/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.system;

import java.nio.ByteBuffer;
import java.util.Iterator;
import java.util.Objects;
import java.util.Spliterator;
import java.util.function.Consumer;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import org.lwjgl.system.Checks;
import org.lwjgl.system.CustomBuffer;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer$StructIterator;
import org.lwjgl.system.StructBuffer$StructSpliterator;

public abstract class StructBuffer
extends CustomBuffer
implements Iterable {
    protected StructBuffer(ByteBuffer byteBuffer, int n2) {
        super(MemoryUtil.memAddress(byteBuffer), byteBuffer, -1, 0, n2, n2);
    }

    protected StructBuffer(long l2, ByteBuffer byteBuffer, int n2, int n3, int n4, int n5) {
        super(l2, byteBuffer, n2, n3, n4, n5);
    }

    @Override
    public int sizeof() {
        return this.getElementFactory().sizeof();
    }

    public Struct get() {
        Struct struct = this.getElementFactory();
        return struct.create(this.address + Integer.toUnsignedLong(this.nextGetIndex()) * (long)struct.sizeof(), this.container);
    }

    public StructBuffer get(Struct struct) {
        int n2 = this.getElementFactory().sizeof();
        MemoryUtil.memCopy(this.address + Integer.toUnsignedLong(this.nextGetIndex()) * (long)n2, struct.address(), n2);
        return (StructBuffer)this.self();
    }

    public StructBuffer put(Struct struct) {
        int n2 = this.getElementFactory().sizeof();
        MemoryUtil.memCopy(struct.address(), this.address + Integer.toUnsignedLong(this.nextPutIndex()) * (long)n2, n2);
        return (StructBuffer)this.self();
    }

    public Struct get(int n2) {
        Struct struct = this.getElementFactory();
        return struct.create(this.address + Integer.toUnsignedLong(StructBuffer.check(n2, this.limit)) * (long)struct.sizeof(), this.container);
    }

    public StructBuffer get(int n2, Struct struct) {
        int n3 = this.getElementFactory().sizeof();
        MemoryUtil.memCopy(this.address + Checks.check(n2, this.limit) * (long)n3, struct.address(), n3);
        return (StructBuffer)this.self();
    }

    public StructBuffer put(int n2, Struct struct) {
        int n3 = this.getElementFactory().sizeof();
        MemoryUtil.memCopy(struct.address(), this.address + Checks.check(n2, this.limit) * (long)n3, n3);
        return (StructBuffer)this.self();
    }

    public StructBuffer apply(Consumer consumer) {
        consumer.accept(this.get());
        return (StructBuffer)this.self();
    }

    public StructBuffer apply(int n2, Consumer consumer) {
        consumer.accept(this.get(n2));
        return (StructBuffer)this.self();
    }

    public Iterator iterator() {
        return new StructBuffer$StructIterator(this.address, this.container, this.getElementFactory(), this.position, this.limit);
    }

    public void forEach(Consumer consumer) {
        Objects.requireNonNull(consumer);
        Struct struct = this.getElementFactory();
        int n2 = this.limit;
        int n3 = struct.sizeof();
        for (int i2 = this.position; i2 < n2; ++i2) {
            consumer.accept(struct.create(this.address + Integer.toUnsignedLong(i2) * (long)this.sizeof(), this.container));
        }
    }

    public Spliterator spliterator() {
        return new StructBuffer$StructSpliterator(this.address, this.container, this.getElementFactory(), this.position, this.limit);
    }

    public Stream stream() {
        return StreamSupport.stream(this.spliterator(), false);
    }

    public Stream parallelStream() {
        return StreamSupport.stream(this.spliterator(), true);
    }

    protected abstract Struct getElementFactory();

    private static int check(int n2, int n3) {
        if (Checks.CHECKS && (n2 < 0 || n3 <= n2)) {
            throw new IndexOutOfBoundsException();
        }
        return n2;
    }
}

