/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.system.jni;

import java.nio.ByteBuffer;
import org.lwjgl.BufferUtils;
import org.lwjgl.system.Checks;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.Struct;
import org.lwjgl.system.Struct$Layout;
import org.lwjgl.system.jni.JNINativeMethod$Buffer;

public class JNINativeMethod
extends Struct
implements NativeResource {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int NAME;
    public static final int SIGNATURE;
    public static final int FNPTR;

    protected JNINativeMethod(long l2, ByteBuffer byteBuffer) {
        super(l2, byteBuffer);
    }

    @Override
    protected JNINativeMethod create(long l2, ByteBuffer byteBuffer) {
        return new JNINativeMethod(l2, byteBuffer);
    }

    public JNINativeMethod(ByteBuffer byteBuffer) {
        super(MemoryUtil.memAddress(byteBuffer), JNINativeMethod.__checkContainer(byteBuffer, SIZEOF));
    }

    @Override
    public int sizeof() {
        return SIZEOF;
    }

    public ByteBuffer name() {
        return JNINativeMethod.nname(this.address());
    }

    public String nameString() {
        return JNINativeMethod.nnameString(this.address());
    }

    public ByteBuffer signature() {
        return JNINativeMethod.nsignature(this.address());
    }

    public String signatureString() {
        return JNINativeMethod.nsignatureString(this.address());
    }

    public long fnPtr() {
        return JNINativeMethod.nfnPtr(this.address());
    }

    public JNINativeMethod name(ByteBuffer byteBuffer) {
        JNINativeMethod.nname(this.address(), byteBuffer);
        return this;
    }

    public JNINativeMethod signature(ByteBuffer byteBuffer) {
        JNINativeMethod.nsignature(this.address(), byteBuffer);
        return this;
    }

    public JNINativeMethod fnPtr(long l2) {
        JNINativeMethod.nfnPtr(this.address(), l2);
        return this;
    }

    public JNINativeMethod set(ByteBuffer byteBuffer, ByteBuffer byteBuffer2, long l2) {
        this.name(byteBuffer);
        this.signature(byteBuffer2);
        this.fnPtr(l2);
        return this;
    }

    public JNINativeMethod set(JNINativeMethod jNINativeMethod) {
        MemoryUtil.memCopy(jNINativeMethod.address(), this.address(), SIZEOF);
        return this;
    }

    public static JNINativeMethod malloc() {
        return new JNINativeMethod(MemoryUtil.nmemAllocChecked(SIZEOF), null);
    }

    public static JNINativeMethod calloc() {
        return new JNINativeMethod(MemoryUtil.nmemCallocChecked(1L, SIZEOF), null);
    }

    public static JNINativeMethod create() {
        ByteBuffer byteBuffer = BufferUtils.createByteBuffer(SIZEOF);
        return new JNINativeMethod(MemoryUtil.memAddress(byteBuffer), byteBuffer);
    }

    public static JNINativeMethod create(long l2) {
        return new JNINativeMethod(l2, null);
    }

    public static JNINativeMethod createSafe(long l2) {
        return l2 == 0L ? null : new JNINativeMethod(l2, null);
    }

    public static JNINativeMethod$Buffer malloc(int n2) {
        return new JNINativeMethod$Buffer(MemoryUtil.nmemAllocChecked(JNINativeMethod.__checkMalloc(n2, SIZEOF)), n2);
    }

    public static JNINativeMethod$Buffer calloc(int n2) {
        return new JNINativeMethod$Buffer(MemoryUtil.nmemCallocChecked(n2, SIZEOF), n2);
    }

    public static JNINativeMethod$Buffer create(int n2) {
        ByteBuffer byteBuffer = JNINativeMethod.__create(n2, SIZEOF);
        return new JNINativeMethod$Buffer(MemoryUtil.memAddress(byteBuffer), byteBuffer, -1, 0, n2, n2);
    }

    public static JNINativeMethod$Buffer create(long l2, int n2) {
        return new JNINativeMethod$Buffer(l2, n2);
    }

    public static JNINativeMethod$Buffer createSafe(long l2, int n2) {
        return l2 == 0L ? null : new JNINativeMethod$Buffer(l2, n2);
    }

    public static JNINativeMethod mallocStack() {
        return JNINativeMethod.malloc(MemoryStack.stackGet());
    }

    public static JNINativeMethod callocStack() {
        return JNINativeMethod.calloc(MemoryStack.stackGet());
    }

    public static JNINativeMethod mallocStack(MemoryStack memoryStack) {
        return JNINativeMethod.malloc(memoryStack);
    }

    public static JNINativeMethod callocStack(MemoryStack memoryStack) {
        return JNINativeMethod.calloc(memoryStack);
    }

    public static JNINativeMethod$Buffer mallocStack(int n2) {
        return JNINativeMethod.malloc(n2, MemoryStack.stackGet());
    }

    public static JNINativeMethod$Buffer callocStack(int n2) {
        return JNINativeMethod.calloc(n2, MemoryStack.stackGet());
    }

    public static JNINativeMethod$Buffer mallocStack(int n2, MemoryStack memoryStack) {
        return JNINativeMethod.malloc(n2, memoryStack);
    }

    public static JNINativeMethod$Buffer callocStack(int n2, MemoryStack memoryStack) {
        return JNINativeMethod.calloc(n2, memoryStack);
    }

    public static JNINativeMethod malloc(MemoryStack memoryStack) {
        return new JNINativeMethod(memoryStack.nmalloc(ALIGNOF, SIZEOF), null);
    }

    public static JNINativeMethod calloc(MemoryStack memoryStack) {
        return new JNINativeMethod(memoryStack.ncalloc(ALIGNOF, 1, SIZEOF), null);
    }

    public static JNINativeMethod$Buffer malloc(int n2, MemoryStack memoryStack) {
        return new JNINativeMethod$Buffer(memoryStack.nmalloc(ALIGNOF, n2 * SIZEOF), n2);
    }

    public static JNINativeMethod$Buffer calloc(int n2, MemoryStack memoryStack) {
        return new JNINativeMethod$Buffer(memoryStack.ncalloc(ALIGNOF, n2, SIZEOF), n2);
    }

    public static ByteBuffer nname(long l2) {
        return MemoryUtil.memByteBufferNT1(MemoryUtil.memGetAddress(l2 + (long)NAME));
    }

    public static String nnameString(long l2) {
        return MemoryUtil.memUTF8(MemoryUtil.memGetAddress(l2 + (long)NAME));
    }

    public static ByteBuffer nsignature(long l2) {
        return MemoryUtil.memByteBufferNT1(MemoryUtil.memGetAddress(l2 + (long)SIGNATURE));
    }

    public static String nsignatureString(long l2) {
        return MemoryUtil.memUTF8(MemoryUtil.memGetAddress(l2 + (long)SIGNATURE));
    }

    public static long nfnPtr(long l2) {
        return MemoryUtil.memGetAddress(l2 + (long)FNPTR);
    }

    public static void nname(long l2, ByteBuffer byteBuffer) {
        if (Checks.CHECKS) {
            Checks.checkNT1(byteBuffer);
        }
        MemoryUtil.memPutAddress(l2 + (long)NAME, MemoryUtil.memAddress(byteBuffer));
    }

    public static void nsignature(long l2, ByteBuffer byteBuffer) {
        if (Checks.CHECKS) {
            Checks.checkNT1(byteBuffer);
        }
        MemoryUtil.memPutAddress(l2 + (long)SIGNATURE, MemoryUtil.memAddress(byteBuffer));
    }

    public static void nfnPtr(long l2, long l3) {
        MemoryUtil.memPutAddress(l2 + (long)FNPTR, Checks.check(l3));
    }

    public static void validate(long l2) {
        Checks.check(MemoryUtil.memGetAddress(l2 + (long)NAME));
        Checks.check(MemoryUtil.memGetAddress(l2 + (long)SIGNATURE));
        Checks.check(MemoryUtil.memGetAddress(l2 + (long)FNPTR));
    }

    static {
        Struct$Layout struct$Layout = JNINativeMethod.__struct(JNINativeMethod.__member(POINTER_SIZE), JNINativeMethod.__member(POINTER_SIZE), JNINativeMethod.__member(POINTER_SIZE));
        SIZEOF = struct$Layout.getSize();
        ALIGNOF = struct$Layout.getAlignment();
        NAME = struct$Layout.offsetof(0);
        SIGNATURE = struct$Layout.offsetof(1);
        FNPTR = struct$Layout.offsetof(2);
    }
}

