/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.system.windows;

import java.nio.ByteBuffer;
import org.lwjgl.BufferUtils;
import org.lwjgl.system.Checks;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.Struct;
import org.lwjgl.system.Struct$Layout;
import org.lwjgl.system.windows.SECURITY_ATTRIBUTES$Buffer;

public class SECURITY_ATTRIBUTES
extends Struct
implements NativeResource {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int NLENGTH;
    public static final int LPSECURITYDESCRIPTOR;
    public static final int BINHERITHANDLE;

    protected SECURITY_ATTRIBUTES(long l2, ByteBuffer byteBuffer) {
        super(l2, byteBuffer);
    }

    @Override
    protected SECURITY_ATTRIBUTES create(long l2, ByteBuffer byteBuffer) {
        return new SECURITY_ATTRIBUTES(l2, byteBuffer);
    }

    public SECURITY_ATTRIBUTES(ByteBuffer byteBuffer) {
        super(MemoryUtil.memAddress(byteBuffer), SECURITY_ATTRIBUTES.__checkContainer(byteBuffer, SIZEOF));
    }

    @Override
    public int sizeof() {
        return SIZEOF;
    }

    public int nLength() {
        return SECURITY_ATTRIBUTES.nnLength(this.address());
    }

    public long lpSecurityDescriptor() {
        return SECURITY_ATTRIBUTES.nlpSecurityDescriptor(this.address());
    }

    public boolean bInheritHandle() {
        return SECURITY_ATTRIBUTES.nbInheritHandle(this.address()) != 0;
    }

    public SECURITY_ATTRIBUTES nLength(int n2) {
        SECURITY_ATTRIBUTES.nnLength(this.address(), n2);
        return this;
    }

    public SECURITY_ATTRIBUTES lpSecurityDescriptor(long l2) {
        SECURITY_ATTRIBUTES.nlpSecurityDescriptor(this.address(), l2);
        return this;
    }

    public SECURITY_ATTRIBUTES bInheritHandle(boolean bl2) {
        SECURITY_ATTRIBUTES.nbInheritHandle(this.address(), bl2 ? 1 : 0);
        return this;
    }

    public SECURITY_ATTRIBUTES set(int n2, long l2, boolean bl2) {
        this.nLength(n2);
        this.lpSecurityDescriptor(l2);
        this.bInheritHandle(bl2);
        return this;
    }

    public SECURITY_ATTRIBUTES set(SECURITY_ATTRIBUTES sECURITY_ATTRIBUTES) {
        MemoryUtil.memCopy(sECURITY_ATTRIBUTES.address(), this.address(), SIZEOF);
        return this;
    }

    public static SECURITY_ATTRIBUTES malloc() {
        return new SECURITY_ATTRIBUTES(MemoryUtil.nmemAllocChecked(SIZEOF), null);
    }

    public static SECURITY_ATTRIBUTES calloc() {
        return new SECURITY_ATTRIBUTES(MemoryUtil.nmemCallocChecked(1L, SIZEOF), null);
    }

    public static SECURITY_ATTRIBUTES create() {
        ByteBuffer byteBuffer = BufferUtils.createByteBuffer(SIZEOF);
        return new SECURITY_ATTRIBUTES(MemoryUtil.memAddress(byteBuffer), byteBuffer);
    }

    public static SECURITY_ATTRIBUTES create(long l2) {
        return new SECURITY_ATTRIBUTES(l2, null);
    }

    public static SECURITY_ATTRIBUTES createSafe(long l2) {
        return l2 == 0L ? null : new SECURITY_ATTRIBUTES(l2, null);
    }

    public static SECURITY_ATTRIBUTES$Buffer malloc(int n2) {
        return new SECURITY_ATTRIBUTES$Buffer(MemoryUtil.nmemAllocChecked(SECURITY_ATTRIBUTES.__checkMalloc(n2, SIZEOF)), n2);
    }

    public static SECURITY_ATTRIBUTES$Buffer calloc(int n2) {
        return new SECURITY_ATTRIBUTES$Buffer(MemoryUtil.nmemCallocChecked(n2, SIZEOF), n2);
    }

    public static SECURITY_ATTRIBUTES$Buffer create(int n2) {
        ByteBuffer byteBuffer = SECURITY_ATTRIBUTES.__create(n2, SIZEOF);
        return new SECURITY_ATTRIBUTES$Buffer(MemoryUtil.memAddress(byteBuffer), byteBuffer, -1, 0, n2, n2);
    }

    public static SECURITY_ATTRIBUTES$Buffer create(long l2, int n2) {
        return new SECURITY_ATTRIBUTES$Buffer(l2, n2);
    }

    public static SECURITY_ATTRIBUTES$Buffer createSafe(long l2, int n2) {
        return l2 == 0L ? null : new SECURITY_ATTRIBUTES$Buffer(l2, n2);
    }

    public static SECURITY_ATTRIBUTES mallocStack() {
        return SECURITY_ATTRIBUTES.malloc(MemoryStack.stackGet());
    }

    public static SECURITY_ATTRIBUTES callocStack() {
        return SECURITY_ATTRIBUTES.calloc(MemoryStack.stackGet());
    }

    public static SECURITY_ATTRIBUTES mallocStack(MemoryStack memoryStack) {
        return SECURITY_ATTRIBUTES.malloc(memoryStack);
    }

    public static SECURITY_ATTRIBUTES callocStack(MemoryStack memoryStack) {
        return SECURITY_ATTRIBUTES.calloc(memoryStack);
    }

    public static SECURITY_ATTRIBUTES$Buffer mallocStack(int n2) {
        return SECURITY_ATTRIBUTES.malloc(n2, MemoryStack.stackGet());
    }

    public static SECURITY_ATTRIBUTES$Buffer callocStack(int n2) {
        return SECURITY_ATTRIBUTES.calloc(n2, MemoryStack.stackGet());
    }

    public static SECURITY_ATTRIBUTES$Buffer mallocStack(int n2, MemoryStack memoryStack) {
        return SECURITY_ATTRIBUTES.malloc(n2, memoryStack);
    }

    public static SECURITY_ATTRIBUTES$Buffer callocStack(int n2, MemoryStack memoryStack) {
        return SECURITY_ATTRIBUTES.calloc(n2, memoryStack);
    }

    public static SECURITY_ATTRIBUTES malloc(MemoryStack memoryStack) {
        return new SECURITY_ATTRIBUTES(memoryStack.nmalloc(ALIGNOF, SIZEOF), null);
    }

    public static SECURITY_ATTRIBUTES calloc(MemoryStack memoryStack) {
        return new SECURITY_ATTRIBUTES(memoryStack.ncalloc(ALIGNOF, 1, SIZEOF), null);
    }

    public static SECURITY_ATTRIBUTES$Buffer malloc(int n2, MemoryStack memoryStack) {
        return new SECURITY_ATTRIBUTES$Buffer(memoryStack.nmalloc(ALIGNOF, n2 * SIZEOF), n2);
    }

    public static SECURITY_ATTRIBUTES$Buffer calloc(int n2, MemoryStack memoryStack) {
        return new SECURITY_ATTRIBUTES$Buffer(memoryStack.ncalloc(ALIGNOF, n2, SIZEOF), n2);
    }

    public static int nnLength(long l2) {
        return UNSAFE.getInt(null, l2 + (long)NLENGTH);
    }

    public static long nlpSecurityDescriptor(long l2) {
        return MemoryUtil.memGetAddress(l2 + (long)LPSECURITYDESCRIPTOR);
    }

    public static int nbInheritHandle(long l2) {
        return UNSAFE.getInt(null, l2 + (long)BINHERITHANDLE);
    }

    public static void nnLength(long l2, int n2) {
        UNSAFE.putInt(null, l2 + (long)NLENGTH, n2);
    }

    public static void nlpSecurityDescriptor(long l2, long l3) {
        MemoryUtil.memPutAddress(l2 + (long)LPSECURITYDESCRIPTOR, Checks.check(l3));
    }

    public static void nbInheritHandle(long l2, int n2) {
        UNSAFE.putInt(null, l2 + (long)BINHERITHANDLE, n2);
    }

    public static void validate(long l2) {
        Checks.check(MemoryUtil.memGetAddress(l2 + (long)LPSECURITYDESCRIPTOR));
    }

    static {
        Struct$Layout struct$Layout = SECURITY_ATTRIBUTES.__struct(SECURITY_ATTRIBUTES.__member(4), SECURITY_ATTRIBUTES.__member(POINTER_SIZE), SECURITY_ATTRIBUTES.__member(4));
        SIZEOF = struct$Layout.getSize();
        ALIGNOF = struct$Layout.getAlignment();
        NLENGTH = struct$Layout.offsetof(0);
        LPSECURITYDESCRIPTOR = struct$Layout.offsetof(1);
        BINHERITHANDLE = struct$Layout.offsetof(2);
    }
}

