/*
 * Decompiled with CFR 0.152.
 */
package ru.woesss.j2me.micro3d;

import emulator.custom.CustomJarResources;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.FloatBuffer;
import java.util.Arrays;
import java.util.Stack;
import ru.woesss.j2me.micro3d.ActTableImpl;
import ru.woesss.j2me.micro3d.Action;
import ru.woesss.j2me.micro3d.Action$Bone;
import ru.woesss.j2me.micro3d.BufferUtils;
import ru.woesss.j2me.micro3d.Loader;
import ru.woesss.j2me.micro3d.Model;
import ru.woesss.j2me.micro3d.Model$Polygon;
import ru.woesss.j2me.micro3d.SparseIntArray;
import ru.woesss.j2me.micro3d.Utils;

public class FigureImpl {
    final Stack stack = new Stack();
    Model model;
    private int pattern;

    public FigureImpl(byte[] byArray) {
        if (byArray == null) {
            throw new NullPointerException();
        }
        try {
            this.init(byArray, 0, byArray.length);
        }
        catch (Exception exception) {
            System.err.println("Error loading data");
            exception.printStackTrace();
            throw new RuntimeException(exception);
        }
    }

    public FigureImpl(byte[] byArray, int n2, int n3) {
        if (byArray == null) {
            throw new NullPointerException();
        }
        if (n2 < 0 || n2 + n3 > byArray.length) {
            throw new ArrayIndexOutOfBoundsException();
        }
        try {
            this.init(byArray, n2, n3);
        }
        catch (Exception exception) {
            System.err.println("Error loading data");
            exception.printStackTrace();
            throw exception;
        }
    }

    public FigureImpl(String string) {
        byte[] byArray = CustomJarResources.getBytes(string);
        if (byArray == null) {
            throw new IOException("Error reading resource: " + string);
        }
        try {
            this.init(byArray, 0, byArray.length);
        }
        catch (Exception exception) {
            System.err.println("Error loading data from [" + string + "]");
            exception.printStackTrace();
            throw new RuntimeException(exception);
        }
    }

    private synchronized void init(byte[] byArray, int n2, int n3) {
        this.model = Loader.loadMbacData(byArray, n2, n3);
        Utils.transform(this.model.originalVertices, this.model.vertices, this.model.originalNormals, this.model.normals, this.model.bones, null);
        this.sortPolygons();
        this.fillTexCoordBuffer();
    }

    private void sortPolygons() {
        Model$Polygon[] model$PolygonArray = this.model.polygonsT;
        Arrays.sort(model$PolygonArray, (model$Polygon, model$Polygon2) -> {
            if (model$Polygon.blendMode != model$Polygon2.blendMode) {
                return model$Polygon.blendMode - model$Polygon2.blendMode;
            }
            if (model$Polygon.face != model$Polygon2.face) {
                return model$Polygon.face - model$Polygon2.face;
            }
            return model$Polygon.doubleFace - model$Polygon2.doubleFace;
        });
        int[][][] nArray = this.model.subMeshesLengthsT;
        int[] nArray2 = this.model.indices;
        int n2 = 0;
        for (Model$Polygon model$Polygon3 : model$PolygonArray) {
            int[] nArray3 = model$Polygon3.indices;
            int n3 = nArray3.length;
            int[] nArray4 = nArray[model$Polygon3.blendMode >> 1][model$Polygon3.face];
            int n4 = model$Polygon3.doubleFace;
            nArray4[n4] = nArray4[n4] + n3;
            System.arraycopy(nArray3, 0, nArray2, n2, n3);
            n2 += n3;
        }
        Model$Polygon[] model$PolygonArray2 = this.model.polygonsC;
        Arrays.sort(model$PolygonArray2, (model$Polygon, model$Polygon2) -> {
            if (model$Polygon.blendMode != model$Polygon2.blendMode) {
                return model$Polygon.blendMode - model$Polygon2.blendMode;
            }
            return model$Polygon.doubleFace - model$Polygon2.doubleFace;
        });
        int[][] nArray5 = this.model.subMeshesLengthsC;
        for (Model$Polygon model$Polygon4 : model$PolygonArray2) {
            int[] nArray6 = model$Polygon4.indices;
            int n5 = nArray6.length;
            int[] nArray7 = nArray5[model$Polygon4.blendMode >> 1];
            int n6 = model$Polygon4.doubleFace;
            nArray7[n6] = nArray7[n6] + n5;
            System.arraycopy(nArray6, 0, nArray2, n2, n5);
            n2 += n5;
        }
    }

    private void fillTexCoordBuffer() {
        ByteBuffer byteBuffer = this.model.texCoordArray;
        byteBuffer.rewind();
        for (Model$Polygon model$Polygon : this.model.polygonsT) {
            byteBuffer.put(model$Polygon.texCoords);
            model$Polygon.texCoords = null;
        }
        for (Model$Polygon model$Polygon : this.model.polygonsC) {
            byteBuffer.put(model$Polygon.texCoords);
            model$Polygon.texCoords = null;
        }
        byteBuffer.rewind();
    }

    public final void dispose() {
        this.model = null;
    }

    public final synchronized void setPosture(ActTableImpl actTableImpl, int n2, int n3) {
        if (n2 < 0 || n2 >= actTableImpl.getNumActions()) {
            throw new IllegalArgumentException();
        }
        Action action = actTableImpl.actions[n2];
        SparseIntArray sparseIntArray = action.dynamic;
        if (sparseIntArray != null) {
            int n4 = n3 < 0 ? 0 : n3 >> 16;
            for (int i2 = sparseIntArray.size() - 1; i2 >= 0; --i2) {
                if (sparseIntArray.keyAt(i2) > n4) continue;
                this.pattern = sparseIntArray.valueAt(i2);
                this.applyPattern();
                break;
            }
        }
        this.applyBoneAction(action, n3 < 0 ? 0 : n3);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void applyBoneAction(Action action, int n2) {
        Action$Bone[] action$BoneArray = action.boneActions;
        if (action$BoneArray.length == 0) {
            return;
        }
        float[] fArray = action.matrices;
        synchronized (action.matrices) {
            for (Action$Bone action$Bone : action$BoneArray) {
                action$Bone.setFrame(n2);
            }
            Utils.transform(this.model.originalVertices, this.model.vertices, this.model.originalNormals, this.model.normals, this.model.bones, action.matrices);
            // ** MonitorExit[var4_4] (shouldn't be in output)
            return;
        }
    }

    private void applyPattern() {
        int n2;
        int n3;
        int n4;
        int[] nArray;
        int[] nArray2 = this.model.indices;
        int n5 = 0;
        int n6 = this.model.vertices.capacity() / 3 - 1;
        for (Model$Polygon model$Polygon : this.model.polygonsT) {
            nArray = model$Polygon.indices;
            n4 = model$Polygon.pattern;
            if ((n4 & this.pattern) == n4) {
                for (n3 = 0; n3 < n2; ++n3) {
                    nArray2[n5++] = nArray[n3];
                }
                continue;
            }
            for (n2 = nArray.length; n2 > 0; --n2) {
                nArray2[n5++] = n6;
            }
        }
        for (Model$Polygon model$Polygon : this.model.polygonsC) {
            nArray = model$Polygon.indices;
            n4 = model$Polygon.pattern;
            if ((n4 & this.pattern) == n4) {
                for (n3 = 0; n3 < n2; ++n3) {
                    nArray2[n5++] = nArray[n3];
                }
                continue;
            }
            for (n2 = nArray.length; n2 > 0; --n2) {
                nArray2[n5++] = n6;
            }
        }
    }

    public final int getNumPattern() {
        return this.model.numPatterns;
    }

    public final synchronized void setPattern(int n2) {
        this.pattern = n2;
        this.applyPattern();
    }

    synchronized void prepareBuffers() {
        if (this.model.vertexArray == null) {
            this.model.vertexArray = BufferUtils.createFloatBuffer(this.model.vertexArrayCapacity);
        }
        Utils.fillBuffer(this.model.vertexArray, this.model.vertices, this.model.indices);
        if (this.model.originalNormals == null) {
            return;
        }
        if (this.model.normalsArray == null) {
            this.model.normalsArray = BufferUtils.createFloatBuffer(this.model.vertexArrayCapacity);
        }
        Utils.fillBuffer(this.model.normalsArray, this.model.normals, this.model.indices);
    }

    public synchronized void setPosture(ActTableImpl actTableImpl, int n2, int n3, int n4) {
        if (n2 < 0 || n2 >= actTableImpl.getNumActions()) {
            throw new IllegalArgumentException();
        }
        this.pattern = n4;
        this.applyPattern();
        this.applyBoneAction(actTableImpl.actions[n2], n3 < 0 ? 0 : n3);
    }

    synchronized void fillBuffers(FloatBuffer floatBuffer, FloatBuffer floatBuffer2) {
        Utils.fillBuffer(floatBuffer, this.model.vertices, this.model.indices);
        if (floatBuffer2 != null) {
            Utils.fillBuffer(floatBuffer2, this.model.normals, this.model.indices);
        }
    }
}

