/*
 * Decompiled with CFR 0.152.
 */
package ru.woesss.j2me.micro3d;

import emulator.Settings;
import emulator.debug.Profiler3D;
import emulator.graphics2D.IImage;
import emulator.graphics3D.lwjgl.Emulator3D;
import java.awt.Rectangle;
import java.nio.ByteBuffer;
import java.nio.FloatBuffer;
import java.nio.IntBuffer;
import java.util.LinkedList;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;
import org.lwjgl.opengl.GL11;
import org.lwjgl.opengl.GL20;
import ru.woesss.j2me.micro3d.BufferUtils;
import ru.woesss.j2me.micro3d.FigureImpl;
import ru.woesss.j2me.micro3d.Light;
import ru.woesss.j2me.micro3d.MathUtil;
import ru.woesss.j2me.micro3d.Model;
import ru.woesss.j2me.micro3d.Program;
import ru.woesss.j2me.micro3d.Program$Color;
import ru.woesss.j2me.micro3d.Program$Simple;
import ru.woesss.j2me.micro3d.Program$Sprite;
import ru.woesss.j2me.micro3d.Program$Tex;
import ru.woesss.j2me.micro3d.Render$Environment;
import ru.woesss.j2me.micro3d.Render$InstanceHolder;
import ru.woesss.j2me.micro3d.RenderNode;
import ru.woesss.j2me.micro3d.RenderNode$FigureNode;
import ru.woesss.j2me.micro3d.RenderNode$PrimitiveNode;
import ru.woesss.j2me.micro3d.TextureImpl;
import ru.woesss.j2me.micro3d.Utils;

public class Render {
    private static final FloatBuffer BG_VBO = BufferUtils.createFloatBuffer(16).put(new float[]{-1.0f, -1.0f, 0.0f, 0.0f, 1.0f, -1.0f, 1.0f, 0.0f, -1.0f, 1.0f, 0.0f, 1.0f, 1.0f, 1.0f, 1.0f, 1.0f});
    private static final int PDATA_COLOR_MASK = 3072;
    private static final int PDATA_COLOR_PER_VERTEX = 3072;
    private static final int PDATA_NORMAL_MASK = 768;
    private static final int PDATA_TEXCOORD_MASK = 12288;
    private static final int[] PRIMITIVE_SIZES = new int[]{0, 1, 2, 3, 4, 1};
    final Render$Environment env = new Render$Environment();
    private final IntBuffer bgTextureId = BufferUtils.createIntBuffer(1).put(-1);
    private final float[] MVP_TMP = new float[16];
    private Graphics targetGraphics;
    private final Rectangle gClip = new Rectangle();
    private final Rectangle clip = new Rectangle();
    private boolean backCopied;
    private final LinkedList stack = new LinkedList();
    private int flushStep;
    private final boolean postCopy2D = !Settings.mascotNo2DMixing;
    private final boolean preCopy2D = !Settings.mascotIgnoreBackground;
    private IntBuffer bufHandles;
    private int clearColor;
    private TextureImpl targetTexture;
    private ByteBuffer imageBuffer;
    private Emulator3D emulator3d;
    private boolean wasBinded;

    static void checkGlError(String string) {
        int n2 = GL20.glGetError();
        if (n2 != 0) {
            System.err.println(string + ": glError " + n2);
            throw new RuntimeException(string + ": glError " + n2);
        }
    }

    public static Render getRender() {
        return Render$InstanceHolder.instance;
    }

    private void init() {
        this.emulator3d = Emulator3D.getInstance();
        this.emulator3d.setFlipImage(true);
    }

    public synchronized void bind(Graphics graphics) {
        boolean bl2;
        ++Profiler3D.MC3D_bindGraphicsCallCount;
        this.targetGraphics = graphics;
        IImage iImage = graphics.getImage();
        int n2 = iImage.getWidth();
        int n3 = iImage.getHeight();
        if (this.emulator3d == null) {
            this.init();
        }
        if (this.env.width != n2 || this.env.height != n3) {
            try {
                if (this.wasBinded) {
                    this.emulator3d.releaseTarget();
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            this.emulator3d.bindTarget(graphics);
            this.wasBinded = true;
            GL20.glViewport(0, 0, n2, n3);
            Program.create();
            this.env.width = n2;
            this.env.height = n3;
            GL20.glClearColor(0.0f, 0.0f, 0.0f, 1.0f);
            GL20.glClear(16384);
        } else {
            this.emulator3d.bindTarget(graphics);
            GL20.glViewport(0, 0, n2, n3);
        }
        Rectangle rectangle = this.clip;
        rectangle.setBounds(graphics.getClipX(), graphics.getClipY(), graphics.getClipWidth(), graphics.getClipHeight());
        int n4 = rectangle.x;
        int n5 = rectangle.y;
        int n6 = rectangle.width;
        int n7 = rectangle.height;
        this.gClip.setBounds(n4, n5, n6, n7);
        if (n4 == 0 && n5 == 0 && n6 == this.env.width && n7 == this.env.height) {
            GL20.glDisable(3089);
        } else {
            GL20.glEnable(3089);
            GL20.glScissor(n4, n5, n6, n7);
        }
        GL20.glClear(256);
        boolean bl3 = bl2 = Settings.m3gAA == 2;
        if (bl2) {
            GL11.glEnable(2832);
            GL11.glEnable(2848);
            GL11.glEnable(2881);
            if (!Emulator3D.useGL11()) {
                GL11.glEnable(32925);
            }
        } else {
            GL11.glDisable(2832);
            GL11.glDisable(2848);
            GL11.glDisable(2881);
            if (!Emulator3D.useGL11()) {
                GL11.glDisable(32925);
            }
        }
        this.backCopied = false;
    }

    public synchronized void bind(TextureImpl textureImpl) {
        ++Profiler3D.MC3D_bindTextureCallCount;
        this.targetTexture = textureImpl;
        int n2 = textureImpl.getWidth();
        int n3 = textureImpl.getHeight();
        if (this.emulator3d == null) {
            this.init();
        }
        if (this.env.width != n2 || this.env.height != n3) {
            if (this.wasBinded) {
                this.emulator3d.releaseTarget();
            }
            this.emulator3d.bindTarget(Image.createImage(n2, n3, 0).getGraphics());
            GL20.glViewport(0, 0, n2, n3);
            Program.create();
            this.env.width = n2;
            this.env.height = n3;
        } else {
            this.emulator3d.bindTarget(Image.createImage(n2, n3, 0).getGraphics());
            GL20.glViewport(0, 0, n2, n3);
        }
        Rectangle rectangle = this.clip;
        rectangle.setBounds(0, 0, n2, n3);
        int n4 = rectangle.x;
        int n5 = rectangle.y;
        int n6 = rectangle.width;
        int n7 = rectangle.height;
        this.gClip.setBounds(n4, n5, n6, n7);
        if (n4 == 0 && n5 == 0 && n6 == this.env.width && n7 == this.env.height) {
            GL20.glDisable(3089);
        } else {
            GL20.glEnable(3089);
            GL20.glScissor(n4, n5, n6, n7);
        }
        GL20.glClearColor((float)(this.clearColor >> 16 & 0xFF) / 255.0f, (float)(this.clearColor >> 8 & 0xFF) / 255.0f, (float)(this.clearColor & 0xFF) / 255.0f, 1.0f);
        GL20.glClear(16640);
        this.backCopied = false;
    }

    private static void applyBlending(int n2) {
        switch (n2) {
            case 2: {
                GL20.glEnable(3042);
                GL20.glBlendColor(0.5f, 0.5f, 0.5f, 1.0f);
                GL20.glBlendEquation(32774);
                GL20.glBlendFunc(32769, 32769);
                break;
            }
            case 4: {
                GL20.glEnable(3042);
                GL20.glBlendEquation(32774);
                GL20.glBlendFunc(1, 1);
                break;
            }
            case 6: {
                GL20.glEnable(3042);
                GL20.glBlendEquation(32779);
                GL20.glBlendFuncSeparate(1, 1, 0, 1);
                break;
            }
            default: {
                GL20.glDisable(3042);
            }
        }
    }

    private void copy2d(boolean bl2) {
        if (this.targetTexture != null) {
            return;
        }
        ++Profiler3D.MC3D_copy2dCount;
        if (!GL20.glIsTexture(this.bgTextureId.get(0))) {
            this.bgTextureId.rewind();
            GL20.glGenTextures(this.bgTextureId);
            GL20.glActiveTexture(33985);
            GL20.glBindTexture(3553, this.bgTextureId.get(0));
            boolean bl3 = Settings.mascotBackgroundFilter;
            GL20.glTexParameteri(3553, 10241, bl3 ? 9729 : 9728);
            GL20.glTexParameteri(3553, 10240, bl3 ? 9729 : 9728);
            GL20.glTexParameteri(3553, 10242, 33071);
            GL20.glTexParameteri(3553, 10243, 33071);
        } else {
            GL20.glActiveTexture(33985);
            GL20.glBindTexture(3553, this.bgTextureId.get(0));
        }
        IImage iImage = this.targetGraphics.getImage();
        int n2 = iImage.isTransparent() ? 6408 : 6407;
        GL11.glTexImage2D(3553, 0, n2, iImage.getWidth(), iImage.getHeight(), 0, n2, 5121, this.getImageBuffer(Render.convert(iImage.getData(), iImage.isTransparent())));
        Render.checkGlError("texImage2D");
        Program$Simple program$Simple = Program.simple;
        program$Simple.use();
        BG_VBO.rewind();
        GL20.glVertexAttribPointer(program$Simple.aPosition, 2, 5126, false, 16, BG_VBO);
        GL20.glEnableVertexAttribArray(program$Simple.aPosition);
        BG_VBO.position(2);
        GL20.glVertexAttribPointer(program$Simple.aTexture, 2, 5126, false, 16, BG_VBO);
        GL20.glEnableVertexAttribArray(program$Simple.aTexture);
        if (bl2) {
            GL20.glDisable(3042);
        } else {
            GL20.glEnable(3042);
            GL20.glBlendEquation(32774);
            GL20.glBlendFunc(770, 771);
        }
        GL20.glDisable(2929);
        GL20.glDepthMask(false);
        GL20.glDrawArrays(5, 0, 4);
        GL20.glDisableVertexAttribArray(program$Simple.aPosition);
        GL20.glDisableVertexAttribArray(program$Simple.aTexture);
        Render.checkGlError("copy2d");
        if (!bl2) {
            return;
        }
        if (this.postCopy2D) {
            this.targetGraphics.setColor(0);
            this.targetGraphics.fillRect(this.gClip.x, this.gClip.y, this.gClip.width, this.gClip.height);
        }
        this.backCopied = true;
    }

    public ByteBuffer getImageBuffer(byte[] byArray) {
        if (this.imageBuffer == null || this.imageBuffer.capacity() < byArray.length) {
            this.imageBuffer = org.lwjgl.BufferUtils.createByteBuffer(byArray.length * 4 / 3);
        }
        this.imageBuffer.position(this.imageBuffer.capacity() - byArray.length);
        this.imageBuffer.put(byArray);
        this.imageBuffer.position(this.imageBuffer.capacity() - byArray.length);
        return this.imageBuffer;
    }

    private static byte[] convert(int[] nArray, boolean bl2) {
        int n2 = nArray.length;
        if (!bl2) {
            byte[] byArray = new byte[n2 * 3];
            for (int i2 = n2 - 1; i2 >= 0; --i2) {
                byArray[i2 * 3] = (byte)(nArray[i2] >> 16 & 0xFF);
                byArray[i2 * 3 + 1] = (byte)(nArray[i2] >> 8 & 0xFF);
                byArray[i2 * 3 + 2] = (byte)(nArray[i2] & 0xFF);
            }
            return byArray;
        }
        byte[] byArray = new byte[n2 * 4];
        for (int i3 = n2 - 1; i3 >= 0; --i3) {
            byArray[i3 * 4] = (byte)(nArray[i3] >> 16 & 0xFF);
            byArray[i3 * 4 + 1] = (byte)(nArray[i3] >> 8 & 0xFF);
            byArray[i3 * 4 + 2] = (byte)(nArray[i3] & 0xFF);
            byArray[i3 * 4 + 3] = (byte)(nArray[i3] >> 24 & 0xFF);
        }
        return byArray;
    }

    protected void finalize() {
        try {
            this.emulator3d.releaseTarget();
        }
        finally {
            super.finalize();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void renderFigure(Model model, TextureImpl[] textureImplArray, int n2, float[] fArray, float[] fArray2, FloatBuffer floatBuffer, FloatBuffer floatBuffer2, Light light, TextureImpl textureImpl, int n3, int n4, int n5) {
        boolean bl2;
        ++Profiler3D.MC3D_renderFigureCallCount;
        boolean bl3 = bl2 = (n2 & 8) != 0;
        if (!bl2 && this.flushStep == 2) {
            return;
        }
        if (!model.hasPolyT && !model.hasPolyC) {
            return;
        }
        GL20.glEnable(2929);
        GL20.glDepthMask(this.flushStep == 1);
        MathUtil.multiplyMM(this.MVP_TMP, fArray, fArray2);
        if (this.bufHandles == null) {
            this.bufHandles = BufferUtils.createIntBuffer(3);
            GL20.glGenBuffers(this.bufHandles);
        }
        try {
            Program program;
            boolean bl4;
            GL20.glBindBuffer(34962, this.bufHandles.get(0));
            GL20.glBufferData(34962, (FloatBuffer)floatBuffer.rewind(), 35040);
            ByteBuffer byteBuffer = model.texCoordArray;
            GL20.glBindBuffer(34962, this.bufHandles.get(1));
            GL20.glBufferData(34962, (ByteBuffer)byteBuffer.rewind(), 35040);
            boolean bl5 = bl4 = (n2 & 1) != 0 && floatBuffer2 != null;
            if (bl4) {
                GL20.glBindBuffer(34962, this.bufHandles.get(2));
                GL20.glBufferData(34962, (FloatBuffer)floatBuffer2.rewind(), 35040);
            }
            if (model.hasPolyT) {
                program = Program.tex;
                program.use();
                GL20.glBindBuffer(34962, this.bufHandles.get(0));
                GL20.glEnableVertexAttribArray(((Program$Tex)program).aPosition);
                GL20.glVertexAttribPointer(((Program$Tex)program).aPosition, 3, 5126, false, 12, 0L);
                GL20.glBindBuffer(34962, this.bufHandles.get(1));
                GL20.glEnableVertexAttribArray(((Program$Tex)program).aColorData);
                GL20.glVertexAttribPointer(((Program$Tex)program).aColorData, 2, 5121, false, 5, 0L);
                GL20.glEnableVertexAttribArray(((Program$Tex)program).aMaterial);
                GL20.glVertexAttribPointer(((Program$Tex)program).aMaterial, 3, 5121, false, 5, 2L);
                if (bl4) {
                    GL20.glBindBuffer(34962, this.bufHandles.get(2));
                    GL20.glEnableVertexAttribArray(((Program$Tex)program).aNormal);
                    GL20.glVertexAttribPointer(((Program$Tex)program).aNormal, 3, 5126, false, 12, 0L);
                    ((Program$Tex)program).setToonShading(n2, n3, n4, n5);
                    program.setLight(light);
                    ((Program$Tex)program).setSphere((n2 & 2) == 0 ? null : textureImpl);
                } else {
                    GL20.glDisableVertexAttribArray(((Program$Tex)program).aNormal);
                    program.setLight(null);
                }
                ((Program$Tex)program).bindMatrices(this.MVP_TMP, fArray2);
                this.renderModel(textureImplArray, model, bl2);
                GL20.glDisableVertexAttribArray(((Program$Tex)program).aPosition);
                GL20.glDisableVertexAttribArray(((Program$Tex)program).aColorData);
                GL20.glDisableVertexAttribArray(((Program$Tex)program).aMaterial);
                GL20.glDisableVertexAttribArray(((Program$Tex)program).aNormal);
                GL20.glBindBuffer(34962, 0);
            }
            if (model.hasPolyC) {
                program = Program.color;
                program.use();
                int n6 = model.numVerticesPolyT;
                GL20.glBindBuffer(34962, this.bufHandles.get(0));
                GL20.glEnableVertexAttribArray(((Program$Color)program).aPosition);
                GL20.glVertexAttribPointer(((Program$Color)program).aPosition, 3, 5126, false, 12, 12 * n6);
                GL20.glBindBuffer(34962, this.bufHandles.get(1));
                GL20.glVertexAttribPointer(((Program$Color)program).aColorData, 3, 5121, true, 5, 5 * n6);
                GL20.glEnableVertexAttribArray(((Program$Color)program).aColorData);
                GL20.glEnableVertexAttribArray(((Program$Color)program).aMaterial);
                GL20.glVertexAttribPointer(((Program$Color)program).aMaterial, 2, 5121, false, 5, 5 * n6 + 3);
                if (bl4) {
                    GL20.glBindBuffer(34962, this.bufHandles.get(2));
                    GL20.glVertexAttribPointer(((Program$Color)program).aNormal, 3, 5126, false, 12, 12 * n6);
                    GL20.glEnableVertexAttribArray(((Program$Color)program).aNormal);
                    program.setLight(light);
                    ((Program$Color)program).setSphere((n2 & 2) == 0 ? null : textureImpl);
                    ((Program$Color)program).setToonShading(n2, n3, n4, n5);
                } else {
                    GL20.glDisableVertexAttribArray(((Program$Color)program).aNormal);
                    program.setLight(null);
                }
                ((Program$Color)program).bindMatrices(this.MVP_TMP, fArray2);
                this.renderModel(model, bl2);
                GL20.glDisableVertexAttribArray(((Program$Color)program).aPosition);
                GL20.glDisableVertexAttribArray(((Program$Color)program).aColorData);
                GL20.glDisableVertexAttribArray(((Program$Color)program).aMaterial);
                GL20.glDisableVertexAttribArray(((Program$Color)program).aNormal);
            }
        }
        finally {
            GL20.glBindBuffer(34962, 0);
        }
    }

    private void renderModel(TextureImpl[] textureImplArray, Model model, boolean bl2) {
        Object object;
        Object object2;
        int n2;
        int[][] nArray;
        if (textureImplArray == null || textureImplArray.length == 0) {
            return;
        }
        ++Profiler3D.MC3D_renderModelCallCount;
        Program$Tex program$Tex = Program.tex;
        int[][][] nArray2 = model.subMeshesLengthsT;
        int n3 = nArray2.length;
        int n4 = 0;
        int n5 = 0;
        if (this.flushStep == 1) {
            if (bl2) {
                n3 = 1;
            }
            GL20.glDisable(3042);
        } else {
            nArray = nArray2[n4++];
            n2 = 0;
            object2 = nArray;
            object = ((int[][])object2).length;
            for (int i2 = 0; i2 < object; ++i2) {
                int[] nArray3;
                for (int n6 : nArray3 = object2[i2]) {
                    n2 += n6;
                }
            }
            n5 += n2;
        }
        while (n4 < n3) {
            nArray = nArray2[n4];
            if (this.flushStep == 2) {
                Render.applyBlending(n4 << 1);
            }
            for (n2 = 0; n2 < nArray.length; ++n2) {
                object2 = nArray[n2];
                if (n2 >= textureImplArray.length) {
                    program$Tex.setTex(null);
                } else {
                    TextureImpl textureImpl = textureImplArray[n2];
                    program$Tex.setTex(textureImpl);
                }
                object = object2[0];
                if (object > 0) {
                    GL20.glEnable(2884);
                    GL20.glDrawArrays(4, n5, object);
                    n5 += object;
                }
                if ((object = (Object)object2[1]) <= 0) continue;
                GL20.glDisable(2884);
                GL20.glDrawArrays(4, n5, object);
                n5 += object;
            }
            ++n4;
        }
        Render.checkGlError("glDrawArrays");
    }

    private void renderModel(Model model, boolean bl2) {
        int n2;
        int[] nArray;
        ++Profiler3D.MC3D_renderModelCallCount;
        int[][] nArray2 = model.subMeshesLengthsC;
        int n3 = nArray2.length;
        int n4 = 0;
        int n5 = 0;
        if (this.flushStep == 1) {
            if (bl2) {
                n3 = 1;
            }
            GL20.glDisable(3042);
        } else {
            nArray = nArray2[n5++];
            n2 = 0;
            for (int n6 : nArray) {
                n2 += n6;
            }
            n4 += n2;
        }
        while (n5 < n3) {
            nArray = nArray2[n5];
            if (this.flushStep == 2) {
                Render.applyBlending(n5 << 1);
            }
            if ((n2 = nArray[0]) > 0) {
                GL20.glEnable(2884);
                GL20.glDrawArrays(4, n4, n2);
                n4 += n2;
            }
            if ((n2 = nArray[1]) > 0) {
                GL20.glDisable(2884);
                GL20.glDrawArrays(4, n4, n2);
                n4 += n2;
            }
            ++n5;
        }
        Render.checkGlError("glDrawArrays");
    }

    public synchronized void release() {
        ++Profiler3D.MC3D_releaseCallCount;
        this.stack.clear();
        if (this.targetTexture != null) {
            GL20.glReadPixels(0, 0, 256, 256, 6408, 5121, this.targetTexture.image.getRaster());
            this.targetTexture = null;
        } else if (this.targetGraphics != null) {
            if (this.postCopy2D) {
                this.copy2d(false);
            }
            this.swapBuffers();
            this.targetGraphics = null;
        }
        this.emulator3d.releaseTarget();
    }

    public synchronized void flush() {
        ++Profiler3D.MC3D_flushCallCount;
        if (this.stack.isEmpty()) {
            return;
        }
        try {
            if (!this.backCopied && this.preCopy2D) {
                this.copy2d(true);
            }
            this.flushStep = 1;
            for (RenderNode renderNode : this.stack) {
                renderNode.render(this);
            }
            this.flushStep = 2;
            for (RenderNode renderNode : this.stack) {
                renderNode.render(this);
                renderNode.recycle();
            }
            GL20.glDisable(3042);
            GL20.glDepthMask(true);
            GL20.glClear(256);
            GL20.glFlush();
        }
        finally {
            this.stack.clear();
            this.swapBuffers();
        }
    }

    private void renderMeshC(RenderNode$PrimitiveNode renderNode$PrimitiveNode) {
        int n2 = renderNode$PrimitiveNode.command;
        Program$Color program$Color = Program.color;
        program$Color.use();
        if ((renderNode$PrimitiveNode.attrs & 1) != 0 && (n2 & 1) != 0 && renderNode$PrimitiveNode.normals != null) {
            TextureImpl textureImpl = renderNode$PrimitiveNode.specular;
            if ((renderNode$PrimitiveNode.attrs & 2) != 0 && (n2 & 2) != 0 && textureImpl != null) {
                GL20.glVertexAttrib2f(program$Color.aMaterial, 1.0f, 1.0f);
                program$Color.setSphere(textureImpl);
            } else {
                GL20.glVertexAttrib2f(program$Color.aMaterial, 1.0f, 0.0f);
                program$Color.setSphere(null);
            }
            program$Color.setLight(renderNode$PrimitiveNode.light);
            program$Color.setToonShading(renderNode$PrimitiveNode.attrs, renderNode$PrimitiveNode.toonThreshold, renderNode$PrimitiveNode.toonHigh, renderNode$PrimitiveNode.toonLow);
            GL20.glVertexAttribPointer(program$Color.aNormal, 3, 5126, false, 12, (FloatBuffer)renderNode$PrimitiveNode.normals.rewind());
            GL20.glEnableVertexAttribArray(program$Color.aNormal);
        } else {
            GL20.glVertexAttrib2f(program$Color.aMaterial, 0.0f, 0.0f);
            program$Color.setLight(null);
            GL20.glDisableVertexAttribArray(program$Color.aNormal);
        }
        program$Color.bindMatrices(this.MVP_TMP, renderNode$PrimitiveNode.viewMatrix);
        GL20.glVertexAttribPointer(program$Color.aPosition, 3, 5126, false, 12, (FloatBuffer)renderNode$PrimitiveNode.vertices.rewind());
        GL20.glEnableVertexAttribArray(program$Color.aPosition);
        if ((n2 & 0xC00) == 1024) {
            program$Color.setColor(renderNode$PrimitiveNode.colors);
        } else {
            GL20.glVertexAttribPointer(program$Color.aColorData, 3, 5121, true, 3, (ByteBuffer)renderNode$PrimitiveNode.colors.rewind());
            GL20.glEnableVertexAttribArray(program$Color.aColorData);
        }
        GL20.glDrawArrays(4, 0, renderNode$PrimitiveNode.vertices.capacity() / 3);
        GL20.glDisableVertexAttribArray(program$Color.aPosition);
        GL20.glDisableVertexAttribArray(program$Color.aColorData);
        GL20.glDisableVertexAttribArray(program$Color.aNormal);
        Render.checkGlError("renderMeshC");
    }

    private void renderMeshT(RenderNode$PrimitiveNode renderNode$PrimitiveNode) {
        int n2 = renderNode$PrimitiveNode.command;
        Program$Tex program$Tex = Program.tex;
        program$Tex.use();
        if ((renderNode$PrimitiveNode.attrs & 1) != 0 && (n2 & 1) != 0 && renderNode$PrimitiveNode.normals != null) {
            TextureImpl textureImpl = renderNode$PrimitiveNode.specular;
            if ((renderNode$PrimitiveNode.attrs & 2) != 0 && (n2 & 2) != 0 && textureImpl != null) {
                GL20.glVertexAttrib3f(program$Tex.aMaterial, 1.0f, 1.0f, n2 & 0x10);
                program$Tex.setSphere(textureImpl);
            } else {
                GL20.glVertexAttrib3f(program$Tex.aMaterial, 1.0f, 0.0f, n2 & 0x10);
                program$Tex.setSphere(null);
            }
            program$Tex.setLight(renderNode$PrimitiveNode.light);
            program$Tex.setToonShading(renderNode$PrimitiveNode.attrs, renderNode$PrimitiveNode.toonThreshold, renderNode$PrimitiveNode.toonHigh, renderNode$PrimitiveNode.toonLow);
            GL20.glVertexAttribPointer(program$Tex.aNormal, 3, 5126, false, 12, (FloatBuffer)renderNode$PrimitiveNode.normals.rewind());
            GL20.glEnableVertexAttribArray(program$Tex.aNormal);
        } else {
            GL20.glVertexAttrib3f(program$Tex.aMaterial, 0.0f, 0.0f, n2 & 0x10);
            program$Tex.setLight(null);
            GL20.glDisableVertexAttribArray(program$Tex.aNormal);
        }
        program$Tex.bindMatrices(this.MVP_TMP, renderNode$PrimitiveNode.viewMatrix);
        GL20.glVertexAttribPointer(program$Tex.aPosition, 3, 5126, false, 12, (FloatBuffer)renderNode$PrimitiveNode.vertices.rewind());
        GL20.glEnableVertexAttribArray(program$Tex.aPosition);
        GL20.glVertexAttribPointer(program$Tex.aColorData, 2, 5121, false, 2, (ByteBuffer)renderNode$PrimitiveNode.texCoords.rewind());
        GL20.glEnableVertexAttribArray(program$Tex.aColorData);
        program$Tex.setTex(renderNode$PrimitiveNode.texture);
        GL20.glDrawArrays(4, 0, renderNode$PrimitiveNode.vertices.capacity() / 3);
        GL20.glDisableVertexAttribArray(program$Tex.aPosition);
        GL20.glDisableVertexAttribArray(program$Tex.aColorData);
        GL20.glDisableVertexAttribArray(program$Tex.aNormal);
        Render.checkGlError("renderMeshT");
    }

    public void drawCommandList(int[] nArray) {
        ++Profiler3D.MC3D_renderCommandListCallCount;
        if (-33554431 != nArray[0]) {
            throw new IllegalArgumentException("Unsupported command list version: " + nArray[0]);
        }
        int n2 = 1;
        block17: while (n2 < nArray.length) {
            int n3 = nArray[n2++];
            switch (n3 & 0xFF000000) {
                case -2030043136: {
                    this.selectAffineTrans(n3 & 0xFFFFFF);
                    continue block17;
                }
                case -1610612736: {
                    this.env.light.ambIntensity = n2++;
                    continue block17;
                }
                case -2097152000: {
                    this.env.attrs = n3 & 0xFFFFFF;
                    continue block17;
                }
                case -2063597568: {
                    this.setCenter(nArray[n2++], nArray[n2++]);
                    continue block17;
                }
                case -2080374784: {
                    Rectangle rectangle = this.clip.intersection(new Rectangle(nArray[n2++], nArray[n2++], nArray[n2++], nArray[n2++]));
                    this.clip.setBounds(rectangle);
                    this.updateClip();
                    continue block17;
                }
                case -1593835520: {
                    this.env.light.x = n2++;
                    this.env.light.y = n2++;
                    this.env.light.z = n2++;
                    this.env.light.dirIntensity = n2++;
                    continue block17;
                }
                case -2113929216: {
                    this.flush();
                    continue block17;
                }
                case -2130706432: {
                    n2 += n3 & 0xFFFFFF;
                    continue block17;
                }
                case -1879048192: {
                    this.setOrthographicScale(nArray[n2++], nArray[n2++]);
                    continue block17;
                }
                case -1862270976: {
                    this.setOrthographicWH(nArray[n2++], nArray[n2++]);
                    continue block17;
                }
                case -1845493760: {
                    this.setPerspectiveFov(nArray[n2++], nArray[n2++], nArray[n2++]);
                    continue block17;
                }
                case -1828716544: {
                    this.setPerspectiveWH(nArray[n2++], nArray[n2++], nArray[n2++], nArray[n2++]);
                    continue block17;
                }
                case -2046820352: {
                    int n4 = n3 & 0xFFFFFF;
                    if (n4 <= 0 || n4 >= 16) continue block17;
                    this.env.textureIdx = n4;
                    continue block17;
                }
                case -1358954496: {
                    this.setToonParam(nArray[n2++], nArray[n2++], nArray[n2++]);
                    continue block17;
                }
                case -2147483648: {
                    return;
                }
            }
            int n5 = n3 & 0x7000000;
            if (n5 == 0 || n3 < 0) {
                throw new IllegalArgumentException();
            }
            int n6 = n3 >> 16 & 0xFF;
            int n7 = PRIMITIVE_SIZES[n5 >> 24];
            int n8 = n6 * 3 * n7;
            int n9 = n2;
            int n10 = n2 += n8;
            if ((n3 & 0x300) == 512) {
                n2 += n6 * 3;
            } else if ((n3 & 0x300) == 768) {
                n2 += n8;
            }
            int n11 = n2;
            if (n5 == 0x5000000) {
                if ((n3 & 0x3000) == 4096) {
                    n2 += 8;
                } else if ((n3 & 0x3000) != 0) {
                    n2 += n6 * 8;
                }
            } else if ((n3 & 0x3000) == 12288) {
                n2 += n6 * 2 * n7;
            }
            int n12 = n2++;
            if ((n3 & 0xC00) != 1024) {
                if ((n3 & 0xC00) == 2048) {
                    n2 += n6;
                } else if ((n3 & 0xC00) == 3072) {
                    n2 += n6 * n7;
                }
            }
            if (n2 > nArray.length) {
                throw new IllegalArgumentException();
            }
            this.postPrimitives(n3, nArray, n9, nArray, n10, nArray, n11, nArray, n12);
        }
    }

    private void updateClip() {
        Rectangle rectangle = this.clip;
        int n2 = rectangle.x;
        int n3 = rectangle.y;
        int n4 = rectangle.width;
        int n5 = rectangle.height;
        if (n2 == 0 && n3 == 0 && n4 == this.env.width && n5 == this.env.height) {
            GL20.glDisable(3089);
        } else {
            GL20.glEnable(3089);
            GL20.glScissor(n2, n3, n4, n5);
        }
        this.swapBuffers();
    }

    public synchronized void postFigure(FigureImpl figureImpl) {
        RenderNode$FigureNode renderNode$FigureNode;
        ++Profiler3D.MC3D_postFigureCallCount;
        if (figureImpl.stack.empty()) {
            renderNode$FigureNode = new RenderNode$FigureNode(this, figureImpl);
        } else {
            renderNode$FigureNode = (RenderNode$FigureNode)figureImpl.stack.pop();
            renderNode$FigureNode.setData(this);
        }
        this.stack.add(renderNode$FigureNode);
    }

    public synchronized void postPrimitives(int n2, int[] nArray, int n3, int[] nArray2, int n4, int[] nArray3, int n5, int[] nArray4, int n6) {
        FloatBuffer floatBuffer;
        ++Profiler3D.MC3D_postPrimitivesCallCount;
        if (n2 < 0) {
            throw new IllegalArgumentException();
        }
        int n7 = n2 >> 16 & 0xFF;
        FloatBuffer floatBuffer2 = null;
        ByteBuffer byteBuffer = null;
        ByteBuffer byteBuffer2 = null;
        switch (n2 & 0x7000000) {
            case 0x1000000: {
                int n8;
                int n9 = n7 * 3;
                floatBuffer = BufferUtils.createFloatBuffer(n9);
                for (n8 = 0; n8 < n9; ++n8) {
                    floatBuffer.put(nArray[n3++]);
                }
                if ((n2 & 0xC00) == 1024) {
                    byteBuffer2 = BufferUtils.createByteBuffer(3);
                    n8 = nArray4[n6];
                    byteBuffer2.put((byte)(n8 >> 16 & 0xFF));
                    byteBuffer2.put((byte)(n8 >> 8 & 0xFF));
                    byteBuffer2.put((byte)(n8 & 0xFF));
                    break;
                }
                if ((n2 & 0xC00) != 0) {
                    byteBuffer2 = BufferUtils.createByteBuffer(n9);
                    for (n8 = 0; n8 < n7; ++n8) {
                        int n10 = nArray4[n6++];
                        byteBuffer2.put((byte)(n10 >> 16 & 0xFF));
                        byteBuffer2.put((byte)(n10 >> 8 & 0xFF));
                        byteBuffer2.put((byte)(n10 & 0xFF));
                    }
                    break;
                }
                return;
            }
            case 0x2000000: {
                int n11;
                int n12 = n7 * 2 * 3;
                floatBuffer = BufferUtils.createFloatBuffer(n12);
                for (n11 = 0; n11 < n12; ++n11) {
                    floatBuffer.put(nArray[n3++]);
                }
                if ((n2 & 0xC00) == 1024) {
                    byteBuffer2 = BufferUtils.createByteBuffer(3);
                    n11 = nArray4[n6];
                    byteBuffer2.put((byte)(n11 >> 16 & 0xFF));
                    byteBuffer2.put((byte)(n11 >> 8 & 0xFF));
                    byteBuffer2.put((byte)(n11 & 0xFF));
                    break;
                }
                if ((n2 & 0xC00) != 0) {
                    byteBuffer2 = BufferUtils.createByteBuffer(n12);
                    for (n11 = 0; n11 < n7; ++n11) {
                        int n13 = nArray4[n6++];
                        byte by2 = (byte)(n13 >> 16 & 0xFF);
                        byte by3 = (byte)(n13 >> 8 & 0xFF);
                        byte by4 = (byte)(n13 & 0xFF);
                        byteBuffer2.put(by2).put(by3).put(by4);
                        byteBuffer2.put(by2).put(by3).put(by4);
                    }
                    break;
                }
                return;
            }
            case 0x3000000: {
                int n14;
                int n15 = n7 * 3 * 3;
                floatBuffer = BufferUtils.createFloatBuffer(n15);
                for (n14 = 0; n14 < n15; ++n14) {
                    floatBuffer.put(nArray[n3++]);
                }
                if ((n2 & 0x300) == 512) {
                    floatBuffer2 = BufferUtils.createFloatBuffer(n15);
                    n14 = n4 + n7 * 3;
                    while (n4 < n14) {
                        float f2 = nArray2[n4++];
                        float f3 = nArray2[n4++];
                        float f4 = nArray2[n4++];
                        floatBuffer2.put(f2).put(f3).put(f4);
                        floatBuffer2.put(f2).put(f3).put(f4);
                        floatBuffer2.put(f2).put(f3).put(f4);
                    }
                } else if ((n2 & 0x300) == 768) {
                    floatBuffer2 = BufferUtils.createFloatBuffer(n15);
                    n14 = n4 + n15;
                    while (n4 < n14) {
                        floatBuffer2.put(nArray2[n4++]);
                    }
                }
                if ((n2 & 0x3000) == 12288) {
                    if (this.env.getTexture() == null) {
                        return;
                    }
                    n14 = n7 * 3 * 2;
                    byteBuffer = BufferUtils.createByteBuffer(n14);
                    for (int i2 = 0; i2 < n14; ++i2) {
                        byteBuffer.put((byte)nArray3[n5++]);
                    }
                    break;
                }
                if ((n2 & 0xC00) == 1024) {
                    byteBuffer2 = BufferUtils.createByteBuffer(3);
                    n14 = nArray4[n6];
                    byteBuffer2.put((byte)(n14 >> 16 & 0xFF));
                    byteBuffer2.put((byte)(n14 >> 8 & 0xFF));
                    byteBuffer2.put((byte)(n14 & 0xFF));
                    break;
                }
                if ((n2 & 0xC00) != 0) {
                    byteBuffer2 = BufferUtils.createByteBuffer(n15);
                    for (n14 = 0; n14 < n7; ++n14) {
                        int n16 = nArray4[n6++];
                        byte by5 = (byte)(n16 >> 16 & 0xFF);
                        byte by6 = (byte)(n16 >> 8 & 0xFF);
                        byte by7 = (byte)(n16 & 0xFF);
                        byteBuffer2.put(by5).put(by6).put(by7);
                        byteBuffer2.put(by5).put(by6).put(by7);
                        byteBuffer2.put(by5).put(by6).put(by7);
                    }
                    break;
                }
                return;
            }
            case 0x4000000: {
                int n17;
                int n18;
                int n19;
                floatBuffer = BufferUtils.createFloatBuffer(n7 * 6 * 3);
                for (n19 = 0; n19 < n7; ++n19) {
                    n17 = n18 = n3 + n19 * 4 * 3;
                    floatBuffer.put(nArray[n17++]).put(nArray[n17++]).put(nArray[n17++]);
                    floatBuffer.put(nArray[n17++]).put(nArray[n17++]).put(nArray[n17++]);
                    floatBuffer.put(nArray[n17++]).put(nArray[n17++]).put(nArray[n17++]);
                    floatBuffer.put(nArray[n17++]).put(nArray[n17++]).put(nArray[n17]);
                    n17 = n18;
                    floatBuffer.put(nArray[n17++]).put(nArray[n17++]).put(nArray[n17]);
                    n17 = n18 + 6;
                    floatBuffer.put(nArray[n17++]).put(nArray[n17++]).put(nArray[n17]);
                }
                if ((n2 & 0x300) == 512) {
                    floatBuffer2 = BufferUtils.createFloatBuffer(n7 * 6 * 3);
                    n19 = n4 + n7 * 3;
                    while (n4 < n19) {
                        float f5 = nArray2[n4++];
                        float f6 = nArray2[n4++];
                        float f7 = nArray2[n4++];
                        floatBuffer2.put(f5).put(f6).put(f7);
                        floatBuffer2.put(f5).put(f6).put(f7);
                        floatBuffer2.put(f5).put(f6).put(f7);
                        floatBuffer2.put(f5).put(f6).put(f7);
                        floatBuffer2.put(f5).put(f6).put(f7);
                        floatBuffer2.put(f5).put(f6).put(f7);
                    }
                } else if ((n2 & 0x300) == 768) {
                    floatBuffer2 = BufferUtils.createFloatBuffer(n7 * 6 * 3);
                    for (n19 = 0; n19 < n7; ++n19) {
                        n17 = n18 = n4 + n19 * 4 * 3;
                        floatBuffer2.put(nArray2[n17++]).put(nArray2[n17++]).put(nArray2[n17++]);
                        floatBuffer2.put(nArray2[n17++]).put(nArray2[n17++]).put(nArray2[n17++]);
                        floatBuffer2.put(nArray2[n17++]).put(nArray2[n17++]).put(nArray2[n17++]);
                        floatBuffer2.put(nArray2[n17++]).put(nArray2[n17++]).put(nArray2[n17]);
                        n17 = n18;
                        floatBuffer2.put(nArray2[n17++]).put(nArray2[n17++]).put(nArray2[n17]);
                        n17 = n18 + 6;
                        floatBuffer2.put(nArray2[n17++]).put(nArray2[n17++]).put(nArray2[n17]);
                    }
                }
                if ((n2 & 0x3000) == 12288) {
                    if (this.env.getTexture() == null) {
                        return;
                    }
                    byteBuffer = BufferUtils.createByteBuffer(n7 * 6 * 2);
                    for (n19 = 0; n19 < n7; ++n19) {
                        int n20;
                        int n21 = n20 = n5 + n19 * 4 * 2;
                        byteBuffer.put((byte)nArray3[n21++]).put((byte)nArray3[n21++]);
                        byteBuffer.put((byte)nArray3[n21++]).put((byte)nArray3[n21++]);
                        byteBuffer.put((byte)nArray3[n21++]).put((byte)nArray3[n21++]);
                        byteBuffer.put((byte)nArray3[n21++]).put((byte)nArray3[n21]);
                        n21 = n20;
                        byteBuffer.put((byte)nArray3[n21++]).put((byte)nArray3[n21]);
                        n21 = n20 + 4;
                        byteBuffer.put((byte)nArray3[n21++]).put((byte)nArray3[n21]);
                    }
                    break;
                }
                if ((n2 & 0xC00) == 1024) {
                    byteBuffer2 = BufferUtils.createByteBuffer(3);
                    n19 = nArray4[n6];
                    byteBuffer2.put((byte)(n19 >> 16 & 0xFF));
                    byteBuffer2.put((byte)(n19 >> 8 & 0xFF));
                    byteBuffer2.put((byte)(n19 & 0xFF));
                    break;
                }
                if ((n2 & 0xC00) != 0) {
                    byteBuffer2 = BufferUtils.createByteBuffer(n7 * 6 * 3);
                    for (n19 = 0; n19 < n7; ++n19) {
                        int n22 = nArray4[n6++];
                        byte by8 = (byte)(n22 >> 16 & 0xFF);
                        byte by9 = (byte)(n22 >> 8 & 0xFF);
                        byte by10 = (byte)(n22 & 0xFF);
                        byteBuffer2.put(by8).put(by9).put(by10);
                        byteBuffer2.put(by8).put(by9).put(by10);
                        byteBuffer2.put(by8).put(by9).put(by10);
                        byteBuffer2.put(by8).put(by9).put(by10);
                        byteBuffer2.put(by8).put(by9).put(by10);
                        byteBuffer2.put(by8).put(by9).put(by10);
                    }
                    break;
                }
                return;
            }
            case 0x5000000: {
                if (this.env.getTexture() == null) {
                    return;
                }
                int n23 = n2 & 0x3000;
                if (n23 == 0) {
                    return;
                }
                float[] fArray = new float[24];
                floatBuffer = BufferUtils.createFloatBuffer(n7 * 6 * 4);
                byteBuffer = BufferUtils.createByteBuffer(n7 * 6 * 2);
                int n24 = 0;
                float f8 = 0.0f;
                float f9 = 0.0f;
                byte by11 = 0;
                byte by12 = 0;
                byte by13 = 0;
                byte by14 = 0;
                MathUtil.multiplyMM(this.MVP_TMP, this.env.projMatrix, this.env.viewMatrix);
                for (int i3 = 0; i3 < n7; ++i3) {
                    fArray[4] = nArray[n3++];
                    fArray[5] = nArray[n3++];
                    fArray[6] = nArray[n3++];
                    fArray[7] = 1.0f;
                    Utils.multiplyMV(fArray, this.MVP_TMP);
                    if (n23 != 4096 || i3 == 0) {
                        float f10 = nArray3[n5++];
                        float f11 = nArray3[n5++];
                        n24 = nArray3[n5++];
                        by11 = (byte)nArray3[n5++];
                        by12 = (byte)nArray3[n5++];
                        by13 = (byte)(nArray3[n5++] - 1);
                        by14 = (byte)(nArray3[n5++] - 1);
                        switch (nArray3[n5++]) {
                            case 0: {
                                f8 = f10 * this.env.projMatrix[0] * 0.5f;
                                f9 = f11 * this.env.projMatrix[5] * 0.5f;
                                break;
                            }
                            case 1: {
                                if (this.env.projection <= -1862270976) {
                                    f8 = f10 / (float)this.env.width;
                                    f9 = f11 / (float)this.env.height;
                                    break;
                                }
                                f8 = f10 / (float)this.env.width * this.env.near;
                                f9 = f11 / (float)this.env.height * this.env.near;
                                break;
                            }
                            case 2: {
                                if (this.env.projection <= -1862270976) {
                                    f8 = f10 * this.env.projMatrix[0] * 0.5f;
                                    f9 = f11 * this.env.projMatrix[5] * 0.5f;
                                    break;
                                }
                                float f12 = this.env.near;
                                f8 = f10 * this.env.projMatrix[0] / f12 * 0.5f * fArray[3];
                                f9 = f11 * this.env.projMatrix[5] / f12 * 0.5f * fArray[3];
                                break;
                            }
                            case 3: {
                                f8 = f10 / (float)this.env.width * fArray[3];
                                f9 = f11 / (float)this.env.height * fArray[3];
                                break;
                            }
                            default: {
                                throw new IllegalArgumentException();
                            }
                        }
                    }
                    Utils.getSpriteVertex(fArray, n24, f8, f9);
                    floatBuffer.put(fArray);
                    byteBuffer.put(by11).put(by14);
                    byteBuffer.put(by11).put(by12);
                    byteBuffer.put(by13).put(by14);
                    byteBuffer.put(by13).put(by14);
                    byteBuffer.put(by11).put(by12);
                    byteBuffer.put(by13).put(by12);
                }
                break;
            }
            default: {
                throw new IllegalArgumentException();
            }
        }
        this.stack.add(new RenderNode$PrimitiveNode(this, n2, floatBuffer, floatBuffer2, byteBuffer, byteBuffer2));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void drawFigure(FigureImpl figureImpl) {
        ++Profiler3D.MC3D_drawFigureCallCount;
        if (!this.backCopied && this.preCopy2D) {
            this.copy2d(true);
        }
        try {
            Model model = figureImpl.model;
            figureImpl.prepareBuffers();
            this.flushStep = 1;
            for (RenderNode renderNode : this.stack) {
                renderNode.render(this);
            }
            this.renderFigure(model, this.env.textures, this.env.attrs, this.env.projMatrix, this.env.viewMatrix, model.vertexArray, model.normalsArray, this.env.light, this.env.specular, this.env.toonThreshold, this.env.toonHigh, this.env.toonLow);
            this.flushStep = 2;
            for (RenderNode renderNode : this.stack) {
                renderNode.render(this);
                renderNode.recycle();
            }
            this.renderFigure(model, this.env.textures, this.env.attrs, this.env.projMatrix, this.env.viewMatrix, model.vertexArray, model.normalsArray, this.env.light, this.env.specular, this.env.toonThreshold, this.env.toonHigh, this.env.toonLow);
            GL20.glDisable(3042);
            GL20.glDepthMask(true);
            GL20.glClear(256);
        }
        finally {
            this.swapBuffers();
        }
    }

    public void reset() {
        this.stack.clear();
    }

    public void setTexture(TextureImpl textureImpl) {
        if (textureImpl == null) {
            return;
        }
        this.env.textures[0] = textureImpl;
        this.env.textureIdx = 0;
        this.env.texturesLen = 1;
    }

    public void setTextureArray(TextureImpl[] textureImplArray) {
        if (textureImplArray == null) {
            return;
        }
        int n2 = textureImplArray.length;
        System.arraycopy(textureImplArray, 0, this.env.textures, 0, n2);
        this.env.texturesLen = n2;
    }

    public float[] getViewMatrix() {
        return this.env.viewMatrix;
    }

    public void setLight(int n2, int n3, int n4, int n5, int n6) {
        this.env.light.set(n2, n3, n4, n5, n6);
    }

    public int getAttributes() {
        return this.env.attrs;
    }

    public void setToonParam(int n2, int n3, int n4) {
        this.env.toonThreshold = n2;
        this.env.toonHigh = n3;
        this.env.toonLow = n4;
    }

    public void setSphereTexture(TextureImpl textureImpl) {
        if (textureImpl != null) {
            this.env.specular = textureImpl;
        }
    }

    public void setAttribute(int n2) {
        this.env.attrs = n2;
    }

    void renderPrimitive(RenderNode$PrimitiveNode renderNode$PrimitiveNode) {
        int n2;
        int n3 = renderNode$PrimitiveNode.command;
        int n4 = n2 = (renderNode$PrimitiveNode.attrs & 8) != 0 ? (n3 & 0x60) >> 4 : 0;
        if (n2 != 0 ? this.flushStep == 1 : this.flushStep == 2) {
            return;
        }
        MathUtil.multiplyMM(this.MVP_TMP, renderNode$PrimitiveNode.projMatrix, renderNode$PrimitiveNode.viewMatrix);
        GL20.glEnable(2929);
        GL20.glDepthFunc(513);
        GL20.glDepthMask(this.flushStep == 1);
        GL20.glDisable(2884);
        Render.applyBlending(n2);
        int n5 = n3 >> 16 & 0xFF;
        switch (n3 & 0x7000000) {
            case 0x1000000: {
                this.renderMesh(renderNode$PrimitiveNode, 0);
                Render.checkGlError("renderPrimitive[PRIMITIVE_POINTS]");
                break;
            }
            case 0x2000000: {
                this.renderMesh(renderNode$PrimitiveNode, 1);
                Render.checkGlError("renderPrimitive[PRIMITIVE_LINES]");
                break;
            }
            case 0x3000000: 
            case 0x4000000: {
                if ((n3 & 0x3000) == 12288) {
                    this.renderMeshT(renderNode$PrimitiveNode);
                    break;
                }
                if ((n3 & 0xC00) == 0) break;
                this.renderMeshC(renderNode$PrimitiveNode);
                break;
            }
            case 0x5000000: {
                Program$Sprite program$Sprite = Program.sprite;
                program$Sprite.use();
                GL20.glVertexAttribPointer(program$Sprite.aPosition, 4, 5126, false, 16, (FloatBuffer)renderNode$PrimitiveNode.vertices.rewind());
                GL20.glEnableVertexAttribArray(program$Sprite.aPosition);
                GL20.glVertexAttribPointer(program$Sprite.aColorData, 2, 5121, false, 2, (ByteBuffer)renderNode$PrimitiveNode.texCoords.rewind());
                GL20.glEnableVertexAttribArray(program$Sprite.aColorData);
                program$Sprite.setTexture(renderNode$PrimitiveNode.texture);
                GL20.glUniform1i(program$Sprite.uIsTransparency, n3 & 0x10);
                GL20.glDrawArrays(4, 0, n5 * 6);
                GL20.glDisableVertexAttribArray(program$Sprite.aPosition);
                GL20.glDisableVertexAttribArray(program$Sprite.aColorData);
                Render.checkGlError("renderPrimitive[PRIMITIVE_POINT_SPRITES]");
            }
        }
    }

    private void renderMesh(RenderNode$PrimitiveNode renderNode$PrimitiveNode, int n2) {
        Program$Color program$Color = Program.color;
        program$Color.use();
        GL20.glVertexAttrib2f(program$Color.aMaterial, 0.0f, 0.0f);
        program$Color.bindMatrices(this.MVP_TMP, renderNode$PrimitiveNode.viewMatrix);
        GL20.glVertexAttribPointer(program$Color.aPosition, 3, 5126, false, 12, (FloatBuffer)renderNode$PrimitiveNode.vertices.rewind());
        GL20.glEnableVertexAttribArray(program$Color.aPosition);
        if ((renderNode$PrimitiveNode.command & 0xC00) == 1024) {
            program$Color.setColor(renderNode$PrimitiveNode.colors);
        } else {
            GL20.glVertexAttribPointer(program$Color.aColorData, 3, 5121, true, 3, (ByteBuffer)renderNode$PrimitiveNode.colors.rewind());
            GL20.glEnableVertexAttribArray(program$Color.aColorData);
        }
        GL20.glDrawArrays(n2, 0, renderNode$PrimitiveNode.vertices.capacity() / 3);
        GL20.glDisableVertexAttribArray(program$Color.aPosition);
        GL20.glDisableVertexAttribArray(program$Color.aColorData);
    }

    public void setOrthographicScale(int n2, int n3) {
        this.env.projection = -1879048192;
        float f2 = this.env.width;
        float f3 = this.env.height;
        float f4 = f2 * (4096.0f / (float)n2);
        float f5 = f3 * (4096.0f / (float)n3);
        float f6 = 2.0f / f4;
        float f7 = 2.0f / f5;
        float f8 = 1.5258789E-5f;
        float f9 = 2.0f * (float)this.env.centerX / f2 - 1.0f;
        float f10 = 2.0f * (float)this.env.centerY / f3 - 1.0f;
        float f11 = 0.0f;
        float[] fArray = this.env.projMatrix;
        fArray[0] = f6;
        fArray[4] = 0.0f;
        fArray[8] = 0.0f;
        fArray[12] = f9;
        fArray[1] = 0.0f;
        fArray[5] = f7;
        fArray[9] = 0.0f;
        fArray[13] = f10;
        fArray[2] = 0.0f;
        fArray[6] = 0.0f;
        fArray[10] = f8;
        fArray[14] = f11;
        fArray[3] = 0.0f;
        fArray[7] = 0.0f;
        fArray[11] = 0.0f;
        fArray[15] = 1.0f;
    }

    public void setOrthographicW(int n2) {
        if (n2 <= 0) {
            return;
        }
        this.env.projection = -1862270976;
        float f2 = this.env.width;
        float f3 = this.env.height;
        float f4 = 2.0f / (float)n2;
        float f5 = f4 * (f2 / f3);
        float f6 = 1.5258789E-5f;
        float f7 = 2.0f * (float)this.env.centerX / f2 - 1.0f;
        float f8 = 2.0f * (float)this.env.centerY / f3 - 1.0f;
        float f9 = 0.0f;
        float[] fArray = this.env.projMatrix;
        fArray[0] = f4;
        fArray[4] = 0.0f;
        fArray[8] = 0.0f;
        fArray[12] = f7;
        fArray[1] = 0.0f;
        fArray[5] = f5;
        fArray[9] = 0.0f;
        fArray[13] = f8;
        fArray[2] = 0.0f;
        fArray[6] = 0.0f;
        fArray[10] = f6;
        fArray[14] = f9;
        fArray[3] = 0.0f;
        fArray[7] = 0.0f;
        fArray[11] = 0.0f;
        fArray[15] = 1.0f;
    }

    public void setOrthographicWH(int n2, int n3) {
        if (n2 <= 0 || n3 <= 0) {
            return;
        }
        this.env.projection = -1862270976;
        float f2 = 2.0f / (float)n2;
        float f3 = 2.0f / (float)n3;
        float f4 = 1.5258789E-5f;
        float f5 = 2.0f * (float)this.env.centerX / (float)this.env.width - 1.0f;
        float f6 = 2.0f * (float)this.env.centerY / (float)this.env.height - 1.0f;
        float f7 = 0.0f;
        float[] fArray = this.env.projMatrix;
        fArray[0] = f2;
        fArray[4] = 0.0f;
        fArray[8] = 0.0f;
        fArray[12] = f5;
        fArray[1] = 0.0f;
        fArray[5] = f3;
        fArray[9] = 0.0f;
        fArray[13] = f6;
        fArray[2] = 0.0f;
        fArray[6] = 0.0f;
        fArray[10] = f4;
        fArray[14] = f7;
        fArray[3] = 0.0f;
        fArray[7] = 0.0f;
        fArray[11] = 0.0f;
        fArray[15] = 1.0f;
    }

    public void setPerspectiveFov(int n2, int n3, int n4) {
        if (n2 <= 0 || n3 <= 0 || n2 >= n3) {
            return;
        }
        n4 = MathUtil.clamp(n4, 2, 2046);
        this.env.projection = -1845493760;
        this.env.near = n2;
        float f2 = 1.0f / (float)(n2 - n3);
        float f3 = 1.0f / (float)Math.tan((double)((float)n4 * 2.4414062E-4f) * Math.PI);
        float f4 = this.env.width;
        float f5 = this.env.height;
        float f6 = f3 * (f4 / f5);
        float f7 = (float)(-(n3 + n2)) * f2;
        float f8 = 2.0f * (float)this.env.centerX / f4 - 1.0f;
        float f9 = 2.0f * (float)this.env.centerY / f5 - 1.0f;
        float f10 = 2.0f * (float)n3 * (float)n2 * f2;
        float[] fArray = this.env.projMatrix;
        fArray[0] = f3;
        fArray[4] = 0.0f;
        fArray[8] = f8;
        fArray[12] = 0.0f;
        fArray[1] = 0.0f;
        fArray[5] = f6;
        fArray[9] = f9;
        fArray[13] = 0.0f;
        fArray[2] = 0.0f;
        fArray[6] = 0.0f;
        fArray[10] = f7;
        fArray[14] = f10;
        fArray[3] = 0.0f;
        fArray[7] = 0.0f;
        fArray[11] = 1.0f;
        fArray[15] = 0.0f;
    }

    public void setPerspectiveW(int n2, int n3, int n4) {
        if (n2 <= 0 || n3 <= 0 || n2 >= n3 || n4 <= 0) {
            return;
        }
        this.env.projection = -1828716544;
        this.env.near = n2;
        float f2 = this.env.width;
        float f3 = this.env.height;
        float f4 = 1.0f / (float)(n2 - n3);
        float f5 = 2.0f * (float)n2 / ((float)n4 * 2.4414062E-4f);
        float f6 = f5 * (f2 / f3);
        float f7 = (float)(-(n2 + n3)) * f4;
        float f8 = 2.0f * (float)this.env.centerX / f2 - 1.0f;
        float f9 = 2.0f * (float)this.env.centerY / f3 - 1.0f;
        float f10 = 2.0f * (float)n3 * (float)n2 * f4;
        float[] fArray = this.env.projMatrix;
        fArray[0] = f5;
        fArray[4] = 0.0f;
        fArray[8] = f8;
        fArray[12] = 0.0f;
        fArray[1] = 0.0f;
        fArray[5] = f6;
        fArray[9] = f9;
        fArray[13] = 0.0f;
        fArray[2] = 0.0f;
        fArray[6] = 0.0f;
        fArray[10] = f7;
        fArray[14] = f10;
        fArray[3] = 0.0f;
        fArray[7] = 0.0f;
        fArray[11] = 1.0f;
        fArray[15] = 0.0f;
    }

    public void setPerspectiveWH(float f2, float f3, int n2, int n3) {
        if (f2 <= 0.0f || f3 <= 0.0f || f2 >= f3 || n2 == 0 || n3 == 0) {
            return;
        }
        this.env.projection = -1828716544;
        this.env.near = f2;
        float f4 = (float)n2 * 2.4414062E-4f;
        float f5 = (float)n3 * 2.4414062E-4f;
        float f6 = 1.0f / (f2 - f3);
        float f7 = 2.0f * f2 / f4;
        float f8 = 2.0f * f2 / f5;
        float f9 = -(f2 + f3) * f6;
        float f10 = 2.0f * (float)this.env.centerX / (float)this.env.width - 1.0f;
        float f11 = 2.0f * (float)this.env.centerY / (float)this.env.height - 1.0f;
        float f12 = 2.0f * f3 * f2 * f6;
        float[] fArray = this.env.projMatrix;
        fArray[0] = f7;
        fArray[4] = 0.0f;
        fArray[8] = f10;
        fArray[12] = 0.0f;
        fArray[1] = 0.0f;
        fArray[5] = f8;
        fArray[9] = f11;
        fArray[13] = 0.0f;
        fArray[2] = 0.0f;
        fArray[6] = 0.0f;
        fArray[10] = f9;
        fArray[14] = f12;
        fArray[3] = 0.0f;
        fArray[7] = 0.0f;
        fArray[11] = 1.0f;
        fArray[15] = 0.0f;
    }

    public void setViewTransArray(float[] fArray) {
        this.env.matrices = fArray;
    }

    private void selectAffineTrans(int n2) {
        float[] fArray = this.env.matrices;
        if (fArray != null && fArray.length >= (n2 + 1) * 12) {
            System.arraycopy(fArray, n2 * 12, this.env.viewMatrix, 0, 12);
        }
    }

    public void setCenter(int n2, int n3) {
        this.env.centerX = n2;
        this.env.centerY = n3;
    }

    public void setClearColor(int n2) {
        this.clearColor = n2;
    }

    public synchronized void flushToBuffer() {
        ++Profiler3D.MC3D_flushCallCount;
        if (this.stack.isEmpty()) {
            return;
        }
        try {
            this.copy2d(true);
            this.flushStep = 1;
            for (RenderNode renderNode : this.stack) {
                renderNode.render(this);
            }
            this.flushStep = 2;
            for (RenderNode renderNode : this.stack) {
                renderNode.render(this);
                renderNode.recycle();
            }
            GL20.glDisable(3042);
            GL20.glDepthMask(true);
            GL20.glClear(256);
            GL20.glFlush();
            if (this.targetTexture != null) {
                GL20.glReadPixels(0, 0, 256, 256, 6408, 5121, this.targetTexture.image.getRaster());
            } else if (this.targetGraphics != null) {
                this.swapBuffers();
            }
        }
        finally {
            this.stack.clear();
        }
    }

    private void swapBuffers() {
        if (this.targetGraphics == null) {
            return;
        }
        Rectangle rectangle = this.clip;
        this.emulator3d.swapBuffers(true, rectangle.x, rectangle.y, rectangle.width, rectangle.height);
    }
}

