/*
 * Decompiled with CFR 0.152.
 */
package com.motorola.iden.micro3d;

import ru.woesss.j2me.micro3d.MathUtil;

public class Vector3D {
    public static final int MAX_VALUE = Short.MAX_VALUE;
    public static final int MIN_VALUE = Short.MIN_VALUE;
    public static final int SIZE_OF_VECTOR3D = 3;
    int x;
    int y;
    int z;

    public Vector3D() {
    }

    public Vector3D(int n2, int n3, int n4) {
        this.x = MathUtil.clamp(n2, Short.MIN_VALUE, Short.MAX_VALUE);
        this.y = MathUtil.clamp(n3, Short.MIN_VALUE, Short.MAX_VALUE);
        this.z = MathUtil.clamp(n4, Short.MIN_VALUE, Short.MAX_VALUE);
    }

    Vector3D(Vector3D vector3D) {
        this.x = vector3D.x;
        this.y = vector3D.y;
        this.z = vector3D.z;
    }

    public int getX() {
        return this.x;
    }

    public int getY() {
        return this.y;
    }

    public int getZ() {
        return this.z;
    }

    public int innerProduct(Vector3D vector3D) {
        if (vector3D == null) {
            throw new NullPointerException();
        }
        return this.x * vector3D.x + this.y * vector3D.y + this.z * vector3D.z;
    }

    public void normalize() {
        int n2 = this.x;
        int n3 = this.y;
        int n4 = this.z;
        int n5 = Integer.numberOfLeadingZeros(Math.abs(n2) | Math.abs(n3) | Math.abs(n4)) - 17;
        if (n5 > 0) {
            n2 <<= n5;
            n3 <<= n5;
            n4 <<= n5;
        } else if (n5 < 0) {
            n5 = -n5;
            n2 >>= n5;
            n3 >>= n5;
            n4 >>= n5;
        }
        int n6 = MathUtil.uSqrt(n2 * n2 + n3 * n3 + n4 * n4);
        if (n6 != 0) {
            this.x = (n2 << 12) / n6;
            this.y = (n3 << 12) / n6;
            this.z = (n4 << 12) / n6;
        } else {
            this.x = 0;
            this.y = 0;
            this.z = 4096;
        }
    }

    public static Vector3D normalize(Vector3D vector3D) {
        if (vector3D == null) {
            throw new NullPointerException();
        }
        if (vector3D.isZero()) {
            throw new IllegalArgumentException();
        }
        Vector3D vector3D2 = new Vector3D(vector3D);
        vector3D2.normalize();
        return vector3D2;
    }

    public void outerProduct(Vector3D vector3D) {
        if (vector3D == null) {
            throw new NullPointerException();
        }
        int n2 = this.x;
        int n3 = this.y;
        int n4 = this.z;
        this.x = n3 * vector3D.z - n4 * vector3D.y;
        this.y = n4 * vector3D.x - n2 * vector3D.z;
        this.z = n2 * vector3D.y - n3 * vector3D.x;
    }

    public static Vector3D outerProduct(Vector3D vector3D, Vector3D vector3D2) {
        if (vector3D == null) {
            throw new NullPointerException();
        }
        Vector3D vector3D3 = new Vector3D(vector3D);
        vector3D3.outerProduct(vector3D2);
        return vector3D3;
    }

    public void set(int n2, int n3, int n4) {
        this.x = MathUtil.clamp(n2, Short.MIN_VALUE, Short.MAX_VALUE);
        this.y = MathUtil.clamp(n3, Short.MIN_VALUE, Short.MAX_VALUE);
        this.z = MathUtil.clamp(n4, Short.MIN_VALUE, Short.MAX_VALUE);
    }

    public void setX(int n2) {
        this.x = MathUtil.clamp(n2, Short.MIN_VALUE, Short.MAX_VALUE);
    }

    public void setY(int n2) {
        this.y = MathUtil.clamp(n2, Short.MIN_VALUE, Short.MAX_VALUE);
    }

    public void setZ(int n2) {
        this.z = MathUtil.clamp(n2, Short.MIN_VALUE, Short.MAX_VALUE);
    }

    boolean isZero() {
        return (this.x & this.y & this.z) == 0;
    }

    void set(Vector3D vector3D) {
        this.x = vector3D.x;
        this.y = vector3D.y;
        this.z = vector3D.z;
    }
}

