/*
 * Decompiled with CFR 0.152.
 */
package emulator.graphics3D;

import emulator.graphics3D.Vector4f;

public class G3DUtils {
    public static boolean Invert4x4(float[] fArray) {
        float[] fArray2 = new float[12];
        float[] fArray3 = new float[16];
        float[] fArray4 = new float[16];
        for (int i2 = 0; i2 < 4; ++i2) {
            fArray3[i2 + 0] = fArray[i2 * 4 + 0];
            fArray3[i2 + 4] = fArray[i2 * 4 + 1];
            fArray3[i2 + 8] = fArray[i2 * 4 + 2];
            fArray3[i2 + 12] = fArray[i2 * 4 + 3];
        }
        fArray2[0] = fArray3[10] * fArray3[15];
        fArray2[1] = fArray3[11] * fArray3[14];
        fArray2[2] = fArray3[9] * fArray3[15];
        fArray2[3] = fArray3[11] * fArray3[13];
        fArray2[4] = fArray3[9] * fArray3[14];
        fArray2[5] = fArray3[10] * fArray3[13];
        fArray2[6] = fArray3[8] * fArray3[15];
        fArray2[7] = fArray3[11] * fArray3[12];
        fArray2[8] = fArray3[8] * fArray3[14];
        fArray2[9] = fArray3[10] * fArray3[12];
        fArray2[10] = fArray3[8] * fArray3[13];
        fArray2[11] = fArray3[9] * fArray3[12];
        fArray4[0] = fArray2[0] * fArray3[5] + fArray2[3] * fArray3[6] + fArray2[4] * fArray3[7];
        fArray4[0] = fArray4[0] - (fArray2[1] * fArray3[5] + fArray2[2] * fArray3[6] + fArray2[5] * fArray3[7]);
        fArray4[1] = fArray2[1] * fArray3[4] + fArray2[6] * fArray3[6] + fArray2[9] * fArray3[7];
        fArray4[1] = fArray4[1] - (fArray2[0] * fArray3[4] + fArray2[7] * fArray3[6] + fArray2[8] * fArray3[7]);
        fArray4[2] = fArray2[2] * fArray3[4] + fArray2[7] * fArray3[5] + fArray2[10] * fArray3[7];
        fArray4[2] = fArray4[2] - (fArray2[3] * fArray3[4] + fArray2[6] * fArray3[5] + fArray2[11] * fArray3[7]);
        fArray4[3] = fArray2[5] * fArray3[4] + fArray2[8] * fArray3[5] + fArray2[11] * fArray3[6];
        fArray4[3] = fArray4[3] - (fArray2[4] * fArray3[4] + fArray2[9] * fArray3[5] + fArray2[10] * fArray3[6]);
        fArray4[4] = fArray2[1] * fArray3[1] + fArray2[2] * fArray3[2] + fArray2[5] * fArray3[3];
        fArray4[4] = fArray4[4] - (fArray2[0] * fArray3[1] + fArray2[3] * fArray3[2] + fArray2[4] * fArray3[3]);
        fArray4[5] = fArray2[0] * fArray3[0] + fArray2[7] * fArray3[2] + fArray2[8] * fArray3[3];
        fArray4[5] = fArray4[5] - (fArray2[1] * fArray3[0] + fArray2[6] * fArray3[2] + fArray2[9] * fArray3[3]);
        fArray4[6] = fArray2[3] * fArray3[0] + fArray2[6] * fArray3[1] + fArray2[11] * fArray3[3];
        fArray4[6] = fArray4[6] - (fArray2[2] * fArray3[0] + fArray2[7] * fArray3[1] + fArray2[10] * fArray3[3]);
        fArray4[7] = fArray2[4] * fArray3[0] + fArray2[9] * fArray3[1] + fArray2[10] * fArray3[2];
        fArray4[7] = fArray4[7] - (fArray2[5] * fArray3[0] + fArray2[8] * fArray3[1] + fArray2[11] * fArray3[2]);
        fArray2[0] = fArray3[2] * fArray3[7];
        fArray2[1] = fArray3[3] * fArray3[6];
        fArray2[2] = fArray3[1] * fArray3[7];
        fArray2[3] = fArray3[3] * fArray3[5];
        fArray2[4] = fArray3[1] * fArray3[6];
        fArray2[5] = fArray3[2] * fArray3[5];
        fArray2[6] = fArray3[0] * fArray3[7];
        fArray2[7] = fArray3[3] * fArray3[4];
        fArray2[8] = fArray3[0] * fArray3[6];
        fArray2[9] = fArray3[2] * fArray3[4];
        fArray2[10] = fArray3[0] * fArray3[5];
        fArray2[11] = fArray3[1] * fArray3[4];
        fArray4[8] = fArray2[0] * fArray3[13] + fArray2[3] * fArray3[14] + fArray2[4] * fArray3[15];
        fArray4[8] = fArray4[8] - (fArray2[1] * fArray3[13] + fArray2[2] * fArray3[14] + fArray2[5] * fArray3[15]);
        fArray4[9] = fArray2[1] * fArray3[12] + fArray2[6] * fArray3[14] + fArray2[9] * fArray3[15];
        fArray4[9] = fArray4[9] - (fArray2[0] * fArray3[12] + fArray2[7] * fArray3[14] + fArray2[8] * fArray3[15]);
        fArray4[10] = fArray2[2] * fArray3[12] + fArray2[7] * fArray3[13] + fArray2[10] * fArray3[15];
        fArray4[10] = fArray4[10] - (fArray2[3] * fArray3[12] + fArray2[6] * fArray3[13] + fArray2[11] * fArray3[15]);
        fArray4[11] = fArray2[5] * fArray3[12] + fArray2[8] * fArray3[13] + fArray2[11] * fArray3[14];
        fArray4[11] = fArray4[11] - (fArray2[4] * fArray3[12] + fArray2[9] * fArray3[13] + fArray2[10] * fArray3[14]);
        fArray4[12] = fArray2[2] * fArray3[10] + fArray2[5] * fArray3[11] + fArray2[1] * fArray3[9];
        fArray4[12] = fArray4[12] - (fArray2[4] * fArray3[11] + fArray2[0] * fArray3[9] + fArray2[3] * fArray3[10]);
        fArray4[13] = fArray2[8] * fArray3[11] + fArray2[0] * fArray3[8] + fArray2[7] * fArray3[10];
        fArray4[13] = fArray4[13] - (fArray2[6] * fArray3[10] + fArray2[9] * fArray3[11] + fArray2[1] * fArray3[8]);
        fArray4[14] = fArray2[6] * fArray3[9] + fArray2[11] * fArray3[11] + fArray2[3] * fArray3[8];
        fArray4[14] = fArray4[14] - (fArray2[10] * fArray3[11] + fArray2[2] * fArray3[8] + fArray2[7] * fArray3[9]);
        fArray4[15] = fArray2[10] * fArray3[10] + fArray2[4] * fArray3[8] + fArray2[9] * fArray3[9];
        fArray4[15] = fArray4[15] - (fArray2[8] * fArray3[9] + fArray2[11] * fArray3[10] + fArray2[5] * fArray3[8]);
        float f2 = fArray3[0] * fArray4[0] + fArray3[1] * fArray4[1] + fArray3[2] * fArray4[2] + fArray3[3] * fArray4[3];
        f2 = 1.0f / f2;
        for (int i3 = 0; i3 < 16; ++i3) {
            fArray[i3] = fArray4[i3] * f2;
        }
        return true;
    }

    public static float getFloatColor(int n2, int n3) {
        return (float)(n2 >> n3 & 0xFF) / 255.0f;
    }

    public static void fillFloatColor(float[] fArray, int n2) {
        fArray[0] = (float)(n2 >> 16 & 0xFF) / 255.0f;
        fArray[1] = (float)(n2 >> 8 & 0xFF) / 255.0f;
        fArray[2] = (float)(n2 & 0xFF) / 255.0f;
        fArray[3] = (float)(n2 >> 24 & 0xFF) / 255.0f;
    }

    public static int getIntColor(float[] fArray) {
        int n2;
        float[] fArray2;
        int n3;
        int n4;
        int n5;
        if (fArray.length == 1) {
            n5 = 255;
            n4 = 255;
            n3 = 255;
            fArray2 = fArray;
            n2 = 0;
        } else {
            n3 = (int)(G3DUtils.limit(fArray[0]) * 255.0f + 0.5f);
            n4 = (int)(G3DUtils.limit(fArray[1]) * 255.0f + 0.5f);
            n5 = (int)(G3DUtils.limit(fArray[2]) * 255.0f + 0.5f);
            if (fArray.length != 4) {
                int n6 = 255;
                return (n6 << 24) + (n3 << 16) + (n4 << 8) + n5;
            }
            fArray2 = fArray;
            n2 = 3;
        }
        int n7 = (int)(G3DUtils.limit(fArray2[n2]) * 255.0f + 0.5f);
        return (n7 << 24) + (n3 << 16) + (n4 << 8) + n5;
    }

    public static float limitPositive(float f2) {
        return f2 >= 0.0f ? f2 : 0.0f;
    }

    public static float limit(float f2) {
        return f2 >= 0.0f ? (f2 <= 1.0f ? f2 : 1.0f) : 0.0f;
    }

    public static float limit(float f2, float f3, float f4) {
        return f2 >= f3 ? (f2 <= f4 ? f2 : f4) : f3;
    }

    public static int limit(int n2, int n3, int n4) {
        return n2 >= n3 ? (n2 <= n4 ? n2 : n4) : n3;
    }

    public static int round(float f2) {
        return f2 >= 0.0f ? (int)(f2 + 0.5f) : (int)(f2 - 0.5f);
    }

    public static final boolean intersectRectangle(int n2, int n3, int n4, int n5, int n6, int n7, int n8, int n9, int[] nArray) {
        int n10;
        int n11;
        int n12;
        int n13 = n12 = n2 < n6 ? n6 : n2;
        if (n2 + n4 > n6 + n8) {
            n11 = n6;
            n10 = n8;
        } else {
            n11 = n2;
            n10 = n4;
        }
        int n14 = n11 + n10;
        if (n14 - n12 < 0) {
            return false;
        }
        nArray[0] = n12;
        nArray[2] = n14 - n12;
        int n15 = n12 = n3 < n7 ? n7 : n3;
        if (n3 + n5 > n7 + n9) {
            n11 = n7;
            n10 = n9;
        } else {
            n11 = n3;
            n10 = n5;
        }
        n14 = n11 + n10;
        if (n14 - n12 < 0) {
            return false;
        }
        nArray[1] = n12;
        nArray[3] = n14 - n12;
        return true;
    }

    public static final boolean intersectTriangle(Vector4f vector4f, Vector4f vector4f2, Vector4f vector4f3, Vector4f vector4f4, Vector4f vector4f5, Vector4f vector4f6, int n2) {
        Vector4f vector4f7 = new Vector4f();
        Vector4f vector4f8 = new Vector4f();
        Vector4f vector4f9 = new Vector4f();
        Vector4f vector4f10 = new Vector4f();
        Vector4f vector4f11 = new Vector4f();
        vector4f7.sub(vector4f4, vector4f3);
        vector4f8.sub(vector4f5, vector4f3);
        vector4f10.cross(vector4f2, vector4f8);
        float f2 = vector4f7.dot(vector4f10);
        if (n2 == 0 && f2 <= 0.0f) {
            return false;
        }
        if (n2 == 1 && f2 >= 0.0f) {
            return false;
        }
        if (f2 > -1.0E-5f && f2 < 1.0E-5f) {
            return false;
        }
        float f3 = 1.0f / f2;
        vector4f9.sub(vector4f, vector4f3);
        vector4f6.y = vector4f9.dot(vector4f10) * f3;
        if (vector4f6.y >= 0.0f && vector4f6.y <= 1.0f) {
            vector4f11.cross(vector4f9, vector4f7);
            vector4f6.z = vector4f2.dot(vector4f11) * f3;
            if (vector4f6.z >= 0.0f && vector4f6.y + vector4f6.z <= 1.0f) {
                vector4f6.x = vector4f8.dot(vector4f11) * f3;
                return true;
            }
            return false;
        }
        return false;
    }
}

