/*
 * Decompiled with CFR 0.152.
 */
package javax.microedition.m3g;

import javax.microedition.lcdui.Image;
import javax.microedition.m3g.Engine;
import javax.microedition.m3g.Helpers;
import javax.microedition.m3g.Object3D;

public class Image2D
extends Object3D {
    public static final int ALPHA = 96;
    public static final int LUMINANCE = 97;
    public static final int LUMINANCE_ALPHA = 98;
    public static final int RGB = 99;
    public static final int RGBA = 100;

    Image2D(int n) {
        super(n);
    }

    public Image2D(int n, int n2, int n3, byte[] array) {
        this(Image2D.create(n, n2, n3, array));
        Engine.addJavaPeer(this.swerveHandle, this);
        this.ii = this.getClass() != Image2D.class;
    }

    private static native int create(int var0, int var1, int var2, byte[] var3);

    public Image2D(int n, int n2, int n3, byte[] array, byte[] array2) {
        this(Image2D.createPalettized(n, n2, n3, array, array2));
        Engine.addJavaPeer(this.swerveHandle, this);
        this.ii = this.getClass() != Image2D.class;
    }

    private static native int createPalettized(int var0, int var1, int var2, byte[] var3, byte[] var4);

    public Image2D(int n, int n2, int n3) {
        this(Image2D.createMutable(n, n2, n3));
        Engine.addJavaPeer(this.swerveHandle, this);
        this.ii = this.getClass() != Image2D.class;
    }

    private static native int createMutable(int var0, int var1, int var2);

    private static native int createUninitialized(int var0, int var1, int var2, boolean var3);

    public Image2D(int n, Object o) {
        this(Image2D.createImage(n, o));
        Engine.addJavaPeer(this.swerveHandle, this);
        this.ii = this.getClass() != Image2D.class;
        Image image = (Image)o;
        int width = this.getWidth();
        int height = this.getHeight();
        boolean opaque = Image2D.isOpaque(image);
        if (width <= height) {
            int[] array = new int[width];
            for (int i2 = 0; i2 < height; ++i2) {
                Image2D.getImageRGB(image, array, 0, width, 0, i2, width, 1);
                this.setRGB(array, 0, i2, width, 1, opaque);
            }
            return;
        }
        int[] array2 = new int[height];
        for (int j = 0; j < width; ++j) {
            Image2D.getImageRGB(image, array2, 0, 1, j, 0, 1, height);
            this.setRGB(array2, j, 0, 1, height, opaque);
        }
    }

    Image2D(byte[] array, int n, int n2) {
        this(Image2D.createImageImpl(array, n, n2));
        Engine.addJavaPeer(this.swerveHandle, this);
        this.ii = this.getClass() != Image2D.class;
    }

    public native int getFormat();

    public native int getWidth();

    public native int getHeight();

    public native boolean isMutable();

    public native void set(int var1, int var2, int var3, int var4, byte[] var5);

    native void unpalettize();

    private native void setRGB(int[] var1, int var2, int var3, int var4, int var5, boolean var6);

    private static int createImage(int n, Object o) {
        if (o == null) {
            throw new NullPointerException();
        }
        if (!(o instanceof Image)) {
            throw new IllegalArgumentException();
        }
        Image image = (Image)o;
        return Image2D.createUninitialized(n, Image2D.getImageWidth(image), Image2D.getImageHeight(image), true);
    }

    private static native int createImageImpl(byte[] var0, int var1, int var2);

    private static int getImageWidth(Image image) {
        return Helpers.getImageWidth(image);
    }

    private static int getImageHeight(Image image) {
        return Helpers.getImageHeight(image);
    }

    static void getImageRGB(Image image, int[] array, int n, int n2, int n3, int n4, int n5, int n6) {
        Helpers.getImageRGB(image, array, n, n2, n3, n4, n5, n6);
    }

    static boolean isOpaque(Image image) {
        return Helpers.isOpaque(image);
    }

    public native boolean isPalettized();

    public native void getPalette(byte[] var1);

    native void setPalette(byte[] var1);

    public native void getPixels(byte[] var1);

    native void setPixels(byte[] var1);

    private native int qonvertATITCImpl(int var1);

    Image2D qonvertATITC(int n) {
        return (Image2D)Engine.instantiateJavaPeer(this.qonvertATITCImpl(n));
    }

    public int getBitsPerColor() {
        int m = 1;
        switch (this.getFormat()) {
            case 96: 
            case 97: {
                m = 1;
                break;
            }
            case 98: {
                m = 2;
                break;
            }
            case 99: {
                m = 3;
                break;
            }
            case 100: {
                m = 4;
            }
        }
        return m;
    }

    public int size() {
        return this.getWidth() * this.getHeight() * this.getBitsPerColor() + 4;
    }
}

