/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.internal.bind.v2.runtime.unmarshaller;

import com.sun.xml.internal.bind.v2.runtime.JaxBeanInfo;
import com.sun.xml.internal.bind.v2.runtime.unmarshaller.Discarder;
import com.sun.xml.internal.bind.v2.runtime.unmarshaller.Messages;
import com.sun.xml.internal.bind.v2.runtime.unmarshaller.TagName;
import com.sun.xml.internal.bind.v2.runtime.unmarshaller.UnmarshallingContext;
import java.util.Collection;
import java.util.Collections;
import javax.xml.bind.Unmarshaller;
import javax.xml.bind.helpers.ValidationEventImpl;
import javax.xml.namespace.QName;
import org.xml.sax.SAXException;

public abstract class Loader {
    protected boolean expectText;

    protected Loader(boolean bl) {
        this.expectText = bl;
    }

    protected Loader() {
    }

    public void startElement(UnmarshallingContext.State state, TagName tagName) throws SAXException {
    }

    public void childElement(UnmarshallingContext.State state, TagName tagName) throws SAXException {
        this.reportUnexpectedChildElement(tagName, true);
        state.setLoader(Discarder.INSTANCE);
        state.setReceiver(null);
    }

    protected final void reportUnexpectedChildElement(TagName tagName, boolean bl) throws SAXException {
        if (bl) {
            UnmarshallingContext unmarshallingContext = UnmarshallingContext.getInstance();
            if (!unmarshallingContext.parent.hasEventHandler() || !unmarshallingContext.shouldErrorBeReported()) {
                return;
            }
        }
        if (tagName.uri != tagName.uri.intern() || tagName.local != tagName.local.intern()) {
            Loader.reportError(Messages.UNINTERNED_STRINGS.format(new Object[0]), bl);
        } else {
            Loader.reportError(Messages.UNEXPECTED_ELEMENT.format(tagName.uri, tagName.local, this.computeExpectedElements()), bl);
        }
    }

    public Collection<QName> getExpectedChildElements() {
        return Collections.emptyList();
    }

    public Collection<QName> getExpectedAttributes() {
        return Collections.emptyList();
    }

    public void text(UnmarshallingContext.State state, CharSequence charSequence) throws SAXException {
        charSequence = charSequence.toString().replace('\r', ' ').replace('\n', ' ').replace('\t', ' ').trim();
        Loader.reportError(Messages.UNEXPECTED_TEXT.format(charSequence), true);
    }

    public final boolean expectText() {
        return this.expectText;
    }

    public void leaveElement(UnmarshallingContext.State state, TagName tagName) throws SAXException {
    }

    private String computeExpectedElements() {
        StringBuilder stringBuilder = new StringBuilder();
        for (QName qName : this.getExpectedChildElements()) {
            if (stringBuilder.length() != 0) {
                stringBuilder.append(',');
            }
            stringBuilder.append("<{").append(qName.getNamespaceURI()).append('}').append(qName.getLocalPart()).append('>');
        }
        if (stringBuilder.length() == 0) {
            return "(none)";
        }
        return stringBuilder.toString();
    }

    protected final void fireBeforeUnmarshal(JaxBeanInfo jaxBeanInfo, Object object, UnmarshallingContext.State state) throws SAXException {
        if (jaxBeanInfo.lookForLifecycleMethods()) {
            UnmarshallingContext unmarshallingContext = state.getContext();
            Unmarshaller.Listener listener = unmarshallingContext.parent.getListener();
            if (jaxBeanInfo.hasBeforeUnmarshalMethod()) {
                jaxBeanInfo.invokeBeforeUnmarshalMethod(unmarshallingContext.parent, object, state.getPrev().getTarget());
            }
            if (listener != null) {
                listener.beforeUnmarshal(object, state.getPrev().getTarget());
            }
        }
    }

    protected final void fireAfterUnmarshal(JaxBeanInfo jaxBeanInfo, Object object, UnmarshallingContext.State state) throws SAXException {
        if (jaxBeanInfo.lookForLifecycleMethods()) {
            UnmarshallingContext unmarshallingContext = state.getContext();
            Unmarshaller.Listener listener = unmarshallingContext.parent.getListener();
            if (jaxBeanInfo.hasAfterUnmarshalMethod()) {
                jaxBeanInfo.invokeAfterUnmarshalMethod(unmarshallingContext.parent, object, state.getTarget());
            }
            if (listener != null) {
                listener.afterUnmarshal(object, state.getTarget());
            }
        }
    }

    protected static void handleGenericException(Exception exception) throws SAXException {
        Loader.handleGenericException(exception, false);
    }

    public static void handleGenericException(Exception exception, boolean bl) throws SAXException {
        Loader.reportError(exception.getMessage(), exception, bl);
    }

    public static void handleGenericError(Error error) throws SAXException {
        Loader.reportError(error.getMessage(), false);
    }

    protected static void reportError(String string, boolean bl) throws SAXException {
        Loader.reportError(string, null, bl);
    }

    public static void reportError(String string, Exception exception, boolean bl) throws SAXException {
        UnmarshallingContext unmarshallingContext = UnmarshallingContext.getInstance();
        unmarshallingContext.handleEvent(new ValidationEventImpl(bl ? 1 : 2, string, unmarshallingContext.getLocator().getLocation(), exception), bl);
    }

    protected static void handleParseConversionException(UnmarshallingContext.State state, Exception exception) throws SAXException {
        state.getContext().handleError(exception);
    }
}

