/*
 * Decompiled with CFR 0.152.
 */
package com.HUD;

import com.HUD.Base.Text;
import com.HUD.GUIScreen;
import com.HUD.Menu;
import com.misc.ImageResize;
import com.misc.Main;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;

public final class GameHelp
extends GUIScreen {
    private int y0;
    private Main main;
    private Menu menu;
    private Text text;
    private int levelNumber;
    private Object hudInfo;
    private int drawtype = 0;
    private int stateCode = 1;
    private boolean preview = false;
    private Image background;
    public static boolean loadSave = false;
    public static boolean loadpos = true;
    private static short toMove = 0;

    public GameHelp(Main main, Menu menu, int levelNumberz, Object hudInfo) {
        this.init(main, menu, levelNumberz, hudInfo, 1);
    }

    public GameHelp(Main main, Menu menu, int levelNumberz, Object hudInfo, int helpState) {
        this.init(main, menu, levelNumberz, hudInfo, helpState);
    }

    public void init(Main main, Menu menu, int levelNumberz, Object hudInfo, int code) {
        String var6;
        this.main = main;
        this.menu = menu;
        this.drawtype = 0;
        loadSave = false;
        loadpos = true;
        this.levelNumber = levelNumberz;
        this.hudInfo = hudInfo;
        this.stateCode = code;
        this.setFont(Main.getFont());
        this.setLeftSoft(Main.getGameText().getString2("NEXT"));
        int var7 = this.getWidth() / 15;
        int var8 = this.getHeight() / 16;
        int var9 = this.getHeight() - var8 * 2;
        toMove = 0;
        String add = "";
        if (this.stateCode > 1) {
            add = "_" + Integer.toString(this.stateCode);
        }
        if (levelNumberz != 1) {
            System.out.println("GameHelp: getting info for level " + Integer.toString(levelNumberz));
            var6 = Main.getGameText().getString2("GAME_HELP_TEXT_" + Integer.toString(levelNumberz) + add);
            if (var6 != null) {
                var6 = var6.replace('*', '\n');
            }
        } else {
            var6 = Main.getGameText().getString2("GAME_HELP_TEXT");
            if (var6 == null) {
                var6 = Main.getGameText().getString2("GAME_HELP_TEXT_1" + add);
            }
            if (var6 != null) {
                var6 = var6.replace('*', '\n');
            }
        }
        if (var6 == null) {
            var6 = "";
        }
        String back1 = Main.getGameText().getString2("GAME_HELP_PREVIEW_" + Integer.toString(levelNumberz) + add);
        String back2 = Main.getGameText().getString2("GAME_HELP_BACKGROUND_" + Integer.toString(levelNumberz) + add);
        this.text = new Text(var6, var7, var8, this.getWidth() - var7 * 2, var9, Main.getFont());
        this.text.setCentreAlign(true);
        if (this.text.lines.size() * this.text.lineHeight() < this.text.height) {
            this.text.hSpace = Math.max(0, (var9 - this.text.lines.size() * this.text.lineHeight()) / 2);
        }
        try {
            if (back1 != null) {
                int offset;
                this.background = ImageResize.createImage(back1, (float)this.getWidth() / 240.0f, (float)this.getWidth() / 240.0f);
                this.text.hSpace = offset = this.background.getHeight() + (this.getWidth() - this.background.getWidth()) / 4 + this.getFont().height();
                this.text.height = this.getHeight() - offset;
                this.preview = true;
            } else if (back2 != null) {
                this.background = ImageResize.createImage(back2, this.getWidth(), this.getHeight());
            } else {
                if (menu != null && menu.background != null) {
                    this.background = menu.background;
                }
                if (menu == null && this.background == null) {
                    this.background = ImageResize.createImage(Main.background, this.getWidth(), this.getHeight());
                }
            }
        }
        catch (Exception err) {
            err.printStackTrace();
        }
    }

    protected final void paint(Graphics g) {
        g.setColor(0);
        g.fillRect(0, 0, this.getWidth(), this.getHeight());
        if (this.pressUp && toMove == 0 && !this.pointerPressed) {
            toMove = (short)(toMove + Main.getFont().height());
        }
        if (this.pressDown && toMove == 0 && !this.pointerPressed) {
            toMove = (short)(toMove - Main.getFont().height());
        }
        if (toMove != 0 && !this.pointerPressed) {
            this.text.move(Math.max(Math.min(3, toMove), -3));
            toMove = (short)(toMove - Math.max(Math.min(3, toMove), -3));
        }
        if (this.background != null && this.preview) {
            g.setColor(0xFFFFFF);
            int mov = (this.getWidth() - this.background.getWidth()) / 4;
            g.drawImage(this.background, mov * 2, mov, 0);
        } else if (this.background != null) {
            g.setColor(0xFFFFFF);
            g.drawImage(this.background, (this.getWidth() - this.background.getWidth()) / 2, (this.getHeight() - this.background.getHeight()) / 2, 0);
        }
        this.text.draw(g);
        g.translate(0, 0);
        g.setClip(0, 0, this.getWidth(), this.getHeight());
        this.drawSoftKeys(g);
        if (!this.pointerPressed) {
            try {
                Thread.sleep(22L);
                this.repaint();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    protected final void onLeftSoftKey() {
        this.onKey5();
    }

    protected final void onKey5() {
        this.background = null;
        this.destroy();
        Main.loadLevel(loadSave, loadpos, this.levelNumber, this.hudInfo, this.main, this.menu, this.stateCode + 1);
    }

    protected final void pointerPressed(int x, int y) {
        super.pointerPressed(x, y);
        this.y0 = y;
    }

    protected final void pointerDragged(int x, int y) {
        x = y - this.y0;
        this.y0 = y;
        toMove = 0;
        this.serviceRepaints();
        this.text.move(x);
        this.repaint();
    }

    protected final void pointerReleased(int x, int y) {
        super.pointerReleased(x, y);
        this.repaint();
    }

    private Image getScreenShot() {
        Image screenshot = Image.createImage((int)this.getWidth(), (int)this.getHeight());
        Graphics g = screenshot.getGraphics();
        this.paint(g);
        return Image.createImage((Image)screenshot);
    }
}

