/*
 * Decompiled with CFR 0.152.
 */
package com.Gameplay;

import com.Gameplay.GameScreen;
import com.HUD.Base.Font;
import com.HUD.Base.ItemList;
import com.HUD.Base.Keyboard;
import com.HUD.Base.TextView;
import com.HUD.MyCanvas.MyCanvas;
import com.Rendering.DirectX7;
import com.Rendering.Fps;
import com.Rendering.Meshes.Mesh;
import com.misc.ImageResize;
import com.misc.Main;
import com.misc.Stringer;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;

public class DialogScreen
extends MyCanvas {
    private DirectX7 g3d;
    private Keyboard keyboard;
    private Main main;
    private GameScreen gs;
    private TextView textView;
    private ItemList itemList;
    private boolean itemListHasCaption;
    private int[] answersGoIndex;
    private Image[] bckList = new Image[10];
    private Image avatar;
    private int index = 0;
    private String[] dialog;
    private boolean scrollDown = false;
    private boolean scrollUp = false;

    public DialogScreen(Font font, DirectX7 g3d, Main main, GameScreen gs) {
        this.keyboard = new Keyboard(this);
        this.g3d = g3d;
        this.main = main;
        this.gs = gs;
    }

    public DialogScreen(String text, Font font, DirectX7 g3d, Main main, GameScreen gs) {
        this.keyboard = new Keyboard(this);
        this.set(text, font, g3d, main, gs);
    }

    public void set(String text, Font font, DirectX7 g3d, Main main, GameScreen gs) {
        this.keyboard.reset();
        this.g3d = g3d;
        this.main = main;
        this.gs = gs;
        this.itemList = null;
        this.index = -1;
        String newText = null;
        if (text.charAt(0) == '/' && text.toLowerCase().endsWith(".txt")) {
            newText = Mesh.getStringFromResource(text);
        }
        this.dialog = newText == null ? Mesh.cutOnStrings(text, '@') : Mesh.cutOnStrings(newText, '\n');
        for (int i = 0; i < this.dialog.length; ++i) {
            String s = this.dialog[i];
            if (s.charAt(0) == '\n') {
                s = s.substring(1, s.length());
            }
            if (s.charAt(s.length() - 1) == '\n') {
                s = s.substring(0, s.length() - 1);
            }
            this.dialog[i] = s;
        }
        int h = (int)((float)this.getHeight() / 3.5f);
        if (h < font.height() * 3) {
            h = font.height() * 3;
        }
        this.textView = new TextView(null, g3d.getWidth() - 20, h, font);
        this.nextText();
    }

    protected final void keyReleased(int keyCode) {
        if (keyCode == this.keyboard.SOFT_LEFT) {
            this.keyboard.keyReleased(this.keyboard.FIRE);
            return;
        }
        this.keyboard.keyReleased(keyCode);
    }

    protected final void keyPressed(int keyCode) {
        if (keyCode == this.keyboard.SOFT_LEFT) {
            this.keyboard.keyPressed(this.keyboard.FIRE);
            return;
        }
        this.keyboard.keyPressed(keyCode);
        if (keyCode == this.keyboard.DOWN || keyCode == 56) {
            this.scrollDown = true;
        } else if (keyCode == this.keyboard.UP || keyCode == 50) {
            this.scrollUp = true;
        }
    }

    protected final void mousePressed(int x, int y) {
        this.keyboard.keyPressed(this.keyboard.FIRE);
    }

    protected final void mouseReleased(int x, int y) {
        this.keyboard.keyReleased(this.keyboard.FIRE);
    }

    protected final void mouseScrollUp() {
        this.scrollUp = true;
    }

    protected final void mouseScrollDown() {
        this.scrollDown = true;
    }

    private boolean nextText() {
        if (this.itemList != null) {
            this.index = this.answersGoIndex == null ? (this.index += this.itemList.getItems().length + this.itemList.getIndex() - (this.itemListHasCaption ? 1 : 0)) : this.answersGoIndex[this.itemList.getIndex() - (this.itemListHasCaption ? 1 : 0)] - 1;
            this.itemList = null;
            this.answersGoIndex = null;
        }
        if (this.index + 1 < this.dialog.length) {
            ++this.index;
            if (this.dialog[this.index].charAt(0) != '$') {
                this.textView.setString(this.dialog[this.index]);
                this.textView.setY(0);
                return true;
            }
            String text = this.dialog[this.index];
            int spacePlace = text.indexOf(32);
            String script = spacePlace != -1 ? text.substring(1, spacePlace).toLowerCase() : text.substring(1);
            String option = text;
            if (spacePlace != -1) {
                option = text.substring(spacePlace + 1);
            }
            if (script.equals("exec")) {
                this.gs.runScriptFromFile(option);
                return this.nextText();
            }
            if (script.equals("if")) {
                if (!this.gs.readBooleanFromScript(option)) {
                    ++this.index;
                }
                return this.nextText();
            }
            if (script.equals("cmd")) {
                this.gs.runScript(new String[]{option});
                return this.nextText();
            }
            if (script.startsWith("bck")) {
                String[] scalingList = new String[]{"fith", "fitw", "full", "fit3dh", "full3d", "orig"};
                int type = Stringer.startsWith(option, scalingList);
                if (type == -1) {
                    type = 0;
                } else {
                    option = option.substring(option.indexOf(32) + 1);
                }
                int layer = script.charAt(script.length() - 1) - 48;
                if (option.equalsIgnoreCase("clear")) {
                    if (layer < 0 || layer > 9) {
                        this.clearBcks();
                    } else {
                        this.bckList[layer] = null;
                    }
                } else {
                    this.loadNewBck(type, option, layer);
                }
                return this.nextText();
            }
            if (script.startsWith("avatar")) {
                if (option.equalsIgnoreCase("clear")) {
                    this.avatar = null;
                } else {
                    this.loadNewAvatar(option);
                }
                return this.nextText();
            }
            if (script.equals("go")) {
                return this.goToLabel(option);
            }
            if (script.equals("question")) {
                String[] items;
                String[] arguments = Mesh.cutOnStrings(option, ' ');
                boolean generative = arguments.length >= 2 && arguments[0].equalsIgnoreCase("gen");
                this.itemListHasCaption = arguments.length < 2 || !arguments[arguments.length - 2].equalsIgnoreCase("nocap");
                int capLen = this.itemListHasCaption ? 1 : 0;
                int answers = Stringer.parseInt(arguments[arguments.length - 1]);
                if (generative) {
                    int newAnswers = 0;
                    String[] allItems = new String[answers];
                    this.answersGoIndex = new int[answers];
                    for (int i = 0; i < answers; ++i) {
                        String answer = this.dialog[this.index + 1 + capLen + i];
                        String condition = this.dialog[this.index + 1 + capLen + i + answers];
                        if (!this.gs.readBooleanFromScript(condition)) continue;
                        allItems[newAnswers] = answer;
                        this.answersGoIndex[newAnswers] = this.index + 1 + capLen + i + answers * 2;
                        ++newAnswers;
                    }
                    if (newAnswers == 0) {
                        this.index += capLen + answers * 3;
                        return this.nextText();
                    }
                    items = new String[newAnswers + capLen];
                    System.arraycopy(allItems, 0, items, capLen, newAnswers);
                } else {
                    items = new String[answers + capLen];
                    System.arraycopy(this.dialog, this.index + capLen + 1, items, capLen, answers);
                }
                if (this.itemListHasCaption) {
                    items[0] = this.dialog[this.index + 1];
                }
                this.itemList = new ItemList(items, this.textView.getFont());
                this.itemList.left = true;
                this.itemList.setIndex(capLen);
                return true;
            }
            if (script.equals("end")) {
                return false;
            }
            return this.nextText();
        }
        return false;
    }

    private void loadNewBck(int scaling, String path, int layer) {
        try {
            this.bckList[layer] = null;
            Image img = Image.createImage((String)path);
            if (scaling != 5) {
                int w = img.getWidth();
                int h = img.getHeight();
                if (scaling == 0) {
                    w = w * this.getHeight() / h;
                    h = this.getHeight();
                } else if (scaling == 1) {
                    h = h * this.getWidth() / w;
                    w = this.getWidth();
                } else if (scaling == 2) {
                    h = this.getHeight();
                    w = this.getWidth();
                } else if (scaling == 3) {
                    w = w * (this.getHeight() * Main.getDisplaySize() / 100) / h;
                    h = this.getHeight() * Main.getDisplaySize() / 100;
                } else if (scaling == 4) {
                    w = this.getWidth();
                    h = this.getHeight() * Main.getDisplaySize() / 100;
                }
                img = ImageResize.bilinearResizeImage(img, w, h);
            }
            this.bckList[layer] = img;
        }
        catch (Exception e) {
            this.bckList[layer] = null;
            return;
        }
    }

    private void loadNewAvatar(String path) {
        try {
            this.avatar = Image.createImage((String)path);
        }
        catch (Exception e) {
            this.avatar = null;
            return;
        }
    }

    private void clearBcks() {
        for (int i = 0; i < this.bckList.length; ++i) {
            this.bckList[i] = null;
        }
    }

    private boolean goToLabel(String option) {
        for (int lineId = 0; lineId < this.dialog.length; ++lineId) {
            String line = this.dialog[lineId];
            if (option.length() != line.length() - 2 || line.charAt(0) != '$' || line.charAt(line.length() - 1) != ':' || line.indexOf(option) != 1) continue;
            this.index = lineId;
            return this.nextText();
        }
        System.out.println("Can't find label '" + option + "'");
        return false;
    }

    protected void paint(Graphics g) {
        int textEnd;
        int textBegin;
        g.setColor(0);
        g.setClip(0, 0, this.getWidth(), this.getHeight());
        g.translate(0, 0);
        g.fillRect(0, 0, this.getWidth(), this.getHeight());
        int sy = this.getHeight() / 2 - this.g3d.getnHeight() / 2;
        g.setColor(255, 255, 255);
        this.g3d.flush(g, 0, sy);
        for (int i = 0; i < this.bckList.length; ++i) {
            Image bck = this.bckList[i];
            if (bck == null) continue;
            g.drawImage(bck, this.getWidth() / 2, this.getHeight() / 2, 3);
        }
        int x = (this.getWidth() - this.textView.getWidth()) / 2;
        int y = this.getHeight() - this.textView.getHeight() - Main.bcks.getHeight() - 4;
        Main.drawBckDialog(g, y, this.textView.getHeight() + y);
        if (this.itemList == null) {
            textBegin = y + this.textView.getY();
            textEnd = textBegin + this.textView.getTextHeight();
            this.textView.paint(g, x, y);
        } else {
            textBegin = y + this.itemList.getPosY(this.textView.getHeight());
            textEnd = textBegin + this.itemList.getHeight();
            this.itemList.draw(g, x, y, this.textView.getWidth(), this.textView.getHeight());
        }
        if (this.avatar != null) {
            g.drawImage(this.avatar, 0, y - this.avatar.getHeight(), 0);
        }
        if (this.textView.getTextHeight() > this.textView.getHeight() && this.itemList == null || this.itemList != null && this.itemList.getHeight() > this.textView.getHeight()) {
            g.setColor(255, 255, 255);
            if (textEnd > y + this.textView.getHeight()) {
                g.fillTriangle(this.getWidth() - 13, y + this.textView.getHeight() - 13, this.getWidth() - 3, y + this.textView.getHeight() - 13, this.getWidth() - 8, y + this.textView.getHeight() - 3);
            }
            if (textBegin < y) {
                g.fillTriangle(this.getWidth() - 13, y + 13, this.getWidth() - 3, y + 13, this.getWidth() - 8, y + 3);
            }
        }
        try {
            Thread.sleep(20L);
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.step();
    }

    private void step() {
        if (this.itemList == null) {
            if (this.keyboard.down()) {
                this.textView.move(-3);
            }
            if (this.keyboard.up()) {
                this.textView.move(3);
            }
            if (this.scrollDown) {
                this.textView.move(-7);
            }
            if (this.scrollUp) {
                this.textView.move(7);
            }
        } else {
            if (this.scrollDown) {
                this.itemList.scrollDown();
                if (this.itemList.getIndex() == 0 && this.itemListHasCaption) {
                    this.itemList.setIndex(1);
                }
            }
            if (this.scrollUp) {
                this.itemList.scrollUp();
                if (this.itemList.getIndex() == 0 && this.itemListHasCaption) {
                    this.itemList.setIndex(this.itemList.getItems().length - 1);
                }
            }
        }
        this.scrollDown = false;
        this.scrollUp = false;
        if (this.keyboard.fire()) {
            this.keyboard.reset();
            if (!this.nextText()) {
                this.gs.start();
                this.gs.paused = false;
                this.clearBcks();
                this.avatar = null;
                this.itemList = null;
                this.answersGoIndex = null;
                this.dialog = null;
                Fps.reset();
                Main.setCurrent(this.gs);
                Fps.reset();
                return;
            }
        }
        this.repaint();
    }

    public static String loadTextFromFile(String text) {
        if (text == null) {
            return null;
        }
        if (text.charAt(0) != '/' || !text.toLowerCase().endsWith(".txt")) {
            return text;
        }
        text = Mesh.getStringFromResource(text);
        return text.replace('\n', '@');
    }
}

