/*
 * Decompiled with CFR 0.152.
 */
package com.Rendering;

import com.Rendering.DirectX7;
import com.Rendering.Texture;
import com.Rendering.TexturingPers;
import com.Rendering.Vertex;

public class TexturingFloors {
    public static final int fp = 12;
    public static final int FP = 4096;

    static final void paintFloor(DirectX7 g3d, Texture texture, int y_start, int y_end, int x_start, int wz_start, int uz_start, int vz_start, int x_end, int wz_end, int uz_end, int vz_end, int dx_start, int dwz_start, int duz_start, int dvz_start, int dx_end, int dwz_end, int duz_end, int dvz_end, int dwz, int duz, int dvz, int fogc, int sz2) {
        int[] tex = texture.rImg.img;
        int lengthBIT = tex.length - 1;
        int widthBIT = texture.rImg.widthBIT;
        int[] rgb = g3d.display;
        int duz4 = duz * sz2;
        int dvz4 = dvz * sz2;
        int dwz4 = dwz * sz2;
        int dv = 0;
        int du = 0;
        int col = 0;
        for (int y = y_start; y < y_end; ++y) {
            int x1 = x_start;
            int x2 = x_end;
            int uz_a = uz_start;
            int uz_b = uz_end;
            int vz_a = vz_start;
            int vz_b = vz_end;
            int wz_a = wz_start;
            int wz_b = wz_end;
            long subtexel_a = x1 % 4096;
            long subtexel_b = x2 % 4096;
            uz_a = (int)((long)uz_a - ((long)duz * subtexel_a >> 12));
            vz_a = (int)((long)vz_a - ((long)dvz * subtexel_a >> 12));
            wz_a = (int)((long)wz_a - ((long)dwz * subtexel_a >> 12));
            uz_b = (int)((long)uz_b - ((long)duz * subtexel_b >> 12));
            vz_b = (int)((long)vz_b - ((long)dvz * subtexel_b >> 12));
            wz_b = (int)((long)wz_b - ((long)dwz * subtexel_b >> 12));
            x2 >>= 12;
            if ((x1 >>= 12) < 0) {
                uz_a -= duz * x1;
                vz_a -= dvz * x1;
                wz_a -= dwz * x1;
                x1 = 0;
            }
            if (x2 > g3d.width) {
                uz_b -= duz * (x2 -= g3d.width);
                vz_b -= dvz * x2;
                wz_b -= dwz * x2;
                x2 = g3d.width;
            }
            if (wz_a == 0 || wz_b == 0) {
                return;
            }
            int tempI = y * g3d.width;
            int length = (x2 += tempI) - (x1 += tempI);
            if (length != 0) {
                int u = (int)(((long)uz_a << 12) / (long)wz_a);
                int v = (int)(((long)vz_a << 12) / (long)wz_a);
                du = ((int)(((long)uz_b << 12) / (long)wz_b) - u) / length;
                dv = ((int)(((long)vz_b << 12) / (long)wz_b) - v) / length;
                while (x2 - x1 >= 7) {
                    col = tex[((v += dv) >>> 12 << widthBIT) + ((u += du) >>> 12) & lengthBIT];
                    if (col != 0) {
                        rgb[x1] = col;
                    }
                    if ((col = tex[((v += dv) >>> 12 << widthBIT) + ((u += du) >>> 12) & lengthBIT]) != 0) {
                        rgb[x1 + 1] = col;
                    }
                    if ((col = tex[((v += dv) >>> 12 << widthBIT) + ((u += du) >>> 12) & lengthBIT]) != 0) {
                        rgb[x1 + 2] = col;
                    }
                    if ((col = tex[((v += dv) >>> 12 << widthBIT) + ((u += du) >>> 12) & lengthBIT]) != 0) {
                        rgb[x1 + 3] = col;
                    }
                    if ((col = tex[((v += dv) >>> 12 << widthBIT) + ((u += du) >>> 12) & lengthBIT]) != 0) {
                        rgb[x1 + 4] = col;
                    }
                    if ((col = tex[((v += dv) >>> 12 << widthBIT) + ((u += du) >>> 12) & lengthBIT]) != 0) {
                        rgb[x1 + 5] = col;
                    }
                    if ((col = tex[((v += dv) >>> 12 << widthBIT) + ((u += du) >>> 12) & lengthBIT]) != 0) {
                        rgb[x1 + 6] = col;
                    }
                    x1 += 7;
                }
                while (x1 < x2) {
                    col = tex[((v += dv) >>> 12 << widthBIT) + ((u += du) >>> 12) & lengthBIT];
                    if (col != 0) {
                        rgb[x1] = col;
                    }
                    ++x1;
                }
            }
            x_start += dx_start;
            wz_start += dwz_start;
            uz_start += duz_start;
            vz_start += dvz_start;
            x_end += dx_end;
            wz_end += dwz_end;
            uz_end += duz_end;
            vz_end += dvz_end;
        }
    }

    static final void paintFloor_1(DirectX7 g3d, Texture texture, int y_start, int y_end, int x_start, int wz_start, int uz_start, int vz_start, int x_end, int wz_end, int uz_end, int vz_end, int dx_start, int dwz_start, int duz_start, int dvz_start, int dx_end, int dwz_end, int duz_end, int dvz_end, int dwz, int duz, int dvz, int sz2) {
        int[] tex = texture.rImg.img;
        int lengthBIT = tex.length - 1;
        int widthBIT = texture.rImg.widthBIT;
        int[] rgb = g3d.display;
        int colf = sz2 & 0xFEFEFE;
        for (int y = y_start; y < y_end; ++y) {
            int x1 = x_start;
            int x2 = x_end;
            int uz_a = uz_start;
            int uz_b = uz_end;
            int vz_a = vz_start;
            int vz_b = vz_end;
            int wz_a = wz_start;
            int wz_b = wz_end;
            long subtexel_a = x1 % 4096;
            long subtexel_b = x2 % 4096;
            uz_a = (int)((long)uz_a - ((long)duz * subtexel_a >> 12));
            vz_a = (int)((long)vz_a - ((long)dvz * subtexel_a >> 12));
            wz_a = (int)((long)wz_a - ((long)dwz * subtexel_a >> 12));
            uz_b = (int)((long)uz_b - ((long)duz * subtexel_b >> 12));
            vz_b = (int)((long)vz_b - ((long)dvz * subtexel_b >> 12));
            wz_b = (int)((long)wz_b - ((long)dwz * subtexel_b >> 12));
            x2 >>= 12;
            if ((x1 >>= 12) < 0) {
                uz_a -= duz * x1;
                vz_a -= dvz * x1;
                wz_a -= dwz * x1;
                x1 = 0;
            }
            if (x2 > g3d.width) {
                uz_b -= duz * (x2 -= g3d.width);
                vz_b -= dvz * x2;
                wz_b -= dwz * x2;
                x2 = g3d.width;
            }
            if (wz_a == 0 || wz_b == 0) {
                return;
            }
            int tempI = y * g3d.width;
            int length = (x2 += tempI) - (x1 += tempI);
            if (length != 0) {
                int col;
                int u = (int)(((long)uz_a << 12) / (long)wz_a);
                int v = (int)(((long)vz_a << 12) / (long)wz_a);
                int du = ((int)(((long)uz_b << 12) / (long)wz_b) - u) / length;
                int dv = ((int)(((long)vz_b << 12) / (long)wz_b) - v) / length;
                while (x2 - x1 >= 2) {
                    col = tex[((v += dv) >>> 12 << widthBIT) + ((u += du) >>> 12) & lengthBIT];
                    if (col != 0) {
                        col = (col & 0xFEFEFE) + colf;
                        rgb[x1] = col | (col >>> 8 & 0x10101) * 255;
                    }
                    if ((col = tex[((v += dv) >>> 12 << widthBIT) + ((u += du) >>> 12) & lengthBIT]) != 0) {
                        col = (col & 0xFEFEFE) + colf;
                        rgb[x1 + 1] = col | (col >>> 8 & 0x10101) * 255;
                    }
                    x1 += 2;
                }
                while (x1 < x2) {
                    col = tex[((v += dv) >>> 12 << widthBIT) + ((u += du) >>> 12) & lengthBIT];
                    if (col != 0) {
                        col = (col & 0xFEFEFE) + colf;
                        rgb[x1] = col | (col >>> 8 & 0x10101) * 255;
                    }
                    ++x1;
                }
            }
            x_start += dx_start;
            wz_start += dwz_start;
            uz_start += duz_start;
            vz_start += dvz_start;
            x_end += dx_end;
            wz_end += dwz_end;
            uz_end += duz_end;
            vz_end += dvz_end;
        }
    }

    static final void paintFloor_2(DirectX7 g3d, Texture texture, int y_start, int y_end, int x_start, int wz_start, int uz_start, int vz_start, int x_end, int wz_end, int uz_end, int vz_end, int dx_start, int dwz_start, int duz_start, int dvz_start, int dx_end, int dwz_end, int duz_end, int dvz_end, int dwz, int duz, int dvz) {
        int[] tex = texture.rImg.img;
        int lengthBIT = tex.length - 1;
        int widthBIT = texture.rImg.widthBIT;
        int[] rgb = g3d.display;
        for (int y = y_start; y < y_end; ++y) {
            int x1 = x_start;
            int x2 = x_end;
            int uz_a = uz_start;
            int uz_b = uz_end;
            int vz_a = vz_start;
            int vz_b = vz_end;
            int wz_a = wz_start;
            int wz_b = wz_end;
            long subtexel_a = x1 % 4096;
            long subtexel_b = x2 % 4096;
            uz_a = (int)((long)uz_a - ((long)duz * subtexel_a >> 12));
            vz_a = (int)((long)vz_a - ((long)dvz * subtexel_a >> 12));
            wz_a = (int)((long)wz_a - ((long)dwz * subtexel_a >> 12));
            uz_b = (int)((long)uz_b - ((long)duz * subtexel_b >> 12));
            vz_b = (int)((long)vz_b - ((long)dvz * subtexel_b >> 12));
            wz_b = (int)((long)wz_b - ((long)dwz * subtexel_b >> 12));
            x2 >>= 12;
            if ((x1 >>= 12) < 0) {
                uz_a -= duz * x1;
                vz_a -= dvz * x1;
                wz_a -= dwz * x1;
                x1 = 0;
            }
            if (x2 > g3d.width) {
                uz_b -= duz * (x2 -= g3d.width);
                vz_b -= dvz * x2;
                wz_b -= dwz * x2;
                x2 = g3d.width;
            }
            if (wz_a == 0 || wz_b == 0) {
                return;
            }
            int tempI = y * g3d.width;
            int length = (x2 += tempI) - (x1 += tempI);
            if (length != 0) {
                int col;
                int u = (int)(((long)uz_a << 12) / (long)wz_a);
                int v = (int)(((long)vz_a << 12) / (long)wz_a);
                int du = ((int)(((long)uz_b << 12) / (long)wz_b) - u) / length;
                int dv = ((int)(((long)vz_b << 12) / (long)wz_b) - v) / length;
                while (x2 - x1 >= 2) {
                    col = tex[((v += dv) >>> 12 << widthBIT) + ((u += du) >>> 12) & lengthBIT];
                    if (col != 0) {
                        col = (col & 0xFEFEFE) + (rgb[x1] & 0xFEFEFE);
                        rgb[x1] = col | (col >>> 8 & 0x10101) * 255;
                    }
                    if ((col = tex[((v += dv) >>> 12 << widthBIT) + ((u += du) >>> 12) & lengthBIT]) != 0) {
                        col = (col & 0xFEFEFE) + (rgb[x1 + 1] & 0xFEFEFE);
                        rgb[x1 + 1] = col | (col >>> 8 & 0x10101) * 255;
                    }
                    x1 += 2;
                }
                while (x1 < x2) {
                    col = tex[((v += dv) >>> 12 << widthBIT) + ((u += du) >>> 12) & lengthBIT];
                    if (col != 0) {
                        col = (col & 0xFEFEFE) + (rgb[x1] & 0xFEFEFE);
                        rgb[x1] = col | (col >>> 8 & 0x10101) * 255;
                    }
                    ++x1;
                }
            }
            x_start += dx_start;
            wz_start += dwz_start;
            uz_start += duz_start;
            vz_start += dvz_start;
            x_end += dx_end;
            wz_end += dwz_end;
            uz_end += duz_end;
            vz_end += dvz_end;
        }
    }

    static final void paintFloor_3(DirectX7 g3d, Texture texture, int y_start, int y_end, int x_start, int wz_start, int uz_start, int vz_start, int x_end, int wz_end, int uz_end, int vz_end, int dx_start, int dwz_start, int duz_start, int dvz_start, int dx_end, int dwz_end, int duz_end, int dvz_end, int dwz, int duz, int dvz, int fogc, int sz2, Vertex a, Vertex b, Vertex c, int f_start, int f_end, int df_start, int df_end, int df) {
        int[] tex = texture.rImg.img;
        int lengthBIT = tex.length - 1;
        int widthBIT = texture.rImg.widthBIT;
        int[] rgb = g3d.display;
        int dv = 0;
        int du = 0;
        if (DirectX7.fDist / 255 != 0) {
            sz2 = -TexturingPers.min(a.rz, b.rz, c.rz) / (DirectX7.fDist / 255);
        }
        if (sz2 > 255) {
            sz2 = 255;
        }
        if (sz2 < 0) {
            sz2 = 0;
        }
        int isz2 = 255 - sz2;
        int f2 = (fogc & 0xFF00FF) * sz2;
        int f22 = (fogc & 0xFF00) * sz2;
        for (int y = y_start; y < y_end; ++y) {
            int x1 = x_start;
            int x2 = x_end;
            int uz_a = uz_start;
            int uz_b = uz_end;
            int vz_a = vz_start;
            int vz_b = vz_end;
            int wz_a = wz_start;
            int wz_b = wz_end;
            long subtexel_a = x1 % 4096;
            long subtexel_b = x2 % 4096;
            uz_a = (int)((long)uz_a - ((long)duz * subtexel_a >> 12));
            vz_a = (int)((long)vz_a - ((long)dvz * subtexel_a >> 12));
            wz_a = (int)((long)wz_a - ((long)dwz * subtexel_a >> 12));
            uz_b = (int)((long)uz_b - ((long)duz * subtexel_b >> 12));
            vz_b = (int)((long)vz_b - ((long)dvz * subtexel_b >> 12));
            wz_b = (int)((long)wz_b - ((long)dwz * subtexel_b >> 12));
            x2 >>= 12;
            if ((x1 >>= 12) < 0) {
                uz_a -= duz * x1;
                vz_a -= dvz * x1;
                wz_a -= dwz * x1;
                x1 = 0;
            }
            if (x2 > g3d.width) {
                uz_b -= duz * (x2 -= g3d.width);
                vz_b -= dvz * x2;
                wz_b -= dwz * x2;
                x2 = g3d.width;
            }
            if (wz_a == 0 || wz_b == 0) {
                return;
            }
            int tempI = y * g3d.width;
            int length = (x2 += tempI) - (x1 += tempI);
            if (length != 0) {
                int col;
                int u = (int)(((long)uz_a << 12) / (long)wz_a);
                int v = (int)(((long)vz_a << 12) / (long)wz_a);
                int u_2 = (int)(((long)uz_b << 12) / (long)wz_b);
                int v_2 = (int)(((long)vz_b << 12) / (long)wz_b);
                du = (u_2 - u) / length;
                dv = (v_2 - v) / length;
                while (x2 - x1 >= 3) {
                    col = tex[((v += dv) >>> 12 << widthBIT) + ((u += du) >>> 12) & lengthBIT];
                    if (col != 0) {
                        rgb[x1] = ((col & 0xFF00FF) * isz2 + f2 & 0xFF00FF00 | (col & 0xFF00) * isz2 + f22 & 0xFF0000) >>> 8;
                    }
                    if ((col = tex[((v += dv) >>> 12 << widthBIT) + ((u += du) >>> 12) & lengthBIT]) != 0) {
                        rgb[x1 + 1] = ((col & 0xFF00FF) * isz2 + f2 & 0xFF00FF00 | (col & 0xFF00) * isz2 + f22 & 0xFF0000) >>> 8;
                    }
                    if ((col = tex[((v += dv) >>> 12 << widthBIT) + ((u += du) >>> 12) & lengthBIT]) != 0) {
                        rgb[x1 + 2] = ((col & 0xFF00FF) * isz2 + f2 & 0xFF00FF00 | (col & 0xFF00) * isz2 + f22 & 0xFF0000) >>> 8;
                    }
                    x1 += 3;
                }
                while (x1 < x2) {
                    col = tex[((v += dv) >>> 12 << widthBIT) + ((u += du) >>> 12) & lengthBIT];
                    if (col != 0) {
                        rgb[x1] = ((col & 0xFF00FF) * isz2 + f2 & 0xFF00FF00 | (col & 0xFF00) * isz2 + f22 & 0xFF0000) >>> 8;
                    }
                    ++x1;
                }
            }
            x_start += dx_start;
            wz_start += dwz_start;
            uz_start += duz_start;
            vz_start += dvz_start;
            x_end += dx_end;
            wz_end += dwz_end;
            uz_end += duz_end;
            vz_end += dvz_end;
        }
    }

    static final void paintFloor_4(DirectX7 g3d, Texture texture, int y_start, int y_end, int x_start, int wz_start, int uz_start, int vz_start, int x_end, int wz_end, int uz_end, int vz_end, int dx_start, int dwz_start, int duz_start, int dvz_start, int dx_end, int dwz_end, int duz_end, int dvz_end, int dwz, int duz, int dvz) {
        int[] tex = texture.rImg.img;
        int lengthBIT = tex.length - 1;
        int widthBIT = texture.rImg.widthBIT;
        int[] rgb = g3d.display;
        int dv = 0;
        int du = 0;
        for (int y = y_start; y < y_end; ++y) {
            int x1 = x_start;
            int x2 = x_end;
            int uz_a = uz_start;
            int uz_b = uz_end;
            int vz_a = vz_start;
            int vz_b = vz_end;
            int wz_a = wz_start;
            int wz_b = wz_end;
            long subtexel_a = x1 % 4096;
            long subtexel_b = x2 % 4096;
            uz_a = (int)((long)uz_a - ((long)duz * subtexel_a >> 12));
            vz_a = (int)((long)vz_a - ((long)dvz * subtexel_a >> 12));
            wz_a = (int)((long)wz_a - ((long)dwz * subtexel_a >> 12));
            uz_b = (int)((long)uz_b - ((long)duz * subtexel_b >> 12));
            vz_b = (int)((long)vz_b - ((long)dvz * subtexel_b >> 12));
            wz_b = (int)((long)wz_b - ((long)dwz * subtexel_b >> 12));
            x2 >>= 12;
            if ((x1 >>= 12) < 0) {
                uz_a -= duz * x1;
                vz_a -= dvz * x1;
                wz_a -= dwz * x1;
                x1 = 0;
            }
            if (x2 > g3d.width) {
                uz_b -= duz * (x2 -= g3d.width);
                vz_b -= dvz * x2;
                wz_b -= dwz * x2;
                x2 = g3d.width;
            }
            if (wz_a == 0 || wz_b == 0) {
                return;
            }
            int tempI = y * g3d.width;
            int length = (x2 += tempI) - (x1 += tempI);
            if (length != 0) {
                int cols;
                int ca;
                int col;
                int u = (int)(((long)uz_a << 12) / (long)wz_a);
                int v = (int)(((long)vz_a << 12) / (long)wz_a);
                du = ((int)(((long)uz_b << 12) / (long)wz_b) - u) / length;
                dv = ((int)(((long)vz_b << 12) / (long)wz_b) - v) / length;
                while (x2 - x1 >= 2) {
                    col = tex[((v += dv) >>> 12 << widthBIT) + ((u += du) >>> 12) & lengthBIT];
                    if (col != 0) {
                        ca = col >>> 24;
                        cols = rgb[x1];
                        rgb[x1] = ((col & 0xFF00FF) * ca + (cols & 0xFF00FF) * (255 - ca) & 0xFF00FF00 | (col & 0xFF00) * ca + (cols & 0xFF00) * (255 - ca) & 0xFF0000) >>> 8;
                    }
                    if ((col = tex[((v += dv) >>> 12 << widthBIT) + ((u += du) >>> 12) & lengthBIT]) != 0) {
                        ca = col >>> 24;
                        cols = rgb[x1 + 1];
                        rgb[x1 + 1] = ((col & 0xFF00FF) * ca + (cols & 0xFF00FF) * (255 - ca) & 0xFF00FF00 | (col & 0xFF00) * ca + (cols & 0xFF00) * (255 - ca) & 0xFF0000) >>> 8;
                    }
                    x1 += 2;
                }
                while (x1 < x2) {
                    col = tex[((v += dv) >>> 12 << widthBIT) + ((u += du) >>> 12) & lengthBIT];
                    if (col != 0) {
                        ca = col >>> 24;
                        cols = rgb[x1];
                        rgb[x1] = ((col & 0xFF00FF) * ca + (cols & 0xFF00FF) * (255 - ca) & 0xFF00FF00 | (col & 0xFF00) * ca + (cols & 0xFF00) * (255 - ca) & 0xFF0000) >>> 8;
                    }
                    ++x1;
                }
            }
            x_start += dx_start;
            wz_start += dwz_start;
            uz_start += duz_start;
            vz_start += dvz_start;
            x_end += dx_end;
            wz_end += dwz_end;
            uz_end += duz_end;
            vz_end += dvz_end;
        }
    }

    static final void paintFloor_3_HQ(DirectX7 g3d, Texture texture, int y_start, int y_end, int x_start, int wz_start, int uz_start, int vz_start, int x_end, int wz_end, int uz_end, int vz_end, int dx_start, int dwz_start, int duz_start, int dvz_start, int dx_end, int dwz_end, int duz_end, int dvz_end, int dwz, int duz, int dvz, Vertex a, Vertex b, Vertex c, int f_start, int f_end, int df_start, int df_end, int df) {
        int[] tex = texture.rImg.img;
        int lengthBIT = tex.length - 1;
        int widthBIT = texture.rImg.widthBIT;
        int[] rgb = g3d.display;
        int fogcolor = DirectX7.fogc;
        int fogcolor2 = fogcolor & 0xFF00;
        fogcolor &= 0xFF00FF;
        for (int y = y_start; y < y_end; ++y) {
            int x1 = x_start;
            int x2 = x_end;
            int uz_a = uz_start;
            int uz_b = uz_end;
            int vz_a = vz_start;
            int vz_b = vz_end;
            int wz_a = wz_start;
            int wz_b = wz_end;
            int f = f_start;
            long subtexel_a = x1 % 4096;
            long subtexel_b = x2 % 4096;
            uz_a = (int)((long)uz_a - ((long)duz * subtexel_a >> 12));
            vz_a = (int)((long)vz_a - ((long)dvz * subtexel_a >> 12));
            wz_a = (int)((long)wz_a - ((long)dwz * subtexel_a >> 12));
            uz_b = (int)((long)uz_b - ((long)duz * subtexel_b >> 12));
            vz_b = (int)((long)vz_b - ((long)dvz * subtexel_b >> 12));
            wz_b = (int)((long)wz_b - ((long)dwz * subtexel_b >> 12));
            x2 >>= 12;
            if ((x1 >>= 12) < 0) {
                uz_a -= duz * x1;
                vz_a -= dvz * x1;
                wz_a -= dwz * x1;
                f -= df * x1;
                x1 = 0;
            }
            if (x2 > g3d.width) {
                uz_b -= duz * (x2 -= g3d.width);
                vz_b -= dvz * x2;
                wz_b -= dwz * x2;
                x2 = g3d.width;
            }
            int tempI = y * g3d.width;
            int length = (x2 += tempI) - (x1 += tempI);
            if (wz_a == 0) {
                return;
            }
            if (length > 0) {
                int col;
                int u = (int)(((long)uz_a << 12) / (long)wz_a);
                int v = (int)(((long)vz_a << 12) / (long)wz_a);
                int du = ((int)(((long)uz_b << 12) / (long)wz_b) - u) / length;
                int dv = ((int)(((long)vz_b << 12) / (long)wz_b) - v) / length;
                int isz2 = f >>> 12;
                int isz = 255 - isz2;
                int c1 = fogcolor * isz;
                int c2 = fogcolor2 * isz;
                while (x2 - x1 >= 2) {
                    col = tex[((v += dv) >>> 12 << widthBIT) + ((u += du) >>> 12) & lengthBIT];
                    if (col != 0) {
                        rgb[x1] = ((col & 0xFF00FF) * isz2 + c1 & 0xFF00FF00 | (col & 0xFF00) * isz2 + c2 & 0xFF0000) >>> 8;
                    }
                    if ((col = tex[((v += dv) >>> 12 << widthBIT) + ((u += du) >>> 12) & lengthBIT]) != 0) {
                        rgb[x1 + 1] = ((col & 0xFF00FF) * isz2 + c1 & 0xFF00FF00 | (col & 0xFF00) * isz2 + c2 & 0xFF0000) >>> 8;
                    }
                    x1 += 2;
                }
                while (x1 < x2) {
                    col = tex[((v += dv) >>> 12 << widthBIT) + ((u += du) >>> 12) & lengthBIT];
                    if (col != 0) {
                        rgb[x1] = ((col & 0xFF00FF) * isz2 + c1 & 0xFF00FF00 | (col & 0xFF00) * isz2 + c2 & 0xFF0000) >>> 8;
                    }
                    ++x1;
                }
            }
            x_start += dx_start;
            wz_start += dwz_start;
            uz_start += duz_start;
            vz_start += dvz_start;
            f_start += df_start;
            x_end += dx_end;
            wz_end += dwz_end;
            uz_end += duz_end;
            vz_end += dvz_end;
        }
    }

    static final void paintFloor_6_HQ(DirectX7 g3d, Texture texture, int y_start, int y_end, int x_start, int wz_start, int uz_start, int vz_start, int x_end, int wz_end, int uz_end, int vz_end, int dx_start, int dwz_start, int duz_start, int dvz_start, int dx_end, int dwz_end, int duz_end, int dvz_end, int dwz, int duz, int dvz, Vertex a, Vertex b, Vertex c, int f_start, int f_end, int df_start, int df_end, int df) {
        int[] tex = texture.rImg.img;
        int lengthBIT = tex.length - 1;
        int widthBIT = texture.rImg.widthBIT;
        int[] rgb = g3d.display;
        if (df > 0) {
            --df;
        }
        if (df < 0) {
            ++df;
        }
        for (int y = y_start; y < y_end; ++y) {
            int x1 = x_start;
            int x2 = x_end;
            int uz_a = uz_start;
            int uz_b = uz_end;
            int vz_a = vz_start;
            int vz_b = vz_end;
            int wz_a = wz_start;
            int wz_b = wz_end;
            int f = f_start;
            long subtexel_a = x1 % 4096;
            long subtexel_b = x2 % 4096;
            uz_a = (int)((long)uz_a - ((long)duz * subtexel_a >> 12));
            vz_a = (int)((long)vz_a - ((long)dvz * subtexel_a >> 12));
            wz_a = (int)((long)wz_a - ((long)dwz * subtexel_a >> 12));
            uz_b = (int)((long)uz_b - ((long)duz * subtexel_b >> 12));
            vz_b = (int)((long)vz_b - ((long)dvz * subtexel_b >> 12));
            wz_b = (int)((long)wz_b - ((long)dwz * subtexel_b >> 12));
            x2 >>= 12;
            if ((x1 >>= 12) < 0) {
                uz_a -= duz * x1;
                vz_a -= dvz * x1;
                wz_a -= dwz * x1;
                f -= df * x1;
                x1 = 0;
            }
            if (x2 > g3d.width) {
                uz_b -= duz * (x2 -= g3d.width);
                vz_b -= dvz * x2;
                wz_b -= dwz * x2;
                x2 = g3d.width;
            }
            int tempI = y * g3d.width;
            int length = (x2 += tempI) - (x1 += tempI);
            if (wz_a == 0) {
                return;
            }
            if (length > 0) {
                int col;
                int u = (int)(((long)uz_a << 12) / (long)wz_a);
                int v = (int)(((long)vz_a << 12) / (long)wz_a);
                int du = ((int)(((long)uz_b << 12) / (long)wz_b) - u) / length;
                int dv = ((int)(((long)vz_b << 12) / (long)wz_b) - v) / length;
                int isz2 = f >> 12;
                if (isz2 < 0) {
                    isz2 = 0;
                }
                while (x2 - x1 >= 2) {
                    col = tex[((v += dv) >>> 12 << widthBIT) + ((u += du) >>> 12) & lengthBIT];
                    if (col != 0) {
                        rgb[x1] = ((col & 0xFF00FF) * isz2 & 0xFF00FF00 | (col & 0xFF00) * isz2 & 0xFF0000) >>> 8;
                    }
                    if ((col = tex[((v += dv) >>> 12 << widthBIT) + ((u += du) >>> 12) & lengthBIT]) != 0) {
                        rgb[x1 + 1] = ((col & 0xFF00FF) * isz2 & 0xFF00FF00 | (col & 0xFF00) * isz2 & 0xFF0000) >>> 8;
                    }
                    x1 += 2;
                }
                while (x1 < x2) {
                    col = tex[((v += dv) >>> 12 << widthBIT) + ((u += du) >>> 12) & lengthBIT];
                    if (col != 0) {
                        rgb[x1] = ((col & 0xFF00FF) * isz2 & 0xFF00FF00 | (col & 0xFF00) * isz2 & 0xFF0000) >>> 8;
                    }
                    ++x1;
                }
            }
            x_start += dx_start;
            wz_start += dwz_start;
            uz_start += duz_start;
            vz_start += dvz_start;
            f_start += df_start;
            x_end += dx_end;
            wz_end += dwz_end;
            uz_end += duz_end;
            vz_end += dvz_end;
        }
    }

    static final void paintFloor_9_HQ(DirectX7 g3d, Texture texture, int y_start, int y_end, int x_start, int wz_start, int uz_start, int vz_start, int x_end, int wz_end, int uz_end, int vz_end, int dx_start, int dwz_start, int duz_start, int dvz_start, int dx_end, int dwz_end, int duz_end, int dvz_end, int dwz, int duz, int dvz, Vertex a, Vertex b, Vertex c, int f_start, int f_end, int df_start, int df_end, int df) {
        int[] tex = texture.rImg.img;
        int lengthBIT = tex.length - 1;
        int widthBIT = texture.rImg.widthBIT;
        int[] rgb = g3d.display;
        if (df > 0) {
            --df;
        }
        if (df < 0) {
            ++df;
        }
        for (int y = y_start; y < y_end; ++y) {
            int x1 = x_start;
            int x2 = x_end;
            int uz_a = uz_start;
            int uz_b = uz_end;
            int vz_a = vz_start;
            int vz_b = vz_end;
            int wz_a = wz_start;
            int wz_b = wz_end;
            int f = f_start;
            long subtexel_a = x1 % 4096;
            long subtexel_b = x2 % 4096;
            uz_a = (int)((long)uz_a - ((long)duz * subtexel_a >> 12));
            vz_a = (int)((long)vz_a - ((long)dvz * subtexel_a >> 12));
            wz_a = (int)((long)wz_a - ((long)dwz * subtexel_a >> 12));
            uz_b = (int)((long)uz_b - ((long)duz * subtexel_b >> 12));
            vz_b = (int)((long)vz_b - ((long)dvz * subtexel_b >> 12));
            wz_b = (int)((long)wz_b - ((long)dwz * subtexel_b >> 12));
            x2 >>= 12;
            if ((x1 >>= 12) < 0) {
                uz_a -= duz * x1;
                vz_a -= dvz * x1;
                wz_a -= dwz * x1;
                f -= df * x1;
                x1 = 0;
            }
            if (x2 > g3d.width) {
                uz_b -= duz * (x2 -= g3d.width);
                vz_b -= dvz * x2;
                wz_b -= dwz * x2;
                x2 = g3d.width;
            }
            int tempI = y * g3d.width;
            int length = (x2 += tempI) - (x1 += tempI);
            if (f < 0) {
                f = 0;
            }
            int df2 = df;
            if (f + df * length < 0) {
                df2 = (0 - f) / length;
            }
            if (wz_a == 0) {
                return;
            }
            if (length > 0) {
                int isz2;
                int col;
                int u = (int)(((long)uz_a << 12) / (long)wz_a);
                int du = ((int)(((long)uz_b << 12) / (long)wz_b) - u) / length;
                int v = (int)(((long)vz_a << 12) / (long)wz_a);
                int dv = ((int)(((long)vz_b << 12) / (long)wz_b) - v) / length;
                while (x2 - x1 >= 2) {
                    col = tex[((v += dv) >>> 12 << widthBIT) + ((u += du) >>> 12) & lengthBIT];
                    if (col != 0) {
                        isz2 = (f += df2) >>> 12;
                        rgb[x1] = ((col & 0xFF00FF) * isz2 & 0xFF00FF00 | (col & 0xFF00) * isz2 & 0xFF0000) >>> 8;
                    }
                    if ((col = tex[((v += dv) >>> 12 << widthBIT) + ((u += du) >>> 12) & lengthBIT]) != 0) {
                        isz2 = (f += df2) >>> 12;
                        rgb[x1 + 1] = ((col & 0xFF00FF) * isz2 & 0xFF00FF00 | (col & 0xFF00) * isz2 & 0xFF0000) >>> 8;
                    }
                    x1 += 2;
                }
                while (x1 < x2) {
                    col = tex[((v += dv) >>> 12 << widthBIT) + ((u += du) >>> 12) & lengthBIT];
                    if (col != 0) {
                        isz2 = (f += df2) >>> 12;
                        rgb[x1] = ((col & 0xFF00FF) * isz2 & 0xFF00FF00 | (col & 0xFF00) * isz2 & 0xFF0000) >>> 8;
                    }
                    ++x1;
                }
            }
            x_start += dx_start;
            wz_start += dwz_start;
            uz_start += duz_start;
            vz_start += dvz_start;
            f_start += df_start;
            x_end += dx_end;
            wz_end += dwz_end;
            uz_end += duz_end;
            vz_end += dvz_end;
        }
    }

    static final void paintFloor_13(DirectX7 g3d, Texture texture, int y_start, int y_end, int x_start, int wz_start, int uz_start, int vz_start, int x_end, int wz_end, int uz_end, int vz_end, int dx_start, int dwz_start, int duz_start, int dvz_start, int dx_end, int dwz_end, int duz_end, int dvz_end, int dwz, int duz, int dvz, Vertex a, Vertex b, Vertex c, int r_start, int r_end, int dr_start, int dr_end, int dr, int g_start, int g_end, int dg_start, int dg_end, int dg, int b_start, int b_end, int db_start, int db_end, int db) {
        int[] tex = texture.rImg.img;
        int lengthBIT = tex.length - 1;
        int widthBIT = texture.rImg.widthBIT;
        int[] rgb = g3d.display;
        for (int y = y_start; y < y_end; ++y) {
            int x1 = x_start;
            int x2 = x_end;
            int uz_a = uz_start;
            int uz_b = uz_end;
            int vz_a = vz_start;
            int vz_b = vz_end;
            int wz_a = wz_start;
            int wz_b = wz_end;
            int rC = r_start;
            int gC = g_start;
            int bC = b_start;
            long subtexel_a = x1 % 4096;
            long subtexel_b = x2 % 4096;
            uz_a = (int)((long)uz_a - ((long)duz * subtexel_a >> 12));
            vz_a = (int)((long)vz_a - ((long)dvz * subtexel_a >> 12));
            wz_a = (int)((long)wz_a - ((long)dwz * subtexel_a >> 12));
            uz_b = (int)((long)uz_b - ((long)duz * subtexel_b >> 12));
            vz_b = (int)((long)vz_b - ((long)dvz * subtexel_b >> 12));
            wz_b = (int)((long)wz_b - ((long)dwz * subtexel_b >> 12));
            x2 >>= 12;
            if ((x1 >>= 12) < 0) {
                uz_a -= duz * x1;
                vz_a -= dvz * x1;
                wz_a -= dwz * x1;
                rC -= dr * x1;
                gC -= dg * x1;
                bC -= db * x1;
                x1 = 0;
            }
            if (x2 > g3d.width) {
                uz_b -= duz * (x2 -= g3d.width);
                vz_b -= dvz * x2;
                wz_b -= dwz * x2;
                x2 = g3d.width;
            }
            int tempI = y * g3d.width;
            int length = (x2 += tempI) - (x1 += tempI);
            if (rC < 0) {
                rC = 0;
            }
            if (gC < 0) {
                gC = 0;
            }
            if (bC < 0) {
                bC = 0;
            }
            int dr2 = dr;
            int dg2 = dg;
            int db2 = db;
            if (rC + dr * length < 0) {
                dr2 = (0 - rC) / length;
            }
            if (gC + dg * length < 0) {
                dg2 = (0 - gC) / length;
            }
            if (bC + db * length < 0) {
                db2 = (0 - bC) / length;
            }
            if (wz_a == 0) {
                return;
            }
            if (length > 0) {
                int u = (int)(((long)uz_a << 12) / (long)wz_a);
                int du = ((int)(((long)uz_b << 12) / (long)wz_b) - u) / length;
                int v = (int)(((long)vz_a << 12) / (long)wz_a);
                int dv = ((int)(((long)vz_b << 12) / (long)wz_b) - v) / length;
                while (x1 < x2) {
                    int col = tex[((v += dv) >>> 12 << widthBIT) + ((u += du) >>> 12) & lengthBIT];
                    if (col != 0) {
                        rgb[x1] = ((col & 0xFF0000) * ((rC += dr2) >>> 12) & 0xFF000000 | (col & 0xFF00) * ((gC += dg2) >>> 12) & 0xFF0000 | (col & 0xFF) * ((bC += db2) >>> 12)) >>> 8;
                    }
                    ++x1;
                }
            }
            x_start += dx_start;
            wz_start += dwz_start;
            uz_start += duz_start;
            vz_start += dvz_start;
            r_start += dr_start;
            g_start += dg_start;
            b_start += db_start;
            x_end += dx_end;
            wz_end += dwz_end;
            uz_end += duz_end;
            vz_end += dvz_end;
        }
    }
}

