/*
 * Decompiled with CFR 0.152.
 */
package com.Math;

import com.Math.Matrix;
import com.Rendering.Fps;

public final class Vector3D {
    public int x;
    public int y;
    public int z;

    public Vector3D() {
    }

    public Vector3D(int x, int y, int z) {
        this.x = x;
        this.y = y;
        this.z = z;
    }

    public Vector3D(int[] ps) {
        if (ps.length >= 3) {
            this.x = ps[0];
            this.y = ps[1];
            this.z = ps[2];
        } else {
            this.z = 0;
            this.y = 0;
            this.x = 0;
        }
    }

    public final void set(int x, int y, int z) {
        this.x = x;
        this.y = y;
        this.z = z;
    }

    public final void add(int x, int y, int z) {
        this.x += x;
        this.y += y;
        this.z += z;
    }

    public final void div(int x, int y, int z) {
        this.x /= x;
        this.y /= y;
        this.z /= z;
    }

    public final void mul(int x, int y, int z) {
        this.x *= x;
        this.y *= y;
        this.z *= z;
    }

    public final void set(Vector3D v) {
        this.x = v.x;
        this.y = v.y;
        this.z = v.z;
    }

    public int length() {
        return (int)Math.sqrt(this.x * this.x + this.y * this.y + this.z * this.z);
    }

    public int lengthSquared() {
        return this.x * this.x + this.y * this.y + this.z * this.z;
    }

    public final void setLength(int len) {
        int dist = this.x * this.x + this.y * this.y + this.z * this.z;
        if (dist != len * len) {
            while (Math.abs(this.x) + Math.abs(this.y) + Math.abs(this.z) > 30000) {
                this.x /= 2;
                this.y /= 2;
                this.z /= 2;
            }
            double sqr = Math.sqrt(this.x * this.x + this.y * this.y + this.z * this.z);
            this.x = (int)((double)this.x / sqr * (double)len);
            this.y = (int)((double)this.y / sqr * (double)len);
            this.z = (int)((double)this.z / sqr * (double)len);
        }
    }

    public final void setLength2(int len) {
        if (len == 0) {
            this.z = 0;
            this.y = 0;
            this.x = 0;
            return;
        }
        int oldlen = Math.max(Math.max(Math.abs(this.x), Math.abs(this.y)), Math.abs(this.z));
        if (oldlen == 0) {
            System.out.println("Cant set vector length: old length is zero");
        }
        if (oldlen == 0) {
            return;
        }
        this.x = this.x * len / oldlen;
        this.y = this.y * len / oldlen;
        this.z = this.z * len / oldlen;
    }

    public void interpolation(Vector3D v, int s) {
        this.x += (v.x - this.x) * 50 / s / Fps.frameTime;
        this.y += (v.y - this.y) * 50 / s / Fps.frameTime;
        this.z += (v.z - this.z) * 50 / s / Fps.frameTime;
    }

    public int dot(Vector3D v) {
        return this.x * v.x + this.y * v.y + this.z * v.z;
    }

    public long dotLong(Vector3D v) {
        return (long)this.x * (long)v.x + (long)(this.y * v.y) + (long)(this.z * v.z);
    }

    public void cross(Vector3D vector3f, Vector3D vector3f1) {
        this.x = (int)((float)(vector3f.y * vector3f1.z / 32768 - vector3f1.y * vector3f.z / 32768));
        this.y = (int)((float)(vector3f.z * vector3f1.x / 32768 - vector3f1.z * vector3f.x / 32768));
        this.z = (int)((float)(vector3f.x * vector3f1.y / 32768 - vector3f1.x * vector3f.y / 32768));
    }

    public void cross(Vector3D a, Vector3D b, int fp) {
        this.x = a.y * b.z - b.y * a.z >> fp;
        this.y = a.z * b.x - b.z * a.x >> fp;
        this.z = a.x * b.y - b.x * a.y >> fp;
    }

    public void mul(Matrix matrix) {
        int m00 = matrix.m00 >> 2;
        int m01 = matrix.m01 >> 2;
        int m02 = matrix.m02 >> 2;
        int m03 = matrix.m03;
        int m10 = matrix.m10 >> 2;
        int m11 = matrix.m11 >> 2;
        int m12 = matrix.m12 >> 2;
        int m13 = matrix.m13;
        int m20 = matrix.m20 >> 2;
        int m21 = matrix.m21 >> 2;
        int m22 = matrix.m22 >> 2;
        int m23 = matrix.m23;
        int fp = 12;
        this.x = m03;
        if (m00 != 0) {
            this.x += this.x * m00 >> 12;
        }
        if (m01 != 0) {
            this.x += this.y * m01 >> 12;
        }
        if (m02 != 0) {
            this.x += this.z * m02 >> 12;
        }
        this.y = -m13;
        if (m10 != 0) {
            this.y -= this.x * m10 >> 12;
        }
        if (m11 != 0) {
            this.y -= this.y * m11 >> 12;
        }
        if (m12 != 0) {
            this.y -= this.z * m12 >> 12;
        }
        this.z = m23;
        if (m20 != 0) {
            this.z += this.x * m20 >> 12;
        }
        if (m21 != 0) {
            this.z += this.y * m21 >> 12;
        }
        if (m22 != 0) {
            this.z += this.z * m22 >> 12;
        }
    }

    public final String toString() {
        return this.x + " " + this.y + " " + this.z;
    }

    public int average() {
        return (this.x + this.y + this.z) / 3;
    }
}

