/*
 * Decompiled with CFR 0.152.
 */
package code.Gameplay.Map;

import code.AI.Bot;
import code.AI.NPC;
import code.AI.Player;
import code.Gameplay.GameScreen;
import code.Gameplay.Inventory.ItemsEngine;
import code.Gameplay.Map.House;
import code.Gameplay.Map.Room;
import code.Gameplay.Objects.GameObject;
import code.Gameplay.Objects.MeshObject;
import code.Gameplay.Objects.SpriteObject;
import code.HUD.Base.TextView;
import code.Math.Vector3D;
import code.Rendering.DirectX7;
import code.Rendering.Vertex;
import code.utils.DelayedDialog;
import code.utils.GameIni;
import code.utils.Main;
import code.utils.StringTools;
import code.utils.WeaponCreator;
import java.util.Random;
import java.util.Vector;
import javax.microedition.lcdui.Graphics;

public abstract class RoomObject {
    private static Random rand = new Random();
    private static final Vertex vert = new Vertex();
    private int oldX;
    private int oldZ;
    private int oldY;
    private int part = -1;
    private int toPart = -1;
    public boolean activable = false;
    public boolean clickable = false;
    public boolean singleUse = false;
    public boolean destroyOnUse = false;
    public boolean alwaysActivate = false;
    public String desc = null;
    public String name = null;
    public String sound = null;
    public String[] need = null;
    public String[] additional = null;
    public String errMessage = null;
    public String message = null;
    public boolean hideWhenUnusable = false;
    public long lastActivate = -1L;
    public long timeToReset = 0L;
    public long radius = 4000L;
    public long messageTimeOut = -1L;
    public int messageType = 0;
    public int pointRadius = 150;
    public int pointHeight = 150;
    public Vector3D pointOffset = null;
    public boolean needToPoint = false;
    public boolean squarePoint = false;
    public boolean dynamicPoint = false;
    public boolean visible = true;
    public boolean activateOnlyOne = false;
    public boolean reloadDestroy = true;
    public long errMessageTimeOut = -1L;
    public long errMessageDelay = 0L;
    public long messageDelay = 0L;
    public int errMessageType = 0;
    public boolean near = true;
    public boolean activated = false;

    public abstract void render(DirectX7 var1, int var2, int var3, int var4, int var5);

    public final int getPart() {
        return this.part;
    }

    public final void setPart(int part) {
        this.part = part;
    }

    public final int getNewPart() {
        return this.toPart;
    }

    public final void setNewPart(int toPart) {
        this.toPart = toPart;
    }

    public abstract int getPosX();

    public abstract int getPosZ();

    public abstract int getPosY();

    public abstract void setPos(int var1, int var2, int var3);

    protected boolean isNeedRecomputePart() {
        int x = this.getPosX();
        int z = this.getPosZ();
        int y = this.getPosY();
        if (this.oldX != x || this.oldZ != z || this.oldY != y || this.part == -1) {
            this.oldX = x;
            this.oldZ = z;
            this.oldY = y;
            return true;
        }
        return false;
    }

    public boolean isAllCollected(Vector points, Player player, House house, GameScreen gs) {
        if (this.need == null) {
            return true;
        }
        for (int i = 0; i < this.need.length; ++i) {
            if (RoomObject.containsCollected(points, this.need[i], player, house, gs, this)) continue;
            return false;
        }
        return true;
    }

    public static boolean contains(int[] in, int[] check) {
        if (in == null || check == null) {
            return false;
        }
        for (int i = 0; i < check.length; ++i) {
            int need = check[i];
            boolean contains = false;
            for (int x = 0; x < in.length || contains; ++x) {
                if (in[x] != need) continue;
                contains = true;
            }
            if (contains) continue;
            return false;
        }
        return true;
    }

    public static boolean containsCollected(Vector points, String name, Player player, House house, GameScreen gs, RoomObject th) {
        if (name != null) {
            String hcName;
            boolean inverse = false;
            if (name.indexOf(33) == 0) {
                inverse = true;
                name = name.substring(1, name.length());
            }
            if ((hcName = name.toUpperCase()).indexOf("WEAPON_") == 0) {
                int i = StringTools.parseInt(name.substring(7, name.length()));
                if (player.arsenal.weapons[i] != null) {
                    return !inverse;
                }
            } else {
                if (hcName.indexOf(61) != -1 || hcName.indexOf(62) != -1 || hcName.indexOf(60) != -1) {
                    int charind = hcName.indexOf(61);
                    if (charind == -1) {
                        charind = hcName.indexOf(62);
                    }
                    if (charind == -1) {
                        charind = hcName.indexOf(60);
                    }
                    char operator = hcName.charAt(charind);
                    char operator2 = hcName.charAt(charind - 1);
                    int var1 = operator2 == '>' || operator2 == '<' ? RoomObject.readVar(name.substring(0, charind - 1), player, house, gs, th) : RoomObject.readVar(name.substring(0, charind), player, house, gs, th);
                    int var2 = RoomObject.readVar(name.substring(charind + 1, name.length()), player, house, gs, th);
                    if (operator == '=' && operator2 == '>' && var1 >= var2) {
                        return !inverse;
                    }
                    if (operator == '=' && operator2 == '<' && var1 <= var2) {
                        return !inverse;
                    }
                    if (operator == '=' && var1 == var2) {
                        return !inverse;
                    }
                    if (operator == '>' && var1 > var2) {
                        return !inverse;
                    }
                    if (operator == '<' && var1 < var2) {
                        return !inverse;
                    }
                    return inverse;
                }
                if (hcName.equals("FALSE")) {
                    return inverse;
                }
                if (hcName.equals("TRUE")) {
                    return !inverse;
                }
                for (int i = 0; i < points.size(); ++i) {
                    String pName = (String)points.elementAt(i);
                    if (pName == null || !pName.equals(name)) continue;
                    return !inverse;
                }
            }
            return inverse;
        }
        return false;
    }

    public boolean contains(Vector points, String name) {
        if (name != null) {
            if (!this.singleUse) {
                return false;
            }
            boolean inverse = true;
            if (name.indexOf(33) == 0) {
                inverse = false;
                name = name.substring(1, name.length());
            }
            for (int i = 0; i < points.size(); ++i) {
                String pName = (String)points.elementAt(i);
                if (pName == null || !pName.equals(name)) continue;
                return inverse;
            }
            return !inverse;
        }
        return this.activated && this.singleUse;
    }

    public static boolean containsSimple(Vector points, String name) {
        if (name == null) {
            return false;
        }
        boolean inverse = true;
        if (name.indexOf(33) == 0) {
            inverse = false;
            name = name.substring(1, name.length());
        }
        for (int i = 0; i < points.size(); ++i) {
            String pName = (String)points.elementAt(i);
            if (pName == null || !pName.equals(name)) continue;
            return inverse;
        }
        return !inverse;
    }

    public void give(String[] name, Player player, House house, GameScreen gs) {
        if (name == null) {
            return;
        }
        for (int num = 0; num < name.length; ++num) {
            boolean inverse = false;
            String newName = name[num];
            if (newName == null) continue;
            if (newName.indexOf(33) == 0) {
                inverse = true;
                newName = newName.substring(1, newName.length());
            }
            String hcName = newName.toUpperCase();
            if (newName.charAt(0) == '{') {
                int counter = 1;
                for (int num2 = num + 1; num2 < name.length; ++num2) {
                    if (name[num2].charAt(0) == '}') {
                        if (--counter != 0) continue;
                        num = num2;
                        continue;
                    }
                    if (name[num2].charAt(0) != '{') continue;
                    ++counter;
                }
                continue;
            }
            if (newName.charAt(0) == '}') continue;
            if (hcName.indexOf("WEAPON_") == 0) {
                int i = RoomObject.readVar(newName.substring(7, newName.length()), player, house, gs, this);
                if (!inverse && player.arsenal.weapons[i] == null) {
                    player.arsenal.weapons[i] = WeaponCreator.createWeapon(i);
                    player.arsenal.weapons[i].setAmmo(0);
                    if (player.arsenal.current != -1 && player.arsenal.currentWeapon().getDamageValue() < player.arsenal.weapons[i].getDamageValue()) {
                        player.arsenal.current = i;
                    }
                }
                if (!inverse) continue;
                player.arsenal.weapons[i] = null;
                player.arsenal.next();
                continue;
            }
            if (hcName.equals("END_SCRIPT")) {
                return;
            }
            if (hcName.equals("REDRAW")) continue;
            if (hcName.equals("SAVE_GAME")) {
                if (gs.player.getHp() <= 0) continue;
                Main.saveGame(gs.levelNumber, player, gs.scene);
                Main.saveObjects(gs.levelNumber, player, gs.scene);
                continue;
            }
            if (hcName.indexOf("DROP_ITEM(") == 0) {
                String[] vars = StringTools.cutOnStrings(newName.substring(10, newName.length() - 1), ',');
                int x = RoomObject.readVar(vars[1], player, house, gs, this);
                int y = RoomObject.readVar(vars[2], player, house, gs, this);
                int z = RoomObject.readVar(vars[3], player, house, gs, this);
                int count = 1;
                if (vars.length >= 5) {
                    count = RoomObject.readVar(vars[4], player, house, gs, this);
                }
                gs.scene.dropItem(vars[0], count, x, y, z);
                return;
            }
            if (hcName.indexOf("LOAD_LEVEL(") == 0) {
                String[] vars = StringTools.cutOnStrings(newName.substring(11, newName.length() - 1), ',');
                Vector3D pos = new Vector3D(player.getPosX(), player.getPosY(), player.getPosZ());
                boolean saveMus = false;
                boolean fullMove = false;
                gs.newPos = pos;
                if (vars.length >= 4) {
                    gs.newPos = new Vector3D(RoomObject.readVar(vars[1], player, house, gs, this), RoomObject.readVar(vars[2], player, house, gs, this), RoomObject.readVar(vars[3], player, house, gs, this));
                }
                if (vars.length >= 5) {
                    player.rotYn(RoomObject.readVar(vars[4], player, house, gs, this));
                    player.updateMatrix();
                }
                if (vars.length >= 6) {
                    saveMus = RoomObject.readBoolean(vars[5], player, house, gs, this);
                }
                if (vars.length >= 7) {
                    fullMove = RoomObject.readBoolean(vars[6], player, house, gs, this);
                }
                gs.loadLevel(RoomObject.readVar(vars[0], player, house, gs, this), pos, !saveMus, fullMove);
                return;
            }
            if (hcName.indexOf("EXEC ") == 0) {
                gs.runScriptFromFile(newName.substring(5), this);
                continue;
            }
            if (hcName.indexOf("SHOW_MESSAGE(") == 0) {
                String[] vars = StringTools.cutOnStrings(newName.substring(13, newName.length() - 1), ',');
                String msg = RoomObject.readString(vars[0], player, house, gs, this);
                int time = RoomObject.readVar(vars[1], player, house, gs, this);
                int delay = 1;
                int type = 1;
                if (vars.length > 2) {
                    type = RoomObject.readVar(vars[2], player, house, gs, this);
                }
                GameScreen.delayDialogs.addElement(new DelayedDialog(time, type, msg, delay));
                continue;
            }
            if (hcName.indexOf("OPENTITLESCREEN()") == 0) {
                gs.openTitleScreenScript();
                return;
            }
            if (hcName.indexOf("REMOVEARSENAL()") == 0) {
                player.arsenal.removeAll();
                return;
            }
            if (hcName.indexOf("IF") == 0) {
                boolean i = RoomObject.readBoolean(newName.substring(2, newName.length()), player, house, gs, this);
                if (num == name.length - 1) continue;
                if (i) {
                    if (name[num + 1].charAt(0) != '{') continue;
                    ++num;
                    continue;
                }
                if (name[num + 1].charAt(0) == '{') continue;
                ++num;
                continue;
            }
            if (hcName.indexOf("MONEY") == 0) {
                if (newName.charAt(5) == '=') {
                    player.money = RoomObject.readVar(newName.substring(6, newName.length()), player, house, gs, this);
                    continue;
                }
                int i = RoomObject.readVar(newName.substring(7, newName.length()), player, house, gs, this);
                if (inverse) {
                    i *= -1;
                }
                if (newName.charAt(5) == '-') {
                    i *= -1;
                }
                player.money += i;
                continue;
            }
            if (hcName.indexOf("AMMO_") == 0) {
                String tmp = newName.substring(5, newName.length());
                int index = tmp.indexOf(61);
                int operation = 48;
                if (index - 1 >= 0) {
                    operation = tmp.charAt(index - 1);
                }
                boolean oper = false;
                if (operation == 43 || operation == 45) {
                    --index;
                    oper = true;
                }
                int weapon = RoomObject.readVar(tmp.substring(0, index), player, house, gs, this);
                if (!oper) {
                    player.arsenal.weapons[weapon].setAmmo(RoomObject.readVar(tmp.substring(index + 1, tmp.length()), player, house, gs, this));
                    continue;
                }
                int i = RoomObject.readVar(tmp.substring(index + 2, tmp.length()), player, house, gs, this);
                if (inverse) {
                    i *= -1;
                }
                if (operation == 45) {
                    i *= -1;
                }
                if (player.arsenal.weapons[weapon] == null) continue;
                player.arsenal.weapons[weapon].magazine.addAmmo(i);
                continue;
            }
            if (hcName.indexOf("FRAGS") == 0) {
                if (newName.charAt(4) == '=') {
                    player.frags = RoomObject.readVar(newName.substring(5, newName.length()), player, house, gs, this);
                    continue;
                }
                int i = RoomObject.readVar(newName.substring(6, newName.length()), player, house, gs, this);
                if (inverse) {
                    i *= -1;
                }
                if (newName.charAt(4) == '-') {
                    i *= -1;
                }
                player.frags += i;
                continue;
            }
            if (newName.indexOf(58) != -1) {
                String objname = newName.substring(0, newName.indexOf(58));
                String command = newName.substring(newName.indexOf(58) + 1, newName.length());
                String hcCommand = command.toUpperCase();
                Vector objs = house.getObjects();
                RoomObject obj = null;
                if (objname.equalsIgnoreCase("system")) {
                    RoomObject.getSetValueSystem(player, house, gs, command, inverse, true, null);
                    continue;
                }
                if (objname.equalsIgnoreCase("player")) {
                    obj = player;
                }
                if (objname.equalsIgnoreCase("self")) {
                    obj = this;
                }
                if (objs.size() > 0 && obj == null) {
                    for (int i = 0; i < objs.size(); ++i) {
                        if (((RoomObject)objs.elementAt((int)i)).name == null || !((RoomObject)objs.elementAt((int)i)).name.equals(objname)) continue;
                        obj = (RoomObject)objs.elementAt(i);
                    }
                }
                if (obj == null) continue;
                if (hcCommand.equals("ACTIVATE")) {
                    obj.activate(house, player, gs);
                    continue;
                }
                RoomObject.getSetValue(player, house, gs, obj, command, inverse, true, null, this);
                continue;
            }
            if (inverse) {
                Player.usedPoints.removeElement(newName);
            }
            if (inverse || RoomObject.containsSimple(Player.usedPoints, newName)) continue;
            Player.usedPoints.addElement(newName);
        }
    }

    public static int getSetValue(Player player, House house, GameScreen gs, RoomObject obj, String command, boolean inverse, boolean set, String buffer, RoomObject th) {
        if (obj == null) {
            return 0;
        }
        GameObject gobj = null;
        if (obj instanceof GameObject) {
            gobj = (GameObject)obj;
        }
        String hcCommand = command.toUpperCase();
        boolean toggle = false;
        if (hcCommand.indexOf("TOGGLE_") != -1) {
            toggle = true;
            hcCommand = hcCommand.substring(7, hcCommand.length());
            command = command.substring(7, command.length());
        }
        if (hcCommand.indexOf("HP") == 0 && obj instanceof GameObject) {
            GameObject obj2 = (GameObject)obj;
            if (!set) {
                return obj2.getHp() * (inverse ? -1 : 1);
            }
            if (hcCommand.charAt(2) == '=') {
                obj2.setHp(RoomObject.readVar(hcCommand.substring(3, hcCommand.length()), player, house, gs, th));
            } else {
                int i = RoomObject.readVar(hcCommand.substring(4, hcCommand.length()), player, house, gs, th);
                if (inverse) {
                    i *= -1;
                }
                if (hcCommand.charAt(2) == '-') {
                    i *= -1;
                }
                obj2.damage(-i);
            }
        } else {
            if (obj instanceof Player && hcCommand.indexOf("GIVE(") == 0) {
                String[] vars = StringTools.cutOnStrings(command.substring(5, command.length() - 1), ',');
                int count = 1;
                if (vars.length >= 2) {
                    count = RoomObject.readVar(vars[1], player, house, gs, th);
                }
                player.items.addItem(vars[0], count);
                String pckScript = ItemsEngine.items[ItemsEngine.getItemId(vars[0])].get("ON_GIVE");
                if (pckScript != null) {
                    gs.runScript(StringTools.cutOnStrings(pckScript, ';'));
                }
                return 1;
            }
            if (obj instanceof Player && hcCommand.indexOf("TAKE(") == 0) {
                String[] vars = StringTools.cutOnStrings(command.substring(5, command.length() - 1), ',');
                int count = 1;
                if (vars.length >= 2) {
                    count = RoomObject.readVar(vars[1], player, house, gs, th);
                }
                player.items.removeItem(vars[0], count);
                String rmsScript = ItemsEngine.items[ItemsEngine.getItemId(vars[0])].get("ON_TAKE");
                if (rmsScript != null) {
                    gs.runScript(StringTools.cutOnStrings(rmsScript, ';'));
                }
                return 1;
            }
            if (hcCommand.equals("FLASHLIGHT")) {
                if (!set) {
                    return (gs.scene.getG3D().flashlightEnabled ? !inverse : inverse) ? 1 : 0;
                }
                gs.scene.getG3D().flashlightEnabled = !toggle ? !inverse : (gs.scene.getG3D().flashlightEnabled ^= true);
            } else {
                if (obj instanceof Player && hcCommand.indexOf("ITEM_COUNT_") == 0) {
                    return player.items.itemsCount(command.substring(11, command.length()));
                }
                if (hcCommand.equals("ACTIVABLE")) {
                    if (!set) {
                        return (obj.activable ? !inverse : inverse) ? 1 : 0;
                    }
                    obj.activable = !toggle ? !inverse : (obj.activable ^= true);
                } else if (hcCommand.equals("CLICKABLE")) {
                    if (!set) {
                        return (obj.clickable ? !inverse : inverse) ? 1 : 0;
                    }
                    obj.clickable = !toggle ? !inverse : (obj.clickable ^= true);
                } else if (hcCommand.equals("SINGLEUSE")) {
                    if (!set) {
                        return (obj.singleUse ? !inverse : inverse) ? 1 : 0;
                    }
                    obj.singleUse = !toggle ? !inverse : (obj.singleUse ^= true);
                } else if (hcCommand.equals("DESTROYONUSE")) {
                    if (!set) {
                        return (obj.destroyOnUse ? !inverse : inverse) ? 1 : 0;
                    }
                    obj.destroyOnUse = !toggle ? !inverse : (obj.destroyOnUse ^= true);
                } else if (hcCommand.equals("HIDEWHENUNUSABLE")) {
                    if (!set) {
                        return (obj.hideWhenUnusable ? !inverse : inverse) ? 1 : 0;
                    }
                    obj.hideWhenUnusable = !toggle ? !inverse : (obj.hideWhenUnusable ^= true);
                } else if (hcCommand.indexOf("NEEDTOPOINT") == 0) {
                    int ntp = 0;
                    if (obj.needToPoint) {
                        ntp = 1;
                    }
                    if (obj.squarePoint) {
                        ntp = 2;
                    }
                    if (!set) {
                        return ntp;
                    }
                    if (hcCommand.charAt(11) == '=') {
                        ntp = RoomObject.readVar(command.substring(12, command.length()), player, house, gs, th);
                    } else {
                        int i = RoomObject.readVar(command.substring(13, command.length()), player, house, gs, th);
                        if (hcCommand.charAt(11) == '-') {
                            i *= -1;
                        }
                        if (inverse) {
                            i *= -1;
                        }
                        ntp += i;
                    }
                    if (ntp == 0) {
                        obj.needToPoint = false;
                        obj.squarePoint = false;
                    } else if (ntp == 1) {
                        obj.needToPoint = true;
                        obj.squarePoint = false;
                    } else {
                        obj.needToPoint = true;
                        obj.squarePoint = true;
                    }
                } else if (hcCommand.indexOf("X") == 0) {
                    if (!set) {
                        return obj.getPosX() * (inverse ? -1 : 1);
                    }
                    if (hcCommand.charAt(1) == '=') {
                        obj.setPos(RoomObject.readVar(command.substring(2, command.length()), player, house, gs, th), obj.getPosY(), obj.getPosZ());
                    } else {
                        int i = RoomObject.readVar(command.substring(3, command.length()), player, house, gs, th);
                        if (hcCommand.charAt(1) == '-') {
                            i *= -1;
                        }
                        if (inverse) {
                            i *= -1;
                        }
                        obj.setPos(obj.getPosX() + RoomObject.readVar(command.substring(2, command.length()), player, house, gs, th), obj.getPosY(), obj.getPosZ());
                    }
                } else if (hcCommand.indexOf("Y") == 0) {
                    if (!set) {
                        return obj.getPosY() * (inverse ? -1 : 1);
                    }
                    if (hcCommand.charAt(1) == '=') {
                        obj.setPos(obj.getPosX(), RoomObject.readVar(command.substring(2, command.length()), player, house, gs, th), obj.getPosZ());
                    } else {
                        int i = RoomObject.readVar(command.substring(3, command.length()), player, house, gs, th);
                        if (hcCommand.charAt(1) == '-') {
                            i *= -1;
                        }
                        if (inverse) {
                            i *= -1;
                        }
                        obj.setPos(obj.getPosX(), obj.getPosY() + RoomObject.readVar(command.substring(2, command.length()), player, house, gs, th), obj.getPosZ());
                    }
                } else if (hcCommand.indexOf("Z") == 0) {
                    if (!set) {
                        return obj.getPosZ() * (inverse ? -1 : 1);
                    }
                    if (hcCommand.charAt(1) == '=') {
                        obj.setPos(obj.getPosX(), obj.getPosY(), RoomObject.readVar(command.substring(2, command.length()), player, house, gs, th));
                    } else {
                        int i = RoomObject.readVar(command.substring(3, command.length()), player, house, gs, th);
                        if (hcCommand.charAt(1) == '-') {
                            i *= -1;
                        }
                        if (inverse) {
                            i *= -1;
                        }
                        obj.setPos(obj.getPosX(), obj.getPosY(), obj.getPosZ() + RoomObject.readVar(command.substring(2, command.length()), player, house, gs, th));
                    }
                } else if (hcCommand.equals("VISIBLE")) {
                    if (!set) {
                        return (obj.visible ? !inverse : inverse) ? 1 : 0;
                    }
                    obj.visible = !toggle ? !inverse : (obj.visible ^= true);
                } else if (hcCommand.indexOf("NAME") == 0) {
                    if (!set && buffer == null) {
                        return 0;
                    }
                    if (!set) {
                        buffer = obj.name;
                        return 0;
                    }
                    obj.name = RoomObject.readString(hcCommand.substring(5, hcCommand.length()), player, house, gs, th);
                } else if (hcCommand.indexOf("DESC") == 0) {
                    if (!set && buffer == null) {
                        return 0;
                    }
                    if (!set) {
                        buffer = obj.desc;
                        return 0;
                    }
                    obj.desc = RoomObject.readString(hcCommand.substring(5, hcCommand.length()), player, house, gs, th);
                } else if (hcCommand.indexOf("NEED") == 0) {
                    if (!set) {
                        return 0;
                    }
                    obj.need = GameIni.cutOnStrings(RoomObject.readString(hcCommand.substring(5, hcCommand.length()), player, house, gs, th), ',', ';');
                } else if (hcCommand.indexOf("SOUND") == 0) {
                    if (!set && buffer == null) {
                        return 0;
                    }
                    if (!set) {
                        buffer = obj.sound;
                        return 0;
                    }
                    obj.sound = RoomObject.readString(hcCommand.substring(6, hcCommand.length()), player, house, gs, th);
                } else if (hcCommand.indexOf("ERRMSG") == 0) {
                    if (!set && buffer == null) {
                        return 0;
                    }
                    if (!set) {
                        buffer = obj.errMessage;
                        return 0;
                    }
                    obj.errMessage = RoomObject.readString(hcCommand.substring(7, hcCommand.length()), player, house, gs, th);
                } else if (hcCommand.indexOf("MESSAGE") == 0) {
                    if (!set && buffer == null) {
                        return 0;
                    }
                    if (!set) {
                        buffer = obj.message;
                        return 0;
                    }
                    obj.sound = RoomObject.readString(hcCommand.substring(9, hcCommand.length()), player, house, gs, th);
                } else {
                    if (hcCommand.indexOf("ROOM") == 0 && !set) {
                        return obj.getPart();
                    }
                    if (hcCommand.indexOf("FOLLOW=") == 0 && obj instanceof NPC && set) {
                        NPC obj2 = (NPC)obj;
                        String str = RoomObject.readString(hcCommand.substring(7, hcCommand.length()), player, house, gs, th);
                        if (str == null) {
                            obj2.toFollow = null;
                        }
                        if (str != null && str.length() <= 0) {
                            obj2.toFollow = null;
                        }
                        if (str != null && str.length() > 0) {
                            String[] ntf = GameIni.cutOnStrings(str, ',', ';');
                            int[] toFollow = new int[ntf.length];
                            for (int i = 0; i < ntf.length; ++i) {
                                toFollow[i] = RoomObject.readVar(ntf[i], player, house, gs, th);
                            }
                            obj2.toFollow = toFollow;
                        }
                    } else {
                        if (hcCommand.indexOf("FOLLOWS(") == 0 && obj instanceof NPC && !set) {
                            NPC obj2 = (NPC)obj;
                            String[] ntf = GameIni.cutOnStrings(RoomObject.readString(hcCommand.substring(7, hcCommand.length() - 1), player, house, gs, th), ',', ';');
                            int[] needToFollow = new int[ntf.length];
                            for (int i = 0; i < ntf.length; ++i) {
                                needToFollow[i] = RoomObject.readVar(ntf[i], player, house, gs, th);
                            }
                            return RoomObject.contains(obj2.toFollow, needToFollow) ? 1 : 0;
                        }
                        if (hcCommand.indexOf("SPEED_X") == 0 && obj instanceof GameObject) {
                            if (!set) {
                                return gobj.character.speed.x * (inverse ? -1 : 1);
                            }
                            if (hcCommand.charAt(7) == '=') {
                                gobj.character.speed.x = RoomObject.readVar(command.substring(8, command.length()), player, house, gs, th);
                            } else {
                                int i = RoomObject.readVar(command.substring(9, command.length()), player, house, gs, th);
                                if (hcCommand.charAt(7) == '-') {
                                    i *= -1;
                                }
                                if (inverse) {
                                    i *= -1;
                                }
                                gobj.character.speed.x += RoomObject.readVar(command.substring(8, command.length()), player, house, gs, th);
                            }
                        } else if (hcCommand.indexOf("SPEED_Y") == 0 && obj instanceof GameObject) {
                            if (!set) {
                                return gobj.character.speed.y * (inverse ? -1 : 1);
                            }
                            if (hcCommand.charAt(7) == '=') {
                                gobj.character.speed.y = RoomObject.readVar(command.substring(8, command.length()), player, house, gs, th);
                            } else {
                                int i = RoomObject.readVar(command.substring(9, command.length()), player, house, gs, th);
                                if (hcCommand.charAt(7) == '-') {
                                    i *= -1;
                                }
                                if (inverse) {
                                    i *= -1;
                                }
                                gobj.character.speed.y += RoomObject.readVar(command.substring(8, command.length()), player, house, gs, th);
                            }
                        } else if (hcCommand.indexOf("SPEED_Z") == 0 && obj instanceof GameObject) {
                            if (!set) {
                                return gobj.character.speed.z * (inverse ? -1 : 1);
                            }
                            if (hcCommand.charAt(7) == '=') {
                                gobj.character.speed.z = RoomObject.readVar(command.substring(8, command.length()), player, house, gs, th);
                            } else {
                                int i = RoomObject.readVar(command.substring(9, command.length()), player, house, gs, th);
                                if (hcCommand.charAt(7) == '-') {
                                    i *= -1;
                                }
                                if (inverse) {
                                    i *= -1;
                                }
                                gobj.character.speed.z += RoomObject.readVar(command.substring(8, command.length()), player, house, gs, th);
                            }
                        } else if (hcCommand.indexOf("ANIMATION_SPEED") == 0 && obj instanceof MeshObject) {
                            MeshObject mobj = (MeshObject)obj;
                            if (!set) {
                                return (int)mobj.animSpeed * (inverse ? -1 : 1);
                            }
                            if (hcCommand.charAt(15) == '=') {
                                mobj.animSpeed = RoomObject.readVar(command.substring(16, command.length()), player, house, gs, th);
                            } else {
                                int i = RoomObject.readVar(command.substring(17, command.length()), player, house, gs, th);
                                if (hcCommand.charAt(15) == '-') {
                                    i *= -1;
                                }
                                if (inverse) {
                                    i *= -1;
                                }
                                mobj.animSpeed += (float)RoomObject.readVar(command.substring(16, command.length()), player, house, gs, th);
                            }
                        } else if (hcCommand.indexOf("ANIMATION_TYPE") == 0 && obj instanceof MeshObject) {
                            MeshObject mobj = (MeshObject)obj;
                            if (!set) {
                                return (int)mobj.animSpeed * (inverse ? -1 : 1);
                            }
                            if (hcCommand.charAt(14) == '=') {
                                mobj.animSpeed = RoomObject.readVar(command.substring(15, command.length()), player, house, gs, th);
                            } else {
                                int i = RoomObject.readVar(command.substring(16, command.length()), player, house, gs, th);
                                if (hcCommand.charAt(14) == '-') {
                                    i *= -1;
                                }
                                if (inverse) {
                                    i *= -1;
                                }
                                mobj.animSpeed += (float)RoomObject.readVar(command.substring(15, command.length()), player, house, gs, th);
                            }
                        }
                    }
                }
            }
        }
        return 0;
    }

    public static int getSetValueSystem(Player player, House house, GameScreen gs, String command, boolean inverse, boolean set, String buffer) {
        String hcCommand = command.toUpperCase();
        boolean toggle = false;
        if (hcCommand.indexOf("TOGGLE_") != -1) {
            toggle = true;
            hcCommand = hcCommand.substring(7, hcCommand.length());
            command = command.substring(7, command.length());
        }
        if (hcCommand.equals("SYMBIAN_DEVICE")) {
            if (!set) {
                return (Main.symbian ? !inverse : inverse) ? 1 : 0;
            }
            Main.symbian = !toggle ? !inverse : (Main.symbian ^= true);
        }
        return 0;
    }

    public static int readVar(String var, Player player, House house, GameScreen gs, RoomObject th) {
        if (var == null) {
            return 0;
        }
        if (var.length() == 0) {
            return 0;
        }
        var = var.trim();
        String hcVar = var.toUpperCase();
        int ind = var.indexOf(40);
        if (ind > -1) {
            String s = var.substring(0, ind) + RoomObject.readVar(var.substring(ind + 1, var.indexOf(41)), player, house, gs, th);
            if (ind + 1 < var.length()) {
                s = s + var.substring(var.indexOf(41) + 1, var.length());
            }
            return RoomObject.readVar(s, player, house, gs, th);
        }
        ind = var.indexOf(43);
        if (ind > 0) {
            return RoomObject.readVar(var.substring(0, ind), player, house, gs, th) + RoomObject.readVar(var.substring(ind + 1, var.length()), player, house, gs, th);
        }
        ind = var.indexOf(45);
        if (ind > 0) {
            return RoomObject.readVar(var.substring(0, ind), player, house, gs, th) - RoomObject.readVar(var.substring(ind + 1, var.length()), player, house, gs, th);
        }
        ind = var.indexOf(42);
        if (ind > -1) {
            return RoomObject.readVar(var.substring(0, ind), player, house, gs, th) * RoomObject.readVar(var.substring(ind + 1, var.length()), player, house, gs, th);
        }
        ind = var.indexOf(47);
        if (ind > -1) {
            return RoomObject.readVar(var.substring(0, ind), player, house, gs, th) / RoomObject.readVar(var.substring(ind + 1, var.length()), player, house, gs, th);
        }
        if (RoomObject.testNumeric(var)) {
            return StringTools.parseInt(var);
        }
        if (hcVar.equals("MONEY")) {
            return player.money;
        }
        if (hcVar.equals("FRAGS")) {
            return player.frags;
        }
        if (hcVar.indexOf("AMMO_") == 0) {
            String tmp = var.substring(5, var.length());
            int weapon = RoomObject.readVar(tmp, player, house, gs, th);
            if (player.arsenal.weapons[weapon] != null) {
                return player.arsenal.weapons[weapon].magazine.ammo;
            }
            return 0;
        }
        if (hcVar.indexOf("RANDOM_") == 0) {
            int max = RoomObject.readVar(var.substring(7, var.length()), player, house, gs, th);
            return rand.nextInt(max + 1);
        }
        if (var.indexOf(58) != -1) {
            String objname = var.substring(0, var.indexOf(58));
            String command = var.substring(var.indexOf(58) + 1, var.length());
            String hcCommand = command.toUpperCase();
            RoomObject obj = null;
            Vector objs = house.getObjects();
            if (objname.equalsIgnoreCase("player")) {
                obj = player;
            }
            if (objname.equalsIgnoreCase("self")) {
                obj = th;
            }
            if (objs.size() > 0 && obj == null) {
                for (int i = 0; i < objs.size(); ++i) {
                    if (!((RoomObject)objs.elementAt((int)i)).name.equals(objname)) continue;
                    obj = (RoomObject)objs.elementAt(i);
                    break;
                }
            }
            return RoomObject.getSetValue(player, house, gs, obj, command, false, false, null, th);
        }
        if (RoomObject.containsCollected(Player.usedPoints, var, player, house, gs, th)) {
            return 1;
        }
        return 0;
    }

    public static boolean readBoolean(String var, Player player, House house, GameScreen gs, RoomObject th) {
        int ind = (var = var.trim()).indexOf(40);
        if (ind > -1) {
            String s = var.substring(0, ind) + RoomObject.readBoolean(var.substring(ind + 1, var.indexOf(41)), player, house, gs, th);
            if (ind + 1 < var.length()) {
                s = s + var.substring(var.indexOf(41) + 1, var.length());
            }
            boolean bol = RoomObject.readBoolean(s, player, house, gs, th);
            if (ind >= 1 && var.charAt(ind - 1) == '!') {
                return !bol;
            }
            return bol;
        }
        ind = var.indexOf(124);
        if (ind > -1) {
            return RoomObject.readBoolean(var.substring(0, ind), player, house, gs, th) || RoomObject.readBoolean(var.substring(ind + 1, var.length()), player, house, gs, th);
        }
        ind = var.indexOf(38);
        if (ind > -1) {
            return RoomObject.readBoolean(var.substring(0, ind), player, house, gs, th) && RoomObject.readBoolean(var.substring(ind + 1, var.length()), player, house, gs, th);
        }
        return RoomObject.containsCollected(Player.usedPoints, var, player, house, gs, th);
    }

    public static String readString(String var, Player player, House house, GameScreen gs, RoomObject th) {
        int ind = (var = var.trim()).indexOf(91);
        if (ind > -1) {
            String s = var.substring(0, ind) + '\"' + String.valueOf(RoomObject.readVar(var.substring(ind + 1, var.indexOf(93)), player, house, gs, th)) + '\"';
            if (ind + 1 < var.length()) {
                s = s + var.substring(var.indexOf(93) + 1, var.length());
            }
            return RoomObject.readString(s, player, house, gs, th);
        }
        ind = var.indexOf(40);
        if (ind > -1) {
            String s = var.substring(0, ind) + '\"' + RoomObject.readString(var.substring(ind + 1, var.indexOf(41)), player, house, gs, th) + '\"';
            if (ind + 1 < var.length()) {
                s = s + var.substring(var.indexOf(41) + 1, var.length());
            }
            return RoomObject.readString(s, player, house, gs, th);
        }
        ind = var.indexOf(43);
        if (ind > -1 && var.charAt(ind - 1) == '\"' && var.charAt(ind + 1) == '\"') {
            return RoomObject.readString(var.substring(0, ind), player, house, gs, th) + RoomObject.readString(var.substring(ind + 1, var.length()), player, house, gs, th);
        }
        if (var.charAt(0) == '\"') {
            return var.substring(1, var.length() - 1);
        }
        return "null";
    }

    public static boolean testNumeric(String var) {
        char c = var.charAt(0);
        return c == '-' || c == '0' || c == '1' || c == '2' || c == '3' || c == '4' || c == '5' || c == '6' || c == '7' || c == '8' || c == '9';
    }

    public void give(String name, Player player) {
        String newName = name;
        if (newName == null) {
            return;
        }
        boolean inverse = false;
        if (newName.indexOf(33) == 0) {
            inverse = true;
            newName = newName.substring(1, newName.length());
        }
        if (inverse) {
            Player.usedPoints.removeElement(newName);
        }
        if (!inverse && !RoomObject.containsSimple(Player.usedPoints, newName)) {
            Player.usedPoints.addElement(newName);
        }
    }

    public abstract void activate(House var1, Player var2, GameScreen var3);

    public void errMsg(GameScreen gs) {
        if (this.errMessageDelay > 0L) {
            GameScreen.delayDialogs.addElement(new DelayedDialog(this.errMessageTimeOut, this.errMessageType, this.errMessage, this.errMessageDelay));
            return;
        }
        if (this.errMessageType > 0) {
            gs.customMessage = this.errMessage;
            gs.customMessagePause = false;
            gs.customMessageEndTime = System.currentTimeMillis() + this.errMessageTimeOut;
            if (this.errMessageType == 2) {
                gs.customMessagePause = true;
                gs.customMessageEndTime = this.errMessageTimeOut;
            }
            GameScreen.lines.removeAllElements();
            TextView.createLines(this.message, GameScreen.lines, gs.font, GameScreen.width);
        }
        if (this.errMessageType == 0) {
            gs.showDialog(this.errMessage);
        }
    }

    public void prMsg(GameScreen gs) {
        if (this.messageDelay > 0L) {
            GameScreen.delayDialogs.addElement(new DelayedDialog(this.messageTimeOut, this.messageType, this.message, this.messageDelay));
            return;
        }
        if (this.messageType > 0) {
            gs.customMessage = this.message;
            gs.customMessagePause = false;
            gs.customMessageEndTime = System.currentTimeMillis() + this.messageTimeOut;
            if (this.messageType == 2) {
                gs.customMessagePause = true;
                gs.customMessageEndTime = this.messageTimeOut;
            }
            GameScreen.lines.removeAllElements();
            TextView.createLines(this.message, GameScreen.lines, gs.font, GameScreen.width);
        }
        if (this.messageType == 0) {
            gs.showDialog(this.message);
        }
    }

    public void drawDebug(Graphics g, DirectX7 g3d, int yy, boolean canReact, House house) {
        Room rm;
        if (!this.activable) {
            return;
        }
        if (this.squarePoint) {
            this.drawDebugSquare(g, g3d, yy, canReact, house);
            return;
        }
        vert.set(this.getPosX(), this.getPosY(), this.getPosZ());
        if (this.pointOffset != null) {
            vert.set(this.getPosX() + this.pointOffset.x, this.getPosY() + this.pointOffset.y, this.getPosZ() + this.pointOffset.z);
        }
        vert.transform(g3d.getInvCamera());
        vert.project(g3d);
        int px = RoomObject.vert.sx;
        int py = RoomObject.vert.sy;
        if (this.part != -1 && (rm = house.getRooms()[this.part]) != null && !rm.isOnRoom(px, py)) {
            return;
        }
        int rad = this.pointRadius * g3d.distX;
        if (-RoomObject.vert.rz + g3d.distX > 0) {
            rad /= -RoomObject.vert.rz + g3d.distX;
        }
        int height = this.pointHeight * g3d.distY;
        if (-RoomObject.vert.rz + g3d.distY > 0) {
            height /= -RoomObject.vert.rz + g3d.distY;
        }
        if (this.dynamicPoint) {
            RoomObject obj;
            if (this instanceof MeshObject) {
                obj = (MeshObject)this;
                ((MeshObject)obj).boundingBox.isVisible(g3d, g3d.computeFinalMatrix(((GameObject)obj).getCharacter().getTransform()), 0, 0, g3d.width, g3d.height);
                RoomObject.vert.sx = (((MeshObject)obj).boundingBox.getMaxX() + ((MeshObject)obj).boundingBox.getMinX()) / 2;
                RoomObject.vert.sy = (((MeshObject)obj).boundingBox.getMaxY() + ((MeshObject)obj).boundingBox.getMinY()) / 2;
                rad = (((MeshObject)obj).boundingBox.getMaxX() - ((MeshObject)obj).boundingBox.getMinX()) / 2;
                height = (((MeshObject)obj).boundingBox.getMaxY() - ((MeshObject)obj).boundingBox.getMinY()) / 2;
            } else if (this instanceof NPC) {
                obj = (NPC)this;
                if (((NPC)obj).meshImage != null) {
                    ((NPC)obj).boundingBox.isVisible(g3d, g3d.computeFinalMatrix(((GameObject)obj).getCharacter().getTransform()), 0, 0, g3d.width, g3d.height);
                    RoomObject.vert.sx = (((NPC)obj).boundingBox.getMaxX() + ((NPC)obj).boundingBox.getMinX()) / 2;
                    RoomObject.vert.sy = (((NPC)obj).boundingBox.getMaxY() + ((NPC)obj).boundingBox.getMinY()) / 2;
                    rad = (((NPC)obj).boundingBox.getMaxX() - ((NPC)obj).boundingBox.getMinX()) / 2;
                    height = (((NPC)obj).boundingBox.getMaxY() - ((NPC)obj).boundingBox.getMinY()) / 2;
                } else {
                    if (((NPC)obj).currentSprite == null) {
                        return;
                    }
                    ((NPC)obj).currentSprite.project(g3d.getInvCamera(), g3d);
                    RoomObject.vert.sx = (((NPC)obj).currentSprite.pos.sx + ((NPC)obj).currentSprite.size.sx) / 2;
                    RoomObject.vert.sy = (((NPC)obj).currentSprite.pos.sy + ((NPC)obj).currentSprite.size.sy) / 2;
                    rad = (((NPC)obj).currentSprite.size.sx - ((NPC)obj).currentSprite.pos.sx) / 2;
                    height = (((NPC)obj).currentSprite.size.sy - ((NPC)obj).currentSprite.pos.sy) / 2;
                }
            } else if (this instanceof SpriteObject) {
                obj = (SpriteObject)this;
                ((SpriteObject)obj).spr.project(g3d.getInvCamera(), g3d);
                RoomObject.vert.sx = (((SpriteObject)obj).spr.pos.sx + ((SpriteObject)obj).spr.size.sx) / 2;
                RoomObject.vert.sy = (((SpriteObject)obj).spr.pos.sy + ((SpriteObject)obj).spr.size.sy) / 2;
                rad = (((SpriteObject)obj).spr.size.sx - ((SpriteObject)obj).spr.pos.sx) / 2;
                height = (((SpriteObject)obj).spr.size.sy - ((SpriteObject)obj).spr.pos.sy) / 2;
            }
        }
        if (RoomObject.vert.rz < 0) {
            g.setColor(0, 0, 0);
            g.fillArc(px - 3, py - 3 + yy, 7, 7, 0, 360);
            g.setColor(255, 0, 0);
            int xx = RoomObject.vert.sx - g3d.width / 2;
            xx *= xx;
            int yyy = RoomObject.vert.sy - g3d.height / 2;
            if (height == 0) {
                height = 1;
            }
            if (xx + (yyy = yyy * yyy * rad / height) < rad * rad && canReact) {
                g.setColor(0, 255, 0);
            }
            if (!this.needToPoint) {
                g.setColor(255, 255, 255);
            }
            g.fillArc(px - 2, py - 2 + yy, 5, 5, 0, 360);
            if (this.needToPoint) {
                g.drawArc(RoomObject.vert.sx - rad, RoomObject.vert.sy - height + yy, rad * 2, height * 2, 0, 360);
            }
            if (this.needToPoint && this instanceof Bot) {
                g.drawArc(RoomObject.vert.sx - rad / 2, RoomObject.vert.sy - height + yy, rad, height * 2 / 5, 0, 360);
            }
            this.printName(g, px, py + yy);
            g.setColor(255, 255, 255);
        }
    }

    public void drawDebugSquare(Graphics g, DirectX7 g3d, int yy, boolean canReact, House house) {
        Room rm;
        if (!this.activable) {
            return;
        }
        vert.set(this.getPosX(), this.getPosY(), this.getPosZ());
        if (this.pointOffset != null) {
            vert.set(this.getPosX() + this.pointOffset.x, this.getPosY() + this.pointOffset.y, this.getPosZ() + this.pointOffset.z);
        }
        vert.transform(g3d.getInvCamera());
        vert.project(g3d);
        int px = RoomObject.vert.sx;
        int py = RoomObject.vert.sy;
        if (this.part != -1 && (rm = house.getRooms()[this.part]) != null && !rm.isOnRoom(px, py)) {
            return;
        }
        int rad = this.pointRadius * g3d.distX / (-RoomObject.vert.rz + g3d.distX);
        int height = this.pointHeight * g3d.distY / (-RoomObject.vert.rz + g3d.distY);
        if (this.dynamicPoint) {
            RoomObject obj;
            if (this instanceof MeshObject) {
                obj = (MeshObject)this;
                ((MeshObject)obj).boundingBox.isVisible(g3d, g3d.computeFinalMatrix(((GameObject)obj).getCharacter().getTransform()), 0, 0, g3d.width, g3d.height);
                RoomObject.vert.sx = (((MeshObject)obj).boundingBox.getMaxX() + ((MeshObject)obj).boundingBox.getMinX()) / 2;
                RoomObject.vert.sy = (((MeshObject)obj).boundingBox.getMaxY() + ((MeshObject)obj).boundingBox.getMinY()) / 2;
                rad = (((MeshObject)obj).boundingBox.getMaxX() - ((MeshObject)obj).boundingBox.getMinX()) / 2;
                height = (((MeshObject)obj).boundingBox.getMaxY() - ((MeshObject)obj).boundingBox.getMinY()) / 2;
            } else if (this instanceof NPC) {
                obj = (NPC)this;
                if (((NPC)obj).meshImage != null) {
                    ((NPC)obj).boundingBox.isVisible(g3d, g3d.computeFinalMatrix(((GameObject)obj).getCharacter().getTransform()), 0, 0, g3d.width, g3d.height);
                    RoomObject.vert.sx = (((NPC)obj).boundingBox.getMaxX() + ((NPC)obj).boundingBox.getMinX()) / 2;
                    RoomObject.vert.sy = (((NPC)obj).boundingBox.getMaxY() + ((NPC)obj).boundingBox.getMinY()) / 2;
                    rad = (((NPC)obj).boundingBox.getMaxX() - ((NPC)obj).boundingBox.getMinX()) / 2;
                    height = (((NPC)obj).boundingBox.getMaxY() - ((NPC)obj).boundingBox.getMinY()) / 2;
                } else {
                    if (((NPC)obj).currentSprite == null) {
                        return;
                    }
                    ((NPC)obj).currentSprite.project(g3d.getInvCamera(), g3d);
                    RoomObject.vert.sx = (((NPC)obj).currentSprite.pos.sx + ((NPC)obj).currentSprite.size.sx) / 2;
                    RoomObject.vert.sy = (((NPC)obj).currentSprite.pos.sy + ((NPC)obj).currentSprite.size.sy) / 2;
                    rad = (((NPC)obj).currentSprite.size.sx - ((NPC)obj).currentSprite.pos.sx) / 2;
                    height = (((NPC)obj).currentSprite.size.sy - ((NPC)obj).currentSprite.pos.sy) / 2;
                }
            } else if (this instanceof SpriteObject) {
                obj = (SpriteObject)this;
                ((SpriteObject)obj).spr.project(g3d.getInvCamera(), g3d);
                RoomObject.vert.sx = (((SpriteObject)obj).spr.pos.sx + ((SpriteObject)obj).spr.size.sx) / 2;
                RoomObject.vert.sy = (((SpriteObject)obj).spr.pos.sy + ((SpriteObject)obj).spr.size.sy) / 2;
                rad = (((SpriteObject)obj).spr.size.sx - ((SpriteObject)obj).spr.pos.sx) / 2;
                height = (((SpriteObject)obj).spr.size.sy - ((SpriteObject)obj).spr.pos.sy) / 2;
            }
        }
        if (RoomObject.vert.rz < 0) {
            g.setColor(0, 0, 0);
            g.fillArc(px - 3, py - 3 + yy, 7, 7, 0, 360);
            g.setColor(255, 0, 0);
            int xx = RoomObject.vert.sx - g3d.width / 2;
            xx *= xx;
            int yyy = RoomObject.vert.sy - g3d.height / 2;
            yyy *= yyy;
            if (xx < rad * rad && yyy < height * height && canReact) {
                g.setColor(0, 255, 0);
            }
            if (!this.needToPoint) {
                g.setColor(255, 255, 255);
            }
            g.fillArc(px - 2, py - 2 + yy, 5, 5, 0, 360);
            if (this.needToPoint) {
                g.drawRect(RoomObject.vert.sx - rad, RoomObject.vert.sy - height + yy, rad * 2, height * 2);
            }
            if (this.needToPoint && this instanceof Bot) {
                g.drawRect(RoomObject.vert.sx - rad / 2, RoomObject.vert.sy - height + yy, rad, height * 2 / 5);
            }
            this.printName(g, px, py + yy);
            g.setColor(255, 255, 255);
        }
    }

    private void printName(Graphics g, int px, int py) {
        if (this.name != null) {
            int col = g.getColor();
            g.setColor(0);
            g.drawString(this.name, px + 5, py - 5, 68);
            g.drawString(this.name, px + 4, py - 5, 68);
            g.drawString(this.name, px + 6, py - 5, 68);
            g.drawString(this.name, px + 4, py - 4, 68);
            g.drawString(this.name, px + 6, py - 4, 68);
            g.drawString(this.name, px + 4, py - 6, 68);
            g.drawString(this.name, px + 6, py - 6, 68);
            g.setColor(col);
            g.drawString(this.name, px + 5, py - 5, 68);
        }
    }

    public boolean check(DirectX7 g3d, int yy) {
        if (!this.activable) {
            return false;
        }
        if (!this.needToPoint) {
            return true;
        }
        vert.set(this.getPosX(), this.getPosY(), this.getPosZ());
        if (this.pointOffset != null) {
            vert.set(this.getPosX() + this.pointOffset.x, this.getPosY() + this.pointOffset.y, this.getPosZ() + this.pointOffset.z);
        }
        vert.transform(g3d.getInvCamera());
        vert.project(g3d);
        int rad = this.pointRadius * g3d.distX;
        if (-RoomObject.vert.rz + g3d.distX > 0) {
            rad /= -RoomObject.vert.rz + g3d.distX;
        }
        int height = this.pointHeight * g3d.distY;
        if (-RoomObject.vert.rz + g3d.distY > 0) {
            height /= -RoomObject.vert.rz + g3d.distY;
        }
        if (this.dynamicPoint) {
            RoomObject obj;
            if (this instanceof MeshObject) {
                obj = (MeshObject)this;
                ((MeshObject)obj).boundingBox.isVisible(g3d, g3d.computeFinalMatrix(((GameObject)obj).getCharacter().getTransform()), 0, 0, g3d.width, g3d.height);
                RoomObject.vert.sx = (((MeshObject)obj).boundingBox.getMaxX() + ((MeshObject)obj).boundingBox.getMinX()) / 2;
                RoomObject.vert.sy = (((MeshObject)obj).boundingBox.getMaxY() + ((MeshObject)obj).boundingBox.getMinY()) / 2;
                rad = (((MeshObject)obj).boundingBox.getMaxX() - ((MeshObject)obj).boundingBox.getMinX()) / 2;
                height = (((MeshObject)obj).boundingBox.getMaxY() - ((MeshObject)obj).boundingBox.getMinY()) / 2;
            } else if (this instanceof NPC) {
                obj = (NPC)this;
                if (((NPC)obj).meshImage != null) {
                    ((NPC)obj).boundingBox.isVisible(g3d, g3d.computeFinalMatrix(((GameObject)obj).getCharacter().getTransform()), 0, 0, g3d.width, g3d.height);
                    RoomObject.vert.sx = (((NPC)obj).boundingBox.getMaxX() + ((NPC)obj).boundingBox.getMinX()) / 2;
                    RoomObject.vert.sy = (((NPC)obj).boundingBox.getMaxY() + ((NPC)obj).boundingBox.getMinY()) / 2;
                    rad = (((NPC)obj).boundingBox.getMaxX() - ((NPC)obj).boundingBox.getMinX()) / 2;
                    height = (((NPC)obj).boundingBox.getMaxY() - ((NPC)obj).boundingBox.getMinY()) / 2;
                } else {
                    if (((NPC)obj).currentSprite == null) {
                        return false;
                    }
                    ((NPC)obj).currentSprite.project(g3d.getInvCamera(), g3d);
                    RoomObject.vert.sx = (((NPC)obj).currentSprite.pos.sx + ((NPC)obj).currentSprite.size.sx) / 2;
                    RoomObject.vert.sy = (((NPC)obj).currentSprite.pos.sy + ((NPC)obj).currentSprite.size.sy) / 2;
                    rad = (((NPC)obj).currentSprite.size.sx - ((NPC)obj).currentSprite.pos.sx) / 2;
                    height = (((NPC)obj).currentSprite.size.sy - ((NPC)obj).currentSprite.pos.sy) / 2;
                }
            } else if (this instanceof SpriteObject) {
                obj = (SpriteObject)this;
                ((SpriteObject)obj).spr.project(g3d.getInvCamera(), g3d);
                RoomObject.vert.sx = (((SpriteObject)obj).spr.pos.sx + ((SpriteObject)obj).spr.size.sx) / 2;
                RoomObject.vert.sy = (((SpriteObject)obj).spr.pos.sy + ((SpriteObject)obj).spr.size.sy) / 2;
                rad = (((SpriteObject)obj).spr.size.sx - ((SpriteObject)obj).spr.pos.sx) / 2;
                height = (((SpriteObject)obj).spr.size.sy - ((SpriteObject)obj).spr.pos.sy) / 2;
            }
        }
        if (RoomObject.vert.rz < 0) {
            if (this.squarePoint) {
                int xx = RoomObject.vert.sx - g3d.width / 2;
                xx *= xx;
                int yyy = RoomObject.vert.sy - g3d.height / 2;
                yyy *= yyy;
                if (xx < rad * rad && yyy < height * height) {
                    return true;
                }
            } else {
                int xx = RoomObject.vert.sx - g3d.width / 2;
                xx *= xx;
                int yyy = RoomObject.vert.sy - g3d.height / 2;
                if (height == 0) {
                    height = 1;
                }
                if (xx + (yyy = yyy * yyy * rad / height) < rad * rad) {
                    return true;
                }
            }
        }
        return false;
    }
}

