/*
 * Decompiled with CFR 0.152.
 */
package code.Gameplay.Objects;

import code.AI.Player;
import code.Collision.Height;
import code.Collision.HeightComputer;
import code.Collision.Ray;
import code.Collision.RayCast;
import code.Collision.SphereCast;
import code.Gameplay.GameScreen;
import code.Gameplay.Map.House;
import code.Gameplay.Map.Scene;
import code.Gameplay.Objects.GameObject;
import code.Math.Matrix;
import code.Math.Vector3D;
import code.Rendering.DirectX7;
import code.Rendering.Meshes.BoundingBox;
import code.Rendering.Meshes.Mesh;
import code.Rendering.Meshes.MeshClone;
import code.Rendering.Meshes.Morphing;
import code.Rendering.MultyTexture;

public final class MeshObject
extends GameObject {
    public static final int OPEN = 1;
    public static final int CLOSE = 2;
    public static final int LOOP = 0;
    public static final int STAY_BEGIN = 0;
    public static final int DRIVE = 1;
    public static final int STAY_END = 2;
    public static final int DRIVE_BACK = 3;
    private static final Vector3D dir = new Vector3D();
    private static final Vector3D side = new Vector3D();
    private static final Vector3D up = new Vector3D();
    private static final Vector3D tVec = new Vector3D();
    private static short[][] animData;
    private static MeshClone meshData;
    public int state = 0;
    public int LIFT_STATE = 0;
    public boolean LIFT_PAUSED = false;
    public long pauseTime = 0L;
    public long pauseBeginTime = 0L;
    public Vector3D playerFollowLift;
    public long clickTime = GameScreen.time;
    public long liftClickTime = GameScreen.time;
    public Vector3D[] poses = new Vector3D[1];
    public int[] timeToMove;
    public int clickAnim = 0;
    public float animSpeed = 0.0f;
    public int animType = 0;
    public Morphing animation;
    public MultyTexture tex;
    public BoundingBox boundingBox;
    public boolean realtimeLighting = false;
    public int addsz = 1500;
    public boolean precCol = false;
    public boolean liftReUse = true;
    public boolean liftCanBePaused = false;
    public boolean liftCycled = false;
    public boolean liftRotateToMove = true;
    public int liftSmoothMove = 0;
    public boolean disactivateOnEnd = false;
    public boolean ignoreWeaponRayCast = false;
    private int distPerSec = 1000;

    public MeshObject(Mesh[] meshes, MultyTexture tex2, int xx, int yy, int zz, boolean realtimeLighting) {
        this.poses[0] = new Vector3D(xx, yy, zz);
        Mesh mesh = meshes[0];
        meshData = new MeshClone(mesh);
        MeshObject.meshData.lighting = realtimeLighting;
        this.animation = new Morphing(Morphing.create(meshes, 0, meshes.length), meshData.copy());
        meshData.destroy();
        meshData = null;
        this.getCharacter().getTransform().setIdentity();
        this.animation.getMesh().setTexture(tex2);
        this.boundingBox = new BoundingBox(this.animation);
        this.tex = tex2;
        this.set(xx, yy, zz);
        this.setHp(0x3FFFFFFF);
        this.realtimeLighting = realtimeLighting;
    }

    public void set(int xx, int yy, int zz) {
        this.character.reset();
        this.character.getTransform().setPosition(xx, yy, zz);
        int xsize = this.animation.getMesh().maxX() - this.animation.getMesh().minX();
        int zsize = this.animation.getMesh().maxX() - this.animation.getMesh().minX();
        int ysize = this.animation.getMesh().maxY() - this.animation.getMesh().minY();
        this.setCharacterSize(xsize / 2, zsize / 2, ysize);
        this.animation.setFrame(0);
    }

    public void destroy() {
    }

    public boolean sphereCollisionTest(Vector3D pos, int rad) {
        this.boundingBox.reSort(this.character.transform);
        if (!SphereCast.isSphereAABBCollision(pos, rad, this.boundingBox.getMinX(), this.boundingBox.getMaxX(), this.boundingBox.getMinZ(), this.boundingBox.getMaxZ())) {
            return false;
        }
        this.setFrame();
        return SphereCast.sphereCast(this.animation.getMesh(), this.getCharacter().getTransform(), pos, rad);
    }

    public void computeHeight(Height height) {
        this.boundingBox.reSort(this.character.transform);
        Vector3D pos = height.getPosition();
        if (!HeightComputer.isPointAABBCollision(pos.x, pos.z, this.boundingBox.getMinX(), this.boundingBox.getMaxX(), this.boundingBox.getMinZ(), this.boundingBox.getMaxZ())) {
            return;
        }
        this.setFrame();
        HeightComputer.computeHeight(this.animation.getMesh(), this.getCharacter().getTransform(), height, this.playerFollowLift == null);
    }

    public final void rayCast(Ray ray) {
        this.setFrame();
        Vector3D var2 = ray.getStart();
        Vector3D var3 = ray.getDir();
        int var4 = Math.min(var2.x, var2.x + var3.x);
        int var5 = Math.min(var2.z, var2.z + var3.z);
        int var6 = Math.max(var2.x, var2.x + var3.x);
        int var7 = Math.max(var2.z, var2.z + var3.z);
        this.boundingBox.reSort(this.character.transform);
        if (var4 <= this.boundingBox.getMaxX() && var5 <= this.boundingBox.getMaxZ() && var6 >= this.boundingBox.getMinX() && var7 >= this.boundingBox.getMinZ()) {
            RayCast.rayCast(this.animation.getMesh(), ray, this.character.getTransform());
        }
    }

    public final void lookAt(int x, int z) {
        Matrix pos = this.getCharacter().getTransform();
        dir.set(pos.m03 - x, 0, pos.m23 - z);
        dir.setLength(-16384);
        tVec.set(pos.m02, 0, pos.m22);
        tVec.setLength(16384);
        tVec.interpolation(dir, 5);
        this.setDir(pos, MeshObject.tVec.x, MeshObject.tVec.z);
    }

    public final void lookAtDirect(int x, int z) {
        Matrix pos = this.getCharacter().getTransform();
        dir.set(pos.m03 - x, 0, pos.m23 - z);
        dir.setLength(-16384);
        this.setDir(pos, MeshObject.dir.x, MeshObject.dir.z);
    }

    private void setDir(Matrix m, int dirX, int dirZ) {
        dir.set(dirX, 0, dirZ);
        dir.setLength(16384);
        if (MeshObject.equals(MeshObject.dir.x, MeshObject.dir.y, MeshObject.dir.z, m.m02, m.m12, m.m22)) {
            return;
        }
        up.set(0, 16384, 0);
        side.cross(up, dir, 14);
        side.setLength(16384);
        if (dir.lengthSquared() != 0 && side.lengthSquared() != 0) {
            m.setDir(MeshObject.dir.x, MeshObject.dir.y, MeshObject.dir.z);
            m.setSide(MeshObject.side.x, MeshObject.side.y, MeshObject.side.z);
            m.setUp(MeshObject.up.x, MeshObject.up.y, MeshObject.up.z);
        }
    }

    private static boolean equals(int ax, int ay, int az, int bx, int by, int bz) {
        return Math.abs(ax - bx) < 20 && Math.abs(ay - by) < 20 && Math.abs(az - bz) < 20;
    }

    private void getNewPos(Vector3D tmp, long coof, int summ) {
        int b;
        int a = 0;
        int sub = 0;
        while (coof > (long)summ && this.liftCycled) {
            coof -= (long)summ;
        }
        while (coof < 0L && this.liftCycled) {
            coof += (long)summ;
        }
        if (coof > (long)summ) {
            coof = summ;
        }
        if (coof < 0L) {
            coof = 0L;
        }
        for (int i = 0; i < this.timeToMove.length; ++i) {
            if (coof < (long)(sub += this.timeToMove[i])) continue;
            ++a;
        }
        if (a > this.poses.length - 1 && this.liftCycled) {
            a = 0;
        }
        if (a > this.poses.length - 1) {
            a = this.poses.length - 1;
        }
        if (a < 0) {
            a = 0;
        }
        if ((b = a + 1) > this.poses.length - 1 && this.liftCycled) {
            b = 0;
        }
        if (b > this.poses.length - 1) {
            b = this.poses.length - 1;
        }
        if (b < 0) {
            b = 0;
        }
        sub = 0;
        if (a > this.timeToMove.length - 1) {
            a = this.timeToMove.length - 1;
        }
        for (int i = 0; i < a; ++i) {
            sub += this.timeToMove[i];
        }
        int c = (int)((coof - (long)sub) * 1000L / (long)this.timeToMove[a]);
        int d = 1000 - c;
        tmp.set((this.poses[a].x * d + this.poses[b].x * c) / 1000, (this.poses[a].y * d + this.poses[b].y * c) / 1000, (this.poses[a].z * d + this.poses[b].z * c) / 1000);
    }

    public void update(Scene scene, Player player) {
        if (this.LIFT_STATE == 0 && this.timeToMove != null) {
            this.character.getTransform().setPosition(this.poses[0]);
        } else if (this.LIFT_STATE == 2 && this.timeToMove != null) {
            this.character.getTransform().setPosition(this.poses[this.poses.length - 1]);
        } else if ((this.LIFT_STATE == 1 || this.LIFT_STATE == 3) && this.timeToMove != null) {
            if (!this.LIFT_PAUSED) {
                int summ = 0;
                for (int i = 0; i < this.timeToMove.length; ++i) {
                    summ += this.timeToMove[i];
                }
                long curTime = GameScreen.time - this.pauseTime;
                long coof = curTime - this.liftClickTime;
                if (coof >= (long)summ && this.liftCycled) {
                    coof -= (long)summ;
                    this.liftClickTime += (long)summ;
                }
                if (this.LIFT_STATE == 1 && coof >= (long)summ) {
                    this.LIFT_STATE = 2;
                    this.activable = !this.disactivateOnEnd & this.activable;
                } else if (this.LIFT_STATE == 3 && coof >= (long)summ) {
                    this.LIFT_STATE = 0;
                } else {
                    if (this.LIFT_STATE == 3) {
                        coof = (long)summ - coof;
                    }
                    boolean a = false;
                    Vector3D tmp = new Vector3D();
                    this.getNewPos(tmp, coof, summ);
                    this.character.transform.setPosition(tmp);
                    if (this.liftSmoothMove != 0) {
                        this.getNewPos(tmp, coof + (long)(this.LIFT_STATE == 3 ? -1000 : 1000), summ);
                        Vector3D oldP = new Vector3D(tmp.x, tmp.y, tmp.z);
                        int distPerSec2 = (int)Math.sqrt((tmp.x - oldP.x) * (tmp.x - oldP.x) + (tmp.y - oldP.y) * (tmp.y - oldP.y) + (tmp.z - oldP.z) * (tmp.z - oldP.z));
                        if (distPerSec2 != 0) {
                            this.distPerSec = this.liftSmoothMove * 1000 / distPerSec2;
                        }
                        this.getNewPos(tmp, coof + (long)(this.LIFT_STATE == 3 ? -this.distPerSec : this.distPerSec), summ);
                        this.character.transform.addPosition(tmp);
                        this.character.transform.divPosition(2, 2, 2);
                        if (this.liftRotateToMove) {
                            this.lookAtDirect(tmp.x, tmp.z);
                        }
                    }
                }
                if (this.playerFollowLift != null) {
                    player.character.transform.setPosition(this.getPosX() + this.playerFollowLift.x, this.getPosY() + this.playerFollowLift.y, this.getPosZ() + this.playerFollowLift.z);
                }
            } else {
                this.pauseTime += GameScreen.time - this.pauseBeginTime;
                this.pauseBeginTime = GameScreen.time;
            }
        }
        this.setFrame();
        if (this.realtimeLighting && this.getPart() != -1) {
            this.animation.getMesh().updateLighting(this.character.transform, true, scene.getHouse().getRooms()[this.getPart()]);
        }
        super.update(scene, player);
    }

    public final void render(DirectX7 g3d, int x1, int y1, int x2, int y2) {
        if (!this.visible) {
            return;
        }
        if (this.lastActivate > 0L && this.lastActivate + this.timeToReset > GameScreen.time && this.hideWhenUnusable) {
            return;
        }
        Matrix mat = this.getCharacter().getTransform();
        mat = g3d.computeFinalMatrix(mat);
        this.setFrame();
        this.boundingBox.reSort(mat);
        if (!this.boundingBox.isVisible(g3d, mat, x1, y1, x2, y2)) {
            return;
        }
        this.animation.getMesh().getTexture().updateAnimation();
        g3d.transformAndProjectVertices(this.animation.getMesh(), mat);
        g3d.addMesh(this.animation.getMesh(), x1, y1, x2, y2, this.tex);
        this.animation.getMesh().increaseMeshSz(this.addsz);
    }

    public void setFrame() {
        if (this.state == 0) {
            this.animation.setFrame((int)((float)this.getFrameInter() * this.animSpeed / 100.0f));
        } else if (this.state == 1) {
            long frame = (long)((float)this.clickAnim + (float)(GameScreen.time - this.clickTime) * this.animSpeed * 20.0f / 1000.0f);
            if (frame >= (long)(this.animation.getMaxFrame() - 1024)) {
                frame = this.animation.getMaxFrame() - 1024;
            }
            this.animation.setFrame((int)frame);
        } else if (this.state == 2) {
            long frame = (long)((float)this.clickAnim - (float)(GameScreen.time - this.clickTime) * this.animSpeed * 20.0f / 1000.0f);
            if (frame < 0L) {
                frame = 0L;
            }
            this.animation.setFrame((int)frame);
        }
    }

    public void activate(House house, Player player, GameScreen gs) {
        if (this.lastActivate > 0L && this.lastActivate + this.timeToReset > GameScreen.time) {
            return;
        }
        if ((!this.singleUse || !this.contains(Player.usedPoints, this.name) && !this.activated) && this.isAllCollected(Player.usedPoints, player, house, gs)) {
            if (this.state == 2) {
                this.state = 1;
            } else if (this.state == 1) {
                this.state = 2;
            }
            this.clickAnim = this.animation.getFrame();
            this.clickTime = GameScreen.time;
            if (this.poses.length > 1) {
                if (this.LIFT_STATE == 1 || this.LIFT_STATE == 3 && this.liftCanBePaused) {
                    this.LIFT_PAUSED = !this.LIFT_PAUSED;
                    this.pauseBeginTime = GameScreen.time;
                }
                if (this.LIFT_STATE == 0 || this.LIFT_STATE == 2) {
                    this.liftClickTime = GameScreen.time;
                }
                if (this.LIFT_STATE == 0) {
                    this.LIFT_STATE = 1;
                    this.pauseTime = 0L;
                }
                if (this.LIFT_STATE == 2 && this.liftReUse) {
                    this.LIFT_STATE = 3;
                    this.pauseTime = 0L;
                }
            }
        }
        super.activate(house, player, gs);
    }
}

