/*
 * Decompiled with CFR 0.152.
 */
package code.HUD;

import code.AI.Player;
import code.Gameplay.Map.RoomObject;
import code.HUD.Base.TextView;
import code.HUD.GUIScreen;
import code.HUD.Menu;
import code.HUD.TitleScreen;
import code.utils.ImageResize;
import code.utils.Main;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;

public final class GameHelp
extends GUIScreen {
    private int y0;
    private Main main;
    private Menu menu;
    private TextView text;
    int x;
    int y;
    private int levelNumber;
    private Object hudInfo;
    private int stateCode = 1;
    private boolean preview = false;
    private boolean levelEnd;
    private Image background;
    public static boolean loadSave = false;
    public static boolean loadpos = true;
    private static short toMove = 0;

    public GameHelp(Main main, Menu menu, int levelNumberz, boolean levelEnd, Object hudInfo) {
        this.init(main, menu, levelNumberz, levelEnd, hudInfo, 1);
    }

    public GameHelp(Main main, Menu menu, int levelNumberz, boolean levelEnd, Object hudInfo, int helpState) {
        this.init(main, menu, levelNumberz, levelEnd, hudInfo, helpState);
    }

    public void init(Main main, Menu menu, int levelNumberz, boolean levelEnd, Object hudInfo, int code) {
        String txt;
        this.main = main;
        this.menu = menu;
        loadSave = false;
        loadpos = true;
        this.levelNumber = levelNumberz;
        this.hudInfo = hudInfo;
        this.stateCode = code;
        this.levelEnd = levelEnd;
        this.setFont(Main.getFont());
        this.setLeftSoft(Main.getGameText().get("NEXT"));
        String prefix = levelEnd ? "LEVEL_END_" : "GAME_HELP_";
        String add = "";
        if (this.stateCode > 1) {
            add = "_" + Integer.toString(this.stateCode);
        }
        Player.toAddOnStart.addElement(prefix + "SCREEN_" + Integer.toString(this.levelNumber) + add);
        this.x = this.getWidth() / 15;
        this.y = Main.getFont().height();
        toMove = 0;
        if (levelNumberz != 1) {
            txt = Main.getGameText().get(prefix + "TEXT_" + Integer.toString(levelNumberz) + add);
        } else {
            txt = Main.getGameText().get(prefix + "TEXT");
            if (txt == null) {
                txt = Main.getGameText().get(prefix + "TEXT_1" + add);
            }
        }
        if (txt == null) {
            txt = "";
        }
        String back1 = Main.getGameText().get(prefix + "PREVIEW_" + Integer.toString(levelNumberz) + add);
        String back2 = Main.getGameText().get(prefix + "BACKGROUND_" + Integer.toString(levelNumberz) + add);
        int textHeight = this.getHeight() - this.y * 2;
        this.text = new TextView(txt, this.getWidth() - this.x * 2, textHeight, Main.getFont());
        this.text.setCenter(true);
        try {
            if (back1 != null) {
                int min = Math.min(this.getWidth(), this.getHeight());
                this.background = ImageResize.createImage(back1, (float)min / 240.0f, (float)min / 240.0f);
                int offset = this.background.getHeight() + Main.getFont().height() * 2;
                this.y = offset + Main.getFont().height();
                this.text.setHeight(this.getHeight() - offset - Main.getFont().height() * 2);
                this.preview = true;
            } else if (back2 != null) {
                this.background = ImageResize.createImage(back2, this.getWidth(), this.getHeight());
            } else {
                if (menu != null && menu.background != null) {
                    this.background = menu.background;
                }
                if (menu == null && this.background == null) {
                    this.background = ImageResize.createImage(Main.background, this.getWidth(), this.getHeight());
                }
            }
        }
        catch (Exception err) {
            err.printStackTrace();
        }
        if (this.text.getTextHeight() < this.text.getHeight() && !this.preview) {
            this.text.setY(Math.max(0, (this.text.getHeight() - this.text.getTextHeight()) / 2));
        }
    }

    protected final void paint(Graphics g) {
        g.setColor(0);
        g.fillRect(0, 0, this.getWidth(), this.getHeight());
        if (this.pressUp && toMove == 0 && !this.pointerPressed) {
            toMove = (short)(toMove + Main.getFont().height());
        }
        if (this.pressDown && toMove == 0 && !this.pointerPressed) {
            toMove = (short)(toMove - Main.getFont().height());
        }
        if (toMove != 0 && !this.pointerPressed && this.text.getTextHeight() > this.text.getHeight()) {
            this.text.move(Math.max(Math.min(3, toMove), -3));
            toMove = (short)(toMove - Math.max(Math.min(3, toMove), -3));
        }
        if (this.background != null && this.preview) {
            g.setColor(0xFFFFFF);
            int posX = (this.getWidth() - this.background.getWidth()) / 2;
            g.drawImage(this.background, posX, (this.y - this.background.getHeight()) / 2, 0);
        } else if (this.background != null) {
            g.setColor(0xFFFFFF);
            g.drawImage(this.background, (this.getWidth() - this.background.getWidth()) / 2, (this.getHeight() - this.background.getHeight()) / 2, 0);
        }
        this.text.paint(g, this.x, this.y);
        g.translate(0, 0);
        g.setClip(0, 0, this.getWidth(), this.getHeight());
        this.drawSoftKeys(g);
        if (!this.pointerPressed) {
            try {
                Thread.sleep(22L);
                this.repaint();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    protected final void onLeftSoftKey() {
        this.onKey5();
    }

    protected final void onKey5() {
        if (this.levelEnd) {
            if (GameHelp.needToShow(this.levelNumber, this.stateCode + 1, true)) {
                this.init(this.main, this.menu, this.levelNumber, true, this.hudInfo, this.stateCode + 1);
            } else {
                this.background = null;
                this.destroy();
                if (Main.isLastLevel(this.levelNumber)) {
                    GUIScreen scr = TitleScreen.hasTitleScreen() ? new TitleScreen(this.main, null) : new Menu(this.main);
                    Main.setCurrent(scr);
                } else {
                    Main.loadLevel(loadSave, loadpos, this.levelNumber + 1, this.hudInfo, this.main, this.menu, 1);
                }
            }
        } else {
            this.background = null;
            this.destroy();
            Main.loadLevel(loadSave, loadpos, this.levelNumber, this.hudInfo, this.main, this.menu, this.stateCode + 1);
        }
    }

    protected final void pointerPressed(int x, int y) {
        super.pointerPressed(x, y);
        this.y0 = y;
    }

    protected final void pointerDragged(int x, int y) {
        x = y - this.y0;
        this.y0 = y;
        toMove = 0;
        this.serviceRepaints();
        this.text.move(x);
        this.repaint();
    }

    protected final void pointerReleased(int x, int y) {
        super.pointerReleased(x, y);
        this.repaint();
    }

    public static boolean needToShow(int levelNumber, int helpState, boolean levelEnd) {
        String add = "";
        if (helpState > 1) {
            add = "_" + Integer.toString(helpState);
        }
        String prefix = levelEnd ? "LEVEL_END_" : "GAME_HELP_";
        boolean dontNeedToShow = Main.getGameText().get(prefix + "TEXT_" + Integer.toString(levelNumber) + add) == null && (levelNumber != 1 || add.length() != 0 || Main.getGameText().get(prefix + "TEXT") == null) && Main.getGameText().get(prefix + "PREVIEW_" + Integer.toString(levelNumber) + add) == null && Main.getGameText().get(prefix + "BACKGROUND_" + Integer.toString(levelNumber) + add) == null || RoomObject.containsSimple(Player.usedPoints, prefix + "SCREEN_" + Integer.toString(levelNumber) + add) && Main.getGameText().getInt(prefix + "VIEW_ONCLE_" + Integer.toString(levelNumber) + add, 0) == 1;
        return !dontNeedToShow;
    }
}

