/*
 * Decompiled with CFR 0.152.
 */
package com.Gameplay.Map;

import com.Collision.Height;
import com.Gameplay.Map.House;
import com.Math.MathUtils2;
import com.Math.Matrix;
import com.Math.Vector3D;
import com.Rendering.Fps;
import com.Rendering.RenderObject;

public final class Character {
    private Matrix matrix = new Matrix();
    private static Fps fps;
    private static Vector3D tmpVec;
    private int player_radius;
    private int player_radius_z = 0;
    private int player_height;
    public Matrix transform = new Matrix();
    public Vector3D speed = new Vector3D();
    public boolean onFloor = false;
    private boolean colz = true;
    private boolean colz_2 = true;
    private boolean col = false;
    private Height height = new Height();
    public RenderObject oldFloorPoly;
    private int oldFloorCx;
    private int oldFloorCz;
    private int oldFloorCy;

    public Character(int radius, int height) {
        this.reset();
        this.set(0, 0);
    }

    public final void set(int radius, int height) {
        this.player_radius = radius;
        this.player_height = height;
    }

    public final void set(int radius, int radiusz, int height) {
        this.player_radius = radius;
        this.player_radius_z = radiusz;
        this.player_height = height;
    }

    public final void splitRadHeight() {
        int tmp = this.player_radius;
        this.player_radius = this.player_height;
        this.player_height = tmp;
    }

    public final void reset() {
        this.colz = true;
        this.colz_2 = true;
        this.col = false;
        this.onFloor = false;
        this.speed.set(0, 0, 0);
        this.transform.setIdentity();
    }

    public final void collisionTest(int part, House house) {
        if (!this.colz) {
            return;
        }
        tmpVec.set(this.transform.m03, this.transform.m13 + this.player_height, this.transform.m23);
        this.col = house.sphereCast(part, tmpVec, this.player_radius);
        int oldPosX = this.transform.m03;
        int oldPosZ = this.transform.m23;
        if (this.col) {
            this.transform.m03 = Character.tmpVec.x;
            this.transform.m13 = Character.tmpVec.y - this.player_height;
            this.transform.m23 = Character.tmpVec.z;
        }
        this.height.getPosition().set(this.transform.m03, this.transform.m13 + this.player_height, this.transform.m23);
        this.height.setHeight(this.transform.m13);
        this.height.setPolygon(null);
        house.computeHeightFull(part, this.height);
        RenderObject floorPoly = this.height.getPolygon();
        boolean bl = this.onFloor = floorPoly != null;
        if (this.onFloor) {
            if (this.oldFloorPoly == floorPoly) {
                this.transform.m03 += this.height.getCentreX() - this.oldFloorCx;
                this.transform.m13 += this.height.getCentreY() - this.oldFloorCy;
                this.transform.m23 += this.height.getCentreZ() - this.oldFloorCz;
            }
            this.transform.m13 = this.height.getHeight();
            this.oldFloorCx = this.height.getCentreX();
            this.oldFloorCz = this.height.getCentreZ();
            this.oldFloorCy = this.height.getCentreY();
        }
        this.oldFloorPoly = floorPoly;
        if (!this.height.updatePosition()) {
            this.oldFloorPoly = null;
        }
    }

    public final long distance(Character character) {
        Matrix var2 = this.transform;
        Matrix var5 = character.transform;
        int var3 = var2.m03 - var5.m03;
        int var4 = var2.m13 - var5.m13;
        int var6 = var2.m23 - var5.m23;
        return (long)var3 * (long)var3 + (long)var4 * (long)var4 + (long)var6 * (long)var6;
    }

    public final int distance(int x, int y, int z) {
        Matrix var2 = this.transform;
        int var3 = Math.abs(var2.m03 - x);
        int var4 = Math.abs(var2.m13 - y);
        int var6 = Math.abs(var2.m23 - z);
        return var3 + var4 + var6;
    }

    public static void collisionTest(Character body1, Character body2) {
        Matrix pos1 = body1.transform;
        Matrix pos2 = body2.transform;
        int rSum = body1.player_radius + body2.player_radius;
        int dx = pos1.m03 - pos2.m03;
        int dy = pos1.m13 - pos2.m13;
        int dz = pos1.m23 - pos2.m23;
        if (Math.abs(dx) > rSum || Math.abs(dy) > rSum || Math.abs(dz) > rSum) {
            return;
        }
        long r = (long)dx * (long)dx + (long)dy * (long)dy + (long)dz * (long)dz;
        if (r < (long)(rSum * rSum)) {
            if (r != 0L) {
                r = (int)(1.0f / MathUtils2.invSqrt(r));
            } else {
                dx = 1;
            }
            int dis = (int)((long)rSum - r);
            Vector3D dir = new Vector3D(dx, dy, dz);
            dir.setLength(dis / 2);
            if (body1.isCollider() && body2.isCollidable()) {
                Character.move(pos1, dir.x, dir.y, dir.z);
            }
            if (body2.isCollider() && body1.isCollidable()) {
                Character.move(pos2, -dir.x, -dir.y, -dir.z);
            }
        }
    }

    private static void move(Matrix matrix, int dx, int dy, int dz) {
        matrix.m03 += dx * 200 / Fps.getFps();
        matrix.m13 += dy * 200 / Fps.getFps();
        matrix.m23 += dz * 200 / Fps.getFps();
    }

    private static void move2(Matrix matrix, int dx, int dy, int dz) {
        matrix.m03 += dx;
        matrix.m13 += dy;
        matrix.m23 += dz;
    }

    public final void moveZ(int d) {
        if (this.onFloor) {
            this.speed.x += this.transform.m02 * d >> 14;
            this.speed.z += this.transform.m22 * d >> 14;
        }
    }

    public final void moveX(int d) {
        if (this.onFloor) {
            this.speed.x += this.transform.m00 * d >> 14;
            this.speed.z += this.transform.m20 * d >> 14;
        }
    }

    public final void drop(int angle) {
        this.matrix.setRotX(angle * 200 / Fps.getFps());
        this.transform.mul(this.matrix);
    }

    public final void rotY(int angle) {
        this.transform.rotY(angle);
    }

    public final void jump(int jump, float force) {
        if (this.onFloor) {
            this.speed.y += jump;
            this.speed.x = (int)((float)this.speed.x * force);
            this.speed.y = (int)((float)this.speed.y * force);
            this.speed.x = (int)((float)this.speed.x * force);
        }
    }

    public final void jumpArcade(int jump, float force) {
        this.speed.y += jump;
        this.speed.x = (int)((float)this.speed.x * force);
        this.speed.y = (int)((float)this.speed.y * force);
        this.speed.x = (int)((float)this.speed.x * force);
    }

    public final void update() {
        if (this.colz) {
            tmpVec.set(this.speed.x * 200 / Fps.getFps(), this.speed.y * 200 / Fps.getFps(), this.speed.z * 200 / Fps.getFps());
            int var1 = (int)((float)this.player_radius * 0.8f);
            if (tmpVec.lengthSquared() > var1 * var1) {
                tmpVec.setLength(var1);
            }
            this.transform.m03 += Character.tmpVec.x;
            this.transform.m13 += Character.tmpVec.y;
            this.transform.m23 += Character.tmpVec.z;
        }
    }

    public final Matrix getTransform() {
        return this.transform;
    }

    public final int getRadius() {
        return this.player_radius;
    }

    public final int getHeight() {
        return this.player_height;
    }

    public final Vector3D getSpeed() {
        return this.speed;
    }

    public final void setSpeedZero() {
        this.speed.set(0, 0, 0);
    }

    public final boolean isOnFloor() {
        return this.onFloor;
    }

    public final void setOnFloor(boolean floord) {
        this.onFloor = floord;
    }

    public final boolean isCollision() {
        return this.col;
    }

    public final void setCollision(boolean col) {
        this.colz = col;
    }

    public final boolean isCollider() {
        return this.colz;
    }

    public final void setCollidable(boolean col) {
        this.colz_2 = col;
    }

    public final boolean isCollidable() {
        return this.colz_2;
    }

    static {
        tmpVec = new Vector3D();
    }
}

