/*
 * Decompiled with CFR 0.152.
 */
package com.Gameplay.Map;

import com.Gameplay.Map.Room;
import com.Math.Matrix;
import com.Rendering.Graphics3D;
import com.Rendering.Meshes.M3GParser;
import com.Rendering.Meshes.Mesh;
import com.Rendering.MultyTexture;
import com.Rendering.Texture;
import com.misc.Asset;
import javax.microedition.lcdui.Graphics;
import javax.microedition.m3g.Appearance;

public class Skybox {
    private Matrix matrix;
    public MultyTexture texture;
    private Texture sky360;
    private int color;
    private byte mode = 0;
    private Mesh mesh;
    private int frame;
    private float x;
    private float y;
    public int x1;
    public int y1;
    public int x2;
    public int y2;
    private boolean resetViewport;
    public boolean skyboxAlways = false;
    public boolean draw = true;
    public boolean m3gRender = false;
    private M3GParser parser;
    private Appearance skyAppearance;

    public Skybox() {
    }

    public Skybox(String modelPath, String texturePath, boolean m3gRender2, int xx, int yy) {
        this.matrix = new Matrix();
        this.frame = 0;
        this.resetViewport = false;
        if (!m3gRender2) {
            this.texture = Asset.getMultyTexture(texturePath);
        }
        this.mesh = Room.loadMeshes(modelPath, 7.0f, 7.0f, 7.0f, this.texture)[0];
        this.mode = 0;
        this.skyboxAlways = false;
        this.m3gRender = m3gRender2;
        if (this.m3gRender) {
            this.parser = new M3GParser(xx, yy);
            this.skyAppearance = M3GParser.appearanceGenerator(texturePath);
        }
    }

    public Skybox(int colors) {
        this.frame = 0;
        this.resetViewport = false;
        this.color = colors;
        this.mode = 1;
        this.skyboxAlways = false;
    }

    public Skybox(Texture colors, float xx, float yy) {
        this.frame = 0;
        this.resetViewport = false;
        this.sky360 = colors;
        this.x = xx;
        this.y = yy;
        this.mode = (byte)2;
        this.skyboxAlways = false;
    }

    public void destroy() {
        this.matrix = null;
        if (this.texture != null) {
            this.texture.destroy();
        }
        this.texture = null;
        if (this.mesh != null) {
            this.mesh.destroy();
        }
        this.mesh = null;
        this.sky360 = null;
    }

    public void resetViewport() {
        this.resetViewport = true;
        this.draw = false;
    }

    public void addViewport(int ax1, int ay1, int ax2, int ay2) {
        if (this.resetViewport) {
            this.resetViewport = false;
            this.x1 = ax1;
            this.y1 = ay1;
            this.x2 = ax2;
            this.y2 = ay2;
        } else {
            if (ax1 < this.x1) {
                this.x1 = ax1;
            }
            if (ay1 < this.y1) {
                this.y1 = ay1;
            }
            if (ax2 > this.x2) {
                this.x2 = ax2;
            }
            if (ay2 > this.y2) {
                this.y2 = ay2;
            }
        }
    }

    public final void render(Graphics g, Graphics3D g3d) {
        if (this.skyboxAlways) {
            this.x1 = 0;
            this.y1 = 0;
            this.x2 = g3d.width;
            this.y2 = g3d.height;
        }
        if (this.mode == 0 && this.m3gRender) {
            this.renderM3G(g, g3d);
        } else if (this.mode == 0) {
            this.matrix.setIdentity();
            this.matrix.setPosition(g3d.getCamera().m03, g3d.getCamera().m13, g3d.getCamera().m23);
            Matrix fm = g3d.computeFinalMatrix(this.matrix);
            g3d.transformAndProjectVertices(this.mesh, fm);
            g3d.addMesh(this.mesh, this.x1, this.y1, this.x2, this.y2);
        } else if (this.mode == 1) {
            g3d.clearDisplay(this.color);
        } else if (this.mode == 2) {
            if (this.x2 - this.x1 == 0 || this.y2 - this.y1 == 0) {
                return;
            }
            int direction = Graphics3D.camera.getRotZHQ();
            int sizex = 455 * g3d.width / g3d.height;
            int sizey = 455;
            int beginx = (int)((float)((direction - sizex / 2) * this.sky360.rImg.w) * this.x / 2048.0f);
            int endx = (int)((float)((direction + sizex / 2) * this.sky360.rImg.w) * this.x / 2048.0f);
            int directiony = Math.min(Math.max(2048 - (1024 - Graphics3D.camera.m12 * 1024 / 16384), 227), 1821);
            int beginy = (int)((float)((directiony - 227) * this.sky360.rImg.h / 2048));
            int endy = (int)((float)((directiony + 227) * this.sky360.rImg.h) * this.y / 2048.0f);
            int fp = 12;
            int sx = beginx << 12;
            int sy = beginy << 12;
            int width = g3d.width;
            int height = g3d.height;
            int xstep = ((endx << 12) - sx) / width;
            int ystep = ((endy << 12) - sy) / height;
            this.render2D(g3d, sx, sy, xstep, ystep);
        }
    }

    void renderM3G(Graphics g, Graphics3D g3d) {
        g3d.clearDisplay(0);
        g3d.flushAlpha = true;
        this.matrix.setIdentity();
        this.matrix.setPosition(g3d.getCamera().m03, g3d.getCamera().m13, g3d.getCamera().m23);
        Matrix fm = g3d.computeFinalMatrix(this.matrix);
        g3d.transformAndProjectVertices(this.mesh, fm);
        this.parser.meshRender(this.mesh, this.x1, this.y1, this.x2, this.y2, this.skyAppearance, g3d, g);
    }

    void render2DLOFIx2(Graphics3D g3d, int sx, int sy, int xstep, int ystep) {
        int texw = this.sky360.rImg.w;
        int texh = this.sky360.rImg.h;
        int texs = this.sky360.rImg.img.length - 1;
        int fp = 12;
        while (sy < 0) {
            sy += texh << 12;
        }
        sy += ystep * this.y1;
        while (sx < 0) {
            sx += texw << 12;
        }
        int sxx = sx;
        int width = g3d.width;
        int height = g3d.height;
        int[] tex = this.sky360.rImg.img;
        for (int scry = this.y1; scry < this.y2; ++scry) {
            int rx1 = width * scry;
            int rx2 = width + rx1;
            sx = sxx;
            int ysa = (sy >> 12) % texh * texw;
            int c = (rx2 - rx1) / 5;
            if (this.x1 > 0) {
                rx1 += this.x1;
                sx += xstep * this.x1;
            }
            if (this.x2 < width) {
                rx2 -= width - this.x2;
            }
            while (rx2 - rx1 >= 2) {
                int col;
                g3d.display[rx1] = col = tex[((sx >> 12) % texw + ysa) % texs];
                g3d.display[rx1 + 1] = col;
                sx += xstep << 1;
                rx1 += 2;
            }
            while (rx1 < rx2) {
                g3d.display[rx1] = tex[((sx >> 12) % texw + ysa) % texs];
                sx += xstep;
                ++rx1;
            }
            sy += ystep;
        }
    }

    void render2D(Graphics3D g3d, int sx, int sy, int xstep, int ystep) {
        int texw = this.sky360.rImg.w;
        int texh = this.sky360.rImg.h;
        int texs = this.sky360.getPixels().length - 1;
        int fp = 12;
        while (sy < 0) {
            sy += texh << 12;
        }
        sy += ystep * this.y1;
        while (sx < 0) {
            sx += texw << 12;
        }
        int sxx = sx;
        int width = g3d.width;
        int height = g3d.height;
        int[] rgb = g3d.display;
        int[] tex = this.sky360.rImg.img;
        for (int scry = this.y1; scry < this.y2; ++scry) {
            int rx1 = width * scry;
            int rx2 = width + rx1;
            sx = sxx;
            int ysa = (sy >> 12) % texh * texw;
            if (this.x1 > 0) {
                rx1 += this.x1;
                sx += xstep * this.x1;
            }
            if (this.x2 < width) {
                rx2 -= width - this.x2;
            }
            while (rx2 - rx1 >= 4) {
                rgb[rx1] = tex[((sx >> 12) % texw + ysa) % texs];
                rgb[rx1 + 1] = tex[(((sx += xstep) >> 12) % texw + ysa) % texs];
                rgb[rx1 + 2] = tex[(((sx += xstep) >> 12) % texw + ysa) % texs];
                rgb[rx1 + 3] = tex[(((sx += xstep) >> 12) % texw + ysa) % texs];
                sx += xstep;
                rx1 += 4;
            }
            while (rx1 < rx2) {
                rgb[rx1] = tex[((sx >> 12) % texw + ysa) % texs];
                sx += xstep;
                ++rx1;
            }
            sy += ystep;
        }
    }

    public Mesh getMesh() {
        return this.mesh;
    }
}

