/*
 * Decompiled with CFR 0.152.
 */
package com.AI.misc;

import com.Gameplay.Objects.GameObject;
import com.Math.Matrix;
import com.Rendering.Graphics3D;
import com.Rendering.Meshes.BoundingBox;
import com.Rendering.Meshes.MeshImage;
import com.Rendering.Meshes.Sprite;
import com.Rendering.MultyTexture;

public final class Corpse
extends GameObject {
    private final MultyTexture mtex;
    private int f = 0;
    private final int frame;
    private final Matrix mat = new Matrix();
    private final MeshImage meshImage;
    public Sprite spr;
    private BoundingBox boundingBox;

    public Corpse(int frame2, Matrix matrix2, MeshImage mesh, MultyTexture tex) {
        this.mat.set(matrix2);
        if (mesh != null) {
            this.meshImage = new MeshImage(mesh.getMesh(), mesh.getAnimation());
            this.boundingBox = new BoundingBox(mesh.getAnimation());
        } else {
            this.meshImage = null;
        }
        this.mtex = tex;
        this.frame = frame2;
        this.character.reset();
        this.character.getTransform().set(this.mat);
        this.character.setCollision(false);
        this.character.setCollidable(false);
        this.character.setOnFloor(true);
        this.character.setSpeedZero();
    }

    protected final boolean isNeedRecomputePart() {
        return this.getFrame() == 0;
    }

    public final void render(Graphics3D g3d, int x1, int y1, int x2, int y2) {
        if (this.f <= 3600) {
            this.setHp(100);
        }
        ++this.f;
        if (this.f > 3600) {
            this.setHp(0);
        }
        if (this.meshImage != null) {
            this.meshImage.getAnimation().setFrame(this.frame);
            Matrix fmat = g3d.computeFinalMatrix(this.mat);
            if (!this.boundingBox.isVisible(g3d, fmat, x1, y1, x2, y2)) {
                return;
            }
            this.meshImage.setMatrix(fmat);
            this.meshImage.setTexture(this.mtex);
            g3d.addRenderObject(this.meshImage, x1, y1, x2, y2);
            this.meshImage.sz += 5900;
            if (this.character.oldFloorPoly != null && this.character.oldFloorPoly.sz > this.meshImage.sz) {
                this.character.oldFloorPoly.sz = this.meshImage.sz - 1;
            }
        } else {
            this.spr.getPosition().set(this.getPosX(), this.getPosY(), this.getPosZ());
            this.spr.updateFrame();
            this.spr.project(g3d.getInvCamera(), g3d);
            if (!this.spr.isVisible(x1, y1, x2, y2)) {
                return;
            }
            g3d.addRenderObject(this.spr, x1, y1, x2, y2);
            this.spr.sz += 5900;
            if (this.character.oldFloorPoly != null && this.character.oldFloorPoly.sz > this.spr.sz) {
                this.character.oldFloorPoly.sz = this.spr.sz - 1;
            }
        }
    }
}

