/*
 * Decompiled with CFR 0.152.
 */
package com.Audio;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import javax.microedition.media.Manager;
import javax.microedition.media.Player;
import javax.microedition.media.control.VolumeControl;

public class Sound {
    private ByteArrayInputStream bis;
    private Player player;

    public static final String formatCheck(String var2) {
        if (var2.endsWith(".wav") || var2.endsWith(".wave")) {
            return "audio/X-wav";
        }
        if (var2.endsWith(".midi") || var2.endsWith(".mid")) {
            return "audio/midi";
        }
        if (var2.endsWith(".mp3")) {
            return "audio/mpeg";
        }
        if (var2.endsWith(".amr")) {
            return "audio/amr";
        }
        if (var2.endsWith(".jts")) {
            return "audio/x-tone-seq";
        }
        if (var2.endsWith(".ac3")) {
            return "audio/ac3";
        }
        if (var2.endsWith(".ogg")) {
            return "audio/ogg";
        }
        if (var2.endsWith(".vorbis")) {
            return "audio/vorbis";
        }
        if (var2.endsWith(".xmf") || var2.endsWith(".mxmf")) {
            return "audio/mobile-xmf";
        }
        if (var2.endsWith(".mmf")) {
            return "application/vnd.yamaha.smaf-audio";
        }
        return "";
    }

    public Sound(String name) {
        try {
            String t = name.toLowerCase();
            String type = Sound.formatCheck(t);
            InputStream is = this.getClass().getResourceAsStream(name);
            byte[] snd = new byte[is.available()];
            is.read(snd);
            this.bis = new ByteArrayInputStream(snd);
            this.player = Manager.createPlayer((InputStream)this.bis, (String)type);
            this.player.realize();
            this.player.prefetch();
            this.player.setLoopCount(1);
            this.player.start();
            this.player.stop();
        }
        catch (Exception exc) {
            System.err.println("ERROR in Sound initialization " + name + ": " + exc);
        }
    }

    public void setLoop(int count) {
        if (this.player == null) {
            return;
        }
        try {
            this.player.setLoopCount(count);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void start(int volume) {
        if (this.player == null) {
            return;
        }
        try {
            this.player.setMediaTime(0L);
            this.setVolume(volume);
            this.player.start();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void stop() {
        if (this.player == null) {
            return;
        }
        try {
            this.player.stop();
            this.player.deallocate();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void stopND() {
        if (this.player == null) {
            return;
        }
        try {
            this.player.stop();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void setVolume(int i) {
        VolumeControl control;
        if (this.player == null) {
            return;
        }
        if (i < 1) {
            i = 1;
        }
        if (i > 100) {
            i = 100;
        }
        if ((control = (VolumeControl)this.player.getControl("VolumeControl")) != null) {
            control.setLevel(i);
        }
    }

    public void destroy() {
        try {
            if (this.player != null) {
                this.stop();
                this.bis.close();
                this.player.close();
            }
            this.bis = null;
            this.player = null;
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

