/*
 * Decompiled with CFR 0.152.
 */
package com.Math;

import com.Math.Vector3D;
import com.Rendering.Vertex;

public final class MathUtils {
    public static float invSqrt(float val) {
        float var1 = 0.5f * val;
        int var2 = Float.floatToIntBits(val);
        var2 = 1597463007 - (var2 >> 1);
        val = Float.intBitsToFloat(var2);
        return val * (1.5f - var1 * val * val);
    }

    public static Vector3D createNormal(Vector3D a, Vector3D b, Vector3D c) {
        Vector3D nor = new Vector3D();
        MathUtils.computeNormal(nor, a, b, c);
        return nor;
    }

    public static void calcNormal(Vector3D nor, int ax, int ay, int az, int bx, int by, int bz, int cx, int cy, int cz) {
        double x = (long)(ay - by) * (long)(az - cz) - (long)(az - bz) * (long)(ay - cy);
        double y = (long)(az - bz) * (long)(ax - cx) - (long)(ax - bx) * (long)(az - cz);
        double z = (long)(ax - bx) * (long)(ay - cy) - (long)(ay - by) * (long)(ax - cx);
        double sqrt = Math.sqrt(x * x + y * y + z * z) / 4096.0;
        nor.set((int)(x / sqrt), (int)(y / sqrt), (int)(z / sqrt));
    }

    public static void computeNormal(Vector3D nor, Vector3D a, Vector3D b, Vector3D c) {
        long x = (long)(a.y - b.y) * (long)(a.z - c.z) - (long)(a.z - b.z) * (long)(a.y - c.y);
        long y = (long)(a.z - b.z) * (long)(a.x - c.x) - (long)(a.x - b.x) * (long)(a.z - c.z);
        long z = (long)(a.x - b.x) * (long)(a.y - c.y) - (long)(a.y - b.y) * (long)(a.x - c.x);
        double sqrt = Math.sqrt(x * x + y * y + z * z) / 4096.0;
        nor.set((int)((double)x / sqrt), (int)((double)y / sqrt), (int)((double)z / sqrt));
    }

    public static Vector3D createNormal(int ax, int ay, int az, int bx, int by, int bz, int cx, int cy, int cz) {
        double var9 = (long)(ay - by) * (long)(az - cz) - (long)(az - bz) * (long)(ay - cy);
        double var11 = (long)(az - bz) * (long)(ax - cx) - (long)(ax - bx) * (long)(az - cz);
        double var13 = (long)(ax - bx) * (long)(ay - cy) - (long)(ay - by) * (long)(ax - cx);
        double var15 = Math.sqrt(var9 * var9 + var11 * var11 + var13 * var13) / 4096.0;
        return new Vector3D((int)(var9 / var15), (int)(var11 / var15), (int)(var13 / var15));
    }

    public static int distanceToLine(Vector3D point, Vector3D a, Vector3D b) {
        int var3 = b.x - a.x;
        int var4 = b.y - a.y;
        int var13 = b.z - a.z;
        int var5 = point.x - a.x;
        int var6 = point.y - a.y;
        int var7 = point.z - a.z;
        long var9 = (long)var3 * (long)var3 + (long)(var4 * var4) + (long)(var13 * var13);
        long var11 = 0L;
        if (var9 != 0L) {
            var11 = ((long)var5 * (long)var3 + (long)(var6 * var4) + (long)(var7 * var13) << 14) / var9;
        }
        if (var11 < 0L) {
            var11 = 0L;
        }
        if (var11 > 16384L) {
            var11 = 16384L;
        }
        var3 = a.x + (int)((long)var3 * var11 >> 14);
        var4 = a.y + (int)((long)var4 * var11 >> 14);
        var13 = a.z + (int)((long)var13 * var11 >> 14);
        return (var3 -= point.x) * var3 + (var4 -= point.y) * var4 + (var13 -= point.z) * var13;
    }

    public static int distanceToRay(Vector3D point, Vector3D a, Vector3D dir) {
        int var3 = dir.x;
        int var4 = dir.y;
        int var13 = dir.z;
        int var5 = point.x - a.x;
        int var6 = point.y - a.y;
        int var7 = point.z - a.z;
        long var9 = var3 * var3 + var4 * var4 + var13 * var13;
        long var11 = 0L;
        if (var9 != 0L) {
            var11 = ((long)var5 * (long)var3 + (long)(var6 * var4) + (long)(var7 * var13) << 14) / var9;
        }
        if (var11 < 0L) {
            var11 = 0L;
        }
        if (var11 > 16384L) {
            var11 = 16384L;
        }
        var3 = a.x + (int)((long)var3 * var11 >> 14);
        var4 = a.y + (int)((long)var4 * var11 >> 14);
        var13 = a.z + (int)((long)var13 * var11 >> 14);
        return (var3 -= point.x) * var3 + (var4 -= point.y) * var4 + (var13 -= point.z) * var13;
    }

    public static boolean isPointOnPolygon(Vector3D a, Vector3D b, Vector3D c, Vector3D normal, Vector3D point) {
        int var7;
        int var5 = normal.x > 0 ? normal.x : -normal.x;
        int var6 = normal.y > 0 ? normal.y : -normal.y;
        int n = var7 = normal.z > 0 ? normal.z : -normal.z;
        return var5 >= var6 && var5 >= var7 ? (normal.x >= 0 ? MathUtils.isPointOnPolygon(point.z, point.y, a.z, a.y, b.z, b.y, c.z, c.y) : MathUtils.isPointOnPolygon(point.z, point.y, c.z, c.y, b.z, b.y, a.z, a.y)) : (var6 >= var5 && var6 >= var7 ? (normal.y >= 0 ? MathUtils.isPointOnPolygon(point.x, point.z, a.x, a.z, b.x, b.z, c.x, c.z) : MathUtils.isPointOnPolygon(point.x, point.z, c.x, c.z, b.x, b.z, a.x, a.z)) : (var7 >= var5 && var7 >= var6 ? (normal.z <= 0 ? MathUtils.isPointOnPolygon(point.x, point.y, a.x, a.y, b.x, b.y, c.x, c.y) : MathUtils.isPointOnPolygon(point.x, point.y, c.x, c.y, b.x, b.y, a.x, a.y)) : true));
    }

    public static boolean isPointOnPolygon(int px, int py, int x1, int y1, int x2, int y2, int x3, int y3) {
        return (x2 - x1) * (py - y1) - (px - x1) * (y2 - y1) > 0 ? false : ((x3 - x2) * (py - y2) - (px - x2) * (y3 - y2) > 0 ? false : (x1 - x3) * (py - y3) - (px - x3) * (y1 - y3) <= 0);
    }

    public static boolean isPointOnPolygon(Vector3D a, Vector3D b, Vector3D c, Vector3D d, Vector3D normal, Vector3D point) {
        int var8;
        int var6 = normal.x > 0 ? normal.x : -normal.x;
        int var7 = normal.y > 0 ? normal.y : -normal.y;
        int n = var8 = normal.z > 0 ? normal.z : -normal.z;
        return var6 >= var7 && var6 >= var8 ? (normal.x >= 0 ? MathUtils.isPointOnPolygon(point.z, point.y, a.z, a.y, b.z, b.y, c.z, c.y, d.z, d.y) : MathUtils.isPointOnPolygon(point.z, point.y, d.z, d.y, c.z, c.y, b.z, b.y, a.z, a.y)) : (var7 >= var6 && var7 >= var8 ? (normal.y >= 0 ? MathUtils.isPointOnPolygon(point.x, point.z, a.x, a.z, b.x, b.z, c.x, c.z, d.x, d.z) : MathUtils.isPointOnPolygon(point.x, point.z, d.x, d.z, c.x, c.z, b.x, b.z, a.x, a.z)) : (var8 >= var6 && var8 >= var7 ? (normal.z <= 0 ? MathUtils.isPointOnPolygon(point.x, point.y, a.x, a.y, b.x, b.y, c.x, c.y, d.x, d.y) : MathUtils.isPointOnPolygon(point.x, point.y, d.x, d.y, c.x, c.y, b.x, b.y, a.x, a.y)) : true));
    }

    public static boolean isPointOnPolygon(int px, int py, int x1, int y1, int x2, int y2, int x3, int y3, int x4, int y4) {
        return (x2 - x1) * (py - y1) - (px - x1) * (y2 - y1) > 0 ? false : ((x3 - x2) * (py - y2) - (px - x2) * (y3 - y2) > 0 ? false : ((x4 - x3) * (py - y3) - (px - x3) * (y4 - y3) > 0 ? false : (x1 - x4) * (py - y4) - (px - x4) * (y1 - y4) <= 0));
    }

    public static boolean isPointOnPolygon(int px, int pz, Vertex a, Vertex b, Vertex c, int norY) {
        return norY > 0 ? MathUtils.isPointOnPolygon(px, pz, a.x, a.z, b.x, b.z, c.x, c.z) : (norY < 0 ? MathUtils.isPointOnPolygon(px, pz, c.x, c.z, b.x, b.z, a.x, a.z) : false);
    }

    public static boolean isPointOnPolygon(int px, int pz, Vertex a, Vertex b, Vertex c, Vertex d, int norY) {
        return norY > 0 ? MathUtils.isPointOnPolygon(px, pz, a.x, a.z, b.x, b.z, c.x, c.z, d.x, d.z) : (norY < 0 ? MathUtils.isPointOnPolygon(px, pz, d.x, d.z, c.x, c.z, b.x, b.z, a.x, a.z) : false);
    }

    public static int calcLight(int nx, int ny, int nz, int sx, int sy, int sz) {
        while (Math.abs(sx) > 30000 || Math.abs(sy) > 30000 || Math.abs(sz) > 30000) {
            sx /= 2;
            sy /= 2;
            sz /= 2;
        }
        while (Math.abs(nx) > 30000 || Math.abs(ny) > 30000 || Math.abs(nz) > 30000) {
            nx /= 2;
            ny /= 2;
            nz /= 2;
        }
        double nw = Math.sqrt(nx * nx + ny * ny + nz * nz);
        double lw = Math.sqrt(sx * sx + sy * sy + sz * sz);
        if (nw < 1.0) {
            nw = 1.0;
        }
        if (lw < 1.0) {
            lw = 1.0;
        }
        double l = (double)(nx * sx + ny * sy + nz * sz) / (nw * lw);
        return Math.min(Math.max((int)(l * 256.0), 0), 255);
    }

    public static int getAnglez(int x, int y, int x1, int y1) {
        int anglez = 0;
        int dist = Math.abs(x - x1) + Math.abs(y - y1);
        if (dist == 0) {
            return 0;
        }
        int xx = (x - x1) * 4000 / dist;
        int yy = (y - y1) * 4000 / dist;
        if (xx < 4000 && xx > 0 && yy > 0) {
            xx = 0;
        }
        if (xx > 0) {
            anglez += xx * 360;
        }
        if (xx < 0) {
            anglez -= xx * 180;
        }
        if (yy > 0) {
            anglez += yy * 90;
        }
        if (yy < 0) {
            anglez -= yy * 270;
        }
        anglez /= 4000;
        anglez -= 90;
        anglez = MathUtils.fixDegree(anglez);
        return anglez;
    }

    public static int getAnglezHQ(int x, int y, int x1, int y1) {
        int anglez = 0;
        int dist = Math.abs(x - x1) + Math.abs(y - y1);
        if (dist == 0) {
            return 0;
        }
        int xx = (x - x1) * 4000 / dist;
        int yy = (y - y1) * 4000 / dist;
        if (xx < 4000 && xx > 0 && yy > 0) {
            xx = 0;
        }
        if (xx > 0) {
            anglez += xx * 2048;
        }
        if (xx < 0) {
            anglez -= xx * 1024;
        }
        if (yy > 0) {
            anglez += yy * 512;
        }
        if (yy < 0) {
            anglez -= yy * 1536;
        }
        anglez /= 4000;
        anglez -= 512;
        anglez = MathUtils.fixDegree2(anglez);
        return anglez;
    }

    public static int fixDegree(int degree) {
        while (degree < 0) {
            degree += 360;
        }
        while (degree >= 360) {
            degree -= 360;
        }
        return degree;
    }

    public static int fixDegree2(int degree) {
        while (degree < 0) {
            degree += 2048;
        }
        while (degree >= 2048) {
            degree -= 2048;
        }
        return degree;
    }

    public static int mix(int a, int b, int i, int max) {
        if (i == 0) {
            return a;
        }
        if (i == max) {
            return b;
        }
        return (a * (max - i) + b * i) / max;
    }
}

