/*
 * Decompiled with CFR 0.152.
 */
package com.Rendering;

import com.Gameplay.Map.LightMapper;
import com.Math.MathUtils;
import com.Rendering.Graphics3D;
import com.Rendering.Texture;
import com.Rendering.TexturingAffine;
import com.Rendering.TexturingFloorsWalls;
import com.Rendering.Vertex;
import com.misc.Main;

public class TexturingPers {
    public static final int fp = 12;
    public static final int FP = 4096;

    public static final void paintWalls(Graphics3D g3d, Texture texture, Vertex a, int au, int av, Vertex b, int bu, int bv, Vertex c, int cu, int cv, int fogc, byte fog, int qz, int q, int al, int bl, int cl, short nx, short ny, short nz) {
        int x_end;
        int x_start;
        int tb;
        Vertex t;
        if (!texture.alphaMixing && texture.drawmode == 4) {
            fog = 0;
        }
        au = au * texture.rImg.w >> 8;
        bu = bu * texture.rImg.w >> 8;
        cu = cu * texture.rImg.w >> 8;
        av = av * texture.rImg.h >> 8;
        bv = bv * texture.rImg.h >> 8;
        cv = cv * texture.rImg.h >> 8;
        if (fog == 8) {
            TexturingAffine.paintFill(g3d, a, b, c, texture, au, av);
            return;
        }
        if (fog == 10) {
            TexturingAffine.paintDitherGradient(g3d, texture, a, al, b, bl, c, cl);
            return;
        }
        if (fog == 11) {
            al = 255 + a.rz * 255 / Graphics3D.waterDistance;
            if (al > 255) {
                al = 255;
            }
            if (al < 0) {
                al = 0;
            }
            if ((bl = 255 + b.rz * 255 / Graphics3D.waterDistance) > 255) {
                bl = 255;
            }
            if (bl < 0) {
                bl = 0;
            }
            if ((cl = 255 + c.rz * 255 / Graphics3D.waterDistance) > 255) {
                cl = 255;
            }
            if (cl < 0) {
                cl = 0;
            }
            TexturingAffine.paintDitherGradient(g3d, texture, a, al, b, bl, c, cl);
            return;
        }
        if (fog == 12) {
            al = 255 + a.rz * 255 / Graphics3D.fDist;
            if (al > 255) {
                al = 255;
            }
            if (al < 0) {
                al = 0;
            }
            if ((bl = 255 + b.rz * 255 / Graphics3D.fDist) > 255) {
                bl = 255;
            }
            if (bl < 0) {
                bl = 0;
            }
            if ((cl = 255 + c.rz * 255 / Graphics3D.fDist) > 255) {
                cl = 255;
            }
            if (cl < 0) {
                cl = 0;
            }
            TexturingAffine.paintDitherGradient(g3d, texture, a, al, b, bl, c, cl);
            return;
        }
        if (b.sx < a.sx) {
            t = a;
            a = b;
            b = t;
            tb = au;
            au = bu;
            bu = tb;
            tb = av;
            av = bv;
            bv = tb;
            tb = al;
            al = bl;
            bl = tb;
        }
        if (c.sx < a.sx) {
            t = c;
            c = a;
            a = t;
            tb = cu;
            cu = au;
            au = tb;
            tb = cv;
            cv = av;
            av = tb;
            tb = cl;
            cl = al;
            al = tb;
        }
        if (c.sx < b.sx) {
            t = b;
            b = c;
            c = t;
            tb = bu;
            bu = cu;
            cu = tb;
            tb = bv;
            bv = cv;
            cv = tb;
            tb = bl;
            bl = cl;
            cl = tb;
        }
        if (a.sx == c.sx) {
            return;
        }
        int cf = 255;
        int bf = 255;
        int af = 255;
        if (Graphics3D.fDist > 1) {
            af = 255 + a.rz * 255 / Graphics3D.fDist;
            if (af > 255) {
                af = 255;
            }
            if (af < 0) {
                af = 0;
            }
            if ((bf = 255 + b.rz * 255 / Graphics3D.fDist) > 255) {
                bf = 255;
            }
            if (bf < 0) {
                bf = 0;
            }
            if ((cf = 255 + c.rz * 255 / Graphics3D.fDist) > 255) {
                cf = 255;
            }
            if (cf < 0) {
                cf = 0;
            }
        }
        if (texture.drawmode == 9) {
            af = al;
            bf = bl;
            cf = cl;
        }
        if (LightMapper.cameraVectorLight && texture.drawmode == 6) {
            af = af * MathUtils.calcLight(nx, ny, nz, a.x - g3d.getCamera().m03, a.y - g3d.getCamera().m13, a.z - g3d.getCamera().m23) / 255;
            bf = bf * MathUtils.calcLight(nx, ny, nz, b.x - g3d.getCamera().m03, b.y - g3d.getCamera().m13, b.z - g3d.getCamera().m23) / 255;
            cf = cf * MathUtils.calcLight(nx, ny, nz, c.x - g3d.getCamera().m03, c.y - g3d.getCamera().m13, c.z - g3d.getCamera().m23) / 255;
        }
        if ((fog == 5 || fog == 6 || fog == 9) && af < 1 && bf < 1 && cf < 1) {
            TexturingAffine.paintFill(g3d, a, b, c, 0);
            return;
        }
        int W_UNIT = 0x40000000;
        int tempI = 262294;
        int awz = a.rz < 0 ? tempI / (-a.rz + 150) : tempI / 150;
        int bwz = b.rz < 0 ? tempI / (-b.rz + 150) : tempI / 150;
        int cwz = c.rz < 0 ? tempI / (-c.rz + 150) : tempI / 150;
        int auz = au * awz;
        int avz = av * awz;
        int buz = bu * bwz;
        int bvz = bv * bwz;
        int cuz = cu * cwz;
        int cvz = cv * cwz;
        tempI = c.sx - a.sx;
        int dy_start = (c.sy - a.sy << 12) / tempI;
        int dwz_start = (cwz - awz << 12) / tempI;
        int duz_start = (cuz - auz << 12) / tempI;
        int dvz_start = (cvz - avz << 12) / tempI;
        int df_start = (cf - af << 12) / tempI;
        int dy_end = 0;
        int dwz_end = 0;
        int duz_end = 0;
        int dvz_end = 0;
        int df_end = 0;
        if (b.sx != a.sx) {
            tempI = b.sx - a.sx;
            dy_end = (b.sy - a.sy << 12) / tempI;
            dwz_end = (bwz - awz << 12) / tempI;
            duz_end = (buz - auz << 12) / tempI;
            dvz_end = (bvz - avz << 12) / tempI;
            df_end = (bf - af << 12) / tempI;
        }
        tempI = b.sx - a.sx;
        int y_start = (a.sy << 12) + dy_start * tempI;
        int wz_start = (awz << 12) + dwz_start * tempI;
        int uz_start = (auz << 12) + duz_start * tempI;
        int vz_start = (avz << 12) + dvz_start * tempI;
        int f_start = (af << 12) + df_start * tempI;
        int y_end = b.sy << 12;
        int wz_end = bwz << 12;
        int uz_end = buz << 12;
        int vz_end = bvz << 12;
        int f_end = bf << 12;
        tempI = y_start - y_end >> 12;
        if (tempI == 0) {
            return;
        }
        int duz = (uz_start - uz_end) / tempI;
        int dvz = (vz_start - vz_end) / tempI;
        int dwz = (wz_start - wz_end) / tempI;
        int df = (f_start - f_end) / tempI;
        y_start = y_end = a.sy << 12;
        wz_start = wz_end = awz << 12;
        uz_start = uz_end = auz << 12;
        vz_start = vz_end = avz << 12;
        f_start = f_end = af << 12;
        if (b.sx > 0) {
            x_start = a.sx;
            if (x_start < 0) {
                y_start -= dy_start * x_start;
                wz_start -= dwz_start * x_start;
                uz_start -= duz_start * x_start;
                vz_start -= dvz_start * x_start;
                f_start -= df_start * x_start;
                y_end -= dy_end * x_start;
                wz_end -= dwz_end * x_start;
                uz_end -= duz_end * x_start;
                vz_end -= dvz_end * x_start;
                f_end -= df_end * x_start;
                x_start = 0;
            }
            int n = x_end = b.sx < g3d.width ? b.sx : g3d.width;
            if (fog == 0) {
                TexturingFloorsWalls.paintWall(g3d, texture, y_start, y_end, x_start, wz_start, uz_start, vz_start, x_end, wz_end, uz_end, vz_end, dy_start, dwz_start, duz_start, dvz_start, dy_end, dwz_end, duz_end, dvz_end, dwz, duz, dvz, q);
            } else if (fog == 1) {
                TexturingFloorsWalls.paintWall_1(g3d, texture, y_start, y_end, x_start, wz_start, uz_start, vz_start, x_end, wz_end, uz_end, vz_end, dy_start, dwz_start, duz_start, dvz_start, dy_end, dwz_end, duz_end, dvz_end, dwz, duz, dvz, qz);
            } else if (fog == 2) {
                TexturingFloorsWalls.paintWall_2(g3d, texture, y_start, y_end, x_start, wz_start, uz_start, vz_start, x_end, wz_end, uz_end, vz_end, dy_start, dwz_start, duz_start, dvz_start, dy_end, dwz_end, duz_end, dvz_end, dwz, duz, dvz);
            } else if (fog == 3) {
                TexturingFloorsWalls.paintWall_3(g3d, texture, y_start, y_end, x_start, wz_start, uz_start, vz_start, x_end, wz_end, uz_end, vz_end, dy_start, dwz_start, duz_start, dvz_start, dy_end, dwz_end, duz_end, dvz_end, dwz, duz, dvz, fogc, qz, a, b, c, f_start, f_end, df_start, df_end, df);
            } else if (fog == 4) {
                TexturingFloorsWalls.paintWall_4(g3d, texture, y_start, y_end, x_start, wz_start, uz_start, vz_start, x_end, wz_end, uz_end, vz_end, dy_start, dwz_start, duz_start, dvz_start, dy_end, dwz_end, duz_end, dvz_end, dwz, duz, dvz);
            } else if (fog == 6 && Main.fogQ == 2) {
                TexturingFloorsWalls.paintWall_6_HQ(g3d, texture, y_start, y_end, x_start, wz_start, uz_start, vz_start, x_end, wz_end, uz_end, vz_end, dy_start, dwz_start, duz_start, dvz_start, dy_end, dwz_end, duz_end, dvz_end, dwz, duz, dvz, a, b, c, f_start, f_end, df_start, df_end, df);
            } else if (fog == 9 && Main.fogQ == 2) {
                TexturingFloorsWalls.paintWall_9_HQ(g3d, texture, y_start, y_end, x_start, wz_start, uz_start, vz_start, x_end, wz_end, uz_end, vz_end, dy_start, dwz_start, duz_start, dvz_start, dy_end, dwz_end, duz_end, dvz_end, dwz, duz, dvz, a, b, c, f_start, f_end, df_start, df_end, df);
            }
        }
        if (c.sx == b.sx || c.sx < 0) {
            return;
        }
        tempI = b.sx - a.sx;
        y_start = (a.sy << 12) + dy_start * tempI;
        wz_start = (awz << 12) + dwz_start * tempI;
        uz_start = (auz << 12) + duz_start * tempI;
        vz_start = (avz << 12) + dvz_start * tempI;
        f_start = (af << 12) + df_start * tempI;
        y_end = b.sy << 12;
        wz_end = bwz << 12;
        uz_end = buz << 12;
        vz_end = bvz << 12;
        f_end = bf << 12;
        tempI = c.sx - b.sx;
        dy_end = (c.sy - b.sy << 12) / tempI;
        dwz_end = (cwz - bwz << 12) / tempI;
        duz_end = (cuz - buz << 12) / tempI;
        dvz_end = (cvz - bvz << 12) / tempI;
        df_end = (cf - bf << 12) / tempI;
        x_start = b.sx;
        if (x_start < 0) {
            y_start -= dy_start * x_start;
            wz_start -= dwz_start * x_start;
            uz_start -= duz_start * x_start;
            vz_start -= dvz_start * x_start;
            f_start -= df_start * x_start;
            y_end -= dy_end * x_start;
            wz_end -= dwz_end * x_start;
            uz_end -= duz_end * x_start;
            vz_end -= dvz_end * x_start;
            f_end -= df_end * x_start;
            x_start = 0;
        }
        int n = x_end = c.sx < g3d.width ? c.sx : g3d.width;
        if (fog == 0) {
            TexturingFloorsWalls.paintWall(g3d, texture, y_start, y_end, x_start, wz_start, uz_start, vz_start, x_end, wz_end, uz_end, vz_end, dy_start, dwz_start, duz_start, dvz_start, dy_end, dwz_end, duz_end, dvz_end, dwz, duz, dvz, q);
        } else if (fog == 1) {
            TexturingFloorsWalls.paintWall_1(g3d, texture, y_start, y_end, x_start, wz_start, uz_start, vz_start, x_end, wz_end, uz_end, vz_end, dy_start, dwz_start, duz_start, dvz_start, dy_end, dwz_end, duz_end, dvz_end, dwz, duz, dvz, qz);
        } else if (fog == 2) {
            TexturingFloorsWalls.paintWall_2(g3d, texture, y_start, y_end, x_start, wz_start, uz_start, vz_start, x_end, wz_end, uz_end, vz_end, dy_start, dwz_start, duz_start, dvz_start, dy_end, dwz_end, duz_end, dvz_end, dwz, duz, dvz);
        } else if (fog == 3) {
            TexturingFloorsWalls.paintWall_3(g3d, texture, y_start, y_end, x_start, wz_start, uz_start, vz_start, x_end, wz_end, uz_end, vz_end, dy_start, dwz_start, duz_start, dvz_start, dy_end, dwz_end, duz_end, dvz_end, dwz, duz, dvz, fogc, qz, a, b, c, f_start, f_end, df_start, df_end, df);
        } else if (fog == 4) {
            TexturingFloorsWalls.paintWall_4(g3d, texture, y_start, y_end, x_start, wz_start, uz_start, vz_start, x_end, wz_end, uz_end, vz_end, dy_start, dwz_start, duz_start, dvz_start, dy_end, dwz_end, duz_end, dvz_end, dwz, duz, dvz);
        } else if (fog == 6 && Main.fogQ == 2) {
            TexturingFloorsWalls.paintWall_6_HQ(g3d, texture, y_start, y_end, x_start, wz_start, uz_start, vz_start, x_end, wz_end, uz_end, vz_end, dy_start, dwz_start, duz_start, dvz_start, dy_end, dwz_end, duz_end, dvz_end, dwz, duz, dvz, a, b, c, f_start, f_end, df_start, df_end, df);
        } else if (fog == 9 && Main.fogQ == 2) {
            TexturingFloorsWalls.paintWall_9_HQ(g3d, texture, y_start, y_end, x_start, wz_start, uz_start, vz_start, x_end, wz_end, uz_end, vz_end, dy_start, dwz_start, duz_start, dvz_start, dy_end, dwz_end, duz_end, dvz_end, dwz, duz, dvz, a, b, c, f_start, f_end, df_start, df_end, df);
        }
    }

    public static final void paint(Graphics3D g3d, Texture texture, Vertex a, int au, int av, Vertex b, int bu, int bv, Vertex c, int cu, int cv, int fogc, byte fog, int qz, int q, int al, int bl, int cl, short nx, short ny, short nz) {
        int y_end;
        int y_start;
        int tb;
        Vertex t;
        if (!texture.alphaMixing && texture.drawmode == 4) {
            fog = 0;
        }
        if (ny > -4 && ny < 4 && Main.persQ == 1 && (fog < 5 || (fog == 9 || fog == 6) && Main.fogQ == 2)) {
            TexturingPers.paintWalls(g3d, texture, a, au, av, b, bu, bv, c, cu, cv, fogc, fog, qz, q, al, bl, cl, nx, ny, nz);
            return;
        }
        au = au * texture.rImg.w >> 8;
        bu = bu * texture.rImg.w >> 8;
        cu = cu * texture.rImg.w >> 8;
        av = av * texture.rImg.h >> 8;
        bv = bv * texture.rImg.h >> 8;
        cv = cv * texture.rImg.h >> 8;
        if (fog == 8) {
            TexturingAffine.paintFill(g3d, a, b, c, texture, au, av);
            return;
        }
        if (fog == 10) {
            TexturingAffine.paintDitherGradient(g3d, texture, a, al, b, bl, c, cl);
            return;
        }
        if (fog == 11) {
            al = 255 + a.rz * 255 / Graphics3D.waterDistance;
            if (al > 255) {
                al = 255;
            }
            if (al < 0) {
                al = 0;
            }
            if ((bl = 255 + b.rz * 255 / Graphics3D.waterDistance) > 255) {
                bl = 255;
            }
            if (bl < 0) {
                bl = 0;
            }
            if ((cl = 255 + c.rz * 255 / Graphics3D.waterDistance) > 255) {
                cl = 255;
            }
            if (cl < 0) {
                cl = 0;
            }
            TexturingAffine.paintDitherGradient(g3d, texture, a, al, b, bl, c, cl);
            return;
        }
        if (fog == 12) {
            al = 255 + a.rz * 255 / Graphics3D.fDist;
            if (al > 255) {
                al = 255;
            }
            if (al < 0) {
                al = 0;
            }
            if ((bl = 255 + b.rz * 255 / Graphics3D.fDist) > 255) {
                bl = 255;
            }
            if (bl < 0) {
                bl = 0;
            }
            if ((cl = 255 + c.rz * 255 / Graphics3D.fDist) > 255) {
                cl = 255;
            }
            if (cl < 0) {
                cl = 0;
            }
            TexturingAffine.paintDitherGradient(g3d, texture, a, al, b, bl, c, cl);
            return;
        }
        if (b.sy < a.sy) {
            t = a;
            a = b;
            b = t;
            tb = au;
            au = bu;
            bu = tb;
            tb = av;
            av = bv;
            bv = tb;
            tb = al;
            al = bl;
            bl = tb;
        }
        if (c.sy < a.sy) {
            t = c;
            c = a;
            a = t;
            tb = cu;
            cu = au;
            au = tb;
            tb = cv;
            cv = av;
            av = tb;
            tb = cl;
            cl = al;
            al = tb;
        }
        if (c.sy < b.sy) {
            t = b;
            b = c;
            c = t;
            tb = bu;
            bu = cu;
            cu = tb;
            tb = bv;
            bv = cv;
            cv = tb;
            tb = bl;
            bl = cl;
            cl = tb;
        }
        if (a.sy == c.sy) {
            return;
        }
        int cf = 255;
        int bf = 255;
        int af = 255;
        if (Graphics3D.fDist > 1) {
            af = 255 + a.rz * 255 / Graphics3D.fDist;
            if (af > 255) {
                af = 255;
            }
            if (af < 0) {
                af = 0;
            }
            if ((bf = 255 + b.rz * 255 / Graphics3D.fDist) > 255) {
                bf = 255;
            }
            if (bf < 0) {
                bf = 0;
            }
            if ((cf = 255 + c.rz * 255 / Graphics3D.fDist) > 255) {
                cf = 255;
            }
            if (cf < 0) {
                cf = 0;
            }
        }
        if (texture.drawmode == 9) {
            af = al;
            bf = bl;
            cf = cl;
        }
        if (LightMapper.cameraVectorLight && texture.drawmode == 6) {
            af = af * MathUtils.calcLight(nx, ny, nz, a.x - g3d.getCamera().m03, a.y - g3d.getCamera().m13, a.z - g3d.getCamera().m23) / 255;
            bf = bf * MathUtils.calcLight(nx, ny, nz, b.x - g3d.getCamera().m03, b.y - g3d.getCamera().m13, b.z - g3d.getCamera().m23) / 255;
            cf = cf * MathUtils.calcLight(nx, ny, nz, c.x - g3d.getCamera().m03, c.y - g3d.getCamera().m13, c.z - g3d.getCamera().m23) / 255;
        }
        if ((fog == 5 || fog == 6 || fog == 9) && af < 1 && bf < 1 && cf < 1) {
            TexturingAffine.paintFill(g3d, a, b, c, 0);
            return;
        }
        int W_UNIT = 0x40000000;
        int tempI = 262294;
        int awz = a.rz < 0 ? tempI / (-a.rz + 150) : tempI / 150;
        int bwz = b.rz < 0 ? tempI / (-b.rz + 150) : tempI / 150;
        int cwz = c.rz < 0 ? tempI / (-c.rz + 150) : tempI / 150;
        int auz = au * awz;
        int avz = av * awz;
        int buz = bu * bwz;
        int bvz = bv * bwz;
        int cuz = cu * cwz;
        int cvz = cv * cwz;
        tempI = c.sy - a.sy;
        int dx_start = (c.sx - a.sx << 12) / tempI;
        int dwz_start = (cwz - awz << 12) / tempI;
        int duz_start = (cuz - auz << 12) / tempI;
        int dvz_start = (cvz - avz << 12) / tempI;
        int df_start = (cf - af << 12) / tempI;
        int dx_end = 0;
        int dwz_end = 0;
        int duz_end = 0;
        int dvz_end = 0;
        int df_end = 0;
        if (b.sy != a.sy) {
            tempI = b.sy - a.sy;
            dx_end = (b.sx - a.sx << 12) / tempI;
            dwz_end = (bwz - awz << 12) / tempI;
            duz_end = (buz - auz << 12) / tempI;
            dvz_end = (bvz - avz << 12) / tempI;
            df_end = (bf - af << 12) / tempI;
        }
        tempI = b.sy - a.sy;
        int x_start = (a.sx << 12) + dx_start * tempI;
        int wz_start = (awz << 12) + dwz_start * tempI;
        int uz_start = (auz << 12) + duz_start * tempI;
        int vz_start = (avz << 12) + dvz_start * tempI;
        int f_start = (af << 12) + df_start * tempI;
        int x_end = b.sx << 12;
        int wz_end = bwz << 12;
        int uz_end = buz << 12;
        int vz_end = bvz << 12;
        int f_end = bf << 12;
        tempI = x_start - x_end >> 12;
        if (tempI == 0) {
            return;
        }
        int duz = (uz_start - uz_end) / tempI;
        int dvz = (vz_start - vz_end) / tempI;
        int dwz = (wz_start - wz_end) / tempI;
        int df = (f_start - f_end) / tempI;
        int tempII = c.sy - a.sy;
        int du_start = (cu - au << 12) / tempII;
        int dv_start = (cv - av << 12) / tempII;
        tempII = b.sy - a.sy;
        int x_start2 = (a.sx << 12) + dx_start * tempII;
        int x_end2 = b.sx << 12;
        int u_start = (au << 12) + du_start * tempII;
        int v_start = (av << 12) + dv_start * tempII;
        int u_end = bu << 12;
        int v_end = bv << 12;
        tempII = x_start2 - x_end2 >> 12;
        int du = 0;
        int dv = 0;
        if (tempII == 0) {
            return;
        }
        du = (u_start - u_end) / tempII;
        dv = (v_start - v_end) / tempII;
        boolean x2pixel = Math.abs(du) + Math.abs(dv) < 2048 && Math.abs(du) < 2048 && Math.abs(dv) < 2048 && Main.pixelsQ <= 1;
        boolean x4pixel = Math.abs(du) + Math.abs(dv) < 1024 && Math.abs(du) < 1024 && Math.abs(dv) < 1024 && Main.pixelsQ == 0;
        x_start = x_end = a.sx << 12;
        wz_start = wz_end = awz << 12;
        uz_start = uz_end = auz << 12;
        vz_start = vz_end = avz << 12;
        f_start = f_end = af << 12;
        if (b.sy > 0) {
            y_start = a.sy;
            if (y_start < 0) {
                x_start -= dx_start * y_start;
                wz_start -= dwz_start * y_start;
                uz_start -= duz_start * y_start;
                vz_start -= dvz_start * y_start;
                f_start -= df_start * y_start;
                x_end -= dx_end * y_start;
                wz_end -= dwz_end * y_start;
                uz_end -= duz_end * y_start;
                vz_end -= dvz_end * y_start;
                f_end -= df_end * y_start;
                y_start = 0;
            }
            y_end = b.sy < g3d.height ? b.sy : g3d.height;
            switch (fog) {
                case 0: {
                    TexturingPers.paintMiniTrianglePers_0(g3d, texture, y_start, y_end, x_start, wz_start, uz_start, vz_start, x_end, wz_end, uz_end, vz_end, dx_start, dwz_start, duz_start, dvz_start, dx_end, dwz_end, duz_end, dvz_end, dwz, duz, dvz, fogc, q, x2pixel, x4pixel);
                    break;
                }
                case 1: {
                    TexturingPers.paintMiniTrianglePers_1(g3d, texture, y_start, y_end, x_start, wz_start, uz_start, vz_start, x_end, wz_end, uz_end, vz_end, dx_start, dwz_start, duz_start, dvz_start, dx_end, dwz_end, duz_end, dvz_end, dwz, duz, dvz, fogc, qz, q, x2pixel, x4pixel);
                    break;
                }
                case 2: {
                    TexturingPers.paintMiniTrianglePers_2(g3d, texture, y_start, y_end, x_start, wz_start, uz_start, vz_start, x_end, wz_end, uz_end, vz_end, dx_start, dwz_start, duz_start, dvz_start, dx_end, dwz_end, duz_end, dvz_end, dwz, duz, dvz, fogc, q);
                    break;
                }
                case 3: {
                    TexturingPers.paintMiniTrianglePers_3(g3d, texture, y_start, y_end, x_start, wz_start, uz_start, vz_start, x_end, wz_end, uz_end, vz_end, dx_start, dwz_start, duz_start, dvz_start, dx_end, dwz_end, duz_end, dvz_end, dwz, duz, dvz, fogc, qz, q, a, b, c, x2pixel, x4pixel, f_start, f_end, df_start, df_end, df);
                    break;
                }
                case 4: {
                    TexturingPers.paintMiniTrianglePers_4(g3d, texture, y_start, y_end, x_start, wz_start, uz_start, vz_start, x_end, wz_end, uz_end, vz_end, dx_start, dwz_start, duz_start, dvz_start, dx_end, dwz_end, duz_end, dvz_end, dwz, duz, dvz, fogc, q);
                    break;
                }
                case 5: {
                    TexturingPers.paintMiniTrianglePers_5(g3d, texture, y_start, y_end, x_start, wz_start, uz_start, vz_start, x_end, wz_end, uz_end, vz_end, dx_start, dwz_start, duz_start, dvz_start, dx_end, dwz_end, duz_end, dvz_end, dwz, duz, dvz, fogc, qz, q, a, b, c, x2pixel, x4pixel, f_start, f_end, df_start, df_end, df);
                    break;
                }
                case 6: {
                    TexturingPers.paintMiniTrianglePers_5(g3d, texture, y_start, y_end, x_start, wz_start, uz_start, vz_start, x_end, wz_end, uz_end, vz_end, dx_start, dwz_start, duz_start, dvz_start, dx_end, dwz_end, duz_end, dvz_end, dwz, duz, dvz, fogc, qz, q, a, b, c, x2pixel, x4pixel, f_start, f_end, df_start, df_end, df);
                    break;
                }
                case 7: {
                    TexturingPers.paintPers_glass(g3d, texture, y_start, y_end, x_start, wz_start, uz_start, vz_start, x_end, wz_end, uz_end, vz_end, dx_start, dwz_start, duz_start, dvz_start, dx_end, dwz_end, duz_end, dvz_end, dwz, duz, dvz, fogc, q);
                    break;
                }
                case 9: {
                    TexturingPers.paintMiniTrianglePers_5(g3d, texture, y_start, y_end, x_start, wz_start, uz_start, vz_start, x_end, wz_end, uz_end, vz_end, dx_start, dwz_start, duz_start, dvz_start, dx_end, dwz_end, duz_end, dvz_end, dwz, duz, dvz, fogc, qz, q, a, b, c, x2pixel, x4pixel, f_start, f_end, df_start, df_end, df);
                }
            }
        }
        if (c.sy == b.sy || c.sy < 0) {
            return;
        }
        tempI = b.sy - a.sy;
        x_start = (a.sx << 12) + dx_start * tempI;
        wz_start = (awz << 12) + dwz_start * tempI;
        uz_start = (auz << 12) + duz_start * tempI;
        vz_start = (avz << 12) + dvz_start * tempI;
        f_start = (af << 12) + df_start * tempI;
        x_end = b.sx << 12;
        wz_end = bwz << 12;
        uz_end = buz << 12;
        vz_end = bvz << 12;
        f_end = bf << 12;
        tempI = c.sy - b.sy;
        dx_end = (c.sx - b.sx << 12) / tempI;
        dwz_end = (cwz - bwz << 12) / tempI;
        duz_end = (cuz - buz << 12) / tempI;
        dvz_end = (cvz - bvz << 12) / tempI;
        df_end = (cf - bf << 12) / tempI;
        y_start = b.sy;
        if (y_start < 0) {
            x_start -= dx_start * y_start;
            wz_start -= dwz_start * y_start;
            uz_start -= duz_start * y_start;
            vz_start -= dvz_start * y_start;
            f_start -= df_start * y_start;
            x_end -= dx_end * y_start;
            wz_end -= dwz_end * y_start;
            uz_end -= duz_end * y_start;
            vz_end -= dvz_end * y_start;
            f_end -= df_end * y_start;
            y_start = 0;
        }
        y_end = c.sy < g3d.height ? c.sy : g3d.height;
        switch (fog) {
            case 0: {
                TexturingPers.paintMiniTrianglePers_0(g3d, texture, y_start, y_end, x_start, wz_start, uz_start, vz_start, x_end, wz_end, uz_end, vz_end, dx_start, dwz_start, duz_start, dvz_start, dx_end, dwz_end, duz_end, dvz_end, dwz, duz, dvz, fogc, q, x2pixel, x4pixel);
                break;
            }
            case 1: {
                TexturingPers.paintMiniTrianglePers_1(g3d, texture, y_start, y_end, x_start, wz_start, uz_start, vz_start, x_end, wz_end, uz_end, vz_end, dx_start, dwz_start, duz_start, dvz_start, dx_end, dwz_end, duz_end, dvz_end, dwz, duz, dvz, fogc, qz, q, x2pixel, x4pixel);
                break;
            }
            case 2: {
                TexturingPers.paintMiniTrianglePers_2(g3d, texture, y_start, y_end, x_start, wz_start, uz_start, vz_start, x_end, wz_end, uz_end, vz_end, dx_start, dwz_start, duz_start, dvz_start, dx_end, dwz_end, duz_end, dvz_end, dwz, duz, dvz, fogc, q);
                break;
            }
            case 3: {
                TexturingPers.paintMiniTrianglePers_3(g3d, texture, y_start, y_end, x_start, wz_start, uz_start, vz_start, x_end, wz_end, uz_end, vz_end, dx_start, dwz_start, duz_start, dvz_start, dx_end, dwz_end, duz_end, dvz_end, dwz, duz, dvz, fogc, qz, q, a, b, c, x2pixel, x4pixel, f_start, f_end, df_start, df_end, df);
                break;
            }
            case 4: {
                TexturingPers.paintMiniTrianglePers_4(g3d, texture, y_start, y_end, x_start, wz_start, uz_start, vz_start, x_end, wz_end, uz_end, vz_end, dx_start, dwz_start, duz_start, dvz_start, dx_end, dwz_end, duz_end, dvz_end, dwz, duz, dvz, fogc, q);
                break;
            }
            case 5: {
                TexturingPers.paintMiniTrianglePers_5(g3d, texture, y_start, y_end, x_start, wz_start, uz_start, vz_start, x_end, wz_end, uz_end, vz_end, dx_start, dwz_start, duz_start, dvz_start, dx_end, dwz_end, duz_end, dvz_end, dwz, duz, dvz, fogc, qz, q, a, b, c, x2pixel, x4pixel, f_start, f_end, df_start, df_end, df);
                break;
            }
            case 6: {
                TexturingPers.paintMiniTrianglePers_5(g3d, texture, y_start, y_end, x_start, wz_start, uz_start, vz_start, x_end, wz_end, uz_end, vz_end, dx_start, dwz_start, duz_start, dvz_start, dx_end, dwz_end, duz_end, dvz_end, dwz, duz, dvz, fogc, qz, q, a, b, c, x2pixel, x4pixel, f_start, f_end, df_start, df_end, df);
                break;
            }
            case 7: {
                TexturingPers.paintPers_glass(g3d, texture, y_start, y_end, x_start, wz_start, uz_start, vz_start, x_end, wz_end, uz_end, vz_end, dx_start, dwz_start, duz_start, dvz_start, dx_end, dwz_end, duz_end, dvz_end, dwz, duz, dvz, fogc, q);
                break;
            }
            case 9: {
                TexturingPers.paintMiniTrianglePers_5(g3d, texture, y_start, y_end, x_start, wz_start, uz_start, vz_start, x_end, wz_end, uz_end, vz_end, dx_start, dwz_start, duz_start, dvz_start, dx_end, dwz_end, duz_end, dvz_end, dwz, duz, dvz, fogc, qz, q, a, b, c, x2pixel, x4pixel, f_start, f_end, df_start, df_end, df);
            }
        }
    }

    static final void paintMiniTrianglePers_0(Graphics3D g3d, Texture texture, int y_start, int y_end, int x_start, int wz_start, int uz_start, int vz_start, int x_end, int wz_end, int uz_end, int vz_end, int dx_start, int dwz_start, int duz_start, int dvz_start, int dx_end, int dwz_end, int duz_end, int dvz_end, int dwz, int duz, int dvz, int fogc, int sz2, boolean x2pixel, boolean x4pixel) {
        if (sz2 > 999) {
            TexturingFloorsWalls.paintFloor(g3d, texture, y_start, y_end, x_start, wz_start, uz_start, vz_start, x_end, wz_end, uz_end, vz_end, dx_start, dwz_start, duz_start, dvz_start, dx_end, dwz_end, duz_end, dvz_end, dwz, duz, dvz, fogc, sz2);
            return;
        }
        int[] tex = texture.rImg.img;
        int lengthBIT = tex.length - 1;
        int widthBIT = texture.widthBIT;
        int[] rgb = g3d.display;
        int duz4 = duz * sz2;
        int dvz4 = dvz * sz2;
        int dwz4 = dwz * sz2;
        for (int y = y_start; y < y_end; ++y) {
            int col;
            int dv;
            int du;
            int v_2;
            int u_2;
            int length;
            int wz_b;
            int wz_a;
            int vz_b;
            int vz_a;
            int uz_b;
            int uz_a;
            int x2;
            int x1;
            if (x_start > x_end) {
                x1 = x_end;
                x2 = x_start;
                uz_a = uz_end;
                uz_b = uz_start;
                vz_a = vz_end;
                vz_b = vz_start;
                wz_a = wz_end;
                wz_b = wz_start;
            } else {
                x1 = x_start;
                x2 = x_end;
                uz_a = uz_start;
                uz_b = uz_end;
                vz_a = vz_start;
                vz_b = vz_end;
                wz_a = wz_start;
                wz_b = wz_end;
            }
            long subtexel_a = x1 % 4096;
            long subtexel_b = x2 % 4096;
            uz_a = (int)((long)uz_a - ((long)duz * subtexel_a >> 12));
            vz_a = (int)((long)vz_a - ((long)dvz * subtexel_a >> 12));
            wz_a = (int)((long)wz_a - ((long)dwz * subtexel_a >> 12));
            uz_b = (int)((long)uz_b - ((long)duz * subtexel_b >> 12));
            vz_b = (int)((long)vz_b - ((long)dvz * subtexel_b >> 12));
            wz_b = (int)((long)wz_b - ((long)dwz * subtexel_b >> 12));
            x2 >>= 12;
            if ((x1 >>= 12) < 0) {
                uz_a -= duz * x1;
                vz_a -= dvz * x1;
                wz_a -= dwz * x1;
                x1 = 0;
            }
            if (x2 > g3d.width) {
                uz_b -= duz * (x2 -= g3d.width);
                vz_b -= dvz * x2;
                wz_b -= dwz * x2;
                x2 = g3d.width;
            }
            if (wz_a == 0 || wz_b == 0) {
                return;
            }
            int tempI = y * g3d.width;
            int u = (int)(((long)uz_a << 12) / (long)wz_a);
            int v = (int)(((long)vz_a << 12) / (long)wz_a);
            int x_begin = x1;
            for (length = (x2 += tempI) - (x1 += tempI); length >= sz2; length -= sz2) {
                u_2 = (int)(((long)(uz_a += duz4) << 12) / (long)(wz_a += dwz4));
                v_2 = (int)(((long)(vz_a += dvz4) << 12) / (long)wz_a);
                du = (u_2 - u) / sz2;
                dv = (v_2 - v) / sz2;
                int i = x1 + sz2;
                while (x1 < i) {
                    col = tex[((v += dv) >> 12 << widthBIT) + ((u += du) >> 12) & lengthBIT];
                    if (col != 0) {
                        rgb[x1] = col;
                    }
                    ++x1;
                    col = tex[((v += dv) >> 12 << widthBIT) + ((u += du) >> 12) & lengthBIT];
                    if (col != 0) {
                        rgb[x1] = col;
                    }
                    ++x1;
                    col = tex[((v += dv) >> 12 << widthBIT) + ((u += du) >> 12) & lengthBIT];
                    if (col != 0) {
                        rgb[x1] = col;
                    }
                    ++x1;
                }
            }
            if (length > 0) {
                u_2 = (int)(((long)uz_b << 12) / (long)wz_b);
                v_2 = (int)(((long)vz_b << 12) / (long)wz_b);
                du = (u_2 - u) / length;
                dv = (v_2 - v) / length;
                while (x2 - x1 >= 3) {
                    col = tex[((v += dv) >> 12 << widthBIT) + ((u += du) >> 12) & lengthBIT];
                    if (col != 0) {
                        rgb[x1] = col;
                    }
                    ++x1;
                    col = tex[((v += dv) >> 12 << widthBIT) + ((u += du) >> 12) & lengthBIT];
                    if (col != 0) {
                        rgb[x1] = col;
                    }
                    ++x1;
                    col = tex[((v += dv) >> 12 << widthBIT) + ((u += du) >> 12) & lengthBIT];
                    if (col != 0) {
                        rgb[x1] = col;
                    }
                    ++x1;
                }
                while (x1 < x2) {
                    col = tex[((v += dv) >> 12 << widthBIT) + ((u += du) >> 12) & lengthBIT];
                    if (col != 0) {
                        rgb[x1] = col;
                    }
                    ++x1;
                }
            }
            x_start += dx_start;
            wz_start += dwz_start;
            uz_start += duz_start;
            vz_start += dvz_start;
            x_end += dx_end;
            wz_end += dwz_end;
            uz_end += duz_end;
            vz_end += dvz_end;
        }
    }

    static final void paintMiniTrianglePers_1(Graphics3D g3d, Texture texture, int y_start, int y_end, int x_start, int wz_start, int uz_start, int vz_start, int x_end, int wz_end, int uz_end, int vz_end, int dx_start, int dwz_start, int duz_start, int dvz_start, int dx_end, int dwz_end, int duz_end, int dvz_end, int dwz, int duz, int dvz, int fogc, int sz2, int q, boolean x2pixel, boolean x4pixel) {
        if (Main.fogQ == 0) {
            TexturingPers.paintMiniTrianglePers_0(g3d, texture, y_start, y_end, x_start, wz_start, uz_start, vz_start, x_end, wz_end, uz_end, vz_end, dx_start, dwz_start, duz_start, dvz_start, dx_end, dwz_end, duz_end, dvz_end, dwz, duz, dvz, fogc, q, x2pixel, x4pixel);
            return;
        }
        if (sz2 > 999) {
            TexturingFloorsWalls.paintFloor_1(g3d, texture, y_start, y_end, x_start, wz_start, uz_start, vz_start, x_end, wz_end, uz_end, vz_end, dx_start, dwz_start, duz_start, dvz_start, dx_end, dwz_end, duz_end, dvz_end, dwz, duz, dvz, sz2);
            return;
        }
        int[] tex = texture.rImg.img;
        int lengthBIT = tex.length - 1;
        int widthBIT = texture.widthBIT;
        int[] rgb = g3d.display;
        int duz4 = duz * q;
        int dvz4 = dvz * q;
        int dwz4 = dwz * q;
        int colf = sz2 & 0xFEFEFE;
        for (int y = y_start; y < y_end; ++y) {
            int col;
            int dv;
            int du;
            int v_2;
            int u_2;
            int length;
            int wz_b;
            int wz_a;
            int vz_b;
            int vz_a;
            int uz_b;
            int uz_a;
            int x2;
            int x1;
            if (x_start > x_end) {
                x1 = x_end;
                x2 = x_start;
                uz_a = uz_end;
                uz_b = uz_start;
                vz_a = vz_end;
                vz_b = vz_start;
                wz_a = wz_end;
                wz_b = wz_start;
            } else {
                x1 = x_start;
                x2 = x_end;
                uz_a = uz_start;
                uz_b = uz_end;
                vz_a = vz_start;
                vz_b = vz_end;
                wz_a = wz_start;
                wz_b = wz_end;
            }
            long subtexel_a = x1 % 4096;
            long subtexel_b = x2 % 4096;
            uz_a = (int)((long)uz_a - ((long)duz * subtexel_a >> 12));
            vz_a = (int)((long)vz_a - ((long)dvz * subtexel_a >> 12));
            wz_a = (int)((long)wz_a - ((long)dwz * subtexel_a >> 12));
            uz_b = (int)((long)uz_b - ((long)duz * subtexel_b >> 12));
            vz_b = (int)((long)vz_b - ((long)dvz * subtexel_b >> 12));
            wz_b = (int)((long)wz_b - ((long)dwz * subtexel_b >> 12));
            x2 >>= 12;
            if ((x1 >>= 12) < 0) {
                uz_a -= duz * x1;
                vz_a -= dvz * x1;
                wz_a -= dwz * x1;
                x1 = 0;
            }
            if (x2 > g3d.width) {
                uz_b -= duz * (x2 -= g3d.width);
                vz_b -= dvz * x2;
                wz_b -= dwz * x2;
                x2 = g3d.width;
            }
            int tempI = y * g3d.width;
            if (wz_a == 0) {
                return;
            }
            int u = (int)(((long)uz_a << 12) / (long)wz_a);
            int v = (int)(((long)vz_a << 12) / (long)wz_a);
            for (length = (x2 += tempI) - (x1 += tempI); length >= q; length -= q) {
                u_2 = (int)(((long)(uz_a += duz4) << 12) / (long)(wz_a += dwz4));
                v_2 = (int)(((long)(vz_a += dvz4) << 12) / (long)wz_a);
                du = (u_2 - u) / q;
                dv = (v_2 - v) / q;
                int i = x1 + q;
                while (x1 < i) {
                    col = tex[((v += dv) >> 12 << widthBIT) + ((u += du) >> 12) & lengthBIT];
                    if (col != 0) {
                        col = (col & 0xFEFEFE) + colf;
                        rgb[x1] = col | (col >> 8 & 0x10101) * 255;
                    }
                    ++x1;
                }
            }
            if (length > 0) {
                u_2 = (int)(((long)uz_b << 12) / (long)wz_b);
                v_2 = (int)(((long)vz_b << 12) / (long)wz_b);
                du = (u_2 - u) / length;
                dv = (v_2 - v) / length;
                while (x1 < x2) {
                    col = tex[((v += dv) >> 12 << widthBIT) + ((u += du) >> 12) & lengthBIT];
                    if (col != 0) {
                        col = (col & 0xFEFEFE) + colf;
                        rgb[x1] = col | (col >> 8 & 0x10101) * 255;
                    }
                    ++x1;
                }
            }
            x_start += dx_start;
            wz_start += dwz_start;
            uz_start += duz_start;
            vz_start += dvz_start;
            x_end += dx_end;
            wz_end += dwz_end;
            uz_end += duz_end;
            vz_end += dvz_end;
        }
    }

    static final void paintMiniTrianglePers_2(Graphics3D g3d, Texture texture, int y_start, int y_end, int x_start, int wz_start, int uz_start, int vz_start, int x_end, int wz_end, int uz_end, int vz_end, int dx_start, int dwz_start, int duz_start, int dvz_start, int dx_end, int dwz_end, int duz_end, int dvz_end, int dwz, int duz, int dvz, int fogc, int sz2) {
        if (sz2 > 999) {
            TexturingFloorsWalls.paintFloor_2(g3d, texture, y_start, y_end, x_start, wz_start, uz_start, vz_start, x_end, wz_end, uz_end, vz_end, dx_start, dwz_start, duz_start, dvz_start, dx_end, dwz_end, duz_end, dvz_end, dwz, duz, dvz);
            return;
        }
        int[] tex = texture.rImg.img;
        int lengthBIT = tex.length - 1;
        int widthBIT = texture.widthBIT;
        int[] rgb = g3d.display;
        int duz4 = duz * sz2;
        int dvz4 = dvz * sz2;
        int dwz4 = dwz * sz2;
        for (int y = y_start; y < y_end; ++y) {
            int col;
            int dv;
            int du;
            int v_2;
            int u_2;
            int length;
            int wz_b;
            int wz_a;
            int vz_b;
            int vz_a;
            int uz_b;
            int uz_a;
            int x2;
            int x1;
            if (x_start > x_end) {
                x1 = x_end;
                x2 = x_start;
                uz_a = uz_end;
                uz_b = uz_start;
                vz_a = vz_end;
                vz_b = vz_start;
                wz_a = wz_end;
                wz_b = wz_start;
            } else {
                x1 = x_start;
                x2 = x_end;
                uz_a = uz_start;
                uz_b = uz_end;
                vz_a = vz_start;
                vz_b = vz_end;
                wz_a = wz_start;
                wz_b = wz_end;
            }
            long subtexel_a = x1 % 4096;
            long subtexel_b = x2 % 4096;
            uz_a = (int)((long)uz_a - ((long)duz * subtexel_a >> 12));
            vz_a = (int)((long)vz_a - ((long)dvz * subtexel_a >> 12));
            wz_a = (int)((long)wz_a - ((long)dwz * subtexel_a >> 12));
            uz_b = (int)((long)uz_b - ((long)duz * subtexel_b >> 12));
            vz_b = (int)((long)vz_b - ((long)dvz * subtexel_b >> 12));
            wz_b = (int)((long)wz_b - ((long)dwz * subtexel_b >> 12));
            x2 >>= 12;
            if ((x1 >>= 12) < 0) {
                uz_a -= duz * x1;
                vz_a -= dvz * x1;
                wz_a -= dwz * x1;
                x1 = 0;
            }
            if (x2 > g3d.width) {
                uz_b -= duz * (x2 -= g3d.width);
                vz_b -= dvz * x2;
                wz_b -= dwz * x2;
                x2 = g3d.width;
            }
            int tempI = y * g3d.width;
            if (wz_a == 0) {
                return;
            }
            int u = (int)(((long)uz_a << 12) / (long)wz_a);
            int v = (int)(((long)vz_a << 12) / (long)wz_a);
            for (length = (x2 += tempI) - (x1 += tempI); length >= sz2; length -= sz2) {
                u_2 = (int)(((long)(uz_a += duz4) << 12) / (long)(wz_a += dwz4));
                v_2 = (int)(((long)(vz_a += dvz4) << 12) / (long)wz_a);
                du = (u_2 - u) / sz2;
                dv = (v_2 - v) / sz2;
                int i = x1 + sz2;
                while (x1 < i) {
                    col = tex[((v += dv) >> 12 << widthBIT) + ((u += du) >> 12) & lengthBIT];
                    if (col != 0) {
                        col = (col & 0xFEFEFE) + (rgb[x1] & 0xFEFEFE);
                        rgb[x1] = col | (col >> 8 & 0x10101) * 255;
                    }
                    ++x1;
                }
            }
            if (length > 0) {
                u_2 = (int)(((long)uz_b << 12) / (long)wz_b);
                v_2 = (int)(((long)vz_b << 12) / (long)wz_b);
                du = (u_2 - u) / length;
                dv = (v_2 - v) / length;
                while (x1 < x2) {
                    col = tex[((v += dv) >> 12 << widthBIT) + ((u += du) >> 12) & lengthBIT];
                    if (col != 0) {
                        col = (col & 0xFEFEFE) + (rgb[x1] & 0xFEFEFE);
                        rgb[x1] = col | (col >> 8 & 0x10101) * 255;
                    }
                    ++x1;
                }
            }
            x_start += dx_start;
            wz_start += dwz_start;
            uz_start += duz_start;
            vz_start += dvz_start;
            x_end += dx_end;
            wz_end += dwz_end;
            uz_end += duz_end;
            vz_end += dvz_end;
        }
    }

    static final void paintMiniTrianglePers_3(Graphics3D g3d, Texture texture, int y_start, int y_end, int x_start, int wz_start, int uz_start, int vz_start, int x_end, int wz_end, int uz_end, int vz_end, int dx_start, int dwz_start, int duz_start, int dvz_start, int dx_end, int dwz_end, int duz_end, int dvz_end, int dwz, int duz, int dvz, int fogc, int sz2, int q, Vertex a, Vertex b, Vertex c, boolean x2pixel, boolean x4pixel, int f_start, int f_end, int df_start, int df_end, int df) {
        if (Main.fogQ == 2 && !Main.forceLQFog) {
            TexturingPers.paintMiniTrianglePers_3_HQ(g3d, texture, y_start, y_end, x_start, wz_start, uz_start, vz_start, x_end, wz_end, uz_end, vz_end, dx_start, dwz_start, duz_start, dvz_start, dx_end, dwz_end, duz_end, dvz_end, dwz, duz, dvz, fogc, sz2, q, a, b, c, f_start, f_end, df_start, df_end, df);
            return;
        }
        if (Main.fogQ == 0) {
            TexturingPers.paintMiniTrianglePers_0(g3d, texture, y_start, y_end, x_start, wz_start, uz_start, vz_start, x_end, wz_end, uz_end, vz_end, dx_start, dwz_start, duz_start, dvz_start, dx_end, dwz_end, duz_end, dvz_end, dwz, duz, dvz, fogc, q, x2pixel, x4pixel);
            return;
        }
        if (q > 999) {
            TexturingFloorsWalls.paintFloor_3(g3d, texture, y_start, y_end, x_start, wz_start, uz_start, vz_start, x_end, wz_end, uz_end, vz_end, dx_start, dwz_start, duz_start, dvz_start, dx_end, dwz_end, duz_end, dvz_end, dwz, duz, dvz, fogc, sz2, a, b, c, f_start, f_end, df_start, df_end, df);
            return;
        }
        int[] tex = texture.rImg.img;
        int lengthBIT = tex.length - 1;
        int widthBIT = texture.widthBIT;
        int[] rgb = g3d.display;
        int duz4 = duz * q;
        int dvz4 = dvz * q;
        int dwz4 = dwz * q;
        if (Graphics3D.fDist / 255 != 0) {
            sz2 = -TexturingPers.max(a.rz, b.rz, c.rz) / (Graphics3D.fDist / 255);
        }
        if (sz2 > 255) {
            sz2 = 255;
        }
        if (sz2 < 0) {
            sz2 = 0;
        }
        int isz2 = 255 - sz2;
        int f2 = (fogc & 0xFF00FF) * sz2;
        int f22 = (fogc & 0xFF00) * sz2;
        for (int y = y_start; y < y_end; ++y) {
            int col;
            int dv;
            int du;
            int v_2;
            int u_2;
            int length;
            int wz_b;
            int wz_a;
            int vz_b;
            int vz_a;
            int uz_b;
            int uz_a;
            int x2;
            int x1;
            if (x_start > x_end) {
                x1 = x_end;
                x2 = x_start;
                uz_a = uz_end;
                uz_b = uz_start;
                vz_a = vz_end;
                vz_b = vz_start;
                wz_a = wz_end;
                wz_b = wz_start;
            } else {
                x1 = x_start;
                x2 = x_end;
                uz_a = uz_start;
                uz_b = uz_end;
                vz_a = vz_start;
                vz_b = vz_end;
                wz_a = wz_start;
                wz_b = wz_end;
            }
            long subtexel_a = x1 % 4096;
            long subtexel_b = x2 % 4096;
            uz_a = (int)((long)uz_a - ((long)duz * subtexel_a >> 12));
            vz_a = (int)((long)vz_a - ((long)dvz * subtexel_a >> 12));
            wz_a = (int)((long)wz_a - ((long)dwz * subtexel_a >> 12));
            uz_b = (int)((long)uz_b - ((long)duz * subtexel_b >> 12));
            vz_b = (int)((long)vz_b - ((long)dvz * subtexel_b >> 12));
            wz_b = (int)((long)wz_b - ((long)dwz * subtexel_b >> 12));
            x2 >>= 12;
            if ((x1 >>= 12) < 0) {
                uz_a -= duz * x1;
                vz_a -= dvz * x1;
                wz_a -= dwz * x1;
                x1 = 0;
            }
            if (x2 > g3d.width) {
                uz_b -= duz * (x2 -= g3d.width);
                vz_b -= dvz * x2;
                wz_b -= dwz * x2;
                x2 = g3d.width;
            }
            int tempI = y * g3d.width;
            if (wz_a == 0) {
                return;
            }
            int u = (int)(((long)uz_a << 12) / (long)wz_a);
            int v = (int)(((long)vz_a << 12) / (long)wz_a);
            for (length = (x2 += tempI) - (x1 += tempI); length >= q; length -= q) {
                u_2 = (int)(((long)(uz_a += duz4) << 12) / (long)(wz_a += dwz4));
                v_2 = (int)(((long)(vz_a += dvz4) << 12) / (long)wz_a);
                du = (u_2 - u) / q;
                dv = (v_2 - v) / q;
                int i = x1 + q;
                while (x1 < i) {
                    col = tex[((v += dv) >> 12 << widthBIT) + ((u += du) >> 12) & lengthBIT];
                    if (col != 0) {
                        rgb[x1] = ((col & 0xFF00FF) * isz2 + f2 & 0xFF00FF00 | (col & 0xFF00) * isz2 + f22 & 0xFF0000) >>> 8;
                    }
                    if ((col = tex[((v += dv) >> 12 << widthBIT) + ((u += du) >> 12) & lengthBIT]) != 0) {
                        rgb[x1 + 1] = ((col & 0xFF00FF) * isz2 + f2 & 0xFF00FF00 | (col & 0xFF00) * isz2 + f22 & 0xFF0000) >>> 8;
                    }
                    x1 += 2;
                }
            }
            if (length > 0) {
                u_2 = (int)(((long)uz_b << 12) / (long)wz_b);
                v_2 = (int)(((long)vz_b << 12) / (long)wz_b);
                du = (u_2 - u) / length;
                dv = (v_2 - v) / length;
                while (x1 < x2) {
                    col = tex[((v += dv) >> 12 << widthBIT) + ((u += du) >> 12) & lengthBIT];
                    if (col != 0) {
                        rgb[x1] = ((col & 0xFF00FF) * isz2 + f2 & 0xFF00FF00 | (col & 0xFF00) * isz2 + f22 & 0xFF0000) >>> 8;
                    }
                    ++x1;
                }
            }
            x_start += dx_start;
            wz_start += dwz_start;
            uz_start += duz_start;
            vz_start += dvz_start;
            x_end += dx_end;
            wz_end += dwz_end;
            uz_end += duz_end;
            vz_end += dvz_end;
        }
    }

    static final void paintMiniTrianglePers_3_HQ(Graphics3D g3d, Texture texture, int y_start, int y_end, int x_start, int wz_start, int uz_start, int vz_start, int x_end, int wz_end, int uz_end, int vz_end, int dx_start, int dwz_start, int duz_start, int dvz_start, int dx_end, int dwz_end, int duz_end, int dvz_end, int dwz, int duz, int dvz, int fogc, int sz2, int q, Vertex a, Vertex b, Vertex c, int f_start, int f_end, int df_start, int df_end, int df) {
        if (q > 999) {
            TexturingFloorsWalls.paintFloor_3_HQ(g3d, texture, y_start, y_end, x_start, wz_start, uz_start, vz_start, x_end, wz_end, uz_end, vz_end, dx_start, dwz_start, duz_start, dvz_start, dx_end, dwz_end, duz_end, dvz_end, dwz, duz, dvz, a, b, c, f_start, f_end, df_start, df_end, df);
            return;
        }
        int[] tex = texture.rImg.img;
        int lengthBIT = tex.length - 1;
        int widthBIT = texture.widthBIT;
        int[] rgb = g3d.display;
        int duz4 = duz * q;
        int dvz4 = dvz * q;
        int dwz4 = dwz * q;
        int fogcolor = Graphics3D.fogc;
        int fogcolor2 = fogcolor & 0xFF00;
        fogcolor &= 0xFF00FF;
        for (int y = y_start; y < y_end; ++y) {
            int col;
            int dv;
            int du;
            int v_2;
            int u_2;
            int length;
            int f;
            int wz_b;
            int wz_a;
            int vz_b;
            int vz_a;
            int uz_b;
            int uz_a;
            int x2;
            int x1;
            if (x_start > x_end) {
                x1 = x_end;
                x2 = x_start;
                uz_a = uz_end;
                uz_b = uz_start;
                vz_a = vz_end;
                vz_b = vz_start;
                wz_a = wz_end;
                wz_b = wz_start;
                f = f_end;
            } else {
                x1 = x_start;
                x2 = x_end;
                uz_a = uz_start;
                uz_b = uz_end;
                vz_a = vz_start;
                vz_b = vz_end;
                wz_a = wz_start;
                wz_b = wz_end;
                f = f_start;
            }
            long subtexel_a = x1 % 4096;
            long subtexel_b = x2 % 4096;
            uz_a = (int)((long)uz_a - ((long)duz * subtexel_a >> 12));
            vz_a = (int)((long)vz_a - ((long)dvz * subtexel_a >> 12));
            wz_a = (int)((long)wz_a - ((long)dwz * subtexel_a >> 12));
            uz_b = (int)((long)uz_b - ((long)duz * subtexel_b >> 12));
            vz_b = (int)((long)vz_b - ((long)dvz * subtexel_b >> 12));
            wz_b = (int)((long)wz_b - ((long)dwz * subtexel_b >> 12));
            x2 >>= 12;
            if ((x1 >>= 12) < 0) {
                uz_a -= duz * x1;
                vz_a -= dvz * x1;
                wz_a -= dwz * x1;
                f -= df * x1;
                x1 = 0;
            }
            if (x2 > g3d.width) {
                uz_b -= duz * (x2 -= g3d.width);
                vz_b -= dvz * x2;
                wz_b -= dwz * x2;
                x2 = g3d.width;
            }
            int tempI = y * g3d.width;
            if (wz_a == 0) {
                return;
            }
            int u = (int)(((long)uz_a << 12) / (long)wz_a);
            int v = (int)(((long)vz_a << 12) / (long)wz_a);
            for (length = (x2 += tempI) - (x1 += tempI); length >= q; length -= q) {
                u_2 = (int)(((long)(uz_a += duz4) << 12) / (long)(wz_a += dwz4));
                v_2 = (int)(((long)(vz_a += dvz4) << 12) / (long)wz_a);
                du = (u_2 - u) / q;
                dv = (v_2 - v) / q;
                int i = x1 + q;
                while (i - x1 >= 2) {
                    int isz2 = (f += df) >> 12;
                    int isz = 255 - isz2;
                    col = tex[((v += dv) >> 12 << widthBIT) + ((u += du) >> 12) & lengthBIT];
                    if (col != 0) {
                        rgb[x1] = ((col & 0xFF00FF) * isz2 + fogcolor * isz & 0xFF00FF00 | (col & 0xFF00) * isz2 + fogcolor2 * isz & 0xFF0000) >>> 8;
                    }
                    isz2 = (f += df) >> 12;
                    isz = 255 - isz2;
                    col = tex[((v += dv) >> 12 << widthBIT) + ((u += du) >> 12) & lengthBIT];
                    if (col != 0) {
                        rgb[x1 + 1] = ((col & 0xFF00FF) * isz2 + fogcolor * isz & 0xFF00FF00 | (col & 0xFF00) * isz2 + fogcolor2 * isz & 0xFF0000) >>> 8;
                    }
                    x1 += 2;
                }
            }
            if (length > 0) {
                u_2 = (int)(((long)uz_b << 12) / (long)wz_b);
                v_2 = (int)(((long)vz_b << 12) / (long)wz_b);
                du = (u_2 - u) / length;
                dv = (v_2 - v) / length;
                while (x1 < x2) {
                    int isz2 = (f += df) >> 12;
                    int isz = 255 - isz2;
                    col = tex[((v += dv) >> 12 << widthBIT) + ((u += du) >> 12) & lengthBIT];
                    if (col != 0) {
                        rgb[x1] = ((col & 0xFF00FF) * isz2 + fogcolor * isz & 0xFF00FF00 | (col & 0xFF00) * isz2 + fogcolor2 * isz & 0xFF0000) >>> 8;
                    }
                    ++x1;
                }
            }
            x_start += dx_start;
            wz_start += dwz_start;
            uz_start += duz_start;
            vz_start += dvz_start;
            f_start += df_start;
            x_end += dx_end;
            wz_end += dwz_end;
            uz_end += duz_end;
            vz_end += dvz_end;
            f_end += df_end;
        }
    }

    static final void paintMiniTrianglePers_4(Graphics3D g3d, Texture texture, int y_start, int y_end, int x_start, int wz_start, int uz_start, int vz_start, int x_end, int wz_end, int uz_end, int vz_end, int dx_start, int dwz_start, int duz_start, int dvz_start, int dx_end, int dwz_end, int duz_end, int dvz_end, int dwz, int duz, int dvz, int fogc, int sz2) {
        if (sz2 > 999) {
            TexturingFloorsWalls.paintFloor_4(g3d, texture, y_start, y_end, x_start, wz_start, uz_start, vz_start, x_end, wz_end, uz_end, vz_end, dx_start, dwz_start, duz_start, dvz_start, dx_end, dwz_end, duz_end, dvz_end, dwz, duz, dvz);
            return;
        }
        int[] tex = texture.rImg.img;
        int lengthBIT = tex.length - 1;
        int widthBIT = texture.widthBIT;
        int[] rgb = g3d.display;
        int duz4 = duz * sz2;
        int dvz4 = dvz * sz2;
        int dwz4 = dwz * sz2;
        for (int y = y_start; y < y_end; ++y) {
            int ca;
            int col;
            int dv;
            int du;
            int v_2;
            int u_2;
            int length;
            int wz_b;
            int wz_a;
            int vz_b;
            int vz_a;
            int uz_b;
            int uz_a;
            int x2;
            int x1;
            if (x_start > x_end) {
                x1 = x_end;
                x2 = x_start;
                uz_a = uz_end;
                uz_b = uz_start;
                vz_a = vz_end;
                vz_b = vz_start;
                wz_a = wz_end;
                wz_b = wz_start;
            } else {
                x1 = x_start;
                x2 = x_end;
                uz_a = uz_start;
                uz_b = uz_end;
                vz_a = vz_start;
                vz_b = vz_end;
                wz_a = wz_start;
                wz_b = wz_end;
            }
            long subtexel_a = x1 % 4096;
            long subtexel_b = x2 % 4096;
            uz_a = (int)((long)uz_a - ((long)duz * subtexel_a >> 12));
            vz_a = (int)((long)vz_a - ((long)dvz * subtexel_a >> 12));
            wz_a = (int)((long)wz_a - ((long)dwz * subtexel_a >> 12));
            uz_b = (int)((long)uz_b - ((long)duz * subtexel_b >> 12));
            vz_b = (int)((long)vz_b - ((long)dvz * subtexel_b >> 12));
            wz_b = (int)((long)wz_b - ((long)dwz * subtexel_b >> 12));
            x2 >>= 12;
            if ((x1 >>= 12) < 0) {
                uz_a -= duz * x1;
                vz_a -= dvz * x1;
                wz_a -= dwz * x1;
                x1 = 0;
            }
            if (x2 > g3d.width) {
                uz_b -= duz * (x2 -= g3d.width);
                vz_b -= dvz * x2;
                wz_b -= dwz * x2;
                x2 = g3d.width;
            }
            int tempI = y * g3d.width;
            if (wz_a == 0) {
                return;
            }
            int u = (int)(((long)uz_a << 12) / (long)wz_a);
            int v = (int)(((long)vz_a << 12) / (long)wz_a);
            for (length = (x2 += tempI) - (x1 += tempI); length >= sz2; length -= sz2) {
                u_2 = (int)(((long)(uz_a += duz4) << 12) / (long)(wz_a += dwz4));
                v_2 = (int)(((long)(vz_a += dvz4) << 12) / (long)wz_a);
                du = (u_2 - u) / sz2;
                dv = (v_2 - v) / sz2;
                int i = x1 + sz2;
                while (x1 < i) {
                    col = tex[((v += dv) >> 12 << widthBIT) + ((u += du) >> 12) & lengthBIT];
                    if (col != 0) {
                        ca = col >> 24 & 0xFF;
                        int cols = rgb[x1];
                        rgb[x1] = ((col & 0xFF00FF) * ca + (cols & 0xFF00FF) * (255 - ca) & 0xFF00FF00 | (col & 0xFF00) * ca + (cols & 0xFF00) * (255 - ca) & 0xFF0000) >>> 8;
                    }
                    ++x1;
                }
            }
            if (length > 0) {
                u_2 = (int)(((long)uz_b << 12) / (long)wz_b);
                v_2 = (int)(((long)vz_b << 12) / (long)wz_b);
                du = (u_2 - u) / length;
                dv = (v_2 - v) / length;
                while (x1 < x2) {
                    col = tex[((v += dv) >> 12 << widthBIT) + ((u += du) >> 12) & lengthBIT];
                    if (col != 0) {
                        ca = col >> 24 & 0xFF;
                        int cols = rgb[x1];
                        rgb[x1] = ((col & 0xFF00FF) * ca + (cols & 0xFF00FF) * (255 - ca) & 0xFF00FF00 | (col & 0xFF00) * ca + (cols & 0xFF00) * (255 - ca) & 0xFF0000) >>> 8;
                    }
                    ++x1;
                }
            }
            x_start += dx_start;
            wz_start += dwz_start;
            uz_start += duz_start;
            vz_start += dvz_start;
            x_end += dx_end;
            wz_end += dwz_end;
            uz_end += duz_end;
            vz_end += dvz_end;
        }
    }

    static final void paintMiniTrianglePers_5(Graphics3D g3d, Texture texture, int y_start, int y_end, int x_start, int wz_start, int uz_start, int vz_start, int x_end, int wz_end, int uz_end, int vz_end, int dx_start, int dwz_start, int duz_start, int dvz_start, int dx_end, int dwz_end, int duz_end, int dvz_end, int dwz, int duz, int dvz, int fogc, int sz2, int q, Vertex a, Vertex b, Vertex c, boolean x2pixel, boolean x4pixel, int f_start, int f_end, int df_start, int df_end, int df) {
        if (!(Main.fogQ != 2 || Main.forceLQFog || texture.drawmode != 6 && texture.drawmode != 9)) {
            TexturingPers.paintMiniTrianglePers_6_HQ(g3d, texture, y_start, y_end, x_start, wz_start, uz_start, vz_start, x_end, wz_end, uz_end, vz_end, dx_start, dwz_start, duz_start, dvz_start, dx_end, dwz_end, duz_end, dvz_end, dwz, duz, dvz, fogc, sz2, q, a, b, c, f_start, f_end, df_start, df_end, df);
            return;
        }
        if (Main.fogQ == 0 && (texture.drawmode == 6 || texture.drawmode == 9)) {
            TexturingPers.paintMiniTrianglePers_0(g3d, texture, y_start, y_end, x_start, wz_start, uz_start, vz_start, x_end, wz_end, uz_end, vz_end, dx_start, dwz_start, duz_start, dvz_start, dx_end, dwz_end, duz_end, dvz_end, dwz, duz, dvz, fogc, q, x2pixel, x4pixel);
            return;
        }
        int[] tex = texture.rImg.img;
        int lengthBIT = tex.length - 1;
        int widthBIT = texture.widthBIT;
        int[] rgb = g3d.display;
        int duz4 = duz * q;
        int dvz4 = dvz * q;
        int dwz4 = dwz * q;
        if (texture.getDrawMode() == 6) {
            if (Graphics3D.fDist / 255 != 0) {
                sz2 = -TexturingPers.max(a.rz, b.rz, c.rz) / (Graphics3D.fDist / 255);
            }
            if (sz2 > 255) {
                sz2 = 255;
            }
            if (sz2 < 0) {
                sz2 = 0;
            }
        }
        int isz2 = 255 - sz2;
        for (int y = y_start; y < y_end; ++y) {
            int col;
            int dv;
            int du;
            int v_2;
            int u_2;
            int length;
            int wz_b;
            int wz_a;
            int vz_b;
            int vz_a;
            int uz_b;
            int uz_a;
            int x2;
            int x1;
            if (x_start > x_end) {
                x1 = x_end;
                x2 = x_start;
                uz_a = uz_end;
                uz_b = uz_start;
                vz_a = vz_end;
                vz_b = vz_start;
                wz_a = wz_end;
                wz_b = wz_start;
            } else {
                x1 = x_start;
                x2 = x_end;
                uz_a = uz_start;
                uz_b = uz_end;
                vz_a = vz_start;
                vz_b = vz_end;
                wz_a = wz_start;
                wz_b = wz_end;
            }
            long subtexel_a = x1 % 4096;
            long subtexel_b = x2 % 4096;
            uz_a = (int)((long)uz_a - ((long)duz * subtexel_a >> 12));
            vz_a = (int)((long)vz_a - ((long)dvz * subtexel_a >> 12));
            wz_a = (int)((long)wz_a - ((long)dwz * subtexel_a >> 12));
            uz_b = (int)((long)uz_b - ((long)duz * subtexel_b >> 12));
            vz_b = (int)((long)vz_b - ((long)dvz * subtexel_b >> 12));
            wz_b = (int)((long)wz_b - ((long)dwz * subtexel_b >> 12));
            x2 >>= 12;
            if ((x1 >>= 12) < 0) {
                uz_a -= duz * x1;
                vz_a -= dvz * x1;
                wz_a -= dwz * x1;
                x1 = 0;
            }
            if (x2 > g3d.width) {
                uz_b -= duz * (x2 -= g3d.width);
                vz_b -= dvz * x2;
                wz_b -= dwz * x2;
                x2 = g3d.width;
            }
            int tempI = y * g3d.width;
            if (wz_a == 0) {
                return;
            }
            int u = (int)(((long)uz_a << 12) / (long)wz_a);
            int v = (int)(((long)vz_a << 12) / (long)wz_a);
            for (length = (x2 += tempI) - (x1 += tempI); length >= q; length -= q) {
                u_2 = (int)(((long)(uz_a += duz4) << 12) / (long)(wz_a += dwz4));
                v_2 = (int)(((long)(vz_a += dvz4) << 12) / (long)wz_a);
                du = (u_2 - u) / q;
                dv = (v_2 - v) / q;
                int i = x1 + q;
                while (x1 < i) {
                    col = tex[((v += dv) >> 12 << widthBIT) + ((u += du) >> 12) & lengthBIT];
                    if (col != 0) {
                        rgb[x1] = ((col & 0xFF00FF) * isz2 & 0xFF00FF00 | (col & 0xFF00) * isz2 & 0xFF0000) >>> 8;
                    }
                    ++x1;
                }
            }
            if (length > 0) {
                u_2 = (int)(((long)uz_b << 12) / (long)wz_b);
                v_2 = (int)(((long)vz_b << 12) / (long)wz_b);
                du = (u_2 - u) / length;
                dv = (v_2 - v) / length;
                while (x1 < x2) {
                    col = tex[((v += dv) >> 12 << widthBIT) + ((u += du) >> 12) & lengthBIT];
                    if (col != 0) {
                        rgb[x1] = ((col & 0xFF00FF) * isz2 & 0xFF00FF00 | (col & 0xFF00) * isz2 & 0xFF0000) >>> 8;
                    }
                    ++x1;
                }
            }
            x_start += dx_start;
            wz_start += dwz_start;
            uz_start += duz_start;
            vz_start += dvz_start;
            x_end += dx_end;
            wz_end += dwz_end;
            uz_end += duz_end;
            vz_end += dvz_end;
        }
    }

    static final void paintMiniTrianglePers_6_HQ(Graphics3D g3d, Texture texture, int y_start, int y_end, int x_start, int wz_start, int uz_start, int vz_start, int x_end, int wz_end, int uz_end, int vz_end, int dx_start, int dwz_start, int duz_start, int dvz_start, int dx_end, int dwz_end, int duz_end, int dvz_end, int dwz, int duz, int dvz, int fogc, int sz2, int q, Vertex a, Vertex b, Vertex c, int f_start, int f_end, int df_start, int df_end, int df) {
        if (q > 999 && texture.drawmode == 6) {
            TexturingFloorsWalls.paintFloor_6_HQ(g3d, texture, y_start, y_end, x_start, wz_start, uz_start, vz_start, x_end, wz_end, uz_end, vz_end, dx_start, dwz_start, duz_start, dvz_start, dx_end, dwz_end, duz_end, dvz_end, dwz, duz, dvz, a, b, c, f_start, f_end, df_start, df_end, df);
            return;
        }
        if (q > 999 && texture.drawmode == 9) {
            TexturingFloorsWalls.paintFloor_9_HQ(g3d, texture, y_start, y_end, x_start, wz_start, uz_start, vz_start, x_end, wz_end, uz_end, vz_end, dx_start, dwz_start, duz_start, dvz_start, dx_end, dwz_end, duz_end, dvz_end, dwz, duz, dvz, a, b, c, f_start, f_end, df_start, df_end, df);
            return;
        }
        int[] tex = texture.rImg.img;
        int lengthBIT = tex.length - 1;
        int widthBIT = texture.widthBIT;
        int[] rgb = g3d.display;
        int duz4 = duz * q;
        int dvz4 = dvz * q;
        int dwz4 = dwz * q;
        if (df > 0) {
            --df;
        }
        if (df < 0) {
            ++df;
        }
        for (int y = y_start; y < y_end; ++y) {
            int col;
            int dv;
            int du;
            int v_2;
            int u_2;
            int length;
            int f;
            int wz_b;
            int wz_a;
            int vz_b;
            int vz_a;
            int uz_b;
            int uz_a;
            int x2;
            int x1;
            if (x_start > x_end) {
                x1 = x_end;
                x2 = x_start;
                uz_a = uz_end;
                uz_b = uz_start;
                vz_a = vz_end;
                vz_b = vz_start;
                wz_a = wz_end;
                wz_b = wz_start;
                f = f_end;
            } else {
                x1 = x_start;
                x2 = x_end;
                uz_a = uz_start;
                uz_b = uz_end;
                vz_a = vz_start;
                vz_b = vz_end;
                wz_a = wz_start;
                wz_b = wz_end;
                f = f_start;
            }
            long subtexel_a = x1 % 4096;
            long subtexel_b = x2 % 4096;
            uz_a = (int)((long)uz_a - ((long)duz * subtexel_a >> 12));
            vz_a = (int)((long)vz_a - ((long)dvz * subtexel_a >> 12));
            wz_a = (int)((long)wz_a - ((long)dwz * subtexel_a >> 12));
            uz_b = (int)((long)uz_b - ((long)duz * subtexel_b >> 12));
            vz_b = (int)((long)vz_b - ((long)dvz * subtexel_b >> 12));
            wz_b = (int)((long)wz_b - ((long)dwz * subtexel_b >> 12));
            x2 >>= 12;
            if ((x1 >>= 12) < 0) {
                uz_a -= duz * x1;
                vz_a -= dvz * x1;
                wz_a -= dwz * x1;
                f -= df * x1;
                x1 = 0;
            }
            if (x2 > g3d.width) {
                uz_b -= duz * (x2 -= g3d.width);
                vz_b -= dvz * x2;
                wz_b -= dwz * x2;
                x2 = g3d.width;
            }
            int tempI = y * g3d.width;
            if (wz_a == 0) {
                return;
            }
            int u = (int)(((long)uz_a << 12) / (long)wz_a);
            int v = (int)(((long)vz_a << 12) / (long)wz_a);
            int isz2 = f >> 12;
            f -= df;
            for (length = (x2 += tempI) - (x1 += tempI); length >= q; length -= q) {
                u_2 = (int)(((long)(uz_a += duz4) << 12) / (long)(wz_a += dwz4));
                v_2 = (int)(((long)(vz_a += dvz4) << 12) / (long)wz_a);
                du = (u_2 - u) / q;
                dv = (v_2 - v) / q;
                int i = x1 + q;
                while (x1 < i) {
                    u += du;
                    v += dv;
                    isz2 = (f += df) >> 12;
                    if (isz2 < 0) {
                        isz2 = 0;
                    }
                    if ((col = tex[(v >> 12 << widthBIT) + (u >> 12) & lengthBIT]) != 0) {
                        rgb[x1] = ((col & 0xFF00FF) * isz2 & 0xFF00FF00 | (col & 0xFF00) * isz2 & 0xFF0000) >>> 8;
                    }
                    ++x1;
                }
            }
            if (length > 0) {
                u_2 = (int)(((long)uz_b << 12) / (long)wz_b);
                v_2 = (int)(((long)vz_b << 12) / (long)wz_b);
                du = (u_2 - u) / length;
                dv = (v_2 - v) / length;
                while (x1 < x2) {
                    u += du;
                    v += dv;
                    isz2 = (f += df) >> 12;
                    if (isz2 < 0) {
                        isz2 = 0;
                    }
                    if ((col = tex[(v >> 12 << widthBIT) + (u >> 12) & lengthBIT]) != 0) {
                        rgb[x1] = ((col & 0xFF00FF) * isz2 & 0xFF00FF00 | (col & 0xFF00) * isz2 & 0xFF0000) >>> 8;
                    }
                    ++x1;
                }
            }
            x_start += dx_start;
            wz_start += dwz_start;
            uz_start += duz_start;
            vz_start += dvz_start;
            f_start += df_start;
            x_end += dx_end;
            wz_end += dwz_end;
            uz_end += duz_end;
            vz_end += dvz_end;
            f_end += df_end;
        }
    }

    static final void paintPers_glass(Graphics3D g3d, Texture texture, int y_start, int y_end, int x_start, int wz_start, int uz_start, int vz_start, int x_end, int wz_end, int uz_end, int vz_end, int dx_start, int dwz_start, int duz_start, int dvz_start, int dx_end, int dwz_end, int duz_end, int dvz_end, int dwz, int duz, int dvz, int fogc, int sz2) {
        int[] tex = texture.rImg.img;
        int lengthBIT = tex.length - 1;
        int widthBIT = texture.widthBIT;
        int[] rgb = g3d.display;
        int scale = 50;
        scale = scale * (g3d.getHeight() + g3d.getWidth()) / 560;
        int duz4 = duz * sz2;
        int dvz4 = dvz * sz2;
        int dwz4 = dwz * sz2;
        for (int y = y_start; y < y_end; ++y) {
            int col;
            int dv;
            int du;
            int v_2;
            int u_2;
            int length;
            int wz_b;
            int wz_a;
            int vz_b;
            int vz_a;
            int uz_b;
            int uz_a;
            int x2;
            int x1;
            if (x_start > x_end) {
                x1 = x_end;
                x2 = x_start;
                uz_a = uz_end;
                uz_b = uz_start;
                vz_a = vz_end;
                vz_b = vz_start;
                wz_a = wz_end;
                wz_b = wz_start;
            } else {
                x1 = x_start;
                x2 = x_end;
                uz_a = uz_start;
                uz_b = uz_end;
                vz_a = vz_start;
                vz_b = vz_end;
                wz_a = wz_start;
                wz_b = wz_end;
            }
            long subtexel_a = x1 % 4096;
            long subtexel_b = x2 % 4096;
            uz_a = (int)((long)uz_a - ((long)duz * subtexel_a >> 12));
            vz_a = (int)((long)vz_a - ((long)dvz * subtexel_a >> 12));
            wz_a = (int)((long)wz_a - ((long)dwz * subtexel_a >> 12));
            uz_b = (int)((long)uz_b - ((long)duz * subtexel_b >> 12));
            vz_b = (int)((long)vz_b - ((long)dvz * subtexel_b >> 12));
            wz_b = (int)((long)wz_b - ((long)dwz * subtexel_b >> 12));
            x2 >>= 12;
            if ((x1 >>= 12) < 0) {
                uz_a -= duz * x1;
                vz_a -= dvz * x1;
                wz_a -= dwz * x1;
                x1 = 0;
            }
            if (x2 > g3d.width) {
                uz_b -= duz * (x2 -= g3d.width);
                vz_b -= dvz * x2;
                wz_b -= dwz * x2;
                x2 = g3d.width;
            }
            int tempI = y * g3d.width;
            if (wz_a == 0) {
                return;
            }
            int u = (int)(((long)uz_a << 12) / (long)wz_a);
            int v = (int)(((long)vz_a << 12) / (long)wz_a);
            for (length = (x2 += tempI) - (x1 += tempI); length >= sz2; length -= sz2) {
                u_2 = (int)(((long)(uz_a += duz4) << 12) / (long)(wz_a += dwz4));
                v_2 = (int)(((long)(vz_a += dvz4) << 12) / (long)wz_a);
                du = (u_2 - u) / sz2;
                dv = (v_2 - v) / sz2;
                int i = x1 + sz2;
                while (x1 < i) {
                    col = tex[((v += dv) >> 12 << widthBIT) + ((u += du) >> 12) & lengthBIT];
                    int cr = ((col >> 16 & 0xFF) - 128) * scale / 200;
                    int cg = ((col >> 8 & 0xFF) - 128) * scale / 200;
                    int coord = x1 + cr + cg * g3d.getWidth();
                    if (coord >= g3d.getDisplay().length) {
                        coord = g3d.getDisplay().length - 1;
                    }
                    if (coord < 0) {
                        coord = 0;
                    }
                    rgb[x1] = col = rgb[coord];
                    ++x1;
                }
            }
            if (length > 0) {
                u_2 = (int)(((long)uz_b << 12) / (long)wz_b);
                v_2 = (int)(((long)vz_b << 12) / (long)wz_b);
                du = (u_2 - u) / length;
                dv = (v_2 - v) / length;
                while (x1 < x2) {
                    col = tex[((v += dv) >> 12 << widthBIT) + ((u += du) >> 12) & lengthBIT];
                    int cr = ((col >> 16 & 0xFF) - 128) * scale / 200;
                    int cg = ((col >> 8 & 0xFF) - 128) * scale / 200;
                    int coord = x1 + cr + cg * g3d.getWidth();
                    if (coord >= g3d.getDisplay().length) {
                        coord = g3d.getDisplay().length - 1;
                    }
                    if (coord < 0) {
                        coord = 0;
                    }
                    rgb[x1] = rgb[coord];
                    ++x1;
                }
            }
            x_start += dx_start;
            wz_start += dwz_start;
            uz_start += duz_start;
            vz_start += dvz_start;
            x_end += dx_end;
            wz_end += dwz_end;
            uz_end += duz_end;
            vz_end += dvz_end;
        }
    }

    static final int max(int a, int b, int c) {
        if (a == b || b == c) {
            return TexturingPers.min(a, c);
        }
        if (a == c) {
            return TexturingPers.min(a, b);
        }
        if (a < b && a < c) {
            return a;
        }
        if (b < a && b < c) {
            return b;
        }
        return c;
    }

    private static final int min(int a, int b) {
        if (a < b) {
            return a;
        }
        return b;
    }
}

