/*
 * Decompiled with CFR 0.152.
 */
package code.Rendering;

import code.Gameplay.Map.LightMapper;
import code.HUD.DeveloperMenu;
import code.Math.MathUtils;
import code.Rendering.DirectX7;
import code.Rendering.Texture;
import code.Rendering.TexturingAffine;
import code.Rendering.TexturingFloors;
import code.Rendering.Vertex;
import code.utils.Main;

public class TexturingPers {
    public static final int fp = 12;
    public static final int FP = 4096;
    public static int move = 150;

    public static final void paint(DirectX7 g3d, Texture texture, Vertex a, int au, int av, Vertex b, int bu, int bv, Vertex c, int cu, int cv, int fogc, int dmode, int qz, int q, int al, int bl, int cl, int ag, int bg, int cg, int ab, int bb, int cb, int nx, int ny, int nz) {
        int tmp;
        int y_end;
        int y_start;
        int tb;
        Vertex t;
        boolean colorLighting;
        if (DeveloperMenu.renderPolygonsOverwrite) {
            TexturingAffine.paintOverwrite(g3d, a, b, c);
            return;
        }
        if (!texture.rImg.alphaMixing && texture.drawmode == 4) {
            dmode = 0;
        }
        if (texture.rImg.w != 256) {
            if (texture.mip != null && texture.mip[0].w < 255 || texture.mip == null && texture.rImg.w < 255) {
                if (au == 255) {
                    au = 256;
                }
                if (bu == 255) {
                    bu = 256;
                }
                if (cu == 255) {
                    cu = 256;
                }
            }
            au = au * texture.rImg.w >> 8;
            bu = bu * texture.rImg.w >> 8;
            cu = cu * texture.rImg.w >> 8;
        }
        if (texture.rImg.h != 256) {
            if (texture.mip != null && texture.mip[0].h < 256 || texture.mip == null && texture.rImg.h < 256) {
                if (av == 255) {
                    av = 256;
                }
                if (bv == 255) {
                    bv = 256;
                }
                if (cv == 255) {
                    cv = 256;
                }
            }
            av = av * texture.rImg.h >> 8;
            bv = bv * texture.rImg.h >> 8;
            cv = cv * texture.rImg.h >> 8;
        }
        if (dmode == 8) {
            TexturingAffine.paintFill(g3d, a, b, c, texture, au, av);
            return;
        }
        if (dmode == 10) {
            TexturingAffine.paintDitherGradient(g3d, texture, a, al, b, bl, c, cl);
            return;
        }
        if (dmode == 11) {
            al = 255 + a.rz * 255 / DirectX7.waterDistance;
            if (al > 255) {
                al = 255;
            }
            if (al < 0) {
                al = 0;
            }
            if ((bl = 255 + b.rz * 255 / DirectX7.waterDistance) > 255) {
                bl = 255;
            }
            if (bl < 0) {
                bl = 0;
            }
            if ((cl = 255 + c.rz * 255 / DirectX7.waterDistance) > 255) {
                cl = 255;
            }
            if (cl < 0) {
                cl = 0;
            }
            TexturingAffine.paintDitherGradient(g3d, texture, a, al, b, bl, c, cl);
            return;
        }
        if (dmode == 12) {
            al = 255 + a.rz * 255 / DirectX7.fDist;
            if (al > 255) {
                al = 255;
            }
            if (al < 0) {
                al = 0;
            }
            if ((bl = 255 + b.rz * 255 / DirectX7.fDist) > 255) {
                bl = 255;
            }
            if (bl < 0) {
                bl = 0;
            }
            if ((cl = 255 + c.rz * 255 / DirectX7.fDist) > 255) {
                cl = 255;
            }
            if (cl < 0) {
                cl = 0;
            }
            TexturingAffine.paintDitherGradient(g3d, texture, a, al, b, bl, c, cl);
            return;
        }
        boolean bl2 = colorLighting = al != ag || ag != ab || bl != bg || bg != bb || cl != cb || cb != cg;
        if (b.sy < a.sy) {
            t = a;
            a = b;
            b = t;
            tb = au;
            au = bu;
            bu = tb;
            tb = av;
            av = bv;
            bv = tb;
            tb = al;
            al = bl;
            bl = tb;
            tb = ag;
            ag = bg;
            bg = tb;
            tb = ab;
            ab = bb;
            bb = tb;
        }
        if (c.sy < a.sy) {
            t = c;
            c = a;
            a = t;
            tb = cu;
            cu = au;
            au = tb;
            tb = cv;
            cv = av;
            av = tb;
            tb = cl;
            cl = al;
            al = tb;
            tb = cg;
            cg = ag;
            ag = tb;
            tb = cb;
            cb = ab;
            ab = tb;
        }
        if (c.sy < b.sy) {
            t = b;
            b = c;
            c = t;
            tb = bu;
            bu = cu;
            cu = tb;
            tb = bv;
            bv = cv;
            cv = tb;
            tb = bl;
            bl = cl;
            cl = tb;
            tb = bg;
            bg = cg;
            cg = tb;
            tb = bb;
            bb = cb;
            cb = tb;
        }
        if (a.sy == c.sy) {
            return;
        }
        int cf = 255;
        int bf = 255;
        int af = 255;
        if (DirectX7.fDist > 1) {
            af = 255 + a.rz * 255 / DirectX7.fDist;
            if (af > 255) {
                af = 255;
            }
            if (af < 0) {
                af = 0;
            }
            if ((bf = 255 + b.rz * 255 / DirectX7.fDist) > 255) {
                bf = 255;
            }
            if (bf < 0) {
                bf = 0;
            }
            if ((cf = 255 + c.rz * 255 / DirectX7.fDist) > 255) {
                cf = 255;
            }
            if (cf < 0) {
                cf = 0;
            }
        }
        if (texture.drawmode == 9 || texture.drawmode == 13) {
            af = al;
            bf = bl;
            cf = cl;
        }
        if (texture.drawmode == 13 && Main.fogQ == 1) {
            colorLighting = false;
            ag = ab = (af + ag + ab) / 3;
            af = ab;
            bg = bb = (bf + bg + bb) / 3;
            bf = bb;
            cg = cb = (cf + cg + cb) / 3;
            cf = cb;
        }
        if (LightMapper.cameraVectorLight && texture.drawmode == 6) {
            af = af * MathUtils.calcLight(nx, ny, nz, a.x - g3d.getCamera().m03, a.y - g3d.getCamera().m13, a.z - g3d.getCamera().m23) / 255;
            bf = bf * MathUtils.calcLight(nx, ny, nz, b.x - g3d.getCamera().m03, b.y - g3d.getCamera().m13, b.z - g3d.getCamera().m23) / 255;
            cf = cf * MathUtils.calcLight(nx, ny, nz, c.x - g3d.getCamera().m03, c.y - g3d.getCamera().m13, c.z - g3d.getCamera().m23) / 255;
        }
        if ((dmode == 5 || dmode == 6 || dmode == 9) && af < 1 && bf < 1 && cf < 1) {
            TexturingAffine.paintFill(g3d, a, b, c, 0);
            return;
        }
        int W_UNIT = texture.rImg.W_UNIT;
        int tempI = (W_UNIT >> 12) + move;
        int awz = a.rz < 0 ? tempI / (-a.rz + move) : tempI / move;
        int bwz = b.rz < 0 ? tempI / (-b.rz + move) : tempI / move;
        int cwz = c.rz < 0 ? tempI / (-c.rz + move) : tempI / move;
        int auz = au * awz;
        int avz = av * awz;
        int buz = bu * bwz;
        int bvz = bv * bwz;
        int cuz = cu * cwz;
        int cvz = cv * cwz;
        tempI = c.sy - a.sy;
        int dx_start = (c.sx - a.sx << 12) / tempI;
        int dwz_start = (cwz - awz << 12) / tempI;
        int duz_start = (cuz - auz << 12) / tempI;
        int dvz_start = (cvz - avz << 12) / tempI;
        int df_start = (cf - af << 12) / tempI;
        int dg_start = (cg - ag << 12) / tempI;
        int db_start = (cb - ab << 12) / tempI;
        int dx_end = 0;
        int dwz_end = 0;
        int duz_end = 0;
        int dvz_end = 0;
        int df_end = 0;
        int dg_end = 0;
        int db_end = 0;
        if (b.sy != a.sy) {
            tempI = b.sy - a.sy;
            dx_end = (b.sx - a.sx << 12) / tempI;
            dwz_end = (bwz - awz << 12) / tempI;
            duz_end = (buz - auz << 12) / tempI;
            dvz_end = (bvz - avz << 12) / tempI;
            df_end = (bf - af << 12) / tempI;
            dg_end = (bg - ag << 12) / tempI;
            db_end = (bb - ab << 12) / tempI;
        }
        tempI = b.sy - a.sy;
        int x_start = (a.sx << 12) + dx_start * tempI;
        int wz_start = (awz << 12) + dwz_start * tempI;
        int uz_start = (auz << 12) + duz_start * tempI;
        int vz_start = (avz << 12) + dvz_start * tempI;
        int f_start = (af << 12) + df_start * tempI;
        int g_start = (ag << 12) + dg_start * tempI;
        int b_start = (ab << 12) + db_start * tempI;
        int x_end = b.sx << 12;
        int wz_end = bwz << 12;
        int uz_end = buz << 12;
        int vz_end = bvz << 12;
        int f_end = bf << 12;
        int g_end = bg << 12;
        int b_end = bb << 12;
        tempI = x_start - x_end >> 12;
        if (tempI == 0) {
            return;
        }
        int duz = (uz_start - uz_end) / tempI;
        int dvz = (vz_start - vz_end) / tempI;
        int dwz = (wz_start - wz_end) / tempI;
        int df = (f_start - f_end) / tempI;
        int dg = (g_start - g_end) / tempI;
        int db = (b_start - b_end) / tempI;
        int tempII = c.sy - a.sy;
        int du_start = (cu - au << 12) / tempII;
        int dv_start = (cv - av << 12) / tempII;
        tempII = b.sy - a.sy;
        int x_start2 = (a.sx << 12) + dx_start * tempII;
        int x_end2 = b.sx << 12;
        int u_start = (au << 12) + du_start * tempII;
        int v_start = (av << 12) + dv_start * tempII;
        int u_end = bu << 12;
        int v_end = bv << 12;
        tempII = x_start2 - x_end2 >> 12;
        int du = 0;
        int dv = 0;
        if (tempII == 0) {
            return;
        }
        du = (u_start - u_end) / tempII;
        dv = (v_start - v_end) / tempII;
        x_start = x_end = a.sx << 12;
        wz_start = wz_end = awz << 12;
        uz_start = uz_end = auz << 12;
        vz_start = vz_end = avz << 12;
        f_start = f_end = af << 12;
        g_start = g_end = ag << 12;
        b_start = b_end = ab << 12;
        int dx_start2 = dx_start;
        int duz_start2 = duz_start;
        int dvz_start2 = dvz_start;
        int dwz_start2 = dwz_start;
        int df_start2 = df_start;
        int dg_start2 = dg_start;
        int db_start2 = db_start;
        if (b.sy > 0) {
            y_start = a.sy;
            if (y_start < 0) {
                x_start -= dx_start * y_start;
                wz_start -= dwz_start * y_start;
                uz_start -= duz_start * y_start;
                vz_start -= dvz_start * y_start;
                f_start -= df_start * y_start;
                g_start -= dg_start * y_start;
                b_start -= db_start * y_start;
                x_end -= dx_end * y_start;
                wz_end -= dwz_end * y_start;
                uz_end -= duz_end * y_start;
                vz_end -= dvz_end * y_start;
                f_end -= df_end * y_start;
                g_end -= dg_end * y_start;
                b_end -= db_end * y_start;
                y_start = 0;
            }
            int n = y_end = b.sy < g3d.height ? b.sy : g3d.height;
            if (dx_start > dx_end) {
                tmp = x_start;
                x_start = x_end;
                x_end = tmp;
                tmp = dx_start;
                dx_start = dx_end;
                dx_end = tmp;
                tmp = uz_start;
                uz_start = uz_end;
                uz_end = tmp;
                tmp = vz_start;
                vz_start = vz_end;
                vz_end = tmp;
                tmp = wz_start;
                wz_start = wz_end;
                wz_end = tmp;
                tmp = duz_start;
                duz_start = duz_end;
                duz_end = tmp;
                tmp = dvz_start;
                dvz_start = dvz_end;
                dvz_end = tmp;
                tmp = dwz_start;
                dwz_start = dwz_end;
                dwz_end = tmp;
                f_start = f_end;
                g_start = g_end;
                b_start = b_end;
                df_start = df_end;
                dg_start = dg_end;
                db_start = db_end;
            }
            switch (dmode) {
                case 0: {
                    TexturingPers.paintMiniTrianglePers_0(g3d, texture, y_start, y_end, x_start, wz_start, uz_start, vz_start, x_end, wz_end, uz_end, vz_end, dx_start, dwz_start, duz_start, dvz_start, dx_end, dwz_end, duz_end, dvz_end, dwz, duz, dvz, fogc, q);
                    break;
                }
                case 1: {
                    TexturingPers.paintMiniTrianglePers_1(g3d, texture, y_start, y_end, x_start, wz_start, uz_start, vz_start, x_end, wz_end, uz_end, vz_end, dx_start, dwz_start, duz_start, dvz_start, dx_end, dwz_end, duz_end, dvz_end, dwz, duz, dvz, fogc, qz, q);
                    break;
                }
                case 2: {
                    TexturingPers.paintMiniTrianglePers_2(g3d, texture, y_start, y_end, x_start, wz_start, uz_start, vz_start, x_end, wz_end, uz_end, vz_end, dx_start, dwz_start, duz_start, dvz_start, dx_end, dwz_end, duz_end, dvz_end, dwz, duz, dvz, fogc, q);
                    break;
                }
                case 3: {
                    TexturingPers.paintMiniTrianglePers_3(g3d, texture, y_start, y_end, x_start, wz_start, uz_start, vz_start, x_end, wz_end, uz_end, vz_end, dx_start, dwz_start, duz_start, dvz_start, dx_end, dwz_end, duz_end, dvz_end, dwz, duz, dvz, fogc, qz, q, a, b, c, f_start, f_end, df_start, df_end, df);
                    break;
                }
                case 4: {
                    TexturingPers.paintMiniTrianglePers_4(g3d, texture, y_start, y_end, x_start, wz_start, uz_start, vz_start, x_end, wz_end, uz_end, vz_end, dx_start, dwz_start, duz_start, dvz_start, dx_end, dwz_end, duz_end, dvz_end, dwz, duz, dvz, fogc, q);
                    break;
                }
                case 5: {
                    TexturingPers.paintMiniTrianglePers_5(g3d, texture, y_start, y_end, x_start, wz_start, uz_start, vz_start, x_end, wz_end, uz_end, vz_end, dx_start, dwz_start, duz_start, dvz_start, dx_end, dwz_end, duz_end, dvz_end, dwz, duz, dvz, fogc, qz, q, a, b, c, f_start, f_end, df_start, df_end, df);
                    break;
                }
                case 6: {
                    TexturingPers.paintMiniTrianglePers_5(g3d, texture, y_start, y_end, x_start, wz_start, uz_start, vz_start, x_end, wz_end, uz_end, vz_end, dx_start, dwz_start, duz_start, dvz_start, dx_end, dwz_end, duz_end, dvz_end, dwz, duz, dvz, fogc, qz, q, a, b, c, f_start, f_end, df_start, df_end, df);
                    break;
                }
                case 7: {
                    TexturingPers.paintPers_glass(g3d, texture, y_start, y_end, x_start, wz_start, uz_start, vz_start, x_end, wz_end, uz_end, vz_end, dx_start, dwz_start, duz_start, dvz_start, dx_end, dwz_end, duz_end, dvz_end, dwz, duz, dvz, fogc, q);
                    break;
                }
                case 9: {
                    TexturingPers.paintMiniTrianglePers_5(g3d, texture, y_start, y_end, x_start, wz_start, uz_start, vz_start, x_end, wz_end, uz_end, vz_end, dx_start, dwz_start, duz_start, dvz_start, dx_end, dwz_end, duz_end, dvz_end, dwz, duz, dvz, fogc, qz, q, a, b, c, f_start, f_end, df_start, df_end, df);
                    break;
                }
                case 13: {
                    if (colorLighting) {
                        TexturingPers.paintMiniTrianglePers_13(g3d, texture, y_start, y_end, x_start, wz_start, uz_start, vz_start, x_end, wz_end, uz_end, vz_end, dx_start, dwz_start, duz_start, dvz_start, dx_end, dwz_end, duz_end, dvz_end, dwz, duz, dvz, fogc, qz, q, a, b, c, f_start, f_end, df_start, df_end, df, g_start, g_end, dg_start, dg_end, dg, b_start, b_end, db_start, db_end, db);
                        break;
                    }
                    TexturingPers.paintMiniTrianglePers_5(g3d, texture, y_start, y_end, x_start, wz_start, uz_start, vz_start, x_end, wz_end, uz_end, vz_end, dx_start, dwz_start, duz_start, dvz_start, dx_end, dwz_end, duz_end, dvz_end, dwz, duz, dvz, fogc, qz, q, a, b, c, f_start, f_end, df_start, df_end, df);
                }
            }
        }
        if (c.sy == b.sy || c.sy < 0) {
            return;
        }
        tempI = b.sy - a.sy;
        duz_start = duz_start2;
        dvz_start = dvz_start2;
        dwz_start = dwz_start2;
        dx_start = dx_start2;
        df_start = df_start2;
        dg_start = dg_start2;
        db_start = db_start2;
        x_start = (a.sx << 12) + dx_start * tempI;
        wz_start = (awz << 12) + dwz_start * tempI;
        uz_start = (auz << 12) + duz_start * tempI;
        vz_start = (avz << 12) + dvz_start * tempI;
        f_start = (af << 12) + df_start * tempI;
        g_start = (ag << 12) + dg_start * tempI;
        b_start = (ab << 12) + db_start * tempI;
        x_end = b.sx << 12;
        wz_end = bwz << 12;
        uz_end = buz << 12;
        vz_end = bvz << 12;
        f_end = bf << 12;
        g_end = bg << 12;
        b_end = bb << 12;
        tempI = c.sy - b.sy;
        dx_end = (c.sx - b.sx << 12) / tempI;
        dwz_end = (cwz - bwz << 12) / tempI;
        duz_end = (cuz - buz << 12) / tempI;
        dvz_end = (cvz - bvz << 12) / tempI;
        df_end = (cf - bf << 12) / tempI;
        dg_end = (cg - bg << 12) / tempI;
        db_end = (cb - bb << 12) / tempI;
        y_start = b.sy;
        if (y_start < 0) {
            x_start -= dx_start * y_start;
            wz_start -= dwz_start * y_start;
            uz_start -= duz_start * y_start;
            vz_start -= dvz_start * y_start;
            f_start -= df_start * y_start;
            g_start -= dg_start * y_start;
            b_start -= db_start * y_start;
            x_end -= dx_end * y_start;
            wz_end -= dwz_end * y_start;
            uz_end -= duz_end * y_start;
            vz_end -= dvz_end * y_start;
            f_end -= df_end * y_start;
            g_end -= dg_end * y_start;
            b_end -= db_end * y_start;
            y_start = 0;
        }
        int n = y_end = c.sy < g3d.height ? c.sy : g3d.height;
        if (x_start > x_end) {
            tmp = x_start;
            x_start = x_end;
            x_end = tmp;
            tmp = dx_start;
            dx_start = dx_end;
            dx_end = tmp;
            tmp = uz_start;
            uz_start = uz_end;
            uz_end = tmp;
            tmp = vz_start;
            vz_start = vz_end;
            vz_end = tmp;
            tmp = wz_start;
            wz_start = wz_end;
            wz_end = tmp;
            tmp = duz_start;
            duz_start = duz_end;
            duz_end = tmp;
            tmp = dvz_start;
            dvz_start = dvz_end;
            dvz_end = tmp;
            tmp = dwz_start;
            dwz_start = dwz_end;
            dwz_end = tmp;
            f_start = f_end;
            g_start = g_end;
            b_start = b_end;
            df_start = df_end;
            dg_start = dg_end;
            db_start = db_end;
        }
        switch (dmode) {
            case 0: {
                TexturingPers.paintMiniTrianglePers_0(g3d, texture, y_start, y_end, x_start, wz_start, uz_start, vz_start, x_end, wz_end, uz_end, vz_end, dx_start, dwz_start, duz_start, dvz_start, dx_end, dwz_end, duz_end, dvz_end, dwz, duz, dvz, fogc, q);
                break;
            }
            case 1: {
                TexturingPers.paintMiniTrianglePers_1(g3d, texture, y_start, y_end, x_start, wz_start, uz_start, vz_start, x_end, wz_end, uz_end, vz_end, dx_start, dwz_start, duz_start, dvz_start, dx_end, dwz_end, duz_end, dvz_end, dwz, duz, dvz, fogc, qz, q);
                break;
            }
            case 2: {
                TexturingPers.paintMiniTrianglePers_2(g3d, texture, y_start, y_end, x_start, wz_start, uz_start, vz_start, x_end, wz_end, uz_end, vz_end, dx_start, dwz_start, duz_start, dvz_start, dx_end, dwz_end, duz_end, dvz_end, dwz, duz, dvz, fogc, q);
                break;
            }
            case 3: {
                TexturingPers.paintMiniTrianglePers_3(g3d, texture, y_start, y_end, x_start, wz_start, uz_start, vz_start, x_end, wz_end, uz_end, vz_end, dx_start, dwz_start, duz_start, dvz_start, dx_end, dwz_end, duz_end, dvz_end, dwz, duz, dvz, fogc, qz, q, a, b, c, f_start, f_end, df_start, df_end, df);
                break;
            }
            case 4: {
                TexturingPers.paintMiniTrianglePers_4(g3d, texture, y_start, y_end, x_start, wz_start, uz_start, vz_start, x_end, wz_end, uz_end, vz_end, dx_start, dwz_start, duz_start, dvz_start, dx_end, dwz_end, duz_end, dvz_end, dwz, duz, dvz, fogc, q);
                break;
            }
            case 5: {
                TexturingPers.paintMiniTrianglePers_5(g3d, texture, y_start, y_end, x_start, wz_start, uz_start, vz_start, x_end, wz_end, uz_end, vz_end, dx_start, dwz_start, duz_start, dvz_start, dx_end, dwz_end, duz_end, dvz_end, dwz, duz, dvz, fogc, qz, q, a, b, c, f_start, f_end, df_start, df_end, df);
                break;
            }
            case 6: {
                TexturingPers.paintMiniTrianglePers_5(g3d, texture, y_start, y_end, x_start, wz_start, uz_start, vz_start, x_end, wz_end, uz_end, vz_end, dx_start, dwz_start, duz_start, dvz_start, dx_end, dwz_end, duz_end, dvz_end, dwz, duz, dvz, fogc, qz, q, a, b, c, f_start, f_end, df_start, df_end, df);
                break;
            }
            case 7: {
                TexturingPers.paintPers_glass(g3d, texture, y_start, y_end, x_start, wz_start, uz_start, vz_start, x_end, wz_end, uz_end, vz_end, dx_start, dwz_start, duz_start, dvz_start, dx_end, dwz_end, duz_end, dvz_end, dwz, duz, dvz, fogc, q);
                break;
            }
            case 9: {
                TexturingPers.paintMiniTrianglePers_5(g3d, texture, y_start, y_end, x_start, wz_start, uz_start, vz_start, x_end, wz_end, uz_end, vz_end, dx_start, dwz_start, duz_start, dvz_start, dx_end, dwz_end, duz_end, dvz_end, dwz, duz, dvz, fogc, qz, q, a, b, c, f_start, f_end, df_start, df_end, df);
                break;
            }
            case 13: {
                if (colorLighting) {
                    TexturingPers.paintMiniTrianglePers_13(g3d, texture, y_start, y_end, x_start, wz_start, uz_start, vz_start, x_end, wz_end, uz_end, vz_end, dx_start, dwz_start, duz_start, dvz_start, dx_end, dwz_end, duz_end, dvz_end, dwz, duz, dvz, fogc, qz, q, a, b, c, f_start, f_end, df_start, df_end, df, g_start, g_end, dg_start, dg_end, dg, b_start, b_end, db_start, db_end, db);
                    break;
                }
                TexturingPers.paintMiniTrianglePers_5(g3d, texture, y_start, y_end, x_start, wz_start, uz_start, vz_start, x_end, wz_end, uz_end, vz_end, dx_start, dwz_start, duz_start, dvz_start, dx_end, dwz_end, duz_end, dvz_end, dwz, duz, dvz, fogc, qz, q, a, b, c, f_start, f_end, df_start, df_end, df);
            }
        }
    }

    static final void paintMiniTrianglePers_0(DirectX7 g3d, Texture texture, int y_start, int y_end, int x_start, int wz_start, int uz_start, int vz_start, int x_end, int wz_end, int uz_end, int vz_end, int dx_start, int dwz_start, int duz_start, int dvz_start, int dx_end, int dwz_end, int duz_end, int dvz_end, int dwz, int duz, int dvz, int fogc, int sz2) {
        if (sz2 > 999) {
            TexturingFloors.paintFloor(g3d, texture, y_start, y_end, x_start, wz_start, uz_start, vz_start, x_end, wz_end, uz_end, vz_end, dx_start, dwz_start, duz_start, dvz_start, dx_end, dwz_end, duz_end, dvz_end, dwz, duz, dvz, fogc, sz2);
            return;
        }
        int[] tex = texture.rImg.img;
        int lengthBIT = tex.length - 1;
        int widthBIT = texture.rImg.widthBIT;
        int[] rgb = g3d.display;
        int duz4 = duz * sz2;
        int dvz4 = dvz * sz2;
        int dwz4 = dwz * sz2;
        int sz21 = sz2 + 1;
        for (int y = y_start; y < y_end; ++y) {
            int x1 = x_start;
            int x2 = x_end;
            int uz_a = uz_start;
            int uz_b = uz_end;
            int vz_a = vz_start;
            int vz_b = vz_end;
            int wz_a = wz_start;
            int wz_b = wz_end;
            long subtexel_a = x1 % 4096;
            long subtexel_b = x2 % 4096;
            uz_a = (int)((long)uz_a - ((long)duz * subtexel_a >> 12));
            vz_a = (int)((long)vz_a - ((long)dvz * subtexel_a >> 12));
            wz_a = (int)((long)wz_a - ((long)dwz * subtexel_a >> 12));
            uz_b = (int)((long)uz_b - ((long)duz * subtexel_b >> 12));
            vz_b = (int)((long)vz_b - ((long)dvz * subtexel_b >> 12));
            wz_b = (int)((long)wz_b - ((long)dwz * subtexel_b >> 12));
            x2 >>= 12;
            if ((x1 >>= 12) < 0) {
                uz_a -= duz * x1;
                vz_a -= dvz * x1;
                wz_a -= dwz * x1;
                x1 = 0;
            }
            if (x2 > g3d.width) {
                uz_b -= duz * (x2 -= g3d.width);
                vz_b -= dvz * x2;
                wz_b -= dwz * x2;
                x2 = g3d.width;
            }
            if (wz_a == 0 || wz_b == 0) {
                return;
            }
            int tempI = y * g3d.width;
            int length = (x2 += tempI) - (x1 += tempI);
            int u = (int)(((long)uz_a << 12) / (long)wz_a);
            int v = (int)(((long)vz_a << 12) / (long)wz_a);
            while (length > 0) {
                int col;
                int dv;
                int du;
                int lineEnd;
                if (length >= sz2) {
                    lineEnd = x1 + sz2;
                    du = ((int)(((long)(uz_a += duz4) << 12) / (long)(wz_a += dwz4)) - u) / sz21;
                    dv = ((int)(((long)(vz_a += dvz4) << 12) / (long)wz_a) - v) / sz21;
                    length -= sz2;
                } else {
                    lineEnd = x2;
                    du = ((int)(((long)uz_b << 12) / (long)wz_b) - u) / length;
                    dv = ((int)(((long)vz_b << 12) / (long)wz_b) - v) / length;
                    length = 0;
                }
                int du2 = du << 1;
                int dv2 = dv << 1;
                while (lineEnd - x1 >= 6) {
                    col = tex[(v + dv >>> 12 << widthBIT) + (u + du >>> 12) & lengthBIT];
                    if (col != 0) {
                        rgb[x1] = col;
                    }
                    if ((col = tex[(v + dv2 >>> 12 << widthBIT) + (u + du2 >>> 12) & lengthBIT]) != 0) {
                        rgb[x1 + 1] = col;
                    }
                    if ((col = tex[((v += dv2) + dv >>> 12 << widthBIT) + ((u += du2) + du >>> 12) & lengthBIT]) != 0) {
                        rgb[x1 + 2] = col;
                    }
                    if ((col = tex[(v + dv2 >>> 12 << widthBIT) + (u + du2 >>> 12) & lengthBIT]) != 0) {
                        rgb[x1 + 3] = col;
                    }
                    if ((col = tex[((v += dv2) + dv >>> 12 << widthBIT) + ((u += du2) + du >>> 12) & lengthBIT]) != 0) {
                        rgb[x1 + 4] = col;
                    }
                    if ((col = tex[(v + dv2 >>> 12 << widthBIT) + (u + du2 >>> 12) & lengthBIT]) != 0) {
                        rgb[x1 + 5] = col;
                    }
                    u += du2;
                    v += dv2;
                    x1 += 6;
                }
                while (x1 < lineEnd) {
                    col = tex[((v += dv) >>> 12 << widthBIT) + ((u += du) >>> 12) & lengthBIT];
                    if (col != 0) {
                        rgb[x1] = col;
                    }
                    ++x1;
                }
            }
            x_start += dx_start;
            wz_start += dwz_start;
            uz_start += duz_start;
            vz_start += dvz_start;
            x_end += dx_end;
            wz_end += dwz_end;
            uz_end += duz_end;
            vz_end += dvz_end;
        }
    }

    static final void paintMiniTrianglePers_1(DirectX7 g3d, Texture texture, int y_start, int y_end, int x_start, int wz_start, int uz_start, int vz_start, int x_end, int wz_end, int uz_end, int vz_end, int dx_start, int dwz_start, int duz_start, int dvz_start, int dx_end, int dwz_end, int duz_end, int dvz_end, int dwz, int duz, int dvz, int fogc, int sz2, int q) {
        if (Main.fogQ == 0) {
            TexturingPers.paintMiniTrianglePers_0(g3d, texture, y_start, y_end, x_start, wz_start, uz_start, vz_start, x_end, wz_end, uz_end, vz_end, dx_start, dwz_start, duz_start, dvz_start, dx_end, dwz_end, duz_end, dvz_end, dwz, duz, dvz, fogc, q);
            return;
        }
        if (sz2 > 999) {
            TexturingFloors.paintFloor_1(g3d, texture, y_start, y_end, x_start, wz_start, uz_start, vz_start, x_end, wz_end, uz_end, vz_end, dx_start, dwz_start, duz_start, dvz_start, dx_end, dwz_end, duz_end, dvz_end, dwz, duz, dvz, sz2);
            return;
        }
        int[] tex = texture.rImg.img;
        int lengthBIT = tex.length - 1;
        int widthBIT = texture.rImg.widthBIT;
        int[] rgb = g3d.display;
        int duz4 = duz * q;
        int dvz4 = dvz * q;
        int dwz4 = dwz * q;
        int colf = sz2 & 0xFEFEFE;
        for (int y = y_start; y < y_end; ++y) {
            int col;
            int dv;
            int du;
            int length;
            int x1 = x_start;
            int x2 = x_end;
            int uz_a = uz_start;
            int uz_b = uz_end;
            int vz_a = vz_start;
            int vz_b = vz_end;
            int wz_a = wz_start;
            int wz_b = wz_end;
            long subtexel_a = x1 % 4096;
            long subtexel_b = x2 % 4096;
            uz_a = (int)((long)uz_a - ((long)duz * subtexel_a >> 12));
            vz_a = (int)((long)vz_a - ((long)dvz * subtexel_a >> 12));
            wz_a = (int)((long)wz_a - ((long)dwz * subtexel_a >> 12));
            uz_b = (int)((long)uz_b - ((long)duz * subtexel_b >> 12));
            vz_b = (int)((long)vz_b - ((long)dvz * subtexel_b >> 12));
            wz_b = (int)((long)wz_b - ((long)dwz * subtexel_b >> 12));
            x2 >>= 12;
            if ((x1 >>= 12) < 0) {
                uz_a -= duz * x1;
                vz_a -= dvz * x1;
                wz_a -= dwz * x1;
                x1 = 0;
            }
            if (x2 > g3d.width) {
                uz_b -= duz * (x2 -= g3d.width);
                vz_b -= dvz * x2;
                wz_b -= dwz * x2;
                x2 = g3d.width;
            }
            int tempI = y * g3d.width;
            if (wz_a == 0) {
                return;
            }
            int u = (int)(((long)uz_a << 12) / (long)wz_a);
            int v = (int)(((long)vz_a << 12) / (long)wz_a);
            for (length = (x2 += tempI) - (x1 += tempI); length >= q; length -= q) {
                du = ((int)(((long)(uz_a += duz4) << 12) / (long)(wz_a += dwz4)) - u) / q;
                dv = ((int)(((long)(vz_a += dvz4) << 12) / (long)wz_a) - v) / q;
                int i = x1 + q;
                while (x1 < i) {
                    col = tex[((v += dv) >>> 12 << widthBIT) + ((u += du) >>> 12) & lengthBIT];
                    if (col != 0) {
                        col = (col & 0xFEFEFE) + colf;
                        rgb[x1] = col | (col >>> 8 & 0x10101) * 255;
                    }
                    if ((col = tex[((v += dv) >>> 12 << widthBIT) + ((u += du) >>> 12) & lengthBIT]) != 0) {
                        col = (col & 0xFEFEFE) + colf;
                        rgb[x1 + 1] = col | (col >>> 8 & 0x10101) * 255;
                    }
                    if ((col = tex[((v += dv) >>> 12 << widthBIT) + ((u += du) >>> 12) & lengthBIT]) != 0) {
                        col = (col & 0xFEFEFE) + colf;
                        rgb[x1 + 2] = col | (col >>> 8 & 0x10101) * 255;
                    }
                    if ((col = tex[((v += dv) >>> 12 << widthBIT) + ((u += du) >>> 12) & lengthBIT]) != 0) {
                        col = (col & 0xFEFEFE) + colf;
                        rgb[x1 + 3] = col | (col >>> 8 & 0x10101) * 255;
                    }
                    x1 += 4;
                }
            }
            if (length > 0) {
                du = ((int)(((long)uz_b << 12) / (long)wz_b) - u) / length;
                dv = ((int)(((long)vz_b << 12) / (long)wz_b) - v) / length;
                while (x2 - x1 >= 4) {
                    col = tex[((v += dv) >>> 12 << widthBIT) + ((u += du) >>> 12) & lengthBIT];
                    if (col != 0) {
                        col = (col & 0xFEFEFE) + colf;
                        rgb[x1] = col | (col >>> 8 & 0x10101) * 255;
                    }
                    if ((col = tex[((v += dv) >>> 12 << widthBIT) + ((u += du) >>> 12) & lengthBIT]) != 0) {
                        col = (col & 0xFEFEFE) + colf;
                        rgb[x1 + 1] = col | (col >>> 8 & 0x10101) * 255;
                    }
                    if ((col = tex[((v += dv) >>> 12 << widthBIT) + ((u += du) >>> 12) & lengthBIT]) != 0) {
                        col = (col & 0xFEFEFE) + colf;
                        rgb[x1 + 2] = col | (col >>> 8 & 0x10101) * 255;
                    }
                    if ((col = tex[((v += dv) >>> 12 << widthBIT) + ((u += du) >>> 12) & lengthBIT]) != 0) {
                        col = (col & 0xFEFEFE) + colf;
                        rgb[x1 + 3] = col | (col >>> 8 & 0x10101) * 255;
                    }
                    x1 += 4;
                }
                while (x1 < x2) {
                    col = tex[((v += dv) >>> 12 << widthBIT) + ((u += du) >>> 12) & lengthBIT];
                    if (col != 0) {
                        col = (col & 0xFEFEFE) + colf;
                        rgb[x1] = col | (col >>> 8 & 0x10101) * 255;
                    }
                    ++x1;
                }
            }
            x_start += dx_start;
            wz_start += dwz_start;
            uz_start += duz_start;
            vz_start += dvz_start;
            x_end += dx_end;
            wz_end += dwz_end;
            uz_end += duz_end;
            vz_end += dvz_end;
        }
    }

    static final void paintMiniTrianglePers_2(DirectX7 g3d, Texture texture, int y_start, int y_end, int x_start, int wz_start, int uz_start, int vz_start, int x_end, int wz_end, int uz_end, int vz_end, int dx_start, int dwz_start, int duz_start, int dvz_start, int dx_end, int dwz_end, int duz_end, int dvz_end, int dwz, int duz, int dvz, int fogc, int sz2) {
        if (sz2 > 999) {
            TexturingFloors.paintFloor_2(g3d, texture, y_start, y_end, x_start, wz_start, uz_start, vz_start, x_end, wz_end, uz_end, vz_end, dx_start, dwz_start, duz_start, dvz_start, dx_end, dwz_end, duz_end, dvz_end, dwz, duz, dvz);
            return;
        }
        int[] tex = texture.rImg.img;
        int lengthBIT = tex.length - 1;
        int widthBIT = texture.rImg.widthBIT;
        int[] rgb = g3d.display;
        int duz4 = duz * sz2;
        int dvz4 = dvz * sz2;
        int dwz4 = dwz * sz2;
        for (int y = y_start; y < y_end; ++y) {
            int col;
            int dv;
            int du;
            int length;
            int x1 = x_start;
            int x2 = x_end;
            int uz_a = uz_start;
            int uz_b = uz_end;
            int vz_a = vz_start;
            int vz_b = vz_end;
            int wz_a = wz_start;
            int wz_b = wz_end;
            long subtexel_a = x1 % 4096;
            long subtexel_b = x2 % 4096;
            uz_a = (int)((long)uz_a - ((long)duz * subtexel_a >> 12));
            vz_a = (int)((long)vz_a - ((long)dvz * subtexel_a >> 12));
            wz_a = (int)((long)wz_a - ((long)dwz * subtexel_a >> 12));
            uz_b = (int)((long)uz_b - ((long)duz * subtexel_b >> 12));
            vz_b = (int)((long)vz_b - ((long)dvz * subtexel_b >> 12));
            wz_b = (int)((long)wz_b - ((long)dwz * subtexel_b >> 12));
            x2 >>= 12;
            if ((x1 >>= 12) < 0) {
                uz_a -= duz * x1;
                vz_a -= dvz * x1;
                wz_a -= dwz * x1;
                x1 = 0;
            }
            if (x2 > g3d.width) {
                uz_b -= duz * (x2 -= g3d.width);
                vz_b -= dvz * x2;
                wz_b -= dwz * x2;
                x2 = g3d.width;
            }
            int tempI = y * g3d.width;
            if (wz_a == 0) {
                return;
            }
            int u = (int)(((long)uz_a << 12) / (long)wz_a);
            int v = (int)(((long)vz_a << 12) / (long)wz_a);
            for (length = (x2 += tempI) - (x1 += tempI); length >= sz2; length -= sz2) {
                du = ((int)(((long)(uz_a += duz4) << 12) / (long)(wz_a += dwz4)) - u) / sz2;
                dv = ((int)(((long)(vz_a += dvz4) << 12) / (long)wz_a) - v) / sz2;
                int i = x1 + sz2;
                while (x1 < i) {
                    col = tex[((v += dv) >>> 12 << widthBIT) + ((u += du) >>> 12) & lengthBIT];
                    if (col != 0) {
                        col = (col & 0xFEFEFE) + (rgb[x1] & 0xFEFEFE);
                        rgb[x1] = col | (col >>> 8 & 0x10101) * 255;
                    }
                    if ((col = tex[((v += dv) >>> 12 << widthBIT) + ((u += du) >>> 12) & lengthBIT]) != 0) {
                        col = (col & 0xFEFEFE) + (rgb[x1 + 1] & 0xFEFEFE);
                        rgb[x1 + 1] = col | (col >>> 8 & 0x10101) * 255;
                    }
                    if ((col = tex[((v += dv) >>> 12 << widthBIT) + ((u += du) >>> 12) & lengthBIT]) != 0) {
                        col = (col & 0xFEFEFE) + (rgb[x1 + 2] & 0xFEFEFE);
                        rgb[x1 + 2] = col | (col >>> 8 & 0x10101) * 255;
                    }
                    x1 += 3;
                }
            }
            if (length > 0) {
                du = ((int)(((long)uz_b << 12) / (long)wz_b) - u) / length;
                dv = ((int)(((long)vz_b << 12) / (long)wz_b) - v) / length;
                while (x2 - x1 >= 3) {
                    col = tex[((v += dv) >>> 12 << widthBIT) + ((u += du) >>> 12) & lengthBIT];
                    if (col != 0) {
                        col = (col & 0xFEFEFE) + (rgb[x1] & 0xFEFEFE);
                        rgb[x1] = col | (col >>> 8 & 0x10101) * 255;
                    }
                    if ((col = tex[((v += dv) >>> 12 << widthBIT) + ((u += du) >>> 12) & lengthBIT]) != 0) {
                        col = (col & 0xFEFEFE) + (rgb[x1 + 1] & 0xFEFEFE);
                        rgb[x1 + 1] = col | (col >>> 8 & 0x10101) * 255;
                    }
                    if ((col = tex[((v += dv) >>> 12 << widthBIT) + ((u += du) >>> 12) & lengthBIT]) != 0) {
                        col = (col & 0xFEFEFE) + (rgb[x1 + 2] & 0xFEFEFE);
                        rgb[x1 + 2] = col | (col >>> 8 & 0x10101) * 255;
                    }
                    x1 += 3;
                }
                while (x1 < x2) {
                    col = tex[((v += dv) >>> 12 << widthBIT) + ((u += du) >>> 12) & lengthBIT];
                    if (col != 0) {
                        col = (col & 0xFEFEFE) + (rgb[x1] & 0xFEFEFE);
                        rgb[x1] = col | (col >>> 8 & 0x10101) * 255;
                    }
                    ++x1;
                }
            }
            x_start += dx_start;
            wz_start += dwz_start;
            uz_start += duz_start;
            vz_start += dvz_start;
            x_end += dx_end;
            wz_end += dwz_end;
            uz_end += duz_end;
            vz_end += dvz_end;
        }
    }

    static final void paintMiniTrianglePers_3(DirectX7 g3d, Texture texture, int y_start, int y_end, int x_start, int wz_start, int uz_start, int vz_start, int x_end, int wz_end, int uz_end, int vz_end, int dx_start, int dwz_start, int duz_start, int dvz_start, int dx_end, int dwz_end, int duz_end, int dvz_end, int dwz, int duz, int dvz, int fogc, int sz2, int q, Vertex a, Vertex b, Vertex c, int f_start, int f_end, int df_start, int df_end, int df) {
        if (Main.fogQ == 2 && !Main.forceLQFog) {
            TexturingPers.paintMiniTrianglePers_3_HQ(g3d, texture, y_start, y_end, x_start, wz_start, uz_start, vz_start, x_end, wz_end, uz_end, vz_end, dx_start, dwz_start, duz_start, dvz_start, dx_end, dwz_end, duz_end, dvz_end, dwz, duz, dvz, fogc, sz2, q, a, b, c, f_start, f_end, df_start, df_end, df);
            return;
        }
        if (Main.fogQ == 0) {
            TexturingPers.paintMiniTrianglePers_0(g3d, texture, y_start, y_end, x_start, wz_start, uz_start, vz_start, x_end, wz_end, uz_end, vz_end, dx_start, dwz_start, duz_start, dvz_start, dx_end, dwz_end, duz_end, dvz_end, dwz, duz, dvz, fogc, q);
            return;
        }
        if (q > 999) {
            TexturingFloors.paintFloor_3(g3d, texture, y_start, y_end, x_start, wz_start, uz_start, vz_start, x_end, wz_end, uz_end, vz_end, dx_start, dwz_start, duz_start, dvz_start, dx_end, dwz_end, duz_end, dvz_end, dwz, duz, dvz, fogc, sz2, a, b, c, f_start, f_end, df_start, df_end, df);
            return;
        }
        int[] tex = texture.rImg.img;
        int lengthBIT = tex.length - 1;
        int widthBIT = texture.rImg.widthBIT;
        int[] rgb = g3d.display;
        int duz4 = duz * q;
        int dvz4 = dvz * q;
        int dwz4 = dwz * q;
        if (DirectX7.fDist / 255 != 0) {
            sz2 = -TexturingPers.min(a.rz, b.rz, c.rz) / (DirectX7.fDist / 255);
        }
        if (sz2 > 255) {
            sz2 = 255;
        }
        if (sz2 < 0) {
            sz2 = 0;
        }
        int isz2 = 255 - sz2;
        int f2 = (fogc & 0xFF00FF) * sz2;
        int f22 = (fogc & 0xFF00) * sz2;
        for (int y = y_start; y < y_end; ++y) {
            int col;
            int dv;
            int du;
            int length;
            int x1 = x_start;
            int x2 = x_end;
            int uz_a = uz_start;
            int uz_b = uz_end;
            int vz_a = vz_start;
            int vz_b = vz_end;
            int wz_a = wz_start;
            int wz_b = wz_end;
            long subtexel_a = x1 % 4096;
            long subtexel_b = x2 % 4096;
            uz_a = (int)((long)uz_a - ((long)duz * subtexel_a >> 12));
            vz_a = (int)((long)vz_a - ((long)dvz * subtexel_a >> 12));
            wz_a = (int)((long)wz_a - ((long)dwz * subtexel_a >> 12));
            uz_b = (int)((long)uz_b - ((long)duz * subtexel_b >> 12));
            vz_b = (int)((long)vz_b - ((long)dvz * subtexel_b >> 12));
            wz_b = (int)((long)wz_b - ((long)dwz * subtexel_b >> 12));
            x2 >>= 12;
            if ((x1 >>= 12) < 0) {
                uz_a -= duz * x1;
                vz_a -= dvz * x1;
                wz_a -= dwz * x1;
                x1 = 0;
            }
            if (x2 > g3d.width) {
                uz_b -= duz * (x2 -= g3d.width);
                vz_b -= dvz * x2;
                wz_b -= dwz * x2;
                x2 = g3d.width;
            }
            int tempI = y * g3d.width;
            if (wz_a == 0) {
                return;
            }
            int u = (int)(((long)uz_a << 12) / (long)wz_a);
            int v = (int)(((long)vz_a << 12) / (long)wz_a);
            for (length = (x2 += tempI) - (x1 += tempI); length >= q; length -= q) {
                du = ((int)(((long)(uz_a += duz4) << 12) / (long)(wz_a += dwz4)) - u) / q;
                dv = ((int)(((long)(vz_a += dvz4) << 12) / (long)wz_a) - v) / q;
                int i = x1 + q;
                while (x1 < i) {
                    col = tex[((v += dv) >>> 12 << widthBIT) + ((u += du) >>> 12) & lengthBIT];
                    if (col != 0) {
                        rgb[x1] = ((col & 0xFF00FF) * isz2 + f2 & 0xFF00FF00 | (col & 0xFF00) * isz2 + f22 & 0xFF0000) >>> 8;
                    }
                    if ((col = tex[((v += dv) >>> 12 << widthBIT) + ((u += du) >>> 12) & lengthBIT]) != 0) {
                        rgb[x1 + 1] = ((col & 0xFF00FF) * isz2 + f2 & 0xFF00FF00 | (col & 0xFF00) * isz2 + f22 & 0xFF0000) >>> 8;
                    }
                    x1 += 2;
                }
            }
            if (length > 0) {
                du = ((int)(((long)uz_b << 12) / (long)wz_b) - u) / length;
                dv = ((int)(((long)vz_b << 12) / (long)wz_b) - v) / length;
                while (x1 < x2) {
                    col = tex[((v += dv) >>> 12 << widthBIT) + ((u += du) >>> 12) & lengthBIT];
                    if (col != 0) {
                        rgb[x1] = ((col & 0xFF00FF) * isz2 + f2 & 0xFF00FF00 | (col & 0xFF00) * isz2 + f22 & 0xFF0000) >>> 8;
                    }
                    ++x1;
                }
            }
            x_start += dx_start;
            wz_start += dwz_start;
            uz_start += duz_start;
            vz_start += dvz_start;
            x_end += dx_end;
            wz_end += dwz_end;
            uz_end += duz_end;
            vz_end += dvz_end;
        }
    }

    static final void paintMiniTrianglePers_3_HQ(DirectX7 g3d, Texture texture, int y_start, int y_end, int x_start, int wz_start, int uz_start, int vz_start, int x_end, int wz_end, int uz_end, int vz_end, int dx_start, int dwz_start, int duz_start, int dvz_start, int dx_end, int dwz_end, int duz_end, int dvz_end, int dwz, int duz, int dvz, int fogc, int sz2, int q, Vertex a, Vertex b, Vertex c, int f_start, int f_end, int df_start, int df_end, int df) {
        if (q > 999) {
            TexturingFloors.paintFloor_3_HQ(g3d, texture, y_start, y_end, x_start, wz_start, uz_start, vz_start, x_end, wz_end, uz_end, vz_end, dx_start, dwz_start, duz_start, dvz_start, dx_end, dwz_end, duz_end, dvz_end, dwz, duz, dvz, a, b, c, f_start, f_end, df_start, df_end, df);
            return;
        }
        int[] tex = texture.rImg.img;
        int lengthBIT = tex.length - 1;
        int widthBIT = texture.rImg.widthBIT;
        int[] rgb = g3d.display;
        int duz4 = duz * q;
        int dvz4 = dvz * q;
        int dwz4 = dwz * q;
        int fogcolor = DirectX7.fogc;
        int fogcolor2 = fogcolor & 0xFF00;
        fogcolor &= 0xFF00FF;
        for (int y = y_start; y < y_end; ++y) {
            int tf2;
            int tf;
            int col;
            int dv;
            int du;
            int length;
            int x1 = x_start;
            int x2 = x_end;
            int uz_a = uz_start;
            int uz_b = uz_end;
            int vz_a = vz_start;
            int vz_b = vz_end;
            int wz_a = wz_start;
            int wz_b = wz_end;
            int f = f_start;
            long subtexel_a = x1 % 4096;
            long subtexel_b = x2 % 4096;
            uz_a = (int)((long)uz_a - ((long)duz * subtexel_a >> 12));
            vz_a = (int)((long)vz_a - ((long)dvz * subtexel_a >> 12));
            wz_a = (int)((long)wz_a - ((long)dwz * subtexel_a >> 12));
            uz_b = (int)((long)uz_b - ((long)duz * subtexel_b >> 12));
            vz_b = (int)((long)vz_b - ((long)dvz * subtexel_b >> 12));
            wz_b = (int)((long)wz_b - ((long)dwz * subtexel_b >> 12));
            x2 >>= 12;
            if ((x1 >>= 12) < 0) {
                uz_a -= duz * x1;
                vz_a -= dvz * x1;
                wz_a -= dwz * x1;
                f -= df * x1;
                x1 = 0;
            }
            if (x2 > g3d.width) {
                uz_b -= duz * (x2 -= g3d.width);
                vz_b -= dvz * x2;
                wz_b -= dwz * x2;
                x2 = g3d.width;
            }
            int tempI = y * g3d.width;
            if (wz_a == 0) {
                return;
            }
            int u = (int)(((long)uz_a << 12) / (long)wz_a);
            int v = (int)(((long)vz_a << 12) / (long)wz_a);
            for (length = (x2 += tempI) - (x1 += tempI); length >= q; length -= q) {
                du = ((int)(((long)(uz_a += duz4) << 12) / (long)(wz_a += dwz4)) - u) / q;
                dv = ((int)(((long)(vz_a += dvz4) << 12) / (long)wz_a) - v) / q;
                int i = x1 + q;
                while (i - x1 >= 2) {
                    col = tex[((v += dv) >>> 12 << widthBIT) + ((u += du) >>> 12) & lengthBIT];
                    if (col != 0) {
                        tf = (f += df) >>> 12;
                        tf2 = 255 - tf;
                        rgb[x1] = (fogcolor * tf2 + (col & 0xFF00FF) * tf & 0xFF00FF00 | fogcolor2 * tf2 + (col & 0xFF00) * tf & 0xFF0000) >>> 8;
                    }
                    if ((col = tex[((v += dv) >>> 12 << widthBIT) + ((u += du) >>> 12) & lengthBIT]) != 0) {
                        tf = (f += df) >>> 12;
                        tf2 = 255 - tf;
                        rgb[x1 + 1] = (fogcolor * tf2 + (col & 0xFF00FF) * tf & 0xFF00FF00 | fogcolor2 * tf2 + (col & 0xFF00) * tf & 0xFF0000) >>> 8;
                    }
                    x1 += 2;
                }
            }
            if (length > 0) {
                du = ((int)(((long)uz_b << 12) / (long)wz_b) - u) / length;
                dv = ((int)(((long)vz_b << 12) / (long)wz_b) - v) / length;
                while (x1 < x2) {
                    col = tex[((v += dv) >>> 12 << widthBIT) + ((u += du) >>> 12) & lengthBIT];
                    if (col != 0) {
                        tf = (f += df) >>> 12;
                        tf2 = 255 - tf;
                        rgb[x1] = (fogcolor * tf2 + (col & 0xFF00FF) * tf & 0xFF00FF00 | fogcolor2 * tf2 + (col & 0xFF00) * tf & 0xFF0000) >>> 8;
                    }
                    ++x1;
                }
            }
            x_start += dx_start;
            wz_start += dwz_start;
            uz_start += duz_start;
            vz_start += dvz_start;
            f_start += df_start;
            x_end += dx_end;
            wz_end += dwz_end;
            uz_end += duz_end;
            vz_end += dvz_end;
            f_end += df_end;
        }
    }

    static final void paintMiniTrianglePers_4(DirectX7 g3d, Texture texture, int y_start, int y_end, int x_start, int wz_start, int uz_start, int vz_start, int x_end, int wz_end, int uz_end, int vz_end, int dx_start, int dwz_start, int duz_start, int dvz_start, int dx_end, int dwz_end, int duz_end, int dvz_end, int dwz, int duz, int dvz, int fogc, int sz2) {
        if (sz2 > 999) {
            TexturingFloors.paintFloor_4(g3d, texture, y_start, y_end, x_start, wz_start, uz_start, vz_start, x_end, wz_end, uz_end, vz_end, dx_start, dwz_start, duz_start, dvz_start, dx_end, dwz_end, duz_end, dvz_end, dwz, duz, dvz);
            return;
        }
        int[] tex = texture.rImg.img;
        int lengthBIT = tex.length - 1;
        int widthBIT = texture.rImg.widthBIT;
        int[] rgb = g3d.display;
        int duz4 = duz * sz2;
        int dvz4 = dvz * sz2;
        int dwz4 = dwz * sz2;
        for (int y = y_start; y < y_end; ++y) {
            int cols;
            int ca;
            int col;
            int dv;
            int du;
            int length;
            int x1 = x_start;
            int x2 = x_end;
            int uz_a = uz_start;
            int uz_b = uz_end;
            int vz_a = vz_start;
            int vz_b = vz_end;
            int wz_a = wz_start;
            int wz_b = wz_end;
            long subtexel_a = x1 % 4096;
            long subtexel_b = x2 % 4096;
            uz_a = (int)((long)uz_a - ((long)duz * subtexel_a >> 12));
            vz_a = (int)((long)vz_a - ((long)dvz * subtexel_a >> 12));
            wz_a = (int)((long)wz_a - ((long)dwz * subtexel_a >> 12));
            uz_b = (int)((long)uz_b - ((long)duz * subtexel_b >> 12));
            vz_b = (int)((long)vz_b - ((long)dvz * subtexel_b >> 12));
            wz_b = (int)((long)wz_b - ((long)dwz * subtexel_b >> 12));
            x2 >>= 12;
            if ((x1 >>= 12) < 0) {
                uz_a -= duz * x1;
                vz_a -= dvz * x1;
                wz_a -= dwz * x1;
                x1 = 0;
            }
            if (x2 > g3d.width) {
                uz_b -= duz * (x2 -= g3d.width);
                vz_b -= dvz * x2;
                wz_b -= dwz * x2;
                x2 = g3d.width;
            }
            int tempI = y * g3d.width;
            if (wz_a == 0) {
                return;
            }
            int u = (int)(((long)uz_a << 12) / (long)wz_a);
            int v = (int)(((long)vz_a << 12) / (long)wz_a);
            for (length = (x2 += tempI) - (x1 += tempI); length >= sz2; length -= sz2) {
                du = ((int)(((long)(uz_a += duz4) << 12) / (long)(wz_a += dwz4)) - u) / sz2;
                dv = ((int)(((long)(vz_a += dvz4) << 12) / (long)wz_a) - v) / sz2;
                int i = x1 + sz2;
                while (x1 < i) {
                    col = tex[((v += dv) >>> 12 << widthBIT) + ((u += du) >>> 12) & lengthBIT];
                    if (col != 0) {
                        ca = col >>> 24;
                        cols = rgb[x1];
                        rgb[x1] = ((col & 0xFF00FF) * ca + (cols & 0xFF00FF) * (255 - ca) & 0xFF00FF00 | (col & 0xFF00) * ca + (cols & 0xFF00) * (255 - ca) & 0xFF0000) >>> 8;
                    }
                    if ((col = tex[((v += dv) >>> 12 << widthBIT) + ((u += du) >>> 12) & lengthBIT]) != 0) {
                        ca = col >>> 24;
                        cols = rgb[x1 + 1];
                        rgb[x1 + 1] = ((col & 0xFF00FF) * ca + (cols & 0xFF00FF) * (255 - ca) & 0xFF00FF00 | (col & 0xFF00) * ca + (cols & 0xFF00) * (255 - ca) & 0xFF0000) >>> 8;
                    }
                    x1 += 2;
                }
            }
            if (length > 0) {
                du = ((int)(((long)uz_b << 12) / (long)wz_b) - u) / length;
                dv = ((int)(((long)vz_b << 12) / (long)wz_b) - v) / length;
                while (x2 - x1 >= 2) {
                    col = tex[((v += dv) >>> 12 << widthBIT) + ((u += du) >>> 12) & lengthBIT];
                    if (col != 0) {
                        ca = col >>> 24;
                        cols = rgb[x1];
                        rgb[x1] = ((col & 0xFF00FF) * ca + (cols & 0xFF00FF) * (255 - ca) & 0xFF00FF00 | (col & 0xFF00) * ca + (cols & 0xFF00) * (255 - ca) & 0xFF0000) >>> 8;
                    }
                    if ((col = tex[((v += dv) >>> 12 << widthBIT) + ((u += du) >>> 12) & lengthBIT]) != 0) {
                        ca = col >>> 24;
                        cols = rgb[x1 + 1];
                        rgb[x1 + 1] = ((col & 0xFF00FF) * ca + (cols & 0xFF00FF) * (255 - ca) & 0xFF00FF00 | (col & 0xFF00) * ca + (cols & 0xFF00) * (255 - ca) & 0xFF0000) >>> 8;
                    }
                    x1 += 2;
                }
                while (x1 < x2) {
                    col = tex[((v += dv) >>> 12 << widthBIT) + ((u += du) >>> 12) & lengthBIT];
                    if (col != 0) {
                        ca = col >>> 24;
                        cols = rgb[x1];
                        rgb[x1] = ((col & 0xFF00FF) * ca + (cols & 0xFF00FF) * (255 - ca) & 0xFF00FF00 | (col & 0xFF00) * ca + (cols & 0xFF00) * (255 - ca) & 0xFF0000) >>> 8;
                    }
                    ++x1;
                }
            }
            x_start += dx_start;
            wz_start += dwz_start;
            uz_start += duz_start;
            vz_start += dvz_start;
            x_end += dx_end;
            wz_end += dwz_end;
            uz_end += duz_end;
            vz_end += dvz_end;
        }
    }

    static final void paintMiniTrianglePers_5(DirectX7 g3d, Texture texture, int y_start, int y_end, int x_start, int wz_start, int uz_start, int vz_start, int x_end, int wz_end, int uz_end, int vz_end, int dx_start, int dwz_start, int duz_start, int dvz_start, int dx_end, int dwz_end, int duz_end, int dvz_end, int dwz, int duz, int dvz, int fogc, int sz2, int q, Vertex a, Vertex b, Vertex c, int f_start, int f_end, int df_start, int df_end, int df) {
        if ((texture.drawmode == 9 || texture.drawmode == 13) && Main.fogQ >= 1 || Main.fogQ == 2 && !Main.forceLQFog && texture.drawmode == 6) {
            TexturingPers.paintMiniTrianglePers_6_HQ(g3d, texture, y_start, y_end, x_start, wz_start, uz_start, vz_start, x_end, wz_end, uz_end, vz_end, dx_start, dwz_start, duz_start, dvz_start, dx_end, dwz_end, duz_end, dvz_end, dwz, duz, dvz, fogc, sz2, q, a, b, c, f_start, f_end, df_start, df_end, df);
            return;
        }
        if (Main.fogQ == 0) {
            TexturingPers.paintMiniTrianglePers_0(g3d, texture, y_start, y_end, x_start, wz_start, uz_start, vz_start, x_end, wz_end, uz_end, vz_end, dx_start, dwz_start, duz_start, dvz_start, dx_end, dwz_end, duz_end, dvz_end, dwz, duz, dvz, fogc, q);
            return;
        }
        int[] tex = texture.rImg.img;
        int lengthBIT = tex.length - 1;
        int widthBIT = texture.rImg.widthBIT;
        int[] rgb = g3d.display;
        int duz4 = duz * q;
        int dvz4 = dvz * q;
        int dwz4 = dwz * q;
        if (texture.getDrawMode() == 6) {
            if (DirectX7.fDist / 255 != 0) {
                sz2 = -TexturingPers.min(a.rz, b.rz, c.rz) / (DirectX7.fDist / 255);
            }
            if (sz2 > 255) {
                sz2 = 255;
            }
            if (sz2 < 0) {
                sz2 = 0;
            }
        }
        int isz2 = 255 - sz2;
        for (int y = y_start; y < y_end; ++y) {
            int col;
            int dv;
            int du;
            int length;
            int x1 = x_start;
            int x2 = x_end;
            int uz_a = uz_start;
            int uz_b = uz_end;
            int vz_a = vz_start;
            int vz_b = vz_end;
            int wz_a = wz_start;
            int wz_b = wz_end;
            long subtexel_a = x1 % 4096;
            long subtexel_b = x2 % 4096;
            uz_a = (int)((long)uz_a - ((long)duz * subtexel_a >> 12));
            vz_a = (int)((long)vz_a - ((long)dvz * subtexel_a >> 12));
            wz_a = (int)((long)wz_a - ((long)dwz * subtexel_a >> 12));
            uz_b = (int)((long)uz_b - ((long)duz * subtexel_b >> 12));
            vz_b = (int)((long)vz_b - ((long)dvz * subtexel_b >> 12));
            wz_b = (int)((long)wz_b - ((long)dwz * subtexel_b >> 12));
            x2 >>= 12;
            if ((x1 >>= 12) < 0) {
                uz_a -= duz * x1;
                vz_a -= dvz * x1;
                wz_a -= dwz * x1;
                x1 = 0;
            }
            if (x2 > g3d.width) {
                uz_b -= duz * (x2 -= g3d.width);
                vz_b -= dvz * x2;
                wz_b -= dwz * x2;
                x2 = g3d.width;
            }
            int tempI = y * g3d.width;
            if (wz_a == 0) {
                return;
            }
            int u = (int)(((long)uz_a << 12) / (long)wz_a);
            int v = (int)(((long)vz_a << 12) / (long)wz_a);
            for (length = (x2 += tempI) - (x1 += tempI); length >= q; length -= q) {
                du = ((int)(((long)(uz_a += duz4) << 12) / (long)(wz_a += dwz4)) - u) / q;
                dv = ((int)(((long)(vz_a += dvz4) << 12) / (long)wz_a) - v) / q;
                int i = x1 + q;
                while (x1 < i) {
                    col = tex[((v += dv) >>> 12 << widthBIT) + ((u += du) >>> 12) & lengthBIT];
                    if (col != 0) {
                        rgb[x1] = ((col & 0xFF00FF) * isz2 & 0xFF00FF00 | (col & 0xFF00) * isz2 & 0xFF0000) >>> 8;
                    }
                    ++x1;
                }
            }
            if (length > 0) {
                du = ((int)(((long)uz_b << 12) / (long)wz_b) - u) / length;
                dv = ((int)(((long)vz_b << 12) / (long)wz_b) - v) / length;
                while (x2 - x1 >= 2) {
                    col = tex[((v += dv) >>> 12 << widthBIT) + ((u += du) >>> 12) & lengthBIT];
                    if (col != 0) {
                        rgb[x1] = ((col & 0xFF00FF) * isz2 & 0xFF00FF00 | (col & 0xFF00) * isz2 & 0xFF0000) >>> 8;
                    }
                    if ((col = tex[((v += dv) >>> 12 << widthBIT) + ((u += du) >>> 12) & lengthBIT]) != 0) {
                        rgb[x1 + 1] = ((col & 0xFF00FF) * isz2 & 0xFF00FF00 | (col & 0xFF00) * isz2 & 0xFF0000) >>> 8;
                    }
                    x1 += 2;
                }
                while (x1 < x2) {
                    col = tex[((v += dv) >>> 12 << widthBIT) + ((u += du) >>> 12) & lengthBIT];
                    if (col != 0) {
                        rgb[x1] = ((col & 0xFF00FF) * isz2 & 0xFF00FF00 | (col & 0xFF00) * isz2 & 0xFF0000) >>> 8;
                    }
                    ++x1;
                }
            }
            x_start += dx_start;
            wz_start += dwz_start;
            uz_start += duz_start;
            vz_start += dvz_start;
            x_end += dx_end;
            wz_end += dwz_end;
            uz_end += duz_end;
            vz_end += dvz_end;
        }
    }

    static final void paintMiniTrianglePers_6_HQ(DirectX7 g3d, Texture texture, int y_start, int y_end, int x_start, int wz_start, int uz_start, int vz_start, int x_end, int wz_end, int uz_end, int vz_end, int dx_start, int dwz_start, int duz_start, int dvz_start, int dx_end, int dwz_end, int duz_end, int dvz_end, int dwz, int duz, int dvz, int fogc, int sz2, int q, Vertex a, Vertex b, Vertex c, int f_start, int f_end, int df_start, int df_end, int df) {
        if (q > 999 && texture.drawmode == 6) {
            TexturingFloors.paintFloor_6_HQ(g3d, texture, y_start, y_end, x_start, wz_start, uz_start, vz_start, x_end, wz_end, uz_end, vz_end, dx_start, dwz_start, duz_start, dvz_start, dx_end, dwz_end, duz_end, dvz_end, dwz, duz, dvz, a, b, c, f_start, f_end, df_start, df_end, df);
            return;
        }
        if (q > 999 && texture.drawmode == 9) {
            TexturingFloors.paintFloor_9_HQ(g3d, texture, y_start, y_end, x_start, wz_start, uz_start, vz_start, x_end, wz_end, uz_end, vz_end, dx_start, dwz_start, duz_start, dvz_start, dx_end, dwz_end, duz_end, dvz_end, dwz, duz, dvz, a, b, c, f_start, f_end, df_start, df_end, df);
            return;
        }
        int[] tex = texture.rImg.img;
        int lengthBIT = tex.length - 1;
        int widthBIT = texture.rImg.widthBIT;
        int[] rgb = g3d.display;
        int duz4 = duz * q;
        int dvz4 = dvz * q;
        int dwz4 = dwz * q;
        for (int y = y_start; y < y_end; ++y) {
            int isz2;
            int col;
            int dv;
            int du;
            int x1 = x_start;
            int x2 = x_end;
            int uz_a = uz_start;
            int uz_b = uz_end;
            int vz_a = vz_start;
            int vz_b = vz_end;
            int wz_a = wz_start;
            int wz_b = wz_end;
            int f = f_start;
            long subtexel_a = x1 % 4096;
            long subtexel_b = x2 % 4096;
            uz_a = (int)((long)uz_a - ((long)duz * subtexel_a >> 12));
            vz_a = (int)((long)vz_a - ((long)dvz * subtexel_a >> 12));
            wz_a = (int)((long)wz_a - ((long)dwz * subtexel_a >> 12));
            uz_b = (int)((long)uz_b - ((long)duz * subtexel_b >> 12));
            vz_b = (int)((long)vz_b - ((long)dvz * subtexel_b >> 12));
            wz_b = (int)((long)wz_b - ((long)dwz * subtexel_b >> 12));
            x2 >>= 12;
            if ((x1 >>= 12) < 0) {
                uz_a -= duz * x1;
                vz_a -= dvz * x1;
                wz_a -= dwz * x1;
                f -= df * x1;
                x1 = 0;
            }
            if (x2 > g3d.width) {
                uz_b -= duz * (x2 -= g3d.width);
                vz_b -= dvz * x2;
                wz_b -= dwz * x2;
                x2 = g3d.width;
            }
            int tempI = y * g3d.width;
            int length = (x2 += tempI) - (x1 += tempI);
            if (wz_a == 0) {
                return;
            }
            int u = (int)(((long)uz_a << 12) / (long)wz_a);
            int v = (int)(((long)vz_a << 12) / (long)wz_a);
            if (f < 0) {
                f = 0;
            }
            int df2 = df;
            if (f + df * length < 0) {
                df2 = -f / length;
            }
            while (length >= q) {
                du = ((int)(((long)(uz_a += duz4) << 12) / (long)(wz_a += dwz4)) - u) / q;
                dv = ((int)(((long)(vz_a += dvz4) << 12) / (long)wz_a) - v) / q;
                int i = x1 + q;
                while (i - x1 >= 3) {
                    col = tex[((v += dv) >>> 12 << widthBIT) + ((u += du) >>> 12) & lengthBIT];
                    if (col != 0) {
                        isz2 = (f += df2) >>> 12;
                        rgb[x1] = ((col & 0xFF00FF) * isz2 & 0xFF00FF00 | (col & 0xFF00) * isz2 & 0xFF0000) >>> 8;
                    }
                    if ((col = tex[((v += dv) >>> 12 << widthBIT) + ((u += du) >>> 12) & lengthBIT]) != 0) {
                        isz2 = (f += df2) >>> 12;
                        rgb[x1 + 1] = ((col & 0xFF00FF) * isz2 & 0xFF00FF00 | (col & 0xFF00) * isz2 & 0xFF0000) >>> 8;
                    }
                    if ((col = tex[((v += dv) >>> 12 << widthBIT) + ((u += du) >>> 12) & lengthBIT]) != 0) {
                        isz2 = (f += df2) >>> 12;
                        rgb[x1 + 2] = ((col & 0xFF00FF) * isz2 & 0xFF00FF00 | (col & 0xFF00) * isz2 & 0xFF0000) >>> 8;
                    }
                    x1 += 3;
                }
                length -= q;
            }
            if (length > 0) {
                du = ((int)(((long)uz_b << 12) / (long)wz_b) - u) / length;
                dv = ((int)(((long)vz_b << 12) / (long)wz_b) - v) / length;
                while (x2 - x1 >= 2) {
                    col = tex[((v += dv) >>> 12 << widthBIT) + ((u += du) >>> 12) & lengthBIT];
                    if (col != 0) {
                        isz2 = (f += df2) >>> 12;
                        rgb[x1] = ((col & 0xFF00FF) * isz2 & 0xFF00FF00 | (col & 0xFF00) * isz2 & 0xFF0000) >>> 8;
                    }
                    if ((col = tex[((v += dv) >>> 12 << widthBIT) + ((u += du) >>> 12) & lengthBIT]) != 0) {
                        isz2 = (f += df2) >>> 12;
                        rgb[x1 + 1] = ((col & 0xFF00FF) * isz2 & 0xFF00FF00 | (col & 0xFF00) * isz2 & 0xFF0000) >>> 8;
                    }
                    x1 += 2;
                }
                while (x1 < x2) {
                    col = tex[((v += dv) >>> 12 << widthBIT) + ((u += du) >>> 12) & lengthBIT];
                    if (col != 0) {
                        isz2 = (f += df2) >>> 12;
                        rgb[x1] = ((col & 0xFF00FF) * isz2 & 0xFF00FF00 | (col & 0xFF00) * isz2 & 0xFF0000) >>> 8;
                    }
                    ++x1;
                }
            }
            x_start += dx_start;
            wz_start += dwz_start;
            uz_start += duz_start;
            vz_start += dvz_start;
            f_start += df_start;
            x_end += dx_end;
            wz_end += dwz_end;
            uz_end += duz_end;
            vz_end += dvz_end;
        }
    }

    static final void paintMiniTrianglePers_13(DirectX7 g3d, Texture texture, int y_start, int y_end, int x_start, int wz_start, int uz_start, int vz_start, int x_end, int wz_end, int uz_end, int vz_end, int dx_start, int dwz_start, int duz_start, int dvz_start, int dx_end, int dwz_end, int duz_end, int dvz_end, int dwz, int duz, int dvz, int fogc, int sz2, int q, Vertex a, Vertex b, Vertex c, int r_start, int r_end, int dr_start, int dr_end, int dr, int g_start, int g_end, int dg_start, int dg_end, int dg, int b_start, int b_end, int db_start, int db_end, int db) {
        if (Main.fogQ == 0) {
            TexturingPers.paintMiniTrianglePers_0(g3d, texture, y_start, y_end, x_start, wz_start, uz_start, vz_start, x_end, wz_end, uz_end, vz_end, dx_start, dwz_start, duz_start, dvz_start, dx_end, dwz_end, duz_end, dvz_end, dwz, duz, dvz, fogc, q);
            return;
        }
        if (q > 999 && texture.drawmode == 13) {
            TexturingFloors.paintFloor_13(g3d, texture, y_start, y_end, x_start, wz_start, uz_start, vz_start, x_end, wz_end, uz_end, vz_end, dx_start, dwz_start, duz_start, dvz_start, dx_end, dwz_end, duz_end, dvz_end, dwz, duz, dvz, a, b, c, r_start, r_end, dr_start, dr_end, dr, g_start, g_end, dg_start, dg_end, dg, b_start, b_end, db_start, db_end, db);
            return;
        }
        int[] tex = texture.rImg.img;
        int lengthBIT = tex.length - 1;
        int widthBIT = texture.rImg.widthBIT;
        int[] rgb = g3d.display;
        int duz4 = duz * q;
        int dvz4 = dvz * q;
        int dwz4 = dwz * q;
        int FPq = 4096 / q;
        for (int y = y_start; y < y_end; ++y) {
            int col;
            int dv;
            int du;
            int x1 = x_start;
            int x2 = x_end;
            int uz_a = uz_start;
            int uz_b = uz_end;
            int vz_a = vz_start;
            int vz_b = vz_end;
            int wz_a = wz_start;
            int wz_b = wz_end;
            int rC = r_start;
            int gC = g_start;
            int bC = b_start;
            long subtexel_a = x1 % 4096;
            long subtexel_b = x2 % 4096;
            uz_a = (int)((long)uz_a - ((long)duz * subtexel_a >> 12));
            vz_a = (int)((long)vz_a - ((long)dvz * subtexel_a >> 12));
            wz_a = (int)((long)wz_a - ((long)dwz * subtexel_a >> 12));
            uz_b = (int)((long)uz_b - ((long)duz * subtexel_b >> 12));
            vz_b = (int)((long)vz_b - ((long)dvz * subtexel_b >> 12));
            wz_b = (int)((long)wz_b - ((long)dwz * subtexel_b >> 12));
            x2 >>= 12;
            if ((x1 >>= 12) < 0) {
                uz_a -= duz * x1;
                vz_a -= dvz * x1;
                wz_a -= dwz * x1;
                rC -= dr * x1;
                gC -= dg * x1;
                bC -= db * x1;
                x1 = 0;
            }
            if (x2 > g3d.width) {
                uz_b -= duz * (x2 -= g3d.width);
                vz_b -= dvz * x2;
                wz_b -= dwz * x2;
                x2 = g3d.width;
            }
            int tempI = y * g3d.width;
            int length = (x2 += tempI) - (x1 += tempI);
            if (rC < 0) {
                rC = 0;
            }
            if (gC < 0) {
                gC = 0;
            }
            if (bC < 0) {
                bC = 0;
            }
            int dr2 = dr;
            int dg2 = dg;
            int db2 = db;
            if (rC + dr * length < 0) {
                dr2 = -rC / length;
            }
            if (gC + dg * length < 0) {
                dg2 = -gC / length;
            }
            if (bC + db * length < 0) {
                db2 = -bC / length;
            }
            if (wz_a == 0) {
                return;
            }
            int u = (int)(((long)uz_a << 12) / (long)wz_a);
            int v = (int)(((long)vz_a << 12) / (long)wz_a);
            while (length >= q) {
                du = ((int)(((long)(uz_a += duz4) << 12) / (long)(wz_a += dwz4)) - u) * FPq >> 12;
                dv = ((int)(((long)(vz_a += dvz4) << 12) / (long)wz_a) - v) * FPq >> 12;
                int i = x1 + q;
                while (i - x1 >= 2) {
                    col = tex[((v += dv) >>> 12 << widthBIT) + ((u += du) >>> 12) & lengthBIT];
                    if (col != 0) {
                        rgb[x1] = ((col & 0xFF0000) * ((rC += dr2) >>> 12) & 0xFF000000 | (col & 0xFF00) * ((gC += dg2) >>> 12) & 0xFF0000 | (col & 0xFF) * ((bC += db2) >>> 12)) >>> 8;
                    }
                    if ((col = tex[((v += dv) >>> 12 << widthBIT) + ((u += du) >>> 12) & lengthBIT]) != 0) {
                        rgb[x1 + 1] = ((col & 0xFF0000) * ((rC += dr2) >>> 12) & 0xFF000000 | (col & 0xFF00) * ((gC += dg2) >>> 12) & 0xFF0000 | (col & 0xFF) * ((bC += db2) >>> 12)) >>> 8;
                    }
                    x1 += 2;
                }
                length -= q;
            }
            if (length > 0) {
                du = ((int)(((long)uz_b << 12) / (long)wz_b) - u) / length;
                dv = ((int)(((long)vz_b << 12) / (long)wz_b) - v) / length;
                while (x1 < x2) {
                    col = tex[((v += dv) >>> 12 << widthBIT) + ((u += du) >>> 12) & lengthBIT];
                    if (col != 0) {
                        rgb[x1] = ((col & 0xFF0000) * ((rC += dr2) >>> 12) & 0xFF000000 | (col & 0xFF00) * ((gC += dg2) >>> 12) & 0xFF0000 | (col & 0xFF) * ((bC += db2) >>> 12)) >>> 8;
                    }
                    ++x1;
                }
            }
            x_start += dx_start;
            wz_start += dwz_start;
            uz_start += duz_start;
            vz_start += dvz_start;
            r_start += dr_start;
            g_start += dg_start;
            b_start += db_start;
            x_end += dx_end;
            wz_end += dwz_end;
            uz_end += duz_end;
            vz_end += dvz_end;
        }
    }

    static final void paintPers_glass(DirectX7 g3d, Texture texture, int y_start, int y_end, int x_start, int wz_start, int uz_start, int vz_start, int x_end, int wz_end, int uz_end, int vz_end, int dx_start, int dwz_start, int duz_start, int dvz_start, int dx_end, int dwz_end, int duz_end, int dvz_end, int dwz, int duz, int dvz, int fogc, int sz2) {
        int[] tex = texture.rImg.img;
        int lengthBIT = tex.length - 1;
        int widthBIT = texture.rImg.widthBIT;
        int[] rgb = g3d.display;
        int g3dlen = g3d.display.length - 1;
        int w = g3d.width;
        int scale = 64;
        scale = scale * (g3d.getHeight() + g3d.getWidth()) / 560;
        int duz4 = duz * sz2;
        int dvz4 = dvz * sz2;
        int dwz4 = dwz * sz2;
        for (int y = y_start; y < y_end; ++y) {
            int coord;
            int col;
            int dv;
            int du;
            int length;
            int wz_b;
            int wz_a;
            int vz_b;
            int vz_a;
            int uz_b;
            int uz_a;
            int x2;
            int x1;
            if (x_start > x_end) {
                x1 = x_end;
                x2 = x_start;
                uz_a = uz_end;
                uz_b = uz_start;
                vz_a = vz_end;
                vz_b = vz_start;
                wz_a = wz_end;
                wz_b = wz_start;
            } else {
                x1 = x_start;
                x2 = x_end;
                uz_a = uz_start;
                uz_b = uz_end;
                vz_a = vz_start;
                vz_b = vz_end;
                wz_a = wz_start;
                wz_b = wz_end;
            }
            long subtexel_a = x1 % 4096;
            long subtexel_b = x2 % 4096;
            uz_a = (int)((long)uz_a - ((long)duz * subtexel_a >> 12));
            vz_a = (int)((long)vz_a - ((long)dvz * subtexel_a >> 12));
            wz_a = (int)((long)wz_a - ((long)dwz * subtexel_a >> 12));
            uz_b = (int)((long)uz_b - ((long)duz * subtexel_b >> 12));
            vz_b = (int)((long)vz_b - ((long)dvz * subtexel_b >> 12));
            wz_b = (int)((long)wz_b - ((long)dwz * subtexel_b >> 12));
            x2 >>= 12;
            if ((x1 >>= 12) < 0) {
                uz_a -= duz * x1;
                vz_a -= dvz * x1;
                wz_a -= dwz * x1;
                x1 = 0;
            }
            if (x2 > g3d.width) {
                uz_b -= duz * (x2 -= g3d.width);
                vz_b -= dvz * x2;
                wz_b -= dwz * x2;
                x2 = g3d.width;
            }
            int tempI = y * g3d.width;
            if (wz_a == 0) {
                return;
            }
            int u = (int)(((long)uz_a << 12) / (long)wz_a);
            int v = (int)(((long)vz_a << 12) / (long)wz_a);
            for (length = (x2 += tempI) - (x1 += tempI); length >= sz2; length -= sz2) {
                du = ((int)(((long)(uz_a += duz4) << 12) / (long)(wz_a += dwz4)) - u) / sz2;
                dv = ((int)(((long)(vz_a += dvz4) << 12) / (long)wz_a) - v) / sz2;
                int i = x1 + sz2;
                while (x1 < i) {
                    col = tex[((v += dv) >>> 12 << widthBIT) + ((u += du) >>> 12) & lengthBIT];
                    coord = (((col & 0xFF0000) - 0x800000) * scale >> 24) + (((col & 0xFF00) - 32768) * scale >> 16) * w + x1;
                    rgb[x1] = coord < 0 ? rgb[0] : (coord > g3dlen ? rgb[g3dlen] : rgb[coord]);
                    ++x1;
                }
            }
            if (length > 0) {
                int u_2 = (int)(((long)uz_b << 12) / (long)wz_b);
                int v_2 = (int)(((long)vz_b << 12) / (long)wz_b);
                du = (u_2 - u) / length;
                dv = (v_2 - v) / length;
                while (x1 < x2) {
                    col = tex[((v += dv) >>> 12 << widthBIT) + ((u += du) >>> 12) & lengthBIT];
                    coord = (((col & 0xFF0000) - 0x800000) * scale >> 24) + (((col & 0xFF00) - 32768) * scale >> 16) * w + x1;
                    rgb[x1] = coord < 0 ? rgb[0] : (coord > g3dlen ? rgb[g3dlen] : rgb[coord]);
                    ++x1;
                }
            }
            x_start += dx_start;
            wz_start += dwz_start;
            uz_start += duz_start;
            vz_start += dvz_start;
            x_end += dx_end;
            wz_end += dwz_end;
            uz_end += duz_end;
            vz_end += dvz_end;
        }
    }

    static final int min(int a, int b, int c) {
        if (a == b || b == c) {
            return TexturingPers.min(a, c);
        }
        if (a == c) {
            return TexturingPers.min(a, b);
        }
        if (a < b && a < c) {
            return a;
        }
        if (b < a && b < c) {
            return b;
        }
        return c;
    }

    private static final int min(int a, int b) {
        if (a < b) {
            return a;
        }
        return b;
    }

    private static final int max(int a, int b) {
        if (a > b) {
            return a;
        }
        return b;
    }
}

