/*
 * Decompiled with CFR 0.152.
 */
package com.Rendering;

import com.Rendering.Graphics3D;
import com.Rendering.Texture;
import com.Rendering.Vertex;
import com.misc.Main;

public class Texturing {
    public static final int fp = 12;
    public static final int FP = 4096;

    public static final void paintAffine(Graphics3D g3d, Texture texture, Vertex a, int au, int av, Vertex b, int bu, int bv, Vertex c, int cu, int cv, int fogc, byte fog, int sz2) {
        if (!texture.alphaMixing && texture.drawmode == 4) {
            fog = 0;
        }
        au = au * texture.rImg.w >> 8;
        bu = bu * texture.rImg.w >> 8;
        cu = cu * texture.rImg.w >> 8;
        av = av * texture.rImg.h >> 8;
        bv = bv * texture.rImg.h >> 8;
        cv = cv * texture.rImg.h >> 8;
        switch (fog) {
            case 0: {
                Texturing.paintAffine_0(g3d, texture, a, au, av, b, bu, bv, c, cu, cv, fogc, sz2);
                break;
            }
            case 1: {
                if (Main.fogQ > 0) {
                    Texturing.paintAffine_1(g3d, texture, a, au, av, b, bu, bv, c, cu, cv, fogc, sz2);
                    break;
                }
                Texturing.paintAffine_0(g3d, texture, a, au, av, b, bu, bv, c, cu, cv, fogc, sz2);
                break;
            }
            case 2: {
                Texturing.paintAffine_2(g3d, texture, a, au, av, b, bu, bv, c, cu, cv, fogc, sz2);
                break;
            }
            case 3: {
                if (Main.fogQ > 0) {
                    Texturing.paintAffine_3(g3d, texture, a, au, av, b, bu, bv, c, cu, cv, fogc, sz2);
                    break;
                }
                Texturing.paintAffine_0(g3d, texture, a, au, av, b, bu, bv, c, cu, cv, fogc, sz2);
                break;
            }
            case 4: {
                Texturing.paintAffine_4(g3d, texture, a, au, av, b, bu, bv, c, cu, cv, fogc, sz2);
                break;
            }
            case 5: {
                Texturing.paintAffine_5(g3d, texture, a, au, av, b, bu, bv, c, cu, cv, fogc, sz2);
                break;
            }
            case 6: {
                if (Main.fogQ > 0) {
                    Texturing.paintAffine_5(g3d, texture, a, au, av, b, bu, bv, c, cu, cv, fogc, sz2);
                    break;
                }
                Texturing.paintAffine_0(g3d, texture, a, au, av, b, bu, bv, c, cu, cv, fogc, sz2);
                break;
            }
            case 7: {
                Texturing.paint_glass(g3d, texture, a, au, av, b, bu, bv, c, cu, cv, fogc, sz2);
                break;
            }
            case 8: {
                Texturing.paintAffine_8(g3d, texture, a, au, av, b, bu, bv, c, cu, cv, fogc, sz2);
            }
        }
    }

    static final void paintAffine_0(Graphics3D g3d, Texture texture, Vertex a, int au, int av, Vertex b, int bu, int bv, Vertex c, int cu, int cv, int fogc, int sz2) {
        boolean x2pixel;
        int tb;
        Vertex t;
        if (b.sy < a.sy) {
            t = a;
            a = b;
            b = t;
            tb = au;
            au = bu;
            bu = tb;
            tb = av;
            av = bv;
            bv = tb;
        }
        if (c.sy < a.sy) {
            t = c;
            c = a;
            a = t;
            tb = cu;
            cu = au;
            au = tb;
            tb = cv;
            cv = av;
            av = tb;
        }
        if (c.sy < b.sy) {
            t = b;
            b = c;
            c = t;
            tb = bu;
            bu = cu;
            cu = tb;
            tb = bv;
            bv = cv;
            cv = tb;
        }
        if (a.sy == c.sy) {
            return;
        }
        int[] tex = texture.rImg.img;
        int lengthBIT = tex.length - 1;
        int widthBIT = texture.widthBIT;
        int[] rgb = g3d.display;
        int tempI = c.sy - a.sy;
        int dx_start = (c.sx - a.sx << 12) / tempI;
        int du_start = (cu - au << 12) / tempI;
        int dv_start = (cv - av << 12) / tempI;
        int dx_end = 0;
        int du_end = 0;
        int dv_end = 0;
        if (b.sy != a.sy) {
            tempI = b.sy - a.sy;
            dx_end = (b.sx - a.sx << 12) / tempI;
            du_end = (bu - au << 12) / tempI;
            dv_end = (bv - av << 12) / tempI;
        }
        tempI = b.sy - a.sy;
        int x_start = (a.sx << 12) + dx_start * tempI;
        int u_start = (au << 12) + du_start * tempI;
        int v_start = (av << 12) + dv_start * tempI;
        int x_end = b.sx << 12;
        int u_end = bu << 12;
        int v_end = bv << 12;
        tempI = x_start - x_end >> 12;
        if (tempI == 0) {
            return;
        }
        int du = (u_start - u_end) / tempI;
        int dv = (v_start - v_end) / tempI;
        x_end = x_start = a.sx << 12;
        u_end = u_start = au << 12;
        v_end = v_start = av << 12;
        int y_start = a.sy;
        int y_end = c.sy < g3d.height ? c.sy : g3d.height;
        boolean bl = x2pixel = Math.abs(du) + Math.abs(dv) < 2048 && Math.abs(du) < 2048 && Math.abs(dv) < 2048 && Main.pixelsQ <= 1;
        if (x2pixel) {
            Texturing.paintAffine_0_2x(x_start, x_end, y_start, y_end, u_start, u_end, v_start, v_end, dx_start, dx_end, du_start, du_end, dv_start, dv_end, a, b, c, au, av, bu, bv, cu, cv, du, dv, g3d, texture);
            return;
        }
        while (y_start < y_end) {
            if (y_start == b.sy) {
                if (c.sy == b.sy) {
                    return;
                }
                tempI = b.sy - a.sy;
                x_start = (a.sx << 12) + dx_start * tempI;
                u_start = (au << 12) + du_start * tempI;
                v_start = (av << 12) + dv_start * tempI;
                x_end = b.sx << 12;
                u_end = bu << 12;
                v_end = bv << 12;
                tempI = c.sy - b.sy;
                dx_end = (c.sx - b.sx << 12) / tempI;
                du_end = (cu - bu << 12) / tempI;
                dv_end = (cv - bv << 12) / tempI;
            }
            if (y_start >= 0) {
                int x2;
                int v;
                int u;
                int x1;
                if (x_start > x_end) {
                    tempI = x_end % 4096;
                    x1 = x_end >> 12;
                    u = u_end;
                    v = v_end;
                    x2 = x_start >> 12;
                } else {
                    tempI = x_start % 4096;
                    x1 = x_start >> 12;
                    u = u_start;
                    v = v_start;
                    x2 = x_end >> 12;
                }
                if (x1 < 0) {
                    u -= du * x1;
                    v -= dv * x1;
                    x1 = 0;
                }
                if (x2 > g3d.width) {
                    x2 = g3d.width;
                }
                tempI = g3d.width * y_start;
                x1 += tempI;
                x2 += tempI;
                u -= du;
                v -= dv;
                while (x1 < x2) {
                    int col = tex[((v += dv) >> 12 << widthBIT) + ((u += du) >> 12) & lengthBIT];
                    if (col != 0) {
                        rgb[x1] = col;
                    }
                    ++x1;
                }
            }
            ++y_start;
            x_start += dx_start;
            u_start += du_start;
            v_start += dv_start;
            x_end += dx_end;
            u_end += du_end;
            v_end += dv_end;
        }
    }

    public static final void paintQuad(Graphics3D g3d, Texture texture, Vertex a, int au, int av, Vertex b, int bu, int bv, Vertex c, int cu, int cv, Vertex d, int du, int dv) {
        int y_end;
        int v_end;
        int u_end;
        int x_end;
        int v_start;
        int u_start;
        int x_start;
        int dv_start;
        int du_start;
        int dx_start;
        int tempI;
        int tb;
        Vertex t;
        if (b.sy < a.sy) {
            t = a;
            a = b;
            b = t;
            tb = au;
            au = bu;
            bu = tb;
            tb = av;
            av = bv;
            bv = tb;
        }
        if (c.sy < a.sy) {
            t = c;
            c = a;
            a = t;
            tb = cu;
            cu = au;
            au = tb;
            tb = cv;
            cv = av;
            av = tb;
        }
        if (d.sy < a.sy) {
            t = d;
            d = a;
            a = t;
            tb = du;
            du = au;
            au = tb;
            tb = dv;
            dv = av;
            av = tb;
        }
        if (d.sy < b.sy) {
            t = d;
            d = b;
            b = t;
            tb = du;
            du = bu;
            bu = tb;
            tb = dv;
            dv = bv;
            bv = tb;
        }
        if (d.sy < c.sy) {
            t = d;
            d = c;
            c = t;
            tb = du;
            du = cu;
            cu = tb;
            tb = dv;
            dv = cv;
            cv = tb;
        }
        if (d.sy < a.sy) {
            t = d;
            d = a;
            a = t;
            tb = du;
            du = au;
            au = tb;
            tb = dv;
            dv = av;
            av = tb;
        }
        if (c.sy < b.sy) {
            t = b;
            b = c;
            c = t;
            tb = bu;
            bu = cu;
            cu = tb;
            tb = bv;
            bv = cv;
            cv = tb;
        }
        int[] tex = texture.rImg.img;
        int lengthBIT = tex.length - 1;
        int widthBIT = texture.widthBIT;
        int[] rgb = g3d.display;
        if (b.sx > a.sx) {
            if (a.sy == b.sy) {
                return;
            }
            tempI = b.sy - a.sy;
            dx_start = (b.sx - a.sx << 12) / tempI;
            du_start = (bu - au << 12) / tempI;
            dv_start = (bv - av << 12) / tempI;
        } else if (c.sx > a.sx) {
            if (a.sy == b.sy) {
                return;
            }
            tempI = b.sy - a.sy;
            dx_start = (b.sx - a.sx << 12) / tempI;
            du_start = (bu - au << 12) / tempI;
            dv_start = (bv - av << 12) / tempI;
        } else {
            if (a.sy == d.sy) {
                return;
            }
            tempI = d.sy - a.sy;
            dx_start = (d.sx - a.sx << 12) / tempI;
            du_start = (du - au << 12) / tempI;
            dv_start = (dv - av << 12) / tempI;
        }
        int dx_end = 0;
        int du_end = 0;
        int dv_end = 0;
        if (a.sx > b.sx) {
            tempI = b.sy - a.sy;
            if (tempI != 0) {
                dx_end = (b.sx - a.sx << 12) / tempI;
                du_end = (bu - au << 12) / tempI;
                dv_end = (bv - av << 12) / tempI;
            }
            x_start = (a.sx << 12) + dx_start * tempI;
            u_start = (au << 12) + du_start * tempI;
            v_start = (av << 12) + dv_start * tempI;
            x_end = b.sx << 12;
            u_end = bu << 12;
            v_end = bv << 12;
        } else if (a.sx > c.sx) {
            tempI = c.sy - a.sy;
            if (tempI != 0) {
                dx_end = (c.sx - a.sx << 12) / tempI;
                du_end = (cu - au << 12) / tempI;
                dv_end = (cv - av << 12) / tempI;
            }
            x_start = (a.sx << 12) + dx_start * tempI;
            u_start = (au << 12) + du_start * tempI;
            v_start = (av << 12) + dv_start * tempI;
            x_end = c.sx << 12;
            u_end = cu << 12;
            v_end = cv << 12;
        } else {
            tempI = d.sy - a.sy;
            if (tempI != 0) {
                dx_end = (d.sx - a.sx << 12) / tempI;
                du_end = (du - au << 12) / tempI;
                dv_end = (dv - av << 12) / tempI;
            }
            x_start = (a.sx << 12) + dx_start * tempI;
            u_start = (au << 12) + du_start * tempI;
            v_start = (av << 12) + dv_start * tempI;
            x_end = d.sx << 12;
            u_end = du << 12;
            v_end = dv << 12;
        }
        tempI = x_start - x_end >> 12;
        if (tempI == 0) {
            return;
        }
        int deltau = (u_start - u_end) / tempI;
        int deltav = (v_start - v_end) / tempI;
        x_end = x_start = a.sx << 12;
        u_end = u_start = au << 12;
        v_end = v_start = av << 12;
        int y_start = a.sy;
        int n = y_end = d.sy < g3d.height ? d.sy : g3d.height;
        while (y_start < y_end) {
            if (y_start == b.sy) {
                if (b.sx > a.sx) {
                    tempI = d.sy - b.sy;
                    if (c.sx > a.sx) {
                        tempI = c.sy - b.sy;
                    }
                    x_start = (b.sx << 12) + dx_start * tempI;
                    u_start = (bu << 12) + du_start * tempI;
                    v_start = (bv << 12) + dv_start * tempI;
                    if (tempI == 0) {
                        dx_start = 0;
                        du_start = 0;
                        dv_start = 0;
                    } else if (c.sx > a.sx) {
                        dx_start = (c.sx - b.sx << 12) / tempI;
                        du_start = (cu - bu << 12) / tempI;
                        dv_start = (cv - bv << 12) / tempI;
                    } else {
                        dx_start = (d.sx - b.sx << 12) / tempI;
                        du_start = (du - bu << 12) / tempI;
                        dv_start = (dv - bv << 12) / tempI;
                    }
                } else {
                    x_end = b.sx << 12;
                    u_end = bu << 12;
                    v_end = bv << 12;
                    tempI = d.sy - b.sy;
                    if (d.sx < a.sx) {
                        tempI = c.sy - b.sy;
                    }
                    if (tempI == 0) {
                        dx_end = 0;
                        du_end = 0;
                        dv_end = 0;
                    } else if (c.sx < a.sx) {
                        dx_end = (c.sx - b.sx << 12) / tempI;
                        du_end = (cu - bu << 12) / tempI;
                        dv_end = (cv - bv << 12) / tempI;
                    } else {
                        dx_end = (d.sx - b.sx << 12) / tempI;
                        du_end = (du - bu << 12) / tempI;
                        dv_end = (dv - bv << 12) / tempI;
                    }
                }
                tempI = x_start - x_end >> 12;
                if (tempI != 0) {
                    deltau = (u_start - u_end) / tempI;
                    deltav = (v_start - v_end) / tempI;
                }
            }
            if (y_start == c.sy) {
                if (c.sx > a.sx) {
                    tempI = d.sy - c.sy;
                    x_start = (c.sx << 12) + dx_start * tempI;
                    u_start = (cu << 12) + du_start * tempI;
                    v_start = (cv << 12) + dv_start * tempI;
                    if (tempI == 0) {
                        dx_start = 0;
                        du_start = 0;
                        dv_start = 0;
                    } else {
                        dx_start = (d.sx - c.sx << 12) / tempI;
                        du_start = (du - cu << 12) / tempI;
                        dv_start = (dv - cv << 12) / tempI;
                    }
                } else {
                    x_end = c.sx << 12;
                    u_end = cu << 12;
                    v_end = cv << 12;
                    tempI = d.sy - c.sy;
                    if (tempI == 0) {
                        dx_end = 0;
                        du_end = 0;
                        dv_end = 0;
                    } else {
                        dx_end = (d.sx - c.sx << 12) / tempI;
                        du_end = (du - cu << 12) / tempI;
                        dv_end = (dv - cv << 12) / tempI;
                    }
                }
                tempI = x_start - x_end >> 12;
                if (tempI != 0) {
                    deltau = (u_start - u_end) / tempI;
                    deltav = (v_start - v_end) / tempI;
                }
            }
            if (y_start >= 0) {
                int x2;
                int v;
                int u;
                int x1;
                if (x_start > x_end) {
                    tempI = x_end % 4096;
                    x1 = x_end >> 12;
                    u = u_end;
                    v = v_end;
                    x2 = x_start >> 12;
                } else {
                    tempI = x_start % 4096;
                    x1 = x_start >> 12;
                    u = u_start;
                    v = v_start;
                    x2 = x_end >> 12;
                }
                if (x1 < 0) {
                    u -= du * x1;
                    v -= dv * x1;
                    x1 = 0;
                }
                if (x2 > g3d.width) {
                    x2 = g3d.width;
                }
                tempI = g3d.width * y_start;
                x1 += tempI;
                x2 += tempI;
                u -= deltau;
                v -= deltav;
                while (x1 < x2) {
                    int col = tex[((v += deltav) >> 12 << widthBIT) + ((u += deltau) >> 12) & lengthBIT];
                    if (col != 0) {
                        rgb[x1] = col;
                    }
                    ++x1;
                }
            }
            ++y_start;
            x_start += dx_start;
            u_start += du_start;
            v_start += dv_start;
            x_end += dx_end;
            u_end += du_end;
            v_end += dv_end;
        }
    }

    static final void paintAffine_0_2x(int x_start, int x_end, int y_start, int y_end, int u_start, int u_end, int v_start, int v_end, int dx_start, int dx_end, int du_start, int du_end, int dv_start, int dv_end, Vertex a, Vertex b, Vertex c, int au, int av, int bu, int bv, int cu, int cv, int du, int dv, Graphics3D g3d, Texture texture) {
        int[] tex = texture.rImg.img;
        int lengthBIT = tex.length - 1;
        int widthBIT = texture.widthBIT;
        int[] rgb = g3d.display;
        while (y_start < y_end) {
            int tempI;
            if (y_start == b.sy) {
                if (c.sy == b.sy) {
                    return;
                }
                tempI = b.sy - a.sy;
                x_start = (a.sx << 12) + dx_start * tempI;
                u_start = (au << 12) + du_start * tempI;
                v_start = (av << 12) + dv_start * tempI;
                x_end = b.sx << 12;
                u_end = bu << 12;
                v_end = bv << 12;
                tempI = c.sy - b.sy;
                dx_end = (c.sx - b.sx << 12) / tempI;
                du_end = (cu - bu << 12) / tempI;
                dv_end = (cv - bv << 12) / tempI;
            }
            if (y_start >= 0) {
                int col;
                int x2;
                int v;
                int u;
                int x1;
                if (x_start > x_end) {
                    tempI = x_end % 4096;
                    x1 = x_end >> 12;
                    u = u_end;
                    v = v_end;
                    x2 = x_start >> 12;
                } else {
                    tempI = x_start % 4096;
                    x1 = x_start >> 12;
                    u = u_start;
                    v = v_start;
                    x2 = x_end >> 12;
                }
                if (x1 < 0) {
                    u -= du * x1;
                    v -= dv * x1;
                    x1 = 0;
                }
                if (x2 > g3d.width) {
                    x2 = g3d.width;
                }
                tempI = g3d.width * y_start;
                x1 += tempI;
                x2 += tempI;
                u -= du;
                v -= dv;
                while (x2 - x1 >= 2) {
                    col = tex[((v += dv) >> 12 << widthBIT) + ((u += du) >> 12) & lengthBIT];
                    if (col != 0) {
                        rgb[x1] = col;
                        rgb[x1 + 1] = col;
                    }
                    u += du;
                    v += dv;
                    x1 += 2;
                }
                while (x1 < x2) {
                    col = tex[((v += dv) >> 12 << widthBIT) + ((u += du) >> 12) & lengthBIT];
                    if (col != 0) {
                        rgb[x1] = col;
                    }
                    ++x1;
                }
            }
            ++y_start;
            x_start += dx_start;
            u_start += du_start;
            v_start += dv_start;
            x_end += dx_end;
            u_end += du_end;
            v_end += dv_end;
        }
    }

    static final void paintAffine_1(Graphics3D g3d, Texture texture, Vertex a, int au, int av, Vertex b, int bu, int bv, Vertex c, int cu, int cv, int fogc, int sz2) {
        int y_end;
        int tb;
        Vertex t;
        int colf = sz2 & 0xFEFEFE;
        if (b.sy < a.sy) {
            t = a;
            a = b;
            b = t;
            tb = au;
            au = bu;
            bu = tb;
            tb = av;
            av = bv;
            bv = tb;
        }
        if (c.sy < a.sy) {
            t = c;
            c = a;
            a = t;
            tb = cu;
            cu = au;
            au = tb;
            tb = cv;
            cv = av;
            av = tb;
        }
        if (c.sy < b.sy) {
            t = b;
            b = c;
            c = t;
            tb = bu;
            bu = cu;
            cu = tb;
            tb = bv;
            bv = cv;
            cv = tb;
        }
        if (a.sy == c.sy) {
            return;
        }
        int[] tex = texture.rImg.img;
        int lengthBIT = tex.length - 1;
        int widthBIT = texture.widthBIT;
        int[] rgb = g3d.display;
        int tempI = c.sy - a.sy;
        int dx_start = (c.sx - a.sx << 12) / tempI;
        int du_start = (cu - au << 12) / tempI;
        int dv_start = (cv - av << 12) / tempI;
        int dx_end = 0;
        int du_end = 0;
        int dv_end = 0;
        if (b.sy != a.sy) {
            tempI = b.sy - a.sy;
            dx_end = (b.sx - a.sx << 12) / tempI;
            du_end = (bu - au << 12) / tempI;
            dv_end = (bv - av << 12) / tempI;
        }
        tempI = b.sy - a.sy;
        int x_start = (a.sx << 12) + dx_start * tempI;
        int u_start = (au << 12) + du_start * tempI;
        int v_start = (av << 12) + dv_start * tempI;
        int x_end = b.sx << 12;
        int u_end = bu << 12;
        int v_end = bv << 12;
        tempI = x_start - x_end >> 12;
        if (tempI == 0) {
            return;
        }
        int du = (u_start - u_end) / tempI;
        int dv = (v_start - v_end) / tempI;
        x_end = x_start = a.sx << 12;
        u_end = u_start = au << 12;
        v_end = v_start = av << 12;
        int y_start = a.sy;
        int n = y_end = c.sy < g3d.height ? c.sy : g3d.height;
        while (y_start < y_end) {
            if (y_start == b.sy) {
                if (c.sy == b.sy) {
                    return;
                }
                tempI = b.sy - a.sy;
                x_start = (a.sx << 12) + dx_start * tempI;
                u_start = (au << 12) + du_start * tempI;
                v_start = (av << 12) + dv_start * tempI;
                x_end = b.sx << 12;
                u_end = bu << 12;
                v_end = bv << 12;
                tempI = c.sy - b.sy;
                dx_end = (c.sx - b.sx << 12) / tempI;
                du_end = (cu - bu << 12) / tempI;
                dv_end = (cv - bv << 12) / tempI;
            }
            if (y_start >= 0) {
                int x2;
                int v;
                int u;
                int x1;
                if (x_start > x_end) {
                    tempI = x_end % 4096;
                    x1 = x_end >> 12;
                    u = u_end;
                    v = v_end;
                    x2 = x_start >> 12;
                } else {
                    tempI = x_start % 4096;
                    x1 = x_start >> 12;
                    u = u_start;
                    v = v_start;
                    x2 = x_end >> 12;
                }
                if (x1 < 0) {
                    u -= du * x1;
                    v -= dv * x1;
                    x1 = 0;
                }
                if (x2 > g3d.width) {
                    x2 = g3d.width;
                }
                tempI = g3d.width * y_start;
                x1 += tempI;
                x2 += tempI;
                u -= du;
                v -= dv;
                while (x1 < x2) {
                    int col = tex[((v += dv) >> 12 << widthBIT) + ((u += du) >> 12) & lengthBIT];
                    if (col != 0) {
                        col = (col & 0xFEFEFE) + colf;
                        rgb[x1] = col | (col >> 8 & 0x10101) * 255;
                    }
                    ++x1;
                }
            }
            ++y_start;
            x_start += dx_start;
            u_start += du_start;
            v_start += dv_start;
            x_end += dx_end;
            u_end += du_end;
            v_end += dv_end;
        }
    }

    static final void paintAffine_2(Graphics3D g3d, Texture texture, Vertex a, int au, int av, Vertex b, int bu, int bv, Vertex c, int cu, int cv, int fogc, int sz2) {
        int y_end;
        int tb;
        Vertex t;
        if (b.sy < a.sy) {
            t = a;
            a = b;
            b = t;
            tb = au;
            au = bu;
            bu = tb;
            tb = av;
            av = bv;
            bv = tb;
        }
        if (c.sy < a.sy) {
            t = c;
            c = a;
            a = t;
            tb = cu;
            cu = au;
            au = tb;
            tb = cv;
            cv = av;
            av = tb;
        }
        if (c.sy < b.sy) {
            t = b;
            b = c;
            c = t;
            tb = bu;
            bu = cu;
            cu = tb;
            tb = bv;
            bv = cv;
            cv = tb;
        }
        if (a.sy == c.sy) {
            return;
        }
        int[] tex = texture.rImg.img;
        int lengthBIT = tex.length - 1;
        int widthBIT = texture.widthBIT;
        int[] rgb = g3d.display;
        int tempI = c.sy - a.sy;
        int dx_start = (c.sx - a.sx << 12) / tempI;
        int du_start = (cu - au << 12) / tempI;
        int dv_start = (cv - av << 12) / tempI;
        int dx_end = 0;
        int du_end = 0;
        int dv_end = 0;
        if (b.sy != a.sy) {
            tempI = b.sy - a.sy;
            dx_end = (b.sx - a.sx << 12) / tempI;
            du_end = (bu - au << 12) / tempI;
            dv_end = (bv - av << 12) / tempI;
        }
        tempI = b.sy - a.sy;
        int x_start = (a.sx << 12) + dx_start * tempI;
        int u_start = (au << 12) + du_start * tempI;
        int v_start = (av << 12) + dv_start * tempI;
        int x_end = b.sx << 12;
        int u_end = bu << 12;
        int v_end = bv << 12;
        tempI = x_start - x_end >> 12;
        if (tempI == 0) {
            return;
        }
        int du = (u_start - u_end) / tempI;
        int dv = (v_start - v_end) / tempI;
        x_end = x_start = a.sx << 12;
        u_end = u_start = au << 12;
        v_end = v_start = av << 12;
        int y_start = a.sy;
        int n = y_end = c.sy < g3d.height ? c.sy : g3d.height;
        while (y_start < y_end) {
            if (y_start == b.sy) {
                if (c.sy == b.sy) {
                    return;
                }
                tempI = b.sy - a.sy;
                x_start = (a.sx << 12) + dx_start * tempI;
                u_start = (au << 12) + du_start * tempI;
                v_start = (av << 12) + dv_start * tempI;
                x_end = b.sx << 12;
                u_end = bu << 12;
                v_end = bv << 12;
                tempI = c.sy - b.sy;
                dx_end = (c.sx - b.sx << 12) / tempI;
                du_end = (cu - bu << 12) / tempI;
                dv_end = (cv - bv << 12) / tempI;
            }
            if (y_start >= 0) {
                int x2;
                int v;
                int u;
                int x1;
                if (x_start > x_end) {
                    tempI = x_end % 4096;
                    x1 = x_end >> 12;
                    u = u_end;
                    v = v_end;
                    x2 = x_start >> 12;
                } else {
                    tempI = x_start % 4096;
                    x1 = x_start >> 12;
                    u = u_start;
                    v = v_start;
                    x2 = x_end >> 12;
                }
                if (x1 < 0) {
                    u -= du * x1;
                    v -= dv * x1;
                    x1 = 0;
                }
                if (x2 > g3d.width) {
                    x2 = g3d.width;
                }
                tempI = g3d.width * y_start;
                x1 += tempI;
                x2 += tempI;
                u -= du;
                v -= dv;
                while (x1 < x2) {
                    int col = tex[((v += dv) >> 12 << widthBIT) + ((u += du) >> 12) & lengthBIT];
                    if (col != 0) {
                        col = (col & 0xFEFEFE) + (rgb[x1] & 0xFEFEFE);
                        rgb[x1] = col | (col >> 8 & 0x10101) * 255;
                    }
                    ++x1;
                }
            }
            ++y_start;
            x_start += dx_start;
            u_start += du_start;
            v_start += dv_start;
            x_end += dx_end;
            u_end += du_end;
            v_end += dv_end;
        }
    }

    static final void paintAffine_3(Graphics3D g3d, Texture texture, Vertex a, int au, int av, Vertex b, int bu, int bv, Vertex c, int cu, int cv, int fogc, int sz2) {
        int y_end;
        int tb;
        Vertex t;
        if (b.sy < a.sy) {
            t = a;
            a = b;
            b = t;
            tb = au;
            au = bu;
            bu = tb;
            tb = av;
            av = bv;
            bv = tb;
        }
        if (c.sy < a.sy) {
            t = c;
            c = a;
            a = t;
            tb = cu;
            cu = au;
            au = tb;
            tb = cv;
            cv = av;
            av = tb;
        }
        if (c.sy < b.sy) {
            t = b;
            b = c;
            c = t;
            tb = bu;
            bu = cu;
            cu = tb;
            tb = bv;
            bv = cv;
            cv = tb;
        }
        if (a.sy == c.sy) {
            return;
        }
        if (Graphics3D.fDist / 255 != 0) {
            sz2 = -Texturing.max(a.rz, b.rz, c.rz) / (Graphics3D.fDist / 255);
        }
        if (sz2 > 255) {
            sz2 = 255;
        }
        if (sz2 < 0) {
            sz2 = 0;
        }
        int[] tex = texture.rImg.img;
        int lengthBIT = tex.length - 1;
        int widthBIT = texture.widthBIT;
        int[] rgb = g3d.display;
        int isz2 = 255 - sz2;
        int f2 = (fogc & 0xFF00FF) * sz2;
        int f22 = (fogc & 0xFF00) * sz2;
        int tempI = c.sy - a.sy;
        int dx_start = (c.sx - a.sx << 12) / tempI;
        int du_start = (cu - au << 12) / tempI;
        int dv_start = (cv - av << 12) / tempI;
        int dx_end = 0;
        int du_end = 0;
        int dv_end = 0;
        if (b.sy != a.sy) {
            tempI = b.sy - a.sy;
            dx_end = (b.sx - a.sx << 12) / tempI;
            du_end = (bu - au << 12) / tempI;
            dv_end = (bv - av << 12) / tempI;
        }
        tempI = b.sy - a.sy;
        int x_start = (a.sx << 12) + dx_start * tempI;
        int u_start = (au << 12) + du_start * tempI;
        int v_start = (av << 12) + dv_start * tempI;
        int x_end = b.sx << 12;
        int u_end = bu << 12;
        int v_end = bv << 12;
        tempI = x_start - x_end >> 12;
        if (tempI == 0) {
            return;
        }
        int du = (u_start - u_end) / tempI;
        int dv = (v_start - v_end) / tempI;
        x_end = x_start = a.sx << 12;
        u_end = u_start = au << 12;
        v_end = v_start = av << 12;
        int y_start = a.sy;
        int n = y_end = c.sy < g3d.height ? c.sy : g3d.height;
        if (Main.fogQ == 2 && !Main.forceLQFog) {
            Texturing.paintAffine_3_HQ(x_start, x_end, y_start, y_end, u_start, u_end, v_start, v_end, dx_start, dx_end, du_start, du_end, dv_start, dv_end, a, b, c, au, av, bu, bv, cu, cv, du, dv, g3d, texture);
            return;
        }
        while (y_start < y_end) {
            if (y_start == b.sy) {
                if (c.sy == b.sy) {
                    return;
                }
                tempI = b.sy - a.sy;
                x_start = (a.sx << 12) + dx_start * tempI;
                u_start = (au << 12) + du_start * tempI;
                v_start = (av << 12) + dv_start * tempI;
                x_end = b.sx << 12;
                u_end = bu << 12;
                v_end = bv << 12;
                tempI = c.sy - b.sy;
                dx_end = (c.sx - b.sx << 12) / tempI;
                du_end = (cu - bu << 12) / tempI;
                dv_end = (cv - bv << 12) / tempI;
            }
            if (y_start >= 0) {
                int x2;
                int v;
                int u;
                int x1;
                if (x_start > x_end) {
                    tempI = x_end % 4096;
                    x1 = x_end >> 12;
                    u = u_end;
                    v = v_end;
                    x2 = x_start >> 12;
                } else {
                    tempI = x_start % 4096;
                    x1 = x_start >> 12;
                    u = u_start;
                    v = v_start;
                    x2 = x_end >> 12;
                }
                if (x1 < 0) {
                    u -= du * x1;
                    v -= dv * x1;
                    x1 = 0;
                }
                if (x2 > g3d.width) {
                    x2 = g3d.width;
                }
                tempI = g3d.width * y_start;
                x1 += tempI;
                x2 += tempI;
                u -= du;
                v -= dv;
                while (x1 < x2) {
                    int col = tex[((v += dv) >> 12 << widthBIT) + ((u += du) >> 12) & lengthBIT];
                    if (col != 0) {
                        rgb[x1] = ((col & 0xFF00FF) * isz2 + f2 & 0xFF00FF00 | (col & 0xFF00) * isz2 + f22 & 0xFF0000) >>> 8;
                    }
                    ++x1;
                }
            }
            ++y_start;
            x_start += dx_start;
            u_start += du_start;
            v_start += dv_start;
            x_end += dx_end;
            u_end += du_end;
            v_end += dv_end;
        }
    }

    static final void paintAffine_3_HQ(int x_start, int x_end, int y_start, int y_end, int u_start, int u_end, int v_start, int v_end, int dx_start, int dx_end, int du_start, int du_end, int dv_start, int dv_end, Vertex a, Vertex b, Vertex c, int au, int av, int bu, int bv, int cu, int cv, int du, int dv, Graphics3D g3d, Texture texture) {
        int fogcolor = Graphics3D.fogc;
        int fogcolor2 = fogcolor & 0xFF00;
        fogcolor &= 0xFF00FF;
        int af = -a.rz * 255 / Graphics3D.fDist;
        if (af > 255) {
            af = 255;
        }
        if (af < 0) {
            af = 0;
        }
        af = 255 - af;
        int bf = -b.rz * 255 / Graphics3D.fDist;
        if (bf > 255) {
            bf = 255;
        }
        if (bf < 0) {
            bf = 0;
        }
        bf = 255 - bf;
        int cf = -c.rz * 255 / Graphics3D.fDist;
        if (cf > 255) {
            cf = 255;
        }
        if (cf < 0) {
            cf = 0;
        }
        cf = 255 - cf;
        int[] tex = texture.rImg.img;
        int lengthBIT = tex.length - 1;
        int widthBIT = texture.widthBIT;
        int[] rgb = g3d.display;
        int tempI = c.sy - a.sy;
        int df_start = (cf - af << 12) / tempI;
        int df_end = 0;
        if (b.sy != a.sy) {
            tempI = b.sy - a.sy;
            df_end = (bf - af << 12) / tempI;
        }
        tempI = b.sy - a.sy;
        int f_start = (af << 12) + df_start * tempI;
        int f_end = bf << 12;
        if ((tempI = (a.sx << 12) + dx_start * tempI - (b.sx << 12) >> 12) == 0) {
            return;
        }
        int df = (f_start - f_end) / tempI;
        f_end = f_start = af << 12;
        while (y_start < y_end) {
            if (y_start == b.sy) {
                if (c.sy == b.sy) {
                    return;
                }
                tempI = b.sy - a.sy;
                x_start = (a.sx << 12) + dx_start * tempI;
                u_start = (au << 12) + du_start * tempI;
                v_start = (av << 12) + dv_start * tempI;
                f_start = (af << 12) + df_start * tempI;
                x_end = b.sx << 12;
                u_end = bu << 12;
                v_end = bv << 12;
                f_end = bf << 12;
                tempI = c.sy - b.sy;
                dx_end = (c.sx - b.sx << 12) / tempI;
                du_end = (cu - bu << 12) / tempI;
                dv_end = (cv - bv << 12) / tempI;
                df_end = (cf - bf << 12) / tempI;
            }
            if (y_start >= 0) {
                int x2;
                int f;
                int v;
                int u;
                int x1;
                if (x_start > x_end) {
                    tempI = x_end % 4096;
                    x1 = x_end >> 12;
                    u = u_end;
                    v = v_end;
                    f = f_end;
                    x2 = x_start >> 12;
                } else {
                    tempI = x_start % 4096;
                    x1 = x_start >> 12;
                    u = u_start;
                    v = v_start;
                    f = f_start;
                    x2 = x_end >> 12;
                }
                if (x1 < 0) {
                    u -= du * x1;
                    v -= dv * x1;
                    f -= df * x1;
                    x1 = 0;
                }
                if (x2 > g3d.width) {
                    x2 = g3d.width;
                }
                tempI = g3d.width * y_start;
                x1 += tempI;
                x2 += tempI;
                u -= du;
                v -= dv;
                while (x1 < x2) {
                    int isz2 = (f += df) >> 12;
                    int isz = 255 - isz2;
                    int col = tex[((v += dv) >> 12 << widthBIT) + ((u += du) >> 12) & lengthBIT];
                    if (col != 0) {
                        rgb[x1] = ((col & 0xFF00FF) * isz2 + fogcolor * isz & 0xFF00FF00 | (col & 0xFF00) * isz2 + fogcolor2 * isz & 0xFF0000) >>> 8;
                    }
                    ++x1;
                }
            }
            ++y_start;
            x_start += dx_start;
            u_start += du_start;
            v_start += dv_start;
            f_start += df_start;
            x_end += dx_end;
            u_end += du_end;
            v_end += dv_end;
            f_end += df_end;
        }
    }

    static final void paintAffine_4(Graphics3D g3d, Texture texture, Vertex a, int au, int av, Vertex b, int bu, int bv, Vertex c, int cu, int cv, int fogc, int sz2) {
        int y_end;
        int tb;
        Vertex t;
        if (b.sy < a.sy) {
            t = a;
            a = b;
            b = t;
            tb = au;
            au = bu;
            bu = tb;
            tb = av;
            av = bv;
            bv = tb;
        }
        if (c.sy < a.sy) {
            t = c;
            c = a;
            a = t;
            tb = cu;
            cu = au;
            au = tb;
            tb = cv;
            cv = av;
            av = tb;
        }
        if (c.sy < b.sy) {
            t = b;
            b = c;
            c = t;
            tb = bu;
            bu = cu;
            cu = tb;
            tb = bv;
            bv = cv;
            cv = tb;
        }
        if (a.sy == c.sy) {
            return;
        }
        int[] tex = texture.rImg.img;
        int lengthBIT = tex.length - 1;
        int widthBIT = texture.widthBIT;
        int[] rgb = g3d.display;
        int tempI = c.sy - a.sy;
        int dx_start = (c.sx - a.sx << 12) / tempI;
        int du_start = (cu - au << 12) / tempI;
        int dv_start = (cv - av << 12) / tempI;
        int dx_end = 0;
        int du_end = 0;
        int dv_end = 0;
        if (b.sy != a.sy) {
            tempI = b.sy - a.sy;
            dx_end = (b.sx - a.sx << 12) / tempI;
            du_end = (bu - au << 12) / tempI;
            dv_end = (bv - av << 12) / tempI;
        }
        tempI = b.sy - a.sy;
        int x_start = (a.sx << 12) + dx_start * tempI;
        int u_start = (au << 12) + du_start * tempI;
        int v_start = (av << 12) + dv_start * tempI;
        int x_end = b.sx << 12;
        int u_end = bu << 12;
        int v_end = bv << 12;
        tempI = x_start - x_end >> 12;
        if (tempI == 0) {
            return;
        }
        int du = (u_start - u_end) / tempI;
        int dv = (v_start - v_end) / tempI;
        x_end = x_start = a.sx << 12;
        u_end = u_start = au << 12;
        v_end = v_start = av << 12;
        int y_start = a.sy;
        int n = y_end = c.sy < g3d.height ? c.sy : g3d.height;
        while (y_start < y_end) {
            if (y_start == b.sy) {
                if (c.sy == b.sy) {
                    return;
                }
                tempI = b.sy - a.sy;
                x_start = (a.sx << 12) + dx_start * tempI;
                u_start = (au << 12) + du_start * tempI;
                v_start = (av << 12) + dv_start * tempI;
                x_end = b.sx << 12;
                u_end = bu << 12;
                v_end = bv << 12;
                tempI = c.sy - b.sy;
                dx_end = (c.sx - b.sx << 12) / tempI;
                du_end = (cu - bu << 12) / tempI;
                dv_end = (cv - bv << 12) / tempI;
            }
            if (y_start >= 0) {
                int x2;
                int v;
                int u;
                int x1;
                if (x_start > x_end) {
                    tempI = x_end % 4096;
                    x1 = x_end >> 12;
                    u = u_end;
                    v = v_end;
                    x2 = x_start >> 12;
                } else {
                    tempI = x_start % 4096;
                    x1 = x_start >> 12;
                    u = u_start;
                    v = v_start;
                    x2 = x_end >> 12;
                }
                if (x1 < 0) {
                    u -= du * x1;
                    v -= dv * x1;
                    x1 = 0;
                }
                if (x2 > g3d.width) {
                    x2 = g3d.width;
                }
                tempI = g3d.width * y_start;
                x1 += tempI;
                x2 += tempI;
                u -= du;
                v -= dv;
                while (x1 < x2) {
                    int col = tex[((v += dv) >> 12 << widthBIT) + ((u += du) >> 12) & lengthBIT];
                    if (col != 0) {
                        int ca = col >> 24 & 0xFF;
                        int cols = rgb[x1];
                        rgb[x1] = ((col & 0xFF00FF) * ca + (cols & 0xFF00FF) * (255 - ca) & 0xFF00FF00 | (col & 0xFF00) * ca + (cols & 0xFF00) * (255 - ca) & 0xFF0000) >>> 8;
                    }
                    ++x1;
                }
            }
            ++y_start;
            x_start += dx_start;
            u_start += du_start;
            v_start += dv_start;
            x_end += dx_end;
            u_end += du_end;
            v_end += dv_end;
        }
    }

    static final void paintAffine_5(Graphics3D g3d, Texture texture, Vertex a, int au, int av, Vertex b, int bu, int bv, Vertex c, int cu, int cv, int fogc, int sz2) {
        int tb;
        Vertex t;
        if (b.sy < a.sy) {
            t = a;
            a = b;
            b = t;
            tb = au;
            au = bu;
            bu = tb;
            tb = av;
            av = bv;
            bv = tb;
        }
        if (c.sy < a.sy) {
            t = c;
            c = a;
            a = t;
            tb = cu;
            cu = au;
            au = tb;
            tb = cv;
            cv = av;
            av = tb;
        }
        if (c.sy < b.sy) {
            t = b;
            b = c;
            c = t;
            tb = bu;
            bu = cu;
            cu = tb;
            tb = bv;
            bv = cv;
            cv = tb;
        }
        if (a.sy == c.sy) {
            return;
        }
        if (texture.getDrawMode() == 6) {
            if (Graphics3D.fDist / 255 != 0) {
                sz2 = -Texturing.max(a.rz, b.rz, c.rz) / (Graphics3D.fDist / 255);
            }
            if (sz2 > 255) {
                sz2 = 255;
            }
            if (sz2 < 0) {
                sz2 = 0;
            }
        }
        int[] tex = texture.rImg.img;
        int lengthBIT = tex.length - 1;
        int widthBIT = texture.widthBIT;
        int[] rgb = g3d.display;
        int tempI = c.sy - a.sy;
        int dx_start = (c.sx - a.sx << 12) / tempI;
        int du_start = (cu - au << 12) / tempI;
        int dv_start = (cv - av << 12) / tempI;
        int dx_end = 0;
        int du_end = 0;
        int dv_end = 0;
        if (b.sy != a.sy) {
            tempI = b.sy - a.sy;
            dx_end = (b.sx - a.sx << 12) / tempI;
            du_end = (bu - au << 12) / tempI;
            dv_end = (bv - av << 12) / tempI;
        }
        tempI = b.sy - a.sy;
        int x_start = (a.sx << 12) + dx_start * tempI;
        int u_start = (au << 12) + du_start * tempI;
        int v_start = (av << 12) + dv_start * tempI;
        int x_end = b.sx << 12;
        int u_end = bu << 12;
        int v_end = bv << 12;
        tempI = x_start - x_end >> 12;
        if (tempI == 0) {
            return;
        }
        int du = (u_start - u_end) / tempI;
        int dv = (v_start - v_end) / tempI;
        x_end = x_start = a.sx << 12;
        u_end = u_start = au << 12;
        v_end = v_start = av << 12;
        int y_start = a.sy;
        int y_end = c.sy < g3d.height ? c.sy : g3d.height;
        int isz2 = 255 - sz2;
        while (y_start < y_end) {
            if (y_start == b.sy) {
                if (c.sy == b.sy) {
                    return;
                }
                tempI = b.sy - a.sy;
                x_start = (a.sx << 12) + dx_start * tempI;
                u_start = (au << 12) + du_start * tempI;
                v_start = (av << 12) + dv_start * tempI;
                x_end = b.sx << 12;
                u_end = bu << 12;
                v_end = bv << 12;
                tempI = c.sy - b.sy;
                dx_end = (c.sx - b.sx << 12) / tempI;
                du_end = (cu - bu << 12) / tempI;
                dv_end = (cv - bv << 12) / tempI;
            }
            if (y_start >= 0) {
                int x2;
                int v;
                int u;
                int x1;
                if (x_start > x_end) {
                    tempI = x_end % 4096;
                    x1 = x_end >> 12;
                    u = u_end;
                    v = v_end;
                    x2 = x_start >> 12;
                } else {
                    tempI = x_start % 4096;
                    x1 = x_start >> 12;
                    u = u_start;
                    v = v_start;
                    x2 = x_end >> 12;
                }
                if (x1 < 0) {
                    u -= du * x1;
                    v -= dv * x1;
                    x1 = 0;
                }
                if (x2 > g3d.width) {
                    x2 = g3d.width;
                }
                tempI = g3d.width * y_start;
                x1 += tempI;
                x2 += tempI;
                u -= du;
                v -= dv;
                while (x1 < x2) {
                    int col = tex[((v += dv) >> 12 << widthBIT) + ((u += du) >> 12) & lengthBIT];
                    if (col != 0) {
                        rgb[x1] = ((col & 0xFF00FF) * isz2 & 0xFF00FF00 | (col & 0xFF00) * isz2 & 0xFF0000) >>> 8;
                    }
                    ++x1;
                }
            }
            ++y_start;
            x_start += dx_start;
            u_start += du_start;
            v_start += dv_start;
            x_end += dx_end;
            u_end += du_end;
            v_end += dv_end;
        }
    }

    static final void paint_glass(Graphics3D g3d, Texture texture, Vertex a, int au, int av, Vertex b, int bu, int bv, Vertex c, int cu, int cv, int fogc, int sz2) {
        int y_end;
        int tb;
        Vertex t;
        if (b.sy < a.sy) {
            t = a;
            a = b;
            b = t;
            tb = au;
            au = bu;
            bu = tb;
            tb = av;
            av = bv;
            bv = tb;
        }
        if (c.sy < a.sy) {
            t = c;
            c = a;
            a = t;
            tb = cu;
            cu = au;
            au = tb;
            tb = cv;
            cv = av;
            av = tb;
        }
        if (c.sy < b.sy) {
            t = b;
            b = c;
            c = t;
            tb = bu;
            bu = cu;
            cu = tb;
            tb = bv;
            bv = cv;
            cv = tb;
        }
        if (a.sy == c.sy) {
            return;
        }
        int[] tex = texture.rImg.img;
        int lengthBIT = tex.length - 1;
        int widthBIT = texture.widthBIT;
        int[] rgb = g3d.display;
        int scale = 50;
        scale = scale * (g3d.getHeight() + g3d.getWidth()) / 560;
        int tempI = c.sy - a.sy;
        int dx_start = (c.sx - a.sx << 12) / tempI;
        int du_start = (cu - au << 12) / tempI;
        int dv_start = (cv - av << 12) / tempI;
        int dx_end = 0;
        int du_end = 0;
        int dv_end = 0;
        if (b.sy != a.sy) {
            tempI = b.sy - a.sy;
            dx_end = (b.sx - a.sx << 12) / tempI;
            du_end = (bu - au << 12) / tempI;
            dv_end = (bv - av << 12) / tempI;
        }
        tempI = b.sy - a.sy;
        int x_start = (a.sx << 12) + dx_start * tempI;
        int u_start = (au << 12) + du_start * tempI;
        int v_start = (av << 12) + dv_start * tempI;
        int x_end = b.sx << 12;
        int u_end = bu << 12;
        int v_end = bv << 12;
        tempI = x_start - x_end >> 12;
        if (tempI == 0) {
            return;
        }
        int du = (u_start - u_end) / tempI;
        int dv = (v_start - v_end) / tempI;
        x_end = x_start = a.sx << 12;
        u_end = u_start = au << 12;
        v_end = v_start = av << 12;
        int y_start = a.sy;
        int n = y_end = c.sy < g3d.height ? c.sy : g3d.height;
        while (y_start < y_end) {
            if (y_start == b.sy) {
                if (c.sy == b.sy) {
                    return;
                }
                tempI = b.sy - a.sy;
                x_start = (a.sx << 12) + dx_start * tempI;
                u_start = (au << 12) + du_start * tempI;
                v_start = (av << 12) + dv_start * tempI;
                x_end = b.sx << 12;
                u_end = bu << 12;
                v_end = bv << 12;
                tempI = c.sy - b.sy;
                dx_end = (c.sx - b.sx << 12) / tempI;
                du_end = (cu - bu << 12) / tempI;
                dv_end = (cv - bv << 12) / tempI;
            }
            if (y_start >= 0) {
                int x2;
                int v;
                int u;
                int x1;
                if (x_start > x_end) {
                    tempI = x_end % 4096;
                    x1 = x_end >> 12;
                    u = u_end;
                    v = v_end;
                    x2 = x_start >> 12;
                } else {
                    tempI = x_start % 4096;
                    x1 = x_start >> 12;
                    u = u_start;
                    v = v_start;
                    x2 = x_end >> 12;
                }
                if (x1 < 0) {
                    u -= du * x1;
                    v -= dv * x1;
                    x1 = 0;
                }
                if (x2 > g3d.width) {
                    x2 = g3d.width;
                }
                tempI = g3d.width * y_start;
                x1 += tempI;
                x2 += tempI;
                u -= du;
                v -= dv;
                while (x1 < x2) {
                    int col = texture.rImg.img[((v += dv) >> 12 << widthBIT) + ((u += du) >> 12) & lengthBIT];
                    int cr = ((col >> 16 & 0xFF) - 128) * scale / 200;
                    int cg = ((col >> 8 & 0xFF) - 128) * scale / 200;
                    int coord = x1 + cr + cg * g3d.getWidth();
                    if (coord >= g3d.getDisplay().length) {
                        coord = g3d.getDisplay().length - 1;
                    }
                    if (coord < 0) {
                        coord = 0;
                    }
                    rgb[x1] = rgb[coord];
                    ++x1;
                }
            }
            ++y_start;
            x_start += dx_start;
            u_start += du_start;
            v_start += dv_start;
            x_end += dx_end;
            u_end += du_end;
            v_end += dv_end;
        }
    }

    static final void paintAffine_8(Graphics3D g3d, Texture texture, Vertex a, int au, int av, Vertex b, int bu, int bv, Vertex c, int cu, int cv, int fogc, int sz2) {
        Vertex t;
        int col = texture.rImg.img[(av << texture.widthBIT) + au & texture.rImg.img.length - 1];
        if (b.sy < a.sy) {
            t = a;
            a = b;
            b = t;
        }
        if (c.sy < a.sy) {
            t = c;
            c = a;
            a = t;
        }
        if (c.sy < b.sy) {
            t = b;
            b = c;
            c = t;
        }
        if (a.sy == c.sy) {
            return;
        }
        int[] rgb = g3d.display;
        int tempI = c.sy - a.sy;
        int dx_start = (c.sx - a.sx << 12) / tempI;
        int dx_end = 0;
        if (b.sy != a.sy) {
            tempI = b.sy - a.sy;
            dx_end = (b.sx - a.sx << 12) / tempI;
        }
        tempI = b.sy - a.sy;
        int x_start = (a.sx << 12) + dx_start * tempI;
        int x_end = b.sx << 12;
        if ((tempI = x_start - x_end >> 12) == 0) {
            return;
        }
        x_end = x_start = a.sx << 12;
        int y_start = a.sy;
        int y_end = c.sy < g3d.height ? c.sy : g3d.height;
        boolean dxe = false;
        boolean xe = false;
        boolean xs = false;
        while (y_start < y_end) {
            if (y_start == b.sy) {
                if (c.sy == b.sy) {
                    return;
                }
                x_start = (a.sx << 12) + dx_start * (b.sy - a.sy);
                x_end = b.sx << 12;
                dx_end = (c.sx - b.sx << 12) / (c.sy - b.sy);
            }
            if (y_start >= 0) {
                int x2;
                int x1 = x_start > x_end ? x_end >> 12 : x_start >> 12;
                int n = x2 = x_start > x_end ? x_start >> 12 : x_end >> 12;
                if (x1 < 0) {
                    x1 = 0;
                }
                if (x2 > g3d.width) {
                    x2 = g3d.width;
                }
                tempI = g3d.width * y_start;
                x1 += tempI;
                x2 += tempI;
                while (x2 - x1 >= 5) {
                    rgb[x1] = col;
                    rgb[x1 + 1] = col;
                    rgb[x1 + 2] = col;
                    rgb[x1 + 3] = col;
                    rgb[x1 + 4] = col;
                    x1 += 5;
                }
                while (x2 - x1 >= 2) {
                    rgb[x1] = col;
                    rgb[x1 + 1] = col;
                    x1 += 2;
                }
                while (x1 < x2) {
                    rgb[x1] = col;
                    ++x1;
                }
            }
            ++y_start;
            x_start += dx_start;
            x_end += dx_end;
        }
    }

    public static int sqr(int x) {
        return x * x;
    }

    public static final void paintPers(Graphics3D g3d, Texture texture, Vertex a, int au, int av, Vertex b, int bu, int bv, Vertex c, int cu, int cv, int fogc, byte fog, int qz, int q) {
        int y_end;
        int y_start;
        int tb;
        Vertex t;
        if (!texture.alphaMixing && texture.drawmode == 4) {
            fog = 0;
        }
        au = au * texture.rImg.w >> 8;
        bu = bu * texture.rImg.w >> 8;
        cu = cu * texture.rImg.w >> 8;
        av = av * texture.rImg.h >> 8;
        bv = bv * texture.rImg.h >> 8;
        cv = cv * texture.rImg.h >> 8;
        if (fog == 8) {
            Texturing.paintAffine_8(g3d, texture, a, au, av, b, bu, bv, c, cu, cv, fogc, 1);
            return;
        }
        if (b.sy < a.sy) {
            t = a;
            a = b;
            b = t;
            tb = au;
            au = bu;
            bu = tb;
            tb = av;
            av = bv;
            bv = tb;
        }
        if (c.sy < a.sy) {
            t = c;
            c = a;
            a = t;
            tb = cu;
            cu = au;
            au = tb;
            tb = cv;
            cv = av;
            av = tb;
        }
        if (c.sy < b.sy) {
            t = b;
            b = c;
            c = t;
            tb = bu;
            bu = cu;
            cu = tb;
            tb = bv;
            bv = cv;
            cv = tb;
        }
        if (a.sy == c.sy) {
            return;
        }
        boolean lx = false;
        int ly = 1000;
        boolean lz = false;
        int lrad = 40000;
        int af = -a.rz * 255 / Graphics3D.fDist;
        if (af > 253) {
            af = 253;
        }
        if (af < 0) {
            af = 0;
        }
        af = 255 - af;
        int bf = -b.rz * 255 / Graphics3D.fDist;
        if (bf > 253) {
            bf = 253;
        }
        if (bf < 0) {
            bf = 0;
        }
        bf = 255 - bf;
        int cf = -c.rz * 255 / Graphics3D.fDist;
        if (cf > 253) {
            cf = 253;
        }
        if (cf < 0) {
            cf = 0;
        }
        cf = 255 - cf;
        int W_UNIT = 0x40000000;
        int tempI = 262344;
        int awz = a.rz < 0 ? tempI / (-a.rz + 200) : tempI / 200;
        int bwz = b.rz < 0 ? tempI / (-b.rz + 200) : tempI / 200;
        int cwz = c.rz < 0 ? tempI / (-c.rz + 200) : tempI / 200;
        int auz = au * awz;
        int avz = av * awz;
        int buz = bu * bwz;
        int bvz = bv * bwz;
        int cuz = cu * cwz;
        int cvz = cv * cwz;
        tempI = c.sy - a.sy;
        int dx_start = (c.sx - a.sx << 12) / tempI;
        int dwz_start = (cwz - awz << 12) / tempI;
        int duz_start = (cuz - auz << 12) / tempI;
        int dvz_start = (cvz - avz << 12) / tempI;
        int df_start = (cf - af << 12) / tempI;
        int dx_end = 0;
        int dwz_end = 0;
        int duz_end = 0;
        int dvz_end = 0;
        int df_end = 0;
        if (b.sy != a.sy) {
            tempI = b.sy - a.sy;
            dx_end = (b.sx - a.sx << 12) / tempI;
            dwz_end = (bwz - awz << 12) / tempI;
            duz_end = (buz - auz << 12) / tempI;
            dvz_end = (bvz - avz << 12) / tempI;
            df_end = (bf - af << 12) / tempI;
        }
        tempI = b.sy - a.sy;
        int x_start = (a.sx << 12) + dx_start * tempI;
        int wz_start = (awz << 12) + dwz_start * tempI;
        int uz_start = (auz << 12) + duz_start * tempI;
        int vz_start = (avz << 12) + dvz_start * tempI;
        int f_start = (af << 12) + df_start * tempI;
        int x_end = b.sx << 12;
        int wz_end = bwz << 12;
        int uz_end = buz << 12;
        int vz_end = bvz << 12;
        int f_end = bf << 12;
        tempI = x_start - x_end >> 12;
        if (tempI == 0) {
            return;
        }
        int duz = (uz_start - uz_end) / tempI;
        int dvz = (vz_start - vz_end) / tempI;
        int dwz = (wz_start - wz_end) / tempI;
        int df = (f_start - f_end) / tempI;
        int tempII = c.sy - a.sy;
        int du_start = (cu - au << 12) / tempII;
        int dv_start = (cv - av << 12) / tempII;
        tempII = b.sy - a.sy;
        int x_start2 = (a.sx << 12) + dx_start * tempII;
        int x_end2 = b.sx << 12;
        int u_start = (au << 12) + du_start * tempII;
        int v_start = (av << 12) + dv_start * tempII;
        int u_end = bu << 12;
        int v_end = bv << 12;
        tempII = x_start2 - x_end2 >> 12;
        int du = 0;
        int dv = 0;
        if (tempII != 0) {
            du = (u_start - u_end) / tempII;
            dv = (v_start - v_end) / tempII;
        }
        boolean x2pixel = Math.abs(du) + Math.abs(dv) < 2048 && Math.abs(du) < 2048 && Math.abs(dv) < 2048 && Main.pixelsQ <= 1;
        boolean x4pixel = Math.abs(du) + Math.abs(dv) < 1024 && Math.abs(du) < 1024 && Math.abs(dv) < 1024 && Main.pixelsQ == 0;
        x_start = x_end = a.sx << 12;
        wz_start = wz_end = awz << 12;
        uz_start = uz_end = auz << 12;
        vz_start = vz_end = avz << 12;
        f_start = f_end = af << 12;
        if (b.sy > 0) {
            y_start = a.sy;
            if (y_start < 0) {
                x_start -= dx_start * y_start;
                wz_start -= dwz_start * y_start;
                uz_start -= duz_start * y_start;
                vz_start -= dvz_start * y_start;
                f_start -= df_start * y_start;
                x_end -= dx_end * y_start;
                wz_end -= dwz_end * y_start;
                uz_end -= duz_end * y_start;
                vz_end -= dvz_end * y_start;
                f_end -= df_end * y_start;
                y_start = 0;
            }
            y_end = b.sy < g3d.height ? b.sy : g3d.height;
            switch (fog) {
                case 0: {
                    Texturing.paintMiniTrianglePers_0(g3d, texture, y_start, y_end, x_start, wz_start, uz_start, vz_start, x_end, wz_end, uz_end, vz_end, dx_start, dwz_start, duz_start, dvz_start, dx_end, dwz_end, duz_end, dvz_end, dwz, duz, dvz, fogc, q, x2pixel, x4pixel);
                    break;
                }
                case 1: {
                    Texturing.paintMiniTrianglePers_1(g3d, texture, y_start, y_end, x_start, wz_start, uz_start, vz_start, x_end, wz_end, uz_end, vz_end, dx_start, dwz_start, duz_start, dvz_start, dx_end, dwz_end, duz_end, dvz_end, dwz, duz, dvz, fogc, qz, q, x2pixel, x4pixel);
                    break;
                }
                case 2: {
                    Texturing.paintMiniTrianglePers_2(g3d, texture, y_start, y_end, x_start, wz_start, uz_start, vz_start, x_end, wz_end, uz_end, vz_end, dx_start, dwz_start, duz_start, dvz_start, dx_end, dwz_end, duz_end, dvz_end, dwz, duz, dvz, fogc, q);
                    break;
                }
                case 3: {
                    Texturing.paintMiniTrianglePers_3(g3d, texture, y_start, y_end, x_start, wz_start, uz_start, vz_start, x_end, wz_end, uz_end, vz_end, dx_start, dwz_start, duz_start, dvz_start, dx_end, dwz_end, duz_end, dvz_end, dwz, duz, dvz, fogc, qz, q, a, b, c, x2pixel, x4pixel, f_start, f_end, df_start, df_end, df);
                    break;
                }
                case 4: {
                    Texturing.paintMiniTrianglePers_4(g3d, texture, y_start, y_end, x_start, wz_start, uz_start, vz_start, x_end, wz_end, uz_end, vz_end, dx_start, dwz_start, duz_start, dvz_start, dx_end, dwz_end, duz_end, dvz_end, dwz, duz, dvz, fogc, q);
                    break;
                }
                case 5: {
                    Texturing.paintMiniTrianglePers_5(g3d, texture, y_start, y_end, x_start, wz_start, uz_start, vz_start, x_end, wz_end, uz_end, vz_end, dx_start, dwz_start, duz_start, dvz_start, dx_end, dwz_end, duz_end, dvz_end, dwz, duz, dvz, fogc, qz, q, a, b, c, x2pixel, x4pixel, f_start, f_end, df_start, df_end, df);
                    break;
                }
                case 6: {
                    Texturing.paintMiniTrianglePers_5(g3d, texture, y_start, y_end, x_start, wz_start, uz_start, vz_start, x_end, wz_end, uz_end, vz_end, dx_start, dwz_start, duz_start, dvz_start, dx_end, dwz_end, duz_end, dvz_end, dwz, duz, dvz, fogc, qz, q, a, b, c, x2pixel, x4pixel, f_start, f_end, df_start, df_end, df);
                    break;
                }
                case 7: {
                    Texturing.paintPers_glass(g3d, texture, y_start, y_end, x_start, wz_start, uz_start, vz_start, x_end, wz_end, uz_end, vz_end, dx_start, dwz_start, duz_start, dvz_start, dx_end, dwz_end, duz_end, dvz_end, dwz, duz, dvz, fogc, q);
                }
            }
        }
        if (c.sy == b.sy || c.sy < 0) {
            return;
        }
        tempI = b.sy - a.sy;
        x_start = (a.sx << 12) + dx_start * tempI;
        wz_start = (awz << 12) + dwz_start * tempI;
        uz_start = (auz << 12) + duz_start * tempI;
        vz_start = (avz << 12) + dvz_start * tempI;
        f_start = (af << 12) + df_start * tempI;
        x_end = b.sx << 12;
        wz_end = bwz << 12;
        uz_end = buz << 12;
        vz_end = bvz << 12;
        f_end = bf << 12;
        tempI = c.sy - b.sy;
        dx_end = (c.sx - b.sx << 12) / tempI;
        dwz_end = (cwz - bwz << 12) / tempI;
        duz_end = (cuz - buz << 12) / tempI;
        dvz_end = (cvz - bvz << 12) / tempI;
        df_end = (cf - bf << 12) / tempI;
        y_start = b.sy;
        if (y_start < 0) {
            x_start -= dx_start * y_start;
            wz_start -= dwz_start * y_start;
            uz_start -= duz_start * y_start;
            vz_start -= dvz_start * y_start;
            f_start -= df_start * y_start;
            x_end -= dx_end * y_start;
            wz_end -= dwz_end * y_start;
            uz_end -= duz_end * y_start;
            vz_end -= dvz_end * y_start;
            f_end -= df_end * y_start;
            y_start = 0;
        }
        y_end = c.sy < g3d.height ? c.sy : g3d.height;
        switch (fog) {
            case 0: {
                Texturing.paintMiniTrianglePers_0(g3d, texture, y_start, y_end, x_start, wz_start, uz_start, vz_start, x_end, wz_end, uz_end, vz_end, dx_start, dwz_start, duz_start, dvz_start, dx_end, dwz_end, duz_end, dvz_end, dwz, duz, dvz, fogc, q, x2pixel, x4pixel);
                break;
            }
            case 1: {
                Texturing.paintMiniTrianglePers_1(g3d, texture, y_start, y_end, x_start, wz_start, uz_start, vz_start, x_end, wz_end, uz_end, vz_end, dx_start, dwz_start, duz_start, dvz_start, dx_end, dwz_end, duz_end, dvz_end, dwz, duz, dvz, fogc, qz, q, x2pixel, x4pixel);
                break;
            }
            case 2: {
                Texturing.paintMiniTrianglePers_2(g3d, texture, y_start, y_end, x_start, wz_start, uz_start, vz_start, x_end, wz_end, uz_end, vz_end, dx_start, dwz_start, duz_start, dvz_start, dx_end, dwz_end, duz_end, dvz_end, dwz, duz, dvz, fogc, q);
                break;
            }
            case 3: {
                Texturing.paintMiniTrianglePers_3(g3d, texture, y_start, y_end, x_start, wz_start, uz_start, vz_start, x_end, wz_end, uz_end, vz_end, dx_start, dwz_start, duz_start, dvz_start, dx_end, dwz_end, duz_end, dvz_end, dwz, duz, dvz, fogc, qz, q, a, b, c, x2pixel, x4pixel, f_start, f_end, df_start, df_end, df);
                break;
            }
            case 4: {
                Texturing.paintMiniTrianglePers_4(g3d, texture, y_start, y_end, x_start, wz_start, uz_start, vz_start, x_end, wz_end, uz_end, vz_end, dx_start, dwz_start, duz_start, dvz_start, dx_end, dwz_end, duz_end, dvz_end, dwz, duz, dvz, fogc, q);
                break;
            }
            case 5: {
                Texturing.paintMiniTrianglePers_5(g3d, texture, y_start, y_end, x_start, wz_start, uz_start, vz_start, x_end, wz_end, uz_end, vz_end, dx_start, dwz_start, duz_start, dvz_start, dx_end, dwz_end, duz_end, dvz_end, dwz, duz, dvz, fogc, qz, q, a, b, c, x2pixel, x4pixel, f_start, f_end, df_start, df_end, df);
                break;
            }
            case 6: {
                Texturing.paintMiniTrianglePers_5(g3d, texture, y_start, y_end, x_start, wz_start, uz_start, vz_start, x_end, wz_end, uz_end, vz_end, dx_start, dwz_start, duz_start, dvz_start, dx_end, dwz_end, duz_end, dvz_end, dwz, duz, dvz, fogc, qz, q, a, b, c, x2pixel, x4pixel, f_start, f_end, df_start, df_end, df);
                break;
            }
            case 7: {
                Texturing.paintPers_glass(g3d, texture, y_start, y_end, x_start, wz_start, uz_start, vz_start, x_end, wz_end, uz_end, vz_end, dx_start, dwz_start, duz_start, dvz_start, dx_end, dwz_end, duz_end, dvz_end, dwz, duz, dvz, fogc, q);
            }
        }
    }

    static final void paintMiniTrianglePers_0(Graphics3D g3d, Texture texture, int y_start, int y_end, int x_start, int wz_start, int uz_start, int vz_start, int x_end, int wz_end, int uz_end, int vz_end, int dx_start, int dwz_start, int duz_start, int dvz_start, int dx_end, int dwz_end, int duz_end, int dvz_end, int dwz, int duz, int dvz, int fogc, int sz2, boolean x2pixel, boolean x4pixel) {
        if (x4pixel) {
            Texturing.paintMiniTrianglePers_0_4X(g3d, texture, y_start, y_end, x_start, wz_start, uz_start, vz_start, x_end, wz_end, uz_end, vz_end, dx_start, dwz_start, duz_start, dvz_start, dx_end, dwz_end, duz_end, dvz_end, dwz, duz, dvz, fogc, sz2);
            return;
        }
        if (x2pixel) {
            Texturing.paintMiniTrianglePers_0_2X(g3d, texture, y_start, y_end, x_start, wz_start, uz_start, vz_start, x_end, wz_end, uz_end, vz_end, dx_start, dwz_start, duz_start, dvz_start, dx_end, dwz_end, duz_end, dvz_end, dwz, duz, dvz, fogc, sz2);
            return;
        }
        int[] tex = texture.rImg.img;
        int lengthBIT = tex.length - 1;
        int widthBIT = texture.widthBIT;
        int[] rgb = g3d.display;
        int duz4 = duz * sz2;
        int dvz4 = dvz * sz2;
        int dwz4 = dwz * sz2;
        for (int y = y_start; y < y_end; ++y) {
            int col;
            int dv;
            int du;
            int v_2;
            int u_2;
            int length;
            int wz_b;
            int wz_a;
            int vz_b;
            int vz_a;
            int uz_b;
            int uz_a;
            int x2;
            int x1;
            if (x_start > x_end) {
                x1 = x_end;
                x2 = x_start;
                uz_a = uz_end;
                uz_b = uz_start;
                vz_a = vz_end;
                vz_b = vz_start;
                wz_a = wz_end;
                wz_b = wz_start;
            } else {
                x1 = x_start;
                x2 = x_end;
                uz_a = uz_start;
                uz_b = uz_end;
                vz_a = vz_start;
                vz_b = vz_end;
                wz_a = wz_start;
                wz_b = wz_end;
            }
            long subtexel_a = x1 % 4096;
            long subtexel_b = x2 % 4096;
            uz_a = (int)((long)uz_a - ((long)duz * subtexel_a >> 12));
            vz_a = (int)((long)vz_a - ((long)dvz * subtexel_a >> 12));
            wz_a = (int)((long)wz_a - ((long)dwz * subtexel_a >> 12));
            uz_b = (int)((long)uz_b - ((long)duz * subtexel_b >> 12));
            vz_b = (int)((long)vz_b - ((long)dvz * subtexel_b >> 12));
            wz_b = (int)((long)wz_b - ((long)dwz * subtexel_b >> 12));
            x2 >>= 12;
            if ((x1 >>= 12) < 0) {
                uz_a -= duz * x1;
                vz_a -= dvz * x1;
                wz_a -= dwz * x1;
                x1 = 0;
            }
            if (x2 > g3d.width) {
                uz_b -= duz * (x2 -= g3d.width);
                vz_b -= dvz * x2;
                wz_b -= dwz * x2;
                x2 = g3d.width;
            }
            if (wz_a == 0) {
                return;
            }
            int tempI = y * g3d.width;
            int u = (int)(((long)uz_a << 12) / (long)wz_a);
            int v = (int)(((long)vz_a << 12) / (long)wz_a);
            for (length = (x2 += tempI) - (x1 += tempI); length >= sz2; length -= sz2) {
                u_2 = (int)(((long)(uz_a += duz4) << 12) / (long)(wz_a += dwz4));
                v_2 = (int)(((long)(vz_a += dvz4) << 12) / (long)wz_a);
                du = (u_2 - u) / sz2;
                dv = (v_2 - v) / sz2;
                int i = x1 + sz2;
                while (x1 < i) {
                    col = tex[((v += dv) >> 12 << widthBIT) + ((u += du) >> 12) & lengthBIT];
                    if (col != 0) {
                        rgb[x1] = col;
                    }
                    ++x1;
                }
            }
            if (length > 0) {
                u_2 = (int)(((long)uz_b << 12) / (long)wz_b);
                v_2 = (int)(((long)vz_b << 12) / (long)wz_b);
                du = (u_2 - u) / length;
                dv = (v_2 - v) / length;
                while (x2 - x1 >= 2) {
                    col = tex[((v += dv) >> 12 << widthBIT) + ((u += du) >> 12) & lengthBIT];
                    if (col != 0) {
                        rgb[x1] = col;
                    }
                    if ((col = tex[((v += dv) >> 12 << widthBIT) + ((u += du) >> 12) & lengthBIT]) != 0) {
                        rgb[x1 + 1] = col;
                    }
                    x1 += 2;
                }
                while (x1 < x2) {
                    col = tex[((v += dv) >> 12 << widthBIT) + ((u += du) >> 12) & lengthBIT];
                    if (col != 0) {
                        rgb[x1] = col;
                    }
                    ++x1;
                }
            }
            x_start += dx_start;
            wz_start += dwz_start;
            uz_start += duz_start;
            vz_start += dvz_start;
            x_end += dx_end;
            wz_end += dwz_end;
            uz_end += duz_end;
            vz_end += dvz_end;
        }
    }

    static final void paintMiniTrianglePers_0_2X(Graphics3D g3d, Texture texture, int y_start, int y_end, int x_start, int wz_start, int uz_start, int vz_start, int x_end, int wz_end, int uz_end, int vz_end, int dx_start, int dwz_start, int duz_start, int dvz_start, int dx_end, int dwz_end, int duz_end, int dvz_end, int dwz, int duz, int dvz, int fogc, int sz2) {
        int[] tex = texture.rImg.img;
        int lengthBIT = tex.length - 1;
        int widthBIT = texture.widthBIT;
        int[] rgb = g3d.display;
        int duz4 = duz * sz2;
        int dvz4 = dvz * sz2;
        int dwz4 = dwz * sz2;
        for (int y = y_start; y < y_end; ++y) {
            int col;
            int dv;
            int du;
            int v_2;
            int u_2;
            int length;
            int wz_b;
            int wz_a;
            int vz_b;
            int vz_a;
            int uz_b;
            int uz_a;
            int x2;
            int x1;
            if (x_start > x_end) {
                x1 = x_end;
                x2 = x_start;
                uz_a = uz_end;
                uz_b = uz_start;
                vz_a = vz_end;
                vz_b = vz_start;
                wz_a = wz_end;
                wz_b = wz_start;
            } else {
                x1 = x_start;
                x2 = x_end;
                uz_a = uz_start;
                uz_b = uz_end;
                vz_a = vz_start;
                vz_b = vz_end;
                wz_a = wz_start;
                wz_b = wz_end;
            }
            long subtexel_a = x1 % 4096;
            long subtexel_b = x2 % 4096;
            uz_a = (int)((long)uz_a - ((long)duz * subtexel_a >> 12));
            vz_a = (int)((long)vz_a - ((long)dvz * subtexel_a >> 12));
            wz_a = (int)((long)wz_a - ((long)dwz * subtexel_a >> 12));
            uz_b = (int)((long)uz_b - ((long)duz * subtexel_b >> 12));
            vz_b = (int)((long)vz_b - ((long)dvz * subtexel_b >> 12));
            wz_b = (int)((long)wz_b - ((long)dwz * subtexel_b >> 12));
            x2 >>= 12;
            if ((x1 >>= 12) < 0) {
                uz_a -= duz * x1;
                vz_a -= dvz * x1;
                wz_a -= dwz * x1;
                x1 = 0;
            }
            if (x2 > g3d.width) {
                uz_b -= duz * (x2 -= g3d.width);
                vz_b -= dvz * x2;
                wz_b -= dwz * x2;
                x2 = g3d.width;
            }
            int tempI = y * g3d.width;
            if (wz_a == 0) {
                return;
            }
            int u = (int)(((long)uz_a << 12) / (long)wz_a);
            int v = (int)(((long)vz_a << 12) / (long)wz_a);
            for (length = (x2 += tempI) - (x1 += tempI); length >= sz2; length -= sz2) {
                u_2 = (int)(((long)(uz_a += duz4) << 12) / (long)(wz_a += dwz4));
                v_2 = (int)(((long)(vz_a += dvz4) << 12) / (long)wz_a);
                du = (u_2 - u) / sz2;
                dv = (v_2 - v) / sz2;
                int i = x1 + sz2;
                while (x1 < i && x1 % 2 != 0) {
                    col = tex[((v += dv) >> 12 << widthBIT) + ((u += du) >> 12) & lengthBIT];
                    if (col != 0) {
                        rgb[x1] = col;
                    }
                    ++x1;
                }
                while (i - x1 >= 2) {
                    col = tex[((v += dv) >> 12 << widthBIT) + ((u += du) >> 12) & lengthBIT];
                    if (col != 0) {
                        rgb[x1] = col;
                        rgb[x1 + 1] = col;
                    }
                    u += du;
                    v += dv;
                    x1 += 2;
                }
                while (x1 < i) {
                    col = tex[((v += dv) >> 12 << widthBIT) + ((u += du) >> 12) & lengthBIT];
                    if (col != 0) {
                        rgb[x1] = col;
                    }
                    ++x1;
                }
            }
            if (length > 0) {
                u_2 = (int)(((long)uz_b << 12) / (long)wz_b);
                v_2 = (int)(((long)vz_b << 12) / (long)wz_b);
                du = (u_2 - u) / length;
                dv = (v_2 - v) / length;
                while (x1 < x2 && x1 % 2 != 0) {
                    col = tex[((v += dv) >> 12 << widthBIT) + ((u += du) >> 12) & lengthBIT];
                    if (col != 0) {
                        rgb[x1] = col;
                    }
                    ++x1;
                }
                while (x2 - x1 >= 2) {
                    col = tex[((v += dv) >> 12 << widthBIT) + ((u += du) >> 12) & lengthBIT];
                    if (col != 0) {
                        rgb[x1] = col;
                        rgb[x1 + 1] = col;
                    }
                    u += du;
                    v += dv;
                    x1 += 2;
                }
                while (x1 < x2) {
                    col = tex[((v += dv) >> 12 << widthBIT) + ((u += du) >> 12) & lengthBIT];
                    if (col != 0) {
                        rgb[x1] = col;
                    }
                    ++x1;
                }
            }
            x_start += dx_start;
            wz_start += dwz_start;
            uz_start += duz_start;
            vz_start += dvz_start;
            x_end += dx_end;
            wz_end += dwz_end;
            uz_end += duz_end;
            vz_end += dvz_end;
        }
    }

    static final void paintMiniTrianglePers_0_4X(Graphics3D g3d, Texture texture, int y_start, int y_end, int x_start, int wz_start, int uz_start, int vz_start, int x_end, int wz_end, int uz_end, int vz_end, int dx_start, int dwz_start, int duz_start, int dvz_start, int dx_end, int dwz_end, int duz_end, int dvz_end, int dwz, int duz, int dvz, int fogc, int sz2) {
        int[] tex = texture.rImg.img;
        int lengthBIT = tex.length - 1;
        int widthBIT = texture.widthBIT;
        int[] rgb = g3d.display;
        int duz4 = duz * sz2;
        int dvz4 = dvz * sz2;
        int dwz4 = dwz * sz2;
        for (int y = y_start; y < y_end; ++y) {
            int col;
            int dv;
            int du;
            int v_2;
            int u_2;
            int length;
            int wz_b;
            int wz_a;
            int vz_b;
            int vz_a;
            int uz_b;
            int uz_a;
            int x2;
            int x1;
            if (x_start > x_end) {
                x1 = x_end;
                x2 = x_start;
                uz_a = uz_end;
                uz_b = uz_start;
                vz_a = vz_end;
                vz_b = vz_start;
                wz_a = wz_end;
                wz_b = wz_start;
            } else {
                x1 = x_start;
                x2 = x_end;
                uz_a = uz_start;
                uz_b = uz_end;
                vz_a = vz_start;
                vz_b = vz_end;
                wz_a = wz_start;
                wz_b = wz_end;
            }
            long subtexel_a = x1 % 4096;
            long subtexel_b = x2 % 4096;
            uz_a = (int)((long)uz_a - ((long)duz * subtexel_a >> 12));
            vz_a = (int)((long)vz_a - ((long)dvz * subtexel_a >> 12));
            wz_a = (int)((long)wz_a - ((long)dwz * subtexel_a >> 12));
            uz_b = (int)((long)uz_b - ((long)duz * subtexel_b >> 12));
            vz_b = (int)((long)vz_b - ((long)dvz * subtexel_b >> 12));
            wz_b = (int)((long)wz_b - ((long)dwz * subtexel_b >> 12));
            x2 >>= 12;
            if ((x1 >>= 12) < 0) {
                uz_a -= duz * x1;
                vz_a -= dvz * x1;
                wz_a -= dwz * x1;
                x1 = 0;
            }
            if (x2 > g3d.width) {
                uz_b -= duz * (x2 -= g3d.width);
                vz_b -= dvz * x2;
                wz_b -= dwz * x2;
                x2 = g3d.width;
            }
            int tempI = y * g3d.width;
            if (wz_a == 0) {
                return;
            }
            int u = (int)(((long)uz_a << 12) / (long)wz_a);
            int v = (int)(((long)vz_a << 12) / (long)wz_a);
            for (length = (x2 += tempI) - (x1 += tempI); length >= sz2; length -= sz2) {
                u_2 = (int)(((long)(uz_a += duz4) << 12) / (long)(wz_a += dwz4));
                v_2 = (int)(((long)(vz_a += dvz4) << 12) / (long)wz_a);
                du = (u_2 - u) / sz2;
                dv = (v_2 - v) / sz2;
                int i = x1 + sz2;
                while (x1 < i && x1 % 4 != 0) {
                    col = tex[((v += dv) >> 12 << widthBIT) + ((u += du) >> 12) & lengthBIT];
                    if (col != 0) {
                        rgb[x1] = col;
                    }
                    ++x1;
                }
                while (i - x1 >= 4) {
                    col = tex[((v += dv) >> 12 << widthBIT) + ((u += du) >> 12) & lengthBIT];
                    if (col != 0) {
                        rgb[x1] = col;
                        rgb[x1 + 1] = col;
                        rgb[x1 + 2] = col;
                        rgb[x1 + 3] = col;
                    }
                    u += du * 3;
                    v += dv * 3;
                    x1 += 4;
                }
                while (x1 < i) {
                    col = tex[((v += dv) >> 12 << widthBIT) + ((u += du) >> 12) & lengthBIT];
                    if (col != 0) {
                        rgb[x1] = col;
                    }
                    ++x1;
                }
            }
            if (length > 0) {
                u_2 = (int)(((long)uz_b << 12) / (long)wz_b);
                v_2 = (int)(((long)vz_b << 12) / (long)wz_b);
                du = (u_2 - u) / length;
                dv = (v_2 - v) / length;
                while (x1 < x2 && x1 % 4 != 0) {
                    col = tex[((v += dv) >> 12 << widthBIT) + ((u += du) >> 12) & lengthBIT];
                    if (col != 0) {
                        rgb[x1] = col;
                    }
                    ++x1;
                }
                while (x2 - x1 >= 4) {
                    col = tex[((v += dv) >> 12 << widthBIT) + ((u += du) >> 12) & lengthBIT];
                    if (col != 0) {
                        rgb[x1] = col;
                        rgb[x1 + 1] = col;
                        rgb[x1 + 2] = col;
                        rgb[x1 + 3] = col;
                    }
                    u += du * 3;
                    v += dv * 3;
                    x1 += 4;
                }
                while (x1 < x2) {
                    col = tex[((v += dv) >> 12 << widthBIT) + ((u += du) >> 12) & lengthBIT];
                    if (col != 0) {
                        rgb[x1] = col;
                    }
                    ++x1;
                }
            }
            x_start += dx_start;
            wz_start += dwz_start;
            uz_start += duz_start;
            vz_start += dvz_start;
            x_end += dx_end;
            wz_end += dwz_end;
            uz_end += duz_end;
            vz_end += dvz_end;
        }
    }

    static final void paintMiniTrianglePers_1(Graphics3D g3d, Texture texture, int y_start, int y_end, int x_start, int wz_start, int uz_start, int vz_start, int x_end, int wz_end, int uz_end, int vz_end, int dx_start, int dwz_start, int duz_start, int dvz_start, int dx_end, int dwz_end, int duz_end, int dvz_end, int dwz, int duz, int dvz, int fogc, int sz2, int q, boolean x2pixel, boolean x4pixel) {
        if (Main.fogQ == 0) {
            Texturing.paintMiniTrianglePers_0(g3d, texture, y_start, y_end, x_start, wz_start, uz_start, vz_start, x_end, wz_end, uz_end, vz_end, dx_start, dwz_start, duz_start, dvz_start, dx_end, dwz_end, duz_end, dvz_end, dwz, duz, dvz, fogc, q, x2pixel, x4pixel);
            return;
        }
        if (x4pixel) {
            Texturing.paintMiniTrianglePers_1_4X(g3d, texture, y_start, y_end, x_start, wz_start, uz_start, vz_start, x_end, wz_end, uz_end, vz_end, dx_start, dwz_start, duz_start, dvz_start, dx_end, dwz_end, duz_end, dvz_end, dwz, duz, dvz, fogc, sz2, q);
            return;
        }
        if (x2pixel) {
            Texturing.paintMiniTrianglePers_1_2X(g3d, texture, y_start, y_end, x_start, wz_start, uz_start, vz_start, x_end, wz_end, uz_end, vz_end, dx_start, dwz_start, duz_start, dvz_start, dx_end, dwz_end, duz_end, dvz_end, dwz, duz, dvz, fogc, sz2, q);
            return;
        }
        int[] tex = texture.rImg.img;
        int lengthBIT = tex.length - 1;
        int widthBIT = texture.widthBIT;
        int[] rgb = g3d.display;
        int duz4 = duz * q;
        int dvz4 = dvz * q;
        int dwz4 = dwz * q;
        int colf = sz2 & 0xFEFEFE;
        for (int y = y_start; y < y_end; ++y) {
            int col;
            int dv;
            int du;
            int v_2;
            int u_2;
            int length;
            int wz_b;
            int wz_a;
            int vz_b;
            int vz_a;
            int uz_b;
            int uz_a;
            int x2;
            int x1;
            if (x_start > x_end) {
                x1 = x_end;
                x2 = x_start;
                uz_a = uz_end;
                uz_b = uz_start;
                vz_a = vz_end;
                vz_b = vz_start;
                wz_a = wz_end;
                wz_b = wz_start;
            } else {
                x1 = x_start;
                x2 = x_end;
                uz_a = uz_start;
                uz_b = uz_end;
                vz_a = vz_start;
                vz_b = vz_end;
                wz_a = wz_start;
                wz_b = wz_end;
            }
            long subtexel_a = x1 % 4096;
            long subtexel_b = x2 % 4096;
            uz_a = (int)((long)uz_a - ((long)duz * subtexel_a >> 12));
            vz_a = (int)((long)vz_a - ((long)dvz * subtexel_a >> 12));
            wz_a = (int)((long)wz_a - ((long)dwz * subtexel_a >> 12));
            uz_b = (int)((long)uz_b - ((long)duz * subtexel_b >> 12));
            vz_b = (int)((long)vz_b - ((long)dvz * subtexel_b >> 12));
            wz_b = (int)((long)wz_b - ((long)dwz * subtexel_b >> 12));
            x2 >>= 12;
            if ((x1 >>= 12) < 0) {
                uz_a -= duz * x1;
                vz_a -= dvz * x1;
                wz_a -= dwz * x1;
                x1 = 0;
            }
            if (x2 > g3d.width) {
                uz_b -= duz * (x2 -= g3d.width);
                vz_b -= dvz * x2;
                wz_b -= dwz * x2;
                x2 = g3d.width;
            }
            int tempI = y * g3d.width;
            if (wz_a == 0) {
                return;
            }
            int u = (int)(((long)uz_a << 12) / (long)wz_a);
            int v = (int)(((long)vz_a << 12) / (long)wz_a);
            for (length = (x2 += tempI) - (x1 += tempI); length >= q; length -= q) {
                u_2 = (int)(((long)(uz_a += duz4) << 12) / (long)(wz_a += dwz4));
                v_2 = (int)(((long)(vz_a += dvz4) << 12) / (long)wz_a);
                du = (u_2 - u) / q;
                dv = (v_2 - v) / q;
                int i = x1 + q;
                while (x1 < i) {
                    col = tex[((v += dv) >> 12 << widthBIT) + ((u += du) >> 12) & lengthBIT];
                    if (col != 0) {
                        col = (col & 0xFEFEFE) + colf;
                        rgb[x1] = col | (col >> 8 & 0x10101) * 255;
                    }
                    ++x1;
                }
            }
            if (length > 0) {
                u_2 = (int)(((long)uz_b << 12) / (long)wz_b);
                v_2 = (int)(((long)vz_b << 12) / (long)wz_b);
                du = (u_2 - u) / length;
                dv = (v_2 - v) / length;
                while (x1 < x2) {
                    col = tex[((v += dv) >> 12 << widthBIT) + ((u += du) >> 12) & lengthBIT];
                    if (col != 0) {
                        col = (col & 0xFEFEFE) + colf;
                        rgb[x1] = col | (col >> 8 & 0x10101) * 255;
                    }
                    ++x1;
                }
            }
            x_start += dx_start;
            wz_start += dwz_start;
            uz_start += duz_start;
            vz_start += dvz_start;
            x_end += dx_end;
            wz_end += dwz_end;
            uz_end += duz_end;
            vz_end += dvz_end;
        }
    }

    static final void paintMiniTrianglePers_1_2X(Graphics3D g3d, Texture texture, int y_start, int y_end, int x_start, int wz_start, int uz_start, int vz_start, int x_end, int wz_end, int uz_end, int vz_end, int dx_start, int dwz_start, int duz_start, int dvz_start, int dx_end, int dwz_end, int duz_end, int dvz_end, int dwz, int duz, int dvz, int fogc, int sz2, int q) {
        int[] tex = texture.rImg.img;
        int lengthBIT = tex.length - 1;
        int widthBIT = texture.widthBIT;
        int[] rgb = g3d.display;
        int duz4 = duz * q;
        int dvz4 = dvz * q;
        int dwz4 = dwz * q;
        int colf = sz2 & 0xFEFEFE;
        for (int y = y_start; y < y_end; ++y) {
            int col;
            int dv;
            int du;
            int v_2;
            int u_2;
            int length;
            int wz_b;
            int wz_a;
            int vz_b;
            int vz_a;
            int uz_b;
            int uz_a;
            int x2;
            int x1;
            if (x_start > x_end) {
                x1 = x_end;
                x2 = x_start;
                uz_a = uz_end;
                uz_b = uz_start;
                vz_a = vz_end;
                vz_b = vz_start;
                wz_a = wz_end;
                wz_b = wz_start;
            } else {
                x1 = x_start;
                x2 = x_end;
                uz_a = uz_start;
                uz_b = uz_end;
                vz_a = vz_start;
                vz_b = vz_end;
                wz_a = wz_start;
                wz_b = wz_end;
            }
            long subtexel_a = x1 % 4096;
            long subtexel_b = x2 % 4096;
            uz_a = (int)((long)uz_a - ((long)duz * subtexel_a >> 12));
            vz_a = (int)((long)vz_a - ((long)dvz * subtexel_a >> 12));
            wz_a = (int)((long)wz_a - ((long)dwz * subtexel_a >> 12));
            uz_b = (int)((long)uz_b - ((long)duz * subtexel_b >> 12));
            vz_b = (int)((long)vz_b - ((long)dvz * subtexel_b >> 12));
            wz_b = (int)((long)wz_b - ((long)dwz * subtexel_b >> 12));
            x2 >>= 12;
            if ((x1 >>= 12) < 0) {
                uz_a -= duz * x1;
                vz_a -= dvz * x1;
                wz_a -= dwz * x1;
                x1 = 0;
            }
            if (x2 > g3d.width) {
                uz_b -= duz * (x2 -= g3d.width);
                vz_b -= dvz * x2;
                wz_b -= dwz * x2;
                x2 = g3d.width;
            }
            int tempI = y * g3d.width;
            if (wz_a == 0) {
                return;
            }
            int u = (int)(((long)uz_a << 12) / (long)wz_a);
            int v = (int)(((long)vz_a << 12) / (long)wz_a);
            for (length = (x2 += tempI) - (x1 += tempI); length >= q; length -= q) {
                u_2 = (int)(((long)(uz_a += duz4) << 12) / (long)(wz_a += dwz4));
                v_2 = (int)(((long)(vz_a += dvz4) << 12) / (long)wz_a);
                du = (u_2 - u) / q;
                dv = (v_2 - v) / q;
                int i = x1 + q;
                while (x1 < i && x1 % 2 != 0) {
                    col = tex[((v += dv) >> 12 << widthBIT) + ((u += du) >> 12) & lengthBIT];
                    if (col != 0) {
                        col = (col & 0xFEFEFE) + colf;
                        rgb[x1] = col | (col >> 8 & 0x10101) * 255;
                    }
                    ++x1;
                }
                while (i - x1 >= 2) {
                    col = tex[((v += dv) >> 12 << widthBIT) + ((u += du) >> 12) & lengthBIT];
                    if (col != 0) {
                        col = (col & 0xFEFEFE) + colf;
                        col |= (col >> 8 & 0x10101) * 255;
                        rgb[x1] = col;
                        rgb[x1 + 1] = col;
                    }
                    u += du;
                    v += dv;
                    x1 += 2;
                }
                while (x1 < i) {
                    col = tex[((v += dv) >> 12 << widthBIT) + ((u += du) >> 12) & lengthBIT];
                    if (col != 0) {
                        col = (col & 0xFEFEFE) + colf;
                        rgb[x1] = col | (col >> 8 & 0x10101) * 255;
                    }
                    ++x1;
                }
            }
            if (length > 0) {
                u_2 = (int)(((long)uz_b << 12) / (long)wz_b);
                v_2 = (int)(((long)vz_b << 12) / (long)wz_b);
                du = (u_2 - u) / length;
                dv = (v_2 - v) / length;
                while (x1 < x2 && x1 % 2 != 0) {
                    col = tex[((v += dv) >> 12 << widthBIT) + ((u += du) >> 12) & lengthBIT];
                    if (col != 0) {
                        col = (col & 0xFEFEFE) + colf;
                        rgb[x1] = col | (col >> 8 & 0x10101) * 255;
                    }
                    ++x1;
                }
                while (x2 - x1 >= 2) {
                    col = tex[((v += dv) >> 12 << widthBIT) + ((u += du) >> 12) & lengthBIT];
                    if (col != 0) {
                        col = (col & 0xFEFEFE) + colf;
                        col |= (col >> 8 & 0x10101) * 255;
                        rgb[x1] = col;
                        rgb[x1 + 1] = col;
                    }
                    u += du;
                    v += dv;
                    x1 += 2;
                }
                while (x1 < x2) {
                    col = tex[((v += dv) >> 12 << widthBIT) + ((u += du) >> 12) & lengthBIT];
                    if (col != 0) {
                        col = (col & 0xFEFEFE) + colf;
                        rgb[x1] = col | (col >> 8 & 0x10101) * 255;
                    }
                    ++x1;
                }
            }
            x_start += dx_start;
            wz_start += dwz_start;
            uz_start += duz_start;
            vz_start += dvz_start;
            x_end += dx_end;
            wz_end += dwz_end;
            uz_end += duz_end;
            vz_end += dvz_end;
        }
    }

    static final void paintMiniTrianglePers_1_4X(Graphics3D g3d, Texture texture, int y_start, int y_end, int x_start, int wz_start, int uz_start, int vz_start, int x_end, int wz_end, int uz_end, int vz_end, int dx_start, int dwz_start, int duz_start, int dvz_start, int dx_end, int dwz_end, int duz_end, int dvz_end, int dwz, int duz, int dvz, int fogc, int sz2, int q) {
        int[] tex = texture.rImg.img;
        int lengthBIT = tex.length - 1;
        int widthBIT = texture.widthBIT;
        int[] rgb = g3d.display;
        int duz4 = duz * q;
        int dvz4 = dvz * q;
        int dwz4 = dwz * q;
        int colf = sz2 & 0xFEFEFE;
        for (int y = y_start; y < y_end; ++y) {
            int col;
            int dv;
            int du;
            int v_2;
            int u_2;
            int length;
            int wz_b;
            int wz_a;
            int vz_b;
            int vz_a;
            int uz_b;
            int uz_a;
            int x2;
            int x1;
            if (x_start > x_end) {
                x1 = x_end;
                x2 = x_start;
                uz_a = uz_end;
                uz_b = uz_start;
                vz_a = vz_end;
                vz_b = vz_start;
                wz_a = wz_end;
                wz_b = wz_start;
            } else {
                x1 = x_start;
                x2 = x_end;
                uz_a = uz_start;
                uz_b = uz_end;
                vz_a = vz_start;
                vz_b = vz_end;
                wz_a = wz_start;
                wz_b = wz_end;
            }
            long subtexel_a = x1 % 4096;
            long subtexel_b = x2 % 4096;
            uz_a = (int)((long)uz_a - ((long)duz * subtexel_a >> 12));
            vz_a = (int)((long)vz_a - ((long)dvz * subtexel_a >> 12));
            wz_a = (int)((long)wz_a - ((long)dwz * subtexel_a >> 12));
            uz_b = (int)((long)uz_b - ((long)duz * subtexel_b >> 12));
            vz_b = (int)((long)vz_b - ((long)dvz * subtexel_b >> 12));
            wz_b = (int)((long)wz_b - ((long)dwz * subtexel_b >> 12));
            x2 >>= 12;
            if ((x1 >>= 12) < 0) {
                uz_a -= duz * x1;
                vz_a -= dvz * x1;
                wz_a -= dwz * x1;
                x1 = 0;
            }
            if (x2 > g3d.width) {
                uz_b -= duz * (x2 -= g3d.width);
                vz_b -= dvz * x2;
                wz_b -= dwz * x2;
                x2 = g3d.width;
            }
            int tempI = y * g3d.width;
            if (wz_a == 0) {
                return;
            }
            int u = (int)(((long)uz_a << 12) / (long)wz_a);
            int v = (int)(((long)vz_a << 12) / (long)wz_a);
            for (length = (x2 += tempI) - (x1 += tempI); length >= q; length -= q) {
                u_2 = (int)(((long)(uz_a += duz4) << 12) / (long)(wz_a += dwz4));
                v_2 = (int)(((long)(vz_a += dvz4) << 12) / (long)wz_a);
                du = (u_2 - u) / q;
                dv = (v_2 - v) / q;
                int i = x1 + q;
                while (x1 < i && x1 % 4 != 0) {
                    col = tex[((v += dv) >> 12 << widthBIT) + ((u += du) >> 12) & lengthBIT];
                    if (col != 0) {
                        col = (col & 0xFEFEFE) + colf;
                        rgb[x1] = col | (col >> 8 & 0x10101) * 255;
                    }
                    ++x1;
                }
                while (i - x1 >= 4) {
                    col = tex[((v += dv) >> 12 << widthBIT) + ((u += du) >> 12) & lengthBIT];
                    if (col != 0) {
                        col = (col & 0xFEFEFE) + colf;
                        col |= (col >> 8 & 0x10101) * 255;
                        rgb[x1] = col;
                        rgb[x1 + 1] = col;
                        rgb[x1 + 2] = col;
                        rgb[x1 + 3] = col;
                    }
                    u += du * 3;
                    v += dv * 3;
                    x1 += 4;
                }
                while (x1 < i) {
                    col = tex[((v += dv) >> 12 << widthBIT) + ((u += du) >> 12) & lengthBIT];
                    if (col != 0) {
                        col = (col & 0xFEFEFE) + colf;
                        rgb[x1] = col | (col >> 8 & 0x10101) * 255;
                    }
                    ++x1;
                }
            }
            if (length > 0) {
                u_2 = (int)(((long)uz_b << 12) / (long)wz_b);
                v_2 = (int)(((long)vz_b << 12) / (long)wz_b);
                du = (u_2 - u) / length;
                dv = (v_2 - v) / length;
                while (x1 < x2 && x1 % 4 != 0) {
                    col = tex[((v += dv) >> 12 << widthBIT) + ((u += du) >> 12) & lengthBIT];
                    if (col != 0) {
                        col = (col & 0xFEFEFE) + colf;
                        rgb[x1] = col | (col >> 8 & 0x10101) * 255;
                    }
                    ++x1;
                }
                while (x2 - x1 >= 4) {
                    col = tex[((v += dv) >> 12 << widthBIT) + ((u += du) >> 12) & lengthBIT];
                    if (col != 0) {
                        col = (col & 0xFEFEFE) + colf;
                        col |= (col >> 8 & 0x10101) * 255;
                        rgb[x1] = col;
                        rgb[x1 + 1] = col;
                        rgb[x1 + 2] = col;
                        rgb[x1 + 3] = col;
                    }
                    u += du * 3;
                    v += dv * 3;
                    x1 += 4;
                }
                while (x1 < x2) {
                    col = tex[((v += dv) >> 12 << widthBIT) + ((u += du) >> 12) & lengthBIT];
                    if (col != 0) {
                        col = (col & 0xFEFEFE) + colf;
                        rgb[x1] = col | (col >> 8 & 0x10101) * 255;
                    }
                    ++x1;
                }
            }
            x_start += dx_start;
            wz_start += dwz_start;
            uz_start += duz_start;
            vz_start += dvz_start;
            x_end += dx_end;
            wz_end += dwz_end;
            uz_end += duz_end;
            vz_end += dvz_end;
        }
    }

    static final void paintMiniTrianglePers_2(Graphics3D g3d, Texture texture, int y_start, int y_end, int x_start, int wz_start, int uz_start, int vz_start, int x_end, int wz_end, int uz_end, int vz_end, int dx_start, int dwz_start, int duz_start, int dvz_start, int dx_end, int dwz_end, int duz_end, int dvz_end, int dwz, int duz, int dvz, int fogc, int sz2) {
        int[] tex = texture.rImg.img;
        int lengthBIT = tex.length - 1;
        int widthBIT = texture.widthBIT;
        int[] rgb = g3d.display;
        int duz4 = duz * sz2;
        int dvz4 = dvz * sz2;
        int dwz4 = dwz * sz2;
        for (int y = y_start; y < y_end; ++y) {
            int col;
            int dv;
            int du;
            int v_2;
            int u_2;
            int length;
            int wz_b;
            int wz_a;
            int vz_b;
            int vz_a;
            int uz_b;
            int uz_a;
            int x2;
            int x1;
            if (x_start > x_end) {
                x1 = x_end;
                x2 = x_start;
                uz_a = uz_end;
                uz_b = uz_start;
                vz_a = vz_end;
                vz_b = vz_start;
                wz_a = wz_end;
                wz_b = wz_start;
            } else {
                x1 = x_start;
                x2 = x_end;
                uz_a = uz_start;
                uz_b = uz_end;
                vz_a = vz_start;
                vz_b = vz_end;
                wz_a = wz_start;
                wz_b = wz_end;
            }
            long subtexel_a = x1 % 4096;
            long subtexel_b = x2 % 4096;
            uz_a = (int)((long)uz_a - ((long)duz * subtexel_a >> 12));
            vz_a = (int)((long)vz_a - ((long)dvz * subtexel_a >> 12));
            wz_a = (int)((long)wz_a - ((long)dwz * subtexel_a >> 12));
            uz_b = (int)((long)uz_b - ((long)duz * subtexel_b >> 12));
            vz_b = (int)((long)vz_b - ((long)dvz * subtexel_b >> 12));
            wz_b = (int)((long)wz_b - ((long)dwz * subtexel_b >> 12));
            x2 >>= 12;
            if ((x1 >>= 12) < 0) {
                uz_a -= duz * x1;
                vz_a -= dvz * x1;
                wz_a -= dwz * x1;
                x1 = 0;
            }
            if (x2 > g3d.width) {
                uz_b -= duz * (x2 -= g3d.width);
                vz_b -= dvz * x2;
                wz_b -= dwz * x2;
                x2 = g3d.width;
            }
            int tempI = y * g3d.width;
            if (wz_a == 0) {
                return;
            }
            int u = (int)(((long)uz_a << 12) / (long)wz_a);
            int v = (int)(((long)vz_a << 12) / (long)wz_a);
            for (length = (x2 += tempI) - (x1 += tempI); length >= sz2; length -= sz2) {
                u_2 = (int)(((long)(uz_a += duz4) << 12) / (long)(wz_a += dwz4));
                v_2 = (int)(((long)(vz_a += dvz4) << 12) / (long)wz_a);
                du = (u_2 - u) / sz2;
                dv = (v_2 - v) / sz2;
                int i = x1 + sz2;
                while (x1 < i) {
                    col = tex[((v += dv) >> 12 << widthBIT) + ((u += du) >> 12) & lengthBIT];
                    if (col != 0) {
                        col = (col & 0xFEFEFE) + (rgb[x1] & 0xFEFEFE);
                        rgb[x1] = col | (col >> 8 & 0x10101) * 255;
                    }
                    ++x1;
                }
            }
            if (length > 0) {
                u_2 = (int)(((long)uz_b << 12) / (long)wz_b);
                v_2 = (int)(((long)vz_b << 12) / (long)wz_b);
                du = (u_2 - u) / length;
                dv = (v_2 - v) / length;
                while (x1 < x2) {
                    col = tex[((v += dv) >> 12 << widthBIT) + ((u += du) >> 12) & lengthBIT];
                    if (col != 0) {
                        col = (col & 0xFEFEFE) + (rgb[x1] & 0xFEFEFE);
                        rgb[x1] = col | (col >> 8 & 0x10101) * 255;
                    }
                    ++x1;
                }
            }
            x_start += dx_start;
            wz_start += dwz_start;
            uz_start += duz_start;
            vz_start += dvz_start;
            x_end += dx_end;
            wz_end += dwz_end;
            uz_end += duz_end;
            vz_end += dvz_end;
        }
    }

    static final void paintMiniTrianglePers_3(Graphics3D g3d, Texture texture, int y_start, int y_end, int x_start, int wz_start, int uz_start, int vz_start, int x_end, int wz_end, int uz_end, int vz_end, int dx_start, int dwz_start, int duz_start, int dvz_start, int dx_end, int dwz_end, int duz_end, int dvz_end, int dwz, int duz, int dvz, int fogc, int sz2, int q, Vertex a, Vertex b, Vertex c, boolean x2pixel, boolean x4pixel, int f_start, int f_end, int df_start, int df_end, int df) {
        if (Main.fogQ == 2 && !Main.forceLQFog) {
            if (x4pixel) {
                Texturing.paintMiniTrianglePers_3_HQ_4X(g3d, texture, y_start, y_end, x_start, wz_start, uz_start, vz_start, x_end, wz_end, uz_end, vz_end, dx_start, dwz_start, duz_start, dvz_start, dx_end, dwz_end, duz_end, dvz_end, dwz, duz, dvz, fogc, sz2, q, a, b, c, f_start, f_end, df_start, df_end, df);
                return;
            }
            if (x2pixel) {
                Texturing.paintMiniTrianglePers_3_HQ_2X(g3d, texture, y_start, y_end, x_start, wz_start, uz_start, vz_start, x_end, wz_end, uz_end, vz_end, dx_start, dwz_start, duz_start, dvz_start, dx_end, dwz_end, duz_end, dvz_end, dwz, duz, dvz, fogc, sz2, q, a, b, c, f_start, f_end, df_start, df_end, df);
                return;
            }
            Texturing.paintMiniTrianglePers_3_HQ(g3d, texture, y_start, y_end, x_start, wz_start, uz_start, vz_start, x_end, wz_end, uz_end, vz_end, dx_start, dwz_start, duz_start, dvz_start, dx_end, dwz_end, duz_end, dvz_end, dwz, duz, dvz, fogc, sz2, q, a, b, c, f_start, f_end, df_start, df_end, df);
            return;
        }
        if (Main.fogQ == 0) {
            Texturing.paintMiniTrianglePers_0(g3d, texture, y_start, y_end, x_start, wz_start, uz_start, vz_start, x_end, wz_end, uz_end, vz_end, dx_start, dwz_start, duz_start, dvz_start, dx_end, dwz_end, duz_end, dvz_end, dwz, duz, dvz, fogc, q, x2pixel, x4pixel);
            return;
        }
        if (x4pixel) {
            Texturing.paintMiniTrianglePers_3_4X(g3d, texture, y_start, y_end, x_start, wz_start, uz_start, vz_start, x_end, wz_end, uz_end, vz_end, dx_start, dwz_start, duz_start, dvz_start, dx_end, dwz_end, duz_end, dvz_end, dwz, duz, dvz, fogc, sz2, q, a, b, c);
            return;
        }
        if (x2pixel) {
            Texturing.paintMiniTrianglePers_3_2X(g3d, texture, y_start, y_end, x_start, wz_start, uz_start, vz_start, x_end, wz_end, uz_end, vz_end, dx_start, dwz_start, duz_start, dvz_start, dx_end, dwz_end, duz_end, dvz_end, dwz, duz, dvz, fogc, sz2, q, a, b, c);
            return;
        }
        int[] tex = texture.rImg.img;
        int lengthBIT = tex.length - 1;
        int widthBIT = texture.widthBIT;
        int[] rgb = g3d.display;
        int duz4 = duz * q;
        int dvz4 = dvz * q;
        int dwz4 = dwz * q;
        if (Graphics3D.fDist / 255 != 0) {
            sz2 = -Texturing.max(a.rz, b.rz, c.rz) / (Graphics3D.fDist / 255);
        }
        if (sz2 > 255) {
            sz2 = 255;
        }
        if (sz2 < 0) {
            sz2 = 0;
        }
        int isz2 = 255 - sz2;
        int f2 = (fogc & 0xFF00FF) * sz2;
        int f22 = (fogc & 0xFF00) * sz2;
        for (int y = y_start; y < y_end; ++y) {
            int col;
            int dv;
            int du;
            int v_2;
            int u_2;
            int length;
            int wz_b;
            int wz_a;
            int vz_b;
            int vz_a;
            int uz_b;
            int uz_a;
            int x2;
            int x1;
            if (x_start > x_end) {
                x1 = x_end;
                x2 = x_start;
                uz_a = uz_end;
                uz_b = uz_start;
                vz_a = vz_end;
                vz_b = vz_start;
                wz_a = wz_end;
                wz_b = wz_start;
            } else {
                x1 = x_start;
                x2 = x_end;
                uz_a = uz_start;
                uz_b = uz_end;
                vz_a = vz_start;
                vz_b = vz_end;
                wz_a = wz_start;
                wz_b = wz_end;
            }
            long subtexel_a = x1 % 4096;
            long subtexel_b = x2 % 4096;
            uz_a = (int)((long)uz_a - ((long)duz * subtexel_a >> 12));
            vz_a = (int)((long)vz_a - ((long)dvz * subtexel_a >> 12));
            wz_a = (int)((long)wz_a - ((long)dwz * subtexel_a >> 12));
            uz_b = (int)((long)uz_b - ((long)duz * subtexel_b >> 12));
            vz_b = (int)((long)vz_b - ((long)dvz * subtexel_b >> 12));
            wz_b = (int)((long)wz_b - ((long)dwz * subtexel_b >> 12));
            x2 >>= 12;
            if ((x1 >>= 12) < 0) {
                uz_a -= duz * x1;
                vz_a -= dvz * x1;
                wz_a -= dwz * x1;
                x1 = 0;
            }
            if (x2 > g3d.width) {
                uz_b -= duz * (x2 -= g3d.width);
                vz_b -= dvz * x2;
                wz_b -= dwz * x2;
                x2 = g3d.width;
            }
            int tempI = y * g3d.width;
            if (wz_a == 0) {
                return;
            }
            int u = (int)(((long)uz_a << 12) / (long)wz_a);
            int v = (int)(((long)vz_a << 12) / (long)wz_a);
            for (length = (x2 += tempI) - (x1 += tempI); length >= q; length -= q) {
                u_2 = (int)(((long)(uz_a += duz4) << 12) / (long)(wz_a += dwz4));
                v_2 = (int)(((long)(vz_a += dvz4) << 12) / (long)wz_a);
                du = (u_2 - u) / q;
                dv = (v_2 - v) / q;
                int i = x1 + q;
                while (x1 < i) {
                    col = tex[((v += dv) >> 12 << widthBIT) + ((u += du) >> 12) & lengthBIT];
                    if (col != 0) {
                        rgb[x1] = ((col & 0xFF00FF) * isz2 + f2 & 0xFF00FF00 | (col & 0xFF00) * isz2 + f22 & 0xFF0000) >>> 8;
                    }
                    ++x1;
                }
            }
            if (length > 0) {
                u_2 = (int)(((long)uz_b << 12) / (long)wz_b);
                v_2 = (int)(((long)vz_b << 12) / (long)wz_b);
                du = (u_2 - u) / length;
                dv = (v_2 - v) / length;
                while (x1 < x2) {
                    col = tex[((v += dv) >> 12 << widthBIT) + ((u += du) >> 12) & lengthBIT];
                    if (col != 0) {
                        rgb[x1] = ((col & 0xFF00FF) * isz2 + f2 & 0xFF00FF00 | (col & 0xFF00) * isz2 + f22 & 0xFF0000) >>> 8;
                    }
                    ++x1;
                }
            }
            x_start += dx_start;
            wz_start += dwz_start;
            uz_start += duz_start;
            vz_start += dvz_start;
            x_end += dx_end;
            wz_end += dwz_end;
            uz_end += duz_end;
            vz_end += dvz_end;
        }
    }

    static final void paintMiniTrianglePers_3_2X(Graphics3D g3d, Texture texture, int y_start, int y_end, int x_start, int wz_start, int uz_start, int vz_start, int x_end, int wz_end, int uz_end, int vz_end, int dx_start, int dwz_start, int duz_start, int dvz_start, int dx_end, int dwz_end, int duz_end, int dvz_end, int dwz, int duz, int dvz, int fogc, int sz2, int q, Vertex a, Vertex b, Vertex c) {
        int[] tex = texture.rImg.img;
        int lengthBIT = tex.length - 1;
        int widthBIT = texture.widthBIT;
        int[] rgb = g3d.display;
        int duz4 = duz * q;
        int dvz4 = dvz * q;
        int dwz4 = dwz * q;
        if (Graphics3D.fDist / 255 != 0) {
            sz2 = -Texturing.max(a.rz, b.rz, c.rz) / (Graphics3D.fDist / 255);
        }
        if (sz2 > 255) {
            sz2 = 255;
        }
        if (sz2 < 0) {
            sz2 = 0;
        }
        int isz2 = 255 - sz2;
        int f2 = (fogc & 0xFF00FF) * sz2;
        int f22 = (fogc & 0xFF00) * sz2;
        for (int y = y_start; y < y_end; ++y) {
            int col;
            int dv;
            int du;
            int v_2;
            int u_2;
            int length;
            int wz_b;
            int wz_a;
            int vz_b;
            int vz_a;
            int uz_b;
            int uz_a;
            int x2;
            int x1;
            if (x_start > x_end) {
                x1 = x_end;
                x2 = x_start;
                uz_a = uz_end;
                uz_b = uz_start;
                vz_a = vz_end;
                vz_b = vz_start;
                wz_a = wz_end;
                wz_b = wz_start;
            } else {
                x1 = x_start;
                x2 = x_end;
                uz_a = uz_start;
                uz_b = uz_end;
                vz_a = vz_start;
                vz_b = vz_end;
                wz_a = wz_start;
                wz_b = wz_end;
            }
            long subtexel_a = x1 % 4096;
            long subtexel_b = x2 % 4096;
            uz_a = (int)((long)uz_a - ((long)duz * subtexel_a >> 12));
            vz_a = (int)((long)vz_a - ((long)dvz * subtexel_a >> 12));
            wz_a = (int)((long)wz_a - ((long)dwz * subtexel_a >> 12));
            uz_b = (int)((long)uz_b - ((long)duz * subtexel_b >> 12));
            vz_b = (int)((long)vz_b - ((long)dvz * subtexel_b >> 12));
            wz_b = (int)((long)wz_b - ((long)dwz * subtexel_b >> 12));
            x2 >>= 12;
            if ((x1 >>= 12) < 0) {
                uz_a -= duz * x1;
                vz_a -= dvz * x1;
                wz_a -= dwz * x1;
                x1 = 0;
            }
            if (x2 > g3d.width) {
                uz_b -= duz * (x2 -= g3d.width);
                vz_b -= dvz * x2;
                wz_b -= dwz * x2;
                x2 = g3d.width;
            }
            int tempI = y * g3d.width;
            if (wz_a == 0) {
                return;
            }
            int u = (int)(((long)uz_a << 12) / (long)wz_a);
            int v = (int)(((long)vz_a << 12) / (long)wz_a);
            for (length = (x2 += tempI) - (x1 += tempI); length >= q; length -= q) {
                u_2 = (int)(((long)(uz_a += duz4) << 12) / (long)(wz_a += dwz4));
                v_2 = (int)(((long)(vz_a += dvz4) << 12) / (long)wz_a);
                du = (u_2 - u) / q;
                dv = (v_2 - v) / q;
                int i = x1 + q;
                while (x1 < i && x1 % 2 != 0) {
                    col = tex[(v >> 12 << widthBIT) + ((u += du) >> 12) & lengthBIT];
                    if (col != 0) {
                        rgb[x1] = ((col & 0xFF00FF) * isz2 + f2 & 0xFF00FF00 | (col & 0xFF00) * isz2 + f22 & 0xFF0000) >>> 8;
                    }
                    ++x1;
                }
                while (i - x1 >= 2) {
                    col = tex[((v += dv) >> 12 << widthBIT) + ((u += du) >> 12) & lengthBIT];
                    if (col != 0) {
                        rgb[x1] = col = ((col & 0xFF00FF) * isz2 + f2 & 0xFF00FF00 | (col & 0xFF00) * isz2 + f22 & 0xFF0000) >>> 8;
                        rgb[x1 + 1] = col;
                    }
                    u += du;
                    v += dv;
                    x1 += 2;
                }
                while (x1 < i) {
                    col = tex[((v += dv) >> 12 << widthBIT) + ((u += du) >> 12) & lengthBIT];
                    if (col != 0) {
                        rgb[x1] = ((col & 0xFF00FF) * isz2 + f2 & 0xFF00FF00 | (col & 0xFF00) * isz2 + f22 & 0xFF0000) >>> 8;
                    }
                    ++x1;
                }
            }
            if (length > 0) {
                u_2 = (int)(((long)uz_b << 12) / (long)wz_b);
                v_2 = (int)(((long)vz_b << 12) / (long)wz_b);
                du = (u_2 - u) / length;
                dv = (v_2 - v) / length;
                while (x1 < x2 && x1 % 2 != 0) {
                    col = tex[(v >> 12 << widthBIT) + ((u += du) >> 12) & lengthBIT];
                    if (col != 0) {
                        rgb[x1] = ((col & 0xFF00FF) * isz2 + f2 & 0xFF00FF00 | (col & 0xFF00) * isz2 + f22 & 0xFF0000) >>> 8;
                    }
                    ++x1;
                }
                while (x2 - x1 >= 2) {
                    col = tex[((v += dv) >> 12 << widthBIT) + ((u += du) >> 12) & lengthBIT];
                    if (col != 0) {
                        rgb[x1] = col = ((col & 0xFF00FF) * isz2 + f2 & 0xFF00FF00 | (col & 0xFF00) * isz2 + f22 & 0xFF0000) >>> 8;
                        rgb[x1 + 1] = col;
                    }
                    u += du;
                    v += dv;
                    x1 += 2;
                }
                while (x1 < x2) {
                    col = tex[((v += dv) >> 12 << widthBIT) + ((u += du) >> 12) & lengthBIT];
                    if (col != 0) {
                        rgb[x1] = ((col & 0xFF00FF) * isz2 + f2 & 0xFF00FF00 | (col & 0xFF00) * isz2 + f22 & 0xFF0000) >>> 8;
                    }
                    ++x1;
                }
            }
            x_start += dx_start;
            wz_start += dwz_start;
            uz_start += duz_start;
            vz_start += dvz_start;
            x_end += dx_end;
            wz_end += dwz_end;
            uz_end += duz_end;
            vz_end += dvz_end;
        }
    }

    static final void paintMiniTrianglePers_3_4X(Graphics3D g3d, Texture texture, int y_start, int y_end, int x_start, int wz_start, int uz_start, int vz_start, int x_end, int wz_end, int uz_end, int vz_end, int dx_start, int dwz_start, int duz_start, int dvz_start, int dx_end, int dwz_end, int duz_end, int dvz_end, int dwz, int duz, int dvz, int fogc, int sz2, int q, Vertex a, Vertex b, Vertex c) {
        int[] tex = texture.rImg.img;
        int lengthBIT = tex.length - 1;
        int widthBIT = texture.widthBIT;
        int[] rgb = g3d.display;
        int duz4 = duz * q;
        int dvz4 = dvz * q;
        int dwz4 = dwz * q;
        if (Graphics3D.fDist / 255 != 0) {
            sz2 = -Texturing.max(a.rz, b.rz, c.rz) / (Graphics3D.fDist / 255);
        }
        if (sz2 > 255) {
            sz2 = 255;
        }
        if (sz2 < 0) {
            sz2 = 0;
        }
        int isz2 = 255 - sz2;
        int f2 = (fogc & 0xFF00FF) * sz2;
        int f22 = (fogc & 0xFF00) * sz2;
        for (int y = y_start; y < y_end; ++y) {
            int col;
            int dv;
            int du;
            int v_2;
            int u_2;
            int length;
            int wz_b;
            int wz_a;
            int vz_b;
            int vz_a;
            int uz_b;
            int uz_a;
            int x2;
            int x1;
            if (x_start > x_end) {
                x1 = x_end;
                x2 = x_start;
                uz_a = uz_end;
                uz_b = uz_start;
                vz_a = vz_end;
                vz_b = vz_start;
                wz_a = wz_end;
                wz_b = wz_start;
            } else {
                x1 = x_start;
                x2 = x_end;
                uz_a = uz_start;
                uz_b = uz_end;
                vz_a = vz_start;
                vz_b = vz_end;
                wz_a = wz_start;
                wz_b = wz_end;
            }
            long subtexel_a = x1 % 4096;
            long subtexel_b = x2 % 4096;
            uz_a = (int)((long)uz_a - ((long)duz * subtexel_a >> 12));
            vz_a = (int)((long)vz_a - ((long)dvz * subtexel_a >> 12));
            wz_a = (int)((long)wz_a - ((long)dwz * subtexel_a >> 12));
            uz_b = (int)((long)uz_b - ((long)duz * subtexel_b >> 12));
            vz_b = (int)((long)vz_b - ((long)dvz * subtexel_b >> 12));
            wz_b = (int)((long)wz_b - ((long)dwz * subtexel_b >> 12));
            x2 >>= 12;
            if ((x1 >>= 12) < 0) {
                uz_a -= duz * x1;
                vz_a -= dvz * x1;
                wz_a -= dwz * x1;
                x1 = 0;
            }
            if (x2 > g3d.width) {
                uz_b -= duz * (x2 -= g3d.width);
                vz_b -= dvz * x2;
                wz_b -= dwz * x2;
                x2 = g3d.width;
            }
            int tempI = y * g3d.width;
            if (wz_a == 0) {
                return;
            }
            int u = (int)(((long)uz_a << 12) / (long)wz_a);
            int v = (int)(((long)vz_a << 12) / (long)wz_a);
            for (length = (x2 += tempI) - (x1 += tempI); length >= q; length -= q) {
                u_2 = (int)(((long)(uz_a += duz4) << 12) / (long)(wz_a += dwz4));
                v_2 = (int)(((long)(vz_a += dvz4) << 12) / (long)wz_a);
                du = (u_2 - u) / q;
                dv = (v_2 - v) / q;
                int i = x1 + q;
                while (x1 < i && x1 % 4 != 0) {
                    col = tex[((v += dv) >> 12 << widthBIT) + ((u += du) >> 12) & lengthBIT];
                    if (col != 0) {
                        rgb[x1] = ((col & 0xFF00FF) * isz2 + f2 & 0xFF00FF00 | (col & 0xFF00) * isz2 + f22 & 0xFF0000) >>> 8;
                    }
                    ++x1;
                }
                while (i - x1 >= 4) {
                    col = tex[((v += dv) >> 12 << widthBIT) + ((u += du) >> 12) & lengthBIT];
                    if (col != 0) {
                        rgb[x1] = col = ((col & 0xFF00FF) * isz2 + f2 & 0xFF00FF00 | (col & 0xFF00) * isz2 + f22 & 0xFF0000) >>> 8;
                        rgb[x1 + 1] = col;
                        rgb[x1 + 2] = col;
                        rgb[x1 + 3] = col;
                    }
                    u += du * 3;
                    v += dv * 3;
                    x1 += 4;
                }
                while (x1 < i) {
                    col = tex[((v += dv) >> 12 << widthBIT) + ((u += du) >> 12) & lengthBIT];
                    if (col != 0) {
                        rgb[x1] = ((col & 0xFF00FF) * isz2 + f2 & 0xFF00FF00 | (col & 0xFF00) * isz2 + f22 & 0xFF0000) >>> 8;
                    }
                    ++x1;
                }
            }
            if (length > 0) {
                u_2 = (int)(((long)uz_b << 12) / (long)wz_b);
                v_2 = (int)(((long)vz_b << 12) / (long)wz_b);
                du = (u_2 - u) / length;
                dv = (v_2 - v) / length;
                while (x1 < x2 && x1 % 4 != 0) {
                    col = tex[((v += dv) >> 12 << widthBIT) + ((u += du) >> 12) & lengthBIT];
                    if (col != 0) {
                        rgb[x1] = ((col & 0xFF00FF) * isz2 + f2 & 0xFF00FF00 | (col & 0xFF00) * isz2 + f22 & 0xFF0000) >>> 8;
                    }
                    ++x1;
                }
                while (x2 - x1 >= 4) {
                    col = tex[((v += dv) >> 12 << widthBIT) + ((u += du) >> 12) & lengthBIT];
                    if (col != 0) {
                        rgb[x1] = col = ((col & 0xFF00FF) * isz2 + f2 & 0xFF00FF00 | (col & 0xFF00) * isz2 + f22 & 0xFF0000) >>> 8;
                        rgb[x1 + 1] = col;
                        rgb[x1 + 2] = col;
                        rgb[x1 + 3] = col;
                    }
                    u += du * 3;
                    v += dv * 3;
                    x1 += 4;
                }
                while (x1 < x2) {
                    col = tex[((v += dv) >> 12 << widthBIT) + ((u += du) >> 12) & lengthBIT];
                    if (col != 0) {
                        rgb[x1] = ((col & 0xFF00FF) * isz2 + f2 & 0xFF00FF00 | (col & 0xFF00) * isz2 + f22 & 0xFF0000) >>> 8;
                    }
                    ++x1;
                }
            }
            x_start += dx_start;
            wz_start += dwz_start;
            uz_start += duz_start;
            vz_start += dvz_start;
            x_end += dx_end;
            wz_end += dwz_end;
            uz_end += duz_end;
            vz_end += dvz_end;
        }
    }

    static final void paintMiniTrianglePers_3_HQ(Graphics3D g3d, Texture texture, int y_start, int y_end, int x_start, int wz_start, int uz_start, int vz_start, int x_end, int wz_end, int uz_end, int vz_end, int dx_start, int dwz_start, int duz_start, int dvz_start, int dx_end, int dwz_end, int duz_end, int dvz_end, int dwz, int duz, int dvz, int fogc, int sz2, int q, Vertex a, Vertex b, Vertex c, int f_start, int f_end, int df_start, int df_end, int df) {
        int[] tex = texture.rImg.img;
        int lengthBIT = tex.length - 1;
        int widthBIT = texture.widthBIT;
        int[] rgb = g3d.display;
        int duz4 = duz * q;
        int dvz4 = dvz * q;
        int dwz4 = dwz * q;
        int fogcolor = Graphics3D.fogc;
        int fogcolor2 = fogcolor & 0xFF00;
        fogcolor &= 0xFF00FF;
        for (int y = y_start; y < y_end; ++y) {
            int col;
            int dv;
            int du;
            int v_2;
            int u_2;
            int length;
            int f;
            int wz_b;
            int wz_a;
            int vz_b;
            int vz_a;
            int uz_b;
            int uz_a;
            int x2;
            int x1;
            if (x_start > x_end) {
                x1 = x_end;
                x2 = x_start;
                uz_a = uz_end;
                uz_b = uz_start;
                vz_a = vz_end;
                vz_b = vz_start;
                wz_a = wz_end;
                wz_b = wz_start;
                f = f_end;
            } else {
                x1 = x_start;
                x2 = x_end;
                uz_a = uz_start;
                uz_b = uz_end;
                vz_a = vz_start;
                vz_b = vz_end;
                wz_a = wz_start;
                wz_b = wz_end;
                f = f_start;
            }
            long subtexel_a = x1 % 4096;
            long subtexel_b = x2 % 4096;
            uz_a = (int)((long)uz_a - ((long)duz * subtexel_a >> 12));
            vz_a = (int)((long)vz_a - ((long)dvz * subtexel_a >> 12));
            wz_a = (int)((long)wz_a - ((long)dwz * subtexel_a >> 12));
            uz_b = (int)((long)uz_b - ((long)duz * subtexel_b >> 12));
            vz_b = (int)((long)vz_b - ((long)dvz * subtexel_b >> 12));
            wz_b = (int)((long)wz_b - ((long)dwz * subtexel_b >> 12));
            x2 >>= 12;
            if ((x1 >>= 12) < 0) {
                uz_a -= duz * x1;
                vz_a -= dvz * x1;
                wz_a -= dwz * x1;
                f -= df * x1;
                x1 = 0;
            }
            if (x2 > g3d.width) {
                uz_b -= duz * (x2 -= g3d.width);
                vz_b -= dvz * x2;
                wz_b -= dwz * x2;
                x2 = g3d.width;
            }
            int tempI = y * g3d.width;
            if (wz_a == 0) {
                return;
            }
            int u = (int)(((long)uz_a << 12) / (long)wz_a);
            int v = (int)(((long)vz_a << 12) / (long)wz_a);
            for (length = (x2 += tempI) - (x1 += tempI); length >= q; length -= q) {
                u_2 = (int)(((long)(uz_a += duz4) << 12) / (long)(wz_a += dwz4));
                v_2 = (int)(((long)(vz_a += dvz4) << 12) / (long)wz_a);
                du = (u_2 - u) / q;
                dv = (v_2 - v) / q;
                int i = x1 + q;
                while (x1 < i) {
                    int isz2 = (f += df) >> 12;
                    int isz = 255 - isz2;
                    col = tex[((v += dv) >> 12 << widthBIT) + ((u += du) >> 12) & lengthBIT];
                    if (col != 0) {
                        rgb[x1] = ((col & 0xFF00FF) * isz2 + fogcolor * isz & 0xFF00FF00 | (col & 0xFF00) * isz2 + fogcolor2 * isz & 0xFF0000) >>> 8;
                    }
                    ++x1;
                }
            }
            if (length > 0) {
                u_2 = (int)(((long)uz_b << 12) / (long)wz_b);
                v_2 = (int)(((long)vz_b << 12) / (long)wz_b);
                du = (u_2 - u) / length;
                dv = (v_2 - v) / length;
                while (x1 < x2) {
                    int isz2 = (f += df) >> 12;
                    int isz = 255 - isz2;
                    col = tex[((v += dv) >> 12 << widthBIT) + ((u += du) >> 12) & lengthBIT];
                    if (col != 0) {
                        rgb[x1] = ((col & 0xFF00FF) * isz2 + fogcolor * isz & 0xFF00FF00 | (col & 0xFF00) * isz2 + fogcolor2 * isz & 0xFF0000) >>> 8;
                    }
                    ++x1;
                }
            }
            x_start += dx_start;
            wz_start += dwz_start;
            uz_start += duz_start;
            vz_start += dvz_start;
            f_start += df_start;
            x_end += dx_end;
            wz_end += dwz_end;
            uz_end += duz_end;
            vz_end += dvz_end;
            f_end += df_end;
        }
    }

    static final void paintMiniTrianglePers_3_HQ_2X(Graphics3D g3d, Texture texture, int y_start, int y_end, int x_start, int wz_start, int uz_start, int vz_start, int x_end, int wz_end, int uz_end, int vz_end, int dx_start, int dwz_start, int duz_start, int dvz_start, int dx_end, int dwz_end, int duz_end, int dvz_end, int dwz, int duz, int dvz, int fogc, int sz2, int q, Vertex a, Vertex b, Vertex c, int f_start, int f_end, int df_start, int df_end, int df) {
        int[] tex = texture.rImg.img;
        int lengthBIT = tex.length - 1;
        int widthBIT = texture.widthBIT;
        int[] rgb = g3d.display;
        int duz4 = duz * q;
        int dvz4 = dvz * q;
        int dwz4 = dwz * q;
        int fogcolor = Graphics3D.fogc;
        int fogcolor2 = fogcolor & 0xFF00;
        fogcolor &= 0xFF00FF;
        for (int y = y_start; y < y_end; ++y) {
            int col;
            int dv;
            int du;
            int v_2;
            int u_2;
            int length;
            int f;
            int wz_b;
            int wz_a;
            int vz_b;
            int vz_a;
            int uz_b;
            int uz_a;
            int x2;
            int x1;
            if (x_start > x_end) {
                x1 = x_end;
                x2 = x_start;
                uz_a = uz_end;
                uz_b = uz_start;
                vz_a = vz_end;
                vz_b = vz_start;
                wz_a = wz_end;
                wz_b = wz_start;
                f = f_end;
            } else {
                x1 = x_start;
                x2 = x_end;
                uz_a = uz_start;
                uz_b = uz_end;
                vz_a = vz_start;
                vz_b = vz_end;
                wz_a = wz_start;
                wz_b = wz_end;
                f = f_start;
            }
            long subtexel_a = x1 % 4096;
            long subtexel_b = x2 % 4096;
            uz_a = (int)((long)uz_a - ((long)duz * subtexel_a >> 12));
            vz_a = (int)((long)vz_a - ((long)dvz * subtexel_a >> 12));
            wz_a = (int)((long)wz_a - ((long)dwz * subtexel_a >> 12));
            uz_b = (int)((long)uz_b - ((long)duz * subtexel_b >> 12));
            vz_b = (int)((long)vz_b - ((long)dvz * subtexel_b >> 12));
            wz_b = (int)((long)wz_b - ((long)dwz * subtexel_b >> 12));
            x2 >>= 12;
            if ((x1 >>= 12) < 0) {
                uz_a -= duz * x1;
                vz_a -= dvz * x1;
                wz_a -= dwz * x1;
                f -= df * x1;
                x1 = 0;
            }
            if (x2 > g3d.width) {
                uz_b -= duz * (x2 -= g3d.width);
                vz_b -= dvz * x2;
                wz_b -= dwz * x2;
                x2 = g3d.width;
            }
            int tempI = y * g3d.width;
            if (wz_a == 0) {
                return;
            }
            int u = (int)(((long)uz_a << 12) / (long)wz_a);
            int v = (int)(((long)vz_a << 12) / (long)wz_a);
            for (length = (x2 += tempI) - (x1 += tempI); length >= q; length -= q) {
                int isz;
                int isz2;
                u_2 = (int)(((long)(uz_a += duz4) << 12) / (long)(wz_a += dwz4));
                v_2 = (int)(((long)(vz_a += dvz4) << 12) / (long)wz_a);
                du = (u_2 - u) / q;
                dv = (v_2 - v) / q;
                int i = x1 + q;
                while (x1 < i && x1 % 2 != 0) {
                    isz2 = (f += df) >> 12;
                    isz = 255 - isz2;
                    col = tex[((v += dv) >> 12 << widthBIT) + ((u += du) >> 12) & lengthBIT];
                    if (col != 0) {
                        rgb[x1] = ((col & 0xFF00FF) * isz2 + fogcolor * isz & 0xFF00FF00 | (col & 0xFF00) * isz2 + fogcolor2 * isz & 0xFF0000) >>> 8;
                    }
                    ++x1;
                }
                while (i - x1 >= 2) {
                    isz2 = (f += df) >> 12;
                    isz = 255 - isz2;
                    col = tex[((v += dv) >> 12 << widthBIT) + ((u += du) >> 12) & lengthBIT];
                    if (col != 0) {
                        rgb[x1] = col = ((col & 0xFF00FF) * isz2 + fogcolor * isz & 0xFF00FF00 | (col & 0xFF00) * isz2 + fogcolor2 * isz & 0xFF0000) >>> 8;
                        rgb[x1 + 1] = col;
                    }
                    u += du;
                    v += dv;
                    f += df;
                    x1 += 2;
                }
                while (x1 < i) {
                    isz2 = (f += df) >> 12;
                    isz = 255 - isz2;
                    col = tex[((v += dv) >> 12 << widthBIT) + ((u += du) >> 12) & lengthBIT];
                    if (col != 0) {
                        rgb[x1] = ((col & 0xFF00FF) * isz2 + fogcolor * isz & 0xFF00FF00 | (col & 0xFF00) * isz2 + fogcolor2 * isz & 0xFF0000) >>> 8;
                    }
                    ++x1;
                }
            }
            if (length > 0) {
                int isz;
                int isz2;
                u_2 = (int)(((long)uz_b << 12) / (long)wz_b);
                v_2 = (int)(((long)vz_b << 12) / (long)wz_b);
                du = (u_2 - u) / length;
                dv = (v_2 - v) / length;
                while (x1 < x2 && x1 % 2 != 0) {
                    isz2 = (f += df) >> 12;
                    isz = 255 - isz2;
                    col = tex[((v += dv) >> 12 << widthBIT) + ((u += du) >> 12) & lengthBIT];
                    if (col != 0) {
                        rgb[x1] = ((col & 0xFF00FF) * isz2 + fogcolor * isz & 0xFF00FF00 | (col & 0xFF00) * isz2 + fogcolor2 * isz & 0xFF0000) >>> 8;
                    }
                    ++x1;
                }
                while (x2 - x1 >= 2) {
                    isz2 = (f += df) >> 12;
                    isz = 255 - isz2;
                    col = tex[((v += dv) >> 12 << widthBIT) + ((u += du) >> 12) & lengthBIT];
                    if (col != 0) {
                        rgb[x1] = col = ((col & 0xFF00FF) * isz2 + fogcolor * isz & 0xFF00FF00 | (col & 0xFF00) * isz2 + fogcolor2 * isz & 0xFF0000) >>> 8;
                        rgb[x1 + 1] = col;
                    }
                    u += du;
                    v += dv;
                    f += df;
                    x1 += 2;
                }
                while (x1 < x2) {
                    isz2 = (f += df) >> 12;
                    isz = 255 - isz2;
                    col = tex[((v += dv) >> 12 << widthBIT) + ((u += du) >> 12) & lengthBIT];
                    if (col != 0) {
                        rgb[x1] = ((col & 0xFF00FF) * isz2 + fogcolor * isz & 0xFF00FF00 | (col & 0xFF00) * isz2 + fogcolor2 * isz & 0xFF0000) >>> 8;
                    }
                    ++x1;
                }
            }
            x_start += dx_start;
            wz_start += dwz_start;
            uz_start += duz_start;
            vz_start += dvz_start;
            f_start += df_start;
            x_end += dx_end;
            wz_end += dwz_end;
            uz_end += duz_end;
            vz_end += dvz_end;
            f_end += df_end;
        }
    }

    static final void paintMiniTrianglePers_3_HQ_4X(Graphics3D g3d, Texture texture, int y_start, int y_end, int x_start, int wz_start, int uz_start, int vz_start, int x_end, int wz_end, int uz_end, int vz_end, int dx_start, int dwz_start, int duz_start, int dvz_start, int dx_end, int dwz_end, int duz_end, int dvz_end, int dwz, int duz, int dvz, int fogc, int sz2, int q, Vertex a, Vertex b, Vertex c, int f_start, int f_end, int df_start, int df_end, int df) {
        int[] tex = texture.rImg.img;
        int lengthBIT = tex.length - 1;
        int widthBIT = texture.widthBIT;
        int[] rgb = g3d.display;
        int duz4 = duz * q;
        int dvz4 = dvz * q;
        int dwz4 = dwz * q;
        int fogcolor = Graphics3D.fogc;
        int fogcolor2 = fogcolor & 0xFF00;
        fogcolor &= 0xFF00FF;
        for (int y = y_start; y < y_end; ++y) {
            int col;
            int dv;
            int du;
            int v_2;
            int u_2;
            int length;
            int f;
            int wz_b;
            int wz_a;
            int vz_b;
            int vz_a;
            int uz_b;
            int uz_a;
            int x2;
            int x1;
            if (x_start > x_end) {
                x1 = x_end;
                x2 = x_start;
                uz_a = uz_end;
                uz_b = uz_start;
                vz_a = vz_end;
                vz_b = vz_start;
                wz_a = wz_end;
                wz_b = wz_start;
                f = f_end;
            } else {
                x1 = x_start;
                x2 = x_end;
                uz_a = uz_start;
                uz_b = uz_end;
                vz_a = vz_start;
                vz_b = vz_end;
                wz_a = wz_start;
                wz_b = wz_end;
                f = f_start;
            }
            long subtexel_a = x1 % 4096;
            long subtexel_b = x2 % 4096;
            uz_a = (int)((long)uz_a - ((long)duz * subtexel_a >> 12));
            vz_a = (int)((long)vz_a - ((long)dvz * subtexel_a >> 12));
            wz_a = (int)((long)wz_a - ((long)dwz * subtexel_a >> 12));
            uz_b = (int)((long)uz_b - ((long)duz * subtexel_b >> 12));
            vz_b = (int)((long)vz_b - ((long)dvz * subtexel_b >> 12));
            wz_b = (int)((long)wz_b - ((long)dwz * subtexel_b >> 12));
            x2 >>= 12;
            if ((x1 >>= 12) < 0) {
                uz_a -= duz * x1;
                vz_a -= dvz * x1;
                wz_a -= dwz * x1;
                f -= df * x1;
                x1 = 0;
            }
            if (x2 > g3d.width) {
                uz_b -= duz * (x2 -= g3d.width);
                vz_b -= dvz * x2;
                wz_b -= dwz * x2;
                x2 = g3d.width;
            }
            int tempI = y * g3d.width;
            if (wz_a == 0) {
                return;
            }
            int u = (int)(((long)uz_a << 12) / (long)wz_a);
            int v = (int)(((long)vz_a << 12) / (long)wz_a);
            for (length = (x2 += tempI) - (x1 += tempI); length >= q; length -= q) {
                int isz;
                int isz2;
                u_2 = (int)(((long)(uz_a += duz4) << 12) / (long)(wz_a += dwz4));
                v_2 = (int)(((long)(vz_a += dvz4) << 12) / (long)wz_a);
                du = (u_2 - u) / q;
                dv = (v_2 - v) / q;
                int i = x1 + q;
                while (i - x1 >= 4) {
                    isz2 = (f += df) >> 12;
                    isz = 255 - isz2;
                    col = tex[((v += dv) >> 12 << widthBIT) + ((u += du) >> 12) & lengthBIT];
                    if (col != 0) {
                        rgb[x1] = col = ((col & 0xFF00FF) * isz2 + fogcolor * isz & 0xFF00FF00 | (col & 0xFF00) * isz2 + fogcolor2 * isz & 0xFF0000) >>> 8;
                        rgb[x1 + 1] = col;
                        rgb[x1 + 2] = col;
                        rgb[x1 + 3] = col;
                    }
                    u += du * 3;
                    v += dv * 3;
                    f += df * 3;
                    x1 += 4;
                }
                while (x1 < i) {
                    isz2 = (f += df) >> 12;
                    isz = 255 - isz2;
                    col = tex[((v += dv) >> 12 << widthBIT) + ((u += du) >> 12) & lengthBIT];
                    if (col != 0) {
                        rgb[x1] = ((col & 0xFF00FF) * isz2 + fogcolor * isz & 0xFF00FF00 | (col & 0xFF00) * isz2 + fogcolor2 * isz & 0xFF0000) >>> 8;
                    }
                    ++x1;
                }
            }
            if (length > 0) {
                int isz;
                int isz2;
                u_2 = (int)(((long)uz_b << 12) / (long)wz_b);
                v_2 = (int)(((long)vz_b << 12) / (long)wz_b);
                du = (u_2 - u) / length;
                dv = (v_2 - v) / length;
                while (x2 - x1 >= 4) {
                    isz2 = (f += df) >> 12;
                    isz = 255 - isz2;
                    col = tex[((v += dv) >> 12 << widthBIT) + ((u += du) >> 12) & lengthBIT];
                    if (col != 0) {
                        rgb[x1] = col = ((col & 0xFF00FF) * isz2 + fogcolor * isz & 0xFF00FF00 | (col & 0xFF00) * isz2 + fogcolor2 * isz & 0xFF0000) >>> 8;
                        rgb[x1 + 1] = col;
                        rgb[x1 + 2] = col;
                        rgb[x1 + 3] = col;
                    }
                    u += du * 3;
                    v += dv * 3;
                    f += df * 3;
                    x1 += 4;
                }
                while (x1 < x2) {
                    isz2 = (f += df) >> 12;
                    isz = 255 - isz2;
                    col = tex[((v += dv) >> 12 << widthBIT) + ((u += du) >> 12) & lengthBIT];
                    if (col != 0) {
                        rgb[x1] = ((col & 0xFF00FF) * isz2 + fogcolor * isz & 0xFF00FF00 | (col & 0xFF00) * isz2 + fogcolor2 * isz & 0xFF0000) >>> 8;
                    }
                    ++x1;
                }
            }
            x_start += dx_start;
            wz_start += dwz_start;
            uz_start += duz_start;
            vz_start += dvz_start;
            f_start += df_start;
            x_end += dx_end;
            wz_end += dwz_end;
            uz_end += duz_end;
            vz_end += dvz_end;
            f_end += df_end;
        }
    }

    static final void paintMiniTrianglePers_4(Graphics3D g3d, Texture texture, int y_start, int y_end, int x_start, int wz_start, int uz_start, int vz_start, int x_end, int wz_end, int uz_end, int vz_end, int dx_start, int dwz_start, int duz_start, int dvz_start, int dx_end, int dwz_end, int duz_end, int dvz_end, int dwz, int duz, int dvz, int fogc, int sz2) {
        int[] tex = texture.rImg.img;
        int lengthBIT = tex.length - 1;
        int widthBIT = texture.widthBIT;
        int[] rgb = g3d.display;
        int duz4 = duz * sz2;
        int dvz4 = dvz * sz2;
        int dwz4 = dwz * sz2;
        for (int y = y_start; y < y_end; ++y) {
            int ca;
            int col;
            int dv;
            int du;
            int v_2;
            int u_2;
            int length;
            int wz_b;
            int wz_a;
            int vz_b;
            int vz_a;
            int uz_b;
            int uz_a;
            int x2;
            int x1;
            if (x_start > x_end) {
                x1 = x_end;
                x2 = x_start;
                uz_a = uz_end;
                uz_b = uz_start;
                vz_a = vz_end;
                vz_b = vz_start;
                wz_a = wz_end;
                wz_b = wz_start;
            } else {
                x1 = x_start;
                x2 = x_end;
                uz_a = uz_start;
                uz_b = uz_end;
                vz_a = vz_start;
                vz_b = vz_end;
                wz_a = wz_start;
                wz_b = wz_end;
            }
            long subtexel_a = x1 % 4096;
            long subtexel_b = x2 % 4096;
            uz_a = (int)((long)uz_a - ((long)duz * subtexel_a >> 12));
            vz_a = (int)((long)vz_a - ((long)dvz * subtexel_a >> 12));
            wz_a = (int)((long)wz_a - ((long)dwz * subtexel_a >> 12));
            uz_b = (int)((long)uz_b - ((long)duz * subtexel_b >> 12));
            vz_b = (int)((long)vz_b - ((long)dvz * subtexel_b >> 12));
            wz_b = (int)((long)wz_b - ((long)dwz * subtexel_b >> 12));
            x2 >>= 12;
            if ((x1 >>= 12) < 0) {
                uz_a -= duz * x1;
                vz_a -= dvz * x1;
                wz_a -= dwz * x1;
                x1 = 0;
            }
            if (x2 > g3d.width) {
                uz_b -= duz * (x2 -= g3d.width);
                vz_b -= dvz * x2;
                wz_b -= dwz * x2;
                x2 = g3d.width;
            }
            int tempI = y * g3d.width;
            if (wz_a == 0) {
                return;
            }
            int u = (int)(((long)uz_a << 12) / (long)wz_a);
            int v = (int)(((long)vz_a << 12) / (long)wz_a);
            for (length = (x2 += tempI) - (x1 += tempI); length >= sz2; length -= sz2) {
                u_2 = (int)(((long)(uz_a += duz4) << 12) / (long)(wz_a += dwz4));
                v_2 = (int)(((long)(vz_a += dvz4) << 12) / (long)wz_a);
                du = (u_2 - u) / sz2;
                dv = (v_2 - v) / sz2;
                int i = x1 + sz2;
                while (x1 < i) {
                    col = tex[((v += dv) >> 12 << widthBIT) + ((u += du) >> 12) & lengthBIT];
                    if (col != 0) {
                        ca = col >> 24 & 0xFF;
                        int cols = rgb[x1];
                        rgb[x1] = ((col & 0xFF00FF) * ca + (cols & 0xFF00FF) * (255 - ca) & 0xFF00FF00 | (col & 0xFF00) * ca + (cols & 0xFF00) * (255 - ca) & 0xFF0000) >>> 8;
                    }
                    ++x1;
                }
            }
            if (length > 0) {
                u_2 = (int)(((long)uz_b << 12) / (long)wz_b);
                v_2 = (int)(((long)vz_b << 12) / (long)wz_b);
                du = (u_2 - u) / length;
                dv = (v_2 - v) / length;
                while (x1 < x2) {
                    col = tex[((v += dv) >> 12 << widthBIT) + ((u += du) >> 12) & lengthBIT];
                    if (col != 0) {
                        ca = col >> 24 & 0xFF;
                        int cols = rgb[x1];
                        rgb[x1] = ((col & 0xFF00FF) * ca + (cols & 0xFF00FF) * (255 - ca) & 0xFF00FF00 | (col & 0xFF00) * ca + (cols & 0xFF00) * (255 - ca) & 0xFF0000) >>> 8;
                    }
                    ++x1;
                }
            }
            x_start += dx_start;
            wz_start += dwz_start;
            uz_start += duz_start;
            vz_start += dvz_start;
            x_end += dx_end;
            wz_end += dwz_end;
            uz_end += duz_end;
            vz_end += dvz_end;
        }
    }

    static final void paintMiniTrianglePers_5(Graphics3D g3d, Texture texture, int y_start, int y_end, int x_start, int wz_start, int uz_start, int vz_start, int x_end, int wz_end, int uz_end, int vz_end, int dx_start, int dwz_start, int duz_start, int dvz_start, int dx_end, int dwz_end, int duz_end, int dvz_end, int dwz, int duz, int dvz, int fogc, int sz2, int q, Vertex a, Vertex b, Vertex c, boolean x2pixel, boolean x4pixel, int f_start, int f_end, int df_start, int df_end, int df) {
        if (Main.fogQ == 2 && !Main.forceLQFog && texture.drawmode == 6) {
            if (x4pixel) {
                Texturing.paintMiniTrianglePers_6_HQ_4X(g3d, texture, y_start, y_end, x_start, wz_start, uz_start, vz_start, x_end, wz_end, uz_end, vz_end, dx_start, dwz_start, duz_start, dvz_start, dx_end, dwz_end, duz_end, dvz_end, dwz, duz, dvz, fogc, sz2, q, a, b, c, f_start, f_end, df_start, df_end, df);
                return;
            }
            if (x2pixel) {
                Texturing.paintMiniTrianglePers_6_HQ_2X(g3d, texture, y_start, y_end, x_start, wz_start, uz_start, vz_start, x_end, wz_end, uz_end, vz_end, dx_start, dwz_start, duz_start, dvz_start, dx_end, dwz_end, duz_end, dvz_end, dwz, duz, dvz, fogc, sz2, q, a, b, c, f_start, f_end, df_start, df_end, df);
                return;
            }
            Texturing.paintMiniTrianglePers_6_HQ(g3d, texture, y_start, y_end, x_start, wz_start, uz_start, vz_start, x_end, wz_end, uz_end, vz_end, dx_start, dwz_start, duz_start, dvz_start, dx_end, dwz_end, duz_end, dvz_end, dwz, duz, dvz, fogc, sz2, q, a, b, c, f_start, f_end, df_start, df_end, df);
            return;
        }
        if (Main.fogQ == 0 && texture.drawmode == 6) {
            Texturing.paintMiniTrianglePers_0(g3d, texture, y_start, y_end, x_start, wz_start, uz_start, vz_start, x_end, wz_end, uz_end, vz_end, dx_start, dwz_start, duz_start, dvz_start, dx_end, dwz_end, duz_end, dvz_end, dwz, duz, dvz, fogc, q, x2pixel, x4pixel);
            return;
        }
        if (x4pixel) {
            Texturing.paintMiniTrianglePers_5_4X(g3d, texture, y_start, y_end, x_start, wz_start, uz_start, vz_start, x_end, wz_end, uz_end, vz_end, dx_start, dwz_start, duz_start, dvz_start, dx_end, dwz_end, duz_end, dvz_end, dwz, duz, dvz, fogc, sz2, q, a, b, c);
            return;
        }
        if (x2pixel) {
            Texturing.paintMiniTrianglePers_5_2X(g3d, texture, y_start, y_end, x_start, wz_start, uz_start, vz_start, x_end, wz_end, uz_end, vz_end, dx_start, dwz_start, duz_start, dvz_start, dx_end, dwz_end, duz_end, dvz_end, dwz, duz, dvz, fogc, sz2, q, a, b, c);
            return;
        }
        int[] tex = texture.rImg.img;
        int lengthBIT = tex.length - 1;
        int widthBIT = texture.widthBIT;
        int[] rgb = g3d.display;
        int duz4 = duz * q;
        int dvz4 = dvz * q;
        int dwz4 = dwz * q;
        if (texture.getDrawMode() == 6) {
            if (Graphics3D.fDist / 255 != 0) {
                sz2 = -Texturing.max(a.rz, b.rz, c.rz) / (Graphics3D.fDist / 255);
            }
            if (sz2 > 255) {
                sz2 = 255;
            }
            if (sz2 < 0) {
                sz2 = 0;
            }
        }
        int isz2 = 255 - sz2;
        for (int y = y_start; y < y_end; ++y) {
            int col;
            int dv;
            int du;
            int v_2;
            int u_2;
            int length;
            int wz_b;
            int wz_a;
            int vz_b;
            int vz_a;
            int uz_b;
            int uz_a;
            int x2;
            int x1;
            if (x_start > x_end) {
                x1 = x_end;
                x2 = x_start;
                uz_a = uz_end;
                uz_b = uz_start;
                vz_a = vz_end;
                vz_b = vz_start;
                wz_a = wz_end;
                wz_b = wz_start;
            } else {
                x1 = x_start;
                x2 = x_end;
                uz_a = uz_start;
                uz_b = uz_end;
                vz_a = vz_start;
                vz_b = vz_end;
                wz_a = wz_start;
                wz_b = wz_end;
            }
            long subtexel_a = x1 % 4096;
            long subtexel_b = x2 % 4096;
            uz_a = (int)((long)uz_a - ((long)duz * subtexel_a >> 12));
            vz_a = (int)((long)vz_a - ((long)dvz * subtexel_a >> 12));
            wz_a = (int)((long)wz_a - ((long)dwz * subtexel_a >> 12));
            uz_b = (int)((long)uz_b - ((long)duz * subtexel_b >> 12));
            vz_b = (int)((long)vz_b - ((long)dvz * subtexel_b >> 12));
            wz_b = (int)((long)wz_b - ((long)dwz * subtexel_b >> 12));
            x2 >>= 12;
            if ((x1 >>= 12) < 0) {
                uz_a -= duz * x1;
                vz_a -= dvz * x1;
                wz_a -= dwz * x1;
                x1 = 0;
            }
            if (x2 > g3d.width) {
                uz_b -= duz * (x2 -= g3d.width);
                vz_b -= dvz * x2;
                wz_b -= dwz * x2;
                x2 = g3d.width;
            }
            int tempI = y * g3d.width;
            if (wz_a == 0) {
                return;
            }
            int u = (int)(((long)uz_a << 12) / (long)wz_a);
            int v = (int)(((long)vz_a << 12) / (long)wz_a);
            for (length = (x2 += tempI) - (x1 += tempI); length >= q; length -= q) {
                u_2 = (int)(((long)(uz_a += duz4) << 12) / (long)(wz_a += dwz4));
                v_2 = (int)(((long)(vz_a += dvz4) << 12) / (long)wz_a);
                du = (u_2 - u) / q;
                dv = (v_2 - v) / q;
                int i = x1 + q;
                while (x1 < i) {
                    col = tex[((v += dv) >> 12 << widthBIT) + ((u += du) >> 12) & lengthBIT];
                    if (col != 0) {
                        rgb[x1] = ((col & 0xFF00FF) * isz2 & 0xFF00FF00 | (col & 0xFF00) * isz2 & 0xFF0000) >>> 8;
                    }
                    ++x1;
                }
            }
            if (length > 0) {
                u_2 = (int)(((long)uz_b << 12) / (long)wz_b);
                v_2 = (int)(((long)vz_b << 12) / (long)wz_b);
                du = (u_2 - u) / length;
                dv = (v_2 - v) / length;
                while (x1 < x2) {
                    col = tex[((v += dv) >> 12 << widthBIT) + ((u += du) >> 12) & lengthBIT];
                    if (col != 0) {
                        rgb[x1] = ((col & 0xFF00FF) * isz2 & 0xFF00FF00 | (col & 0xFF00) * isz2 & 0xFF0000) >>> 8;
                    }
                    ++x1;
                }
            }
            x_start += dx_start;
            wz_start += dwz_start;
            uz_start += duz_start;
            vz_start += dvz_start;
            x_end += dx_end;
            wz_end += dwz_end;
            uz_end += duz_end;
            vz_end += dvz_end;
        }
    }

    static final void paintMiniTrianglePers_5_2X(Graphics3D g3d, Texture texture, int y_start, int y_end, int x_start, int wz_start, int uz_start, int vz_start, int x_end, int wz_end, int uz_end, int vz_end, int dx_start, int dwz_start, int duz_start, int dvz_start, int dx_end, int dwz_end, int duz_end, int dvz_end, int dwz, int duz, int dvz, int fogc, int sz2, int q, Vertex a, Vertex b, Vertex c) {
        int[] tex = texture.rImg.img;
        int lengthBIT = tex.length - 1;
        int widthBIT = texture.widthBIT;
        int[] rgb = g3d.display;
        int duz4 = duz * q;
        int dvz4 = dvz * q;
        int dwz4 = dwz * q;
        if (Graphics3D.fDist / 255 != 0) {
            sz2 = -Texturing.max(a.rz, b.rz, c.rz) / (Graphics3D.fDist / 255);
        }
        if (sz2 > 255) {
            sz2 = 255;
        }
        if (sz2 < 0) {
            sz2 = 0;
        }
        int isz2 = 255 - sz2;
        int f2 = (fogc & 0xFF00FF) * sz2;
        int f22 = (fogc & 0xFF00) * sz2;
        for (int y = y_start; y < y_end; ++y) {
            int col;
            int dv;
            int du;
            int v_2;
            int u_2;
            int length;
            int wz_b;
            int wz_a;
            int vz_b;
            int vz_a;
            int uz_b;
            int uz_a;
            int x2;
            int x1;
            if (x_start > x_end) {
                x1 = x_end;
                x2 = x_start;
                uz_a = uz_end;
                uz_b = uz_start;
                vz_a = vz_end;
                vz_b = vz_start;
                wz_a = wz_end;
                wz_b = wz_start;
            } else {
                x1 = x_start;
                x2 = x_end;
                uz_a = uz_start;
                uz_b = uz_end;
                vz_a = vz_start;
                vz_b = vz_end;
                wz_a = wz_start;
                wz_b = wz_end;
            }
            long subtexel_a = x1 % 4096;
            long subtexel_b = x2 % 4096;
            uz_a = (int)((long)uz_a - ((long)duz * subtexel_a >> 12));
            vz_a = (int)((long)vz_a - ((long)dvz * subtexel_a >> 12));
            wz_a = (int)((long)wz_a - ((long)dwz * subtexel_a >> 12));
            uz_b = (int)((long)uz_b - ((long)duz * subtexel_b >> 12));
            vz_b = (int)((long)vz_b - ((long)dvz * subtexel_b >> 12));
            wz_b = (int)((long)wz_b - ((long)dwz * subtexel_b >> 12));
            x2 >>= 12;
            if ((x1 >>= 12) < 0) {
                uz_a -= duz * x1;
                vz_a -= dvz * x1;
                wz_a -= dwz * x1;
                x1 = 0;
            }
            if (x2 > g3d.width) {
                uz_b -= duz * (x2 -= g3d.width);
                vz_b -= dvz * x2;
                wz_b -= dwz * x2;
                x2 = g3d.width;
            }
            int tempI = y * g3d.width;
            if (wz_a == 0) {
                return;
            }
            int u = (int)(((long)uz_a << 12) / (long)wz_a);
            int v = (int)(((long)vz_a << 12) / (long)wz_a);
            for (length = (x2 += tempI) - (x1 += tempI); length >= q; length -= q) {
                u_2 = (int)(((long)(uz_a += duz4) << 12) / (long)(wz_a += dwz4));
                v_2 = (int)(((long)(vz_a += dvz4) << 12) / (long)wz_a);
                du = (u_2 - u) / q;
                dv = (v_2 - v) / q;
                int i = x1 + q;
                while (i - x1 >= 2) {
                    col = tex[((v += dv) >> 12 << widthBIT) + ((u += du) >> 12) & lengthBIT];
                    if (col != 0) {
                        rgb[x1] = col = ((col & 0xFF00FF) * isz2 & 0xFF00FF00 | (col & 0xFF00) * isz2 & 0xFF0000) >>> 8;
                        rgb[x1 + 1] = col;
                    }
                    u += du;
                    v += dv;
                    x1 += 2;
                }
                while (x1 < i) {
                    col = tex[((v += dv) >> 12 << widthBIT) + ((u += du) >> 12) & lengthBIT];
                    if (col != 0) {
                        rgb[x1] = ((col & 0xFF00FF) * isz2 & 0xFF00FF00 | (col & 0xFF00) * isz2 & 0xFF0000) >>> 8;
                    }
                    ++x1;
                }
            }
            if (length > 0) {
                u_2 = (int)(((long)uz_b << 12) / (long)wz_b);
                v_2 = (int)(((long)vz_b << 12) / (long)wz_b);
                du = (u_2 - u) / length;
                dv = (v_2 - v) / length;
                while (x2 - x1 >= 2) {
                    col = tex[((v += dv) >> 12 << widthBIT) + ((u += du) >> 12) & lengthBIT];
                    if (col != 0) {
                        rgb[x1] = col = ((col & 0xFF00FF) * isz2 & 0xFF00FF00 | (col & 0xFF00) * isz2 & 0xFF0000) >>> 8;
                        rgb[x1 + 1] = col;
                    }
                    u += du;
                    v += dv;
                    x1 += 2;
                }
                while (x1 < x2) {
                    col = tex[((v += dv) >> 12 << widthBIT) + ((u += du) >> 12) & lengthBIT];
                    if (col != 0) {
                        rgb[x1] = ((col & 0xFF00FF) * isz2 & 0xFF00FF00 | (col & 0xFF00) * isz2 & 0xFF0000) >>> 8;
                    }
                    ++x1;
                }
            }
            x_start += dx_start;
            wz_start += dwz_start;
            uz_start += duz_start;
            vz_start += dvz_start;
            x_end += dx_end;
            wz_end += dwz_end;
            uz_end += duz_end;
            vz_end += dvz_end;
        }
    }

    static final void paintMiniTrianglePers_5_4X(Graphics3D g3d, Texture texture, int y_start, int y_end, int x_start, int wz_start, int uz_start, int vz_start, int x_end, int wz_end, int uz_end, int vz_end, int dx_start, int dwz_start, int duz_start, int dvz_start, int dx_end, int dwz_end, int duz_end, int dvz_end, int dwz, int duz, int dvz, int fogc, int sz2, int q, Vertex a, Vertex b, Vertex c) {
        int[] tex = texture.rImg.img;
        int lengthBIT = tex.length - 1;
        int widthBIT = texture.widthBIT;
        int[] rgb = g3d.display;
        int duz4 = duz * q;
        int dvz4 = dvz * q;
        int dwz4 = dwz * q;
        if (Graphics3D.fDist / 255 != 0) {
            sz2 = -Texturing.max(a.rz, b.rz, c.rz) / (Graphics3D.fDist / 255);
        }
        if (sz2 > 255) {
            sz2 = 255;
        }
        if (sz2 < 0) {
            sz2 = 0;
        }
        int isz2 = 255 - sz2;
        int f2 = (fogc & 0xFF00FF) * sz2;
        int f22 = (fogc & 0xFF00) * sz2;
        for (int y = y_start; y < y_end; ++y) {
            int col;
            int dv;
            int du;
            int v_2;
            int u_2;
            int length;
            int wz_b;
            int wz_a;
            int vz_b;
            int vz_a;
            int uz_b;
            int uz_a;
            int x2;
            int x1;
            if (x_start > x_end) {
                x1 = x_end;
                x2 = x_start;
                uz_a = uz_end;
                uz_b = uz_start;
                vz_a = vz_end;
                vz_b = vz_start;
                wz_a = wz_end;
                wz_b = wz_start;
            } else {
                x1 = x_start;
                x2 = x_end;
                uz_a = uz_start;
                uz_b = uz_end;
                vz_a = vz_start;
                vz_b = vz_end;
                wz_a = wz_start;
                wz_b = wz_end;
            }
            long subtexel_a = x1 % 4096;
            long subtexel_b = x2 % 4096;
            uz_a = (int)((long)uz_a - ((long)duz * subtexel_a >> 12));
            vz_a = (int)((long)vz_a - ((long)dvz * subtexel_a >> 12));
            wz_a = (int)((long)wz_a - ((long)dwz * subtexel_a >> 12));
            uz_b = (int)((long)uz_b - ((long)duz * subtexel_b >> 12));
            vz_b = (int)((long)vz_b - ((long)dvz * subtexel_b >> 12));
            wz_b = (int)((long)wz_b - ((long)dwz * subtexel_b >> 12));
            x2 >>= 12;
            if ((x1 >>= 12) < 0) {
                uz_a -= duz * x1;
                vz_a -= dvz * x1;
                wz_a -= dwz * x1;
                x1 = 0;
            }
            if (x2 > g3d.width) {
                uz_b -= duz * (x2 -= g3d.width);
                vz_b -= dvz * x2;
                wz_b -= dwz * x2;
                x2 = g3d.width;
            }
            int tempI = y * g3d.width;
            if (wz_a == 0) {
                return;
            }
            int u = (int)(((long)uz_a << 12) / (long)wz_a);
            int v = (int)(((long)vz_a << 12) / (long)wz_a);
            for (length = (x2 += tempI) - (x1 += tempI); length >= q; length -= q) {
                u_2 = (int)(((long)(uz_a += duz4) << 12) / (long)(wz_a += dwz4));
                v_2 = (int)(((long)(vz_a += dvz4) << 12) / (long)wz_a);
                du = (u_2 - u) / q;
                dv = (v_2 - v) / q;
                int i = x1 + q;
                while (i - x1 >= 4) {
                    col = tex[((v += dv) >> 12 << widthBIT) + ((u += du) >> 12) & lengthBIT];
                    if (col != 0) {
                        rgb[x1] = col = ((col & 0xFF00FF) * isz2 & 0xFF00FF00 | (col & 0xFF00) * isz2 & 0xFF0000) >>> 8;
                        rgb[x1 + 1] = col;
                        rgb[x1 + 2] = col;
                        rgb[x1 + 3] = col;
                    }
                    u += du * 3;
                    v += dv * 3;
                    x1 += 4;
                }
                while (x1 < i) {
                    col = tex[((v += dv) >> 12 << widthBIT) + ((u += du) >> 12) & lengthBIT];
                    if (col != 0) {
                        rgb[x1] = ((col & 0xFF00FF) * isz2 & 0xFF00FF00 | (col & 0xFF00) * isz2 & 0xFF0000) >>> 8;
                    }
                    ++x1;
                }
            }
            if (length > 0) {
                u_2 = (int)(((long)uz_b << 12) / (long)wz_b);
                v_2 = (int)(((long)vz_b << 12) / (long)wz_b);
                du = (u_2 - u) / length;
                dv = (v_2 - v) / length;
                while (x2 - x1 >= 4) {
                    col = tex[((v += dv) >> 12 << widthBIT) + ((u += du) >> 12) & lengthBIT];
                    if (col != 0) {
                        rgb[x1] = col = ((col & 0xFF00FF) * isz2 & 0xFF00FF00 | (col & 0xFF00) * isz2 & 0xFF0000) >>> 8;
                        rgb[x1 + 1] = col;
                        rgb[x1 + 2] = col;
                        rgb[x1 + 3] = col;
                    }
                    u += du * 3;
                    v += dv * 3;
                    x1 += 4;
                }
                while (x1 < x2) {
                    col = tex[((v += dv) >> 12 << widthBIT) + ((u += du) >> 12) & lengthBIT];
                    if (col != 0) {
                        rgb[x1] = ((col & 0xFF00FF) * isz2 & 0xFF00FF00 | (col & 0xFF00) * isz2 & 0xFF0000) >>> 8;
                    }
                    ++x1;
                }
            }
            x_start += dx_start;
            wz_start += dwz_start;
            uz_start += duz_start;
            vz_start += dvz_start;
            x_end += dx_end;
            wz_end += dwz_end;
            uz_end += duz_end;
            vz_end += dvz_end;
        }
    }

    static final void paintMiniTrianglePers_6_HQ(Graphics3D g3d, Texture texture, int y_start, int y_end, int x_start, int wz_start, int uz_start, int vz_start, int x_end, int wz_end, int uz_end, int vz_end, int dx_start, int dwz_start, int duz_start, int dvz_start, int dx_end, int dwz_end, int duz_end, int dvz_end, int dwz, int duz, int dvz, int fogc, int sz2, int q, Vertex a, Vertex b, Vertex c, int f_start, int f_end, int df_start, int df_end, int df) {
        int[] tex = texture.rImg.img;
        int lengthBIT = tex.length - 1;
        int widthBIT = texture.widthBIT;
        int[] rgb = g3d.display;
        int duz4 = duz * q;
        int dvz4 = dvz * q;
        int dwz4 = dwz * q;
        for (int y = y_start; y < y_end; ++y) {
            int col;
            int dv;
            int du;
            int v_2;
            int u_2;
            int length;
            int f;
            int wz_b;
            int wz_a;
            int vz_b;
            int vz_a;
            int uz_b;
            int uz_a;
            int x2;
            int x1;
            if (x_start > x_end) {
                x1 = x_end;
                x2 = x_start;
                uz_a = uz_end;
                uz_b = uz_start;
                vz_a = vz_end;
                vz_b = vz_start;
                wz_a = wz_end;
                wz_b = wz_start;
                f = f_end;
            } else {
                x1 = x_start;
                x2 = x_end;
                uz_a = uz_start;
                uz_b = uz_end;
                vz_a = vz_start;
                vz_b = vz_end;
                wz_a = wz_start;
                wz_b = wz_end;
                f = f_start;
            }
            long subtexel_a = x1 % 4096;
            long subtexel_b = x2 % 4096;
            uz_a = (int)((long)uz_a - ((long)duz * subtexel_a >> 12));
            vz_a = (int)((long)vz_a - ((long)dvz * subtexel_a >> 12));
            wz_a = (int)((long)wz_a - ((long)dwz * subtexel_a >> 12));
            uz_b = (int)((long)uz_b - ((long)duz * subtexel_b >> 12));
            vz_b = (int)((long)vz_b - ((long)dvz * subtexel_b >> 12));
            wz_b = (int)((long)wz_b - ((long)dwz * subtexel_b >> 12));
            x2 >>= 12;
            if ((x1 >>= 12) < 0) {
                uz_a -= duz * x1;
                vz_a -= dvz * x1;
                wz_a -= dwz * x1;
                f -= df * x1;
                x1 = 0;
            }
            if (x2 > g3d.width) {
                uz_b -= duz * (x2 -= g3d.width);
                vz_b -= dvz * x2;
                wz_b -= dwz * x2;
                x2 = g3d.width;
            }
            int tempI = y * g3d.width;
            if (wz_a == 0) {
                return;
            }
            int u = (int)(((long)uz_a << 12) / (long)wz_a);
            int v = (int)(((long)vz_a << 12) / (long)wz_a);
            for (length = (x2 += tempI) - (x1 += tempI); length >= q; length -= q) {
                u_2 = (int)(((long)(uz_a += duz4) << 12) / (long)(wz_a += dwz4));
                v_2 = (int)(((long)(vz_a += dvz4) << 12) / (long)wz_a);
                du = (u_2 - u) / q;
                dv = (v_2 - v) / q;
                int i = x1 + q;
                while (x1 < i) {
                    int isz2 = (f += df) >> 12;
                    col = tex[((v += dv) >> 12 << widthBIT) + ((u += du) >> 12) & lengthBIT];
                    if (col != 0) {
                        rgb[x1] = ((col & 0xFF00FF) * isz2 & 0xFF00FF00 | (col & 0xFF00) * isz2 & 0xFF0000) >>> 8;
                    }
                    ++x1;
                }
            }
            if (length > 0) {
                u_2 = (int)(((long)uz_b << 12) / (long)wz_b);
                v_2 = (int)(((long)vz_b << 12) / (long)wz_b);
                du = (u_2 - u) / length;
                dv = (v_2 - v) / length;
                while (x1 < x2) {
                    int isz2 = (f += df) >> 12;
                    col = tex[((v += dv) >> 12 << widthBIT) + ((u += du) >> 12) & lengthBIT];
                    if (col != 0) {
                        rgb[x1] = ((col & 0xFF00FF) * isz2 & 0xFF00FF00 | (col & 0xFF00) * isz2 & 0xFF0000) >>> 8;
                    }
                    ++x1;
                }
            }
            x_start += dx_start;
            wz_start += dwz_start;
            uz_start += duz_start;
            vz_start += dvz_start;
            f_start += df_start;
            x_end += dx_end;
            wz_end += dwz_end;
            uz_end += duz_end;
            vz_end += dvz_end;
            f_end += df_end;
        }
    }

    static final void paintMiniTrianglePers_6_HQ_2X(Graphics3D g3d, Texture texture, int y_start, int y_end, int x_start, int wz_start, int uz_start, int vz_start, int x_end, int wz_end, int uz_end, int vz_end, int dx_start, int dwz_start, int duz_start, int dvz_start, int dx_end, int dwz_end, int duz_end, int dvz_end, int dwz, int duz, int dvz, int fogc, int sz2, int q, Vertex a, Vertex b, Vertex c, int f_start, int f_end, int df_start, int df_end, int df) {
        int[] tex = texture.rImg.img;
        int lengthBIT = tex.length - 1;
        int widthBIT = texture.widthBIT;
        int[] rgb = g3d.display;
        int duz4 = duz * q;
        int dvz4 = dvz * q;
        int dwz4 = dwz * q;
        for (int y = y_start; y < y_end; ++y) {
            int col;
            int dv;
            int du;
            int v_2;
            int u_2;
            int length;
            int f;
            int wz_b;
            int wz_a;
            int vz_b;
            int vz_a;
            int uz_b;
            int uz_a;
            int x2;
            int x1;
            if (x_start > x_end) {
                x1 = x_end;
                x2 = x_start;
                uz_a = uz_end;
                uz_b = uz_start;
                vz_a = vz_end;
                vz_b = vz_start;
                wz_a = wz_end;
                wz_b = wz_start;
                f = f_end;
            } else {
                x1 = x_start;
                x2 = x_end;
                uz_a = uz_start;
                uz_b = uz_end;
                vz_a = vz_start;
                vz_b = vz_end;
                wz_a = wz_start;
                wz_b = wz_end;
                f = f_start;
            }
            long subtexel_a = x1 % 4096;
            long subtexel_b = x2 % 4096;
            uz_a = (int)((long)uz_a - ((long)duz * subtexel_a >> 12));
            vz_a = (int)((long)vz_a - ((long)dvz * subtexel_a >> 12));
            wz_a = (int)((long)wz_a - ((long)dwz * subtexel_a >> 12));
            uz_b = (int)((long)uz_b - ((long)duz * subtexel_b >> 12));
            vz_b = (int)((long)vz_b - ((long)dvz * subtexel_b >> 12));
            wz_b = (int)((long)wz_b - ((long)dwz * subtexel_b >> 12));
            x2 >>= 12;
            if ((x1 >>= 12) < 0) {
                uz_a -= duz * x1;
                vz_a -= dvz * x1;
                wz_a -= dwz * x1;
                f -= df * x1;
                x1 = 0;
            }
            if (x2 > g3d.width) {
                uz_b -= duz * (x2 -= g3d.width);
                vz_b -= dvz * x2;
                wz_b -= dwz * x2;
                x2 = g3d.width;
            }
            int tempI = y * g3d.width;
            if (wz_a == 0) {
                return;
            }
            int u = (int)(((long)uz_a << 12) / (long)wz_a);
            int v = (int)(((long)vz_a << 12) / (long)wz_a);
            for (length = (x2 += tempI) - (x1 += tempI); length >= q; length -= q) {
                int isz2;
                u_2 = (int)(((long)(uz_a += duz4) << 12) / (long)(wz_a += dwz4));
                v_2 = (int)(((long)(vz_a += dvz4) << 12) / (long)wz_a);
                du = (u_2 - u) / q;
                dv = (v_2 - v) / q;
                int i = x1 + q;
                while (x1 < i && x1 % 2 != 0) {
                    isz2 = (f += df) >> 12;
                    col = tex[((v += dv) >> 12 << widthBIT) + ((u += du) >> 12) & lengthBIT];
                    if (col != 0) {
                        rgb[x1] = ((col & 0xFF00FF) * isz2 & 0xFF00FF00 | (col & 0xFF00) * isz2 & 0xFF0000) >>> 8;
                    }
                    ++x1;
                }
                while (i - x1 >= 2) {
                    isz2 = (f += df) >> 12;
                    col = tex[((v += dv) >> 12 << widthBIT) + ((u += du) >> 12) & lengthBIT];
                    if (col != 0) {
                        rgb[x1] = col = ((col & 0xFF00FF) * isz2 & 0xFF00FF00 | (col & 0xFF00) * isz2 & 0xFF0000) >>> 8;
                        rgb[x1 + 1] = col;
                    }
                    u += du;
                    v += dv;
                    f += df;
                    x1 += 2;
                }
                while (x1 < i) {
                    isz2 = (f += df) >> 12;
                    col = tex[((v += dv) >> 12 << widthBIT) + ((u += du) >> 12) & lengthBIT];
                    if (col != 0) {
                        rgb[x1] = ((col & 0xFF00FF) * isz2 & 0xFF00FF00 | (col & 0xFF00) * isz2 & 0xFF0000) >>> 8;
                    }
                    ++x1;
                }
            }
            if (length > 0) {
                int isz2;
                u_2 = (int)(((long)uz_b << 12) / (long)wz_b);
                v_2 = (int)(((long)vz_b << 12) / (long)wz_b);
                du = (u_2 - u) / length;
                dv = (v_2 - v) / length;
                while (x1 < x2 && x1 % 2 != 0) {
                    isz2 = (f += df) >> 12;
                    col = tex[((v += dv) >> 12 << widthBIT) + ((u += du) >> 12) & lengthBIT];
                    if (col != 0) {
                        rgb[x1] = ((col & 0xFF00FF) * isz2 & 0xFF00FF00 | (col & 0xFF00) * isz2 & 0xFF0000) >>> 8;
                    }
                    ++x1;
                }
                while (x2 - x1 >= 2) {
                    isz2 = (f += df) >> 12;
                    col = tex[((v += dv) >> 12 << widthBIT) + ((u += du) >> 12) & lengthBIT];
                    if (col != 0) {
                        rgb[x1] = col = ((col & 0xFF00FF) * isz2 & 0xFF00FF00 | (col & 0xFF00) * isz2 & 0xFF0000) >>> 8;
                        rgb[x1 + 1] = col;
                    }
                    u += du;
                    v += dv;
                    f += df;
                    x1 += 2;
                }
                while (x1 < x2) {
                    isz2 = (f += df) >> 12;
                    col = tex[((v += dv) >> 12 << widthBIT) + ((u += du) >> 12) & lengthBIT];
                    if (col != 0) {
                        rgb[x1] = ((col & 0xFF00FF) * isz2 & 0xFF00FF00 | (col & 0xFF00) * isz2 & 0xFF0000) >>> 8;
                    }
                    ++x1;
                }
            }
            x_start += dx_start;
            wz_start += dwz_start;
            uz_start += duz_start;
            vz_start += dvz_start;
            f_start += df_start;
            x_end += dx_end;
            wz_end += dwz_end;
            uz_end += duz_end;
            vz_end += dvz_end;
            f_end += df_end;
        }
    }

    static final void paintMiniTrianglePers_6_HQ_4X(Graphics3D g3d, Texture texture, int y_start, int y_end, int x_start, int wz_start, int uz_start, int vz_start, int x_end, int wz_end, int uz_end, int vz_end, int dx_start, int dwz_start, int duz_start, int dvz_start, int dx_end, int dwz_end, int duz_end, int dvz_end, int dwz, int duz, int dvz, int fogc, int sz2, int q, Vertex a, Vertex b, Vertex c, int f_start, int f_end, int df_start, int df_end, int df) {
        int[] tex = texture.rImg.img;
        int lengthBIT = tex.length - 1;
        int widthBIT = texture.widthBIT;
        int[] rgb = g3d.display;
        int duz4 = duz * q;
        int dvz4 = dvz * q;
        int dwz4 = dwz * q;
        for (int y = y_start; y < y_end; ++y) {
            int col;
            int dv;
            int du;
            int v_2;
            int u_2;
            int length;
            int f;
            int wz_b;
            int wz_a;
            int vz_b;
            int vz_a;
            int uz_b;
            int uz_a;
            int x2;
            int x1;
            if (x_start > x_end) {
                x1 = x_end;
                x2 = x_start;
                uz_a = uz_end;
                uz_b = uz_start;
                vz_a = vz_end;
                vz_b = vz_start;
                wz_a = wz_end;
                wz_b = wz_start;
                f = f_end;
            } else {
                x1 = x_start;
                x2 = x_end;
                uz_a = uz_start;
                uz_b = uz_end;
                vz_a = vz_start;
                vz_b = vz_end;
                wz_a = wz_start;
                wz_b = wz_end;
                f = f_start;
            }
            long subtexel_a = x1 % 4096;
            long subtexel_b = x2 % 4096;
            uz_a = (int)((long)uz_a - ((long)duz * subtexel_a >> 12));
            vz_a = (int)((long)vz_a - ((long)dvz * subtexel_a >> 12));
            wz_a = (int)((long)wz_a - ((long)dwz * subtexel_a >> 12));
            uz_b = (int)((long)uz_b - ((long)duz * subtexel_b >> 12));
            vz_b = (int)((long)vz_b - ((long)dvz * subtexel_b >> 12));
            wz_b = (int)((long)wz_b - ((long)dwz * subtexel_b >> 12));
            x2 >>= 12;
            if ((x1 >>= 12) < 0) {
                uz_a -= duz * x1;
                vz_a -= dvz * x1;
                wz_a -= dwz * x1;
                f -= df * x1;
                x1 = 0;
            }
            if (x2 > g3d.width) {
                uz_b -= duz * (x2 -= g3d.width);
                vz_b -= dvz * x2;
                wz_b -= dwz * x2;
                x2 = g3d.width;
            }
            int tempI = y * g3d.width;
            if (wz_a == 0) {
                return;
            }
            int u = (int)(((long)uz_a << 12) / (long)wz_a);
            int v = (int)(((long)vz_a << 12) / (long)wz_a);
            for (length = (x2 += tempI) - (x1 += tempI); length >= q; length -= q) {
                int isz2;
                u_2 = (int)(((long)(uz_a += duz4) << 12) / (long)(wz_a += dwz4));
                v_2 = (int)(((long)(vz_a += dvz4) << 12) / (long)wz_a);
                du = (u_2 - u) / q;
                dv = (v_2 - v) / q;
                int i = x1 + q;
                while (x1 < i && x1 % 4 != 0) {
                    isz2 = (f += df) >> 12;
                    col = tex[((v += dv) >> 12 << widthBIT) + ((u += du) >> 12) & lengthBIT];
                    if (col != 0) {
                        rgb[x1] = ((col & 0xFF00FF) * isz2 & 0xFF00FF00 | (col & 0xFF00) * isz2 & 0xFF0000) >>> 8;
                    }
                    ++x1;
                }
                while (i - x1 >= 4) {
                    isz2 = (f += df) >> 12;
                    col = tex[((v += dv) >> 12 << widthBIT) + ((u += du) >> 12) & lengthBIT];
                    if (col != 0) {
                        rgb[x1] = col = ((col & 0xFF00FF) * isz2 & 0xFF00FF00 | (col & 0xFF00) * isz2 & 0xFF0000) >>> 8;
                        rgb[x1 + 1] = col;
                        rgb[x1 + 2] = col;
                        rgb[x1 + 3] = col;
                    }
                    u += du * 3;
                    v += dv * 3;
                    f += df * 3;
                    x1 += 4;
                }
                while (x1 < i) {
                    isz2 = (f += df) >> 12;
                    col = tex[((v += dv) >> 12 << widthBIT) + ((u += du) >> 12) & lengthBIT];
                    if (col != 0) {
                        rgb[x1] = ((col & 0xFF00FF) * isz2 & 0xFF00FF00 | (col & 0xFF00) * isz2 & 0xFF0000) >>> 8;
                    }
                    ++x1;
                }
            }
            if (length > 0) {
                int isz2;
                u_2 = (int)(((long)uz_b << 12) / (long)wz_b);
                v_2 = (int)(((long)vz_b << 12) / (long)wz_b);
                du = (u_2 - u) / length;
                dv = (v_2 - v) / length;
                while (x1 < x2 && x1 % 4 != 0) {
                    isz2 = (f += df) >> 12;
                    col = tex[((v += dv) >> 12 << widthBIT) + ((u += du) >> 12) & lengthBIT];
                    if (col != 0) {
                        rgb[x1] = ((col & 0xFF00FF) * isz2 & 0xFF00FF00 | (col & 0xFF00) * isz2 & 0xFF0000) >>> 8;
                    }
                    ++x1;
                }
                while (x2 - x1 >= 4) {
                    isz2 = (f += df) >> 12;
                    col = tex[((v += dv) >> 12 << widthBIT) + ((u += du) >> 12) & lengthBIT];
                    if (col != 0) {
                        rgb[x1] = col = ((col & 0xFF00FF) * isz2 & 0xFF00FF00 | (col & 0xFF00) * isz2 & 0xFF0000) >>> 8;
                        rgb[x1 + 1] = col;
                        rgb[x1 + 2] = col;
                        rgb[x1 + 3] = col;
                    }
                    u += du * 3;
                    v += dv * 3;
                    f += df * 3;
                    x1 += 4;
                }
                while (x1 < x2) {
                    isz2 = (f += df) >> 12;
                    col = tex[((v += dv) >> 12 << widthBIT) + ((u += du) >> 12) & lengthBIT];
                    if (col != 0) {
                        rgb[x1] = ((col & 0xFF00FF) * isz2 & 0xFF00FF00 | (col & 0xFF00) * isz2 & 0xFF0000) >>> 8;
                    }
                    ++x1;
                }
            }
            x_start += dx_start;
            wz_start += dwz_start;
            uz_start += duz_start;
            vz_start += dvz_start;
            f_start += df_start;
            x_end += dx_end;
            wz_end += dwz_end;
            uz_end += duz_end;
            vz_end += dvz_end;
            f_end += df_end;
        }
    }

    static final void paintPers_glass(Graphics3D g3d, Texture texture, int y_start, int y_end, int x_start, int wz_start, int uz_start, int vz_start, int x_end, int wz_end, int uz_end, int vz_end, int dx_start, int dwz_start, int duz_start, int dvz_start, int dx_end, int dwz_end, int duz_end, int dvz_end, int dwz, int duz, int dvz, int fogc, int sz2) {
        int[] tex = texture.rImg.img;
        int lengthBIT = tex.length - 1;
        int widthBIT = texture.widthBIT;
        int[] rgb = g3d.display;
        int scale = 50;
        scale = scale * (g3d.getHeight() + g3d.getWidth()) / 560;
        int duz4 = duz * sz2;
        int dvz4 = dvz * sz2;
        int dwz4 = dwz * sz2;
        for (int y = y_start; y < y_end; ++y) {
            int col;
            int dv;
            int du;
            int v_2;
            int u_2;
            int length;
            int wz_b;
            int wz_a;
            int vz_b;
            int vz_a;
            int uz_b;
            int uz_a;
            int x2;
            int x1;
            if (x_start > x_end) {
                x1 = x_end;
                x2 = x_start;
                uz_a = uz_end;
                uz_b = uz_start;
                vz_a = vz_end;
                vz_b = vz_start;
                wz_a = wz_end;
                wz_b = wz_start;
            } else {
                x1 = x_start;
                x2 = x_end;
                uz_a = uz_start;
                uz_b = uz_end;
                vz_a = vz_start;
                vz_b = vz_end;
                wz_a = wz_start;
                wz_b = wz_end;
            }
            long subtexel_a = x1 % 4096;
            long subtexel_b = x2 % 4096;
            uz_a = (int)((long)uz_a - ((long)duz * subtexel_a >> 12));
            vz_a = (int)((long)vz_a - ((long)dvz * subtexel_a >> 12));
            wz_a = (int)((long)wz_a - ((long)dwz * subtexel_a >> 12));
            uz_b = (int)((long)uz_b - ((long)duz * subtexel_b >> 12));
            vz_b = (int)((long)vz_b - ((long)dvz * subtexel_b >> 12));
            wz_b = (int)((long)wz_b - ((long)dwz * subtexel_b >> 12));
            x2 >>= 12;
            if ((x1 >>= 12) < 0) {
                uz_a -= duz * x1;
                vz_a -= dvz * x1;
                wz_a -= dwz * x1;
                x1 = 0;
            }
            if (x2 > g3d.width) {
                uz_b -= duz * (x2 -= g3d.width);
                vz_b -= dvz * x2;
                wz_b -= dwz * x2;
                x2 = g3d.width;
            }
            int tempI = y * g3d.width;
            if (wz_a == 0) {
                return;
            }
            int u = (int)(((long)uz_a << 12) / (long)wz_a);
            int v = (int)(((long)vz_a << 12) / (long)wz_a);
            for (length = (x2 += tempI) - (x1 += tempI); length >= sz2; length -= sz2) {
                u_2 = (int)(((long)(uz_a += duz4) << 12) / (long)(wz_a += dwz4));
                v_2 = (int)(((long)(vz_a += dvz4) << 12) / (long)wz_a);
                du = (u_2 - u) / sz2;
                dv = (v_2 - v) / sz2;
                int i = x1 + sz2;
                while (x1 < i) {
                    col = tex[((v += dv) >> 12 << widthBIT) + ((u += du) >> 12) & lengthBIT];
                    int cr = ((col >> 16 & 0xFF) - 128) * scale / 200;
                    int cg = ((col >> 8 & 0xFF) - 128) * scale / 200;
                    int coord = x1 + cr + cg * g3d.getWidth();
                    if (coord >= g3d.getDisplay().length) {
                        coord = g3d.getDisplay().length - 1;
                    }
                    if (coord < 0) {
                        coord = 0;
                    }
                    rgb[x1] = col = rgb[coord];
                    ++x1;
                }
            }
            if (length > 0) {
                u_2 = (int)(((long)uz_b << 12) / (long)wz_b);
                v_2 = (int)(((long)vz_b << 12) / (long)wz_b);
                du = (u_2 - u) / length;
                dv = (v_2 - v) / length;
                while (x1 < x2) {
                    col = tex[((v += dv) >> 12 << widthBIT) + ((u += du) >> 12) & lengthBIT];
                    int cr = ((col >> 16 & 0xFF) - 128) * scale / 200;
                    int cg = ((col >> 8 & 0xFF) - 128) * scale / 200;
                    int coord = x1 + cr + cg * g3d.getWidth();
                    if (coord >= g3d.getDisplay().length) {
                        coord = g3d.getDisplay().length - 1;
                    }
                    if (coord < 0) {
                        coord = 0;
                    }
                    rgb[x1] = rgb[coord];
                    ++x1;
                }
            }
            x_start += dx_start;
            wz_start += dwz_start;
            uz_start += duz_start;
            vz_start += dvz_start;
            x_end += dx_end;
            wz_end += dwz_end;
            uz_end += duz_end;
            vz_end += dvz_end;
        }
    }

    private static final int max(int a, int b, int c) {
        if (a == b || b == c) {
            return Texturing.min(a, c);
        }
        if (a == c) {
            return Texturing.min(a, b);
        }
        if (a < b && a < c) {
            return a;
        }
        if (b < a && b < c) {
            return b;
        }
        return c;
    }

    private static final int min(int a, int b) {
        if (a < b) {
            return a;
        }
        return b;
    }
}

