/*
 * Decompiled with CFR 0.152.
 */
package com.Gameplay;

import com.Gameplay.GameScreen;
import com.Gameplay.Shop;
import com.Gameplay.Weapon;
import com.misc.Main;
import com.misc.Stringer;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;

public class Arsenal {
    private static Main main;
    public static Weapon[] weapons;
    public static int current;
    public static boolean hasHand;

    public Arsenal(int width_g3d, int height_g3d) {
        current = -1;
        weapons = new Weapon[Shop.weapon_count];
        if (Shop.defaultArsenal != null) {
            for (int i = 0; i < Shop.defaultArsenal.length; ++i) {
                if (Shop.defaultArsenal[i] != -1) {
                    Arsenal.weapons[Shop.defaultArsenal[i]] = Stringer.createWeapon(Shop.defaultArsenal[i]);
                    if (current == -1) {
                        current = Shop.defaultArsenal[i];
                    }
                }
                if (Shop.defaultArsenal[i] != -1) continue;
                hasHand = true;
            }
        } else {
            hasHand = true;
            current = -1;
        }
        for (int var3 = 0; var3 < weapons.length; ++var3) {
            if (weapons[var3] == null) continue;
            weapons[var3].reset();
            if (!weapons[var3].isTwoHands()) {
                weapons[var3].setAmmo(200);
                continue;
            }
            weapons[var3].setAmmo(400);
        }
        if (Arsenal.currentWeapon() != null) {
            Arsenal.currentWeapon().createSprite(width_g3d, height_g3d);
        }
    }

    public static final void destroy() {
        for (int var1 = 0; var1 < weapons.length; ++var1) {
            if (weapons[var1] == null) continue;
            weapons[var1].reset();
            Arsenal.weapons[var1] = null;
        }
        weapons = null;
    }

    public static final Weapon currentWeapon() {
        if (current >= 0 && current < weapons.length) {
            return weapons[current];
        }
        return null;
    }

    public static final Weapon[] getWeapons() {
        return weapons;
    }

    public static final void next() {
        if (Arsenal.currentWeapon() != null) {
            Arsenal.currentWeapon().reset();
        }
        if (++current >= weapons.length) {
            current = 0;
            if (hasHand) {
                current = -1;
            }
        }
        if (current != -1 && weapons[current] == null) {
            Arsenal.next();
            return;
        }
    }

    public static final void previous() {
        if (Arsenal.currentWeapon() != null) {
            Arsenal.currentWeapon().reset();
        }
        if (--current < 0 && !hasHand || current < -1 && hasHand) {
            current = weapons.length - 1;
        }
        if (current != -1 && weapons[current] == null) {
            Arsenal.previous();
            return;
        }
    }

    public static final void drawWeapon(Graphics g, int y, int width, int height, GameScreen gs) {
        if (current == -1) {
            return;
        }
        if (Arsenal.currentWeapon() == null) {
            return;
        }
        Weapon var5 = Arsenal.currentWeapon();
        if (!gs.player.zoom || !var5.hasZoom) {
            var5.draw(g, 0, y, width, height);
        } else {
            var5.drawSight(g, 0, y, width, height);
        }
        if (var5.isReloading()) {
            int var6 = Math.max(height / 50, 6);
            int var10001 = (width /= 2) - width / 2;
            int var10002 = height - var6 - 2 + y;
            int var10004 = var6;
            var6 = var5.reloadingPercentage();
            int var7 = var10004;
            height = width;
            width = var10002;
            y = var10001;
            g.setColor(0xFFFFFF);
            g.drawRect(y, width, height, var7);
            g.fillRect(y, width, height * var6 / 100, var7);
        }
    }

    public Arsenal() {
    }

    public static Image resize(Image img, float scaleW, float scaleH) {
        if (scaleH != 1.0f && scaleW != 1.0f) {
            return Arsenal.resize(img, (int)((float)img.getWidth() * scaleW), (int)((float)img.getHeight() * scaleH));
        }
        return img;
    }

    public static Image resize(Image img, int new_width, int new_height) {
        if (img.getWidth() == new_width && img.getHeight() == new_height) {
            return img;
        }
        int[] var3 = new int[img.getWidth() * img.getHeight()];
        img.getRGB(var3, 0, img.getWidth(), 0, 0, img.getWidth(), img.getHeight());
        int[] var4 = new int[new_width * new_height];
        int[] var10000 = var3;
        int var10002 = img.getWidth();
        int var10003 = img.getHeight();
        boolean var21 = true;
        int var8 = new_height;
        int var7 = new_width;
        int var6 = var10003;
        int var5 = var10002;
        var3 = var4;
        int[] var22 = var10000;
        try {
            for (int var9 = 0; var9 < var7; ++var9) {
                for (int var10 = 0; var10 < var8; ++var10) {
                    int var18;
                    int var11 = (var9 << 16) / var7 * var5;
                    int var12 = (var10 << 16) / var8 * var6;
                    int var13 = var11 >>> 16;
                    int var14 = var12 >>> 16;
                    var11 &= 0xFFFF;
                    var12 &= 0xFFFF;
                    int var17 = var18 = var13 + var14 * var5;
                    int var16 = var18;
                    int var15 = var18++;
                    if (var13 < var5 - 1) {
                        ++var16;
                    }
                    if (var14 < var6 - 1) {
                        var17 += var5;
                        var18 += var5;
                    }
                    var13 = ((var22[var15] >>> 24) * (65535 - var11) + (var22[var16] >>> 24) * var11 >>> 16) * (65535 - var12) + ((var22[var17] >>> 24) * (65535 - var11) + (var22[var18] >>> 24) * var11 >>> 16) * var12 >>> 16;
                    var14 = ((var22[var15] >> 16 & 0xFF) * (65535 - var11) + (var22[var16] >> 16 & 0xFF) * var11 >>> 16) * (65535 - var12) + ((var22[var17] >> 16 & 0xFF) * (65535 - var11) + (var22[var18] >> 16 & 0xFF) * var11 >>> 16) * var12 >>> 16;
                    int var19 = ((var22[var15] >> 8 & 0xFF) * (65535 - var11) + (var22[var16] >> 8 & 0xFF) * var11 >>> 16) * (65535 - var12) + ((var22[var17] >> 8 & 0xFF) * (65535 - var11) + (var22[var18] >> 8 & 0xFF) * var11 >>> 16) * var12 >>> 16;
                    var11 = ((var22[var15] & 0xFF) * (65535 - var11) + (var22[var16] & 0xFF) * var11 >>> 16) * (65535 - var12) + ((var22[var17] & 0xFF) * (65535 - var11) + (var22[var18] & 0xFF) * var11 >>> 16) * var12 >>> 16;
                    var3[var9 + var10 * var7] = var13 << 24 | var14 << 16 | var19 << 8 | var11;
                }
            }
        }
        catch (ArrayIndexOutOfBoundsException var20) {
            var20.printStackTrace();
        }
        return Image.createRGBImage((int[])var4, (int)new_width, (int)new_height, (boolean)true);
    }

    public static int[] resize2(int[] var3, int img_width, int img_height, int new_width, int new_height) {
        if (img_width == new_width && img_height == new_height) {
            return var3;
        }
        int[] var4 = new int[new_width * new_height];
        int var10002 = img_width;
        int var10003 = img_height;
        boolean var21 = true;
        int var8 = new_height;
        int var7 = new_width;
        int var6 = var10003;
        int var5 = var10002;
        try {
            for (int var9 = 0; var9 < var7; ++var9) {
                for (int var10 = 0; var10 < var8; ++var10) {
                    int var18;
                    int var11 = (var9 << 16) / var7 * var5;
                    int var12 = (var10 << 16) / var8 * var6;
                    int var13 = var11 >>> 16;
                    int var14 = var12 >>> 16;
                    var11 &= 0xFFFF;
                    var12 &= 0xFFFF;
                    int var17 = var18 = var13 + var14 * var5;
                    int var16 = var18;
                    int var15 = var18++;
                    if (var13 < var5 - 1) {
                        ++var16;
                    }
                    if (var14 < var6 - 1) {
                        var17 += var5;
                        var18 += var5;
                    }
                    var13 = ((var3[var15] >>> 24) * (65535 - var11) + (var3[var16] >>> 24) * var11 >>> 16) * (65535 - var12) + ((var3[var17] >>> 24) * (65535 - var11) + (var3[var18] >>> 24) * var11 >>> 16) * var12 >>> 16;
                    var14 = ((var3[var15] >> 16 & 0xFF) * (65535 - var11) + (var3[var16] >> 16 & 0xFF) * var11 >>> 16) * (65535 - var12) + ((var3[var17] >> 16 & 0xFF) * (65535 - var11) + (var3[var18] >> 16 & 0xFF) * var11 >>> 16) * var12 >>> 16;
                    int var19 = ((var3[var15] >> 8 & 0xFF) * (65535 - var11) + (var3[var16] >> 8 & 0xFF) * var11 >>> 16) * (65535 - var12) + ((var3[var17] >> 8 & 0xFF) * (65535 - var11) + (var3[var18] >> 8 & 0xFF) * var11 >>> 16) * var12 >>> 16;
                    var11 = ((var3[var15] & 0xFF) * (65535 - var11) + (var3[var16] & 0xFF) * var11 >>> 16) * (65535 - var12) + ((var3[var17] & 0xFF) * (65535 - var11) + (var3[var18] & 0xFF) * var11 >>> 16) * var12 >>> 16;
                    var4[var9 + var10 * var7] = var13 << 24 | var14 << 16 | var19 << 8 | var11;
                }
            }
        }
        catch (ArrayIndexOutOfBoundsException var20) {
            var20.printStackTrace();
        }
        return var4;
    }

    public static int[] resize3(int[] var3, int img_width, int img_height, int new_width, int new_height) {
        if (img_width == new_width && img_height == new_height) {
            return var3;
        }
        int[] var4 = new int[new_width * new_height];
        int var10002 = img_width;
        int var10003 = img_height;
        boolean var21 = true;
        int var8 = new_height;
        int var7 = new_width;
        int var6 = var10003;
        int var5 = var10002;
        try {
            for (int var9 = 0; var9 < var7; ++var9) {
                for (int var10 = 0; var10 < var8; ++var10) {
                    int var11 = (var9 << 16) / var7 * var5;
                    int var12 = (var10 << 16) / var8 * var6;
                    int var13 = var11 >>> 16;
                    int var14 = var12 >>> 16;
                    var4[var9 + var10 * var7] = var3[var13 + var14 * var5];
                }
            }
        }
        catch (ArrayIndexOutOfBoundsException var20) {
            var20.printStackTrace();
        }
        return var4;
    }

    public static int[] resizeToInt(int[] var4, int[] var3, int img_width, int img_height, int new_width, int new_height) {
        if (img_width == new_width && img_height == new_height) {
            return var3;
        }
        int var10002 = img_width;
        int var10003 = img_height;
        int var8 = new_height;
        int var7 = new_width;
        int var6 = var10003;
        int var5 = var10002;
        try {
            for (int var9 = 0; var9 < var7; ++var9) {
                for (int var10 = 0; var10 < var8; ++var10) {
                    int var11 = var9 * var5 / var7;
                    int var12 = var10 * var6 / var8;
                    var4[var9 + var10 * var7] = var3[var11 + var12 * var5];
                }
            }
        }
        catch (ArrayIndexOutOfBoundsException var20) {
            var20.printStackTrace();
        }
        return var4;
    }

    static {
        hasHand = false;
    }
}

