/*
 * Decompiled with CFR 0.152.
 */
package com.Gameplay;

import com.Rendering.Fps;

public final class Magazine {
    private static Fps fps;
    private short capacity;
    public short ammo;
    public short rounds;
    private short reloadTime;
    private short frame = (short)-1;

    public Magazine(int capacity, int reloadTime) {
        this.capacity = (short)capacity;
        this.reloadTime = (short)reloadTime;
    }

    public void setAmmo(int ammo) {
        this.ammo = (short)ammo;
    }

    public final void set(short ammo2, short rounds2) {
        this.ammo = ammo2;
        this.rounds = rounds2;
    }

    public void addAmmo(int number) {
        this.ammo = (short)(this.ammo + number);
        if (this.ammo < 0) {
            this.ammo = 0;
        }
    }

    final void reload() {
        if (this.ammo != 0 && this.frame == -1) {
            this.frame = 0;
        }
    }

    final void update() {
        if (this.frame >= 0) {
            this.frame = (short)(this.frame + 1);
        }
        if (this.frame > this.reloadTime * Fps.getFps() / 200) {
            this.frame = (short)-1;
            this.recount();
        }
    }

    final void recount() {
        this.rounds = (short)Math.min(this.capacity, this.ammo);
        this.ammo = (short)(this.ammo - this.rounds);
    }

    final boolean isReloading() {
        return this.frame != -1;
    }

    final int percentage() {
        return 100 * this.frame * 200 / Fps.getFps() / this.reloadTime;
    }

    final int getRounds() {
        return this.rounds;
    }

    final int getAmmo() {
        return this.ammo;
    }

    final void takeRounds(int number) {
        this.rounds = (short)(this.rounds - number);
    }
}

