/*
 * Decompiled with CFR 0.152.
 */
package com.misc;

import com.Gameplay.Weapon;
import com.Rendering.Meshes.Mesh;
import com.misc.Asset;
import com.misc.Main;
import java.util.Hashtable;

public class Stringer {
    private final Hashtable hashtable = new Hashtable();
    public static boolean printInfo = false;

    public static Weapon createWeapon(int index) {
        int pos = 0;
        String file = Mesh.getStringFromResource("/weapons.txt");
        while (file.indexOf(91) >= 0) {
            pos = file.indexOf(91);
            int endpos = file.indexOf(93);
            String objectType = file.substring(pos + 1, endpos);
            String object = file.substring(endpos + 1);
            if ((endpos = object.indexOf(91)) >= 0) {
                file = object.substring(endpos);
                object = object.substring(0, endpos - 1);
            }
            if (printInfo) {
                System.out.println(objectType + ":" + object);
            }
            if (objectType.indexOf(Integer.toString(index)) > -1) {
                String str;
                Stringer obj = new Stringer(object);
                boolean pb = true;
                boolean th = true;
                float kw = 1.0f;
                if (obj.getString("KW") != null) {
                    kw = obj.getFloat("KW");
                }
                float kh = 1.0f;
                if (obj.getString("KH") != null) {
                    kh = obj.getFloat("KH");
                }
                if (obj.getInt("PATRONBUY") == 0) {
                    pb = false;
                }
                if (obj.getInt("TWOHANDS") == 0) {
                    th = false;
                }
                Weapon wp = new Weapon(obj.getString("IMAGE"), obj.getString("FIRE"), kw, kh, obj.getInt("DAMAGE"), obj.getInt("DELAY"), obj.getInt("SHOTTIME"), th, obj.getInt("CAPACITY"), obj.getInt("RELOADTIME"), obj.getLong("DISTANCE"), pb, index);
                if (obj.getString("SHOOT_SOUND") != null) {
                    wp.shoot = obj.getString("SHOOT_SOUND");
                    if (Main.isSounds && Main.sounds > 0) {
                        Asset.getSound(wp.shoot);
                    }
                }
                if (obj.getString("RELOAD_SOUND") != null) {
                    wp.reload = obj.getString("RELOAD_SOUND");
                    if (Main.isSounds && Main.sounds > 0) {
                        Asset.getSound(wp.reload);
                    }
                }
                if (obj.getString("NEWFIREANIM") != null && obj.getInt("NEWFIREANIM") == 1) {
                    wp.newanim = true;
                }
                if (obj.getString("CANSHOOT") != null && obj.getInt("CANSHOOT") == 0) {
                    wp.canShoot = false;
                }
                if (obj.getString("MELEEANIM") != null && obj.getInt("MELEEANIM") == 1) {
                    wp.meleeAnim = true;
                    wp.attackIntensity = 5.0f;
                }
                if (obj.getString("IGNORE_SIGHT_IMAGE") != null && obj.getInt("IGNORE_SIGHT_IMAGE") == 1) {
                    wp.ignoreSightOnDraw = true;
                }
                wp.fileSight = obj.getString("SIGHT_IMAGE");
                wp.fileSightWeapon = obj.getString("SIGHT_WEAPON_IMAGE");
                if (obj.getString("X_POS") != null) {
                    wp.customPos = true;
                    wp.customPosX = obj.getFloat("X_POS");
                }
                if (obj.getString("CENTRE_ALIGHT") != null && obj.getInt("CENTRE_ALIGHT") == 1) {
                    wp.centreAlign = true;
                }
                if ((str = obj.getString("ZOOM")) != null) {
                    int[] snds = Mesh.cutOnInts(str, ';', ',');
                    wp.minZoom = snds[0];
                    wp.maxZoom = snds[1];
                    wp.hasZoom = false;
                    if (snds[2] == 1) {
                        wp.hasZoom = true;
                    }
                }
                return wp;
            }
            if (endpos >= 0) continue;
            break;
        }
        return null;
    }

    public static Stringer createFromResource(String file) {
        file = Mesh.getStringFromResource(file);
        return new Stringer(file);
    }

    public static Stringer createFromResourceWithKeys(String file) {
        file = Mesh.getStringFromResource(file);
        return new Stringer(file, true);
    }

    public Stringer(String str) {
        String[] var5 = Mesh.cutOnStrings(str, '\n');
        for (int var2 = 0; var2 < var5.length; ++var2) {
            int var3 = var5[var2].indexOf(61);
            if (var3 < 0) continue;
            String var4 = var5[var2].substring(0, var3).trim();
            String var6 = var5[var2].substring(var3 + 1).trim();
            this.hashtable.put(var4, var6);
        }
    }

    public Stringer(String str, boolean keys) {
        String[] var5 = Mesh.cutOnStrings(str, '\n');
        String key = "";
        for (int var2 = 0; var2 < var5.length; ++var2) {
            if (var5[var2].charAt(0) == '[') {
                key = var5[var2].substring(1, var5[var2].length() - 1) + "@@@";
                continue;
            }
            int var3 = var5[var2].indexOf(61);
            if (var3 < 0) continue;
            String var4 = var5[var2].substring(0, var3).trim();
            String var6 = var5[var2].substring(var3 + 1).trim();
            this.hashtable.put(key + var4, var6);
        }
    }

    public String getString2(String key) {
        String var2 = (String)this.hashtable.get(key);
        if (var2 == null && printInfo) {
            System.out.println("Stringer: " + key + " not found");
        }
        return var2;
    }

    public String getString(String key) {
        String s2;
        String var2 = (String)this.hashtable.get(key);
        if (var2 == null && printInfo) {
            System.out.println("Stringer: " + key + " not found");
        }
        if (var2 != null && (s2 = Main.gameText.getString2(var2)) != null) {
            var2 = s2;
        }
        return var2;
    }

    public String get(String key) {
        String var2 = (String)this.hashtable.get(key);
        if (var2 == null && printInfo) {
            System.out.println("Stringer: " + key + " not found");
        }
        return var2;
    }

    public static byte parseByte(String val) {
        val = Stringer.deleteExtremeSpaces(val);
        return (byte)Integer.parseInt(val);
    }

    public byte getByte(String key) {
        String val = this.get(key);
        if (val == null) {
            return 0;
        }
        return Stringer.parseByte(val);
    }

    public int getInt(String key) {
        return Stringer.parseInt(this.getString(key));
    }

    public long getLong(String key) {
        return Stringer.parseLong(this.getString(key));
    }

    public int getInt2(String key) {
        return Stringer.parseInt(this.getString2(key));
    }

    public float getFloat(String key) {
        return Stringer.parseFloat(this.getString(key));
    }

    public float getFloat2(String key) {
        return Stringer.parseFloat(this.getString2(key));
    }

    public static int parseInt(String val) {
        val = Stringer.deleteExtremeSpaces(val);
        return Integer.parseInt(val);
    }

    public static long parseLong(String val) {
        val = Stringer.deleteExtremeSpaces(val);
        return Long.parseLong(val);
    }

    public static float parseFloat(String val) {
        val = Stringer.deleteExtremeSpaces(val);
        return Float.parseFloat(val);
    }

    public static String deleteExtremeSpaces(String s) {
        while (s.length() > 0 && s.charAt(0) == ' ') {
            s = s.substring(1, s.length());
        }
        while (s.length() > 0 && s.charAt(0) == '+') {
            s = s.substring(1, s.length());
        }
        while (s.length() > 0 && s.charAt(s.length() - 1) == ' ') {
            s = s.substring(0, s.length() - 1);
        }
        return s;
    }

    public static String removeEmpty(String s) {
        while (s.length() > 0 && s.charAt(0) == ' ') {
            s = s.substring(1, s.length());
        }
        while (s.length() > 0 && s.charAt(s.length() - 1) == ' ') {
            s = s.substring(0, s.length() - 1);
        }
        return s;
    }

    public static String removeSpaces(String s) {
        char[] array = s.toCharArray();
        int sub = 0;
        for (int i = 0; i < array.length; ++i) {
            if (array[i] != ' ') continue;
            int back = 0;
            for (int l = i; l >= 0; --l) {
                if (array[l] != '\"') continue;
                ++back;
            }
            if (back % 2 == 0) continue;
            ++sub;
        }
        char[] array2 = new char[array.length - sub];
        sub = 0;
        for (int i = 0; i < array.length; ++i) {
            if (array[i] == ' ') {
                int back = 0;
                for (int l = i; l >= 0; --l) {
                    if (array[l] != '\"') continue;
                    ++back;
                }
                if (back % 2 != 0) continue;
                array2[sub] = array[i];
                ++sub;
                continue;
            }
            array2[sub] = array[i];
            ++sub;
        }
        return new String(array2);
    }

    public static int countChars(String str, char ch) {
        if (str == null) {
            return 0;
        }
        int c = 0;
        for (int i = 0; i < str.length(); ++i) {
            if (str.charAt(i) != ch) continue;
            ++c;
        }
        return c;
    }
}

