/*
 * Decompiled with CFR 0.152.
 */
package com.AI.misc;

import com.Gameplay.Objects.GameObject;
import com.Math.Matrix;
import com.Math.Vector3D;
import com.Rendering.Graphics3D;
import com.Rendering.Meshes.BoundingBox;
import com.Rendering.Meshes.Mesh;
import com.Rendering.Meshes.MeshImage;
import com.Rendering.Meshes.Sprite;
import com.Rendering.MultyTexture;
import com.Rendering.RenderObject;

public final class Corpse
extends GameObject {
    private MultyTexture mtex;
    private int f = 0;
    private boolean boled = false;
    private int frame;
    private Matrix matrix;
    private MeshImage meshImage;
    public Sprite spr;
    private BoundingBox boundingBox;

    public Corpse(int frame2, Matrix matrix2, MeshImage mesh, MultyTexture tex) {
        this.matrix = matrix2;
        this.boled = false;
        if (mesh != null) {
            this.meshImage = new MeshImage(mesh.getMesh(), mesh.getAnimation());
        }
        if (this.meshImage != null) {
            this.boundingBox = new BoundingBox(mesh.getAnimation());
        }
        this.mtex = tex;
        this.frame = frame2;
        this.getCharacter().reset();
        this.getCharacter().getTransform().set(this.matrix);
        this.getCharacter().setCollision(false);
        this.getCharacter().setCollidable(false);
        this.getCharacter().setOnFloor(true);
        this.getCharacter().setSpeedZero();
    }

    public void set(Vector3D pos) {
        this.getCharacter().reset();
        this.getCharacter().getTransform().setPosition(pos.x, pos.y, pos.z);
    }

    public void destroy() {
    }

    protected final boolean isNeedRecomputePart() {
        return this.getFrame() == 0;
    }

    protected static void increaseMeshSz(Mesh mesh, int val1) {
        RenderObject[] var2 = mesh.getPoligons();
        for (int val = 0; val < var2.length; ++val) {
            var2[val].sz += val1;
        }
    }

    public final void render(Graphics3D g3d, int x1, int y1, int x2, int y2) {
        if (this.f <= 3600) {
            this.setHp(100);
        }
        ++this.f;
        if (this.f > 3600) {
            this.setHp(0);
        }
        if (this.meshImage != null) {
            this.meshImage.getAnimation().setFrame(this.frame);
            Matrix var6 = g3d.computeFinalMatrix(this.matrix);
            if (!this.boundingBox.isVisible(g3d, var6, x1, y1, x2, y2)) {
                return;
            }
            this.meshImage.setMatrix(var6);
            this.meshImage.setTexture(this.mtex);
            g3d.addRenderObject(this.meshImage, x1, y1, x2, y2);
            this.meshImage.sz += 5900;
            if (this.getCharacter().oldFloorPoly != null && this.getCharacter().oldFloorPoly.sz > this.meshImage.sz) {
                this.getCharacter().oldFloorPoly.sz = this.meshImage.sz - 1;
            }
        } else {
            this.spr.getPosition().set(this.getPosX(), this.getPosY(), this.getPosZ());
            this.spr.updateFrame();
            this.spr.project(g3d.getInvCamera(), g3d);
            if (!this.spr.isVisible(x1, y1, x2, y2)) {
                return;
            }
            g3d.addRenderObject(this.spr, x1, y1, x2, y2);
            this.spr.sz += 5900;
            if (this.getCharacter().oldFloorPoly != null && this.getCharacter().oldFloorPoly.sz > this.spr.sz) {
                this.getCharacter().oldFloorPoly.sz = this.spr.sz - 1;
            }
        }
    }
}

