/*
 * Decompiled with CFR 0.152.
 */
package com.Gameplay.Map;

import com.Gameplay.Map.Room;
import com.Math.Matrix;
import com.Rendering.Graphics3D;
import com.Rendering.Meshes.Mesh;
import com.Rendering.MultyTexture;
import com.Rendering.Texture;
import com.misc.Asset;

public class Skybox {
    private boolean a_boolean_fld;
    private Matrix matrix;
    public MultyTexture texture;
    private Texture sky360;
    private int color;
    private byte mode = 0;
    private Mesh mesh;
    private int frame;
    private float x;
    private float y;
    private int x1;
    private int y1;
    private int x2;
    private int y2;
    private boolean resetViewport;
    public boolean skyboxAlways = false;

    public Skybox() {
    }

    public Skybox(String modelPath, String texturePath) {
        this.a_boolean_fld = false;
        this.matrix = new Matrix();
        this.frame = 0;
        this.resetViewport = false;
        this.texture = Asset.getMultyTexture(texturePath, true);
        this.mesh = Room.loadMeshes(modelPath, 1.0f, 1.0f, 1.0f, this.texture)[0];
        this.mode = 0;
        this.skyboxAlways = false;
    }

    public Skybox(int colors) {
        this.a_boolean_fld = false;
        this.frame = 0;
        this.resetViewport = false;
        this.color = colors;
        this.mode = 1;
        this.skyboxAlways = false;
    }

    public Skybox(Texture colors, float xx, float yy) {
        this.a_boolean_fld = false;
        this.frame = 0;
        this.resetViewport = false;
        this.sky360 = colors;
        this.x = xx;
        this.y = yy;
        this.mode = (byte)2;
        this.skyboxAlways = false;
    }

    public void destroy() {
        this.matrix = null;
        if (this.texture != null) {
            this.texture.destroy();
        }
        this.texture = null;
        if (this.mesh != null) {
            this.mesh.destroy();
            this.mesh = null;
        }
        this.sky360 = null;
    }

    public void resetViewport() {
        this.resetViewport = true;
    }

    public void addViewport(int ax1, int ay1, int ax2, int ay2) {
        if (this.resetViewport) {
            this.resetViewport = false;
            this.x1 = ax1;
            this.y1 = ay1;
            this.x2 = ax2;
            this.y2 = ay2;
        } else {
            if (ax1 < this.x1) {
                this.x1 = ax1;
            }
            if (ay1 < this.y1) {
                this.y1 = ay1;
            }
            if (ax2 > this.x2) {
                this.x2 = ax2;
            }
            if (ay2 > this.y2) {
                this.y2 = ay2;
            }
        }
    }

    public final void render(Graphics3D g3d) {
        if (this.skyboxAlways) {
            this.x1 = 0;
            this.y1 = 0;
            this.x2 = g3d.width;
            this.y2 = g3d.height;
        }
        if (this.mode == 0) {
            this.matrix.set(g3d.getInvCamera());
            this.matrix.setPosition(0, 0, 0);
            if (this.a_boolean_fld) {
                // empty if block
            }
            g3d.transformAndProjectVertices(this.mesh, this.matrix);
            g3d.addMesh(this.mesh, this.x1, this.y1, this.x2, this.y2);
        }
        if (this.mode == 1) {
            g3d.clearDisplay(this.color);
        }
        if (this.mode == 2) {
            int sy;
            if (this.x2 - this.x1 == 0 || this.y2 - this.y1 == 0) {
                return;
            }
            int direction = Graphics3D.camera.getRotZHQ();
            int sizex = 455 * g3d.width / g3d.height;
            int sizey = 455;
            int beginx = (int)((float)((direction - sizex / 2) * this.sky360.rImg.w) * this.x / 2048.0f);
            int endx = (int)((float)((direction + sizex / 2) * this.sky360.rImg.w) * this.x / 2048.0f);
            int directiony = Math.min(Math.max(2048 - (1024 - Graphics3D.camera.m12 * 1024 / Matrix.FP), 227), 1821);
            int beginy = (int)((float)((directiony - 227) * this.sky360.rImg.h / 2048));
            int endy = (int)((float)((directiony + 227) * this.sky360.rImg.h) * this.y / 2048.0f);
            int fp = 12;
            int sx = beginx << 12;
            int width = g3d.width;
            int height = g3d.height;
            int xstep = ((endx << 12) - sx) / width;
            int ystep = ((endy << 12) - sy) / height;
            if (xstep < 2048) {
                this.render2DLOFIx2(g3d, sx, sy, xstep, ystep);
                return;
            }
            if (xstep < 1024) {
                this.render2DLOFIx4(g3d, sx, sy, xstep, ystep);
                return;
            }
            int texw = this.sky360.rImg.w;
            int texh = this.sky360.rImg.h;
            int texs = this.sky360.getPixels().length - 1;
            for (sy = beginy << 12; sy < 0; sy += texh << 12) {
            }
            sy += ystep * this.y1;
            while (sx < 0) {
                sx += texw << 12;
            }
            int sxx = sx;
            int rx1 = 0;
            int rx2 = 0;
            int[] rgb = g3d.display;
            int[] tex = this.sky360.rImg.img;
            for (int scry = this.y1; scry < this.y2; ++scry) {
                rx1 = width * scry;
                rx2 = width + rx1;
                sx = sxx;
                int ysa = (sy >> 12) % texh * texw;
                int c = (rx2 - rx1) / 5;
                if (this.x1 > 0) {
                    rx1 += this.x1;
                    sx += xstep * this.x1;
                }
                if (this.x2 < width) {
                    rx2 -= width - this.x2;
                }
                while (rx2 - rx1 >= 4) {
                    rgb[rx1] = tex[((sx >> 12) % texw + ysa) % texs];
                    rgb[rx1 + 1] = tex[(((sx += xstep) >> 12) % texw + ysa) % texs];
                    rgb[rx1 + 2] = tex[(((sx += xstep) >> 12) % texw + ysa) % texs];
                    rgb[rx1 + 3] = tex[(((sx += xstep) >> 12) % texw + ysa) % texs];
                    sx += xstep;
                    rx1 += 4;
                }
                while (rx1 < rx2) {
                    rgb[rx1] = tex[((sx >> 12) % texw + ysa) % texs];
                    sx += xstep;
                    ++rx1;
                }
                sy += ystep;
            }
        }
    }

    void render2DLOFIx2(Graphics3D g3d, int sx, int sy, int xstep, int ystep) {
        int texw = this.sky360.rImg.w;
        int texh = this.sky360.rImg.h;
        int texs = this.sky360.rImg.img.length - 1;
        int fp = 12;
        while (sy < 0) {
            sy += texh << 12;
        }
        sy += ystep * this.y1;
        while (sx < 0) {
            sx += texw << 12;
        }
        int sxx = sx;
        int width = g3d.width;
        int height = g3d.height;
        int[] tex = this.sky360.rImg.img;
        for (int scry = this.y1; scry < this.y2; ++scry) {
            int col;
            int rx1 = width * scry;
            int rx2 = width + rx1;
            sx = sxx;
            int ysa = (sy >> 12) % texh * texw;
            int c = (rx2 - rx1) / 5;
            if (this.x1 > 0) {
                rx1 += this.x1;
                sx += xstep * this.x1;
            }
            if (this.x2 < width) {
                rx2 -= width - this.x2;
            }
            while (rx2 - rx1 >= 4) {
                g3d.display[rx1] = col = tex[((sx >> 12) % texw + ysa) % texs];
                g3d.display[rx1 + 1] = col;
                g3d.display[rx1 + 2] = col = tex[(((sx += xstep << 1) >> 12) % texw + ysa) % texs];
                g3d.display[rx1 + 3] = col;
                sx += xstep << 1;
                rx1 += 4;
            }
            while (rx2 - rx1 >= 2) {
                g3d.display[rx1] = col = tex[((sx >> 12) % texw + ysa) % texs];
                g3d.display[rx1 + 1] = col;
                sx += xstep << 1;
                rx1 += 2;
            }
            while (rx1 < rx2) {
                g3d.display[rx1] = tex[((sx >> 12) % texw + ysa) % texs];
                sx += xstep;
                ++rx1;
            }
            sy += ystep;
        }
    }

    void render2DLOFIx4(Graphics3D g3d, int sx, int sy, int xstep, int ystep) {
        int texw = this.sky360.rImg.w;
        int texh = this.sky360.rImg.h;
        int texs = this.sky360.rImg.img.length - 1;
        int fp = 12;
        while (sy < 0) {
            sy += texh << 12;
        }
        sy += ystep * this.y1;
        while (sx < 0) {
            sx += texw << 12;
        }
        int sxx = sx;
        int width = g3d.width;
        int height = g3d.height;
        int[] tex = this.sky360.rImg.img;
        for (int scry = this.y1; scry < this.y2; ++scry) {
            int col;
            int rx1 = width * scry;
            int rx2 = width + rx1;
            sx = sxx;
            int ysa = (sy >> 12) % texh * texw;
            int c = (rx2 - rx1) / 5;
            if (this.x1 > 0) {
                rx1 += this.x1;
                sx += xstep * this.x1;
            }
            if (this.x2 < width) {
                rx2 -= width - this.x2;
            }
            while (rx2 - rx1 >= 8) {
                g3d.display[rx1] = col = tex[((sx >> 12) % texw + ysa) % texs];
                g3d.display[rx1 + 1] = col;
                g3d.display[rx1 + 2] = col;
                g3d.display[rx1 + 3] = col;
                g3d.display[rx1 + 4] = col = tex[(((sx += xstep << 2) >> 12) % texw + ysa) % texs];
                g3d.display[rx1 + 5] = col;
                g3d.display[rx1 + 6] = col;
                g3d.display[rx1 + 7] = col;
                sx += xstep << 2;
                rx1 += 8;
            }
            while (rx2 - rx1 >= 4) {
                g3d.display[rx1] = col = tex[((sx >> 12) % texw + ysa) % texs];
                g3d.display[rx1 + 1] = col;
                g3d.display[rx1 + 2] = col;
                g3d.display[rx1 + 3] = col;
                sx += xstep << 2;
                rx1 += 4;
            }
            while (rx1 < rx2) {
                g3d.display[rx1] = tex[((sx >> 12) % texw + ysa) % texs];
                sx += xstep;
                ++rx1;
            }
            sy += ystep;
        }
    }

    public Mesh getMesh() {
        return this.mesh;
    }
}

