/*
 * Decompiled with CFR 0.152.
 */
package code.Rendering;

import code.Rendering.Texture;
import code.utils.Asset;
import code.utils.GameIni;
import code.utils.StringTools;

public class MultyTexture {
    public Texture[] textures;

    MultyTexture() {
    }

    public MultyTexture(String files, boolean perspectiveCorrect) {
        String[] texList = GameIni.cutOnStrings(files, ',', ';');
        this.textures = new Texture[texList.length];
        for (int i = 0; i < texList.length; ++i) {
            String[] anims = StringTools.cutOnStrings(texList[i], ':');
            if (anims.length == 1) {
                this.textures[i] = Asset.getTexture(anims[0]);
                this.textures[i].setPerspectiveCorrection(perspectiveCorrect);
                continue;
            }
            this.textures[i] = Asset.getTexture(anims[1]);
            this.textures[i].animation_speed = Float.parseFloat(anims[0].trim());
            this.textures[i].animMIP = new Texture[anims.length - 1];
            for (int x = 1; x < anims.length; ++x) {
                this.textures[i].animMIP[x - 1] = Asset.getTexture(anims[x]);
            }
            this.textures[i].setPerspectiveCorrection(perspectiveCorrect);
        }
    }

    public MultyTexture(String[] texList) {
        this.textures = new Texture[texList.length];
        for (int i = 0; i < texList.length; ++i) {
            System.out.println("Loading Texture:" + i);
            String[] texInfo = GameIni.cutOnStrings(texList[i], ',', ';');
            String[] animation = StringTools.cutOnStrings(texInfo[0], ':');
            this.textures[i] = Asset.getTexture(animation[animation.length > 1 ? 1 : 0].trim());
            if (animation.length > 1) {
                this.textures[i].animation_speed = Float.parseFloat(animation[0].trim());
                this.textures[i].animMIP = new Texture[animation.length - 1];
                for (int i2 = 1; i2 < animation.length; ++i2) {
                    this.textures[i].animMIP[i2 - 1] = Asset.getTexture(animation[i2].trim());
                }
            }
            this.textures[i].setPerspectiveCorrection(true);
            if (texInfo.length >= 2 && !texInfo[1].toLowerCase().trim().equals("std")) {
                this.textures[i].drawmode = (byte)StringTools.parseInt(texInfo[1]);
            }
            if (texInfo.length >= 3) {
                this.textures[i].addsz = StringTools.parseInt(texInfo[2]);
            }
            if (texInfo.length >= 4) {
                this.textures[i].setPerspectiveCorrection(StringTools.parseInt(texInfo[3]) == 1);
            }
            if (texInfo.length >= 5) {
                boolean bl = this.textures[i].castShadow = StringTools.parseInt(texInfo[4]) == 1;
            }
            if (texInfo.length < 6) continue;
            this.textures[i].collision = StringTools.parseInt(texInfo[5]) == 1;
        }
    }

    public MultyTexture(Texture tex) {
        this.textures = new Texture[1];
        this.textures[0] = tex;
    }

    public MultyTexture(int i) {
        this.textures = new Texture[i];
    }

    public void updateAnimation() {
        for (int i = 0; i < this.textures.length; ++i) {
            this.textures[i].updateAnimation();
        }
    }
}

