/*
 * Decompiled with CFR 0.152.
 */
import java.io.IOException;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;
import ru.antares.utils.PointXY;
import ru.antares.utils.Rect;

public class Bubble {
    public static final int FR_PRECISION = 10000;
    private int dxFR = 10000;
    private int dyFR = 10000;
    private int xFR = 0;
    private int yFR = 0;
    public Rect rect;
    public int phizBubbleIndex;
    public Image img;
    public boolean bubbleHitUpWall = false;
    public boolean bubbleHitBotWall = false;

    public Bubble() {
    }

    public Bubble(Bubble bubble) {
        this.dxFR = bubble.dxFR;
        this.dyFR = bubble.dyFR;
        this.xFR = bubble.xFR;
        this.yFR = bubble.yFR;
        this.rect = new Rect(bubble.rect);
        this.img = bubble.img;
        this.phizBubbleIndex = bubble.phizBubbleIndex;
    }

    public boolean loadBubble(String string, int n, int n2, int n3, int n4, int n5) {
        this.rect = new Rect();
        this.setX(n2);
        this.setY(n3);
        this.dxFR = n4;
        this.dyFR = n5;
        this.phizBubbleIndex = n;
        try {
            this.img = Image.createImage((String)string);
            this.rect.width = this.img.getWidth();
            this.rect.height = this.img.getHeight();
        }
        catch (IOException iOException) {
            System.out.println(string);
            iOException.printStackTrace();
            return false;
        }
        return true;
    }

    public void move(Rect rect) {
        this.xFR += this.dxFR;
        this.yFR += this.dyFR;
        int n = rect.x * 10000;
        if (this.xFR < n) {
            this.dxFR *= -1;
            this.xFR = n;
        } else {
            n = (rect.x + rect.width - this.rect.width) * 10000;
            if (this.xFR > n) {
                this.dxFR *= -1;
                this.xFR = n;
            }
        }
        n = rect.y * 10000;
        if (this.yFR < n) {
            this.dyFR *= -1;
            this.yFR = n;
            this.bubbleHitUpWall = true;
        } else {
            n = (rect.y + rect.height - this.rect.height) * 10000;
            if (this.yFR > n) {
                this.dyFR *= -1;
                this.yFR = n;
                this.bubbleHitBotWall = true;
            }
        }
        this.rect.x = this.xFR / 10000;
        this.rect.y = this.yFR / 10000;
    }

    public int getDxFR() {
        return this.dxFR;
    }

    public int getDyFR() {
        return this.dyFR;
    }

    public int getDx() {
        return this.dxFR / 10000;
    }

    public int getDy() {
        return this.dyFR / 10000;
    }

    public void setDxFR(int n) {
        this.dxFR = n;
    }

    public void setDyFR(int n) {
        this.dyFR = n;
    }

    public int getXFR() {
        return this.xFR;
    }

    public int getYFR() {
        return this.yFR;
    }

    public int getX() {
        return this.xFR / 10000;
    }

    public int getY() {
        return this.yFR / 10000;
    }

    public void setX(int n) {
        this.xFR = n * 10000;
        this.rect.x = n;
    }

    public void setY(int n) {
        this.yFR = n * 10000;
        this.rect.y = n;
    }

    public void setXY(PointXY pointXY) {
        this.xFR = pointXY.x * 10000;
        this.rect.x = pointXY.x;
        this.yFR = pointXY.y * 10000;
        this.rect.y = pointXY.y;
    }

    public void setCenterX(int n) {
        this.rect.x = n - this.rect.width / 2;
        this.xFR = this.rect.x * 10000;
    }

    public void setCenterY(int n) {
        this.rect.y = n - this.rect.height / 2;
        this.yFR = this.rect.y * 10000;
    }

    public boolean collisionDetect(Bubble bubble) {
        return this.rect.intersectRound(bubble.rect);
    }

    public void drawBubble(Graphics graphics) {
        graphics.drawImage(this.img, this.rect.x, this.rect.y, 0);
    }

    public String toString() {
        return this.getClass().getName() + "[x1=" + this.rect.x + ",y1=" + this.rect.y + ",dx=" + this.dxFR + ",dy=" + this.dyFR + ",width=" + this.rect.width + ",height=" + this.rect.height + "]";
    }
}

