/*
 * Decompiled with CFR 0.152.
 */
import javax.microedition.lcdui.Canvas;
import javax.microedition.lcdui.Display;
import javax.microedition.lcdui.Displayable;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;
import javax.microedition.midlet.MIDlet;
import ru.antares.utils.DebugEx;

public class MainGameLoop
extends Canvas
implements Runnable {
    public static final int SPLASH_SHOW_TIME = 20;
    private MeBubblesMIDlet gameMIDlet;
    public GameCanvas gameCanvas;
    public MainMenu mainMenu;
    public Display display;
    private int width = 128;
    private int height = 128;
    private Image backImage;
    public Graphics backCanvas;
    private int curSplashShowTime = 0;
    public int gameLoopState = -10;
    boolean oldGameLoadOk = false;
    boolean pause = false;
    boolean exit = false;
    boolean save_exit_ok = false;

    public MainGameLoop(MeBubblesMIDlet meBubblesMIDlet) {
        this.gameMIDlet = meBubblesMIDlet;
        this.display = Display.getDisplay((MIDlet)meBubblesMIDlet);
        this.display.setCurrent((Displayable)this);
        this.mainMenu = new MainMenu(this, this.width, this.height);
        this.gameCanvas = new GameCanvas(this, this.width, this.height);
    }

    public boolean createMainGameLoop() {
        DebugEx.debugOut("Creat main game loop");
        if (!this.mainMenu.createMainMenu()) {
            DebugEx.debugOut("   main game loop create error");
            return false;
        }
        try {
            this.backImage = Image.createImage((int)this.width, (int)this.height);
            this.backCanvas = this.backImage.getGraphics();
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return false;
        }
        return true;
    }

    public boolean loadGameEngine() {
        DebugEx.debugOut("Load game engine");
        if (!this.gameCanvas.createGameCanvas()) {
            DebugEx.debugOut("   game engine load error");
            return false;
        }
        this.gameCanvas.mainGame.vibrationOn = this.mainMenu.vibrationOn;
        this.gameCanvas.mainGame.soundOn = this.mainMenu.soundOn;
        this.gameCanvas.mainGame.musicOn = this.mainMenu.musicOn;
        return true;
    }

    public boolean tryLoadOldGame() {
        DebugEx.debugOut("try load old game");
        if (this.gameCanvas.loadOldGame()) {
            this.mainMenu.createMenuMeBubbles();
            this.gameLoopState = -1;
            this.oldGameLoadOk = true;
            return true;
        }
        DebugEx.debugOut("   load old game error. load new Game");
        this.resetOldLoadedGame();
        this.mainMenu.createMenuMainMenu();
        this.gameLoopState = -1;
        return false;
    }

    public boolean tryLoadNewGame(int n, int n2, int n3) {
        DebugEx.debugOut("try load New game");
        if (this.gameCanvas.loadGame(n, n2, n3)) {
            this.gameLoopState = -2;
            return true;
        }
        DebugEx.debugOut("   load new game error");
        return false;
    }

    public void saveCurGameAndExit() {
        if (this.gameLoopState == 2) {
            DebugEx.debugOut("   Save game");
            this.gameCanvas.saveCurGame();
            while (!this.gameCanvas.curGameSaved()) {
                this.gameCanvas.paint(this.backCanvas);
            }
        }
        this.mainMenu.saveGameParam();
        this.mainMenu.savePlayerScore();
        DebugEx.debugOut("All data Saved");
        this.save_exit_ok = true;
    }

    public boolean isAllDataSaved() {
        return this.save_exit_ok;
    }

    public void pause(boolean bl) {
        this.pause = bl;
    }

    public void exitGame() {
        this.exit = true;
    }

    public void resetOldLoadedGame() {
        this.oldGameLoadOk = false;
        this.mainMenu.gameLevel = 0;
        this.gameCanvas.resetCurPlayerScore();
    }

    public void paint(Graphics graphics) {
        switch (this.gameLoopState) {
            case 2: {
                this.gameCanvas.paint(this.backCanvas);
                break;
            }
            case 1: {
                this.mainMenu.menu.paint(this.backCanvas);
                break;
            }
            case 10: {
                this.mainMenu.menu.paint(this.backCanvas);
            }
        }
        graphics.drawImage(this.backImage, 0, 0, 0);
    }

    protected void keyPressed(int n) {
        this.pause = true;
        switch (this.gameLoopState) {
            case 2: {
                this.gameCanvas.keyPressed(n, this.getGameAction(n));
                break;
            }
            case 1: {
                this.mainMenu.menu.keyPressed(n, this.getGameAction(n));
            }
        }
        this.pause = false;
    }

    protected void keyReleased(int n) {
        this.pause = true;
        switch (this.gameLoopState) {
            case 2: {
                this.gameCanvas.keyReleased(n, this.getGameAction(n));
                break;
            }
            case 1: {
                this.mainMenu.menu.keyReleased(n, this.getGameAction(n));
            }
        }
        this.pause = false;
    }

    public void run() {
        this.pause = false;
        while (!this.exit) {
            try {
                Thread.sleep(20L);
                while (this.pause) {
                }
                this.pause = true;
                switch (this.gameLoopState) {
                    case 2: {
                        this.repaint();
                        switch (this.gameCanvas.getGameState()) {
                            case 0: {
                                break;
                            }
                            case -1: {
                                this.mainMenu.createMenuMainMenu();
                                this.gameCanvas.resetCurPlayerScore();
                                this.mainMenu.gameLevel = 0;
                                this.gameLoopState = -1;
                                break;
                            }
                            case 1: {
                                this.mainMenu.createMenuGameOwer(this.gameCanvas.getPlayerScore());
                                this.gameCanvas.resetCurPlayerScore();
                                this.mainMenu.gameLevel = 0;
                                this.gameLoopState = -1;
                                break;
                            }
                            case 2: {
                                if (this.mainMenu.gameMode == 0) {
                                    this.mainMenu.createMenuYouWin(this.gameCanvas.getPlayerScore());
                                    this.gameCanvas.resetCurPlayerScore();
                                    this.gameLoopState = -1;
                                    break;
                                }
                                if (this.mainMenu.gameMode != 1) break;
                                ++this.mainMenu.gameLevel;
                                DebugEx.debugOut("   load new level=" + this.mainMenu.gameLevel);
                                if (this.mainMenu.gameLevel >= 10) {
                                    this.mainMenu.createMenuYouWin(this.gameCanvas.getPlayerScore());
                                    this.mainMenu.gameLevel = 0;
                                    this.gameLoopState = -1;
                                    break;
                                }
                                this.gameLoopState = -2;
                            }
                        }
                        break;
                    }
                    case 1: {
                        this.repaint();
                        switch (this.mainMenu.getMenuState()) {
                            case 0: {
                                break;
                            }
                            case 1: {
                                this.gameLoopState = -2;
                                break;
                            }
                            case -1: {
                                this.exit = true;
                            }
                        }
                        break;
                    }
                    case -2: {
                        if (this.oldGameLoadOk) {
                            this.oldGameLoadOk = false;
                        } else if (!this.tryLoadNewGame(this.mainMenu.gameMode, this.mainMenu.gameDifficulty, this.mainMenu.gameLevel)) {
                            DebugEx.debugOut("   load new game error.Abort Game");
                            this.exit = true;
                            break;
                        }
                        this.display.setCurrent((Displayable)this);
                        this.gameLoopState = 2;
                        break;
                    }
                    case -1: {
                        this.display.setCurrent((Displayable)this);
                        this.gameLoopState = 1;
                        break;
                    }
                    case 10: {
                        ++this.curSplashShowTime;
                        if (this.curSplashShowTime <= 20) break;
                        this.curSplashShowTime = 0;
                        this.gameLoopState = 0;
                        break;
                    }
                    case -10: {
                        DebugEx.debugOut("Show Splash");
                        this.mainMenu.createMenuGreetings();
                        this.gameLoopState = 10;
                        this.repaint();
                        break;
                    }
                    case 0: {
                        this.loadGameEngine();
                        this.tryLoadOldGame();
                        break;
                    }
                    case -11: {
                        this.gameLoopState = 1000;
                        break;
                    }
                }
                this.pause = false;
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
        DebugEx.debugOut("Exit!!!!!!!!");
        this.saveCurGameAndExit();
        this.gameMIDlet.notifyDestroyed();
    }
}

