/*
 * Decompiled with CFR 0.152.
 */
package zip;

import java.util.Calendar;
import java.util.Date;

public class ZipEntry {
    private byte[] namebytes = null;
    public int namelen;
    public int dostime;
    public int size;
    public int compressedSize;
    public int offset;
    public int crc;
    public short method;
    public String name;
    public int flag;

    public ZipEntry(String n) {
        if (n != null) {
            this.name = n.replace('\\', '/');
            this.namebytes = this.name.getBytes();
            this.namelen = this.namebytes.length;
        }
    }

    public void setname(byte[] n, int off, int len) {
        this.namelen = len;
        this.name = new String(n, off, len).replace('\\', '/');
        this.namebytes = this.name.getBytes();
    }

    public void setTime(long time) {
        Calendar w = Calendar.getInstance();
        if (time > 0L) {
            w.setTime(new Date(time));
        }
        this.dostime = w.get(1) - 1980 << 25 | w.get(2) + 1 << 21 | w.get(5) << 16 | w.get(11) << 11 | w.get(12) << 5 | w.get(13) >> 1;
    }

    public void setMethod(int method) {
        this.method = (short)method;
    }

    public int getMethod() {
        return this.method;
    }

    public byte[] getNamebytes() {
        return this.namebytes;
    }

    public boolean isDirectory() {
        return this.name.endsWith("/");
    }

    public String toString() {
        return this.name;
    }
}

