/*
 * Decompiled with CFR 0.152.
 */
import java.io.ByteArrayOutputStream;
import java.io.UnsupportedEncodingException;

public class ClassUtil {
    private static final int CLASS = 7;
    private static final int STR = 8;
    private static final int LONG = 5;
    private static final int DOUBLE = 6;
    private static final int UTF8 = 1;
    private static final ByteArrayOutputStream ut = new ByteArrayOutputStream();
    private static int[] offset = new int[16384];
    private static boolean find = false;

    public static byte[] classReplace(byte[] b, String src, String des, boolean replaceAll) {
        try {
            return ClassUtil.classReplace(b, src.getBytes("utf-8"), des.getBytes("utf-8"), replaceAll);
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            return null;
        }
    }

    public static byte[] classReplace(byte[] b, String src, String des) {
        return ClassUtil.classReplace(b, src, des, true);
    }

    public static boolean isFind() {
        return find;
    }

    public static boolean classSearch(byte[] b, String src) {
        try {
            return ClassUtil.classSearch(b, src.getBytes("utf-8"));
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            return false;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static boolean classSearch(byte[] b, byte[] src) {
        if (b.length < src.length) return false;
        if (b.length < 10) {
            return false;
        }
        int cfr_ignored_0 = src.length;
        try {
            int byteoff = 8;
            int n = (b[byteoff++] & 0xFF) << 8 | b[byteoff++] & 0xFF;
            int l = 0;
            int i = 1;
            while (true) {
                if (i >= n) {
                    return false;
                }
                switch (b[byteoff]) {
                    case 5: 
                    case 6: {
                        l = 9;
                        ++i;
                        break;
                    }
                    case 1: {
                        int n2 = ++byteoff;
                        int n3 = ++byteoff;
                        l = (b[n2] & 0xFF) << 8 | b[n3] & 0xFF;
                        byte[] bytes = new byte[l];
                        System.arraycopy(b, ++byteoff, bytes, 0, l);
                        if (!ClassUtil.bytesFind(bytes, src)) break;
                        return true;
                    }
                    case 7: 
                    case 8: {
                        l = 3;
                        break;
                    }
                    default: {
                        l = 5;
                    }
                }
                byteoff += l;
                ++i;
            }
        }
        catch (Exception exception) {
            return false;
        }
    }

    public static boolean bytesFind(byte[] b, byte[] src) {
        int len = b.length;
        int comparelen = src.length;
        if (len >= comparelen) {
            int i = 0;
            while (i < len) {
                block4: {
                    int j = 0;
                    while (j < comparelen) {
                        if (b[i + j] == src[j]) {
                            ++j;
                            continue;
                        }
                        break block4;
                    }
                    return true;
                }
                ++i;
            }
        }
        return false;
    }

    private static byte[] notEqualReplace(byte[] b, byte[] src, byte[] des, int boff, int len) {
        int comparelen = src.length;
        int num = 0;
        int[] offs = offset;
        if (len >= comparelen) {
            int end = boff + len - comparelen + 1;
            int max = offs.length;
            int i = boff;
            while (i < end) {
                block9: {
                    int j = 0;
                    while (j < comparelen) {
                        if (b[i + j] == src[j]) {
                            ++j;
                            continue;
                        }
                        break block9;
                    }
                    offs[num++] = i;
                    i += comparelen - 1;
                    if (num == max) {
                        offs = new int[max << 1];
                        System.arraycopy(offset, 0, offs, 0, max);
                        offset = offs;
                        max = offs.length;
                    }
                }
                ++i;
            }
        }
        if (num > 0) {
            int copylen = des.length;
            byte[] data = new byte[len + (copylen - comparelen) * num];
            int dataoff = 0;
            int sourceoff = boff;
            int i = 0;
            while (i < num) {
                int k = offs[i];
                if (k > sourceoff) {
                    int cplen = k - sourceoff;
                    System.arraycopy(b, sourceoff, data, dataoff, cplen);
                    dataoff += cplen;
                }
                System.arraycopy(des, 0, data, dataoff, copylen);
                dataoff += copylen;
                sourceoff = k + comparelen;
                ++i;
            }
            if (sourceoff < boff + len) {
                System.arraycopy(b, sourceoff, data, dataoff, boff + len - sourceoff);
            }
            return data;
        }
        return null;
    }

    private static boolean equalReplace(byte[] b, byte[] src, byte[] des, int boff, int len) {
        int comparelen = src.length;
        boolean c = false;
        if (len >= comparelen) {
            int end = boff + len - comparelen + 1;
            int i = boff;
            while (i < end) {
                block4: {
                    int j = 0;
                    while (j < comparelen) {
                        if (b[i + j] == src[j]) {
                            ++j;
                            continue;
                        }
                        break block4;
                    }
                    c = true;
                    System.arraycopy(des, 0, b, i, comparelen);
                }
                ++i;
            }
        }
        return c;
    }

    public static byte[] classReplace(byte[] b, byte[] src, byte[] des, boolean all) {
        boolean equal;
        boolean bl = equal = src.length == des.length;
        if (b.length < src.length || b.length < 10) {
            return b;
        }
        int cplen = src.length;
        find = false;
        int writeoff = 0;
        try {
            int byteoff = 8;
            int n = (b[byteoff++] & 0xFF) << 8 | b[byteoff++] & 0xFF;
            int l = 0;
            int i = 1;
            while (i < n) {
                switch (b[byteoff]) {
                    case 5: 
                    case 6: {
                        l = 9;
                        ++i;
                        break;
                    }
                    case 1: {
                        byte[] data;
                        int n2 = ++byteoff;
                        int n3 = ++byteoff;
                        ++byteoff;
                        l = (b[n2] & 0xFF) << 8 | b[n3] & 0xFF;
                        if (l < cplen) break;
                        if (equal) {
                            if (l != cplen && !all || !ClassUtil.equalReplace(b, src, des, byteoff, l)) break;
                            find = true;
                            break;
                        }
                        if (l != cplen && !all || (data = ClassUtil.notEqualReplace(b, src, des, byteoff, l)) == null) break;
                        ut.write(b, writeoff, byteoff - 2 - writeoff);
                        int len = data.length;
                        ut.write(len >> 8);
                        ut.write(len);
                        ut.write(data);
                        writeoff = byteoff + l;
                        find = true;
                        break;
                    }
                    case 7: 
                    case 8: {
                        l = 3;
                        break;
                    }
                    default: {
                        l = 5;
                    }
                }
                byteoff += l;
                ++i;
            }
        }
        catch (Exception exception) {
            return null;
        }
        if (find) {
            if (!equal) {
                ut.write(b, writeoff, b.length - writeoff);
                b = ut.toByteArray();
                ut.reset();
            }
            return b;
        }
        return null;
    }
}

