/*
 * Decompiled with CFR 0.152.
 */
package cn.agrj.rsRk.zip;

import cn.agrj.rsRk.zip.Adler32;
import cn.agrj.rsRk.zip.InflaterDynHeader;
import cn.agrj.rsRk.zip.InflaterHuffmanTree;
import cn.agrj.rsRk.zip.OutputWindow;
import cn.agrj.rsRk.zip.StreamManipulator;

public class Inflater {
    private static final int[] CPLENS = new int[]{3, 4, 5, 6, 7, 8, 9, 10, 11, 13, 15, 17, 19, 23, 27, 31, 35, 43, 51, 59, 67, 83, 99, 115, 131, 163, 195, 227, 258};
    private static final int[] CPLEXT;
    private static final int[] CPDIST;
    private static final int[] CPDEXT;
    private int mode;
    private int readAdler;
    private int neededBits;
    private int uncomprLen;
    private boolean isLastBlock;
    private int totalOut;
    private int totalIn;
    private int repLength;
    private int repDist;
    private boolean nowrap;
    private StreamManipulator input;
    private OutputWindow outputWindow;
    private InflaterDynHeader dynHeader;
    private InflaterHuffmanTree litlenTree;
    private InflaterHuffmanTree distTree;
    private Adler32 adler;

    static {
        int[] nArray = new int[29];
        nArray[8] = 1;
        nArray[9] = 1;
        nArray[10] = 1;
        nArray[11] = 1;
        nArray[12] = 2;
        nArray[13] = 2;
        nArray[14] = 2;
        nArray[15] = 2;
        nArray[16] = 3;
        nArray[17] = 3;
        nArray[18] = 3;
        nArray[19] = 3;
        nArray[20] = 4;
        nArray[21] = 4;
        nArray[22] = 4;
        nArray[23] = 4;
        nArray[24] = 5;
        nArray[25] = 5;
        nArray[26] = 5;
        nArray[27] = 5;
        CPLEXT = nArray;
        CPDIST = new int[]{1, 2, 3, 4, 5, 7, 9, 13, 17, 25, 33, 49, 65, 97, 129, 193, 257, 385, 513, 769, 1025, 1537, 2049, 3073, 4097, 6145, 8193, 12289, 16385, 24577};
        int[] nArray2 = new int[30];
        nArray2[4] = 1;
        nArray2[5] = 1;
        nArray2[6] = 2;
        nArray2[7] = 2;
        nArray2[8] = 3;
        nArray2[9] = 3;
        nArray2[10] = 4;
        nArray2[11] = 4;
        nArray2[12] = 5;
        nArray2[13] = 5;
        nArray2[14] = 6;
        nArray2[15] = 6;
        nArray2[16] = 7;
        nArray2[17] = 7;
        nArray2[18] = 8;
        nArray2[19] = 8;
        nArray2[20] = 9;
        nArray2[21] = 9;
        nArray2[22] = 10;
        nArray2[23] = 10;
        nArray2[24] = 11;
        nArray2[25] = 11;
        nArray2[26] = 12;
        nArray2[27] = 12;
        nArray2[28] = 13;
        nArray2[29] = 13;
        CPDEXT = nArray2;
    }

    protected Inflater(boolean nohead) {
        this.nowrap = nohead;
        this.adler = new Adler32();
        this.input = new StreamManipulator();
        this.outputWindow = new OutputWindow();
        this.mode = this.nowrap ? 2 : 0;
    }

    public boolean finished() {
        return this.mode == 12 && this.outputWindow.getAvailable() == 0;
    }

    public int getRemaining() {
        return this.input.getAvailableBytes();
    }

    public int getTotalIn() {
        return this.totalIn - this.getRemaining();
    }

    public int getTotalOut() {
        return this.totalOut;
    }

    public int inflate(byte[] buf, int off, int len) {
        if (len <= 0) {
            return 0;
        }
        int count = 0;
        do {
            if (this.mode == 11) continue;
            int more = this.outputWindow.copyOutput(buf, off, len);
            this.adler.update(buf, off, more);
            off += more;
            count += more;
            this.totalOut += more;
            if ((len -= more) != 0) continue;
            return count;
        } while (this.decode() || this.outputWindow.getAvailable() > 0 && this.mode != 11);
        return count;
    }

    public boolean needsDictionary() {
        return this.mode == 1 && this.neededBits == 0;
    }

    public boolean needsInput() {
        return this.input.needsInput();
    }

    public void reset() {
        this.mode = this.nowrap ? 2 : 0;
        this.totalOut = 0;
        this.totalIn = 0;
        this.input.reset();
        this.outputWindow.reset();
        this.dynHeader = null;
        this.litlenTree = null;
        this.distTree = null;
        this.isLastBlock = false;
        this.adler.reset();
    }

    public void setInput(byte[] buf, int off, int len) {
        this.input.setInput(buf, off, len);
        this.totalIn += len;
    }

    private boolean decodeHeader() {
        int header = this.input.peekBits(16);
        if (header < 0) {
            return false;
        }
        this.input.dropBits(16);
        header = (header << 8 | header >> 8) & 0xFFFF;
        if ((header & 0x20) == 0) {
            this.mode = 2;
        } else {
            this.mode = 1;
            this.neededBits = 32;
        }
        return true;
    }

    private boolean decodeDict() {
        while (this.neededBits > 0) {
            int dictByte = this.input.peekBits(8);
            if (dictByte < 0) {
                return false;
            }
            this.input.dropBits(8);
            this.readAdler = this.readAdler << 8 | dictByte;
            this.neededBits -= 8;
        }
        return false;
    }

    private boolean decodeHuffman() {
        int free = this.outputWindow.getFreeSpace();
        while (free >= 258) {
            switch (this.mode) {
                case 7: {
                    int symbol;
                    while (((symbol = this.litlenTree.getSymbol(this.input)) & 0xFFFFFF00) == 0) {
                        this.outputWindow.write(symbol);
                        if (--free >= 258) continue;
                        return true;
                    }
                    if (symbol < 257) {
                        if (symbol < 0) {
                            return false;
                        }
                        this.distTree = null;
                        this.litlenTree = null;
                        this.mode = 2;
                        return true;
                    }
                    this.repLength = CPLENS[symbol - 257];
                    this.neededBits = CPLEXT[symbol - 257];
                }
                case 8: {
                    int i;
                    if (this.neededBits > 0) {
                        this.mode = 8;
                        i = this.input.peekBits(this.neededBits);
                        if (i < 0) {
                            return false;
                        }
                        this.input.dropBits(this.neededBits);
                        this.repLength += i;
                    }
                    this.mode = 9;
                }
                case 9: {
                    int symbol = this.distTree.getSymbol(this.input);
                    if (symbol < 0) {
                        return false;
                    }
                    this.repDist = CPDIST[symbol];
                    this.neededBits = CPDEXT[symbol];
                }
                case 10: {
                    int i;
                    if (this.neededBits > 0) {
                        this.mode = 10;
                        i = this.input.peekBits(this.neededBits);
                        if (i < 0) {
                            return false;
                        }
                        this.input.dropBits(this.neededBits);
                        this.repDist += i;
                    }
                    this.outputWindow.repeat(this.repLength, this.repDist);
                    free -= this.repLength;
                    this.mode = 7;
                }
            }
        }
        return true;
    }

    private boolean decodeChksum() {
        while (this.neededBits > 0) {
            int chkByte = this.input.peekBits(8);
            if (chkByte < 0) {
                return false;
            }
            this.input.dropBits(8);
            this.readAdler = this.readAdler << 8 | chkByte;
            this.neededBits -= 8;
        }
        this.mode = 12;
        return false;
    }

    private boolean decode() {
        switch (this.mode) {
            case 0: {
                return this.decodeHeader();
            }
            case 1: {
                return this.decodeDict();
            }
            case 11: {
                return this.decodeChksum();
            }
            case 2: {
                if (this.isLastBlock) {
                    if (this.nowrap) {
                        this.mode = 12;
                        return false;
                    }
                    this.input.skipToByteBoundary();
                    this.neededBits = 32;
                    this.mode = 11;
                    return true;
                }
                int type = this.input.peekBits(3);
                if (type < 0) {
                    return false;
                }
                this.input.dropBits(3);
                if ((type & 1) != 0) {
                    this.isLastBlock = true;
                }
                switch (type >> 1) {
                    case 0: {
                        this.input.skipToByteBoundary();
                        this.mode = 3;
                        break;
                    }
                    case 1: {
                        this.litlenTree = InflaterHuffmanTree.defLitLenTree;
                        this.distTree = InflaterHuffmanTree.defDistTree;
                        this.mode = 7;
                        break;
                    }
                    case 2: {
                        this.dynHeader = new InflaterDynHeader();
                        this.mode = 6;
                    }
                }
                return true;
            }
            case 3: {
                this.uncomprLen = this.input.peekBits(16);
                if (this.uncomprLen < 0) {
                    return false;
                }
                this.input.dropBits(16);
                this.mode = 4;
            }
            case 4: {
                int nlen = this.input.peekBits(16);
                if (nlen < 0) {
                    return false;
                }
                this.input.dropBits(16);
                this.mode = 5;
            }
            case 5: {
                int more = this.outputWindow.copyStored(this.input, this.uncomprLen);
                this.uncomprLen -= more;
                if (this.uncomprLen == 0) {
                    this.mode = 2;
                    return true;
                }
                return !this.input.needsInput();
            }
            case 6: {
                if (!this.dynHeader.decode(this.input)) {
                    return false;
                }
                this.litlenTree = this.dynHeader.buildLitLenTree();
                this.distTree = this.dynHeader.buildDistTree();
                this.mode = 7;
            }
            case 7: 
            case 8: 
            case 9: 
            case 10: {
                return this.decodeHuffman();
            }
            case 12: {
                return false;
            }
        }
        return false;
    }
}

