/*
 * Decompiled with CFR 0.152.
 */
package gameboy.utils;

import javax.microedition.lcdui.List;

public class Utils {
    public static boolean isEmptyString(String s) {
        return s == null || s.trim().length() == 0;
    }

    public static boolean isEmptyMenuList(List list) {
        return list == null || list.size() == 0;
    }

    public static String millisTimeToString(long millisTime, boolean showNullDays, boolean showNullHours, boolean showNullMinutes, boolean showNullSeconds) {
        String str = "";
        long secTime = millisTime / 1000L;
        long s = 0L;
        long m = 0L;
        long h = 0L;
        long d = 0L;
        d = secTime / 86400L;
        h = (secTime %= 86400L) / 3600L;
        m = (secTime %= 3600L) / 60L;
        s = secTime %= 60L;
        if (d == 0L && showNullDays || d > 0L) {
            str = str + d + "d";
        }
        if (h == 0L && showNullHours || h > 0L) {
            if (str.length() > 0) {
                str = str + ", ";
            }
            str = str + h + "h";
        }
        if (m == 0L && showNullMinutes || m > 0L) {
            if (str.length() > 0) {
                str = str + ", ";
            }
            str = str + m + "m";
        }
        if (s == 0L && showNullSeconds || s > 0L) {
            if (str.length() > 0) {
                str = str + ", ";
            }
            str = str + s + "s";
        }
        return str.trim();
    }

    public static String bytes2unit(long bytes, boolean stripChange) {
        if (bytes <= 1024L) {
            return bytes + "";
        }
        if (bytes > 1024L && bytes < 0x100000L) {
            return bytes / 1024L + " KB";
        }
        if (bytes >= 0x100000L) {
            long change = bytes % 0x100000L;
            String changeStr = Long.toString(change);
            if (stripChange && changeStr.length() == 6) {
                changeStr = changeStr.substring(0, 1);
            } else if (stripChange && changeStr.length() == 7) {
                bytes += change;
                change = 0L;
            } else {
                change = 0L;
            }
            if (change > 0L) {
                return bytes / 0x100000L + "." + changeStr + " MB";
            }
            return bytes / 0x100000L + " MB";
        }
        if (bytes >= 0x40000000L) {
            long change = bytes % 0x40000000L;
            String changeStr = Long.toString(change);
            if (stripChange && changeStr.length() == 9) {
                changeStr = changeStr.substring(0, 1);
            } else if (stripChange && changeStr.length() == 10) {
                bytes += change;
                change = 0L;
            } else {
                change = 0L;
            }
            if (change > 0L) {
                changeStr = Long.toString(change);
                return bytes / 0x40000000L + "." + changeStr + " GB";
            }
            return bytes / 0x40000000L + " GB";
        }
        return Long.toString(bytes);
    }

    public static long getSimpleCRC(byte[] b) {
        long crc = 0L;
        for (int i = 0; i < b.length; ++i) {
            crc += (long)b[i];
        }
        return crc += (long)b.length;
    }
}

