/*
 * Decompiled with CFR 0.152.
 */
package gameboy.core;

import gameboy.core.CPU;
import gameboy.core.Cartridge;
import gameboy.core.Interrupt;
import gameboy.core.Joypad;
import gameboy.core.Memory;
import gameboy.core.RAM;
import gameboy.core.Serial;
import gameboy.core.Sound;
import gameboy.core.Timer;
import gameboy.core.Video;
import gameboy.core.driver.ClockDriver;
import gameboy.core.driver.JoypadDriver;
import gameboy.core.driver.SoundDriver;
import gameboy.core.driver.StoreDriver;
import gameboy.core.driver.VideoDriver;

public class GameBoy
implements Memory {
    private static final byte[] REGISTERED_BITMAP = new byte[]{60, 66, -71, -91, -71, -91, 66, 60};
    private RAM ram = new RAM();
    private Cartridge cartridge;
    private Interrupt interrupt;
    private CPU cpu;
    private Serial serial;
    private Timer timer;
    private Joypad joypad;
    private Video video;
    private Sound sound;

    public GameBoy(VideoDriver videoDriver, SoundDriver soundDriver, JoypadDriver joypadDriver, StoreDriver storeDriver, ClockDriver clockDriver) {
        this.cartridge = new Cartridge(storeDriver, clockDriver);
        this.interrupt = new Interrupt();
        this.cpu = new CPU(this.interrupt, this);
        this.serial = new Serial(this.interrupt);
        this.timer = new Timer(this.interrupt);
        this.joypad = new Joypad(joypadDriver, this.interrupt);
        this.video = new Video(videoDriver, this.interrupt, this);
        this.sound = new Sound(soundDriver);
    }

    private final byte[] intArray2ByteArray(int[] ia) {
        byte[] ba = new byte[ia.length * 4];
        int i = 0;
        int j = 0;
        while (i < ia.length) {
            byte[] b = this.int2ByteArray(ia[i]);
            System.arraycopy(b, 0, ba, j, 4);
            ++i;
            j += 4;
        }
        return ba;
    }

    private final int byteArrayToInt(byte[] b, int offset) {
        int value = 0;
        int shift = 0;
        for (int i = 0; i < 4; ++i) {
            shift = (3 - i) * 8;
            value += (b[i + offset] & 0xFF) << shift;
        }
        return value;
    }

    private final int[] byteArrayToIntArray(byte[] b) {
        if (b.length < 4 || b.length % 4 != 0) {
            return null;
        }
        int count = b.length / 4;
        int[] ints = new int[count];
        int i = 0;
        int j = 0;
        while (i < b.length) {
            ints[j] = this.byteArrayToInt(b, i);
            i += 4;
            ++j;
        }
        return ints;
    }

    private final byte[] int2ByteArray(int i) {
        byte[] dword = new byte[]{(byte)(i >> 24 & 0xFF), (byte)(i >> 16 & 0xFF), (byte)(i >> 8 & 0xFF), (byte)(i & 0xFF)};
        return dword;
    }

    private final void resetByteArray(byte[] ba) {
        for (int i = 0; i < ba.length; ++i) {
            ba[0] = 0;
        }
    }

    public final void setFullGameBoyState(byte[] state, int startOffset) {
        int offset = 0;
        offset = startOffset;
        int len = this.intArray2ByteArray(this.cpu.getState()).length;
        byte[] cpuState = new byte[len];
        System.arraycopy(state, offset, cpuState, 0, len);
        offset += len;
        len = this.int2ByteArray(this.interrupt.getEnable()).length;
        byte[] interruptEnable = new byte[len];
        System.arraycopy(state, offset, interruptEnable, 0, len);
        offset += len;
        len = this.int2ByteArray(this.interrupt.getFlag()).length;
        byte[] interruptFlag = new byte[len];
        System.arraycopy(state, offset, interruptFlag, 0, len);
        offset += len;
        len = this.ram.getWRam().length;
        byte[] wram = new byte[len];
        System.arraycopy(state, offset, wram, 0, len);
        offset += len;
        len = this.ram.getHRam().length;
        byte[] hram = new byte[len];
        System.arraycopy(state, offset, hram, 0, len);
        offset += len;
        len = this.intArray2ByteArray(this.video.getRegVideoState()).length;
        byte[] regVideoState = new byte[len];
        System.arraycopy(state, offset, regVideoState, 0, len);
        offset += len;
        len = this.video.getBasicVideoState().length;
        byte[] basicVideoState = new byte[len];
        System.arraycopy(state, offset, basicVideoState, 0, len);
        offset += len;
        len = this.intArray2ByteArray(this.video.getAdvVideoState()).length;
        byte[] advVideoState = new byte[len];
        System.arraycopy(state, offset, advVideoState, 0, len);
        this.cpu.setState(this.byteArrayToIntArray(cpuState));
        this.interrupt.setEnable(this.byteArrayToInt(interruptEnable, 0));
        this.interrupt.setFlag(this.byteArrayToInt(interruptFlag, 0));
        this.ram.setWRam(wram);
        this.ram.setHRam(hram);
        this.video.setRegVideoState(this.byteArrayToIntArray(regVideoState));
        this.video.setBasicVideoState(basicVideoState);
        this.video.setAdvVideoState(this.byteArrayToIntArray(advVideoState));
    }

    public final byte[] getFullGameBoyState() {
        int offset = 0;
        byte[] wram = this.ram.getWRam();
        byte[] hram = this.ram.getHRam();
        byte[] cpuState = this.intArray2ByteArray(this.cpu.getState());
        byte[] interruptEnable = this.int2ByteArray(this.interrupt.getEnable());
        byte[] interruptFlag = this.int2ByteArray(this.interrupt.getFlag());
        byte[] basicVideoState = this.video.getBasicVideoState();
        byte[] regVideoState = this.intArray2ByteArray(this.video.getRegVideoState());
        byte[] advVideoState = this.intArray2ByteArray(this.video.getAdvVideoState());
        byte[] state = new byte[wram.length + hram.length + cpuState.length + interruptEnable.length + interruptFlag.length + basicVideoState.length + regVideoState.length + advVideoState.length];
        this.resetByteArray(state);
        System.arraycopy(cpuState, 0, state, offset, cpuState.length);
        System.arraycopy(interruptEnable, 0, state, offset += cpuState.length, interruptEnable.length);
        System.arraycopy(interruptFlag, 0, state, offset += interruptEnable.length, interruptFlag.length);
        System.arraycopy(wram, 0, state, offset += interruptFlag.length, wram.length);
        System.arraycopy(hram, 0, state, offset += wram.length, hram.length);
        System.arraycopy(regVideoState, 0, state, offset += hram.length, regVideoState.length);
        System.arraycopy(basicVideoState, 0, state, offset += regVideoState.length, basicVideoState.length);
        System.arraycopy(advVideoState, 0, state, offset += basicVideoState.length, advVideoState.length);
        return state;
    }

    public final Cartridge getCartridge() {
        return this.cartridge;
    }

    public final int getFrameSkip() {
        return this.video.getFrameSkip();
    }

    public final void setFrameSkip(int frameSkip) {
        this.video.setFrameSkip(frameSkip);
    }

    public final void load(String cartridgeName) {
        this.cartridge.load(cartridgeName);
    }

    public final void save(String cartridgeName) {
        this.cartridge.save(cartridgeName);
    }

    public final void start() {
        this.sound.start();
    }

    public final void stop() {
        this.sound.stop();
    }

    public final void reset() {
        this.ram.reset();
        this.cartridge.reset();
        this.interrupt.reset();
        this.cpu.reset();
        this.serial.reset();
        this.timer.reset();
        this.joypad.reset();
        this.video.reset();
        this.sound.reset();
        this.cpu.setROM(this.cartridge.getROM());
        this.drawLogo();
    }

    public final int cycles() {
        return Math.min(this.video.cycles(), this.joypad.cycles());
    }

    public final void emulate(int ticks) {
        while (ticks > 0) {
            int count = this.cycles();
            this.cpu.emulate(count);
            this.video.emulate(count);
            this.joypad.emulate(count);
            ticks -= count;
        }
    }

    public final void write(int address, int data) {
        if (address <= Short.MAX_VALUE) {
            this.cartridge.write(address, data);
        } else if (address <= 40959) {
            this.video.write(address, data);
        } else if (address <= 49151) {
            this.cartridge.write(address, data);
        } else if (address <= 65023) {
            this.ram.write(address, data);
        } else if (address <= 65279) {
            this.video.write(address, data);
        } else if (address == 65280) {
            this.joypad.write(address, data);
        } else if (address >= 65281 && address <= 65282) {
            this.serial.write(address, data);
        } else if (address >= 65284 && address <= 65287) {
            this.timer.write(address, data);
        } else if (address == 65295) {
            this.interrupt.write(address, data);
            this.cpu.interrupt();
        } else if (address >= 65296 && address <= 65343) {
            this.sound.write(address, data);
        } else if (address >= 65344 && address <= 65355) {
            this.video.write(address, data);
            if (address == 65345) {
                this.cpu.interrupt();
            }
        } else if (address >= 65408 && address <= 65534) {
            this.ram.write(address, data);
        } else if (address == 65535) {
            this.interrupt.write(address, data);
            this.cpu.interrupt();
        }
    }

    public final int read(int address) {
        if (address <= Short.MAX_VALUE) {
            return this.cartridge.read(address);
        }
        if (address <= 40959) {
            return this.video.read(address);
        }
        if (address <= 49151) {
            return this.cartridge.read(address);
        }
        if (address <= 65023) {
            return this.ram.read(address);
        }
        if (address <= 65279) {
            return this.video.read(address);
        }
        if (address == 65280) {
            return this.joypad.read(address);
        }
        if (address >= 65281 && address <= 65282) {
            return this.serial.read(address);
        }
        if (address >= 65284 && address <= 65287) {
            return this.timer.read(address);
        }
        if (address == 65295) {
            return this.interrupt.read(address);
        }
        if (address >= 65296 && address <= 65343) {
            return this.sound.read(address);
        }
        if (address >= 65344 && address <= 65355) {
            return this.video.read(address);
        }
        if (address >= 65408 && address <= 65534) {
            return this.ram.read(address);
        }
        if (address == 65535) {
            return this.interrupt.read(address);
        }
        return 255;
    }

    private final void drawLogo() {
        int index;
        for (index = 0; index < 48; ++index) {
            int bits = this.cartridge.read(260 + index);
            int pattern0 = (bits >> 0 & 0x80) + (bits >> 1 & 0x60) + (bits >> 2 & 0x18) + (bits >> 3 & 6) + (bits >> 4 & 1);
            int pattern1 = (bits << 4 & 0x80) + (bits << 3 & 0x60) + (bits << 2 & 0x18) + (bits << 1 & 6) + (bits << 0 & 1);
            this.video.write(32784 + (index << 3), pattern0);
            this.video.write(32786 + (index << 3), pattern0);
            this.video.write(32788 + (index << 3), pattern1);
            this.video.write(32790 + (index << 3), pattern1);
        }
        for (index = 0; index < 8; ++index) {
            this.video.write(33168 + (index << 1), REGISTERED_BITMAP[index]);
        }
        for (int tile = 0; tile < 12; ++tile) {
            this.video.write(39172 + tile, tile + 1);
            this.video.write(39204 + tile, tile + 13);
        }
        this.video.write(39184, 25);
    }
}

