/*
 * Decompiled with CFR 0.152.
 */
package gameboy.utils;

import gameboy.utils.Utils;
import java.io.IOException;
import java.io.InputStream;
import java.util.Enumeration;
import java.util.Vector;

public class Properties {
    public static final byte FETCH_LAZY = 1;
    public static final byte FETCH_ALL = 2;
    InputStream propIs;
    Vector keys;
    Vector values;
    String filePath;
    String locale;
    String shortLocale;
    byte fetchMode;

    public Properties(String filePath, byte fetchMode) {
        this.filePath = filePath;
        this.fetchMode = fetchMode;
        this.locale = System.getProperty("microedition.locale");
        this.locale = this.locale == null || this.locale.length() == 0 ? "en" : this.locale.toLowerCase();
        int pos = this.locale.indexOf(45);
        this.shortLocale = pos != -1 ? this.locale.substring(0, pos) : this.locale;
        this.propIs = this.getClass().getResourceAsStream(filePath);
        if (this.propIs == null) {
            this.propIs = this.getClass().getResourceAsStream(filePath + '_' + this.locale + ".properties");
            if (this.propIs == null) {
                this.propIs = this.getClass().getResourceAsStream(filePath + '_' + this.shortLocale + ".properties");
                if (this.propIs == null) {
                    this.propIs = this.getClass().getResourceAsStream(filePath + "_en.properties");
                    if (this.propIs == null) {
                        throw new RuntimeException("Unable to open properties: " + filePath);
                    }
                    this.filePath = filePath + "_en.properties";
                } else {
                    this.filePath = filePath + '_' + this.shortLocale + ".properties";
                }
            } else {
                this.filePath = filePath + '_' + this.locale + ".properties";
            }
        }
        if (fetchMode <= 0) {
            fetchMode = (byte)2;
        }
        if (fetchMode == 2) {
            this.load(this.propIs);
            this.closeInputStream();
        } else if (fetchMode != 1) {
            throw new RuntimeException("Available modes are Properties.FETCH_LAZY & Properties.FETCH_ALL");
        }
        System.gc();
    }

    public String getFilePath() {
        return this.filePath;
    }

    private void closeInputStream() {
        if (this.propIs != null) {
            try {
                this.propIs.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
            this.propIs = null;
        }
    }

    public void close() {
        this.closeInputStream();
    }

    public void resetInputStream() {
        this.closeInputStream();
        this.propIs = this.getClass().getResourceAsStream(this.filePath);
        if (this.propIs == null) {
            throw new RuntimeException("Unable to open properties: " + this.filePath);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean load(InputStream propIs) {
        try {
            if (propIs != null && propIs.available() == 0) {
                return false;
            }
        }
        catch (IOException ex) {
            return false;
        }
        try {
            this.keys = new Vector();
            this.values = new Vector();
            while (propIs.available() > 0) {
                String line = "";
                int c = 32;
                while ((c = propIs.read()) > 0 && c != 10) {
                    if (c == 10) continue;
                    line = line + (char)c;
                }
                line = line.trim();
                int pos = line.indexOf(61);
                if (line.length() <= 0 || pos + 1 >= line.length()) continue;
                String key = line.substring(0, pos).trim().toLowerCase();
                String value = line.substring(pos + 1, line.length());
                if (key.length() <= 0) continue;
                this.keys.addElement(key);
                this.values.addElement(value);
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        finally {
            this.resetInputStream();
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String loadKeyValue(String requestedKey) {
        try {
            if (this.propIs != null && this.propIs.available() == 0) {
                return null;
            }
        }
        catch (IOException ex) {
            return null;
        }
        try {
            this.keys = new Vector();
            this.values = new Vector();
            while (this.propIs.available() > 0) {
                String line = "";
                int c = 32;
                while ((c = this.propIs.read()) > 0 && c != 10) {
                    if (c == 10) continue;
                    line = line + (char)c;
                }
                line = line.trim();
                int pos = line.indexOf(61);
                if (line.length() <= 0 || pos + 1 >= line.length()) continue;
                String key = line.substring(0, pos).trim().toLowerCase();
                String value = line.substring(pos + 1, line.length());
                if (key.length() <= 0 || !key.equals(requestedKey)) continue;
                String ex = value;
                return ex;
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        finally {
            this.resetInputStream();
        }
        return null;
    }

    private String getKeyValue(String requestedKey) {
        if (this.keys == null || this.keys.size() == 0) {
            return null;
        }
        Enumeration keysEnum = this.keys.elements();
        Enumeration valuesEnum = this.values.elements();
        while (keysEnum.hasMoreElements() && valuesEnum.hasMoreElements()) {
            String value = (String)valuesEnum.nextElement();
            if (!requestedKey.equals((String)keysEnum.nextElement())) continue;
            return value;
        }
        return null;
    }

    public String getProperty(String key) {
        String value = this.getKeyValue(key = key.trim().toLowerCase());
        if (value != null) {
            return value;
        }
        value = this.loadKeyValue(key);
        if (value != null) {
            this.keys.addElement(key);
            this.values.addElement(value);
            return value;
        }
        return key;
    }

    public String getProperty(String key, String defaultValue) {
        String value = this.getKeyValue(key = key.trim().toLowerCase());
        if (value != null) {
            return value;
        }
        value = this.loadKeyValue(key);
        if (value != null) {
            this.keys.addElement(key);
            this.values.addElement(value);
            return value;
        }
        return defaultValue;
    }

    public Enumeration propertyNames() {
        if (this.keys != null) {
            return this.keys.elements();
        }
        return null;
    }

    public static String getSystemProperty(String key) {
        if (Utils.isEmptyString(key)) {
            return null;
        }
        String v = System.getProperty(key);
        if (Utils.isEmptyString(v)) {
            return null;
        }
        return v;
    }

    public static String getSystemProperty(String key, String defaultValue) {
        String v = Properties.getSystemProperty(key);
        if (v == null) {
            return defaultValue;
        }
        return v;
    }
}

