/*
 * Decompiled with CFR 0.152.
 */
package de.joergjahnke.gameboy.core;

import de.joergjahnke.common.emulation.RunnableDevice;
import de.joergjahnke.common.emulation.ThrottleableCPU;
import de.joergjahnke.common.io.Serializable;
import de.joergjahnke.common.io.SerializationUtils;
import de.joergjahnke.common.util.Logger;
import de.joergjahnke.gameboy.core.Cartridge;
import de.joergjahnke.gameboy.core.Gameboy;
import de.joergjahnke.gameboy.core.SoundChannel;
import de.joergjahnke.gameboy.core.SoundChip;
import de.joergjahnke.gameboy.core.Sprite;
import de.joergjahnke.gameboy.core.SquareWaveChannel;
import de.joergjahnke.gameboy.core.VideoChip;
import de.joergjahnke.gameboy.core.VoluntaryWaveChannel;
import de.joergjahnke.gameboy.core.WhiteNoiseChannel;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;

public class CPU
extends RunnableDevice
implements ThrottleableCPU,
Serializable {
    private static final boolean DEBUG_CODE = false;
    private static final boolean DEBUG_INTERRUPTS = false;
    private static final boolean DEBUG_DMA = false;
    private static final boolean IMMEDIATE_HDMA = false;
    private static final int WRAM_BANK_SIZE = 4096;
    private static final int WRAM_SIZE = 8192;
    private static final int VRAM_AREA = 32768;
    private static final int RAM_BANK_AREA = 40960;
    private static final int WRAM_AREA = 49152;
    private static final int SWITCHABLE_WRAM_AREA = 53248;
    private static final int ECHO_RAM_AREA = 57344;
    private static final int HIGH_RAM_AREA = 65024;
    private static final int IO_AREA = 65280;
    private static final int ZERO = 128;
    private static final int NEGATIVE = 64;
    private static final int HALFCARRY = 32;
    private static final int CARRY = 16;
    private static final int JOYPAD_PORT = 65280;
    private static final int INTERRUPT_FLAG = 65295;
    private static final int HDMA_SOURCE_HIGH = 65361;
    private static final int HDMA_SOURCE_LOW = 65362;
    private static final int HDMA_DEST_HIGH = 65363;
    private static final int HDMA_DEST_LOW = 65364;
    private static final int HDMA_CONTROL = 65365;
    private static final int LCD_CONTROL = 65344;
    private static final int LCD_STATUS = 65345;
    private static final int LCD_LINE = 65348;
    private static final int SPEED_SWITCH = 65357;
    private static final int INTERRUPT_ENABLE = 65535;
    public static final int IRQ_VBLANK = 1;
    public static final int IRQ_LCDSTAT = 2;
    public static final int IRQ_TIMER = 4;
    public static final int IRQ_SERIAL = 8;
    public static final int IRQ_JOYPAD = 16;
    private static final int IRQ_VECTOR_VBLANK = 64;
    private static final int IRQ_VECTOR_JOYPAD = 96;
    private static final int RESET_VECTOR = 256;
    private static final String[] ASSEMBLY = new String[]{"NOP", "LD BC,d16", "LD (BC),A", "INC BC", "INC B", "DEC B", "LD B,d8", "RLCA", "LD (a16),SP", "ADD HL,BC", "LD A,(BC)", "DEC BC", "INC C", "DEC C", "LD C,d8", "RRCA", "STOP", "LD DE,d16", "LD (DE), A", "INC DE", "INC D", "DEC D", "LD D", "RLA", "JR r8", "ADD HL,DE", "LD A,(DE)", "DEC DE", "INC E", "DEC E", "LD E,d8", "RRA", "JR NZ,r8", "LD HL,d16", "LD (HL+),A", "INC HL", "INC H", "DEC H", "LD H,d8", "DAA", "JR Z,r8", "ADD HL,HL", "LD A,(HL+)", "DEC HL", "INC L", "DEC L", "LD L,d8", "CPL", "JR NC,r8", "LD SP,d16", "LD (HL-),A", "INC SP", "INC (HL)", "DEC (HL)", "LD (HL),d8", "SCF", "JR C,r8", "ADD HL,SP", "LD A,(HL-)", "DEC SP", "INC A", "DEC A", "LD A,d8", "CCF", "LD B,B", "LD B,C", "LD B,D", "LD B,E", "LD B,H", "LD B,L", "LD B,(HL)", "LD B,A", "LD C,B", "LD C,C", "LD C,D", "LD C,E", "LD C,H", "LD C,L", "LD C,(HL)", "LD C,A", "LD D,B", "LD D,C", "LD D,D", "LD D,E", "LD D,H", "LD D,L", "LD D,(HL)", "LD D,A", "LD E,B", "LD E,C", "LD E,D", "LD E,E", "LD E,H", "LD E,L", "LD E,(HL)", "LD E,A", "LD H,B", "LD H,C", "LD H,D", "LD H,E", "LD H,H", "LD H,L", "LD H,(HL)", "LD H,A", "LD L,B", "LD L,C", "LD L,D", "LD L,E", "LD L,H", "LD L,L", "LD L,(HL)", "LD L,A", "LD (HL),B", "LD (HL),C", "LD (HL),D", "LD (HL),E", "LD (HL),H", "LD (HL),L", "HALT", "LD (HL),A", "LD A,B", "LD A,C", "LD A,D", "LD A,E", "LD A,H", "LD A,L", "LD A,(HL)", "LD A,A", "ADD B", "ADD C", "ADD D", "ADD E", "ADD H", "ADD L", "ADD (HL)", "ADD A", "ADC B", "ADC C", "ADC D", "ADC E", "ADC H", "ADC L", "ADC (HL)", "ADC A", "SUB B", "SUB C", "SUB D", "SUB E", "SUB H", "SUB L", "SUB (HL)", "SUB A", "SBC B", "SBC C", "SBC D", "SBC E", "SBC H", "SBC L", "SBC (HL)", "SBC A", "AND B", "AND C", "AND D", "AND E", "AND H", "AND L", "AND (HL)", "AND A", "XOR B", "XOR C", "XOR D", "XOR E", "XOR H", "XOR L", "XOR (HL)", "XOR A", "OR B", "OR C", "OR D", "OR E", "OR H", "OR L", "OR (HL)", "OR A", "CP B", "CP C", "CP D", "CP E", "CP H", "CP L", "CP (HL)", "CP A", "RET NZ", "POP BC", "JP NZ,a16", "JP a16", "CALL NZ,a16", "PUSH BC", "ADD d8", "RST $00", "RET Z", "RET", "JP Z,a16", "Prefix CB", "CALL Z,a16", "CALL a16", "ADC d8", "RST $08", "RET NC", "POP DE", "JP NC,a16", "?", "CALL NC,a16", "PUSH DE", "SUB d8", "RST $10", "RET C", "RETI", "JP C,a16", "?", "CALL C,a16", "?", "SBC d8", "RST $18", "LD ($FF00+a8),A", "POP HL", "LD ($FF00+C),A", "?", "?", "PUSH HL", "AND d8", "RST $20", "ADD SP,r8", "JP (HL)", "LD (a16),A", "?", "?", "?", "XOR d8", "RST $28", "LD A,($FF00+a8)", "POP AF", "LD A,($FF00+C)", "DI", "?", "PUSH AF", "OR d8", "RST $30", "LD HL,SP+r8", "LD SP,HL", "LD A,(a16)", "EI", "?", "?", "CP d8", "RST $38"};
    private static final String[] ASSEMBLY_CB = new String[]{"RLC ", "RRC ", "RL ", "RR ", "SLA ", "SRA ", "SWAP ", "SRL ", "BIT 0,", "BIT 1,", "BIT 2,", "BIT 3,", "BIT 4,", "BIT 5,", "BIT 6,", "BIT 7,", "RES 0,", "RES 1,", "RES 2,", "RES 3,", "RES 4,", "RES 5,", "RES 6,", "RES 7,", "SET 0,", "SET 1,", "SET 2,", "SET 3,", "SET 4,", "SET 5,", "SET 6,", "SET 7,"};
    private static final String[] REGISTERS = new String[]{"B", "C", "D", "E", "H", "L", "(HL)", "A"};
    private static final int[][] DAA_ADJUST = new int[][]{{0, 96, 0, 160, 6, 102, 250, 154}, {6, 102, 0, 160, 6, 102, 250, 154}, {96, 96, 0, 160, 102, 102, 250, 154}, {102, 102, 0, 160, 102, 102, 250, 154}};
    protected final Gameboy gameboy;
    private VideoChip video;
    private SoundChip sound;
    protected final Cartridge cartridge;
    protected final byte[] memory;
    protected Logger logger;
    private long cycles = 0L;
    private long throttledMillis = 0L;
    private int a;
    private int b = 0;
    private int c = 19;
    private int d = 0;
    private int e = 216;
    private int f = 176;
    private int hl = 333;
    private int sp = 65534;
    private int pc = 256;
    private boolean isInterruptEnabled = false;
    private boolean doesInterruptEnableSwitch = false;
    private int irqsRequested = 0;
    private int irqsEnabled = 0;
    private int currentGBCRAMBank = 1;
    private final byte[][] gbcRAMBanks = new byte[7][4096];
    private final Timer timer = new Timer();
    private long nextEvent = 0L;
    private int cpuSpeed;
    private final int instructionsPerDiv;
    private boolean isSoundOn;
    private boolean hasSoundListener;
    private boolean isHDMARunning = false;

    public CPU(Gameboy gameboy, Cartridge cartridge) {
        this.gameboy = gameboy;
        this.cartridge = cartridge;
        this.memory = new byte[65536];
        System.arraycopy(cartridge.getROMBanks()[0], 0, this.memory, 0, 16384);
        System.arraycopy(cartridge.getROMBanks()[1], 0, this.memory, 16384, 16384);
        System.arraycopy(cartridge.getRAMBanks()[0], 0, this.memory, 40960, 8192);
        this.a = cartridge.isGBC() ? 17 : 1;
        this.cpuSpeed = 0x400000;
        this.instructionsPerDiv = this.cpuSpeed / 16384;
    }

    public final long getCycles() {
        return this.cycles;
    }

    public final void requestIRQ(int irq) {
        this.irqsRequested |= irq;
    }

    private void checkEvents() {
        long cycles_ = this.cycles;
        VideoChip video_ = this.video;
        if (cycles_ >= this.timer.getNextIRQRequest()) {
            this.requestIRQ(4);
            this.timer.restart();
        }
        if (cycles_ >= video_.getNextUpdate()) {
            video_.update(cycles_);
            if (this.isHDMARunning() && video_.getLCDLine() < 144 && video_.getVideoMode() == 0) {
                this.performHDMA(1);
            }
        }
        this.nextEvent = Math.min(this.timer.getNextIRQRequest(), video_.getNextUpdate());
        if (this.isSoundOn && this.hasSoundListener) {
            if (cycles_ >= this.sound.getNextUpdate()) {
                this.sound.update(cycles_);
            }
            this.nextEvent = Math.min(this.nextEvent, this.sound.getNextUpdate());
        }
    }

    private boolean isHDMARunning() {
        return this.isHDMARunning;
    }

    private void performHDMA(int blocks) {
        byte[] memory_ = this.memory;
        int source = ((memory_[65361] & 0xFF) << 8) + (memory_[65362] & 0xF0);
        int dest = ((memory_[65363] & 0x1F) << 8) + (memory_[65364] & 0xF0);
        VideoChip vc = this.video;
        int len = blocks << 4;
        for (int i = 0; i < len; ++i) {
            vc.writeByte(dest + i & 0x1FFF, (byte)this.readByte(source + i));
        }
        memory_[65365] = (byte)(memory_[65365] - blocks);
        boolean bl = this.isHDMARunning = (memory_[65365] & 0xFF) != 255;
        if (this.isHDMARunning()) {
            memory_[65361] = (byte)(source + (blocks << 4) >> 8);
            memory_[65362] = (byte)(source + (blocks << 4) & 0xFF);
            memory_[65363] = (byte)(dest + (blocks << 4) >> 8);
            memory_[65364] = (byte)(dest + (blocks << 4) & 0xFF);
        }
    }

    private void initialize() {
        this.video = this.gameboy.getVideoChip();
        this.sound = this.gameboy.getSoundChip();
        this.hasSoundListener = this.sound.countObservers() > 0;
    }

    public void powerUp() {
        this.initialize();
        this.writeByte(65295, (byte)1);
        this.writeByte(65315, (byte)-65);
        this.writeByte(65316, (byte)119);
        this.writeByte(65317, (byte)-13);
        this.writeByte(65318, (byte)-15);
        this.writeByte(65344, (byte)-111);
        this.writeByte(65351, (byte)-4);
        this.writeByte(65352, (byte)-1);
        this.writeByte(65353, (byte)-1);
        this.memory[65365] = -1;
    }

    private void setInterruptEnabled(boolean isInterruptEnabled) {
        this.isInterruptEnabled = isInterruptEnabled;
    }

    private void setH(int data) {
        this.hl &= 0xFF;
        this.hl |= data << 8;
    }

    private void setL(int data) {
        this.hl &= 0xFF00;
        this.hl |= data;
    }

    private void pushByte(int data) {
        int sp_ = this.sp = this.sp - 1 & 0xFFFF;
        this.writeByte(sp_, (byte)data);
    }

    private void pushWord(int data) {
        int sp_ = this.sp = this.sp - 2 & 0xFFFF;
        this.writeByte(sp_, (byte)(data & 0xFF));
        this.writeByte(sp_ + 1, (byte)(data >> 8));
    }

    private int popByte() {
        int sp_ = this.sp;
        int result = this.readByte(sp_);
        this.sp = sp_ + 1 & 0xFFFF;
        return result;
    }

    private int popWord() {
        int sp_ = this.sp;
        int result = this.readByte(sp_) + (this.readByte(sp_ + 1) << 8);
        this.sp = sp_ + 2 & 0xFFFF;
        return result;
    }

    private void operationADD(int data) {
        int a_ = this.a;
        int value = a_ + data & 0xFF;
        this.f = (value == 0 ? 128 : 0) + ((a_ & 0xF) + (data & 0xF) >= 16 ? 32 : 0) + (value < a_ ? 16 : 0);
        this.a = value;
    }

    private void operationADD16(int data) {
        int value = this.hl + data;
        this.f &= 0x80;
        this.f |= value >= 65536 ? 16 : 0;
        this.f |= (this.hl & 0xFFF) + (data & 0xFFF) >= 4096 ? 32 : 0;
        this.hl = value & 0xFFFF;
    }

    private void operationADC(int data) {
        int a_ = this.a;
        int value = a_ + data + ((this.f & 0x10) != 0 ? 1 : 0);
        this.f = ((value & 0xFF) == 0 ? 128 : 0) + ((a_ & 0xF) + (data & 0xF) >= 16 ? 32 : 0) + (value >= 256 ? 16 : 0);
        this.a = value & 0xFF;
    }

    private void operationSUB(int data) {
        int a_ = this.a;
        int value = a_ - data & 0xFF;
        this.f = (value == 0 ? 128 : 0) + 64 + ((a_ & 0xF) < (data & 0xF) ? 32 : 0) + (value > a_ ? 16 : 0);
        this.a = value;
    }

    private void operationSBC(int data) {
        int a_ = this.a;
        int value = a_ - data - ((this.f & 0x10) != 0 ? 1 : 0);
        this.f = ((value & 0xFF) == 0 ? 128 : 0) + 64 + ((a_ & 0xF) < (data & 0xF) ? 32 : 0) + (value < 0 ? 16 : 0);
        this.a = value & 0xFF;
    }

    private void operationAND(int data) {
        this.a &= data;
        this.f = 32 + (this.a == 0 ? 128 : 0);
    }

    private void operationOR(int data) {
        this.a |= data;
        this.f = this.a == 0 ? 128 : 0;
    }

    private void operationXOR(int data) {
        this.a ^= data;
        this.f = this.a == 0 ? 128 : 0;
    }

    private void operationCP(int data) {
        this.f = (this.a == data ? 128 : 0) + 64 + ((this.a & 0xF) < (data & 0xF) ? 32 : 0) + (this.a < data ? 16 : 0);
    }

    private int operationINC(int data) {
        int value = data + 1 & 0xFF;
        this.f &= 0x10;
        this.f |= value == 0 ? 128 : 0;
        this.f |= (value & 0xF) == 0 ? 32 : 0;
        return value;
    }

    private int operationDEC(int data) {
        int value = data - 1 & 0xFF;
        this.f &= 0x10;
        this.f |= 0x40;
        this.f |= value == 0 ? 128 : 0;
        this.f |= (value & 0xF) == 15 ? 32 : 0;
        return value;
    }

    private int operationSWAP(int data) {
        int value = data >> 4 | (data & 0xF) << 4;
        this.f = value == 0 ? 128 : 0;
        return value;
    }

    private int operationSLA(int data) {
        int value = data << 1 & 0xFF;
        this.f = (value == 0 ? 128 : 0) + (data >= 128 ? 16 : 0);
        return value;
    }

    private int operationRLC(int data) {
        int value = (data << 1) + (data >> 7) & 0xFF;
        this.f = (value == 0 ? 128 : 0) + (data >= 128 ? 16 : 0);
        return value;
    }

    private int operationRL(int data) {
        int value = (data << 1) + ((this.f & 0x10) != 0 ? 1 : 0) & 0xFF;
        this.f = (value == 0 ? 128 : 0) + (data >= 128 ? 16 : 0);
        return value;
    }

    private int operationSRL(int data) {
        int value = data >> 1;
        this.f = (value == 0 ? 128 : 0) + ((data & 1) != 0 ? 16 : 0);
        return value;
    }

    private int operationSRA(int data) {
        int value = data >> 1 | data & 0x80;
        this.f = (value == 0 ? 128 : 0) + ((data & 1) != 0 ? 16 : 0);
        return value;
    }

    private int operationRRC(int data) {
        int value = (data >> 1) + ((data & 1) != 0 ? 128 : 0);
        this.f = (value == 0 ? 128 : 0) + ((data & 1) != 0 ? 16 : 0);
        return value;
    }

    private int operationRR(int data) {
        int value = (data >> 1) + ((this.f & 0x10) != 0 ? 128 : 0);
        this.f = (value == 0 ? 128 : 0) + ((data & 1) != 0 ? 16 : 0);
        return value;
    }

    private void operationBIT(int data, int bit) {
        this.f &= 0x10;
        this.f |= ((data & 1 << bit) == 0 ? 128 : 0) + 32;
    }

    private void operationCALL() {
        byte[] memory_ = this.memory;
        int pc_ = this.pc;
        int newPC = (memory_[pc_] & 0xFF) + ((memory_[pc_ + 1] & 0xFF) << 8);
        this.pc += 2;
        this.operationCALL(newPC);
    }

    private void operationCALL(int address) {
        this.pushWord(this.pc);
        this.pc = address;
    }

    private void operationHALT() {
        this.setInterruptEnabled(true);
        while ((this.irqsRequested & this.irqsEnabled) == 0) {
            this.cycles = this.nextEvent;
            this.checkEvents();
        }
        this.cycles += 16L;
    }

    private String getAssembly(int opcode) {
        if (opcode != 203) {
            String assembly = ASSEMBLY[opcode];
            int index = -1;
            index = assembly.indexOf("a8");
            if (index > 0) {
                int a8 = this.memory[this.pc] & 0xFF;
                return assembly.substring(0, index) + "$" + Integer.toHexString(a8) + assembly.substring(index + 2);
            }
            index = assembly.indexOf("a16");
            if (index > 0) {
                int a16 = (this.memory[this.pc] & 0xFF) + (this.memory[this.pc + 1] & 0xFF) * 256;
                return assembly.substring(0, index) + "$" + Integer.toHexString(a16) + assembly.substring(index + 2);
            }
            index = assembly.indexOf("r8");
            if (index > 0) {
                int r8 = this.memory[this.pc] & 0xFF;
                return assembly.substring(0, index) + "$" + Integer.toHexString(r8) + assembly.substring(index + 2);
            }
            index = assembly.indexOf("d8");
            if (index > 0) {
                int d8 = this.memory[this.pc] & 0xFF;
                return assembly.substring(0, index) + "$" + Integer.toHexString(d8) + assembly.substring(index + 2);
            }
            index = assembly.indexOf("d16");
            if (index > 0) {
                int d16 = (this.memory[this.pc] & 0xFF) + (this.memory[this.pc + 1] & 0xFF) * 256;
                return assembly.substring(0, index) + "$" + Integer.toHexString(d16) + assembly.substring(index + 2);
            }
            return assembly;
        }
        int cbOpcode = this.memory[this.pc] & 0xFF;
        String cbAssembly = ASSEMBLY_CB[cbOpcode >> 3];
        String cbRegister = REGISTERS[cbOpcode & 7];
        return ASSEMBLY[opcode] + ' ' + cbAssembly + cbRegister;
    }

    public final void run() {
        super.run();
        this.initialize();
        byte[] memory_ = this.memory;
        while (this.isRunning) {
            while (!this.isPaused) {
                int opCode = memory_[this.pc++] & 0xFF;
                switch (opCode) {
                    case 6: {
                        this.b = memory_[this.pc++] & 0xFF;
                        this.cycles += 8L;
                        break;
                    }
                    case 14: {
                        this.c = memory_[this.pc++] & 0xFF;
                        this.cycles += 8L;
                        break;
                    }
                    case 22: {
                        this.d = memory_[this.pc++] & 0xFF;
                        this.cycles += 8L;
                        break;
                    }
                    case 30: {
                        this.e = memory_[this.pc++] & 0xFF;
                        this.cycles += 8L;
                        break;
                    }
                    case 38: {
                        this.setH(memory_[this.pc++] & 0xFF);
                        this.cycles += 8L;
                        break;
                    }
                    case 46: {
                        this.setL(memory_[this.pc++] & 0xFF);
                        this.cycles += 8L;
                        break;
                    }
                    case 54: {
                        this.writeByte(this.hl, memory_[this.pc++]);
                        this.cycles += 12L;
                        break;
                    }
                    case 62: {
                        this.a = memory_[this.pc++] & 0xFF;
                        this.cycles += 8L;
                        break;
                    }
                    case 64: {
                        this.cycles += 4L;
                        break;
                    }
                    case 65: {
                        this.b = this.c;
                        this.cycles += 4L;
                        break;
                    }
                    case 66: {
                        this.b = this.d;
                        this.cycles += 4L;
                        break;
                    }
                    case 67: {
                        this.b = this.e;
                        this.cycles += 4L;
                        break;
                    }
                    case 68: {
                        this.b = this.hl >> 8;
                        this.cycles += 4L;
                        break;
                    }
                    case 69: {
                        this.b = this.hl & 0xFF;
                        this.cycles += 4L;
                        break;
                    }
                    case 70: {
                        this.b = this.readByte(this.hl);
                        this.cycles += 8L;
                        break;
                    }
                    case 71: {
                        this.b = this.a;
                        this.cycles += 4L;
                        break;
                    }
                    case 72: {
                        this.c = this.b;
                        this.cycles += 4L;
                        break;
                    }
                    case 73: {
                        this.cycles += 4L;
                        break;
                    }
                    case 74: {
                        this.c = this.d;
                        this.cycles += 4L;
                        break;
                    }
                    case 75: {
                        this.c = this.e;
                        this.cycles += 4L;
                        break;
                    }
                    case 76: {
                        this.c = this.hl >> 8;
                        this.cycles += 4L;
                        break;
                    }
                    case 77: {
                        this.c = this.hl & 0xFF;
                        this.cycles += 4L;
                        break;
                    }
                    case 78: {
                        this.c = this.readByte(this.hl);
                        this.cycles += 8L;
                        break;
                    }
                    case 79: {
                        this.c = this.a;
                        this.cycles += 4L;
                        break;
                    }
                    case 80: {
                        this.d = this.b;
                        this.cycles += 4L;
                        break;
                    }
                    case 81: {
                        this.d = this.c;
                        this.cycles += 4L;
                        break;
                    }
                    case 82: {
                        this.cycles += 4L;
                        break;
                    }
                    case 83: {
                        this.d = this.e;
                        this.cycles += 4L;
                        break;
                    }
                    case 84: {
                        this.d = this.hl >> 8;
                        this.cycles += 4L;
                        break;
                    }
                    case 85: {
                        this.d = this.hl & 0xFF;
                        this.cycles += 4L;
                        break;
                    }
                    case 86: {
                        this.d = this.readByte(this.hl);
                        this.cycles += 8L;
                        break;
                    }
                    case 87: {
                        this.d = this.a;
                        this.cycles += 4L;
                        break;
                    }
                    case 88: {
                        this.e = this.b;
                        this.cycles += 4L;
                        break;
                    }
                    case 89: {
                        this.e = this.c;
                        this.cycles += 4L;
                        break;
                    }
                    case 90: {
                        this.e = this.d;
                        this.cycles += 4L;
                        break;
                    }
                    case 91: {
                        this.cycles += 4L;
                        break;
                    }
                    case 92: {
                        this.e = this.hl >> 8;
                        this.cycles += 4L;
                        break;
                    }
                    case 93: {
                        this.e = this.hl & 0xFF;
                        this.cycles += 4L;
                        break;
                    }
                    case 94: {
                        this.e = this.readByte(this.hl);
                        this.cycles += 8L;
                        break;
                    }
                    case 95: {
                        this.e = this.a;
                        this.cycles += 4L;
                        break;
                    }
                    case 96: {
                        this.setH(this.b);
                        this.cycles += 4L;
                        break;
                    }
                    case 97: {
                        this.setH(this.c);
                        this.cycles += 4L;
                        break;
                    }
                    case 98: {
                        this.setH(this.d);
                        this.cycles += 4L;
                        break;
                    }
                    case 99: {
                        this.setH(this.e);
                        this.cycles += 4L;
                        break;
                    }
                    case 100: {
                        this.cycles += 4L;
                        break;
                    }
                    case 101: {
                        this.setH(this.hl & 0xFF);
                        this.cycles += 4L;
                        break;
                    }
                    case 102: {
                        this.setH(this.readByte(this.hl));
                        this.cycles += 8L;
                        break;
                    }
                    case 103: {
                        this.setH(this.a);
                        this.cycles += 4L;
                        break;
                    }
                    case 104: {
                        this.setL(this.b);
                        this.cycles += 4L;
                        break;
                    }
                    case 105: {
                        this.setL(this.c);
                        this.cycles += 4L;
                        break;
                    }
                    case 106: {
                        this.setL(this.d);
                        this.cycles += 4L;
                        break;
                    }
                    case 107: {
                        this.setL(this.e);
                        this.cycles += 4L;
                        break;
                    }
                    case 108: {
                        this.setL(this.hl >> 8);
                        this.cycles += 4L;
                        break;
                    }
                    case 109: {
                        this.cycles += 4L;
                        break;
                    }
                    case 110: {
                        this.setL(this.readByte(this.hl));
                        this.cycles += 8L;
                        break;
                    }
                    case 111: {
                        this.setL(this.a);
                        this.cycles += 4L;
                        break;
                    }
                    case 112: {
                        this.writeByte(this.hl, (byte)this.b);
                        this.cycles += 8L;
                        break;
                    }
                    case 113: {
                        this.writeByte(this.hl, (byte)this.c);
                        this.cycles += 8L;
                        break;
                    }
                    case 114: {
                        this.writeByte(this.hl, (byte)this.d);
                        this.cycles += 8L;
                        break;
                    }
                    case 115: {
                        this.writeByte(this.hl, (byte)this.e);
                        this.cycles += 8L;
                        break;
                    }
                    case 116: {
                        this.writeByte(this.hl, (byte)(this.hl >> 8));
                        this.cycles += 8L;
                        break;
                    }
                    case 117: {
                        this.writeByte(this.hl, (byte)(this.hl & 0xFF));
                        this.cycles += 8L;
                        break;
                    }
                    case 119: {
                        this.writeByte(this.hl, (byte)this.a);
                        this.cycles += 8L;
                        break;
                    }
                    case 120: {
                        this.a = this.b;
                        this.cycles += 4L;
                        break;
                    }
                    case 121: {
                        this.a = this.c;
                        this.cycles += 4L;
                        break;
                    }
                    case 122: {
                        this.a = this.d;
                        this.cycles += 4L;
                        break;
                    }
                    case 123: {
                        this.a = this.e;
                        this.cycles += 4L;
                        break;
                    }
                    case 124: {
                        this.a = this.hl >> 8;
                        this.cycles += 4L;
                        break;
                    }
                    case 125: {
                        this.a = this.hl & 0xFF;
                        this.cycles += 4L;
                        break;
                    }
                    case 126: {
                        this.a = this.readByte(this.hl);
                        this.cycles += 8L;
                        break;
                    }
                    case 127: {
                        this.cycles += 4L;
                        break;
                    }
                    case 10: {
                        this.a = this.readByte((this.b << 8) + this.c);
                        this.cycles += 8L;
                        break;
                    }
                    case 26: {
                        this.a = this.readByte((this.d << 8) + this.e);
                        this.cycles += 8L;
                        break;
                    }
                    case 250: {
                        int pc_ = this.pc;
                        this.a = this.readByte((memory_[pc_] & 0xFF) + ((memory_[pc_ + 1] & 0xFF) << 8));
                        this.pc += 2;
                        this.cycles += 16L;
                        break;
                    }
                    case 2: {
                        this.writeByte((this.b << 8) + this.c, (byte)this.a);
                        this.cycles += 8L;
                        break;
                    }
                    case 18: {
                        this.writeByte((this.d << 8) + this.e, (byte)this.a);
                        this.cycles += 8L;
                        break;
                    }
                    case 234: {
                        int pc_ = this.pc;
                        this.writeByte((memory_[pc_] & 0xFF) + ((memory_[pc_ + 1] & 0xFF) << 8), (byte)this.a);
                        this.pc += 2;
                        this.cycles += 16L;
                        break;
                    }
                    case 242: {
                        this.a = this.readIO(65280 + this.c);
                        this.cycles += 8L;
                        break;
                    }
                    case 226: {
                        this.writeIO(65280 + this.c, (byte)this.a);
                        this.cycles += 8L;
                        break;
                    }
                    case 224: {
                        this.writeIO(65280 + (memory_[this.pc++] & 0xFF), (byte)this.a);
                        this.cycles += 12L;
                        break;
                    }
                    case 240: {
                        this.a = this.readIO(65280 + (memory_[this.pc++] & 0xFF));
                        this.cycles += 12L;
                        break;
                    }
                    case 58: {
                        this.a = this.readByte(this.hl--);
                        this.hl &= 0xFFFF;
                        this.cycles += 8L;
                        break;
                    }
                    case 50: {
                        this.writeByte(this.hl--, (byte)this.a);
                        this.hl &= 0xFFFF;
                        this.cycles += 8L;
                        break;
                    }
                    case 42: {
                        this.a = this.readByte(this.hl++);
                        this.hl &= 0xFFFF;
                        this.cycles += 8L;
                        break;
                    }
                    case 34: {
                        this.writeByte(this.hl++, (byte)this.a);
                        this.hl &= 0xFFFF;
                        this.cycles += 8L;
                        break;
                    }
                    case 1: {
                        this.c = memory_[this.pc++] & 0xFF;
                        this.b = memory_[this.pc++] & 0xFF;
                        this.cycles += 12L;
                        break;
                    }
                    case 17: {
                        this.e = memory_[this.pc++] & 0xFF;
                        this.d = memory_[this.pc++] & 0xFF;
                        this.cycles += 12L;
                        break;
                    }
                    case 33: {
                        int pc_ = this.pc;
                        this.hl = (memory_[pc_] & 0xFF) + ((memory_[pc_ + 1] & 0xFF) << 8);
                        this.pc += 2;
                        this.cycles += 12L;
                        break;
                    }
                    case 49: {
                        int pc_ = this.pc;
                        this.sp = (memory_[pc_] & 0xFF) + ((memory_[pc_ + 1] & 0xFF) << 8);
                        this.pc += 2;
                        this.cycles += 12L;
                        break;
                    }
                    case 249: {
                        this.sp = this.hl;
                        this.cycles += 8L;
                        break;
                    }
                    case 248: {
                        int value = this.sp + memory_[this.pc++];
                        this.hl = value & 0xFFFF;
                        this.f = value >= 65536 ? 16 : 0;
                        this.cycles += 12L;
                        break;
                    }
                    case 8: {
                        int pc_ = this.pc;
                        this.writeWord((memory_[pc_] & 0xFF) + ((memory_[pc_ + 1] & 0xFF) << 8), this.sp);
                        this.pc += 2;
                        this.cycles += 20L;
                        break;
                    }
                    case 197: {
                        this.pushByte(this.b);
                        this.pushByte(this.c);
                        this.cycles += 16L;
                        break;
                    }
                    case 213: {
                        this.pushByte(this.d);
                        this.pushByte(this.e);
                        this.cycles += 16L;
                        break;
                    }
                    case 229: {
                        this.pushWord(this.hl);
                        this.cycles += 16L;
                        break;
                    }
                    case 245: {
                        this.pushByte(this.a);
                        this.pushByte(this.f);
                        this.cycles += 16L;
                        break;
                    }
                    case 193: {
                        this.c = this.popByte();
                        this.b = this.popByte();
                        this.cycles += 12L;
                        break;
                    }
                    case 209: {
                        this.e = this.popByte();
                        this.d = this.popByte();
                        this.cycles += 12L;
                        break;
                    }
                    case 225: {
                        this.hl = this.popWord();
                        this.cycles += 12L;
                        break;
                    }
                    case 241: {
                        this.f = this.popByte() & 0xF0;
                        this.a = this.popByte();
                        this.cycles += 12L;
                        break;
                    }
                    case 128: {
                        this.operationADD(this.b);
                        this.cycles += 4L;
                        break;
                    }
                    case 129: {
                        this.operationADD(this.c);
                        this.cycles += 4L;
                        break;
                    }
                    case 130: {
                        this.operationADD(this.d);
                        this.cycles += 4L;
                        break;
                    }
                    case 131: {
                        this.operationADD(this.e);
                        this.cycles += 4L;
                        break;
                    }
                    case 132: {
                        this.operationADD(this.hl >> 8);
                        this.cycles += 4L;
                        break;
                    }
                    case 133: {
                        this.operationADD(this.hl & 0xFF);
                        this.cycles += 4L;
                        break;
                    }
                    case 134: {
                        this.operationADD(this.readByte(this.hl));
                        this.cycles += 8L;
                        break;
                    }
                    case 135: {
                        this.operationADD(this.a);
                        this.cycles += 4L;
                        break;
                    }
                    case 198: {
                        this.operationADD(memory_[this.pc++] & 0xFF);
                        this.cycles += 8L;
                        break;
                    }
                    case 136: {
                        this.operationADC(this.b);
                        this.cycles += 4L;
                        break;
                    }
                    case 137: {
                        this.operationADC(this.c);
                        this.cycles += 4L;
                        break;
                    }
                    case 138: {
                        this.operationADC(this.d);
                        this.cycles += 4L;
                        break;
                    }
                    case 139: {
                        this.operationADC(this.e);
                        this.cycles += 4L;
                        break;
                    }
                    case 140: {
                        this.operationADC(this.hl >> 8);
                        this.cycles += 4L;
                        break;
                    }
                    case 141: {
                        this.operationADC(this.hl & 0xFF);
                        this.cycles += 4L;
                        break;
                    }
                    case 142: {
                        this.operationADC(this.readByte(this.hl));
                        this.cycles += 8L;
                        break;
                    }
                    case 143: {
                        this.operationADC(this.a);
                        this.cycles += 4L;
                        break;
                    }
                    case 206: {
                        this.operationADC(memory_[this.pc++] & 0xFF);
                        this.cycles += 8L;
                        break;
                    }
                    case 144: {
                        this.operationSUB(this.b);
                        this.cycles += 4L;
                        break;
                    }
                    case 145: {
                        this.operationSUB(this.c);
                        this.cycles += 4L;
                        break;
                    }
                    case 146: {
                        this.operationSUB(this.d);
                        this.cycles += 4L;
                        break;
                    }
                    case 147: {
                        this.operationSUB(this.e);
                        this.cycles += 4L;
                        break;
                    }
                    case 148: {
                        this.operationSUB(this.hl >> 8);
                        this.cycles += 4L;
                        break;
                    }
                    case 149: {
                        this.operationSUB(this.hl & 0xFF);
                        this.cycles += 4L;
                        break;
                    }
                    case 150: {
                        this.operationSUB(this.readByte(this.hl));
                        this.cycles += 8L;
                        break;
                    }
                    case 151: {
                        this.operationSUB(this.a);
                        this.cycles += 4L;
                        break;
                    }
                    case 214: {
                        this.operationSUB(memory_[this.pc++] & 0xFF);
                        this.cycles += 8L;
                        break;
                    }
                    case 152: {
                        this.operationSBC(this.b);
                        this.cycles += 4L;
                        break;
                    }
                    case 153: {
                        this.operationSBC(this.c);
                        this.cycles += 4L;
                        break;
                    }
                    case 154: {
                        this.operationSBC(this.d);
                        this.cycles += 4L;
                        break;
                    }
                    case 155: {
                        this.operationSBC(this.e);
                        this.cycles += 4L;
                        break;
                    }
                    case 156: {
                        this.operationSBC(this.hl >> 8);
                        this.cycles += 4L;
                        break;
                    }
                    case 157: {
                        this.operationSBC(this.hl & 0xFF);
                        this.cycles += 4L;
                        break;
                    }
                    case 158: {
                        this.operationSBC(this.readByte(this.hl));
                        this.cycles += 8L;
                        break;
                    }
                    case 159: {
                        this.operationSBC(this.a);
                        this.cycles += 4L;
                        break;
                    }
                    case 222: {
                        this.operationSBC(memory_[this.pc++] & 0xFF);
                        this.cycles += 8L;
                        break;
                    }
                    case 160: {
                        this.operationAND(this.b);
                        this.cycles += 4L;
                        break;
                    }
                    case 161: {
                        this.operationAND(this.c);
                        this.cycles += 4L;
                        break;
                    }
                    case 162: {
                        this.operationAND(this.d);
                        this.cycles += 4L;
                        break;
                    }
                    case 163: {
                        this.operationAND(this.e);
                        this.cycles += 4L;
                        break;
                    }
                    case 164: {
                        this.operationAND(this.hl >> 8);
                        this.cycles += 4L;
                        break;
                    }
                    case 165: {
                        this.operationAND(this.hl & 0xFF);
                        this.cycles += 4L;
                        break;
                    }
                    case 166: {
                        this.operationAND(this.readByte(this.hl));
                        this.cycles += 8L;
                        break;
                    }
                    case 167: {
                        this.operationAND(this.a);
                        this.cycles += 4L;
                        break;
                    }
                    case 230: {
                        this.operationAND(memory_[this.pc++] & 0xFF);
                        this.cycles += 8L;
                        break;
                    }
                    case 168: {
                        this.operationXOR(this.b);
                        this.cycles += 4L;
                        break;
                    }
                    case 169: {
                        this.operationXOR(this.c);
                        this.cycles += 4L;
                        break;
                    }
                    case 170: {
                        this.operationXOR(this.d);
                        this.cycles += 4L;
                        break;
                    }
                    case 171: {
                        this.operationXOR(this.e);
                        this.cycles += 4L;
                        break;
                    }
                    case 172: {
                        this.operationXOR(this.hl >> 8);
                        this.cycles += 4L;
                        break;
                    }
                    case 173: {
                        this.operationXOR(this.hl & 0xFF);
                        this.cycles += 4L;
                        break;
                    }
                    case 174: {
                        this.operationXOR(this.readByte(this.hl));
                        this.cycles += 8L;
                        break;
                    }
                    case 175: {
                        this.operationXOR(this.a);
                        this.cycles += 4L;
                        break;
                    }
                    case 238: {
                        this.operationXOR(memory_[this.pc++] & 0xFF);
                        this.cycles += 8L;
                        break;
                    }
                    case 176: {
                        this.operationOR(this.b);
                        this.cycles += 4L;
                        break;
                    }
                    case 177: {
                        this.operationOR(this.c);
                        this.cycles += 4L;
                        break;
                    }
                    case 178: {
                        this.operationOR(this.d);
                        this.cycles += 4L;
                        break;
                    }
                    case 179: {
                        this.operationOR(this.e);
                        this.cycles += 4L;
                        break;
                    }
                    case 180: {
                        this.operationOR(this.hl >> 8);
                        this.cycles += 4L;
                        break;
                    }
                    case 181: {
                        this.operationOR(this.hl & 0xFF);
                        this.cycles += 4L;
                        break;
                    }
                    case 182: {
                        this.operationOR(this.readByte(this.hl));
                        this.cycles += 8L;
                        break;
                    }
                    case 183: {
                        this.operationOR(this.a);
                        this.cycles += 4L;
                        break;
                    }
                    case 246: {
                        this.operationOR(memory_[this.pc++] & 0xFF);
                        this.cycles += 8L;
                        break;
                    }
                    case 184: {
                        this.operationCP(this.b);
                        this.cycles += 4L;
                        break;
                    }
                    case 185: {
                        this.operationCP(this.c);
                        this.cycles += 4L;
                        break;
                    }
                    case 186: {
                        this.operationCP(this.d);
                        this.cycles += 4L;
                        break;
                    }
                    case 187: {
                        this.operationCP(this.e);
                        this.cycles += 4L;
                        break;
                    }
                    case 188: {
                        this.operationCP(this.hl >> 8);
                        this.cycles += 4L;
                        break;
                    }
                    case 189: {
                        this.operationCP(this.hl & 0xFF);
                        this.cycles += 4L;
                        break;
                    }
                    case 190: {
                        this.operationCP(this.readByte(this.hl));
                        this.cycles += 8L;
                        break;
                    }
                    case 191: {
                        this.operationCP(this.a);
                        this.cycles += 4L;
                        break;
                    }
                    case 254: {
                        this.operationCP(memory_[this.pc++] & 0xFF);
                        this.cycles += 8L;
                        break;
                    }
                    case 4: {
                        this.b = this.operationINC(this.b);
                        this.cycles += 4L;
                        break;
                    }
                    case 12: {
                        this.c = this.operationINC(this.c);
                        this.cycles += 4L;
                        break;
                    }
                    case 20: {
                        this.d = this.operationINC(this.d);
                        this.cycles += 4L;
                        break;
                    }
                    case 28: {
                        this.e = this.operationINC(this.e);
                        this.cycles += 4L;
                        break;
                    }
                    case 36: {
                        this.setH(this.operationINC(this.hl >> 8));
                        this.cycles += 4L;
                        break;
                    }
                    case 44: {
                        this.setL(this.operationINC(this.hl & 0xFF));
                        this.cycles += 4L;
                        break;
                    }
                    case 52: {
                        this.writeByte(this.hl, (byte)this.operationINC(this.readByte(this.hl)));
                        this.cycles += 12L;
                        break;
                    }
                    case 60: {
                        this.a = this.operationINC(this.a);
                        this.cycles += 4L;
                        break;
                    }
                    case 5: {
                        this.b = this.operationDEC(this.b);
                        this.cycles += 4L;
                        break;
                    }
                    case 13: {
                        this.c = this.operationDEC(this.c);
                        this.cycles += 4L;
                        break;
                    }
                    case 21: {
                        this.d = this.operationDEC(this.d);
                        this.cycles += 4L;
                        break;
                    }
                    case 29: {
                        this.e = this.operationDEC(this.e);
                        this.cycles += 4L;
                        break;
                    }
                    case 37: {
                        this.setH(this.operationDEC(this.hl >> 8));
                        this.cycles += 4L;
                        break;
                    }
                    case 45: {
                        this.setL(this.operationDEC(this.hl & 0xFF));
                        this.cycles += 4L;
                        break;
                    }
                    case 53: {
                        this.writeByte(this.hl, (byte)this.operationDEC(this.readByte(this.hl)));
                        this.cycles += 12L;
                        break;
                    }
                    case 61: {
                        this.a = this.operationDEC(this.a);
                        this.cycles += 4L;
                        break;
                    }
                    case 9: {
                        this.operationADD16((this.b << 8) + this.c);
                        this.cycles += 8L;
                        break;
                    }
                    case 25: {
                        this.operationADD16((this.d << 8) + this.e);
                        this.cycles += 8L;
                        break;
                    }
                    case 41: {
                        this.operationADD16(this.hl);
                        this.cycles += 8L;
                        break;
                    }
                    case 57: {
                        this.operationADD16((this.a << 8) + this.f);
                        this.cycles += 8L;
                        break;
                    }
                    case 232: {
                        int value = this.sp + memory_[this.pc++];
                        this.f = value >= 65536 ? 16 : 0;
                        this.sp = value & 0xFFFF;
                        this.cycles += 16L;
                        break;
                    }
                    case 3: {
                        int value = (this.b << 8) + this.c + 1 & 0xFFFF;
                        this.b = value >> 8;
                        this.c = value & 0xFF;
                        this.cycles += 8L;
                        break;
                    }
                    case 19: {
                        int value = (this.d << 8) + this.e + 1 & 0xFFFF;
                        this.d = value >> 8;
                        this.e = value & 0xFF;
                        this.cycles += 8L;
                        break;
                    }
                    case 35: {
                        this.hl = this.hl + 1 & 0xFFFF;
                        this.cycles += 8L;
                        break;
                    }
                    case 51: {
                        this.sp = this.sp + 1 & 0xFFFF;
                        this.cycles += 8L;
                        break;
                    }
                    case 11: {
                        int value = (this.b << 8) + this.c - 1 & 0xFFFF;
                        this.b = value >> 8;
                        this.c = value & 0xFF;
                        this.cycles += 8L;
                        break;
                    }
                    case 27: {
                        int value = (this.d << 8) + this.e - 1 & 0xFFFF;
                        this.d = value >> 8;
                        this.e = value & 0xFF;
                        this.cycles += 8L;
                        break;
                    }
                    case 43: {
                        this.hl = this.hl - 1 & 0xFFFF;
                        this.cycles += 8L;
                        break;
                    }
                    case 59: {
                        this.sp = this.sp - 1 & 0xFFFF;
                        this.cycles += 8L;
                        break;
                    }
                    case 203: {
                        this.executeTwoByteOperation(memory_[this.pc++] & 0xFF);
                        break;
                    }
                    case 39: {
                        int upper = this.a & 0xF0;
                        int lower = this.a & 0xF;
                        int flags = ((this.f & 0x20) != 0 ? 4 : 0) + ((this.f & 0x40) != 0 ? 2 : 0) + ((this.f & 0x10) != 0 ? 1 : 0);
                        int table = (upper > 9 ? 2 : 0) + (lower > 9 ? 1 : 0);
                        int value = this.a + DAA_ADJUST[table][flags];
                        this.a = value & 0xFF;
                        this.f &= 0x40;
                        this.f |= (this.a == 0 ? 128 : 0) + (value >= 256 ? 16 : 0);
                        this.cycles += 4L;
                        break;
                    }
                    case 47: {
                        this.a = ~this.a & 0xFF;
                        this.f |= 0x60;
                        this.cycles += 4L;
                        break;
                    }
                    case 63: {
                        this.f ^= 0x10;
                        this.f &= 0x90;
                        this.cycles += 4L;
                        break;
                    }
                    case 55: {
                        this.f |= 0x10;
                        this.f &= 0x90;
                        this.cycles += 4L;
                        break;
                    }
                    case 0: {
                        this.cycles += 4L;
                        break;
                    }
                    case 118: {
                        this.operationHALT();
                        this.cycles += 4L;
                        break;
                    }
                    case 16: {
                        if ((this.readByte(65357) & 1) != 0) {
                            this.cpuSpeed = this.cpuSpeed == 0x400000 ? 8388000 : 0x400000;
                            this.writeByte(65357, (byte)(this.readByte(65357) & 0xFE));
                            this.setChanged(true);
                            this.notifyObservers(new Long(this.cpuSpeed));
                            this.gameboy.getPerformanceMeter().setTargetSpeed(this.cpuSpeed);
                            this.gameboy.getPerformanceMeter().setupNextMeasurement(this.cycles);
                            this.gameboy.getLogger().info("Set Gameboy CPU speed to " + this.cpuSpeed + " Hz");
                        } else {
                            this.operationHALT();
                        }
                        ++this.pc;
                        this.cycles += 4L;
                        break;
                    }
                    case 243: {
                        this.setInterruptEnabled(false);
                        this.cycles += 4L;
                        break;
                    }
                    case 251: {
                        if (!this.isInterruptEnabled) {
                            this.doesInterruptEnableSwitch = true;
                        }
                        this.cycles += 4L;
                        break;
                    }
                    case 7: {
                        this.a = this.operationRLC(this.a);
                        this.cycles += 4L;
                        break;
                    }
                    case 23: {
                        this.a = this.operationRL(this.a);
                        this.cycles += 4L;
                        break;
                    }
                    case 15: {
                        this.a = this.operationRRC(this.a);
                        this.cycles += 4L;
                        break;
                    }
                    case 31: {
                        this.a = this.operationRR(this.a);
                        this.cycles += 4L;
                        break;
                    }
                    case 195: {
                        int pc_ = this.pc;
                        this.pc = (memory_[pc_] & 0xFF) + ((memory_[pc_ + 1] & 0xFF) << 8);
                        this.cycles += 16L;
                        break;
                    }
                    case 233: {
                        this.pc = this.hl;
                        this.cycles += 4L;
                        break;
                    }
                    case 24: {
                        this.pc += memory_[this.pc++] + 1;
                        this.cycles += 12L;
                        break;
                    }
                    case 194: {
                        int pc_;
                        if ((this.f & 0x80) == 0) {
                            pc_ = this.pc;
                            this.pc = (memory_[pc_] & 0xFF) + ((memory_[pc_ + 1] & 0xFF) << 8);
                            this.cycles += 16L;
                            break;
                        }
                        this.pc += 2;
                        this.cycles += 12L;
                        break;
                    }
                    case 202: {
                        int pc_;
                        if ((this.f & 0x80) != 0) {
                            pc_ = this.pc;
                            this.pc = (memory_[pc_] & 0xFF) + ((memory_[pc_ + 1] & 0xFF) << 8);
                            this.cycles += 16L;
                            break;
                        }
                        this.pc += 2;
                        this.cycles += 12L;
                        break;
                    }
                    case 210: {
                        int pc_;
                        if ((this.f & 0x10) == 0) {
                            pc_ = this.pc;
                            this.pc = (memory_[pc_] & 0xFF) + ((memory_[pc_ + 1] & 0xFF) << 8);
                            this.cycles += 16L;
                            break;
                        }
                        this.pc += 2;
                        this.cycles += 12L;
                        break;
                    }
                    case 218: {
                        int pc_;
                        if ((this.f & 0x10) != 0) {
                            pc_ = this.pc;
                            this.pc = (memory_[pc_] & 0xFF) + ((memory_[pc_ + 1] & 0xFF) << 8);
                            this.cycles += 16L;
                            break;
                        }
                        this.pc += 2;
                        this.cycles += 12L;
                        break;
                    }
                    case 32: {
                        if ((this.f & 0x80) == 0) {
                            this.pc += (byte)(memory_[this.pc] & 0xFF) + 1;
                            this.cycles += 12L;
                            break;
                        }
                        ++this.pc;
                        this.cycles += 8L;
                        break;
                    }
                    case 40: {
                        if ((this.f & 0x80) != 0) {
                            this.pc += (byte)(memory_[this.pc] & 0xFF) + 1;
                            this.cycles += 12L;
                            break;
                        }
                        ++this.pc;
                        this.cycles += 8L;
                        break;
                    }
                    case 48: {
                        if ((this.f & 0x10) == 0) {
                            this.pc += (byte)(memory_[this.pc] & 0xFF) + 1;
                            this.cycles += 12L;
                            break;
                        }
                        ++this.pc;
                        this.cycles += 8L;
                        break;
                    }
                    case 56: {
                        if ((this.f & 0x10) != 0) {
                            this.pc += (byte)(memory_[this.pc] & 0xFF) + 1;
                            this.cycles += 12L;
                            break;
                        }
                        ++this.pc;
                        this.cycles += 8L;
                        break;
                    }
                    case 205: {
                        this.operationCALL();
                        this.cycles += 24L;
                        break;
                    }
                    case 196: {
                        if ((this.f & 0x80) == 0) {
                            this.operationCALL();
                            this.cycles += 24L;
                            break;
                        }
                        this.pc += 2;
                        this.cycles += 12L;
                        break;
                    }
                    case 204: {
                        if ((this.f & 0x80) != 0) {
                            this.operationCALL();
                            this.cycles += 24L;
                            break;
                        }
                        this.pc += 2;
                        this.cycles += 12L;
                        break;
                    }
                    case 212: {
                        if ((this.f & 0x10) == 0) {
                            this.operationCALL();
                            this.cycles += 24L;
                            break;
                        }
                        this.pc += 2;
                        this.cycles += 12L;
                        break;
                    }
                    case 220: {
                        if ((this.f & 0x10) != 0) {
                            this.operationCALL();
                            this.cycles += 24L;
                            break;
                        }
                        this.pc += 2;
                        this.cycles += 12L;
                        break;
                    }
                    case 199: 
                    case 207: 
                    case 215: 
                    case 223: 
                    case 231: 
                    case 239: 
                    case 247: 
                    case 255: {
                        this.operationCALL(opCode - 199);
                        this.cycles += 16L;
                        break;
                    }
                    case 201: {
                        this.pc = this.popWord();
                        this.cycles += 16L;
                        break;
                    }
                    case 217: {
                        this.pc = this.popWord();
                        if (!this.isInterruptEnabled) {
                            this.doesInterruptEnableSwitch = true;
                        }
                        this.cycles += 16L;
                        break;
                    }
                    case 192: {
                        if ((this.f & 0x80) == 0) {
                            this.pc = this.popWord();
                            this.cycles += 20L;
                            break;
                        }
                        this.cycles += 8L;
                        break;
                    }
                    case 200: {
                        if ((this.f & 0x80) != 0) {
                            this.pc = this.popWord();
                            this.cycles += 20L;
                            break;
                        }
                        this.cycles += 8L;
                        break;
                    }
                    case 208: {
                        if ((this.f & 0x10) == 0) {
                            this.pc = this.popWord();
                            this.cycles += 20L;
                            break;
                        }
                        this.cycles += 8L;
                        break;
                    }
                    case 216: {
                        if ((this.f & 0x10) != 0) {
                            this.pc = this.popWord();
                            this.cycles += 20L;
                            break;
                        }
                        this.cycles += 8L;
                    }
                }
                if (this.cycles >= this.nextEvent) {
                    this.checkEvents();
                }
                if (this.isInterruptEnabled && this.irqsRequested != 0 && (this.irqsRequested & this.irqsEnabled) != 0) {
                    int irqVector = 64;
                    int mask = 1;
                    while (irqVector <= 96) {
                        if ((this.irqsRequested & this.irqsEnabled & mask) != 0) {
                            this.irqsRequested ^= mask;
                            this.setInterruptEnabled(false);
                            this.doesInterruptEnableSwitch = false;
                            this.operationCALL(irqVector);
                            break;
                        }
                        irqVector += 8;
                        mask <<= 1;
                    }
                }
                if (!this.doesInterruptEnableSwitch) continue;
                this.setInterruptEnabled(!this.isInterruptEnabled);
                this.doesInterruptEnableSwitch = false;
            }
            if (!this.isPaused) continue;
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException interruptedException) {}
        }
    }

    private void executeTwoByteOperation(int opCode) {
        block0 : switch (opCode & 0xC0) {
            case 0: {
                switch (opCode) {
                    case 0: {
                        this.b = this.operationRLC(this.b);
                        this.cycles += 8L;
                        break block0;
                    }
                    case 1: {
                        this.c = this.operationRLC(this.c);
                        this.cycles += 8L;
                        break block0;
                    }
                    case 2: {
                        this.d = this.operationRLC(this.d);
                        this.cycles += 8L;
                        break block0;
                    }
                    case 3: {
                        this.e = this.operationRLC(this.e);
                        this.cycles += 8L;
                        break block0;
                    }
                    case 4: {
                        this.setH(this.operationRLC(this.hl >> 8));
                        this.cycles += 8L;
                        break block0;
                    }
                    case 5: {
                        this.setL(this.operationRLC(this.hl & 0xFF));
                        this.cycles += 8L;
                        break block0;
                    }
                    case 6: {
                        this.writeByte(this.hl, (byte)this.operationRLC(this.readByte(this.hl)));
                        this.cycles += 16L;
                        break block0;
                    }
                    case 7: {
                        this.a = this.operationRLC(this.a);
                        this.cycles += 8L;
                        break block0;
                    }
                    case 8: {
                        this.b = this.operationRRC(this.b);
                        this.cycles += 8L;
                        break block0;
                    }
                    case 9: {
                        this.c = this.operationRRC(this.c);
                        this.cycles += 8L;
                        break block0;
                    }
                    case 10: {
                        this.d = this.operationRRC(this.d);
                        this.cycles += 8L;
                        break block0;
                    }
                    case 11: {
                        this.e = this.operationRRC(this.e);
                        this.cycles += 8L;
                        break block0;
                    }
                    case 12: {
                        this.setH(this.operationRRC(this.hl >> 8));
                        this.cycles += 8L;
                        break block0;
                    }
                    case 13: {
                        this.setL(this.operationRRC(this.hl & 0xFF));
                        this.cycles += 8L;
                        break block0;
                    }
                    case 14: {
                        this.writeByte(this.hl, (byte)this.operationRRC(this.readByte(this.hl)));
                        this.cycles += 16L;
                        break block0;
                    }
                    case 15: {
                        this.a = this.operationRRC(this.a);
                        this.cycles += 8L;
                        break block0;
                    }
                    case 16: {
                        this.b = this.operationRL(this.b);
                        this.cycles += 8L;
                        break block0;
                    }
                    case 17: {
                        this.c = this.operationRL(this.c);
                        this.cycles += 8L;
                        break block0;
                    }
                    case 18: {
                        this.d = this.operationRL(this.d);
                        this.cycles += 8L;
                        break block0;
                    }
                    case 19: {
                        this.e = this.operationRL(this.e);
                        this.cycles += 8L;
                        break block0;
                    }
                    case 20: {
                        this.setH(this.operationRL(this.hl >> 8));
                        this.cycles += 8L;
                        break block0;
                    }
                    case 21: {
                        this.setL(this.operationRL(this.hl & 0xFF));
                        this.cycles += 8L;
                        break block0;
                    }
                    case 22: {
                        this.writeByte(this.hl, (byte)this.operationRL(this.readByte(this.hl)));
                        this.cycles += 16L;
                        break block0;
                    }
                    case 23: {
                        this.a = this.operationRL(this.a);
                        this.cycles += 8L;
                        break block0;
                    }
                    case 24: {
                        this.b = this.operationRR(this.b);
                        this.cycles += 8L;
                        break block0;
                    }
                    case 25: {
                        this.c = this.operationRR(this.c);
                        this.cycles += 8L;
                        break block0;
                    }
                    case 26: {
                        this.d = this.operationRR(this.d);
                        this.cycles += 8L;
                        break block0;
                    }
                    case 27: {
                        this.e = this.operationRR(this.e);
                        this.cycles += 8L;
                        break block0;
                    }
                    case 28: {
                        this.setH(this.operationRR(this.hl >> 8));
                        this.cycles += 8L;
                        break block0;
                    }
                    case 29: {
                        this.setL(this.operationRR(this.hl & 0xFF));
                        this.cycles += 8L;
                        break block0;
                    }
                    case 30: {
                        this.writeByte(this.hl, (byte)this.operationRR(this.readByte(this.hl)));
                        this.cycles += 16L;
                        break block0;
                    }
                    case 31: {
                        this.a = this.operationRR(this.a);
                        this.cycles += 8L;
                        break block0;
                    }
                    case 32: {
                        this.b = this.operationSLA(this.b);
                        this.cycles += 8L;
                        break block0;
                    }
                    case 33: {
                        this.c = this.operationSLA(this.c);
                        this.cycles += 8L;
                        break block0;
                    }
                    case 34: {
                        this.d = this.operationSLA(this.d);
                        this.cycles += 8L;
                        break block0;
                    }
                    case 35: {
                        this.e = this.operationSLA(this.e);
                        this.cycles += 8L;
                        break block0;
                    }
                    case 36: {
                        this.setH(this.operationSLA(this.hl >> 8));
                        this.cycles += 8L;
                        break block0;
                    }
                    case 37: {
                        this.setL(this.operationSLA(this.hl & 0xFF));
                        this.cycles += 8L;
                        break block0;
                    }
                    case 38: {
                        this.writeByte(this.hl, (byte)this.operationSLA(this.readByte(this.hl)));
                        this.cycles += 16L;
                        break block0;
                    }
                    case 39: {
                        this.a = this.operationSLA(this.a);
                        this.cycles += 8L;
                        break block0;
                    }
                    case 40: {
                        this.b = this.operationSRA(this.b);
                        this.cycles += 8L;
                        break block0;
                    }
                    case 41: {
                        this.c = this.operationSRA(this.c);
                        this.cycles += 8L;
                        break block0;
                    }
                    case 42: {
                        this.d = this.operationSRA(this.d);
                        this.cycles += 8L;
                        break block0;
                    }
                    case 43: {
                        this.e = this.operationSRA(this.e);
                        this.cycles += 8L;
                        break block0;
                    }
                    case 44: {
                        this.setH(this.operationSRA(this.hl >> 8));
                        this.cycles += 8L;
                        break block0;
                    }
                    case 45: {
                        this.setL(this.operationSRA(this.hl & 0xFF));
                        this.cycles += 8L;
                        break block0;
                    }
                    case 46: {
                        this.writeByte(this.hl, (byte)this.operationSRA(this.readByte(this.hl)));
                        this.cycles += 16L;
                        break block0;
                    }
                    case 47: {
                        this.a = this.operationSRA(this.a);
                        this.cycles += 8L;
                        break block0;
                    }
                    case 48: {
                        this.b = this.operationSWAP(this.b);
                        this.cycles += 8L;
                        break block0;
                    }
                    case 49: {
                        this.c = this.operationSWAP(this.c);
                        this.cycles += 8L;
                        break block0;
                    }
                    case 50: {
                        this.d = this.operationSWAP(this.d);
                        this.cycles += 8L;
                        break block0;
                    }
                    case 51: {
                        this.e = this.operationSWAP(this.e);
                        this.cycles += 8L;
                        break block0;
                    }
                    case 52: {
                        this.setH(this.operationSWAP(this.hl >> 8));
                        this.cycles += 8L;
                        break block0;
                    }
                    case 53: {
                        this.setL(this.operationSWAP(this.hl & 0xFF));
                        this.cycles += 8L;
                        break block0;
                    }
                    case 54: {
                        this.writeByte(this.hl, (byte)this.operationSWAP(this.readByte(this.hl)));
                        this.cycles += 16L;
                        break block0;
                    }
                    case 55: {
                        this.a = this.operationSWAP(this.a);
                        this.cycles += 8L;
                        break block0;
                    }
                    case 56: {
                        this.b = this.operationSRL(this.b);
                        this.cycles += 8L;
                        break block0;
                    }
                    case 57: {
                        this.c = this.operationSRL(this.c);
                        this.cycles += 8L;
                        break block0;
                    }
                    case 58: {
                        this.d = this.operationSRL(this.d);
                        this.cycles += 8L;
                        break block0;
                    }
                    case 59: {
                        this.e = this.operationSRL(this.e);
                        this.cycles += 8L;
                        break block0;
                    }
                    case 60: {
                        this.setH(this.operationSRL(this.hl >> 8));
                        this.cycles += 8L;
                        break block0;
                    }
                    case 61: {
                        this.setL(this.operationSRL(this.hl & 0xFF));
                        this.cycles += 8L;
                        break block0;
                    }
                    case 62: {
                        this.writeByte(this.hl, (byte)this.operationSRL(this.readByte(this.hl)));
                        this.cycles += 16L;
                        break block0;
                    }
                    case 63: {
                        this.a = this.operationSRL(this.a);
                        this.cycles += 8L;
                        break block0;
                    }
                }
                break;
            }
            case 64: 
            case 128: 
            case 192: {
                int bit = (opCode & 0x38) >> 3;
                switch (opCode & 0xC7) {
                    case 64: {
                        this.operationBIT(this.b, bit);
                        this.cycles += 8L;
                        break block0;
                    }
                    case 65: {
                        this.operationBIT(this.c, bit);
                        this.cycles += 8L;
                        break block0;
                    }
                    case 66: {
                        this.operationBIT(this.d, bit);
                        this.cycles += 8L;
                        break block0;
                    }
                    case 67: {
                        this.operationBIT(this.e, bit);
                        this.cycles += 8L;
                        break block0;
                    }
                    case 68: {
                        this.operationBIT(this.hl >> 8, bit);
                        this.cycles += 8L;
                        break block0;
                    }
                    case 69: {
                        this.operationBIT(this.hl & 0xFF, bit);
                        this.cycles += 8L;
                        break block0;
                    }
                    case 70: {
                        this.operationBIT(this.readByte(this.hl), bit);
                        this.cycles += 16L;
                        break block0;
                    }
                    case 71: {
                        this.operationBIT(this.a, bit);
                        this.cycles += 8L;
                        break block0;
                    }
                    case 128: {
                        this.b |= 1 << bit;
                        this.b ^= 1 << bit;
                        this.cycles += 8L;
                        break block0;
                    }
                    case 129: {
                        this.c |= 1 << bit;
                        this.c ^= 1 << bit;
                        this.cycles += 8L;
                        break block0;
                    }
                    case 130: {
                        this.d |= 1 << bit;
                        this.d ^= 1 << bit;
                        this.cycles += 8L;
                        break block0;
                    }
                    case 131: {
                        this.e |= 1 << bit;
                        this.e ^= 1 << bit;
                        this.cycles += 8L;
                        break block0;
                    }
                    case 132: {
                        int bits = 1 << bit;
                        int value = this.hl >> 8 | bits;
                        this.setH(value ^ bits);
                        this.cycles += 8L;
                        break block0;
                    }
                    case 133: {
                        int bits = 1 << bit;
                        int value = this.hl & 0xFF | bits;
                        this.setL(value ^ bits);
                        this.cycles += 8L;
                        break block0;
                    }
                    case 134: {
                        int bits = 1 << bit;
                        int value = this.readByte(this.hl) | bits;
                        this.writeByte(this.hl, (byte)(value ^ bits));
                        this.cycles += 16L;
                        break block0;
                    }
                    case 135: {
                        this.a |= 1 << bit;
                        this.a ^= 1 << bit;
                        this.cycles += 8L;
                        break block0;
                    }
                    case 192: {
                        this.b |= 1 << bit;
                        this.cycles += 8L;
                        break block0;
                    }
                    case 193: {
                        this.c |= 1 << bit;
                        this.cycles += 8L;
                        break block0;
                    }
                    case 194: {
                        this.d |= 1 << bit;
                        this.cycles += 8L;
                        break block0;
                    }
                    case 195: {
                        this.e |= 1 << bit;
                        this.cycles += 8L;
                        break block0;
                    }
                    case 196: {
                        this.setH(this.hl >> 8 | 1 << bit);
                        this.cycles += 8L;
                        break block0;
                    }
                    case 197: {
                        this.setL(this.hl & 0xFF | 1 << bit);
                        this.cycles += 8L;
                        break block0;
                    }
                    case 198: {
                        this.writeByte(this.hl, (byte)(this.readByte(this.hl) | 1 << bit));
                        this.cycles += 16L;
                        break block0;
                    }
                    case 199: {
                        this.a |= 1 << bit;
                        this.cycles += 8L;
                    }
                }
            }
        }
    }

    private int readByte(int adr) {
        switch (adr & 0xE000) {
            case 32768: {
                return this.video.readByte(adr & 0x1FFF);
            }
            case 57344: {
                switch (adr & 0xFF00) {
                    case 65024: {
                        return this.memory[adr] & 0xFF;
                    }
                    case 65280: {
                        return this.readIO(adr);
                    }
                }
                return this.memory[adr - 8192] & 0xFF;
            }
        }
        return this.memory[adr] & 0xFF;
    }

    protected final int readIO(int adr) {
        switch (adr) {
            case 65284: {
                return this.timer.getDiv();
            }
            case 65285: {
                return this.timer.getTima();
            }
            case 65286: {
                return this.timer.getTma();
            }
            case 65287: {
                return this.timer.getTac();
            }
            case 65295: {
                return this.irqsRequested;
            }
            case 65318: {
                SoundChannel[] soundChannels = this.sound.getSoundChannels();
                return this.memory[adr] & 0xF0 | (soundChannels[0].isActive() ? 1 : 0) | (soundChannels[1].isActive() ? 2 : 0) | (soundChannels[2].isActive() ? 4 : 0) | (soundChannels[3].isActive() ? 8 : 0);
            }
            case 65345: {
                int result = this.memory[adr] & 0xFC;
                result |= this.video.getLCDLine() == this.readIO(65349) ? 4 : 0;
                return result |= this.video.getVideoMode();
            }
            case 65348: {
                return this.video.getLCDLine();
            }
            case 65384: {
                int index = this.memory[adr + 1] & 0x3F;
                return (byte)this.video.getColorByte(0 + index);
            }
            case 65386: {
                int index = this.memory[adr + 1] & 0x3F;
                return (byte)this.video.getColorByte(8 + index);
            }
            case 65357: {
                return this.memory[adr] & 0x7F | (this.cpuSpeed == 8388000 ? 128 : 0);
            }
        }
        return this.memory[adr] & 0xFF;
    }

    private void writeByte(int adr, byte data) {
        block0 : switch (adr & 0xE000) {
            case 32768: {
                this.video.writeByte(adr & 0x1FFF, data);
                break;
            }
            case 49152: {
                this.memory[adr] = data;
                break;
            }
            case 57344: {
                switch (adr & 0xFF00) {
                    case 65024: {
                        this.memory[adr] = data;
                        if (adr >= 65184) break block0;
                        this.writeOAM(adr, data);
                        break;
                    }
                    case 65280: {
                        this.writeIO(adr, data);
                        break;
                    }
                    default: {
                        this.memory[adr - 8192] = data;
                        break;
                    }
                }
                break;
            }
            default: {
                this.cartridge.writeByte(adr, data);
            }
        }
    }

    private void writeOAM(int adr, byte data) {
        Sprite sprite = this.video.getSprites()[(adr & 0xFC) >> 2];
        switch (adr & 3) {
            case 0: {
                sprite.setY((data & 0xFF) - 16);
                break;
            }
            case 1: {
                sprite.setX((data & 0xFF) - 8);
                break;
            }
            case 2: {
                sprite.setTile(data & 0xFF);
                break;
            }
            case 3: {
                sprite.setAttributes(data & 0xFF);
                break;
            }
        }
    }

    private void writeWord(int adr, int data) {
        this.writeByte(adr, (byte)(data & 0xFF));
        this.writeByte(adr + 1, (byte)(data >> 8));
    }

    protected final void writeIO(int adr, byte data) {
        switch (adr) {
            case 65280: {
                int jp = 255;
                if ((data & 0x10) == 0) {
                    jp &= 255 - this.gameboy.getJoypad().getDirections();
                }
                if ((data & 0x20) == 0) {
                    jp &= 255 - this.gameboy.getJoypad().getButtons();
                }
                data = (byte)jp;
                if ((this.readIO(adr) & ~data & 0xF) == 0) break;
                this.requestIRQ(16);
                break;
            }
            case 65282: {
                data = (byte)(data & 0x7F);
                if ((data & 1) != 1) break;
                this.memory[65281] = -1;
                break;
            }
            case 65284: {
                this.timer.setDiv(data & 0xFF);
                break;
            }
            case 65285: {
                this.timer.setTima(data & 0xFF);
                break;
            }
            case 65286: {
                this.timer.setTma(data & 0xFF);
                break;
            }
            case 65287: {
                this.timer.setTac(data & 0xFF);
                break;
            }
            case 65295: {
                this.irqsRequested = data & 0xFF;
                break;
            }
            case 65296: {
                ((SquareWaveChannel)this.sound.getSoundChannels()[0]).setSweep((data & 0x70) >> 4, (data & 8) != 0, data & 7);
                break;
            }
            case 65297: {
                ((SquareWaveChannel)this.sound.getSoundChannels()[0]).setWavePatternDuty((data & 0xC0) >> 6);
                break;
            }
            case 65298: {
                ((SquareWaveChannel)this.sound.getSoundChannels()[0]).setVolumeEnvelope((data & 0xF0) >> 4, (data & 8) != 0, data & 7);
                break;
            }
            case 65299: 
            case 65300: {
                this.memory[adr] = data;
                int frequencyGB = (this.memory[65299] & 0xFF) + ((this.memory[65300] & 7) << 8);
                ((SquareWaveChannel)this.sound.getSoundChannels()[0]).setFrequency(frequencyGB);
                if (adr != 65300 || (data & 0x80) == 0) break;
                this.sound.getSoundChannels()[0].setRepeat((data & 0x40) == 0);
                this.sound.getSoundChannels()[0].setLength(64 - (this.memory[65297] & 0x3F));
                break;
            }
            case 65302: {
                ((SquareWaveChannel)this.sound.getSoundChannels()[1]).setWavePatternDuty((data & 0xC0) >> 6);
                break;
            }
            case 65303: {
                ((SquareWaveChannel)this.sound.getSoundChannels()[1]).setVolumeEnvelope((data & 0xF0) >> 4, (data & 8) != 0, data & 7);
                break;
            }
            case 65304: 
            case 65305: {
                this.memory[adr] = data;
                int frequencyGB = (this.memory[65304] & 0xFF) + ((this.memory[65305] & 7) << 8);
                ((SquareWaveChannel)this.sound.getSoundChannels()[1]).setFrequency(frequencyGB);
                if (adr != 65305 || (data & 0x80) == 0) break;
                this.sound.getSoundChannels()[1].setRepeat((data & 0x40) == 0);
                this.sound.getSoundChannels()[1].setLength(64 - (this.memory[65302] & 0x3F));
                break;
            }
            case 65306: {
                ((VoluntaryWaveChannel)this.sound.getSoundChannels()[2]).setActive((data & 0x80) != 0);
                break;
            }
            case 65307: {
                break;
            }
            case 65308: {
                int vol = data >> 5 & 3;
                ((VoluntaryWaveChannel)this.sound.getSoundChannels()[2]).setOutputLevel(vol == 0 ? 0 : 200 >> vol);
                break;
            }
            case 65309: 
            case 65310: {
                this.memory[adr] = data;
                int frequencyGB = (this.memory[65309] & 0xFF) + ((this.memory[65310] & 7) << 8);
                ((VoluntaryWaveChannel)this.sound.getSoundChannels()[2]).setFrequency(frequencyGB);
                if (adr != 65310 || (data & 0x80) == 0) break;
                this.sound.getSoundChannels()[2].setRepeat((data & 0x40) == 0);
                this.sound.getSoundChannels()[2].setLength(255 - (this.memory[65307] & 0xFF));
                break;
            }
            case 65312: {
                break;
            }
            case 65313: {
                ((WhiteNoiseChannel)this.sound.getSoundChannels()[3]).setVolumeEnvelope((data & 0xF0) >> 4, (data & 8) != 0, data & 7);
                break;
            }
            case 65314: {
                ((WhiteNoiseChannel)this.sound.getSoundChannels()[3]).setPolynomialCounter((data & 0xF0) >> 4, (data & 8) != 0, data & 7);
                break;
            }
            case 65315: {
                if ((data & 0x80) == 0) break;
                this.sound.getSoundChannels()[3].setRepeat((data & 0x40) == 0);
                this.sound.getSoundChannels()[3].setLength(64 - (this.memory[65312] & 0x3F));
                break;
            }
            case 65317: {
                this.sound.getSoundChannels()[0].setTerminalActive(0, (data & 1) != 0);
                this.sound.getSoundChannels()[0].setTerminalActive(1, (data & 0x10) != 0);
                this.sound.getSoundChannels()[1].setTerminalActive(0, (data & 2) != 0);
                this.sound.getSoundChannels()[1].setTerminalActive(1, (data & 0x20) != 0);
                this.sound.getSoundChannels()[2].setTerminalActive(0, (data & 4) != 0);
                this.sound.getSoundChannels()[2].setTerminalActive(1, (data & 0x40) != 0);
                this.sound.getSoundChannels()[3].setTerminalActive(0, (data & 8) != 0);
                this.sound.getSoundChannels()[3].setTerminalActive(1, (data & 0x80) != 0);
                break;
            }
            case 65318: {
                this.isSoundOn = (data & 0x80) != 0;
                break;
            }
            case 65328: 
            case 65329: 
            case 65330: 
            case 65331: 
            case 65332: 
            case 65333: 
            case 65334: 
            case 65335: 
            case 65336: 
            case 65337: 
            case 65338: 
            case 65339: 
            case 65340: 
            case 65341: 
            case 65342: 
            case 65343: {
                ((VoluntaryWaveChannel)this.sound.getSoundChannels()[2]).setWavePattern(adr & 0xF, data);
                break;
            }
            case 65344: {
                VideoChip vc = this.video;
                vc.setLCDEnabled((data & 0x80) != 0);
                vc.setWindowTileArea((data & 0x40) != 0 ? 39936 : 38912);
                vc.setWindowEnabled((data & 0x20) != 0);
                vc.setTileDataArea((data & 0x10) != 0 ? 32768 : 34816);
                vc.setBackgroundTileArea((data & 8) != 0 ? 39936 : 38912);
                vc.setSpriteHeight((data & 4) != 0 ? 16 : 8);
                vc.setSpritesEnabled((data & 2) != 0);
                if (this.cartridge.isGBC()) {
                    vc.setHaveSpritesPriority((data & 1) == 0);
                    break;
                }
                vc.setBackgroundBlank((data & 1) == 0);
                break;
            }
            case 65345: {
                data = (byte)(this.memory[adr] & 0x87 | data & 0x78);
                VideoChip vc = this.video;
                vc.setCoincidenceIRQEnabled((data & 0x40) != 0);
                vc.setOAMIRQEnabled((data & 0x20) != 0);
                vc.setVBlankIRQEnabled((data & 0x10) != 0);
                vc.setHBlankIRQEnabled((data & 8) != 0);
                if (!vc.isLCDEnabled() || (data & 3) != 1 || (data & 0x44) == 68) break;
                this.requestIRQ(2);
                break;
            }
            case 65346: {
                this.video.setScrollY(data & 0xFF);
                break;
            }
            case 65347: {
                this.video.setScrollX(data & 0xFF);
                break;
            }
            case 65349: {
                if (!this.video.isLCDEnabled()) break;
                this.video.checkCoincidenceIRQ();
                break;
            }
            case 65350: {
                int source = (data & 0xFF) << 8;
                for (int i = 0; i < 160; ++i) {
                    this.writeOAM(65024 + i, (byte)this.readByte(source + i));
                }
                break;
            }
            case 65351: 
            case 65352: 
            case 65353: {
                if (this.cartridge.isGBC()) break;
                int palette = adr == 65351 ? 0 : 8 + (adr - 65352);
                int[] colors = new int[]{-1, -5592406, -11184811, -16777216};
                int i = 0;
                int shift = 0;
                while (i < 4) {
                    int col = colors[(data & 0xFF) >> shift & 3];
                    this.video.getColorPalettes()[palette].setColor(i, col);
                    this.video.invalidateTiles();
                    ++i;
                    shift += 2;
                }
                break;
            }
            case 65354: {
                this.video.setWindowY(data & 0xFF);
                break;
            }
            case 65355: {
                this.video.setWindowX((data & 0xFF) - 7);
                break;
            }
            case 65359: {
                this.video.setGBCVRAMBank(data & 1);
                break;
            }
            case 65365: {
                if (!this.isHDMARunning()) {
                    if ((data & 0x80) == 0) {
                        int len = (data & 0x7F) + 1;
                        this.performHDMA(len);
                        this.isHDMARunning = false;
                        break;
                    }
                    data = (byte)(data & 0x7F);
                    this.isHDMARunning = true;
                    break;
                }
                if ((data & 0x80) == 0) {
                    data = (byte)(data | 0x80);
                    this.isHDMARunning = false;
                    break;
                }
                data = (byte)(data & 0x7F);
                this.isHDMARunning = true;
                break;
            }
            case 65385: 
            case 65387: {
                if (!this.cartridge.isGBC()) break;
                int index = this.memory[adr - 1] & 0xFF;
                int palette = (adr == 65385 ? 0 : 8) * 4 << 1;
                this.video.setColorByte(palette + (index & 0x3F), data & 0xFF);
                if (index < 128) break;
                this.memory[adr - 1] = (byte)(0x80 | index + 1 & 0x3F);
                break;
            }
            case 65392: {
                if (!this.cartridge.isGBC()) break;
                this.setGBCRAMBank(Math.max(data & 7, 1));
                break;
            }
            case 65535: {
                this.irqsEnabled = data & 0xFF;
                break;
            }
        }
        this.memory[adr] = data;
    }

    private void setGBCRAMBank(int ramBank) {
        if (this.currentGBCRAMBank != ramBank) {
            System.arraycopy(this.memory, 53248, this.gbcRAMBanks[this.currentGBCRAMBank - 1], 0, 4096);
            this.currentGBCRAMBank = ramBank;
            System.arraycopy(this.gbcRAMBanks[this.currentGBCRAMBank - 1], 0, this.memory, 53248, 4096);
        }
    }

    public final void throttle(long ms) {
        this.throttledMillis += ms;
        try {
            Thread.sleep(ms);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    public final long getThrottledTime() {
        return this.throttledMillis;
    }

    public final void resetThrottleTime() {
        this.throttledMillis = 0L;
    }

    public void serialize(DataOutputStream out) throws IOException {
        SerializationUtils.serialize(out, this.memory);
        out.writeLong(this.cycles);
        out.writeInt(this.a);
        out.writeInt(this.b);
        out.writeInt(this.c);
        out.writeInt(this.d);
        out.writeInt(this.e);
        out.writeInt(this.f);
        out.writeInt(this.hl);
        out.writeInt(this.sp);
        out.writeInt(this.pc);
        out.writeBoolean(this.isInterruptEnabled);
        out.writeBoolean(this.doesInterruptEnableSwitch);
        out.writeInt(this.irqsRequested);
        out.writeInt(this.irqsEnabled);
        out.writeInt(this.currentGBCRAMBank);
        for (int i = 0; i < this.gbcRAMBanks.length; ++i) {
            SerializationUtils.serialize(out, this.gbcRAMBanks[i]);
        }
        this.timer.serialize(out);
        out.writeLong(this.nextEvent);
        out.writeInt(this.cpuSpeed);
        out.writeBoolean(this.hasSoundListener);
        out.writeBoolean(this.isHDMARunning);
        this.cartridge.serialize(out);
    }

    public void deserialize(DataInputStream in) throws IOException {
        SerializationUtils.deserialize(in, this.memory);
        this.cycles = in.readLong();
        this.a = in.readInt();
        this.b = in.readInt();
        this.c = in.readInt();
        this.d = in.readInt();
        this.e = in.readInt();
        this.f = in.readInt();
        this.hl = in.readInt();
        this.sp = in.readInt();
        this.pc = in.readInt();
        this.isInterruptEnabled = in.readBoolean();
        this.doesInterruptEnableSwitch = in.readBoolean();
        this.irqsRequested = in.readInt();
        this.irqsEnabled = in.readInt();
        this.currentGBCRAMBank = in.readInt();
        for (int i = 0; i < this.gbcRAMBanks.length; ++i) {
            SerializationUtils.deserialize(in, this.gbcRAMBanks[i]);
        }
        this.timer.deserialize(in);
        this.nextEvent = in.readLong();
        this.cpuSpeed = in.readInt();
        this.hasSoundListener = in.readBoolean();
        this.isHDMARunning = in.readBoolean();
        this.cartridge.deserialize(in);
    }

    class Timer
    implements Serializable {
        private long divCycle;
        private int instructionsPerTima = Integer.MAX_VALUE;
        private long lastStartedCycle;
        private int tma;
        private int tac;
        private int tima;
        private long nextTimerIRQRequest = Long.MAX_VALUE;

        Timer() {
        }

        public int getDiv() {
            return (int)((CPU.this.getCycles() - this.divCycle) / (long)CPU.this.instructionsPerDiv) & 0xFF;
        }

        public final void setDiv(int div) {
            this.divCycle = CPU.this.getCycles();
        }

        public final int getTima() {
            if (this.isRunning()) {
                return this.tima + (int)((CPU.this.getCycles() - this.lastStartedCycle) / (long)this.instructionsPerTima) & 0xFF;
            }
            return this.tima;
        }

        public final void setTima(int tima) {
            this.tima = tima;
            this.lastStartedCycle = CPU.this.getCycles();
            this.determineNextIRQ();
        }

        public final int getTma() {
            return this.tma;
        }

        public final void setTma(int tma) {
            this.tma = tma;
        }

        public final int getTac() {
            return 0xF8 | this.tac & 7;
        }

        public final void setTac(int tac) {
            this.tac = tac;
            switch (tac & 3) {
                case 0: {
                    this.instructionsPerTima = CPU.this.cpuSpeed / 4096;
                    break;
                }
                case 1: {
                    this.instructionsPerTima = CPU.this.cpuSpeed / 262144;
                    break;
                }
                case 2: {
                    this.instructionsPerTima = CPU.this.cpuSpeed / 65536;
                    break;
                }
                case 3: {
                    this.instructionsPerTima = CPU.this.cpuSpeed / 16384;
                }
            }
            this.determineNextIRQ();
        }

        public final boolean isRunning() {
            return (this.tac & 4) != 0;
        }

        private final void determineNextIRQ() {
            this.tima = this.getTima();
            if (this.isRunning()) {
                this.lastStartedCycle = CPU.this.getCycles();
                this.nextTimerIRQRequest = this.lastStartedCycle + (long)(this.instructionsPerTima * (256 - this.tima));
                if (this.nextTimerIRQRequest < CPU.this.nextEvent) {
                    CPU.this.nextEvent = this.nextTimerIRQRequest;
                }
            } else {
                this.nextTimerIRQRequest = Long.MAX_VALUE;
                this.instructionsPerTima = Integer.MAX_VALUE;
            }
        }

        protected final void restart() {
            this.setTima(this.getTma());
        }

        protected final long getNextIRQRequest() {
            return this.nextTimerIRQRequest;
        }

        public void serialize(DataOutputStream out) throws IOException {
            out.writeLong(this.divCycle);
            out.writeInt(this.instructionsPerTima);
            out.writeLong(this.lastStartedCycle);
            out.writeInt(this.tma);
            out.writeInt(this.tac);
            out.writeLong(this.nextTimerIRQRequest);
        }

        public void deserialize(DataInputStream in) throws IOException {
            this.divCycle = in.readLong();
            this.instructionsPerTima = in.readInt();
            this.lastStartedCycle = in.readLong();
            this.tma = in.readInt();
            this.tac = in.readInt();
            this.nextTimerIRQRequest = in.readLong();
        }
    }
}

