/*
 * Decompiled with CFR 0.152.
 */
package de.joergjahnke.gameboy.core;

import de.joergjahnke.common.io.Serializable;
import de.joergjahnke.common.io.SerializationUtils;
import de.joergjahnke.gameboy.core.VideoChip;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;

public class ColorPalette
implements Serializable {
    public static final int COLORS_PER_PALETTE = 4;
    private final VideoChip video;
    private final int[] colors = new int[4];
    private int colorsCode = Integer.MAX_VALUE;

    public ColorPalette(VideoChip video) {
        this(video, -1);
    }

    public ColorPalette(VideoChip video, int color) {
        this.video = video;
        for (int i = 0; i < this.colors.length; ++i) {
            this.colors[i] = color;
        }
    }

    public final int getColor(int n) {
        return this.colors[n];
    }

    public final void setColor(int n, int col) {
        if (col != this.colors[n]) {
            this.colors[n] = col;
            this.colorsCode = Integer.MAX_VALUE;
            this.video.invalidateTiles();
            this.video.invalidateLines();
        }
    }

    public final int hashCode() {
        if (this.colorsCode == Integer.MAX_VALUE) {
            int hc = 0;
            int i = 0;
            int shift = 0;
            while (i < 4) {
                hc ^= this.colors[i] << shift;
                ++i;
                shift += 2;
            }
            this.colorsCode = hc;
        }
        return this.colorsCode;
    }

    public boolean equals(Object obj) {
        return obj != null && this.getClass() == obj.getClass() && this.hashCode() == ((ColorPalette)obj).hashCode();
    }

    public void serialize(DataOutputStream out) throws IOException {
        SerializationUtils.serialize(out, this.colors);
        out.writeInt(this.colorsCode);
    }

    public void deserialize(DataInputStream in) throws IOException {
        SerializationUtils.deserialize(in, this.colors);
        this.colorsCode = in.readInt();
    }
}

