/*
 * Decompiled with CFR 0.152.
 */
package de.joergjahnke.gameboy.core;

import de.joergjahnke.common.emulation.FrequencyDataProducer;
import de.joergjahnke.common.io.Serializable;
import de.joergjahnke.common.io.SerializationUtils;
import de.joergjahnke.gameboy.core.SoundChip;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;

public abstract class SoundChannel
implements Serializable,
FrequencyDataProducer {
    public static final int LEFT = 0;
    public static final int RIGHT = 1;
    protected static final int MAX_VOLUME = 15;
    protected final SoundChip sound;
    private boolean[] active = new boolean[2];
    protected int length = 0;
    protected int samples = 0;
    protected boolean isRepeat = false;
    protected int frequency;
    protected int startFrequency;
    protected int volume = 0;
    protected int startVolume = 0;
    protected int audioIndex = 0;

    protected SoundChannel(SoundChip sound) {
        this.sound = sound;
    }

    public boolean isActive() {
        return this.length > 0 || this.isRepeat;
    }

    public final boolean hasSound() {
        return this.isActive() && (this.isTerminalActive(0) || this.isTerminalActive(1));
    }

    public final boolean isTerminalActive(int terminal) {
        return this.active[terminal];
    }

    public final void setTerminalActive(int terminal, boolean active) {
        this.active[terminal] = active;
    }

    public final int getLength() {
        return (this.length << 8) / 128;
    }

    public final void setLength(int length) {
        this.length = length * 128 >> 8;
        this.startFrequency = this.frequency;
        this.startVolume = this.volume;
    }

    public final boolean isRepeat() {
        return this.isRepeat;
    }

    public final void setRepeat(boolean isRepeat) {
        this.isRepeat = isRepeat;
    }

    public void serialize(DataOutputStream out) throws IOException {
        SerializationUtils.serialize(out, this.active);
        out.writeInt(this.audioIndex);
        out.writeInt(this.volume);
        out.writeInt(this.startVolume);
        out.writeInt(this.frequency);
        out.writeInt(this.startFrequency);
        out.writeInt(this.length);
        out.writeInt(this.samples);
        out.writeBoolean(this.isRepeat);
    }

    public void deserialize(DataInputStream in) throws IOException {
        SerializationUtils.deserialize(in, this.active);
        this.audioIndex = in.readInt();
        this.volume = in.readInt();
        this.startVolume = in.readInt();
        this.frequency = in.readInt();
        this.startVolume = in.readInt();
        this.length = in.readInt();
        this.samples = in.readInt();
        this.isRepeat = in.readBoolean();
    }

    public abstract void update();

    public abstract void mix(byte[] var1);
}

