/*
 * Decompiled with CFR 0.152.
 */
package de.joergjahnke.gameboy.jme;

import de.joergjahnke.common.jme.Backlight;
import de.joergjahnke.common.jme.ImageUtils;
import de.joergjahnke.common.jme.LocalizationSupport;
import de.joergjahnke.common.jme.OrientationSensitiveCanvas;
import de.joergjahnke.common.util.Observer;
import de.joergjahnke.gameboy.core.Gameboy;
import de.joergjahnke.gameboy.core.Joypad;
import de.joergjahnke.gameboy.core.VideoChip;
import de.joergjahnke.gameboy.jme.MEGameboyMIDlet;
import java.io.IOException;
import java.util.Hashtable;
import java.util.Timer;
import java.util.TimerTask;
import javax.microedition.lcdui.Alert;
import javax.microedition.lcdui.AlertType;
import javax.microedition.lcdui.Displayable;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;
import javax.microedition.lcdui.game.Sprite;

public class GameboyCanvas
extends OrientationSensitiveCanvas
implements Observer {
    private static final String[] BUTTON_IMAGES = new String[]{"/res/drawable/button_a", "/res/drawable/button_b", "/res/drawable/button_select", "/res/drawable/button_start"};
    private static final int[] BUTTON_JOYPAD_MAPPING = new int[]{1, 2, 4, 8};
    private static final String[] DIRECTION_IMAGES = new String[]{"/res/drawable/button_up", "/res/drawable/button_down", "/res/drawable/button_left", "/res/drawable/button_right"};
    private static final int[] DIRECTION_JOYPAD_MAPPING = new int[]{4, 8, 2, 1};
    private static final String ONEPIXEL_IMAGE = "/res/jme/pixel.png";
    private static final int MIN_PERCENTAGE_POINTER_MOVEMENT = 5;
    private static final long AUTOMATIC_KEY_RELEASE_TIME = 200L;
    protected final MEGameboyMIDlet midlet;
    protected Gameboy gameboy;
    protected boolean showEmulatorExceptions = true;
    private int x;
    private int y;
    private int paintWidth;
    private int paintHeight;
    private Sprite[] buttons = null;
    private Image[] buttonImages = null;
    private Sprite[] directions = null;
    private Image[] directionImages = null;
    private Image onePixel = null;
    protected final Graphics graphics;
    private int pStartX = -1;
    private int pStartY = -1;
    private Hashtable buttonAssignments = new Hashtable();
    private Hashtable buttonReleaseTimers = new Hashtable();
    private boolean isShowButtons = false;
    private boolean isShowDPad = false;
    private int[] rgbDataCopy = null;

    public GameboyCanvas(MEGameboyMIDlet midlet) {
        super(midlet);
        this.midlet = midlet;
        this.setFullScreenMode(true);
        if (this.hasPointerEvents()) {
            this.isShowDPad = true;
            this.isShowButtons = true;
            this.buttons = new Sprite[BUTTON_IMAGES.length];
            this.buttonImages = new Image[BUTTON_IMAGES.length * 2];
            this.directions = new Sprite[DIRECTION_IMAGES.length];
            this.directionImages = new Image[DIRECTION_IMAGES.length * 2];
            try {
                int ddim;
                int bdim;
                int dim;
                int i;
                this.onePixel = Image.createImage((String)ONEPIXEL_IMAGE);
                for (i = 0; i < BUTTON_IMAGES.length; ++i) {
                    this.buttonImages[i] = Image.createImage((String)(BUTTON_IMAGES[i] + ".png"));
                    this.buttonImages[i + GameboyCanvas.BUTTON_IMAGES.length] = ImageUtils.adjustBrightness(this.buttonImages[i], 0.75);
                    this.buttons[i] = new Sprite(this.buttonImages[i]);
                }
                for (i = 0; i < DIRECTION_IMAGES.length; ++i) {
                    this.directionImages[i] = Image.createImage((String)(DIRECTION_IMAGES[i] + ".png"));
                    this.directionImages[i + GameboyCanvas.BUTTON_IMAGES.length] = ImageUtils.adjustBrightness(this.directionImages[i], 0.75);
                    this.directions[i] = new Sprite(this.directionImages[i]);
                }
                if (this.getWidth() < this.getHeight()) {
                    dim = this.getWidth();
                    bdim = this.buttons[0].getWidth();
                    ddim = this.directions[0].getWidth();
                } else {
                    dim = this.getHeight();
                    bdim = this.buttons[0].getHeight();
                    ddim = this.directions[0].getHeight();
                }
                if (dim < bdim * this.buttons.length + ddim) {
                    this.directions = null;
                    if (dim < bdim * this.buttons.length) {
                        this.buttons = null;
                    }
                }
            }
            catch (IOException e) {
                this.buttons = null;
                this.directions = null;
            }
        }
        this.graphics = this.getGraphics();
        this.buttonAssignments.put(new Integer(49), "A");
        this.buttonAssignments.put(new Integer(51), "B");
        this.buttonAssignments.put(new Integer(55), "Select");
        this.buttonAssignments.put(new Integer(57), "Start");
    }

    public final Gameboy getGameboy() {
        return this.gameboy;
    }

    public void setGameboy(Gameboy gameboy) {
        this.gameboy = gameboy;
    }

    public boolean isShowButtons() {
        return this.isShowButtons && this.buttons != null;
    }

    public void setShowButtons(boolean isShowButtons) {
        this.isShowButtons = isShowButtons;
    }

    public boolean isShowDirectionButtons() {
        return this.isShowDPad && this.directions != null;
    }

    public void setShowDirectionButtons(boolean isShowDPad) {
        this.isShowDPad = isShowDPad;
    }

    public Hashtable getButtonAssignments() {
        return this.buttonAssignments;
    }

    public void setButtonAssignments(Hashtable buttonAssignments) {
        this.buttonAssignments = buttonAssignments;
    }

    private void paint() {
        this.graphics.setColor(0, 0, 0);
        this.graphics.fillRect(0, 0, this.getWidth(), this.getHeight());
        System.arraycopy(this.gameboy.getVideoChip().getRGBData(), 0, this.rgbDataCopy, 0, this.rgbDataCopy.length);
        if (!this.isAutoChangeOrientation() || this.transform == 0) {
            this.graphics.drawRGB(this.rgbDataCopy, 0, this.paintWidth, this.x, this.y, this.paintWidth, this.paintHeight, false);
        } else {
            Image image = Image.createRGBImage((int[])this.rgbDataCopy, (int)this.paintWidth, (int)this.paintHeight, (boolean)false);
            this.graphics.drawRegion(image, 0, 0, image.getWidth(), image.getHeight(), this.transform, this.x, this.y, 20);
            image = null;
            System.gc();
        }
        if (this.isShowButtons()) {
            for (int i = 0; i < this.buttons.length; ++i) {
                this.buttons[i].setTransform(this.transform);
                this.buttons[i].paint(this.graphics);
            }
        }
        if (this.isShowDirectionButtons()) {
            for (int i = 0; i < this.directions.length; ++i) {
                this.directions[i].setTransform(this.transform);
                this.directions[i].paint(this.graphics);
            }
        }
        this.flushGraphics();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void calculateScreenSize() {
        int buttonsHeight;
        int buttonsWidth;
        int w = this.getWidth();
        int h = this.isAutoChangeOrientation() ? this.getWidth() : this.getHeight();
        double scalingW = (double)w * 1.0 / 160.0;
        double scalingH = (double)h * 1.0 / 144.0;
        int n = this.isShowDirectionButtons() ? this.directions[0].getWidth() : (buttonsWidth = this.isShowButtons() ? this.buttons[0].getWidth() : 0);
        int n2 = this.isShowDirectionButtons() ? this.directions[0].getHeight() : (buttonsHeight = this.isShowButtons() ? this.buttons[0].getHeight() : 0);
        if (this.isShowButtons() || this.isShowDirectionButtons()) {
            if (scalingH >= scalingW) {
                scalingH = (double)(h - buttonsHeight) * 1.0 / 144.0;
            } else {
                scalingW = (double)(w - buttonsWidth) * 1.0 / 160.0;
            }
        }
        VideoChip video = this.gameboy.getVideoChip();
        double scaling = Math.min(scalingW, scalingH);
        try {
            boolean useScaling = this.midlet.getSettings().getBoolean("Scaling", true);
            if (!useScaling) {
                scaling = 1.0;
            }
        }
        catch (Exception e) {
        }
        finally {
            video.setScaling((int)(scaling * 1024.0));
        }
        video.deleteObserver(this);
        video.addObserver(this);
        this.gameboy.deleteObserver(this);
        this.gameboy.addObserver(this);
        this.paintWidth = video.getScaledWidth();
        this.paintHeight = video.getScaledHeight();
        this.rgbDataCopy = new int[this.paintWidth * this.paintHeight];
        if (this.isShowButtons() || this.isShowDirectionButtons()) {
            int dh;
            int n1 = this.buttons.length;
            int bw = this.buttons[0].getWidth();
            int bh = this.buttons[0].getHeight();
            int n22 = this.isShowDirectionButtons() ? 1 + n1 : n1;
            int dw = this.directions == null ? 0 : this.directions[0].getWidth();
            int n3 = dh = this.directions == null ? 0 : this.directions[0].getHeight();
            if (this.isShowButtons()) {
                int yy;
                int xx;
                int i;
                if (h - this.paintHeight >= bh) {
                    this.x = w - this.paintWidth >> 1;
                    this.y = h - this.paintHeight - buttonsHeight >> 1;
                    int xinc = (w - n1 * bw - (this.isShowDirectionButtons() ? dw : 0)) / (n22 - 1) + bw;
                    i = 0;
                    xx = 0;
                    yy = h - bh;
                    while (i < n1) {
                        this.buttons[i].setPosition(xx, yy);
                        ++i;
                        xx += xinc;
                    }
                } else {
                    this.x = w - this.paintWidth - buttonsWidth >> 1;
                    this.y = h - this.paintHeight >> 1;
                    int yinc = (h - n1 * bh - (this.isShowDirectionButtons() ? dh : 0)) / (n22 - 1) + bh;
                    i = 0;
                    xx = w - bw;
                    yy = 0;
                    while (i < n1) {
                        this.buttons[i].setPosition(xx, yy);
                        ++i;
                        yy += yinc;
                    }
                }
            }
            if (this.isShowDirectionButtons()) {
                for (int i = 0; i < this.directions.length; ++i) {
                    this.directions[i].setPosition(w - dw, h - dh);
                }
            }
        } else {
            this.x = w - this.paintWidth >> 1;
            this.y = h - this.paintHeight >> 1;
        }
    }

    private int adjustJoypadDirection(int direction) {
        switch (this.transform) {
            case 5: {
                return direction < 4 ? direction << 2 : (direction == 4 ? 2 : 1);
            }
            case 3: {
                return direction >= 4 ? direction ^ 0xC : direction ^ 3;
            }
            case 6: {
                return direction >= 4 ? direction >> 2 : (direction == 1 ? 8 : 4);
            }
        }
        return direction;
    }

    private int getJoypadChanges(int keyCode) {
        int pressedDirections = this.gameboy.getJoypad().getDirections();
        int pressedButtons = this.gameboy.getJoypad().getButtons();
        int repeatMask = 0;
        int gameAction = this.buttonAssignments.contains("Up") ? 0 : this.getGameAction(keyCode);
        String buttonName = null;
        if (this.buttonAssignments.containsKey(new Integer(keyCode))) {
            buttonName = this.buttonAssignments.get(new Integer(keyCode)).toString();
        } else if (this.buttonAssignments.containsKey(new Integer(keyCode + Integer.MIN_VALUE))) {
            buttonName = this.buttonAssignments.get(new Integer(keyCode + Integer.MIN_VALUE)).toString();
            repeatMask = Integer.MIN_VALUE;
        }
        if ("Up".equals(buttonName) || gameAction == 1) {
            pressedDirections |= this.adjustJoypadDirection(4);
        }
        if ("Down".equals(buttonName) || gameAction == 6) {
            pressedDirections |= this.adjustJoypadDirection(8);
        }
        if ("Left".equals(buttonName) || gameAction == 2) {
            pressedDirections |= this.adjustJoypadDirection(2);
        }
        if ("Right".equals(buttonName) || gameAction == 5) {
            pressedDirections |= this.adjustJoypadDirection(1);
        }
        if ("A".equals(buttonName) || gameAction == 8) {
            pressedButtons |= 1;
        }
        if ("B".equals(buttonName)) {
            pressedButtons |= 2;
        }
        if ("Select".equals(buttonName)) {
            pressedButtons |= 4;
        }
        if ("Start".equals(buttonName)) {
            pressedButtons |= 8;
        }
        return pressedDirections + (pressedButtons << 16) + repeatMask;
    }

    protected void keyPressed(final int keyCode) {
        boolean needReleaseTimer;
        int changes = this.getJoypadChanges(keyCode);
        int pressedDirections = changes & 0xFFFF;
        int pressedButtons = (changes & 0x7FFF0000) >> 16;
        boolean bl = needReleaseTimer = (changes & Integer.MIN_VALUE) != 0;
        if (needReleaseTimer) {
            Integer key = new Integer(keyCode);
            Timer buttonReleaseTimer = (Timer)this.buttonReleaseTimers.get(key);
            if (buttonReleaseTimer != null) {
                buttonReleaseTimer.cancel();
            }
            buttonReleaseTimer = new Timer();
            buttonReleaseTimer.schedule(new TimerTask(){

                public void run() {
                    GameboyCanvas.this.keyReleased(keyCode);
                }
            }, 200L);
            this.buttonReleaseTimers.put(key, buttonReleaseTimer);
        }
        this.gameboy.getJoypad().setDirections(this.gameboy.getJoypad().getDirections() | pressedDirections);
        this.gameboy.getJoypad().setButtons(this.gameboy.getJoypad().getButtons() | pressedButtons);
    }

    protected void keyReleased(int keyCode) {
        int changes = this.getJoypadChanges(keyCode);
        int pressedDirections = changes & 0xFFFF;
        int pressedButtons = (changes & 0x7FFF0000) >> 16;
        this.gameboy.getJoypad().setDirections(this.gameboy.getJoypad().getDirections() & 15 - pressedDirections);
        this.gameboy.getJoypad().setButtons(this.gameboy.getJoypad().getButtons() & 15 - pressedButtons);
    }

    protected void keyRepeated(int keyCode) {
        this.keyPressed(keyCode);
    }

    protected void pointerPressed(int x, int y) {
        int i;
        boolean wasEventProcessed = false;
        if (this.isShowButtons()) {
            for (i = 0; !wasEventProcessed && i < this.buttons.length; ++i) {
                if (!this.buttons[i].collidesWith(this.onePixel, x, y, true)) continue;
                this.gameboy.getJoypad().setButtons(this.gameboy.getJoypad().getButtons() | BUTTON_JOYPAD_MAPPING[i]);
                wasEventProcessed = true;
            }
        }
        if (this.isShowDirectionButtons()) {
            for (i = 0; !wasEventProcessed && i < this.directions.length; ++i) {
                if (!this.directions[i].collidesWith(this.onePixel, x, y, true)) continue;
                this.gameboy.getJoypad().setDirections(this.gameboy.getJoypad().getDirections() | DIRECTION_JOYPAD_MAPPING[i]);
                wasEventProcessed = true;
            }
        }
        if (!wasEventProcessed && x >= this.x && x < this.x + this.paintWidth && y >= this.y && y < this.y + this.paintHeight) {
            this.pStartX = x;
            this.pStartY = y;
        }
    }

    protected void pointerReleased(int x, int y) {
        int i;
        boolean wasEventProcessed = false;
        if (this.isShowButtons()) {
            for (i = 0; !wasEventProcessed && i < this.buttons.length; ++i) {
                if (!this.buttons[i].collidesWith(this.onePixel, x, y, true)) continue;
                this.gameboy.getJoypad().setButtons(this.gameboy.getJoypad().getButtons() & 15 - BUTTON_JOYPAD_MAPPING[i]);
                wasEventProcessed = true;
            }
        }
        if (this.isShowDirectionButtons()) {
            for (i = 0; !wasEventProcessed && i < this.directions.length; ++i) {
                if (!this.directions[i].collidesWith(this.onePixel, x, y, true)) continue;
                this.gameboy.getJoypad().setDirections(this.gameboy.getJoypad().getDirections() & 15 - DIRECTION_JOYPAD_MAPPING[i]);
                wasEventProcessed = true;
            }
        }
        if (!wasEventProcessed && x >= this.x && x < this.x + this.paintWidth && y >= this.y && y < this.y + this.paintHeight) {
            this.gameboy.getJoypad().setDirections(0);
        }
        this.pStartY = -1;
        this.pStartX = -1;
    }

    protected void pointerDragged(int x, int y) {
        if (x >= this.x && x < this.x + this.paintWidth && y >= this.y && y < this.y + this.paintHeight && this.pStartX > 0) {
            int distX = x - this.pStartX;
            int distY = y - this.pStartY;
            if (Math.abs(distX) > Math.abs(distY)) {
                if (Math.abs(distX) > this.paintWidth * 5 / 100) {
                    this.gameboy.getJoypad().setDirections(distX < 0 ? this.adjustJoypadDirection(2) : this.adjustJoypadDirection(1));
                }
            } else if (Math.abs(distY) > this.paintHeight * 5 / 100) {
                this.gameboy.getJoypad().setDirections(distY < 0 ? this.adjustJoypadDirection(4) : this.adjustJoypadDirection(8));
            }
        }
    }

    public void onAccelerometerChange(double x, double y, double z) {
        Joypad joypad = this.gameboy.getJoypad();
        if (x > 200.0) {
            joypad.setDirections(joypad.getDirections() | this.adjustJoypadDirection(2));
        } else if (x < -200.0) {
            joypad.setDirections(joypad.getDirections() | this.adjustJoypadDirection(1));
        } else {
            joypad.setDirections(joypad.getDirections() & 15 - this.adjustJoypadDirection(2) - this.adjustJoypadDirection(1));
        }
        if (y < -200.0) {
            joypad.setDirections(joypad.getDirections() | this.adjustJoypadDirection(4));
        } else if (y > 200.0) {
            joypad.setDirections(joypad.getDirections() | this.adjustJoypadDirection(8));
        } else {
            joypad.setDirections(joypad.getDirections() & 15 - this.adjustJoypadDirection(4) - this.adjustJoypadDirection(8));
        }
        try {
            Backlight.setLevel(75);
        }
        catch (Throwable t) {
            // empty catch block
        }
    }

    public void update(Object observable, Object event) {
        if (observable instanceof VideoChip && event == VideoChip.SIGNAL_NEW_FRAME) {
            this.paint();
        } else if (event instanceof Throwable && this.showEmulatorExceptions) {
            this.showEmulatorExceptions = false;
            this.display.setCurrent((Displayable)new Alert(LocalizationSupport.getMessage("AnErrorHasOccurred"), LocalizationSupport.getMessage("ErrorWas") + ((Throwable)event).getMessage() + LocalizationSupport.getMessage("NoFurtherMessages"), null, AlertType.WARNING));
        } else if (observable instanceof Joypad) {
            int i;
            if (this.isShowButtons()) {
                int pressedButtons = ((Joypad)observable).getButtons();
                for (i = 0; i < BUTTON_JOYPAD_MAPPING.length; ++i) {
                    this.buttons[i].setImage(this.buttonImages[(pressedButtons & BUTTON_JOYPAD_MAPPING[i]) != 0 ? i + BUTTON_IMAGES.length : i], this.buttons[i].getWidth(), this.buttons[i].getHeight());
                }
            }
            if (this.isShowDirectionButtons()) {
                int selectedDirections = ((Joypad)observable).getDirections();
                for (i = 0; i < DIRECTION_JOYPAD_MAPPING.length; ++i) {
                    this.directions[i].setImage(this.directionImages[(selectedDirections & DIRECTION_JOYPAD_MAPPING[i]) != 0 ? i + BUTTON_IMAGES.length : i], this.directions[i].getWidth(), this.directions[i].getHeight());
                }
            }
            if (this.isShowButtons() || this.isShowDirectionButtons()) {
                this.paint();
            }
        }
    }
}

