/*
 * Decompiled with CFR 0.152.
 */
import java.io.IOException;
import java.io.InputStream;
import java.util.Vector;
import javax.microedition.lcdui.Alert;
import javax.microedition.lcdui.AlertType;
import javax.microedition.lcdui.Command;
import javax.microedition.lcdui.CommandListener;
import javax.microedition.lcdui.Display;
import javax.microedition.lcdui.Displayable;
import javax.microedition.lcdui.List;
import javax.microedition.rms.RecordStore;

public class MainMenu
implements CommandListener {
    private Command selectCommand = new Command("Select", 8, 1);
    private Command exitCommand = new Command("Exit", 7, 1);
    private Command backCommand = new Command("Back", 2, 1);
    AppleIIGo midlet;
    Display display;
    EmAppleII apple;
    AppleCanvas canvas;
    private static int diskDrive;
    private static int[] diskSel;
    private List menuOptions;
    private List menuDisk;
    private boolean menuDiskEmpty;
    private List menuSettings;
    private List menuPageOrientation;
    private List menuColorMode;
    private List menuNavKeys;
    private List menuJoystick;

    public MainMenu(AppleIIGo appleIIGo, Display display, EmAppleII emAppleII, AppleCanvas appleCanvas) {
        this.midlet = appleIIGo;
        this.display = display;
        this.apple = emAppleII;
        this.canvas = appleCanvas;
        String[] stringArray = new String[]{"Continue", "Disk II Drive 1", "Disk II Drive 2", "Settings", "About"};
        this.menuOptions = new List("AppleIIGo", 3, stringArray, null);
        this.menuOptions.setSelectCommand(this.selectCommand);
        this.menuOptions.addCommand(this.exitCommand);
        this.menuOptions.setCommandListener((CommandListener)this);
        String[] stringArray2 = this.readDiskIndex("Resources/disks.index");
        if (stringArray2 != null) {
            this.menuDisk = new List("Disk II Drive " + diskDrive, 3, stringArray2, null);
            this.menuDisk.setSelectCommand(this.selectCommand);
            this.menuDiskEmpty = false;
        } else {
            this.menuDisk = new List("Disk II Drive " + diskDrive, 3);
            this.menuDiskEmpty = true;
        }
        this.menuDisk.addCommand(this.backCommand);
        this.menuDisk.setCommandListener((CommandListener)this);
        String[] stringArray3 = new String[]{"Screen orientation", "Screen colour", "Navigation keys", "Joystick mode"};
        this.menuSettings = new List("Settings", 3, stringArray3, null);
        this.menuSettings.setSelectCommand(this.selectCommand);
        this.menuSettings.addCommand(this.backCommand);
        this.menuSettings.setCommandListener((CommandListener)this);
        String[] stringArray4 = new String[]{"Portrait", "Landscape"};
        this.menuPageOrientation = new List("Screen orientation", 3, stringArray4, null);
        this.menuPageOrientation.setSelectCommand(this.selectCommand);
        this.menuPageOrientation.addCommand(this.backCommand);
        this.menuPageOrientation.setCommandListener((CommandListener)this);
        String[] stringArray5 = new String[]{"Green", "Colour"};
        this.menuColorMode = new List("Screen colour", 3, stringArray5, null);
        this.menuColorMode.setSelectCommand(this.selectCommand);
        this.menuColorMode.addCommand(this.backCommand);
        this.menuColorMode.setCommandListener((CommandListener)this);
        String[] stringArray6 = new String[]{"Apple II keyboard", "Joystick"};
        this.menuNavKeys = new List("Navigation keys", 3, stringArray6, null);
        this.menuNavKeys.setSelectCommand(this.selectCommand);
        this.menuNavKeys.addCommand(this.backCommand);
        this.menuNavKeys.setCommandListener((CommandListener)this);
        String[] stringArray7 = new String[]{"Analog", "Digital"};
        this.menuJoystick = new List("Jostick mode", 3, stringArray7, null);
        this.menuJoystick.setSelectCommand(this.selectCommand);
        this.menuJoystick.addCommand(this.backCommand);
        this.menuJoystick.setCommandListener((CommandListener)this);
    }

    private void configRead() {
        try {
            RecordStore recordStore = RecordStore.openRecordStore((String)"config", (boolean)true);
            if (recordStore.getNumRecords() > 0) {
                byte[] byArray = new byte[1];
                recordStore.getRecord(1, byArray, 0);
                this.canvas.setPageOrientation(byArray[0]);
                recordStore.getRecord(2, byArray, 0);
                this.canvas.setColorMode(byArray[0]);
                recordStore.getRecord(3, byArray, 0);
                this.canvas.keyboard.setNavKeyMode(byArray[0]);
                recordStore.getRecord(4, byArray, 0);
                this.apple.paddle.setPaddleMode(byArray[0]);
                recordStore.closeRecordStore();
            }
        }
        catch (Throwable throwable) {
            this.error("Error while reading configuration: " + throwable.toString());
        }
    }

    private void configWrite() {
        byte[] byArray = new byte[1];
        try {
            RecordStore recordStore = RecordStore.openRecordStore((String)"config", (boolean)true);
            if (recordStore.getNumRecords() == 0) {
                recordStore.addRecord(byArray, 0, 1);
                recordStore.addRecord(byArray, 0, 1);
                recordStore.addRecord(byArray, 0, 1);
                recordStore.addRecord(byArray, 0, 1);
            }
            byArray[0] = (byte)this.canvas.getPageOrientation();
            recordStore.setRecord(1, byArray, 0, 1);
            byArray[0] = (byte)this.canvas.getColorMode();
            recordStore.setRecord(2, byArray, 0, 1);
            byArray[0] = (byte)this.canvas.keyboard.getNavKeyMode();
            recordStore.setRecord(3, byArray, 0, 1);
            byArray[0] = (byte)this.apple.paddle.getPaddleMode();
            recordStore.setRecord(4, byArray, 0, 1);
            recordStore.closeRecordStore();
        }
        catch (Throwable throwable) {
            this.error("Error while writing configuration: " + throwable.toString());
        }
    }

    private String[] readDiskIndex(String string) {
        InputStream inputStream = this.getClass().getResourceAsStream(string);
        try {
            int n;
            Vector<String> vector = new Vector<String>();
            StringBuffer stringBuffer = new StringBuffer();
            while ((n = inputStream.read()) != -1) {
                if (n == 10 || n == 13) {
                    if (stringBuffer.length() <= 0) continue;
                    vector.addElement(stringBuffer.toString());
                    stringBuffer = new StringBuffer();
                    continue;
                }
                stringBuffer.append((char)n);
            }
            String[] stringArray = new String[vector.size()];
            if (vector.size() == 0) {
                return null;
            }
            for (int i = 0; i < vector.size(); ++i) {
                stringArray[i] = (String)vector.elementAt(i);
            }
            return stringArray;
        }
        catch (IOException iOException) {
            return null;
        }
    }

    public void show() {
        this.display.setCurrent((Displayable)this.menuOptions);
    }

    private void about() {
        Alert alert = new Alert("About", "AppleIIGo 0.9.9\n\nApple II J2ME Emulator\n\u00a9 2006 by\nMarc S. Ressl\nReleased under the GPL.", null, null);
        this.display.setCurrent((Displayable)alert);
    }

    private void confirm(String string) {
        Alert alert = new Alert(null, string, null, AlertType.CONFIRMATION);
        alert.setTimeout(1000);
        this.display.setCurrent((Displayable)alert);
    }

    private void error(String string) {
        Alert alert = new Alert(null, string, null, AlertType.ERROR);
        this.display.setCurrent((Displayable)alert);
    }

    private boolean mountDisk(String string, int n) {
        Class<?> clazz = this.getClass();
        InputStream inputStream = clazz.getResourceAsStream(string);
        if (this.apple.disk != null) {
            return this.apple.disk.mountDisk(inputStream, n, false);
        }
        return false;
    }

    public void commandAction(Command command, Displayable displayable) {
        if (displayable.equals(this.menuOptions)) {
            if (command.equals(this.selectCommand)) {
                switch (this.menuOptions.getSelectedIndex()) {
                    case 0: {
                        this.configRead();
                        this.canvas.show();
                        break;
                    }
                    case 1: {
                        diskDrive = 0;
                        this.menuDisk.setTitle("Disk II Drive 1");
                        if (!this.menuDiskEmpty) {
                            this.menuDisk.setSelectedIndex(diskSel[diskDrive], true);
                        }
                        this.display.setCurrent((Displayable)this.menuDisk);
                        break;
                    }
                    case 2: {
                        diskDrive = 1;
                        this.menuDisk.setTitle("Disk II Drive 2");
                        if (!this.menuDiskEmpty) {
                            this.menuDisk.setSelectedIndex(diskSel[diskDrive], true);
                        }
                        this.display.setCurrent((Displayable)this.menuDisk);
                        break;
                    }
                    case 3: {
                        this.configRead();
                        this.display.setCurrent((Displayable)this.menuSettings);
                        break;
                    }
                    case 4: {
                        this.about();
                    }
                }
            } else if (command.equals(this.exitCommand)) {
                this.midlet.exit();
            }
        } else if (displayable.equals(this.menuDisk)) {
            if (command.equals(this.selectCommand)) {
                MainMenu.diskSel[MainMenu.diskDrive] = this.menuDisk.getSelectedIndex();
                String string = this.menuDisk.getString(diskSel[diskDrive]);
                if (this.mountDisk("/Disks/" + string, diskDrive)) {
                    this.confirm(string + " selected");
                } else {
                    this.error("Error while loading " + string);
                }
            } else if (command.equals(this.backCommand)) {
                this.display.setCurrent((Displayable)this.menuOptions);
            }
        } else if (displayable.equals(this.menuSettings)) {
            if (command.equals(this.selectCommand)) {
                switch (this.menuSettings.getSelectedIndex()) {
                    case 0: {
                        this.menuPageOrientation.setSelectedIndex(this.canvas.getPageOrientation(), true);
                        this.display.setCurrent((Displayable)this.menuPageOrientation);
                        break;
                    }
                    case 1: {
                        this.menuColorMode.setSelectedIndex(this.canvas.getColorMode(), true);
                        this.display.setCurrent((Displayable)this.menuColorMode);
                        break;
                    }
                    case 2: {
                        this.menuNavKeys.setSelectedIndex(this.canvas.keyboard.getNavKeyMode(), true);
                        this.display.setCurrent((Displayable)this.menuNavKeys);
                        break;
                    }
                    case 3: {
                        this.menuJoystick.setSelectedIndex(this.apple.paddle.getPaddleMode(), true);
                        this.display.setCurrent((Displayable)this.menuJoystick);
                    }
                }
            } else if (command.equals(this.backCommand)) {
                this.display.setCurrent((Displayable)this.menuOptions);
            }
        } else if (displayable.equals(this.menuPageOrientation)) {
            if (command.equals(this.selectCommand)) {
                this.canvas.setPageOrientation(this.menuPageOrientation.getSelectedIndex());
                switch (this.canvas.getPageOrientation()) {
                    case 0: {
                        this.confirm("Portrait selected");
                        break;
                    }
                    case 1: {
                        this.confirm("Landscape selected");
                    }
                }
                this.configWrite();
            } else if (command.equals(this.backCommand)) {
                this.display.setCurrent((Displayable)this.menuSettings);
            }
        } else if (displayable.equals(this.menuColorMode)) {
            if (command.equals(this.selectCommand)) {
                this.canvas.setColorMode(this.menuColorMode.getSelectedIndex());
                switch (this.canvas.getColorMode()) {
                    case 0: {
                        this.confirm("Green selected");
                        break;
                    }
                    case 1: {
                        this.confirm("Colour selected");
                    }
                }
                this.configWrite();
            } else if (command.equals(this.backCommand)) {
                this.display.setCurrent((Displayable)this.menuSettings);
            }
        } else if (displayable.equals(this.menuNavKeys)) {
            if (command.equals(this.selectCommand)) {
                this.canvas.keyboard.setNavKeyMode(this.menuNavKeys.getSelectedIndex());
                switch (this.canvas.keyboard.getNavKeyMode()) {
                    case 0: {
                        this.confirm("Apple II keyboard selected");
                        break;
                    }
                    case 1: {
                        this.confirm("Joystick selected");
                    }
                }
                this.configWrite();
            } else if (command.equals(this.backCommand)) {
                this.display.setCurrent((Displayable)this.menuSettings);
            }
        } else if (displayable.equals(this.menuJoystick)) {
            if (command.equals(this.selectCommand)) {
                this.apple.paddle.setPaddleMode(this.menuJoystick.getSelectedIndex());
                switch (this.apple.paddle.getPaddleMode()) {
                    case 0: {
                        this.confirm("Analog selected");
                        break;
                    }
                    case 1: {
                        this.confirm("Digital selected");
                    }
                }
                this.configWrite();
            } else if (command.equals(this.backCommand)) {
                this.display.setCurrent((Displayable)this.menuSettings);
            }
        }
    }

    static {
        diskSel = new int[]{0, 0};
    }
}

