/*
 * Decompiled with CFR 0.152.
 */
import javax.microedition.lcdui.Alert;
import javax.microedition.lcdui.AlertType;
import javax.microedition.lcdui.Command;
import javax.microedition.lcdui.CommandListener;
import javax.microedition.lcdui.Display;
import javax.microedition.lcdui.Displayable;
import javax.microedition.midlet.MIDlet;

public class AppleIIGo
extends MIDlet
implements CommandListener {
    private Display display;
    private String errorString = null;
    private Alert errorBox;
    private EmAppleII apple;
    private AppleCanvas canvas;
    private MainMenu mainmenu;

    public AppleIIGo() {
        try {
            this.apple = new EmAppleII();
            boolean bl = this.apple.loadROM("/Resources/apple2e.rom");
            if (!bl) {
                bl = this.apple.loadROM("/Resources/APPLE2E.ROM");
            }
            if (!bl) {
                bl = this.apple.loadROM("/Resources/apple2p.rom");
            }
            if (!bl) {
                bl = this.apple.loadROM("/Resources/APPLE2P.ROM");
            }
            if (!bl) {
                bl = this.apple.loadROM("/Resources/apple2.rom");
            }
            if (!bl) {
                bl = this.apple.loadROM("/Resources/APPLE2.ROM");
            }
            if (!bl) {
                this.apple = null;
                this.errorString = "Apple II ROM \u043d\u0435 \u043c\u043e\u0436\u0435\u0442 \u0431\u044b\u0442\u044c \u0437\u0430\u0433\u0440\u0443\u0436\u0435\u043d.";
                return;
            }
        }
        catch (Throwable throwable) {
            this.errorString = "Emulator \u043e\u0431\u044a\u0435\u043a\u0442 \u043d\u0435 \u043c\u043e\u0436\u0435\u0442 \u0431\u044b\u0442\u044c \u0437\u0430\u043f\u0443\u0449\u0435\u043d:" + throwable.toString();
            return;
        }
        try {
            if (this.apple.disk != null) {
                this.apple.disk.initDrive(0, false);
                this.apple.disk.initDrive(1, false);
                if (!this.apple.disk.loadROM("/Resources/diskii.rom")) {
                    this.errorString = "Disk II ROM \u043d\u0435 \u043c\u043e\u0436\u0435\u0442 \u0431\u044b\u0442\u044c \u0437\u0430\u0433\u0440\u0443\u0436\u0435\u043d.";
                }
            }
        }
        catch (Throwable throwable) {
            this.errorString = "Disk II \u043e\u0431\u044a\u0435\u043a\u0442 \u043d\u0435 \u043c\u043e\u0436\u0435\u0442 \u0431\u044b\u0442\u044c \u0437\u0430\u043f\u0443\u0449\u0435\u043d:" + throwable.toString();
            return;
        }
        try {
            if (this.apple.prodosClock != null && !this.apple.prodosClock.loadROM("/Resources/clock.rom")) {
                this.errorString = "ProDOS Clock ROM \u043d\u0435 \u043c\u043e\u0436\u0435\u0442 \u0431\u044b\u0442\u044c \u0437\u0430\u0433\u0440\u0443\u0436\u0435\u043d.";
            }
        }
        catch (Throwable throwable) {
            this.errorString = "ProDOS Clock \u043e\u0431\u044a\u0435\u043a\u0442 \u043d\u0435 \u043c\u043e\u0436\u0435\u0442 \u0431\u044b\u0442\u044c \u0437\u0430\u043f\u0443\u0449\u0435\u043d:" + throwable.toString();
            return;
        }
    }

    public void exit() {
        this.destroyApp(false);
        this.notifyDestroyed();
    }

    public void commandAction(Command command, Displayable displayable) {
        if (command == Alert.DISMISS_COMMAND) {
            if (this.mainmenu != null) {
                this.mainmenu.show();
            } else {
                this.exit();
            }
        }
    }

    protected void startApp() {
        this.display = Display.getDisplay((MIDlet)this);
        try {
            if (this.canvas == null && this.apple != null) {
                this.canvas = new AppleCanvas(this.display, this.apple);
            }
        }
        catch (Throwable throwable) {
            this.errorString = "Canvas \u043d\u0435 \u043c\u043e\u0436\u0435\u0442 \u0431\u044b\u0442\u044c \u0437\u0430\u043f\u0443\u0449\u0435\u043d:" + throwable.toString();
        }
        try {
            if (this.mainmenu == null && this.canvas != null) {
                this.mainmenu = new MainMenu(this, this.display, this.apple, this.canvas);
            }
        }
        catch (Throwable throwable) {
            this.errorString = "Main menu \u043d\u0435 \u043c\u043e\u0436\u0435\u0442 \u0431\u044b\u0442\u044c \u0437\u0430\u043f\u0443\u0449\u0435\u043d:" + throwable.toString();
        }
        if (this.errorString != null) {
            this.errorBox = new Alert(null, this.errorString, null, this.mainmenu == null ? AlertType.ERROR : AlertType.WARNING);
            this.errorBox.setTimeout(-2);
            this.errorBox.setCommandListener((CommandListener)this);
            this.display.setCurrent((Displayable)this.errorBox);
        } else if (this.mainmenu != null) {
            this.mainmenu.show();
        }
    }

    protected void pauseApp() {
    }

    protected void destroyApp(boolean bl) {
    }
}

