/*
 * Decompiled with CFR 0.152.
 */
import java.io.IOException;
import java.io.InputStream;
import java.util.Calendar;

public class ProDOSClock
extends Peripheral {
    int clockResultMode = 0;
    int clockResultPos = 0;
    int[] clockResultProdos = new int[4];
    String clockResultString = "";

    public ProDOSClock(EmAppleII emAppleII, int n) {
        super(emAppleII, n);
    }

    private String zeroPad(String string, int n) {
        n -= string.length();
        while (n > 0) {
            string = "0" + string;
            --n;
        }
        return string;
    }

    private void updateClock(int n) {
        Calendar calendar = Calendar.getInstance();
        int n2 = calendar.get(1) % 100;
        int n3 = calendar.get(2) + 1;
        int n4 = calendar.get(5);
        int n5 = calendar.get(7);
        int n6 = calendar.get(11);
        int n7 = calendar.get(12);
        int n8 = calendar.get(13);
        this.clockResultString = this.zeroPad(Integer.toString(n3), 2) + "," + this.zeroPad(Integer.toString(n5), 2) + "," + this.zeroPad(Integer.toString(n4), 2) + "," + this.zeroPad(Integer.toString(n6), 2) + "," + this.zeroPad(Integer.toString(n7), 2) + "," + this.zeroPad(Integer.toString(n8), 2);
        this.clockResultProdos[0] = (n4 & 0x1F) + ((n3 & 7) << 5);
        this.clockResultProdos[1] = ((n2 & 0x7F) << 1) + ((n3 & 8) >> 1);
        this.clockResultProdos[2] = n7 & 0xFF;
        this.clockResultProdos[3] = n6 & 0xFF;
        this.clockResultPos = 0;
        this.clockResultMode = n;
    }

    public int ioRead(int n) {
        switch (n & 0xF) {
            case 0: {
                this.updateClock(0);
                break;
            }
            case 1: {
                this.updateClock(1);
                break;
            }
            case 2: {
                switch (this.clockResultMode) {
                    case 0: {
                        if (this.clockResultPos >= this.clockResultString.length()) break;
                        char c = this.clockResultString.charAt(this.clockResultPos);
                        ++this.clockResultPos;
                        return c;
                    }
                    case 1: {
                        if (this.clockResultPos >= 4) break;
                        int n2 = this.clockResultProdos[this.clockResultPos];
                        ++this.clockResultPos;
                        return n2;
                    }
                }
                return 0;
            }
        }
        return this.apple.noise();
    }

    public void ioWrite(int n, int n2) {
        this.ioRead(n);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean loadROM(String string) {
        boolean bl = false;
        InputStream inputStream = this.getClass().getResourceAsStream(string);
        if (inputStream == null) {
            return bl;
        }
        try {
            inputStream.read(this.apple.mem, 147456 + (this.slot << 8), 256);
            bl = true;
        }
        catch (IOException iOException) {
        }
        finally {
            try {
                inputStream.close();
            }
            catch (IOException iOException) {}
        }
        return bl;
    }
}

