/*
 * Decompiled with CFR 0.152.
 */
import javax.microedition.lcdui.Display;

public class Keyboard {
    public static final int NAVKEY_KEYBOARD_APPLEII = 0;
    public static final int NAVKEY_JOYSTICK = 1;
    private static final int KEYBOARD_DELAY = 500;
    private static final int DIRECT_DELAY = 200;
    private Display display;
    private AppleCanvas canvas;
    private EmAppleII apple;
    private KeyboardPalette keyboardPalette;
    private boolean mkSel = false;
    private boolean mkPressed = false;
    private long mkTime;
    private String mkString = "";
    private int mkKey;
    private int mkIndex = 0;
    private int navKeyMode = 0;
    private boolean altSel = false;

    public Keyboard(Display display, AppleCanvas appleCanvas, EmAppleII emAppleII) {
        this.display = display;
        this.canvas = appleCanvas;
        this.apple = emAppleII;
        this.keyboardPalette = new KeyboardPalette(display, emAppleII);
    }

    public void setNavKeyMode(int n) {
        this.navKeyMode = n;
    }

    public int getNavKeyMode() {
        return this.navKeyMode;
    }

    public int update() {
        if (this.mkSel) {
            if (System.currentTimeMillis() > this.mkTime) {
                return this.mkFlush();
            }
            return this.mkChar();
        }
        return 0;
    }

    private void altPressed() {
        this.altSel = true;
    }

    private void altReleased() {
        this.altSel = false;
    }

    private int mkChar() {
        return this.mkString.charAt(this.mkIndex);
    }

    private int mkFlush() {
        if (this.mkSel) {
            int n = this.mkPressed ? this.mkKey : this.mkChar();
            this.apple.keyPressed(n);
            this.mkSel = false;
            return n;
        }
        return 0;
    }

    private void mkDirect(int n) {
        this.mkTime = System.currentTimeMillis() + 200L;
        if (this.mkSel) {
            char[] cArray = new char[1];
            this.mkFlush();
            cArray[0] = (char)n;
            this.mkSel = true;
            this.mkString = new String(cArray);
            this.mkIndex = 0;
        } else {
            this.apple.keyPressed(n);
        }
    }

    private void mkPressed(String string, char c) {
        this.mkTime = System.currentTimeMillis() + 500L;
        if (this.mkSel) {
            if (string.equals(this.mkString)) {
                ++this.mkIndex;
                if (this.mkIndex >= this.mkString.length()) {
                    this.mkIndex = 0;
                }
                return;
            }
            this.mkFlush();
        }
        this.mkSel = true;
        this.mkPressed = true;
        this.mkKey = c;
        this.mkString = string;
        this.mkIndex = 0;
    }

    private void mkReleased() {
        this.mkPressed = false;
    }

    public void keyPressed(int n, int n2) {
        if (n == 42) {
            this.keyboardPalette.show();
            return;
        }
        if (n >= 32) {
            if (!this.altSel) {
                switch (n) {
                    case 48: {
                        this.mkPressed(" 0", '0');
                        return;
                    }
                    case 49: {
                        this.mkPressed(".,1:;?!", '1');
                        return;
                    }
                    case 50: {
                        this.mkPressed("ABC2\"", '2');
                        return;
                    }
                    case 51: {
                        this.mkPressed("DEF3#", '3');
                        return;
                    }
                    case 52: {
                        this.mkPressed("GHI4$", '4');
                        return;
                    }
                    case 53: {
                        this.mkPressed("JKL5%", '5');
                        return;
                    }
                    case 54: {
                        this.mkPressed("MNO6&^", '6');
                        return;
                    }
                    case 55: {
                        this.mkPressed("PQRS7'@", '7');
                        return;
                    }
                    case 56: {
                        this.mkPressed("TUV8(", '8');
                        return;
                    }
                    case 57: {
                        this.mkPressed("WXYZ9)", '9');
                        return;
                    }
                    case 35: {
                        this.mkPressed("+-*/=<>", '=');
                        return;
                    }
                }
                this.mkDirect(n);
                return;
            }
            this.canvas.togglePage();
            switch (n) {
                case 49: {
                    this.canvas.toggleStatInfo();
                    return;
                }
                case 50: {
                    this.apple.toggleDebugMode();
                    return;
                }
            }
            return;
        }
        if (this.canvas.getPageRotation()) {
            switch (n2) {
                case 2: {
                    n2 = 6;
                    break;
                }
                case 5: {
                    n2 = 1;
                    break;
                }
                case 1: {
                    n2 = 2;
                    break;
                }
                case 6: {
                    n2 = 5;
                }
            }
        }
        if (this.navKeyMode != 0 || this.altSel) {
            switch (n2) {
                case 2: {
                    this.apple.paddle.setPaddle(0, -1);
                    return;
                }
                case 5: {
                    this.apple.paddle.setPaddle(0, 1);
                    return;
                }
                case 1: {
                    this.apple.paddle.setPaddle(1, -1);
                    return;
                }
                case 6: {
                    this.apple.paddle.setPaddle(1, 1);
                    return;
                }
                case 8: {
                    this.apple.paddle.setButton(0, true);
                    return;
                }
            }
        } else {
            switch (n2) {
                case 2: {
                    this.mkDirect(8);
                    return;
                }
                case 5: {
                    this.mkDirect(21);
                    return;
                }
                case 1: {
                    this.mkDirect(11);
                    return;
                }
                case 6: {
                    this.mkDirect(10);
                    return;
                }
                case 8: {
                    this.mkDirect(13);
                    return;
                }
            }
        }
        switch (n) {
            case -22: 
            case -20: 
            case -8: 
            case -6: 
            case -1: 
            case 21: 
            case 23: {
                if (this.navKeyMode == 0) {
                    this.altPressed();
                    this.canvas.togglePage();
                    this.mkFlush();
                    this.apple.debugNextStep();
                    break;
                }
                this.apple.paddle.setButton(1, true);
                break;
            }
            case -21: 
            case -7: 
            case 4: 
            case 22: {
                if (this.altSel) {
                    this.apple.paddle.setButton(1, true);
                    break;
                }
                this.canvas.back();
            }
        }
    }

    public void keyReleased(int n, int n2) {
        if (n >= 32 && !this.altSel) {
            this.mkReleased();
        }
        if (this.canvas.getPageRotation()) {
            switch (n2) {
                case 2: {
                    n2 = 6;
                    break;
                }
                case 5: {
                    n2 = 1;
                    break;
                }
                case 1: {
                    n2 = 2;
                    break;
                }
                case 6: {
                    n2 = 5;
                }
            }
        }
        if (this.navKeyMode != 0 || this.altSel) {
            switch (n2) {
                case 2: 
                case 5: {
                    this.apple.paddle.setPaddle(0, 0);
                    return;
                }
                case 1: 
                case 6: {
                    this.apple.paddle.setPaddle(1, 0);
                    return;
                }
                case 8: {
                    this.apple.paddle.setButton(0, false);
                    return;
                }
            }
        }
        switch (n) {
            case -22: 
            case -20: 
            case -8: 
            case -6: 
            case -1: 
            case 21: 
            case 23: {
                if (this.navKeyMode == 0) {
                    this.altReleased();
                    this.apple.paddle.setPaddle(0, 0);
                    this.apple.paddle.setPaddle(1, 0);
                    this.apple.paddle.setButton(0, false);
                    this.apple.paddle.setButton(1, false);
                    break;
                }
                this.apple.paddle.setButton(1, false);
                break;
            }
            case -21: 
            case -7: 
            case 4: 
            case 22: {
                if (!this.altSel) break;
                this.apple.paddle.setButton(1, true);
            }
        }
    }
}

