/*
 * Decompiled with CFR 0.152.
 */
package de.joergjahnke.c64.jme;

import de.joergjahnke.c64.core.C1541;
import de.joergjahnke.c64.core.C64;
import de.joergjahnke.c64.jme.C64Canvas;
import de.joergjahnke.c64.smalldisplays.SmoothingScalableVIC6569;
import de.joergjahnke.common.jme.ButtonAssignmentCanvas;
import de.joergjahnke.common.jme.CollectionUtils;
import de.joergjahnke.common.jme.FileBrowser;
import de.joergjahnke.common.jme.FileSystemHandler;
import de.joergjahnke.common.jme.FormattedTextForm;
import de.joergjahnke.common.jme.ImageUtils;
import de.joergjahnke.common.jme.LocalizationSupport;
import de.joergjahnke.common.jme.Menu;
import de.joergjahnke.common.jme.MenuListener;
import de.joergjahnke.common.jme.OrientationSensitiveCanvasHelper;
import de.joergjahnke.common.jme.PCMtoMIDIPlayer;
import de.joergjahnke.common.jme.ProgressForm;
import de.joergjahnke.common.jme.Settings;
import de.joergjahnke.common.jme.WavePlayer;
import de.joergjahnke.common.vmabstraction.sunvm.SunVMResourceLoader;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Calendar;
import java.util.Date;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import javax.microedition.io.Connector;
import javax.microedition.lcdui.Alert;
import javax.microedition.lcdui.AlertType;
import javax.microedition.lcdui.ChoiceGroup;
import javax.microedition.lcdui.Command;
import javax.microedition.lcdui.CommandListener;
import javax.microedition.lcdui.Display;
import javax.microedition.lcdui.Displayable;
import javax.microedition.lcdui.Font;
import javax.microedition.lcdui.Form;
import javax.microedition.lcdui.Image;
import javax.microedition.lcdui.Item;
import javax.microedition.lcdui.ItemCommandListener;
import javax.microedition.lcdui.ItemStateListener;
import javax.microedition.lcdui.List;
import javax.microedition.lcdui.Spacer;
import javax.microedition.lcdui.StringItem;
import javax.microedition.lcdui.TextField;
import javax.microedition.midlet.MIDlet;
import javax.microedition.rms.RecordStore;
import javax.microedition.rms.RecordStoreException;

public class MEC64MIDlet
extends MIDlet
implements CommandListener,
MenuListener {
    private static final String SETTING_FILESEARCH_STARTDIR = "FileSearchStartDir";
    public static final String SETTING_ACCELEROMETER = "Accelerometer";
    public static final String SETTING_LANGUAGE = "Language";
    protected static final String SETTING_SOUNDACTIVE = "SoundActive";
    public static final String SETTING_AUTO_ROTATE = "AutoRotateScreen";
    public static final String SETTING_SNAPSHOTS = "Snapshots";
    public static final String SETTING_PREFIX_KEYS = "Key_";
    private static final String SUSPENDDATA_SUFFIX = "_SuspendData";
    private static final char SNAPSHOT_NAME_DELIMITER = '\n';
    private static final String[] JOYSTICK_KEYS = new String[]{"Up", "Up & Right", "Right", "Down & Right", "Down", "Down & Left", "Left", "Up & Left", "Fire"};
    private static final String[] SUPPORTED_LOCALES = new String[]{"Device default", "de", "en", "es", "fr", "it", "ru", "zh_CN"};
    private static final String PROJECT_PAGE_URL = "https://sourceforge.net/projects/jmec64/";
    private static final int STATUS_LOAD_OK = 0;
    private static final int STATUS_LOAD_FAILED = 1;
    private static final int STATUS_NOTHING_LOADED = 2;
    private static final int SNAPSHOT_PROGRAMNAME_LENGTH = 18;
    private static final String NO_IMAGE = "<no image>";
    private static final int NUM_DRIVES = 2;
    protected static final String SNAPSHOT_EXTENSION = ".snapshot";
    private static Image floppyImage = null;
    protected static Image snapshotImage = null;
    private final Hashtable programs = new Hashtable();
    protected C64Canvas c64Canvas = null;
    private C64 c64 = null;
    private String fileSearchStartDir;
    private FileSystemHandler fileSystemHandler;
    private Settings settings = null;
    private Hashtable attachedImages = new Hashtable();
    private final String typeMenuText;
    private final String specialKeysMenuText;
    private final String attachImageMenuText;
    private final String detachImageMenuText;
    private final String selectDriveMenuText;
    private final String searchProgramsMenuText;
    private final String runMenuText;
    protected final String resetMenuText;
    private final String editSettingsMenuText;
    private final String assignKeysMenuText;
    private final String showLogMenuText;
    private final String aboutMenuText;
    private final String helpMenuText;
    private final String snapshotMenuText;
    private final String suspendMenuText;
    private final String exitMenuText;
    private final Command fastLoadRunProgramCommand;
    private final Command fastLoadProgramCommand;
    private final Command loadProgramCommand;
    private final Command fastAutoStartCommand;
    private final Command autoStartCommand;
    protected final Command okCommand;
    private final Command okEnterCommand;
    protected final Command backCommand;
    private final Command browseCommand;
    private final Command removeCommand;
    private final Command menuCommand;
    private final Command closeCommand;
    protected final Command cancelCommand;
    protected final Menu mainMenu;

    public MEC64MIDlet() {
        try {
            this.settings = new Settings(this.getAppProperty("MIDlet-Name"));
        }
        catch (Exception e) {
            // empty catch block
        }
        String locale = this.getLocale();
        LocalizationSupport.initLocalizationSupport(locale, "/res/l10n/commonMessages.properties");
        LocalizationSupport.initLocalizationSupport(locale, "/res/l10n/c64EmulatorMessages.properties");
        this.typeMenuText = LocalizationSupport.getMessage("TypeText");
        this.specialKeysMenuText = LocalizationSupport.getMessage("SpecialKeys");
        this.attachImageMenuText = LocalizationSupport.getMessage("LoadImage");
        this.detachImageMenuText = LocalizationSupport.getMessage("DetachAll");
        this.selectDriveMenuText = LocalizationSupport.getMessage("SelectDrive");
        this.searchProgramsMenuText = LocalizationSupport.getMessage("SearchPrograms");
        this.runMenuText = LocalizationSupport.getMessage("RunCurrent");
        this.resetMenuText = LocalizationSupport.getMessage("ResetC64");
        this.editSettingsMenuText = LocalizationSupport.getMessage("EditSettings");
        this.assignKeysMenuText = LocalizationSupport.getMessage("AssignKeys");
        this.showLogMenuText = LocalizationSupport.getMessage("ShowLog");
        this.aboutMenuText = LocalizationSupport.getMessage("About");
        this.helpMenuText = LocalizationSupport.getMessage("Help");
        this.snapshotMenuText = LocalizationSupport.getMessage("SaveSnapshot");
        this.suspendMenuText = LocalizationSupport.getMessage("SuspendAndExit");
        this.exitMenuText = LocalizationSupport.getMessage("Exit");
        this.fastLoadRunProgramCommand = new Command(LocalizationSupport.getMessage("FastLoadRun"), LocalizationSupport.getMessage("FastLoadRunProgram"), 8, 1);
        this.fastLoadProgramCommand = new Command(LocalizationSupport.getMessage("FastLoad"), LocalizationSupport.getMessage("FastLoadProgram"), 8, 2);
        this.loadProgramCommand = new Command(LocalizationSupport.getMessage("Load"), LocalizationSupport.getMessage("LoadProgram"), 8, 3);
        this.fastAutoStartCommand = new Command(LocalizationSupport.getMessage("FastAutoStart"), LocalizationSupport.getMessage("FastAutoStart"), 8, 2);
        this.autoStartCommand = new Command(LocalizationSupport.getMessage("AutoStart"), LocalizationSupport.getMessage("AutoStart"), 8, 3);
        this.okCommand = new Command(LocalizationSupport.getMessage("OK"), 4, 1);
        this.okEnterCommand = new Command(LocalizationSupport.getMessage("OKEnter"), 4, 2);
        this.backCommand = new Command(LocalizationSupport.getMessage("Back"), 2, 99);
        this.browseCommand = new Command(LocalizationSupport.getMessage("Browse"), 8, 2);
        this.removeCommand = new Command(LocalizationSupport.getMessage("Remove"), 8, 2);
        this.menuCommand = new Command(LocalizationSupport.getMessage("Menu"), 8, 1);
        this.closeCommand = new Command(LocalizationSupport.getMessage("Close"), 2, 98);
        this.cancelCommand = new Command(LocalizationSupport.getMessage("Cancel"), 2, 98);
        this.mainMenu = new Menu(this.getAppProperty("MIDlet-Name"));
        this.mainMenu.addItem(this.attachImageMenuText, this.getMenuIcon("attach_sm.png"));
        this.mainMenu.addItem(this.typeMenuText, this.getMenuIcon("typetext_sm.png"));
        this.mainMenu.addItem(this.specialKeysMenuText, this.getMenuIcon("keyboard_sm.png"));
        this.mainMenu.addItem(this.selectDriveMenuText, this.getMenuIcon("drive_sm.png"));
        this.mainMenu.addItem(this.runMenuText, this.getMenuIcon("play_sm.png"));
        this.mainMenu.addItem(this.resetMenuText, this.getMenuIcon("reset_sm.png"));
        this.mainMenu.addItem(this.snapshotMenuText, this.getMenuIcon("snapshot.png"));
        if (this.supportsFileConnectionAPI()) {
            this.mainMenu.addItem(this.searchProgramsMenuText, this.getMenuIcon("search_sm.png"));
        }
        this.mainMenu.addItem(this.editSettingsMenuText, this.getMenuIcon("settings_sm.png"));
        this.mainMenu.addItem(this.assignKeysMenuText, this.getMenuIcon("joystick_sm.png"));
        this.mainMenu.addItem(this.aboutMenuText, this.getMenuIcon("about_sm.png"));
        this.mainMenu.addItem(this.helpMenuText, this.getMenuIcon("help_sm.png"));
        this.mainMenu.addItem(this.showLogMenuText, this.getMenuIcon("log_sm.png"));
        this.mainMenu.addItem(this.suspendMenuText, this.getMenuIcon("suspend_sm.png"));
        this.mainMenu.addItem(this.exitMenuText, this.getMenuIcon("exit_sm.png"));
        this.mainMenu.setMenuListener(this);
        try {
            this.c64 = new C64(new SunVMResourceLoader(), 2);
            this.c64Canvas = new C64Canvas(this);
            this.c64Canvas.setC64(this.c64);
            this.c64Canvas.calculateScreenSize();
            this.c64Canvas.setCommandListener(this);
            Display.getDisplay((MIDlet)this).setCurrent((Displayable)this.c64Canvas);
            this.c64Canvas.addCommand(this.menuCommand);
            try {
                if (this.settings.exists(SETTING_PREFIX_KEYS + JOYSTICK_KEYS[0])) {
                    this.c64Canvas.setUseAccelerometer(this.settings.getBoolean(SETTING_ACCELEROMETER, this.c64Canvas.isUseAccelerometer()));
                    this.c64Canvas.setAutoChangeOrientation(this.settings.getBoolean(SETTING_AUTO_ROTATE, this.c64Canvas.isAutoChangeOrientation()));
                    Hashtable<Integer, String> assignments = new Hashtable<Integer, String>();
                    for (int i = 0; i < JOYSTICK_KEYS.length; ++i) {
                        assignments.put(new Integer(this.settings.getInteger(SETTING_PREFIX_KEYS + JOYSTICK_KEYS[i])), JOYSTICK_KEYS[i]);
                    }
                    this.c64Canvas.setButtonAssignments(assignments);
                    this.setSound(this.settings.getBoolean(SETTING_SOUNDACTIVE, false));
                }
            }
            catch (Exception e) {
                // empty catch block
            }
            this.programs.clear();
            try {
                CollectionUtils.putAll(this.programs, this.readProgramListFromTextFile());
            }
            catch (Exception e) {
                // empty catch block
            }
            if (this.supportsFileConnectionAPI()) {
                for (int i = 0; i < this.c64.getDriveCount(); ++i) {
                    this.c64.getDrive(i).addObserver(this.c64Canvas);
                }
                this.fileSystemHandler = new FileSystemHandler(this.c64.getLogger(), C1541.SUPPORTED_EXTENSIONS, this.settings);
                CollectionUtils.putAll(this.programs, this.fileSystemHandler.getCachedProgramList());
            }
            if (null == floppyImage) {
                try {
                    floppyImage = Image.createImage((String)"/res/drawable/floppy.png");
                }
                catch (Exception e) {
                    // empty catch block
                }
            }
            this.resume();
            new Thread(this.c64).start();
        }
        catch (Throwable t) {
            t.printStackTrace();
            throw new RuntimeException(LocalizationSupport.getMessage("CouldNotInitialize") + t);
        }
        if (null == floppyImage) {
            try {
                floppyImage = Image.createImage((String)"/res/drawable/floppy.png");
            }
            catch (Exception e) {
                // empty catch block
            }
        }
        if (null == snapshotImage) {
            try {
                snapshotImage = Image.createImage((String)"/res/drawable/snapshot.png");
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public Settings getSettings() {
        return this.settings;
    }

    private String getLocale() {
        String locale = System.getProperty("microedition.locale");
        try {
            locale = this.settings.getString(SETTING_LANGUAGE, locale);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return locale;
    }

    protected Image getMenuIcon(String filename) {
        try {
            return ImageUtils.scale(Image.createImage((String)("/res/drawable/" + filename)), 16, 16, true);
        }
        catch (Exception e) {
            return null;
        }
    }

    public void startApp() {
        this.c64.resume();
    }

    public void pauseApp() {
        this.c64.pause();
        this.notifySoundPlayer(PCMtoMIDIPlayer.SIGNAL_PAUSE);
    }

    public void destroyApp(boolean unconditional) {
        this.c64.stop();
        this.notifySoundPlayer(PCMtoMIDIPlayer.SIGNAL_STOP);
    }

    private void notifySoundPlayer(Object signal) {
        if (null != this.c64.getSID() && this.c64.getSID().countObservers() > 0) {
            this.c64.getSID().setChanged(true);
            this.c64.getSID().notifyObservers(signal);
        }
    }

    private final boolean supportsFileConnectionAPI() {
        return null != System.getProperty("microedition.io.file.FileConnection.version");
    }

    private void runProgram() {
        this.c64.getKeyboard().textTyped("run");
        this.c64.getKeyboard().keyTyped("ENTER");
    }

    protected Vector getSnapshots() {
        Vector<String> result = new Vector<String>();
        String snapshots = this.getSettings().getString(SETTING_SNAPSHOTS, null);
        if (null != snapshots) {
            int index = 0;
            while (index < snapshots.length()) {
                int newIndex = snapshots.indexOf(10, index);
                result.addElement(snapshots.substring(index, newIndex));
                index = newIndex + 1;
            }
        }
        return result;
    }

    protected Vector getSnapshots(String program, Vector snapshotList) {
        int to;
        Vector<String> result = new Vector<String>();
        String search = program.substring(0, Math.min(program.length(), 18));
        int n = to = snapshotList == null ? 0 : snapshotList.size();
        for (int i = 0; i < to; ++i) {
            String name = snapshotList.elementAt(i).toString();
            if (!name.startsWith(search)) continue;
            result.addElement(name);
        }
        return result;
    }

    protected void setSnapshots(Vector snapshotList) throws RecordStoreException {
        if (null != snapshotList) {
            StringBuffer snapshots = new StringBuffer();
            int to = snapshotList.size();
            for (int i = 0; i < to; ++i) {
                snapshots.append(snapshotList.elementAt(i));
                snapshots.append('\n');
            }
            this.getSettings().setString(SETTING_SNAPSHOTS, snapshots.toString());
        } else {
            this.getSettings().remove(SETTING_SNAPSHOTS);
        }
    }

    private void saveState(String name) throws IOException, RecordStoreException {
        RecordStore rs = RecordStore.openRecordStore((String)name, (boolean)true);
        ByteArrayOutputStream os = new ByteArrayOutputStream();
        DataOutputStream out = new DataOutputStream(os);
        out.writeInt(this.attachedImages.size());
        Enumeration en = this.attachedImages.keys();
        while (en.hasMoreElements()) {
            Integer driveNo = (Integer)en.nextElement();
            out.writeInt(driveNo);
            out.writeUTF(this.attachedImages.get(driveNo).toString());
        }
        this.c64.serialize(out);
        out.flush();
        rs.addRecord(os.toByteArray(), 0, os.size());
        out.close();
        os.close();
        rs.closeRecordStore();
    }

    private void saveSnapshot() {
        this.pauseApp();
        Calendar cal = Calendar.getInstance();
        cal.setTime(new Date());
        Object attachedImage = this.attachedImages.get(new Integer(this.c64.getActiveDrive()));
        String currentImage = attachedImage == null ? NO_IMAGE : attachedImage.toString();
        String name = currentImage.substring(0, Math.min(currentImage.length(), 18)) + "@" + this.formatForSnapshot(cal.get(1)) + this.formatForSnapshot(cal.get(2) + 1) + this.formatForSnapshot(cal.get(5)) + "-" + this.formatForSnapshot(cal.get(11)) + this.formatForSnapshot(cal.get(12)) + this.formatForSnapshot(cal.get(13));
        try {
            this.saveState(name);
            Vector snapshots = this.getSnapshots();
            snapshots.addElement(name);
            this.setSnapshots(snapshots);
        }
        catch (Throwable t) {
            try {
                RecordStore.deleteRecordStore((String)name);
            }
            catch (Throwable t2) {
                // empty catch block
            }
            Display.getDisplay((MIDlet)this).setCurrent((Displayable)new Alert(LocalizationSupport.getMessage("SavingSnapshotFailed"), LocalizationSupport.getMessage("FailedToStoreState"), null, AlertType.WARNING));
            t.printStackTrace();
        }
        this.startApp();
    }

    private String formatForSnapshot(int n) {
        String s = "0" + n;
        return s.substring(s.length() - 2);
    }

    private void suspend() {
        this.pauseApp();
        boolean reallyExit = true;
        try {
            this.saveState(this.getAppProperty("MIDlet-Name") + SUSPENDDATA_SUFFIX);
        }
        catch (Throwable t) {
            Display.getDisplay((MIDlet)this).setCurrent((Displayable)new Alert(LocalizationSupport.getMessage("SuspendFailed"), LocalizationSupport.getMessage("FailedToStoreState"), null, AlertType.WARNING));
            t.printStackTrace();
            reallyExit = false;
            this.startApp();
        }
        if (reallyExit) {
            this.exit();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int loadState(String name) {
        int status = 0;
        Display display = Display.getDisplay((MIDlet)this);
        ProgressForm progressForm = new ProgressForm(LocalizationSupport.getMessage("Resuming"));
        boolean hasSuspendData = false;
        RecordStore rs = null;
        try {
            rs = RecordStore.openRecordStore((String)name, (boolean)false);
            byte[] bytes = rs.getRecord(1);
            hasSuspendData = true;
            DataInputStream in = new DataInputStream(new ByteArrayInputStream(bytes));
            bytes = null;
            display.setCurrent((Displayable)progressForm);
            int size = in.readInt();
            for (int i = 0; i < size; ++i) {
                int driveNo = in.readInt();
                String program = in.readUTF();
                this.attachImage(driveNo, program);
                progressForm.update(this, new Integer((i + 1) * 100 / size));
            }
            this.c64.deserialize(in);
            in.close();
            rs.closeRecordStore();
            progressForm.update(this, new Integer(100));
        }
        catch (Throwable t) {
            if (hasSuspendData) {
                status = 1;
                t.printStackTrace();
            } else {
                status = 2;
            }
        }
        finally {
            if (hasSuspendData) {
                try {
                    rs.closeRecordStore();
                }
                catch (Exception e) {}
            }
            display.setCurrent((Displayable)this.c64Canvas);
        }
        return status;
    }

    private void runSnapshot(final String name) {
        final Display display = Display.getDisplay((MIDlet)this);
        Thread loader = new Thread(){

            public void run() {
                switch (MEC64MIDlet.this.loadState(name)) {
                    case 1: {
                        display.setCurrent(new Alert(LocalizationSupport.getMessage("LoadSnapshotFailed"), LocalizationSupport.getMessage("FailedToRestoreState"), null, AlertType.WARNING), (Displayable)MEC64MIDlet.this.c64Canvas);
                        break;
                    }
                }
                MEC64MIDlet.this.c64.resume();
            }
        };
        loader.start();
    }

    private void runGame(final String image, final Command c) {
        final Display display = Display.getDisplay((MIDlet)this);
        display.callSerially(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void run() {
                try {
                    MEC64MIDlet.this.attachImage(MEC64MIDlet.this.c64.getActiveDrive(), image);
                    if (MEC64MIDlet.this.mainMenu.getMenuPosition(MEC64MIDlet.this.detachImageMenuText) < 0) {
                        MEC64MIDlet.this.mainMenu.insertItem(MEC64MIDlet.this.detachImageMenuText, MEC64MIDlet.this.getMenuIcon("detach_sm.png"), MEC64MIDlet.this.mainMenu.getMenuPosition(MEC64MIDlet.this.attachImageMenuText) + 1);
                    }
                    if (c == MEC64MIDlet.this.okCommand) {
                        MEC64MIDlet.this.showProgramList();
                    } else if (c == MEC64MIDlet.this.autoStartCommand) {
                        MEC64MIDlet.this.c64.getKeyboard().textTyped("load \"*\",8,1");
                        MEC64MIDlet.this.c64.getKeyboard().keyTyped("ENTER");
                        MEC64MIDlet.this.runProgram();
                    } else if (c == MEC64MIDlet.this.fastAutoStartCommand) {
                        MEC64MIDlet.this.c64.fastLoadFile("*", -1);
                        MEC64MIDlet.this.runProgram();
                    }
                }
                catch (Exception e) {
                    display.setCurrent((Displayable)new Alert(LocalizationSupport.getMessage("FailedToLoad"), LocalizationSupport.getMessage("FailedToLoad") + ": " + image, null, AlertType.WARNING));
                    e.printStackTrace();
                }
                finally {
                    MEC64MIDlet.this.c64.resume();
                }
            }
        });
    }

    private void resume() {
        final Display display = Display.getDisplay((MIDlet)this);
        final String name = this.getAppProperty("MIDlet-Name") + SUSPENDDATA_SUFFIX;
        Thread loader = new Thread(){

            public void run() {
                int status = MEC64MIDlet.this.loadState(name);
                if (status == 1 || status == 0) {
                    try {
                        RecordStore.deleteRecordStore((String)name);
                    }
                    catch (Exception e) {
                        display.setCurrent((Displayable)new Alert(LocalizationSupport.getMessage("CouldNotRemoveSuspendData"), LocalizationSupport.getMessage("FailedToRemoveSuspendData"), null, AlertType.WARNING));
                        e.printStackTrace();
                    }
                }
                switch (status) {
                    case 1: {
                        display.setCurrent(new Alert(LocalizationSupport.getMessage("ResumeFailed"), LocalizationSupport.getMessage("FailedToRestoreState"), null, AlertType.WARNING), (Displayable)MEC64MIDlet.this.c64Canvas);
                        break;
                    }
                    case 0: {
                        break;
                    }
                }
            }
        };
        loader.start();
    }

    private void exit() {
        this.c64.stop();
        this.destroyApp(false);
        this.notifyDestroyed();
    }

    private void showAssignButtonsCanvas() {
        Display display = Display.getDisplay((MIDlet)this);
        final Vector<String> buttons = new Vector<String>();
        for (int i = 0; i < JOYSTICK_KEYS.length; ++i) {
            buttons.addElement(JOYSTICK_KEYS[i]);
        }
        ButtonAssignmentCanvas buttonAssignmentCanvas = new ButtonAssignmentCanvas(display, buttons){

            public void onFinished() {
                super.onFinished();
                if (this.getState() == 4) {
                    MEC64MIDlet.this.c64Canvas.setButtonAssignments(this.getAssignments());
                    try {
                        for (int i = 0; i < buttons.size(); ++i) {
                            try {
                                MEC64MIDlet.this.settings.remove(MEC64MIDlet.SETTING_PREFIX_KEYS + buttons.elementAt(i).toString());
                                continue;
                            }
                            catch (IllegalArgumentException e) {
                                // empty catch block
                            }
                        }
                        Enumeration en = this.getAssignments().keys();
                        while (en.hasMoreElements()) {
                            Integer key = (Integer)en.nextElement();
                            MEC64MIDlet.this.settings.setInteger(MEC64MIDlet.SETTING_PREFIX_KEYS + this.getAssignments().get(key).toString(), key);
                        }
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
            }
        };
        display.setCurrent((Displayable)buttonAssignmentCanvas);
    }

    private void showLogForm() {
        Form log = new Form(LocalizationSupport.getMessage("LogMessages"));
        StringItem logItem = new StringItem("", this.c64.getLogger().dumpAll());
        logItem.setFont(Font.getFont((int)0, (int)0, (int)8));
        log.append((Item)logItem);
        log.addCommand(this.closeCommand);
        log.setCommandListener((CommandListener)this);
        Display.getDisplay((MIDlet)this).setCurrent((Displayable)log);
        this.pauseApp();
    }

    private void showProgramList() {
        final List programList = new List(LocalizationSupport.getMessage("SelectProgram"), 3);
        programList.addCommand(this.cancelCommand);
        programList.addCommand(this.fastLoadRunProgramCommand);
        programList.addCommand(this.fastLoadProgramCommand);
        programList.addCommand(this.loadProgramCommand);
        programList.setSelectCommand(this.fastLoadProgramCommand);
        Vector prgs = this.c64.getDrive(this.c64.getActiveDrive()).getFilenames();
        for (int i = 0; i < prgs.size(); ++i) {
            programList.append(prgs.elementAt(i).toString(), null);
        }
        final Display display = Display.getDisplay((MIDlet)this);
        programList.setCommandListener(new CommandListener(){

            public void commandAction(Command c, Displayable d) {
                display.setCurrent((Displayable)MEC64MIDlet.this.c64Canvas);
                if (c != MEC64MIDlet.this.cancelCommand && programList.getSelectedIndex() >= 0) {
                    String program = programList.getString(programList.getSelectedIndex());
                    if (c == MEC64MIDlet.this.fastLoadRunProgramCommand) {
                        MEC64MIDlet.this.fastLoadSelectedProgram(program);
                        MEC64MIDlet.this.runProgram();
                    } else if (c == MEC64MIDlet.this.fastLoadProgramCommand) {
                        MEC64MIDlet.this.fastLoadSelectedProgram(program);
                    } else if (c == MEC64MIDlet.this.loadProgramCommand) {
                        MEC64MIDlet.this.c64.loadFile(program);
                    }
                }
                MEC64MIDlet.this.startApp();
            }
        });
        display.setCurrent((Displayable)programList);
        this.pauseApp();
    }

    private void fastLoadSelectedProgram(final String program) {
        final Display display = Display.getDisplay((MIDlet)this);
        Runnable loader = new Runnable(){

            public void run() {
                try {
                    MEC64MIDlet.this.c64.fastLoadFile(program, -1);
                    display.setCurrent((Displayable)new Alert(LocalizationSupport.getMessage("ProgramLoaded"), program + " " + LocalizationSupport.getMessage("WasLoadedSuccessfully"), null, AlertType.CONFIRMATION));
                }
                catch (IOException e) {
                    if (MEC64MIDlet.this.c64.getLogger() != null) {
                        MEC64MIDlet.this.c64.getLogger().warning(LocalizationSupport.getMessage("ErrorWhileLoading") + "'" + program + "': " + e);
                    }
                    display.setCurrent((Displayable)new Alert(LocalizationSupport.getMessage("FailedToLoadProgram"), LocalizationSupport.getMessage("FailedToLoadProgram") + ": " + program + "!", null, AlertType.WARNING));
                }
            }
        };
        display.setCurrent((Displayable)this.c64Canvas);
        display.callSerially(loader);
    }

    private Hashtable readProgramListFromTextFile() throws IOException {
        Hashtable<String, String> result = new Hashtable<String, String>();
        InputStream is = this.getClass().getResourceAsStream("/programs/programs.txt");
        int c = 0;
        while (c >= 0) {
            StringBuffer line = new StringBuffer();
            while ((c = is.read()) > 0 && c != 10 && c != 13) {
                line.append((char)c);
            }
            if (line.toString().startsWith("#") || line.length() <= 0) continue;
            result.put(line.toString(), "/programs/" + line.toString());
        }
        return result;
    }

    private void showTypeTextForm() {
        final Display display = Display.getDisplay((MIDlet)this);
        Form typeTextForm = new Form(LocalizationSupport.getMessage("TypeText"));
        final TextField typeTextField = new TextField(LocalizationSupport.getMessage("Text"), "", 40, 524288);
        typeTextForm.append((Item)typeTextField);
        typeTextForm.addCommand(this.cancelCommand);
        typeTextForm.addCommand(this.okCommand);
        typeTextForm.addCommand(this.okEnterCommand);
        Vector typedTexts = this.c64.getKeyboard().getTypedTexts();
        if (typedTexts.size() > 0) {
            Object[] historyArray = new String[typedTexts.size()];
            typedTexts.copyInto(historyArray);
            final ChoiceGroup history = new ChoiceGroup(LocalizationSupport.getMessage("History"), 4, (String[])historyArray, null);
            typeTextForm.setItemStateListener(new ItemStateListener(){

                public void itemStateChanged(Item item) {
                    if (history == item) {
                        typeTextField.setString(history.getString(history.getSelectedIndex()));
                    }
                }
            });
            typeTextForm.insert(1, (Item)history);
        }
        typeTextForm.setCommandListener(new CommandListener(){

            public void commandAction(Command c, Displayable d) {
                if (c == MEC64MIDlet.this.okCommand) {
                    MEC64MIDlet.this.c64.getKeyboard().textTyped(typeTextField.getString());
                } else if (c == MEC64MIDlet.this.okEnterCommand) {
                    MEC64MIDlet.this.c64.getKeyboard().textTyped(typeTextField.getString());
                    MEC64MIDlet.this.c64.getKeyboard().keyTyped("ENTER");
                }
                display.setCurrent((Displayable)MEC64MIDlet.this.c64Canvas);
                MEC64MIDlet.this.startApp();
            }
        });
        display.setCurrent((Displayable)typeTextForm);
        this.pauseApp();
    }

    protected Hashtable getImages() {
        return this.programs;
    }

    private void showImageList() {
        final List imageList = new List(LocalizationSupport.getMessage("SelectProgram"), 3);
        imageList.addCommand(this.fastAutoStartCommand);
        imageList.addCommand(this.autoStartCommand);
        imageList.addCommand(this.okCommand);
        imageList.addCommand(this.cancelCommand);
        imageList.addCommand(this.removeCommand);
        imageList.setSelectCommand(this.okCommand);
        Vector listItems = new Vector();
        CollectionUtils.addAll(listItems, this.getImages().keys());
        CollectionUtils.sort(listItems);
        Vector snapshots = this.getSnapshots();
        Vector noImageSnapshots = this.getSnapshots(NO_IMAGE, snapshots);
        int to = noImageSnapshots.size();
        for (int j = 0; j < to; ++j) {
            imageList.append(noImageSnapshots.elementAt(j).toString(), snapshotImage);
        }
        for (int i = 0; i < listItems.size(); ++i) {
            String name = listItems.elementAt(i).toString();
            imageList.append(name, floppyImage);
            Vector programSnapshots = this.getSnapshots(name, snapshots);
            int to2 = programSnapshots.size();
            for (int j = 0; j < to2; ++j) {
                imageList.append(programSnapshots.elementAt(j).toString(), snapshotImage);
            }
        }
        final Display display = Display.getDisplay((MIDlet)this);
        imageList.setCommandListener(new CommandListener(){

            public void commandAction(Command c, Displayable d) {
                display.setCurrent((Displayable)MEC64MIDlet.this.c64Canvas);
                if (c == MEC64MIDlet.this.okCommand || c == MEC64MIDlet.this.autoStartCommand || c == MEC64MIDlet.this.fastAutoStartCommand) {
                    String image = imageList.getString(imageList.getSelectedIndex());
                    if (MEC64MIDlet.this.programs.containsKey(image)) {
                        MEC64MIDlet.this.runGame(image, c);
                    } else {
                        MEC64MIDlet.this.runSnapshot(image);
                    }
                } else if (c == MEC64MIDlet.this.removeCommand) {
                    String image = imageList.getString(imageList.getSelectedIndex());
                    if (MEC64MIDlet.this.programs.containsKey(image)) {
                        display.setCurrent(new Alert(LocalizationSupport.getMessage("NotASnapshot"), LocalizationSupport.getMessage("OnlySnapshotsCanBeRemoved"), null, AlertType.INFO), (Displayable)MEC64MIDlet.this.c64Canvas);
                    } else {
                        try {
                            RecordStore.deleteRecordStore((String)image);
                            Vector snapshots = MEC64MIDlet.this.getSnapshots();
                            snapshots.removeElement(image);
                            MEC64MIDlet.this.setSnapshots(snapshots);
                            display.setCurrent(new Alert(LocalizationSupport.getMessage("RemovedSnapshotData"), LocalizationSupport.getMessage("RemovedSnapshotDataFor") + " " + image, null, AlertType.INFO), (Displayable)MEC64MIDlet.this.c64Canvas);
                        }
                        catch (Exception e) {
                            display.setCurrent(new Alert(LocalizationSupport.getMessage("CouldNotRemoveSnapshotData"), LocalizationSupport.getMessage("FailedToRemoveSnapshotDataFor") + " " + image, null, AlertType.WARNING), (Displayable)MEC64MIDlet.this.c64Canvas);
                        }
                    }
                } else {
                    MEC64MIDlet.this.startApp();
                }
            }
        });
        display.setCurrent((Displayable)imageList);
        this.pauseApp();
    }

    private synchronized void attachImage(int driveNo, String program) throws IOException {
        String selectedImage = this.programs.get(program).toString();
        String image = this.programs.get(program).toString();
        if (!image.equals(this.attachedImages.get(new Integer(driveNo)))) {
            boolean applyDelta = image.endsWith(".dlt");
            if (applyDelta) {
                image = image.substring(0, image.length() - 4);
            }
            this.c64.getDrive(driveNo).attachImage(image.indexOf("://") > 0 ? Connector.openInputStream((String)image) : this.getClass().getResourceAsStream(image), image);
            if (applyDelta) {
                this.c64.getDrive(driveNo).getDriveHandler().applyDelta(Connector.openInputStream((String)selectedImage));
                this.c64.getLogger().info(LocalizationSupport.getMessage("AppliedDelta") + " '" + selectedImage + "'");
            }
            this.attachedImages.put(new Integer(driveNo), program);
        }
    }

    private void detachImages() {
        for (int i = 0; i < this.c64.getDriveCount(); ++i) {
            this.c64.getDrive(i).detachImage();
        }
        this.attachedImages.clear();
    }

    protected void setSound(boolean active) {
        if (active) {
            if (this.c64.getSID().countObservers() == 0) {
                try {
                    this.c64.getSID().addObserver(new PCMtoMIDIPlayer(this.c64.getSID()));
                }
                catch (Throwable t) {
                    try {
                        this.c64.getSID().addObserver(new WavePlayer(this.c64.getSID()));
                    }
                    catch (Throwable t2) {
                        this.c64.getLogger().warning(LocalizationSupport.getMessage("CouldNotCreateSoundPlayer"));
                        t2.printStackTrace();
                    }
                }
            }
        } else if (this.c64.getSID().countObservers() > 0) {
            this.notifySoundPlayer(PCMtoMIDIPlayer.SIGNAL_STOP);
            this.c64.getSID().deleteObservers();
        }
        try {
            this.settings.setBoolean(SETTING_SOUNDACTIVE, active);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void showDriveList() {
        final List driveList = new List(LocalizationSupport.getMessage("SelectDrive"), 3);
        driveList.addCommand(this.okCommand);
        driveList.addCommand(this.cancelCommand);
        driveList.setSelectCommand(this.okCommand);
        for (int i = 0; i < this.c64.getDriveCount(); ++i) {
            driveList.append(LocalizationSupport.getMessage("Drive") + " " + i + " (#" + (i + 8) + ")", null);
        }
        final Display display = Display.getDisplay((MIDlet)this);
        driveList.setCommandListener(new CommandListener(){

            public void commandAction(Command c, Displayable d) {
                display.setCurrent((Displayable)MEC64MIDlet.this.c64Canvas);
                if (c == MEC64MIDlet.this.okCommand) {
                    MEC64MIDlet.this.c64.setActiveDrive(driveList.getSelectedIndex());
                }
                MEC64MIDlet.this.startApp();
            }
        });
        display.setCurrent((Displayable)driveList);
        this.pauseApp();
    }

    private void showSelectDirectoryForm() {
        final Display display = Display.getDisplay((MIDlet)this);
        String defaultDir = this.settings.getString(SETTING_FILESEARCH_STARTDIR, "");
        Vector<String> filters = new Vector<String>();
        filters.addElement("/");
        FileBrowser fileBrowser = new FileBrowser(display, defaultDir, filters){

            public void onSelect() {
                super.onSelect();
                MEC64MIDlet.this.fileSearchStartDir = this.getSelectedFile();
                try {
                    MEC64MIDlet.this.settings.setString(MEC64MIDlet.SETTING_FILESEARCH_STARTDIR, MEC64MIDlet.this.fileSearchStartDir);
                }
                catch (Exception exception) {
                    // empty catch block
                }
                MEC64MIDlet.this.fileSystemHandler.readProgramListFromFileSystem(MEC64MIDlet.this.fileSearchStartDir, MEC64MIDlet.this.programs, display);
                display.setCurrent((Displayable)MEC64MIDlet.this.c64Canvas);
            }

            public void onError(Throwable t) {
                super.onError(t);
                try {
                    MEC64MIDlet.this.settings.remove(MEC64MIDlet.SETTING_FILESEARCH_STARTDIR);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        };
        fileBrowser.show();
    }

    private void showSettingsForm() {
        Form settingsForm = new Form(LocalizationSupport.getMessage("EmulatorSettings"));
        String[] ports = new String[]{LocalizationSupport.getMessage("Port") + " 1", LocalizationSupport.getMessage("Port") + " 2"};
        final ChoiceGroup portsChoice = new ChoiceGroup(LocalizationSupport.getMessage("JoystickPort"), 1, ports, null);
        portsChoice.setSelectedIndex(this.c64.getActiveJoystick(), true);
        settingsForm.append((Item)portsChoice);
        String[] pointerOptions = new String[]{LocalizationSupport.getMessage("NoPointer"), LocalizationSupport.getMessage("PointerAsJoystickButton"), LocalizationSupport.getMessage("VirtualJoystick"), LocalizationSupport.getMessage("PointerForStickMovement")};
        final ChoiceGroup pointerOptionsChoice = new ChoiceGroup(LocalizationSupport.getMessage("PointerUsage"), 1, pointerOptions, null);
        pointerOptionsChoice.setSelectedIndex(this.c64Canvas.getPointerUsage(), true);
        if (this.c64Canvas.hasPointerEvents() || this.c64Canvas.hasPointerMotionEvents()) {
            settingsForm.append((Item)pointerOptionsChoice);
        }
        settingsForm.append((Item)new Spacer(0, 2));
        String[] sound = new String[]{LocalizationSupport.getMessage("On"), LocalizationSupport.getMessage("Off")};
        final ChoiceGroup soundChoice = new ChoiceGroup(LocalizationSupport.getMessage("Sound"), 1, sound, null);
        soundChoice.setSelectedIndex(this.c64.getSID().countObservers() > 0 ? 0 : 1, true);
        settingsForm.append((Item)soundChoice);
        settingsForm.append((Item)new Spacer(0, 2));
        String[] videoOptions = new String[]{LocalizationSupport.getMessage("SmoothScaling")};
        final ChoiceGroup videoChoice = new ChoiceGroup(LocalizationSupport.getMessage("VideoOptions"), 2, videoOptions, null);
        final boolean isSmoothScaling = this.c64.getVIC() instanceof SmoothingScalableVIC6569;
        videoChoice.setSelectedIndex(0, isSmoothScaling);
        settingsForm.append((Item)videoChoice);
        String[] frameSkipOptions = new String[]{LocalizationSupport.getMessage("Automatic"), "1", "2", "3", "4"};
        final ChoiceGroup frameSkipChoice = new ChoiceGroup(LocalizationSupport.getMessage("ShowEveryNthFrame"), 1, frameSkipOptions, null);
        int frameSkip = this.c64.doAutoAdjustFrameskip() ? 0 : Math.min(this.c64.getVIC().getFrameSkip(), 4);
        frameSkipChoice.setSelectedIndex(frameSkip, true);
        settingsForm.append((Item)frameSkipChoice);
        String[] driveModes = new String[]{LocalizationSupport.getMessage("Fast"), LocalizationSupport.getMessage("Balanced"), LocalizationSupport.getMessage("Compatible")};
        final ChoiceGroup driveModeChoice = new ChoiceGroup(LocalizationSupport.getMessage("C1541Mode"), 1, driveModes, null);
        int level = this.c64.getDrive(0).getEmulationLevel();
        driveModeChoice.setSelectedIndex(level >= 100 ? 2 : (level >= 50 ? 1 : 0), true);
        settingsForm.append((Item)driveModeChoice);
        String[] keyboardTypes = new String[]{LocalizationSupport.getMessage("PhoneKeyboard"), LocalizationSupport.getMessage("FullKeyboard")};
        final ChoiceGroup keyboardChoice = new ChoiceGroup(LocalizationSupport.getMessage("KeyboardType"), 1, keyboardTypes, null);
        keyboardChoice.setSelectedIndex(this.c64Canvas.isPhoneKeyboard ? 0 : 1, true);
        settingsForm.append((Item)keyboardChoice);
        final ChoiceGroup languageChoice = new ChoiceGroup(LocalizationSupport.getMessage(SETTING_LANGUAGE), 1, SUPPORTED_LOCALES, null);
        final String activeLanguage = this.settings.getString(SETTING_LANGUAGE, SUPPORTED_LOCALES[0]);
        int activeLanguageIndex = 0;
        for (int i = 0; i < SUPPORTED_LOCALES.length; ++i) {
            if (!activeLanguage.equals(SUPPORTED_LOCALES[i])) continue;
            activeLanguageIndex = i;
            break;
        }
        languageChoice.setSelectedIndex(activeLanguageIndex, true);
        settingsForm.append((Item)languageChoice);
        String[] accelerometerOptions = new String[]{LocalizationSupport.getMessage("ForJoystickEmulation"), LocalizationSupport.getMessage(SETTING_AUTO_ROTATE)};
        final ChoiceGroup accelerometerChoice = new ChoiceGroup(LocalizationSupport.getMessage("UseAccelerometer"), 2, accelerometerOptions, null);
        boolean isUseAccelerometer = this.c64Canvas.isUseAccelerometer();
        boolean isRotateScreen = this.c64Canvas.isAutoChangeOrientation();
        accelerometerChoice.setSelectedIndex(0, isUseAccelerometer);
        accelerometerChoice.setSelectedIndex(1, isRotateScreen);
        try {
            if (OrientationSensitiveCanvasHelper.supportsAccelerometer()) {
                settingsForm.append((Item)new Spacer(0, 2));
                settingsForm.append((Item)accelerometerChoice);
            }
        }
        catch (Throwable t) {
            // empty catch block
        }
        final Display display = Display.getDisplay((MIDlet)this);
        settingsForm.addCommand(this.okCommand);
        settingsForm.addCommand(this.cancelCommand);
        settingsForm.setCommandListener(new CommandListener(){

            public void commandAction(Command c, Displayable d) {
                boolean isRestartRequired = false;
                if (c == MEC64MIDlet.this.okCommand) {
                    MEC64MIDlet.this.c64.setActiveJoystick(portsChoice.getSelectedIndex());
                    MEC64MIDlet.this.c64Canvas.setPointerUsage(pointerOptionsChoice.getSelectedIndex());
                    MEC64MIDlet.this.setSound(soundChoice.getSelectedIndex() == 0);
                    if (frameSkipChoice.getSelectedIndex() == 0) {
                        MEC64MIDlet.this.c64.setDoAutoAdjustFrameskip(true);
                    } else {
                        MEC64MIDlet.this.c64.setDoAutoAdjustFrameskip(false);
                        MEC64MIDlet.this.c64.getVIC().setFrameSkip(frameSkipChoice.getSelectedIndex());
                    }
                    MEC64MIDlet.this.c64Canvas.setUseAccelerometer(accelerometerChoice.isSelected(0));
                    MEC64MIDlet.this.c64Canvas.setAutoChangeOrientation(accelerometerChoice.isSelected(1));
                    boolean bl = MEC64MIDlet.this.c64Canvas.isPhoneKeyboard = keyboardChoice.getSelectedIndex() == 0;
                    int level = driveModeChoice.getSelectedIndex() == 0 ? 0 : (driveModeChoice.getSelectedIndex() == 2 ? 100 : 50);
                    for (int i = 0; i < MEC64MIDlet.this.c64.getDriveCount(); ++i) {
                        MEC64MIDlet.this.c64.getDrive(i).setEmulationLevel(level);
                    }
                    try {
                        MEC64MIDlet.this.settings.setBoolean("SmoothScaling", videoChoice.isSelected(0));
                        MEC64MIDlet.this.settings.setInteger("FrameSkip", frameSkipChoice.getSelectedIndex());
                        MEC64MIDlet.this.settings.setBoolean("PhoneKeyboard", MEC64MIDlet.this.c64Canvas.isPhoneKeyboard);
                        MEC64MIDlet.this.settings.setInteger("DriveMode", level);
                        MEC64MIDlet.this.settings.setBoolean(MEC64MIDlet.SETTING_ACCELEROMETER, MEC64MIDlet.this.c64Canvas.isUseAccelerometer());
                        MEC64MIDlet.this.settings.setBoolean(MEC64MIDlet.SETTING_AUTO_ROTATE, MEC64MIDlet.this.c64Canvas.isAutoChangeOrientation());
                        String newLanguage = SUPPORTED_LOCALES[languageChoice.getSelectedIndex()];
                        isRestartRequired |= !activeLanguage.equals(newLanguage);
                        if (languageChoice.getSelectedIndex() == 0) {
                            MEC64MIDlet.this.settings.remove(MEC64MIDlet.SETTING_LANGUAGE);
                        } else {
                            MEC64MIDlet.this.settings.setString(MEC64MIDlet.SETTING_LANGUAGE, newLanguage);
                        }
                    }
                    catch (Exception e) {
                        // empty catch block
                    }
                    if (videoChoice.isSelected(0) != isSmoothScaling) {
                        MEC64MIDlet.this.c64Canvas.calculateScreenSize();
                    }
                }
                display.setCurrent((Displayable)MEC64MIDlet.this.c64Canvas);
                MEC64MIDlet.this.startApp();
                if (isRestartRequired) {
                    display.callSerially(new Runnable(){

                        public void run() {
                            display.setCurrent((Displayable)new Alert(LocalizationSupport.getMessage("RestartRequired"), LocalizationSupport.getMessage("SomeSettingsRequireRestart"), null, AlertType.INFO));
                        }
                    });
                }
            }
        });
        display.setCurrent((Displayable)settingsForm);
        this.pauseApp();
    }

    private void showSpecialKeysForm() {
        final Display display = Display.getDisplay((MIDlet)this);
        String[] specialKeys = new String[]{"Escape", "Run", "F1", "F3", "F5", "F7", "Space", "Enter", "Delete", "Break", "Commodore", "Pound", "Cursor Up", "Cursor Down", "Cursor Left", "Cursor Right"};
        final List specialKeyList = new List(LocalizationSupport.getMessage("SelectKey"), 3, specialKeys, null);
        specialKeyList.addCommand(this.okCommand);
        specialKeyList.addCommand(this.cancelCommand);
        specialKeyList.setSelectCommand(this.okCommand);
        specialKeyList.setCommandListener(new CommandListener(){

            public void commandAction(Command c, Displayable d) {
                display.setCurrent((Displayable)MEC64MIDlet.this.c64Canvas);
                if (c == MEC64MIDlet.this.okCommand) {
                    final String key = specialKeyList.getString(specialKeyList.getSelectedIndex());
                    display.callSerially(new Runnable(){

                        public void run() {
                            MEC64MIDlet.this.c64.getKeyboard().keyTyped(key.toUpperCase());
                        }
                    });
                }
                MEC64MIDlet.this.startApp();
            }
        });
        display.setCurrent((Displayable)specialKeyList);
        this.pauseApp();
    }

    private void showAboutForm() {
        Form about = new Form(LocalizationSupport.getMessage("About"));
        StringItem projectUrl = new StringItem(null, PROJECT_PAGE_URL, 1);
        projectUrl.addCommand(this.browseCommand);
        projectUrl.setItemCommandListener(new ItemCommandListener(){

            public void commandAction(Command c, Item item) {
                try {
                    MEC64MIDlet.this.platformRequest(((StringItem)item).getText());
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        });
        String text = LocalizationSupport.getMessage("AboutText1") + this.getAppProperty("MIDlet-Version") + LocalizationSupport.getMessage("AboutText2") + LocalizationSupport.getMessage("AboutText3") + LocalizationSupport.getMessage("AboutText4");
        String pageStr = "#PROJECTPAGE#";
        int index1 = text.indexOf("#PROJECTPAGE#");
        about.append(text.substring(0, index1));
        about.append((Item)projectUrl);
        about.append(text.substring(index1 + "#PROJECTPAGE#".length(), text.length()));
        about.addCommand(this.closeCommand);
        about.setCommandListener((CommandListener)this);
        Display display = Display.getDisplay((MIDlet)this);
        display.setCurrent((Displayable)about);
        this.pauseApp();
    }

    private void showHelpForm() {
        InputStream helpContent = LocalizationSupport.loadLocalizedFile("/docs/help.txt", this.getLocale());
        try {
            FormattedTextForm helpForm = new FormattedTextForm(this, LocalizationSupport.getMessage("Help"), helpContent);
            helpForm.addCommand(this.closeCommand);
            helpForm.setCommandListener(this);
            Display display = Display.getDisplay((MIDlet)this);
            display.setCurrent((Displayable)helpForm);
            this.pauseApp();
        }
        catch (Exception e) {
            Display.getDisplay((MIDlet)this).setCurrent((Displayable)new Alert(LocalizationSupport.getMessage("FailedToLoadHelp"), LocalizationSupport.getMessage("FailedToLoadHelpFile"), null, AlertType.WARNING));
            e.printStackTrace();
        }
    }

    public void commandAction(Command c, Displayable s) {
        if (c == this.okCommand || c == this.backCommand || c == this.cancelCommand) {
            Display.getDisplay((MIDlet)this).setCurrent((Displayable)this.c64Canvas);
        } else if (c == this.closeCommand) {
            Display.getDisplay((MIDlet)this).setCurrent((Displayable)this.c64Canvas);
            this.startApp();
        } else if (c == this.menuCommand) {
            this.mainMenu.show(Display.getDisplay((MIDlet)this));
            this.pauseApp();
        }
    }

    public void menuAction(String item) {
        this.startApp();
        if (item.equals(this.exitMenuText)) {
            this.exit();
        } else if (item.equals(this.suspendMenuText)) {
            this.suspend();
        } else if (item.equals(this.attachImageMenuText)) {
            this.showImageList();
        } else if (item.equals(this.selectDriveMenuText)) {
            this.showDriveList();
        } else if (item.equals(this.detachImageMenuText)) {
            this.detachImages();
            this.mainMenu.removeItem(this.detachImageMenuText);
        } else if (item.equals(this.runMenuText)) {
            this.runProgram();
        } else if (item.equals(this.aboutMenuText)) {
            this.showAboutForm();
        } else if (item.equals(this.helpMenuText)) {
            this.showHelpForm();
        } else if (item.equals(this.typeMenuText)) {
            this.showTypeTextForm();
        } else if (item.equals(this.specialKeysMenuText)) {
            this.showSpecialKeysForm();
        } else if (item.equals(this.resetMenuText)) {
            this.c64.reset();
            this.c64Canvas.showEmulatorExceptions = true;
        } else if (item.equals(this.showLogMenuText)) {
            this.showLogForm();
        } else if (item.equals(this.editSettingsMenuText)) {
            this.showSettingsForm();
        } else if (item.equals(this.searchProgramsMenuText)) {
            CollectionUtils.removeAll(this.programs, this.fileSystemHandler.getCachedProgramList());
            this.showSelectDirectoryForm();
        } else if (item.equals(this.assignKeysMenuText)) {
            this.showAssignButtonsCanvas();
        } else if (item.equals(this.snapshotMenuText)) {
            this.saveSnapshot();
        }
    }

    public void menuClosed(Menu menu) {
        if (menu == this.mainMenu) {
            this.startApp();
        }
    }
}

