/*
 * Decompiled with CFR 0.152.
 */
package de.joergjahnke.c64.jme;

import de.joergjahnke.c64.core.C64;
import de.joergjahnke.c64.core.Joystick;
import de.joergjahnke.c64.core.VIC6569;
import de.joergjahnke.c64.jme.MEC64MIDlet;
import de.joergjahnke.c64.jme.VirtualJoystick;
import de.joergjahnke.c64.smalldisplays.ScalableVIC6569;
import de.joergjahnke.c64.smalldisplays.SmoothingScalableVIC6569;
import de.joergjahnke.common.jme.Backlight;
import de.joergjahnke.common.jme.LocalizationSupport;
import de.joergjahnke.common.jme.OrientationSensitiveCanvas;
import de.joergjahnke.common.ui.Color;
import de.joergjahnke.common.util.Observer;
import java.io.IOException;
import java.util.Hashtable;
import java.util.Timer;
import java.util.TimerTask;
import javax.microedition.lcdui.Alert;
import javax.microedition.lcdui.AlertType;
import javax.microedition.lcdui.Displayable;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;
import javax.microedition.lcdui.game.Sprite;

public class C64Canvas
extends OrientationSensitiveCanvas
implements Observer {
    private static final int POINTER_NO_USAGE = 0;
    private static final int POINTER_AS_FIRE_BUTTON = 1;
    private static final int POINTER_FOR_VIRTUAL_JOYSTICK = 2;
    private static final int POINTER_FOR_JOYSTICK_MOVEMENT = 3;
    private static final int MIN_PERCENTAGE_POINTER_MOVEMENT = 10;
    protected static final String SETTING_FRAMESKIP = "FrameSkip";
    protected static final String SETTING_SMOOTH_SCALING = "SmoothScaling";
    protected static final String SETTING_POINTER_USAGE = "PointerUsage";
    protected static final String SETTING_PHONE_KEYBOARD = "PhoneKeyboard";
    protected static final String SETTING_DRIVEMODE = "DriveMode";
    private static final long AUTOMATIC_KEY_RELEASE_TIME = 200L;
    protected final MEC64MIDlet midlet;
    protected C64 c64;
    protected boolean showEmulatorExceptions = true;
    private int x;
    private int y;
    private int bx;
    private int by;
    private int offset;
    private int ox;
    private int oy;
    private Sprite logo;
    private Color borderColor = new Color(0);
    protected boolean isPhoneKeyboard;
    private int paintWidth;
    private int paintHeight;
    private VirtualJoystick virtualJoystick;
    private int pointerUsage = 0;
    private final Graphics graphics;
    private int pStartX = -1;
    private int pStartY = -1;
    private Hashtable buttonAssignments = new Hashtable();
    private Hashtable buttonReleaseTimers = new Hashtable();
    static /* synthetic */ Class class$de$joergjahnke$c64$smalldisplays$SmoothingScalableVIC6569;
    static /* synthetic */ Class class$de$joergjahnke$c64$smalldisplays$ScalableVIC6569;
    static /* synthetic */ Class class$de$joergjahnke$c64$core$VIC6569;

    public C64Canvas(MEC64MIDlet midlet) {
        super(midlet);
        this.midlet = midlet;
        this.pointerUsage = this.midlet.getSettings().getInteger(SETTING_POINTER_USAGE, 1);
        this.isPhoneKeyboard = this.midlet.getSettings().getBoolean(SETTING_PHONE_KEYBOARD, true);
        this.setFullScreenMode(true);
        try {
            this.logo = new Sprite(Image.createImage((String)"/res/jme/J64.png"));
            this.logo.defineReferencePixel(this.logo.getWidth() / 2, this.logo.getHeight() / 2);
            this.logo.setRefPixelPosition(this.getWidth() / 2, this.getHeight() / 2);
        }
        catch (IOException e) {
            // empty catch block
        }
        if (this.hasPointerEvents() || this.hasPointerMotionEvents()) {
            try {
                this.virtualJoystick = new VirtualJoystick();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        this.graphics = this.getGraphics();
    }

    public final C64 getC64() {
        return this.c64;
    }

    public void setC64(C64 c64) {
        this.c64 = c64;
        try {
            int level = this.midlet.getSettings().getInteger(SETTING_DRIVEMODE);
            for (int i = 0; i < this.c64.getDriveCount(); ++i) {
                c64.getDrive(i).setEmulationLevel(level);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public int getPointerUsage() {
        return this.pointerUsage;
    }

    public void setPointerUsage(int usage) {
        this.pointerUsage = usage;
        try {
            this.midlet.getSettings().setInteger(SETTING_POINTER_USAGE, usage);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public Hashtable getButtonAssignments() {
        return this.buttonAssignments;
    }

    public void setButtonAssignments(Hashtable buttonAssignments) {
        this.buttonAssignments = buttonAssignments;
    }

    private void paint() {
        VIC6569 vic = this.c64.getVIC();
        this.graphics.setColor(0, 0, 0);
        this.graphics.fillRect(0, 0, this.getWidth(), this.getHeight());
        if (vic.isSmallScreen()) {
            this.graphics.setColor(this.borderColor.getRGB());
            if (!this.isAutoChangeOrientation() || this.transform == 0 || this.transform == 3) {
                this.graphics.fillRect(this.bx, this.by, vic.getBorderWidth(), vic.getBorderHeight());
            } else {
                this.graphics.fillRect(this.bx, this.by, vic.getBorderHeight(), vic.getBorderWidth());
            }
        }
        if (!this.isAutoChangeOrientation() || this.transform == 0) {
            this.graphics.drawRGB(vic.getRGBData(), this.offset, vic.getBorderWidth(), this.x, this.y, this.paintWidth, this.paintHeight, false);
        } else {
            Image image = Image.createRGBImage((int[])vic.getRGBData(), (int)vic.getBorderWidth(), (int)vic.getBorderHeight(), (boolean)false);
            this.graphics.drawRegion(image, this.ox, this.oy, this.paintWidth, this.paintHeight, this.transform, this.x, this.y, 20);
            image = null;
            System.gc();
        }
        if (!this.c64.isReady()) {
            this.logo.paint(this.graphics);
        }
        if (this.pointerUsage == 2 && null != this.virtualJoystick && this.c64.isReady()) {
            this.virtualJoystick.getImage().paint(this.graphics);
        }
        this.flushGraphics();
    }

    public void calculateScreenSize() {
        boolean wasPaused = this.c64.isPaused();
        this.c64.pause();
        try {
            Thread.sleep(10L);
        }
        catch (InterruptedException e) {
            // empty catch block
        }
        boolean isRotateScreen = this.transform != 0 && this.transform != 3;
        int swidth = isRotateScreen ? this.getHeight() : this.getWidth();
        int sheight = isRotateScreen ? this.getWidth() : this.getHeight();
        double scaling = Math.min((double)swidth * 1.0 / 320.0, (double)sheight * 1.0 / 200.0);
        boolean isSmoothScaling = this.midlet.getSettings().getBoolean(SETTING_SMOOTH_SCALING, scaling < 0.8) && scaling < 1.0;
        VIC6569Factory factory = new VIC6569Factory();
        VIC6569 vic = factory.create(scaling, isSmoothScaling);
        vic.copy(this.c64.getVIC());
        this.c64.getVIC().deleteObserver(this);
        this.c64.getVIC().destroy();
        this.c64.setVIC(vic);
        vic.addObserver(this);
        System.gc();
        try {
            vic.initScreenMemory();
        }
        catch (OutOfMemoryError e) {
            this.c64.getVIC().destroy();
            System.gc();
            vic = new ScalableVIC6569(this.c64, scaling);
            this.c64.getVIC().deleteObserver(this);
            this.c64.setVIC(vic);
            vic.addObserver(this);
            System.gc();
            vic.initScreenMemory();
            this.c64.getLogger().warning(LocalizationSupport.getMessage("OutOfVideoMemory"));
        }
        catch (IllegalStateException e) {
            vic = new VIC6569(this.c64);
            vic.initScreenMemory();
            this.display.setCurrent((Displayable)new Alert(LocalizationSupport.getMessage("AnErrorHasOccurred"), LocalizationSupport.getMessage("ErrorWas") + e.getMessage() + LocalizationSupport.getMessage("CorrectVideoSettings"), null, AlertType.WARNING));
        }
        if (vic instanceof ScalableVIC6569) {
            scaling = ((ScalableVIC6569)vic).getScaling();
        }
        try {
            vic.setFrameSkip(this.midlet.getSettings().getInteger(SETTING_FRAMESKIP));
            this.c64.setDoAutoAdjustFrameskip(false);
        }
        catch (Exception e) {
            vic.setFrameSkip(4);
            this.c64.setDoAutoAdjustFrameskip(true);
        }
        vic.setSmallScreen(true);
        this.bx = Math.max(0, this.getWidth() - (isRotateScreen ? vic.getBorderHeight() : vic.getBorderWidth()) >> 1);
        this.by = Math.max(0, this.getHeight() - (isRotateScreen ? vic.getBorderWidth() : vic.getBorderHeight()) >> 1);
        int width = vic.isSmallScreen() ? vic.getDisplayWidth() : vic.getBorderWidth();
        int height = vic.isSmallScreen() ? vic.getDisplayHeight() : vic.getBorderHeight();
        int sx = this.getWidth() - (isRotateScreen ? height : width) >> 1;
        int sy = this.getHeight() - (isRotateScreen ? width : height) >> 1;
        this.x = Math.max(0, sx);
        this.y = Math.max(0, sy);
        this.paintWidth = Math.min(swidth, width);
        this.paintHeight = Math.min(sheight, height);
        if (vic.isSmallScreen()) {
            vic.gotoPixel(40, 40);
            this.ox = (int)(40.0 * scaling);
            this.oy = (int)(40.0 * scaling);
        } else {
            vic.gotoPixel((int)Math.max((double)(-sx) / scaling, 0.0), (int)Math.max((double)(-sy) / scaling, 0.0));
            this.oy = 0;
            this.ox = 0;
        }
        this.offset = vic.getNextPixel();
        if (null != this.virtualJoystick) {
            this.virtualJoystick.getImage().setPosition(this.getWidth() - this.virtualJoystick.getWidth(), this.getHeight() - this.virtualJoystick.getHeight());
        }
        this.logo.setTransform(this.transform);
        if (!wasPaused) {
            this.c64.resume();
        }
    }

    private int adjustJoystickDirection(int direction) {
        switch (this.transform) {
            case 5: {
                return direction < 4 ? direction << 2 : (direction == 4 ? 2 : 1);
            }
            case 3: {
                return direction < 4 ? direction ^ 3 : direction ^ 0xC;
            }
            case 6: {
                return direction > 2 ? direction >> 2 : (direction == 1 ? 8 : 4);
            }
        }
        return direction;
    }

    private String getKeySelection(int keyCode) {
        String key = this.getKeyName(keyCode);
        if (this.isPhoneKeyboard) {
            if (42 == keyCode) {
                key = "ENTER";
            } else if (35 == keyCode) {
                key = "SPACE";
            }
        }
        return key;
    }

    private int getJoystickChanges(int keyCode) {
        int pressedDirections = 0;
        int pressedButtons = 0;
        int repeatMask = 0;
        int gameAction = this.buttonAssignments.contains("Up") ? 0 : this.getGameAction(keyCode);
        String buttonName = "";
        if (this.buttonAssignments.containsKey(new Integer(keyCode))) {
            buttonName = this.buttonAssignments.get(new Integer(keyCode)).toString();
        } else if (this.buttonAssignments.containsKey(new Integer(keyCode + Integer.MIN_VALUE))) {
            buttonName = this.buttonAssignments.get(new Integer(keyCode + Integer.MIN_VALUE)).toString();
            repeatMask = Integer.MIN_VALUE;
        }
        if (buttonName.indexOf("Up") >= 0 || gameAction == 1) {
            pressedDirections |= this.adjustJoystickDirection(1);
        }
        if (buttonName.indexOf("Down") >= 0 || gameAction == 6) {
            pressedDirections |= this.adjustJoystickDirection(2);
        }
        if (buttonName.indexOf("Left") >= 0 || gameAction == 2) {
            pressedDirections |= this.adjustJoystickDirection(4);
        }
        if (buttonName.indexOf("Right") >= 0 || gameAction == 5) {
            pressedDirections |= this.adjustJoystickDirection(8);
        }
        if ("Fire".equals(buttonName) || gameAction == 8) {
            pressedButtons |= 0x10;
        }
        return pressedDirections + (pressedButtons << 16) + repeatMask;
    }

    protected void keyPressed(final int keyCode) {
        int changes = this.getJoystickChanges(keyCode);
        if (changes == 0) {
            String key = this.getKeySelection(keyCode);
            this.c64.getKeyboard().keyTyped(key);
        } else {
            boolean needReleaseTimer;
            int pressedDirections = changes & 0xFFFF;
            boolean wasFirePressed = (changes & 0x7FFF0000) >> 16 != 0;
            Joystick joystick = this.c64.getJoystick(this.c64.getActiveJoystick());
            joystick.setDirection(joystick.getDirection() | pressedDirections);
            joystick.setFiring(joystick.isFiring() | wasFirePressed);
            boolean bl = needReleaseTimer = (changes & Integer.MIN_VALUE) != 0;
            if (needReleaseTimer) {
                Integer key = new Integer(keyCode);
                Timer buttonReleaseTimer = (Timer)this.buttonReleaseTimers.get(key);
                if (buttonReleaseTimer != null) {
                    buttonReleaseTimer.cancel();
                }
                buttonReleaseTimer = new Timer();
                buttonReleaseTimer.schedule(new TimerTask(){

                    public void run() {
                        C64Canvas.this.keyReleased(keyCode);
                    }
                }, 200L);
                this.buttonReleaseTimers.put(key, buttonReleaseTimer);
            }
        }
    }

    protected void keyReleased(int keyCode) {
        int changes = this.getJoystickChanges(keyCode);
        int pressedDirections = changes & 0xFFFF;
        boolean wasFireReleased = (changes & 0x7FFF0000) >> 16 != 0;
        Joystick joystick = this.c64.getJoystick(this.c64.getActiveJoystick());
        joystick.setDirection(joystick.getDirection() & 15 - pressedDirections);
        joystick.setFiring(joystick.isFiring() & !wasFireReleased);
    }

    protected void keyRepeated(int keyCode) {
        this.keyPressed(keyCode);
    }

    protected void pointerPressed(int x, int y) {
        switch (this.pointerUsage) {
            case 2: {
                int value = this.virtualJoystick.getValue(x - this.virtualJoystick.getImage().getX(), y - this.virtualJoystick.getImage().getY());
                Joystick joystick = this.c64.getJoystick(this.c64.getActiveJoystick());
                joystick.setDirection(this.adjustJoystickDirection(value & 0xF));
                joystick.setFiring((value & 0x10) != 0);
                break;
            }
            case 1: {
                this.c64.getJoystick(this.c64.getActiveJoystick()).setFiring(true);
                break;
            }
            case 3: {
                this.pStartX = x;
                this.pStartY = y;
                break;
            }
        }
    }

    protected void pointerReleased(int x, int y) {
        switch (this.pointerUsage) {
            case 2: {
                Joystick joystick = this.c64.getJoystick(this.c64.getActiveJoystick());
                joystick.setFiring(false);
                joystick.setDirection(0);
                break;
            }
            case 1: {
                this.c64.getJoystick(this.c64.getActiveJoystick()).setFiring(false);
                break;
            }
            case 3: {
                this.c64.getJoystick(this.c64.getActiveJoystick()).setDirection(0);
                this.pStartY = -1;
                this.pStartX = -1;
                break;
            }
        }
    }

    protected void pointerDragged(int x, int y) {
        switch (this.pointerUsage) {
            case 3: {
                if (x < this.x || x >= this.x + this.paintWidth || y < this.y || y >= this.y + this.paintHeight || this.pStartX <= 0) break;
                int distX = x - this.pStartX;
                int distY = y - this.pStartY;
                if (Math.abs(distX) > Math.abs(distY)) {
                    if (Math.abs(distX) <= this.paintWidth * 10 / 100) break;
                    this.c64.getJoystick(this.c64.getActiveJoystick()).setDirection(this.adjustJoystickDirection(distX < 0 ? 4 : 8));
                    break;
                }
                if (Math.abs(distY) <= this.paintHeight * 10 / 100) break;
                this.c64.getJoystick(this.c64.getActiveJoystick()).setDirection(this.adjustJoystickDirection(distY < 0 ? 1 : 2));
            }
        }
    }

    public void onDeviceRotated() {
        this.calculateScreenSize();
    }

    public void onAccelerometerChange(double x, double y, double z) {
        Joystick joystick = this.c64.getJoystick(this.c64.getActiveJoystick());
        if (x > 200.0) {
            joystick.setDirection(joystick.getDirection() | 4);
        } else if (x < -200.0) {
            joystick.setDirection(joystick.getDirection() | 8);
        } else {
            joystick.setDirection(joystick.getDirection() & 3);
        }
        if (y < -200.0) {
            joystick.setDirection(joystick.getDirection() | 1);
        } else if (y > 200.0) {
            joystick.setDirection(joystick.getDirection() | 2);
        } else {
            joystick.setDirection(joystick.getDirection() & 0xC);
        }
        try {
            Backlight.setLevel(75);
        }
        catch (Throwable t) {
            // empty catch block
        }
    }

    public void update(Object observable, Object event) {
        if (observable instanceof VIC6569) {
            if (event instanceof Color) {
                this.borderColor = (Color)event;
            } else {
                this.paint();
            }
        } else if (event instanceof Throwable && this.showEmulatorExceptions) {
            this.showEmulatorExceptions = false;
            this.display.setCurrent((Displayable)new Alert(LocalizationSupport.getMessage("AnErrorHasOccurred"), LocalizationSupport.getMessage("ErrorWas") + ((Throwable)event).getMessage() + LocalizationSupport.getMessage("NoFurtherMessages"), null, AlertType.WARNING));
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    class VIC6569Factory {
        VIC6569Factory() {
        }

        public VIC6569 create(double scaling, boolean isSmoothScaling) {
            return scaling != 1.0 ? (isSmoothScaling ? new SmoothingScalableVIC6569(C64Canvas.this.c64, scaling) : new ScalableVIC6569(C64Canvas.this.c64, scaling)) : new VIC6569(C64Canvas.this.c64);
        }

        public Class getDesiredType(double scaling, boolean isSmoothScaling) {
            Class clazz = scaling != 1.0 ? (isSmoothScaling ? (class$de$joergjahnke$c64$smalldisplays$SmoothingScalableVIC6569 == null ? (class$de$joergjahnke$c64$smalldisplays$SmoothingScalableVIC6569 = C64Canvas.class$("de.joergjahnke.c64.smalldisplays.SmoothingScalableVIC6569")) : class$de$joergjahnke$c64$smalldisplays$SmoothingScalableVIC6569) : (class$de$joergjahnke$c64$smalldisplays$ScalableVIC6569 == null ? (class$de$joergjahnke$c64$smalldisplays$ScalableVIC6569 = C64Canvas.class$("de.joergjahnke.c64.smalldisplays.ScalableVIC6569")) : class$de$joergjahnke$c64$smalldisplays$ScalableVIC6569)) : (class$de$joergjahnke$c64$core$VIC6569 == null ? (class$de$joergjahnke$c64$core$VIC6569 = C64Canvas.class$("de.joergjahnke.c64.core.VIC6569")) : class$de$joergjahnke$c64$core$VIC6569);
            return clazz;
        }
    }
}

