/*
 * Decompiled with CFR 0.152.
 */
package de.joergjahnke.common.jme;

import de.joergjahnke.common.jme.MenuListener;
import java.util.Hashtable;
import java.util.Vector;
import javax.microedition.lcdui.Command;
import javax.microedition.lcdui.CommandListener;
import javax.microedition.lcdui.Display;
import javax.microedition.lcdui.Displayable;
import javax.microedition.lcdui.Image;
import javax.microedition.lcdui.List;

public class Menu
extends List
implements CommandListener {
    private final Vector items = new Vector();
    private final Hashtable itemIcons = new Hashtable();
    private Display currentDisplay = null;
    private Displayable previous = null;
    private MenuListener listener = null;
    private Command selectCommand;
    private Command backCommand;

    public Menu(String title) {
        super(title, 3);
        this.setCommandListener(this);
        this.setSelectCommandText("Select");
        this.setBackCommandText("Back");
    }

    public void removeAllItems() {
        this.items.removeAllElements();
        this.itemIcons.clear();
    }

    public void addItem(String item, Image icon) {
        this.insertItem(item, icon, this.items.size());
    }

    public void insertItem(String item, Image icon, int pos) {
        this.items.insertElementAt(item, pos);
        if (icon != null) {
            this.itemIcons.put(item, icon);
        }
    }

    public void addMenu(Menu menu, Image icon) {
        this.insertMenu(menu, icon, this.items.size());
    }

    public void insertMenu(Menu menu, Image icon, int pos) {
        this.items.insertElementAt(menu, pos);
        if (icon != null) {
            this.itemIcons.put(menu, icon);
        }
    }

    public void removeItem(int n) {
        this.itemIcons.remove(this.items.elementAt(n));
        this.items.removeElementAt(n);
    }

    public void removeItem(Object item) {
        this.items.removeElement(item);
        this.itemIcons.remove(item);
    }

    public int getMenuPosition(Object item) {
        return this.items.indexOf(item);
    }

    public int getItemCount() {
        return this.items.size();
    }

    public void setMenuListener(MenuListener listener) {
        this.listener = listener;
    }

    public void setSelectCommandText(String text) {
        if (this.selectCommand != null) {
            this.removeCommand(this.selectCommand);
        }
        this.selectCommand = new Command(text, 4, 1);
        this.addCommand(this.selectCommand);
    }

    public void setBackCommandText(String text) {
        if (this.backCommand != null) {
            this.removeCommand(this.backCommand);
        }
        if (text != null && !"".equals(text)) {
            this.backCommand = new Command(text, 2, 99);
            this.addCommand(this.backCommand);
        }
    }

    public void show(Display display) {
        this.deleteAll();
        for (int i = 0; i < this.items.size(); ++i) {
            Object item = this.items.elementAt(i);
            Image icon = (Image)this.itemIcons.get(item);
            String text = item instanceof Menu ? ((Menu)((Object)item)).getTitle() + " ->" : item.toString();
            this.append(text, icon);
        }
        this.setSelectCommand(this.selectCommand);
        this.previous = display.getCurrent();
        display.setCurrent((Displayable)this);
        this.currentDisplay = display;
    }

    private Displayable getPreviousRoot() {
        if (this.previous instanceof Menu && ((Menu)this.previous).previous != this.previous) {
            return ((Menu)this.previous).getPreviousRoot();
        }
        return this.previous;
    }

    public void commandAction(Command c, Displayable d) {
        if (c == this.selectCommand) {
            final Object item = this.items.elementAt(this.getSelectedIndex());
            if (item instanceof Menu) {
                ((Menu)((Object)item)).show(this.currentDisplay);
            } else if (this.listener != null) {
                this.currentDisplay.setCurrent(this.getPreviousRoot());
                this.currentDisplay.callSerially(new Runnable(){

                    public void run() {
                        Menu.this.listener.menuAction(item.toString());
                    }
                });
            }
        } else if (c == this.backCommand) {
            this.currentDisplay.setCurrent(this.previous);
            if (this.listener != null) {
                this.listener.menuClosed(this);
            }
        }
    }
}

