/*
 * Decompiled with CFR 0.152.
 */
package de.joergjahnke.c64.core;

import de.joergjahnke.c64.core.CPU6502;
import de.joergjahnke.common.emulation.RunnableDevice;
import de.joergjahnke.common.util.DefaultLogger;
import de.joergjahnke.common.vmabstraction.ResourceLoader;

public abstract class EmulatedDevice
extends RunnableDevice
implements Runnable {
    private final String name;
    protected final CPU6502 cpu;
    protected final ResourceLoader resourceLoader;
    private DefaultLogger logger = null;
    protected boolean wasPaused = false;

    public EmulatedDevice(String name, ResourceLoader resourceLoader) {
        this.name = name;
        this.resourceLoader = resourceLoader;
        this.cpu = this.createCPU();
    }

    public final String getName() {
        return this.name;
    }

    public final CPU6502 getCPU() {
        return this.cpu;
    }

    public final DefaultLogger getLogger() {
        return this.logger;
    }

    public final void setLogger(DefaultLogger logger) {
        this.logger = logger;
        if (null != this.cpu) {
            this.cpu.setLogger(logger);
        }
    }

    public void stop() {
        if (this.isRunning) {
            this.logger.info(this.name + " stopping");
            super.stop();
        }
    }

    public void pause() {
        if (this.isRunning() && !this.isPaused()) {
            super.pause();
            this.wasPaused = true;
            this.logger.info(this.name + " paused");
        }
    }

    public void resume() {
        if (this.isRunning() && this.isPaused()) {
            super.resume();
            this.logger.info(this.name + " resumed");
        }
    }

    public void reset() {
        this.logger.info(this.name + " resetting");
        this.pause();
        try {
            Thread.sleep(100L);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        this.cpu.reset();
        this.resetIOChips();
        this.resume();
        this.logger.info(this.name + " reset done");
    }

    public void run() {
        this.logger.info("Starting " + this.name);
        super.run();
    }

    protected abstract CPU6502 createCPU();

    protected abstract void resetIOChips();
}

